unit grpfile;
interface
uses objects;

const
     grpOK        = 0;                      {vse v poradku}

     grpCreate    = $3c00;                  {vytvori novy soubor}
     grpOpenRead  = $3d00;                  {jen pro cteni}
     grpOpenWrite = $3d01;                  {jen pro zapis}
     grpOpen      = $3d02;                  {cteni i zapis}

type
     PGrpStream = ^TGrpStream;
     TGrpStream = object (TDOSStream)
     is_grp:boolean;
     numfiles:longint;
     startpos:longint;
     LocalPos:longint;
     LocalSize:longint;
     Constructor Init (FileName: FNameStr; Mode:word);
     Destructor Done;virtual;
     Procedure Seek (Poz: LongInt);Virtual;
     {$IFDEF VER2}
     Procedure Read (Var Buf; Count: longint);Virtual;
     {$ELSE}
     Procedure Read (Var Buf; Count: Sw_Word);Virtual;
     {$ENDIF}
     Function GetSize:longint;virtual;
     Function GetPos:longint;virtual;
     Function ReadStream(var Buf; Count:longint):longint;
     end;


implementation

Function Convert_Up(s:string):string;
var a:byte;
begin
for a:=1 to Length(s) do s[a]:=UpCase(s[a]);
Convert_Up:=s;
end;

function SkipEndSpaces(s:string):string;
var i:byte;
begin
i:=Length(S);
while (S[i] in [' ',#0]) and (i>0) do Dec (i);
s[0]:=char(i);
SkipEndSpaces:=s;
end;  { SkipEndSpaces }


Constructor TGrpStream.Init(FileName: FNameStr; Mode: Word);
const MAGIC = 'KenSilverman';
      VELIKOSTZAHLAVI = 12+4;

var a:byte;
    b,g:longint;
    s:string;
    n:string[12];
begin
is_grp:=false;
a:=Pos('#',Filename);                     {budeme to otevirat jako normalni}
if a=0 then
   begin
   inherited Init(FileName,mode); {soubor nebo jako soubor v archivu?}
   LocalPos:=Position;
   StartPos:=Position;
   LocalSize:=StreamSize;
   end
   else begin
   s:=Copy(FileName,1,a-1);
   inherited Init(s,mode);
   if status<>stOK then Exit;           {nepodarilo se otevrit .GRP archiv}
   inherited Read(n[1],12);
   n[0]:=#12;
   if MAGIC<>n then status:=stOpenError {nejde o Duke3D .GRP format}
      else begin
      g:=0;
      inherited Read(numfiles,4);
      s:=Convert_Up(Copy(FileName,a+1,255));
      for b:=1 to numfiles do
          begin
          n[0]:=#12;
          inherited Read(n[1],12);
          n:=Convert_Up(SkipEndSpaces(n));
          inherited Read(localsize,4);
          if n=s then
             begin
             status:=stOK;
             startpos:=VELIKOSTZAHLAVI+numfiles*16+g;
             localpos:=0;
             inherited Seek(startpos);
             is_grp:=true;
             Exit;
             end;
          inc(g,localsize);
          end;
      status:=stOpenError;             {soubor tohoto jmena v archivu neni}
      end;
   end;
end;


Destructor TGrpStream.Done;
begin
Close;
inherited Done;
end;


Procedure TGrpStream.Seek(poz:longint);
begin
if Poz<0 then Poz:=0;
if Poz>LocalSize then Poz:=LocalSize;
inc(poz,StartPos);
inherited Seek(poz);
LocalPos:=Position-StartPos;
end;



{$IFDEF VER2}
Procedure TGrpStream.Read (Var Buf; Count: longint);
{$ELSE}
Procedure TGrpStream.Read (Var Buf; Count: Sw_Word);
{$ENDIF}
var os:longint;
begin
if is_grp=false then
   begin
   inherited Read(buf,count);
   LocalPos:=position;
   end
   else begin
   os:=StreamSize;
   StreamSize:=LocalSize;
   Position:=LocalPos;
   inherited Read(buf,count);
   StreamSize:=os;
   LocalPos:=position;
   Position:=LocalPos+StartPos;
   end;
end;


Function TGrpStream.GetSize:longint;
begin
GetSize:=LocalSize;
end;


Function TGrpStream.GetPos:longint;
begin
GetPos:=LocalPos;
end;


Function TGrpStream.ReadStream(var Buf; Count:longint):longint;
var l:longint;
begin
l:=GetPos;
Read(buf,count);
if status<>stOK then
   begin
   reset;
   l:=GetSize-l;
   Read(buf,l);
   end else l:=count;
ReadStream:=l;
end;


end.
