; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define OUTPUTDIR  'misc\pack'
#define SOURCEDIR  '..\..\..'
#define TEOVERSION  '1.8.2'
#define WEBSITE "https://sourceforge.net/projects/teoemulator/"

[Setup]
AppName=Teow
AppVersion={#TEOVERSION}
AppPublisherURL={#WEBSITE}
AppSupportURL={#WEBSITE}
AppUpdatesURL={#WEBSITE}
DefaultDirName={pf}\Teow
DefaultGroupName=Teow
SourceDir={#SOURCEDIR}
UsePreviousAppDir=no
OutputDir={#OUTPUTDIR}
OutputBaseFilename=teo-{#TEOVERSION}-setup
Compression=lzma
InternalCompressLevel=ultra
WizardImageFile={#OUTPUTDIR}\inno\teo-big-img.bmp
WizardSmallImageFile={#OUTPUTDIR}\inno\teo-small-img.bmp

[Languages]
Name: en; MessagesFile: compiler:Default.isl
Name: fr; MessagesFile: compiler:Languages\French.isl

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}

[Files]
; ------------------------- Executables -------------------------------
Flags: ignoreversion; Languages: en; DestDir: "{app}\bin"; Source: "{#OUTPUTDIR}\mingw\en\cc90hfe-com.exe"; DestName: "cc90hfe.exe"
Flags: ignoreversion; Languages: fr; DestDir: "{app}\bin"; Source: "{#OUTPUTDIR}\mingw\fr\cc90hfe-com.exe"; DestName: "cc90hfe.exe"
Flags: ignoreversion; Languages: en; DestDir: "{app}"; Source: "{#OUTPUTDIR}\mingw\en\teow.exe"
Flags: ignoreversion; Languages: fr; DestDir: "{app}"; Source: "{#OUTPUTDIR}\mingw\fr\teow.exe"
Flags: ignoreversion; Languages: en; DestDir: "{app}"; Source: "{#OUTPUTDIR}\mingw\en\cc90hfe.exe"
Flags: ignoreversion; Languages: fr; DestDir: "{app}"; Source: "{#OUTPUTDIR}\mingw\fr\cc90hfe.exe"
Flags: ignoreversion; Languages: en; DestDir: "{app}"; Source: "{#OUTPUTDIR}\msdos\en\wav2k7.exe"
Flags: ignoreversion; Languages: fr; DestDir: "{app}"; Source: "{#OUTPUTDIR}\msdos\fr\wav2k7.exe"
Flags: ignoreversion; Languages: en; DestDir: "{app}"; Source: "{#OUTPUTDIR}\msdos\en\sap2.exe"
Flags: ignoreversion; Languages: fr; DestDir: "{app}"; Source: "{#OUTPUTDIR}\msdos\fr\sap2.exe"
Flags: ignoreversion; Languages: en; DestDir: "{app}"; Source: "{#OUTPUTDIR}\msdos\en\sapfs.exe"
Flags: ignoreversion; Languages: fr; DestDir: "{app}"; Source: "{#OUTPUTDIR}\msdos\fr\sapfs.exe"
; ------------------------- Root files -------------------------------
Flags: ignoreversion; DestDir: "{app}"; Source: "readme-en.txt"; DestName: "README.TXT"; Languages: en
Flags: ignoreversion; DestDir: "{app}"; Source: "readme-fr.txt"; DestName: "README.TXT"; Languages: fr
Flags: ignoreversion; DestDir: "{app}"; Source: "change-en.log"; DestName: "CHANGES.TXT"; Languages: en
Flags: ignoreversion; DestDir: "{app}"; Source: "change-fr.log"; DestName: "CHANGES.TXT"; Languages: fr
Flags: ignoreversion; DestDir: "{app}"; Source: "licence-en.txt"; DestName: "LICENCE.TXT"; Languages: en
Flags: ignoreversion; DestDir: "{app}"; Source: "licence-fr.txt"; DestName: "LICENCE.TXT"; Languages: fr
Flags: ignoreversion; DestDir: "{app}"; Source: "allegro.cfg"
Flags: ignoreversion; DestDir: "{app}"; Source: "language.dat"
Flags: ignoreversion; DestDir: "{app}"; Source: "keyboard.dat"
Flags: ignoreversion; DestDir: "{app}"; Source: "alleg40.dll"
Flags: ignoreversion; DestDir: "{app}"; Source: "libpng3.dll"
Flags: ignoreversion; DestDir: "{app}"; Source: "zlib1.dll"
Flags: ignoreversion; DestDir: "{app}"; Source: "cwsdpmi.exe"
Flags: ignoreversion; DestDir: "{app}"; Source: "cc90.sap"
Flags: ignoreversion; DestDir: "{app}"; Source: "cc90.fd"
Flags: ignoreversion; DestDir: "{app}"; Source: "cc90.hfe"
Flags: ignoreversion; DestDir: "{app}"; Source: "empty.hfe"
; ------------------------- ROMs -------------------------------
Flags: ignoreversion; DestDir: "{app}\system\rom"; Source: "system\rom\basic512.rom"
Flags: ignoreversion; DestDir: "{app}\system\rom"; Source: "system\rom\extramon.rom"
Flags: ignoreversion; DestDir: "{app}\system\rom"; Source: "system\rom\basic1.rom"
Flags: ignoreversion; DestDir: "{app}\system\rom"; Source: "system\rom\expl.rom"
Flags: ignoreversion; DestDir: "{app}\system\rom"; Source: "system\rom\monitor1.rom"
Flags: ignoreversion; DestDir: "{app}\system\rom"; Source: "system\rom\monitor2.rom"
; ------------------------- Printer -------------------------------
Flags: ignoreversion; DestDir: "{app}\system\printer\042"; Source: "system\printer\042\picas.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\055"; Source: "system\printer\055\picas.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\582"; Source: "system\printer\582\conds.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\582"; Source: "system\printer\582\italc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\582"; Source: "system\printer\582\picac.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\582"; Source: "system\printer\582\picas.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\582"; Source: "system\printer\582\scrpc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\582"; Source: "system\printer\582\table.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\600"; Source: "system\printer\600\elitc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\600"; Source: "system\printer\600\italc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\600"; Source: "system\printer\600\itals.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\600"; Source: "system\printer\600\picac.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\600"; Source: "system\printer\600\picas.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\600"; Source: "system\printer\600\scrpc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\elitc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\italc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\itals.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\picac.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\picas.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\scrpc.txt"
Flags: ignoreversion; DestDir: "{app}\system\printer\612"; Source: "system\printer\612\table.txt"
; --------------------- Documentation images ----------------------------
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif2.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif3.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif3a.gif"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif3b.gif"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif4.gif"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif5.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif6.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif7.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif8.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif9.gif"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif10.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif11.jpg"
Flags: ignoreversion; DestDir: "{app}\doc\images"; Source: "doc\images\modif12.jpg"
; --------------------- Documentation html ----------------------------
Flags: ignoreversion; DestDir: "{app}\doc"; Source: "doc\doc.css"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90hfe_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90hfe_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90_faq_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90_faq_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90_thomson_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90_thomson_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90232_adapt_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90232_adapt_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90232_modif_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90232_modif_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90hfe_linux_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90hfe_linux_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\cc90hfe_windows_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\cc90hfe_windows_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\libsap_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\libsap_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\licence_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\licence_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\sap2_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\sap2_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\sapfs_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\sapfs_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\teo_changes_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\teo_changes_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\teo_dos_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\teo_dos_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\teo_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\teo_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\teo_linux_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\teo_linux_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\teo_windows_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\teo_windows_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\wav2k7_en.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\wav2k7_fr.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: en; Source: "doc\welcome_en.htm"; DestName: "index.htm"
Flags: ignoreversion; DestDir: "{app}\doc"; Languages: fr; Source: "doc\welcome_fr.htm"; DestName: "index.htm"

[Icons]
IconIndex: 0; Name: "{group}\Teow"; Filename: "{app}\teow.exe"
IconIndex: 0; Name: "{group}\Cc90hfe"; Filename: "{app}\cc90hfe.exe"
IconIndex: 0; Name: "{group}\Teow + reset"; Filename: "{app}\teow.exe"; Parameters: "--reset"
IconIndex: 0; Name: "{group}\Manuel de Teow"; Filename: "{app}\doc\index.htm"; Languages: fr
IconIndex: 0; Name: "{group}\Teow's manual"; Filename: "{app}\doc\index.htm"; Languages: en
IconIndex: 0; Name: "{group}\Licence de Teow"; Filename: "{app}\licence.txt"; Languages: fr
IconIndex: 0; Name: "{group}\Teow's licence"; Filename: "{app}\licence.txt"; Languages: en
IconIndex: 0; Name: "{group}\{cm:ProgramOnTheWeb,Teow}"; Filename: "{#WEBSITE}"
IconIndex: 0; Name: "{group}\{cm:UninstallProgram,Teow}"; Filename: "{uninstallexe}"
IconIndex: 0; Name: "{commondesktop}\Teow {#TEOVERSION}"; Filename: "{app}\teow.exe"; Tasks: desktopicon

[Dirs]
Flags: uninsneveruninstall; Name: "{app}\disk"
Flags: uninsneveruninstall; Name: "{app}\memo"
Flags: uninsneveruninstall; Name: "{app}\cass"

[Run]
Languages: fr; Filename: "{app}\readme.txt"; Description: "Voir le fichier README"; Flags: postinstall shellexec skipifsilent unchecked
Languages: en; Filename: "{app}\readme.txt"; Description: "View the README file"; Flags: postinstall shellexec skipifsilent unchecked
Languages: fr; Filename: "{app}\teow.exe"; Description: "Lancer l'application"; Flags: postinstall nowait skipifsilent
Languages: en; Filename: "{app}\teow.exe"; Description: "Launch application"; Flags: postinstall nowait skipifsilent

[InstallDelete]
; version 1.8.1 and older
Type: files; Name: "{app}\teo.cfg"
Type: files; Name: "{app}\b512_b0.rom"
Type: files; Name: "{app}\b512_b1.rom"
Type: files; Name: "{app}\basic1.rom"
Type: files; Name: "{app}\fichier.rom"
Type: files; Name: "{app}\to8mon1.rom"
Type: files; Name: "{app}\to8mon2.rom"
Type: files; Name: "{app}\licence_fr.txt"
Type: files; Name: "{app}\licence_en.txt"
Type: files; Name: "{app}\readme_fr.txt"
Type: files; Name: "{app}\readme_en.txt"
; version 1.8.1 specific
Type: files; Name: "{app}\fonts\condc600.txt"
Type: files; Name: "{app}\fonts\condc612.txt"
Type: files; Name: "{app}\fonts\elitc600.txt"
Type: files; Name: "{app}\fonts\elitc612.txt"
Type: files; Name: "{app}\fonts\elits600.txt"
Type: files; Name: "{app}\fonts\elits612.txt"
Type: files; Name: "{app}\fonts\elons055.txt"
Type: files; Name: "{app}\fonts\elons600.txt"
Type: files; Name: "{app}\fonts\elons612.txt"
Type: files; Name: "{app}\fonts\picac600.txt"
Type: files; Name: "{app}\fonts\picac612.txt"
Type: files; Name: "{app}\fonts\picas055.txt"
Type: files; Name: "{app}\fonts\picas600.txt"
Type: files; Name: "{app}\fonts\picas612.txt"
Type: files; Name: "{app}\fonts\tiny.txt"
Type: dirifempty; Name: {app}\fonts
Type: files; Name: "{app}\doc\wiki\changeen"
Type: files; Name: "{app}\doc\wiki\changefr"
Type: files; Name: "{app}\doc\wiki\index"
Type: files; Name: "{app}\doc\wiki\indexfr"
Type: files; Name: "{app}\doc\wiki\libsapen"
Type: files; Name: "{app}\doc\wiki\libsapfr"
Type: files; Name: "{app}\doc\wiki\licencen"
Type: files; Name: "{app}\doc\wiki\licencfr"
Type: files; Name: "{app}\doc\wiki\sap2en"
Type: files; Name: "{app}\doc\wiki\sap2fr"
Type: files; Name: "{app}\doc\wiki\sapfsen"
Type: files; Name: "{app}\doc\wiki\sapfsfr"
Type: files; Name: "{app}\doc\wiki\teodosen"
Type: files; Name: "{app}\doc\wiki\teodosfr"
Type: files; Name: "{app}\doc\wiki\teoen"
Type: files; Name: "{app}\doc\wiki\teofr"
Type: files; Name: "{app}\doc\wiki\teolnxen"
Type: files; Name: "{app}\doc\wiki\teolnxfr"
Type: files; Name: "{app}\doc\wiki\teowinen"
Type: files; Name: "{app}\doc\wiki\teowinfr"
Type: files; Name: "{app}\doc\wiki\wav2k7en"
Type: files; Name: "{app}\doc\wiki\wav2k7fr"
Type: files; Name: "{app}\doc\changeen.htm"
Type: files; Name: "{app}\doc\changefr.htm"
Type: files; Name: "{app}\doc\indexfr.htm"
Type: files; Name: "{app}\doc\libsapen.htm"
Type: files; Name: "{app}\doc\libsapfr.htm"
Type: files; Name: "{app}\doc\licencen.htm"
Type: files; Name: "{app}\doc\licencfr.htm"
Type: files; Name: "{app}\doc\sap2en.htm"
Type: files; Name: "{app}\doc\sap2fr.htm"
Type: files; Name: "{app}\doc\sapfsen.htm"
Type: files; Name: "{app}\doc\sapfsfr.htm"
Type: files; Name: "{app}\doc\teodosen.htm"
Type: files; Name: "{app}\doc\teodosfr.htm"
Type: files; Name: "{app}\doc\teoen.htm"
Type: files; Name: "{app}\doc\teofr.htm"
Type: files; Name: "{app}\doc\teolnxen.htm"
Type: files; Name: "{app}\doc\teolnxfr.htm"
Type: files; Name: "{app}\doc\teowinen.htm"
Type: files; Name: "{app}\doc\teowinfr.htm"
Type: files; Name: "{app}\doc\wav2k7en.htm"
Type: files; Name: "{app}\doc\wav2k7fr.htm"
; version 1.8.0 specific
Type: files; Name: "{app}\doc\images\en.gif"
Type: files; Name: "{app}\doc\images\fr.gif"
Type: files; Name: "{app}\doc\images\home.gif"
Type: files; Name: "{app}\doc\images\logo.jpg"
Type: files; Name: "{app}\doc\images\logoblank.jpg"
Type: files; Name: "{app}\doc\images\teo_d1en.gif"
Type: files; Name: "{app}\doc\images\teo_d1fr.gif"
Type: files; Name: "{app}\doc\images\teo_d2en.gif"
Type: files; Name: "{app}\doc\images\teo_d2fr.gif"
Type: files; Name: "{app}\doc\images\teo_d3en.gif"
Type: files; Name: "{app}\doc\images\teo_d3fr.gif"
Type: files; Name: "{app}\doc\images\teo_d4en.gif"
Type: files; Name: "{app}\doc\images\teo_d4fr.gif"
Type: files; Name: "{app}\doc\images\teo_d5en.gif"
Type: files; Name: "{app}\doc\images\teo_d5fr.gif"
Type: files; Name: "{app}\doc\images\teo_d6en.gif"
Type: files; Name: "{app}\doc\images\teo_d6fr.gif"
Type: files; Name: "{app}\doc\images\teo_v1en.gif"
Type: files; Name: "{app}\doc\images\teo_v1fr.gif"
Type: files; Name: "{app}\doc\images\teo_v2en.gif"
Type: files; Name: "{app}\doc\images\teo_v2fr.gif"
Type: files; Name: "{app}\doc\images\teo_v3en.gif"
Type: files; Name: "{app}\doc\images\teo_v3fr.gif"
Type: files; Name: "{app}\doc\images\teo_v4en.gif"
Type: files; Name: "{app}\doc\images\teo_v4fr.gif"
Type: files; Name: "{app}\doc\images\teo_v5en.gif"
Type: files; Name: "{app}\doc\images\teo_v5fr.gif"
Type: files; Name: "{app}\doc\images\teo_v6en.gif"
Type: files; Name: "{app}\doc\images\teo_v6fr.gif"
Type: files; Name: "{app}\doc\images\teo_w0en.gif"
Type: files; Name: "{app}\doc\images\teo_w0fr.gif"
Type: files; Name: "{app}\doc\images\teo_w1en.gif"
Type: files; Name: "{app}\doc\images\teo_w1fr.gif"
Type: files; Name: "{app}\doc\images\teo_w2en.gif"
Type: files; Name: "{app}\doc\images\teo_w2fr.gif"
Type: files; Name: "{app}\doc\images\teo_w3en.gif"
Type: files; Name: "{app}\doc\images\teo_w3fr.gif"
Type: files; Name: "{app}\doc\images\teo_w4en.gif"
Type: files; Name: "{app}\doc\images\teo_w4fr.gif"
Type: files; Name: "{app}\doc\images\teo_w5en.gif"
Type: files; Name: "{app}\doc\images\teo_w5fr.gif"
Type: files; Name: "{app}\doc\images\teo_x1en.png"
Type: files; Name: "{app}\doc\images\teo_x1fr.png"
Type: files; Name: "{app}\doc\images\teo_x2en.png"
Type: files; Name: "{app}\doc\images\teo_x2fr.png"
Type: files; Name: "{app}\doc\images\teo_x3en.png"
Type: files; Name: "{app}\doc\images\teo_x3fr.png"
Type: files; Name: "{app}\doc\images\teo_x4en.png"
Type: files; Name: "{app}\doc\images\teo_x4fr.png"
Type: files; Name: "{app}\doc\images\teo_x5en.png"
Type: files; Name: "{app}\doc\images\teo_x5fr.png"
Type: files; Name: "{app}\doc\teo.htm"
Type: files; Name: "{app}\doc\teo_dos.htm"
Type: files; Name: "{app}\doc\teo_en.htm"
Type: files; Name: "{app}\doc\teo_linux.htm"
Type: files; Name: "{app}\doc\teo_tech.htm"
Type: files; Name: "{app}\doc\teo_tech_en.htm"
Type: files; Name: "{app}\doc\teo_win.htm"
; delete shortcut entries
Type: files; Name: "{group}\*"

