
 id=CORSAIR;
 object[id].max_draw_dist=5000;
 object[id].always_draw_dist=50;

 object[id].nvertices = 122;
 object[id].nfacets   =  49;
 object[id].nctrl_srf =  11;

 object[id].ctrl_surface[0].hinge.x      =  -5.66;
 object[id].ctrl_surface[0].hinge.y      =   0;
 object[id].ctrl_surface[0].hinge.z      =   0.66;
 object[id].ctrl_surface[0].rudder_gain  =   1;
 object[id].ctrl_surface[0].aileron_gain =   0;
 object[id].ctrl_surface[0].elevator_gain=   0;
 object[id].ctrl_surface[0].flap_gain    =   0;
 object[id].ctrl_surface[0].brake_gain   =   0;
 object[id].ctrl_surface[0].gear_gain    =   0;
 object[id].ctrl_surface[0].gear_id      =  -1;
 object[id].ctrl_surface[0].nctrlpoly    =   2;
 object[id].ctrl_surface[0].poly_id[0]   =  49;
 object[id].ctrl_surface[0].poly_id[1]   =  50;

 object[id].ctrl_surface[1].hinge.x      =  -6.63;
 object[id].ctrl_surface[1].hinge.y      =   0;
 object[id].ctrl_surface[1].hinge.z      =   0.42;
 object[id].ctrl_surface[1].rudder_gain  =   0;
 object[id].ctrl_surface[1].aileron_gain =   0;
 object[id].ctrl_surface[1].elevator_gain=   1;
 object[id].ctrl_surface[1].flap_gain    =   0;
 object[id].ctrl_surface[1].brake_gain   =   0;
 object[id].ctrl_surface[1].gear_gain    =   0;
 object[id].ctrl_surface[1].gear_id      =  -1;
 object[id].ctrl_surface[1].nctrlpoly    =   4;
 object[id].ctrl_surface[1].poly_id[0]   =  51;
 object[id].ctrl_surface[1].poly_id[1]   =  52;
 object[id].ctrl_surface[1].poly_id[2]   =  53;
 object[id].ctrl_surface[1].poly_id[3]   =  54;

 object[id].ctrl_surface[2].hinge.x      =  -1.22;
 object[id].ctrl_surface[2].hinge.y      =   0.60;
 object[id].ctrl_surface[2].hinge.z      =  -0.30;
 object[id].ctrl_surface[2].rudder_gain  =   0;
 object[id].ctrl_surface[2].aileron_gain =   0;
 object[id].ctrl_surface[2].elevator_gain=   0;
 object[id].ctrl_surface[2].flap_gain    =   2.08; /* 50 = 24 * 2.08 */
 object[id].ctrl_surface[2].brake_gain   =   0;
 object[id].ctrl_surface[2].gear_gain    =   0;
 object[id].ctrl_surface[2].gear_id      =  -1;
 object[id].ctrl_surface[2].nctrlpoly    =   2;
 object[id].ctrl_surface[2].poly_id[0]   =  55;
 object[id].ctrl_surface[2].poly_id[1]   =  56;

 object[id].ctrl_surface[3].hinge.x      =  -1.22;
 object[id].ctrl_surface[3].hinge.y      =  -0.60;
 object[id].ctrl_surface[3].hinge.z      =  -0.30;
 object[id].ctrl_surface[3].rudder_gain  =   0;
 object[id].ctrl_surface[3].aileron_gain =   0;
 object[id].ctrl_surface[3].elevator_gain=   0;
 object[id].ctrl_surface[3].flap_gain    =   2.08;
 object[id].ctrl_surface[3].brake_gain   =   0;
 object[id].ctrl_surface[3].gear_gain    =   0;
 object[id].ctrl_surface[3].gear_id      =  -1;
 object[id].ctrl_surface[3].nctrlpoly    =   2;
 object[id].ctrl_surface[3].poly_id[0]   =  57;
 object[id].ctrl_surface[3].poly_id[1]   =  58;

 object[id].ctrl_surface[4].hinge.x      = -1.22;
 object[id].ctrl_surface[4].hinge.y      =  1.94;
 object[id].ctrl_surface[4].hinge.z      = -0.85;
 object[id].ctrl_surface[4].rudder_gain  =   0;
 object[id].ctrl_surface[4].aileron_gain =   0;
 object[id].ctrl_surface[4].elevator_gain=   0;
 object[id].ctrl_surface[4].flap_gain    =   2.08;
 object[id].ctrl_surface[4].brake_gain   =   0;
 object[id].ctrl_surface[4].gear_gain    =   0;
 object[id].ctrl_surface[4].gear_id      =  -1;
 object[id].ctrl_surface[4].nctrlpoly    =   2;
 object[id].ctrl_surface[4].poly_id[0]   =  59;
 object[id].ctrl_surface[4].poly_id[1]   =  60;

 object[id].ctrl_surface[5].hinge.x      =  -1.22;
 object[id].ctrl_surface[5].hinge.y      =  -1.94;
 object[id].ctrl_surface[5].hinge.z      =  -0.85;
 object[id].ctrl_surface[5].rudder_gain  =   0;
 object[id].ctrl_surface[5].aileron_gain =   0;
 object[id].ctrl_surface[5].elevator_gain=   0;
 object[id].ctrl_surface[5].flap_gain    =   2.08;
 object[id].ctrl_surface[5].brake_gain   =   0;
 object[id].ctrl_surface[5].gear_gain    =   0;
 object[id].ctrl_surface[5].gear_id      =  -1;
 object[id].ctrl_surface[5].nctrlpoly    =   2;
 object[id].ctrl_surface[5].poly_id[0]   =  61;
 object[id].ctrl_surface[5].poly_id[1]   =  62;

 object[id].ctrl_surface[6].hinge.x      = -1.22;
 object[id].ctrl_surface[6].hinge.y      =  1.94;
 object[id].ctrl_surface[6].hinge.z      = -0.85;
 object[id].ctrl_surface[6].rudder_gain  =   0;
 object[id].ctrl_surface[6].aileron_gain =   1;
 object[id].ctrl_surface[6].elevator_gain=   0;
 object[id].ctrl_surface[6].flap_gain    =   0;
 object[id].ctrl_surface[6].brake_gain   =   0;
 object[id].ctrl_surface[6].gear_gain    =   0;
 object[id].ctrl_surface[6].gear_id      =  -1;
 object[id].ctrl_surface[6].nctrlpoly    =   2;
 object[id].ctrl_surface[6].poly_id[0]   =  63;
 object[id].ctrl_surface[6].poly_id[1]   =  64;

 object[id].ctrl_surface[7].hinge.x      =  -1.22;
 object[id].ctrl_surface[7].hinge.y      =  -1.94;
 object[id].ctrl_surface[7].hinge.z      =  -0.85;
 object[id].ctrl_surface[7].rudder_gain  =   0;
 object[id].ctrl_surface[7].aileron_gain =  -1;
 object[id].ctrl_surface[7].elevator_gain=   0;
 object[id].ctrl_surface[7].flap_gain    =   0;
 object[id].ctrl_surface[7].brake_gain   =   0;
 object[id].ctrl_surface[7].gear_gain    =   0;
 object[id].ctrl_surface[7].gear_id      =  -1;
 object[id].ctrl_surface[7].nctrlpoly    =   2;
 object[id].ctrl_surface[7].poly_id[0]   =  65;
 object[id].ctrl_surface[7].poly_id[1]   =  66;

 object[id].ctrl_surface[8].hinge.x      =   0.81;
 object[id].ctrl_surface[8].hinge.y      =   1.65;
 object[id].ctrl_surface[8].hinge.z      =  -0.75;
 object[id].ctrl_surface[8].rudder_gain  =   0;
 object[id].ctrl_surface[8].aileron_gain =   0;
 object[id].ctrl_surface[8].elevator_gain=   0;
 object[id].ctrl_surface[8].flap_gain    =   0;
 object[id].ctrl_surface[8].brake_gain   =   0;
 object[id].ctrl_surface[8].gear_gain    =  90;
 object[id].ctrl_surface[8].gear_id      =   1;
 object[id].ctrl_surface[8].nctrlpoly    =   4;
 object[id].ctrl_surface[8].poly_id[0]   =  67;
 object[id].ctrl_surface[8].poly_id[1]   =  68;
 object[id].ctrl_surface[8].poly_id[2]   =  69;
 object[id].ctrl_surface[8].poly_id[3]   =  70;

 object[id].ctrl_surface[9].hinge.x      =   0.81;
 object[id].ctrl_surface[9].hinge.y      =  -1.65;
 object[id].ctrl_surface[9].hinge.z      =  -0.75;
 object[id].ctrl_surface[9].rudder_gain  =   0;
 object[id].ctrl_surface[9].aileron_gain =   0;
 object[id].ctrl_surface[9].elevator_gain=   0;
 object[id].ctrl_surface[9].flap_gain    =   0;
 object[id].ctrl_surface[9].brake_gain   =   0;
 object[id].ctrl_surface[9].gear_gain    =  90;
 object[id].ctrl_surface[9].gear_id      =   2;
 object[id].ctrl_surface[9].nctrlpoly    =   4;
 object[id].ctrl_surface[9].poly_id[0]   =  71;
 object[id].ctrl_surface[9].poly_id[1]   =  72;
 object[id].ctrl_surface[9].poly_id[2]   =  73;
 object[id].ctrl_surface[9].poly_id[3]   =  74;

 #define VOFF 0.18 /* Fudge to make tail wheel look right */
 object[id].ctrl_surface[10].hinge.x      =  -5.49;
 object[id].ctrl_surface[10].hinge.y      =   0.00;
 object[id].ctrl_surface[10].hinge.z      =  -0.36+VOFF;
 object[id].ctrl_surface[10].rudder_gain  =   0;
 object[id].ctrl_surface[10].aileron_gain =   0;
 object[id].ctrl_surface[10].elevator_gain=   0;
 object[id].ctrl_surface[10].flap_gain    =   0;
 object[id].ctrl_surface[10].brake_gain   =   0;
 object[id].ctrl_surface[10].gear_gain    =  90;
 object[id].ctrl_surface[10].gear_id      =   0;
 object[id].ctrl_surface[10].nctrlpoly    =   4;
 object[id].ctrl_surface[10].poly_id[0]   =  75;
 object[id].ctrl_surface[10].poly_id[1]   =  76;
 object[id].ctrl_surface[10].poly_id[2]   =  77;
 object[id].ctrl_surface[10].poly_id[3]   =  78;

 nfacets=object[id].nfacets;
 for (j=0; j<object[id].nctrl_srf; j++) nfacets+=object[id].ctrl_surface[j].nctrlpoly;

 if ((object[id].vertex = malloc(object[id].nvertices*sizeof(cartvektor))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }

 if ((object[id].facet = malloc(nfacets*sizeof(polygon_struct))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }
 facetid=object[id].facet;

 /* Engine cowl */
 (object[id].vertex+0)->y=-0.26;
 (object[id].vertex+0)->x=2.35;
 (object[id].vertex+0)->z=0.62;

 (object[id].vertex+1)->y=-0.62;
 (object[id].vertex+1)->x=2.35;
 (object[id].vertex+1)->z=0.26;

 (object[id].vertex+2)->y=-0.62;
 (object[id].vertex+2)->x=2.35;
 (object[id].vertex+2)->z=-0.26;

 (object[id].vertex+3)->y=-0.26;
 (object[id].vertex+3)->x=2.35;
 (object[id].vertex+3)->z=-0.62;

 (object[id].vertex+4)->y=0.26;
 (object[id].vertex+4)->x=2.35;
 (object[id].vertex+4)->z=-0.62;

 (object[id].vertex+5)->y=0.62;
 (object[id].vertex+5)->x=2.35;
 (object[id].vertex+5)->z=-0.26;

 (object[id].vertex+6)->y=0.62;
 (object[id].vertex+6)->x=2.35;
 (object[id].vertex+6)->z=0.26;

 (object[id].vertex+7)->y=0.26;
 (object[id].vertex+7)->x=2.35;
 (object[id].vertex+7)->z=0.62;

 /* Body cross section */
 (object[id].vertex+8)->y=-0.26;
 (object[id].vertex+8)->x=-2.18;
 (object[id].vertex+8)->z=0.62;

 (object[id].vertex+9)->y=-0.62;
 (object[id].vertex+9)->x=-2.18;
 (object[id].vertex+9)->z=0.26;

 (object[id].vertex+10)->y=-0.62;
 (object[id].vertex+10)->x=-2.18;
 (object[id].vertex+10)->z=-0.26;

 (object[id].vertex+11)->y=-0.26;
 (object[id].vertex+11)->x=-2.18;
 (object[id].vertex+11)->z=-0.62;

 (object[id].vertex+12)->y=0.26;
 (object[id].vertex+12)->x=-2.18;
 (object[id].vertex+12)->z=-0.62;

 (object[id].vertex+13)->y=0.62;
 (object[id].vertex+13)->x=-2.18;
 (object[id].vertex+13)->z=-0.26;

 (object[id].vertex+14)->y=0.62;
 (object[id].vertex+14)->x=-2.18;
 (object[id].vertex+14)->z=0.26;

 (object[id].vertex+15)->y=0.26;
 (object[id].vertex+15)->x=-2.18;
 (object[id].vertex+15)->z=0.62;

 /* Engine air intake */
 (object[id].vertex+16)->y=-0.20;
 (object[id].vertex+16)->x=2.54;
 (object[id].vertex+16)->z=0.48;

 (object[id].vertex+17)->y=-0.48;
 (object[id].vertex+17)->x=2.54;
 (object[id].vertex+17)->z=0.20;

 (object[id].vertex+18)->y=-0.48;
 (object[id].vertex+18)->x=2.54;
 (object[id].vertex+18)->z=-0.20;

 (object[id].vertex+19)->y=-0.20;
 (object[id].vertex+19)->x=2.54;
 (object[id].vertex+19)->z=-0.48;

 (object[id].vertex+20)->y=0.20;
 (object[id].vertex+20)->x=2.54;
 (object[id].vertex+20)->z=-0.48;

 (object[id].vertex+21)->y=0.48;
 (object[id].vertex+21)->x=2.54;
 (object[id].vertex+21)->z=-0.20;

 (object[id].vertex+22)->y=0.48;
 (object[id].vertex+22)->x=2.54;
 (object[id].vertex+22)->z=0.20;

 (object[id].vertex+23)->y=0.20;
 (object[id].vertex+23)->x=2.54;
 (object[id].vertex+23)->z=0.48;

 /* rear cockpit */
 (object[id].vertex+24)->y=0.18;
 (object[id].vertex+24)->x=-2.18;
 (object[id].vertex+24)->z=1.07;

 (object[id].vertex+25)->y=-0.18;
 (object[id].vertex+25)->x=-2.18;
 (object[id].vertex+25)->z=1.07;

 /* tip of tail */
 (object[id].vertex+26)->y=0.;
 (object[id].vertex+26)->x=-7.45;
 (object[id].vertex+26)->z=0.12;

 (object[id].vertex+27)->y=0.;
 (object[id].vertex+27)->x=-7.45;
 (object[id].vertex+27)->z=0.36;

 /* canopy */
 (object[id].vertex+28)->y=0.2;
 (object[id].vertex+28)->x=-1.09;
 (object[id].vertex+28)->z=0.76;

 (object[id].vertex+29)->y=-0.2;
 (object[id].vertex+29)->x=-1.09;
 (object[id].vertex+29)->z=0.76;

 (object[id].vertex+30)->y=0.26;
 (object[id].vertex+30)->x=-1.46;
 (object[id].vertex+30)->z=0.62;

 (object[id].vertex+31)->y=-0.26;
 (object[id].vertex+31)->x=-1.46;
 (object[id].vertex+31)->z=0.62;

 (object[id].vertex+32)->y=0.11;
 (object[id].vertex+32)->x=-1.46;
 (object[id].vertex+32)->z=1.16;

 (object[id].vertex+33)->y=-0.11;
 (object[id].vertex+33)->x=-1.46;
 (object[id].vertex+33)->z=1.16;

 /* inner wing */

 (object[id].vertex+34)->x= 0.87;
 (object[id].vertex+34)->y= 0.60;
 (object[id].vertex+34)->z=-0.30;

 (object[id].vertex+35)->x=-1.87;
 (object[id].vertex+35)->y= 0.60;
 (object[id].vertex+35)->z=-0.30;

 (object[id].vertex+36)->x= 0.87;
 (object[id].vertex+36)->y= 1.94;
 (object[id].vertex+36)->z=-0.85;

 (object[id].vertex+37)->x=-1.87;
 (object[id].vertex+37)->y= 1.94;
 (object[id].vertex+37)->z=-0.85;

 (object[id].vertex+38)->x= 0.87;
 (object[id].vertex+38)->y=-0.60;
 (object[id].vertex+38)->z=-0.30;

 (object[id].vertex+39)->x=-1.87;
 (object[id].vertex+39)->y=-0.60;
 (object[id].vertex+39)->z=-0.30;

 (object[id].vertex+40)->x= 0.87;
 (object[id].vertex+40)->y=-1.94;
 (object[id].vertex+40)->z=-0.85;

 (object[id].vertex+41)->x=-1.87;
 (object[id].vertex+41)->y=-1.94;
 (object[id].vertex+41)->z=-0.85;

 /* outer wing */
 (object[id].vertex+42)->x= 0.56;
 (object[id].vertex+42)->y= 5.94;
 (object[id].vertex+42)->z=-0.13;

 (object[id].vertex+43)->x= 0.36;
 (object[id].vertex+43)->y= 6.20;
 (object[id].vertex+43)->z=-0.07;

 (object[id].vertex+44)->x=-0.19;
 (object[id].vertex+44)->y= 6.23;
 (object[id].vertex+44)->z=-0.07;

 (object[id].vertex+45)->x=-1.14;
 (object[id].vertex+45)->y= 5.75;
 (object[id].vertex+45)->z=-0.169;

 /* outer wing */
 (object[id].vertex+46)->x= 0.56;
 (object[id].vertex+46)->y=-5.94;
 (object[id].vertex+46)->z=-0.13;

 (object[id].vertex+47)->x= 0.36;
 (object[id].vertex+47)->y=-6.20;
 (object[id].vertex+47)->z=-0.07;

 (object[id].vertex+48)->x=-0.19;
 (object[id].vertex+48)->y=-6.23;
 (object[id].vertex+48)->z=-0.07;

 (object[id].vertex+49)->x=-1.14;
 (object[id].vertex+49)->y=-5.75;
 (object[id].vertex+49)->z=-0.169;

 /* Tail plane */
 (object[id].vertex+50)->x=-5.82;
 (object[id].vertex+50)->y= 0;
 (object[id].vertex+50)->z=.42;

 (object[id].vertex+51)->x=-7.28;
 (object[id].vertex+51)->y= 0;
 (object[id].vertex+51)->z=.42;

 (object[id].vertex+52)->x=-6.14;
 (object[id].vertex+52)->y= 2.25;
 (object[id].vertex+52)->z= 0.42;

 (object[id].vertex+53)->x=-6.37;
 (object[id].vertex+53)->y= 2.50;
 (object[id].vertex+53)->z= 0.42;

 (object[id].vertex+54)->x=-6.62;
 (object[id].vertex+54)->y= 2.50;
 (object[id].vertex+54)->z= 0.42;

 (object[id].vertex+55)->x=-6.97;
 (object[id].vertex+55)->y= 2.25;
 (object[id].vertex+55)->z= 0.42;

 (object[id].vertex+56)->x=-6.14;
 (object[id].vertex+56)->y=-2.25;
 (object[id].vertex+56)->z= 0.42;

 (object[id].vertex+57)->x=-6.37;
 (object[id].vertex+57)->y=-2.50;
 (object[id].vertex+57)->z= 0.42;

 (object[id].vertex+58)->x=-6.62;
 (object[id].vertex+58)->y=-2.50;
 (object[id].vertex+58)->z= 0.42;

 (object[id].vertex+59)->x=-6.97;
 (object[id].vertex+59)->y=-2.25;
 (object[id].vertex+59)->z= 0.42;

 /* Tail fin */
 (object[id].vertex+60)->x=-4.95;
 (object[id].vertex+60)->y= 0.00;
 (object[id].vertex+60)->z= 0.72;

 (object[id].vertex+61)->x=-6.71;
 (object[id].vertex+61)->y= 0.00;
 (object[id].vertex+61)->z= 0.48;

 (object[id].vertex+62)->x=-5.39;
 (object[id].vertex+62)->y= 0.00;
 (object[id].vertex+62)->z= 2.18;

 (object[id].vertex+63)->x=-5.53;
 (object[id].vertex+63)->y= 0.00;
 (object[id].vertex+63)->z= 2.28;

 (object[id].vertex+64)->x=-5.94;
 (object[id].vertex+64)->y= 0.00;
 (object[id].vertex+64)->z= 2.28;

 (object[id].vertex+65)->x=-6.35;
 (object[id].vertex+65)->y= 0.00;
 (object[id].vertex+65)->z= 2.04;

 (object[id].vertex+66)->x=-5.66;
 (object[id].vertex+66)->y= 0.00;
 (object[id].vertex+66)->z= 0.63;

 (object[id].vertex+67)->x=-5.66;
 (object[id].vertex+67)->y= 0.00;
 (object[id].vertex+67)->z= 1.65;

 (object[id].vertex+68)->x=-5.39;
 (object[id].vertex+68)->y= 0.00;
 (object[id].vertex+68)->z= 1.65;

 /* Elevator */
 (object[id].vertex+69)->x=-6.37;
 (object[id].vertex+69)->y= 2.09;
 (object[id].vertex+69)->z= 0.42;

 (object[id].vertex+70)->x=-6.63;
 (object[id].vertex+70)->y= 2.09;
 (object[id].vertex+70)->z= 0.42;

 (object[id].vertex+71)->x=-6.63;
 (object[id].vertex+71)->y= 0.00;
 (object[id].vertex+71)->z= 0.42;

 (object[id].vertex+72)->x=-6.63;
 (object[id].vertex+72)->y=-2.09;
 (object[id].vertex+72)->z= 0.42;

 (object[id].vertex+73)->x=-6.37;
 (object[id].vertex+73)->y=-2.09;
 (object[id].vertex+73)->z= 0.42;

 /* Flaps */
 (object[id].vertex+74)->x=-1.22;
 (object[id].vertex+74)->y= 1.94;
 (object[id].vertex+74)->z=-0.85;

 (object[id].vertex+75)->x=-1.22;
 (object[id].vertex+75)->y= 0.60;
 (object[id].vertex+75)->z=-0.30;

 (object[id].vertex+76)->x=-1.22;
 (object[id].vertex+76)->y=-0.60;
 (object[id].vertex+76)->z=-0.30;

 (object[id].vertex+77)->x=-1.22;
 (object[id].vertex+77)->y=-1.94;
 (object[id].vertex+77)->z=-0.85;

 /* Flaps / aileron */
 (object[id].vertex+78)->x=-1.09;
 (object[id].vertex+78)->y= 3.45;
 (object[id].vertex+78)->z=-0.58;

 (object[id].vertex+79)->x=-1.65;
 (object[id].vertex+79)->y= 3.45;
 (object[id].vertex+79)->z=-0.58;

 (object[id].vertex+80)->x=-0.92;
 (object[id].vertex+80)->y= 5.71;
 (object[id].vertex+80)->z=-0.176;

 (object[id].vertex+81)->x=-1.09;
 (object[id].vertex+81)->y=-3.45;
 (object[id].vertex+81)->z=-0.58;

 (object[id].vertex+82)->x=-1.65;
 (object[id].vertex+82)->y=-3.45;
 (object[id].vertex+82)->z=-0.58;

 (object[id].vertex+83)->x=-0.92;
 (object[id].vertex+83)->y=-5.71;
 (object[id].vertex+83)->z=-0.176;

 (object[id].vertex+84)->x=-1.31;
 (object[id].vertex+84)->y= 5.37;
 (object[id].vertex+84)->z=-0.237;

 (object[id].vertex+85)->x=-1.31;
 (object[id].vertex+85)->y=-5.37;
 (object[id].vertex+85)->z=-0.237;

 /* Port undercarriage */
 for (i=0; i<8; i++){
  float xc=0.81, yc=1.85, zc=-2.00, radius=0.41;

  (object[id].vertex+86+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+86+i)->y=yc;
  (object[id].vertex+86+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+94)->x= 0.87;
 (object[id].vertex+94)->y= 1.65;
 (object[id].vertex+94)->z=-0.75;

 (object[id].vertex+95)->x= 0.74;
 (object[id].vertex+95)->y= 1.65;
 (object[id].vertex+95)->z=-0.75;

 (object[id].vertex+96)->x= 0.74;
 (object[id].vertex+96)->y= 1.65;
 (object[id].vertex+96)->z=-2.00;

 (object[id].vertex+97)->x= 0.87;
 (object[id].vertex+97)->y= 1.65;
 (object[id].vertex+97)->z=-2.00;

 /* Stb. undercarriage */
 for (i=0; i<8; i++){
  float xc=0.81, yc=-1.85, zc=-2.00, radius=0.41;

  (object[id].vertex+98+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+98+i)->y=yc;
  (object[id].vertex+98+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+106)->x= 0.87;
 (object[id].vertex+106)->y=-1.65;
 (object[id].vertex+106)->z=-0.75;

 (object[id].vertex+107)->x= 0.74;
 (object[id].vertex+107)->y=-1.65;
 (object[id].vertex+107)->z=-0.75;

 (object[id].vertex+108)->x= 0.74;
 (object[id].vertex+108)->y=-1.65;
 (object[id].vertex+108)->z=-2.00;

 (object[id].vertex+109)->x= 0.87;
 (object[id].vertex+109)->y=-1.65;
 (object[id].vertex+109)->z=-2.00;

 /* Tail wheel */

 for (i=0; i<8; i++){
  float xc=-5.71, yc= 0.00, zc=-0.85+VOFF, radius=0.14;

  (object[id].vertex+110+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+110+i)->y=yc;
  (object[id].vertex+110+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+118)->x=-5.44;
 (object[id].vertex+118)->y= 0.00;
 (object[id].vertex+118)->z=-0.36+VOFF;

 (object[id].vertex+119)->x=-5.54;
 (object[id].vertex+119)->y= 0.00;
 (object[id].vertex+119)->z=-0.33+VOFF;

 (object[id].vertex+120)->x=-5.74;
 (object[id].vertex+120)->y= 0.00;
 (object[id].vertex+120)->z=-0.87+VOFF;

 (object[id].vertex+121)->x=-5.68;
 (object[id].vertex+121)->y= 0.00;
 (object[id].vertex+121)->z=-0.87+VOFF;


 /*
 (object[id].vertex+)->x=;
 (object[id].vertex+)->y=;
 (object[id].vertex+)->z=;
 */

 /**********/
 /* Facets */
 /**********/

 /* 0 fore body */
 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=6;
 facetid->edge[1]=7;
 facetid->edge[2]=23;
 facetid->edge[3]=22;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=3;
 facetid->edge[1]=2;
 facetid->edge[2]=10;
 facetid->edge[3]=11;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=4;
 facetid->edge[1]=3;
 facetid->edge[2]=11;
 facetid->edge[3]=12;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=5;
 facetid->edge[1]=4;
 facetid->edge[2]=12;
 facetid->edge[3]=13;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=0;
 facetid->edge[1]=7;
 facetid->edge[2]=28;
 facetid->edge[3]=29;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=1;
 facetid->edge[1]=0;
 facetid->edge[2]=8;
 facetid->edge[3]=9;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=2;
 facetid->edge[1]=1;
 facetid->edge[2]=9;
 facetid->edge[3]=10;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=6;
 facetid->edge[1]=5;
 facetid->edge[2]=13;
 facetid->edge[3]=14;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=7;
 facetid->edge[1]=6;
 facetid->edge[2]=14;
 facetid->edge[3]=15;
 facetid++;

 /* 9 cowl front edge */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=2;
 facetid->edge[1]=3;
 facetid->edge[2]=19;
 facetid->edge[3]=18;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=3;
 facetid->edge[1]=4;
 facetid->edge[2]=20;
 facetid->edge[3]=19;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=4;
 facetid->edge[1]=5;
 facetid->edge[2]=21;
 facetid->edge[3]=20;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=7;
 facetid->edge[1]=0;
 facetid->edge[2]=16;
 facetid->edge[3]=23;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=0;
 facetid->edge[1]=1;
 facetid->edge[2]=17;
 facetid->edge[3]=16;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=1;
 facetid->edge[1]=2;
 facetid->edge[2]=18;
 facetid->edge[3]=17;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=5;
 facetid->edge[1]=6;
 facetid->edge[2]=22;
 facetid->edge[3]=21;
 facetid++;

 /* 16 engine front */
 facetid->color=BLUE;
 facetid->nedges=8;
 facetid->edge[0]=16;
 facetid->edge[1]=17;
 facetid->edge[2]=18;
 facetid->edge[3]=19;
 facetid->edge[4]=20;
 facetid->edge[5]=21;
 facetid->edge[6]=22;
 facetid->edge[7]=23;
 facetid++;

 /* 17 aft body */
 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=25;
 facetid->edge[1]=24;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=8;
 facetid->edge[1]=25;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=9;
 facetid->edge[1]=8;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=10;
 facetid->edge[1]=9;
 facetid->edge[2]=27;
 facetid->edge[3]=26;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=11;
 facetid->edge[1]=10;
 facetid->edge[2]=26;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=12;
 facetid->edge[1]=11;
 facetid->edge[2]=26;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=13;
 facetid->edge[1]=12;
 facetid->edge[2]=26;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=14;
 facetid->edge[1]=13;
 facetid->edge[2]=26;
 facetid->edge[3]=27;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=15;
 facetid->edge[1]=14;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=24;
 facetid->edge[1]=15;
 facetid->edge[2]=27;
 facetid++;

 /* 27 canopy */
 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=29;
 facetid->edge[1]=28;
 facetid->edge[2]=32;
 facetid->edge[3]=33;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=28;
 facetid->edge[1]=30;
 facetid->edge[2]=32;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=31;
 facetid->edge[1]=29;
 facetid->edge[2]=33;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=33;
 facetid->edge[1]=32;
 facetid->edge[2]=24;
 facetid->edge[3]=25;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=32;
 facetid->edge[1]=30;
 facetid->edge[2]=15;
 facetid->edge[3]=24;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=25;
 facetid->edge[1]=8;
 facetid->edge[2]=31;
 facetid->edge[3]=33;
 facetid++;

 /* 33 inner wing */
 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=34;
 facetid->edge[1]=36;
 facetid->edge[2]=74;
 facetid->edge[3]=75;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=34;
 facetid->edge[1]=75;
 facetid->edge[2]=74;
 facetid->edge[3]=36;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=38;
 facetid->edge[1]=76;
 facetid->edge[2]=77;
 facetid->edge[3]=40;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=38;
 facetid->edge[1]=40;
 facetid->edge[2]=77;
 facetid->edge[3]=76;
 facetid++;

 /* 37 outer wing */
 facetid->color=LIGHTBLUE;
 facetid->nedges=7;
 facetid->edge[0]=74;
 facetid->edge[1]=36;
 facetid->edge[2]=42;
 facetid->edge[3]=43;
 facetid->edge[4]=44;
 facetid->edge[5]=45;
 facetid->edge[6]=80;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=7;
 facetid->edge[0]=42;
 facetid->edge[1]=36;
 facetid->edge[2]=74;
 facetid->edge[3]=80;
 facetid->edge[4]=45;
 facetid->edge[5]=44;
 facetid->edge[6]=43;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=7;
 facetid->edge[0]=46;
 facetid->edge[1]=40;
 facetid->edge[2]=77;
 facetid->edge[3]=83;
 facetid->edge[4]=49;
 facetid->edge[5]=48;
 facetid->edge[6]=47;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=7;
 facetid->edge[0]=77;
 facetid->edge[1]=40;
 facetid->edge[2]=46;
 facetid->edge[3]=47;
 facetid->edge[4]=48;
 facetid->edge[5]=49;
 facetid->edge[6]=83;
 facetid++;

 /* 41 tail plane */
 facetid->color=LIGHTBLUE;
 facetid->nedges=6;
 facetid->edge[0]=71;
 facetid->edge[1]=50;
 facetid->edge[2]=52;
 facetid->edge[3]=53;
 facetid->edge[4]=69;
 facetid->edge[5]=70;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=52;
 facetid->edge[1]=50;
 facetid->edge[2]=71;
 facetid->edge[3]=70;
 facetid->edge[4]=69;
 facetid->edge[5]=53;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=6;
 facetid->edge[0]=56;
 facetid->edge[1]=50;
 facetid->edge[2]=71;
 facetid->edge[3]=72;
 facetid->edge[4]=73;
 facetid->edge[5]=57;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=71;
 facetid->edge[1]=50;
 facetid->edge[2]=56;
 facetid->edge[3]=57;
 facetid->edge[4]=73;
 facetid->edge[5]=72;
 facetid++;

 /* 45 Tail fin */
 facetid->color=LIGHTBLUE;
 facetid->nedges=5;
 facetid->edge[0]=60;
 facetid->edge[1]=66;
 facetid->edge[2]=67;
 facetid->edge[3]=68;
 facetid->edge[4]=62;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=5;
 facetid->edge[0]=67;
 facetid->edge[1]=66;
 facetid->edge[2]=60;
 facetid->edge[3]=62;
 facetid->edge[4]=68;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=7;
 facetid->edge[1]=30;
 facetid->edge[2]=28;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=3;
 facetid->edge[0]=29;
 facetid->edge[1]=31;
 facetid->edge[2]=0;
 facetid++;

 /* Control surfaces below */

 /* 49 rudder */
 facetid->color=LIGHTBLUE;
 facetid->nedges=8;
 facetid->edge[0]=66;
 facetid->edge[1]=61;
 facetid->edge[2]=65;
 facetid->edge[3]=64;
 facetid->edge[4]=63;
 facetid->edge[5]=62;
 facetid->edge[6]=68;
 facetid->edge[7]=67;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=8;
 facetid->edge[0]=65;
 facetid->edge[1]=61;
 facetid->edge[2]=66;
 facetid->edge[3]=67;
 facetid->edge[4]=68;
 facetid->edge[5]=62;
 facetid->edge[6]=63;
 facetid->edge[7]=64;
 facetid++;

 /* 51 elevator */
 facetid->color=LIGHTBLUE;
 facetid->nedges=7;
 facetid->edge[0]=51;
 facetid->edge[1]=71;
 facetid->edge[2]=70;
 facetid->edge[3]=69;
 facetid->edge[4]=53;
 facetid->edge[5]=54;
 facetid->edge[6]=55;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=7;
 facetid->edge[0]=70;
 facetid->edge[1]=71;
 facetid->edge[2]=51;
 facetid->edge[3]=55;
 facetid->edge[4]=54;
 facetid->edge[5]=53;
 facetid->edge[6]=69;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=7;
 facetid->edge[0]=72;
 facetid->edge[1]=71;
 facetid->edge[2]=51;
 facetid->edge[3]=59;
 facetid->edge[4]=58;
 facetid->edge[5]=57;
 facetid->edge[6]=73;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=7;
 facetid->edge[0]=51;
 facetid->edge[1]=71;
 facetid->edge[2]=72;
 facetid->edge[3]=73;
 facetid->edge[4]=57;
 facetid->edge[5]=58;
 facetid->edge[6]=59;
 facetid++;

 /* 55 Inboard flaps */

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=75;
 facetid->edge[1]=74;
 facetid->edge[2]=37;
 facetid->edge[3]=35;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=37;
 facetid->edge[1]=74;
 facetid->edge[2]=75;
 facetid->edge[3]=35;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=77;
 facetid->edge[1]=76;
 facetid->edge[2]=39;
 facetid->edge[3]=41;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=76;
 facetid->edge[2]=77;
 facetid->edge[3]=41;
 facetid++;

 /* 59 Outboard flaps */
 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=74;
 facetid->edge[1]=78;
 facetid->edge[2]=79;
 facetid->edge[3]=37;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=79;
 facetid->edge[1]=78;
 facetid->edge[2]=74;
 facetid->edge[3]=37;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=81;
 facetid->edge[1]=77;
 facetid->edge[2]=41;
 facetid->edge[3]=82;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=4;
 facetid->edge[0]=41;
 facetid->edge[1]=77;
 facetid->edge[2]=81;
 facetid->edge[3]=82;
 facetid++;

 /* 63 Ailerons */
 facetid->color=LIGHTBLUE;
 facetid->nedges=5;
 facetid->edge[0]=79;
 facetid->edge[1]=78;
 facetid->edge[2]=80;
 facetid->edge[3]=45;
 facetid->edge[4]=84;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=5;
 facetid->edge[0]=80;
 facetid->edge[1]=78;
 facetid->edge[2]=79;
 facetid->edge[3]=84;
 facetid->edge[4]=45;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=5;
 facetid->edge[0]=83;
 facetid->edge[1]=81;
 facetid->edge[2]=82;
 facetid->edge[3]=85;
 facetid->edge[4]=49;
 facetid++;

 facetid->color=LIGHTBLUE;
 facetid->nedges=5;
 facetid->edge[0]=82;
 facetid->edge[1]=81;
 facetid->edge[2]=83;
 facetid->edge[3]=49;
 facetid->edge[4]=85;
 facetid++;

 /* 67 Port undercarriage */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=86;
 facetid->edge[1]=87;
 facetid->edge[2]=88;
 facetid->edge[3]=89;
 facetid->edge[4]=90;
 facetid->edge[5]=91;
 facetid->edge[6]=92;
 facetid->edge[7]=93;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=93;
 facetid->edge[1]=92;
 facetid->edge[2]=91;
 facetid->edge[3]=90;
 facetid->edge[4]=89;
 facetid->edge[5]=88;
 facetid->edge[6]=87;
 facetid->edge[7]=86;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=94;
 facetid->edge[1]=95;
 facetid->edge[2]=96;
 facetid->edge[3]=97;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=96;
 facetid->edge[1]=95;
 facetid->edge[2]=94;
 facetid->edge[3]=97;
 facetid++;

 /* 71 Port undercarriage */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]= 98;
 facetid->edge[1]= 99;
 facetid->edge[2]=100;
 facetid->edge[3]=101;
 facetid->edge[4]=102;
 facetid->edge[5]=103;
 facetid->edge[6]=104;
 facetid->edge[7]=105;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=100;
 facetid->edge[1]= 99;
 facetid->edge[2]= 98;
 facetid->edge[3]=105;
 facetid->edge[4]=104;
 facetid->edge[5]=103;
 facetid->edge[6]=102;
 facetid->edge[7]=101;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=106;
 facetid->edge[1]=107;
 facetid->edge[2]=108;
 facetid->edge[3]=109;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=108;
 facetid->edge[1]=107;
 facetid->edge[2]=106;
 facetid->edge[3]=109;
 facetid++;

 /* 75 Tail wheel */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=110;
 facetid->edge[1]=111;
 facetid->edge[2]=112;
 facetid->edge[3]=113;
 facetid->edge[4]=114;
 facetid->edge[5]=115;
 facetid->edge[6]=116;
 facetid->edge[7]=117;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=112;
 facetid->edge[1]=111;
 facetid->edge[2]=110;
 facetid->edge[3]=117;
 facetid->edge[4]=116;
 facetid->edge[5]=115;
 facetid->edge[6]=114;
 facetid->edge[7]=113;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=118;
 facetid->edge[1]=119;
 facetid->edge[2]=120;
 facetid->edge[3]=121;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=120;
 facetid->edge[1]=119;
 facetid->edge[2]=118;
 facetid->edge[3]=121;
 facetid++;

 if (object[id].facet+nfacets!=facetid)
 {
   printf("F4U: Incorrect number of facets\n");
   exit(1);
 }

 /*
 facetid->color=;
 facetid->nedges=;
 facetid->edge[0]=;
 facetid->edge[1]=;
 facetid->edge[2]=;
 facetid->edge[3]=;
 facetid++;
 */

 /* Define control surface rotation axis */
 object[id].ctrl_surface[0].axis =
   vminus(*(object[id].vertex+67),*(object[id].vertex+66));
 object[id].ctrl_surface[1].axis =
   vminus(*(object[id].vertex+70),*(object[id].vertex+72));
 object[id].ctrl_surface[2].axis =
   vminus(*(object[id].vertex+75),*(object[id].vertex+74));
 object[id].ctrl_surface[3].axis =
   vminus(*(object[id].vertex+77),*(object[id].vertex+76));
 object[id].ctrl_surface[4].axis =
   vminus(*(object[id].vertex+74),*(object[id].vertex+78));
 object[id].ctrl_surface[5].axis =
   vminus(*(object[id].vertex+81),*(object[id].vertex+77));
 object[id].ctrl_surface[6].axis =
   vminus(*(object[id].vertex+78),*(object[id].vertex+80));
 object[id].ctrl_surface[7].axis =
   vminus(*(object[id].vertex+83),*(object[id].vertex+81));
 object[id].ctrl_surface[8].axis =
   vminus(*(object[id].vertex+70),*(object[id].vertex+72));
 object[id].ctrl_surface[9].axis =
   vminus(*(object[id].vertex+70),*(object[id].vertex+72));
 object[id].ctrl_surface[10].axis =
   vminus(*(object[id].vertex+70),*(object[id].vertex+72));


 for (j=0; j<object[id].nctrl_srf; j++){
  float norm;
  cartvektor tmp, tmp2;

  /* Generate orthonormal-system */
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].axis,
                  object[id].ctrl_surface[j].axis));
  object[id].ctrl_surface[j].front=
                  svmult(1./norm,object[id].ctrl_surface[j].axis);
  /* Rotate 90 deg about z */
  tmp.x = -object[id].ctrl_surface[j].front.y;
  tmp.y =  object[id].ctrl_surface[j].front.x;
  tmp.z =  object[id].ctrl_surface[j].front.z;

  /* Rotate 90 deg about x - then the vector is not parallel with front vector */
  tmp2.x =  tmp.x;
  tmp2.y = -tmp.z;
  tmp2.z =  tmp.y;

  object[id].ctrl_surface[j].left =
   vkryds(object[id].ctrl_surface[j].front,tmp2);
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].left,
                  object[id].ctrl_surface[j].left));
  object[id].ctrl_surface[j].left=
                  svmult(1./norm,object[id].ctrl_surface[j].left);

  object[id].ctrl_surface[j].top =
   vkryds(object[id].ctrl_surface[j].front,object[id].ctrl_surface[j].left);
 }

  object[id].colarr[WHITE].r = 255;
 object[id].colarr[WHITE].g = 255;
 object[id].colarr[WHITE].b = 255;

 object[id].colarr[LIGHTGRAY].r = 192;
 object[id].colarr[LIGHTGRAY].g = 192;
 object[id].colarr[LIGHTGRAY].b = 192;

 object[id].colarr[DARKGRAY].r =  80;
 object[id].colarr[DARKGRAY].g =  80;
 object[id].colarr[DARKGRAY].b =  80;

 object[id].colarr[RED].r = 255;
 object[id].colarr[RED].g =  32;
 object[id].colarr[RED].b =  32;

 object[id].colarr[GREEN].r =  32;
 object[id].colarr[GREEN].g = 255;
 object[id].colarr[GREEN].b =  32;

 object[id].colarr[BLUE].r =  32;
 object[id].colarr[BLUE].g =  32;
 object[id].colarr[BLUE].b = 255;

 object[id].colarr[LIGHTRED].r = 255;
 object[id].colarr[LIGHTRED].g =  96;
 object[id].colarr[LIGHTRED].b =  96;

 object[id].colarr[LIGHTBLUE].r = 96;
 object[id].colarr[LIGHTBLUE].g = 96;
 object[id].colarr[LIGHTBLUE].b = 255;

 object[id].colarr[CYAN].r =  96;
 object[id].colarr[CYAN].g = 192;
 object[id].colarr[CYAN].b = 192;

 object[id].colarr[LIGHTCYAN].r =  64;
 object[id].colarr[LIGHTCYAN].g = 255;
 object[id].colarr[LIGHTCYAN].b = 255;

 object[id].colarr[DARKGREEN].r =  50;
 object[id].colarr[DARKGREEN].g = 100;
 object[id].colarr[DARKGREEN].b =  40;

 nobjects++;
