/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIHSV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgHasSystemValue(const char * const name);

	Seek to the first value of the given name within the section
	within the system INI file.

	If name == NULL, the current name of the value is searched.

ob(ject): cfgHasSystemValue
su(bsystem): inifile/2
sh(ort description): Seek to the first value \para{name} within the system INI file
lo(ng description): Seek to the first value with the specified name within
	the current section of
	the system INI file. If \para{name} == NULL, the current value is
	searched.
re(lated to): 
fi(le): cfgihsv.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIHSV.C 1.3 1999/12/13 02:22:24 ska Exp ska $";
#endif

int cfgHasSystemValue(const char * const name)
{	DBG_ENTER("cfgHasSystemValue", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )
	DBG_RETURN_BI( cfgi_findVal(aS(sysini), name))
}
