/*
 *  aviriff.h   AVI file format
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef AVIRIFF_H
#define AVIRIFF_H

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to count the elements in an array */
#ifndef NUMELMS
    #define NUMELMS( x )    (sizeof( x ) / sizeof( (x)[0] ))
#endif

/* Macro to make chunk identifiers */
#define FCC( x ) \
    ((((DWORD)(x) & 0x000000FF) << 24) | (((DWORD)(x) & 0x0000FF00) << 8) | \
    (((DWORD)(x) & 0x00FF0000) >> 8) | (((DWORD)(x) && 0xFF000000) >> 24))

/* Chunk identifiers */
#define ckidMAINAVIHEADER       FCC( 'avih' )
#define ckidODML                FCC( 'odml' )
#define ckidAVIEXTHEADER        FCC( 'dmlh' )
#define ckidSTREAMLIST          FCC( 'strl' )
#ifndef ckidSTREAMHEADER
    #define ckidSTREAMHEADER    FCC( 'strh' )
#endif
#ifndef ckidSTREAMFORMAT
    #define ckidSTREAMFORMAT    FCC( 'strf' )
#endif
#define ckidAVIOLDINDEX         FCC( 'idx1' )
#define ckidAVISUPERINDEX       FCC( 'indx' )

/* AVI main header flags */
#define AVIF_HASINDEX       0x00000010L
#define AVIF_MUSTUSEINDEX   0x00000020L
#define AVIF_ISINTERLEAVED  0x00000100L
#define AVIF_TRUSTCKTYPE    0x00000800L
#define AVIF_WASCAPTUREFILE 0x00010000L
#define AVIF_COPYRIGHTED    0x00020000L

/* Stream types */
#ifndef streamtypeVIDEO
    #define streamtypeVIDEO FCC( 'vids' )
    #define streamtypeAUDIO FCC( 'auds' )
    #define streamtypeMIDI  FCC( 'mids' )
    #define streamtypeTEXT  FCC( 'txts' )
#endif

/* AVI stream header flags */
#define AVISF_DISABLED          0x00000001L
#define AVISF_VIDEO_PALCHANGES  0x00010000L

/* AVI old index flags */
#ifndef AVIIF_LIST
    #define AVIIF_LIST      0x00000001L
    #define AVIIF_KEYFRAME  0x00000010L
#endif
#define AVIIF_NO_TIME       0x00000100L
#define AVIIF_COMPRESSOR    0x0FFF0000L

/* Time code rate values */
#define TIMECODE_RATE_30DROP    0

/* Time code SMPTE flags */
#define TIMECODE_SMPTE_BINARY_GROUP 0x00000007L
#define TIMECODE_SMPTE_COLOR_FRAME  0x00000008L

/* AVI index types */
#define AVI_INDEX_OF_INDEXES        0x00
#define AVI_INDEX_OF_CHUNKS         0x01
#define AVI_INDEX_OF_TIMED_CHUNKS   0x02
#define AVI_INDEX_OF_SUB_2FIELD     0x03
#define AVI_INDEX_IS_DATA           0x80

/* AVI index subtypes */
#define AVI_INDEX_SUB_DEFAULT   0x00
#define AVI_INDEX_SUB_2FIELD    0x01

/* Standard index size */
#define STDINDEXSIZE    0x4000

/* Macros to manipulate index sizes */
#define NUMINDEX( x )       ((STDINDEXSIZE - 32) / 4 / (x))
#define NUMINDEXFILL( x )   ((STDINDEXSIZE / 4) - NUMINDEX( x ))

/* AVI standard index flags */
#define AVISTDINDEX_DELTAFRAME  0x80000000L
#define AVISTDINDEX_SIZEMASK    0x7FFFFFFFL

/* RIFF chunk */
typedef struct _riffchunk {
    FOURCC  fcc;
    DWORD   cb;
} RIFFCHUNK;
typedef RIFFCHUNK   *LPRIFFCHUNK;

/* RIFF list */
typedef struct _rifflist {
    FOURCC  fcc;
    DWORD   cb;
    FOURCC  fccListType;
} RIFFLIST;
typedef RIFFLIST    *LPRIFFLIST;

/* Macros to manipulate RIFF data */
#define RIFFROUND( x )  ((x) + ((x) & 1))
#define RIFFNEXT( x ) \
    (LPRIFFCHUNK)((LPBYTE)(x) + sizeof( RIFFCHUNK ) + RIFFROUND( ((LPRIFFCHUNK)(x)->cb))

/* AVI main header */
typedef struct _avimainheader {
    FOURCC  fcc;
    DWORD   cb;
    DWORD   dwMicroSecPerFrame;
    DWORD   dwMaxBytesPerSec;
    DWORD   dwPaddingGranularity;
    DWORD   dwFlags;
    DWORD   dwTotalFrames;
    DWORD   dwInitialFrames;
    DWORD   dwStreams;
    DWORD   dwSuggestedBufferSize;
    DWORD   dwWidth;
    DWORD   dwHeight;
    DWORD   dwReserved[4];
} AVIMAINHEADER;

/* AVI extended header */
typedef struct _aviextheader {
    FOURCC  fcc;
    DWORD   cb;
    DWORD   dwGrandFrames;
    DWORD   dwFuture[61];
} AVIEXTHEADER;

/* AVI stream header */
typedef struct _avistreamheader {
    FOURCC  fcc;
    DWORD   cb;
    FOURCC  fccType;
    FOURCC  fccHandler;
    DWORD   dwFlags;
    WORD    wPriority;
    WORD    wLanguage;
    DWORD   dwInitialFrames;
    DWORD   dwScale;
    DWORD   dwRate;
    DWORD   dwStart;
    DWORD   dwLength;
    DWORD   dwSuggestedBufferSize;
    DWORD   dwQuality;
    DWORD   dwSampleSize;
    struct {
        short   left;
        short   top;
        short   right;
        short   bottom;
    } rcFrame;
} AVISTREAMHEADER;

/* AVI old index */
typedef struct _avioldindex {
    FOURCC  fcc;
    DWORD   cb;
    struct _avioldindex_entry {
        DWORD   dwChunkId;
        DWORD   dwFlags;
        DWORD   dwOffset;
        DWORD   dwSize;
    } aIndex[1];
} AVIOLDINDEX;

/* Time code */
typedef union _timecode {
    struct {
        WORD    wFrameRate;
        WORD    wFrameFract;
        LONG    cFrames;
    };
    DWORDLONG   qw;
} TIMECODE;

/* Time code data */
typedef struct _timecodedata {
    TIMECODE    time;
    DWORD       dwSMPTEflags;
    DWORD       dwUser;
} TIMECODEDATA;

/* AVI meta-index */
typedef struct _avimetaindex {
    FOURCC  fcc;
    UINT    cb;
    WORD    wLongsPerEntry;
    BYTE    bIndexSubType;
    BYTE    bIndexType;
    DWORD   nEntriesInUse;
    DWORD   dwChunkId;
    DWORD   dwReserved[3];
    DWORD   adwIndex[1];
} AVIMETAINDEX;

/* AVI super-index */
typedef struct _avisuperindex {
    FOURCC  fcc;
    UINT    cb;
    WORD    wLongsPerEntry;
    BYTE    bIndexSubType;
    BYTE    bIndexType;
    DWORD   nEntriesInUse;
    DWORD   dwChunkId;
    DWORD   dwReserved[3];
    struct _avisuperindex_entry {
        DWORDLONG   qwOffset;
        DWORD       dwSize;
        DWORD       dwDuration;
    } aIndex[NUMINDEX( 4 )];
} AVISUPERINDEX;
#define Valid_SUPERINDEX( x ) \
    (*(DWORD *)(&((x)->wLongsPerEntry)) == (4 | AVI_INDEX_OF_INDEXES << 24)))

/* AVI standard index entry */
typedef struct _avistdindex_entry {
    DWORD   dwOffset;
    DWORD   dwSize;
} AVISTDINDEX_ENTRY;

/* AVI standard index *
typedef struct _avistdindex {
    FOURCC              fcc;
    UINT                cb;
    WORD                wLongsPerEntry;
    BYTE                bIndexSubType;
    BYTE                bIndexType;
    DWORD               nEntriesInUse;
    DWORD               dwChunkId;
    DWORDLONG           qwBaseOffset;
    DWORD               dwReserved_3;
    AVISTDINDEX_ENTRY   aIndex[NUMINDEX( 2 )];
} AVISTDINDEX;

/* AVI timed index entry */
typedef struct _avitimedindex_entry {
    DWORD   dwOffset;
    DWORD   dwSize;
    DWORD   dwDuration;
} AVITIMEDINDEX_ENTRY;

/* AVI timed index */
typedef struct _avitimedindex {
    FOURCC              fcc;
    UINT                cb;
    WORD                wLongsPerEntry;
    BYTE                bIndexSubType;
    BYTE                bIndexType;
    DWORD               nEntriesInUse;
    DWORD               dwChunkId;
    DWORDLONG           qwBaseOffset;
    DWORD               dwReserved_3;
    AVITIMEDINDEX_ENTRY aIndex[NUMINDEX( 3 )];
    DWORD               adwTrailingFill[NUMINDEXFILL( 3 )];
} AVITIMEDINDEX;

/* AVI time code index */
typedef struct _avitimecodeindex {
    FOURCC          fcc;
    UINT            cb;
    WORD            wLongsPerEntry;
    BYTE            bIndexSubType;
    BYTE            bIndexType;
    DWORD           nEntriesInUse;
    DWORD           dwChunkId;
    DWORD           dwReserved[3];
    TIMECODEDATA    aIndex[NUMINDEX( sizeof( TIMECODEDATA ) / sizeof( LONG ) )];
} AVITIMECODEINDEX;

/* AVI time code discontinuity list entry */
typedef struct _avitcdlindex_entry {
    DWORD       dwTick;
    TIMECODE    time;
    DWORD       dwSMPTEflags;
    DWORD       dwUser;
    TCHAR       szReelId[12];
} AVITCDLINDEX_ENTRY;

/* AVI time code discontinuity list index */
typedef struct _avitcdlindex {
    FOURCC              fcc;
    UINT                cb;
    WORD                wLongsPerEntry;
    BYTE                bIndexSubType;
    BYTE                bIndexType;
    DWORD               nEntriesInUse;
    DWORD               dwChunkId;
    DWORD               dwReserved[3];
    AVITCDLINDEX_ENTRY  aIndex[NUMINDEX( 7 )];
    DWORD               adwTrailingFill[NUMINDEXFILL( 7 )];
} AVITCDLINDEX;

/* AVI field index chunk */
typedef struct _avifieldindex_chunk {
    FOURCC      fcc;
    DWORD       cb;
    WORD        wLongsPerEntry;
    BYTE        bIndexSubType;
    BYTE        bIndexType;
    DWORD       nEntriesInUse;
    DWORD       dwChunkId;
    DWORDLONG   qwBaseOffset;
    DWORD       dwReserved3;
    struct _avifieldindex_entry {
        DWORD   dwOffset;
        DWORD   dwSize;
        DWORD   dwOffsetField2;
    } aIndex[1];
} AVIFIELDINDEX;
typedef AVIFIELDINDEX   *PAVIFIELDINDEX;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* AVIRIFF_H */
