/*
 *  sqlext.h    Open Database Connectivity (ODBC) extension functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __SQLEXT
#define __SQLEXT

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <sql.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ODBC constants */
#define SQL_SPEC_MAJOR                  3
#define SQL_SPEC_MINOR                  80
#define SQL_SPEC_STRING                 "03.80"
#define SQL_SQLSTATE_SIZE               5
#define SQL_MAX_SDN_LENGTH              32
#define SQL_MAX_OPTION_STRING_LENGTH    256

/* ODBC primitive data types */
typedef SQLTCHAR    SQLSTATE[SQL_SQLSTATE_SIZE + 1];

/* ODBC return codes */
#if (ODBCVER < 0x0300)
    #define SQL_NO_DATA_FOUND   100L
#else
    #define SQL_NO_DATA_FOUND   SQL_NO_DATA
#endif

/* ODBC handle types */
#if (ODBCVER >= 0x0300)
    #define SQL_HANDLE_SENV 5L
#endif

/* ODBC environment attributes */
#if (ODBCVER >= 0x0300)
    #define SQL_ATTR_ODBC_VERSION       200L
    #define SQL_ATTR_CONNECTION_POOLING 201L
    #define SQL_ATTR_CP_MATCH           202L
#endif

/* ODBC connection pooling values */
#if (ODBCVER >= 0x0300)
    #define SQL_CP_OFF              0L
    #define SQL_CP_ONE_PER_DRIVER   1L
    #define SQL_CP_ONE_PER_HENV     2L
    #define SQL_CP_DEFAULT          SQL_CP_OFF
#endif

/* ODBC connecting pooling match values */
#if (ODBCVER >= 0x0300)
    #define SQL_CP_STRICT_MATCH     0L
    #define SQL_CP_RELAXED_MATCH    1L
    #define SQL_CP_MATCH_DEFAULT    SQL_CP_STRICT_MATCH
#endif

/* ODBC version values */
#if (ODBCVER >= 0x0300)
    #define SQL_OV_ODBC2    2L
    #define SQL_OV_ODBC3    3L
#endif
#if (ODBCVER >= 0x0380)
    #define SQL_OV_ODBC3_80 380L
#endif

/* ODBC connection attributes */
#define SQL_ACCESS_MODE                     101L
#define SQL_AUTOCOMMIT                      102L
#define SQL_LOGIN_TIMEOUT                   103L
#define SQL_OPT_TRACE                       104L
#define SQL_OPT_TRACEFILE                   105L
#define SQL_TRANSLATE_DLL                   106L
#define SQL_TRANSLATE_OPTION                107L
#define SQL_TXN_ISOLATION                   108L
#define SQL_CURRENT_QUALIFIER               109L
#define SQL_ODBC_CURSORS                    110L
#define SQL_QUIET_MODE                      111L
#define SQL_PACKET_SIZE                     112L
#if (ODBCVER >= 0x0300)
    #define SQL_ATTR_ACCESS_MODE            SQL_ACCESS_MODE
    #define SQL_ATTR_AUTOCOMMIT             SQL_AUTOCOMMIT
    #define SQL_ATTR_CONNECTION_TIMEOUT     113L
    #define SQL_ATTR_CURRENT_CATALOG        SQL_CURRENT_QUALIFIER
    #define SQL_ATTR_DISCONNECT_BEHAVIOR    114L
    #define SQL_ATTR_ENLIST_IN_DTC          1207L
    #define SQL_ATTR_ENLIST_IN_XA           1208L
    #define SQL_ATTR_LOGIN_TIMEOUT          SQL_LOGIN_TIMEOUT
    #define SQL_ATTR_ODBC_CURSORS           SQL_ODBC_CURSORS
    #define SQL_ATTR_PACKET_SIZE            SQL_PACKET_SIZE
    #define SQL_ATTR_QUIET_MODE             SQL_QUIET_MODE
    #define SQL_ATTR_TRACE                  SQL_OPT_TRACE
    #define SQL_ATTR_TRACEFILE              SQL_OPT_TRACEFILE
    #define SQL_ATTR_TRANSLATE_LIB          SQL_TRANSLATE_DLL
    #define SQL_ATTR_TRANSLATE_OPTION       SQL_TRANSLATE_OPTION
    #define SQL_ATTR_TXN_ISOLATION          SQL_TXN_ISOLATION
#endif
#define SQL_ATTR_CONNECTION_DEAD            1209L
#if (ODBCVER >= 0x0351)
    #define SQL_ATTR_ANSI_APP               115L
#endif
#if (ODBCVER >= 0x0380)
    #define SQL_ATTR_RESET_CONNECTION       116L
    #define SQL_ATTR_ASYNC_DBC_FUNCTIONS_ENABLE 117L
#endif

/* ODBC connection options */
#if (ODBCVER < 0x0300)
    #define SQL_CONNECT_OPT_DRVR_START  1000L
    #define SQL_CONN_OPT_MAX            SQL_PACKET_SIZE
    #define SQL_CONN_OPT_MIN            SQL_ACCESS_MODE
#endif

/* ODBC access modes */
#define SQL_MODE_READ_WRITE 0L
#define SQL_MODE_READ_ONLY  1L
#define SQL_MODE_DEFAULT    SQL_MODE_READ_WRITE

/* ODBC autocommit options */
#define SQL_AUTOCOMMIT_OFF      0L
#define SQL_AUTOCOMMIT_ON       1L
#define SQL_AUTOCOMMIT_DEFAULT  SQL_AUTOCOMMIT_ON

/* ODBC login timeout special value */
#define SQL_LOGIN_TIMEOUT_DEFAULT   15L

/* ODBC trace values */
#define SQL_OPT_TRACE_OFF           0L
#define SQL_OPT_TRACE_ON            1L
#define SQL_OPT_TRACE_DEFAULT       SQL_OPT_TRACE_OFF
#define SQL_OPT_TRACE_FILE_DEFAULT  "\\SQL.LOG"

/* ODBC cursor options */
#define SQL_CUR_USE_IF_NEEDED   0L
#define SQL_CUR_USE_ODBC        1L
#define SQL_CUR_USE_DRIVER      2L
#define SQL_CUR_DEFAULT         SQL_CUR_USE_DRIVER

/* ODBC disconnect behavior values */
#if (ODBCVER >= 0x0300)
    #define SQL_DB_RETURN_TO_POOL   0L
    #define SQL_DB_DISCONNECT       1L
    #define SQL_DB_DEFAULT          SQL_DB_RETURN_TO_POOL
#endif

/* ODBC enlist in DTC values */
#if (ODBCVER >= 0x0300)
    #define SQL_DTC_DONE    0L
#endif

/* ODBC connection dead values */
#define SQL_CD_TRUE     1L
#define SQL_CD_FALSE    0L

/* ODBC ANSI application values */
#if (ODBCVER >= 0x0351)
    #define SQL_AA_TRUE     1L
    #define SQL_AA_FALSE    0L
#endif

/* ODBC reset connection values */
#if (ODBCVER >= 0x0380)
    #define SQL_RESET_CONNECTION_YES    1L
#endif

/* ODBC asynchronous DBC functions enable values */
#if (ODBCVER >= 0x0380)
    #define SQL_ASYNC_DBC_ENABLE_ON         1L
    #define SQL_ASYNC_DBC_ENABLE_OFF        0L
    #define SQL_ASYNC_DBC_ENABLE_DEFAULT    SQL_ASYNC_DBC_ENABLE_OFF
#endif

/* ODBC statement attributes */
#define SQL_QUERY_TIMEOUT                   0L
#define SQL_MAX_ROWS                        1L
#define SQL_NOSCAN                          2L
#define SQL_MAXLENGTH                       3L
#define SQL_ASYNC_ENABLE                    4L
#define SQL_BIND_TYPE                       5L
#define SQL_CURSOR_TYPE                     6L
#define SQL_CONCURRENCY                     7L
#define SQL_KEYSET_SIZE                     8L
#define SQL_ROWSET_SIZE                     9L
#define SQL_SIMULATE_CURSOR                 10L
#define SQL_RETRIEVE_DATA                   11L
#define SQL_USE_BOOKMARKS                   12L
#define SQL_GET_BOOKMARK                    13L
#define SQL_ROW_NUMBER                      14L
#if (ODBCVER >= 0x0300)
    #define SQL_ATTR_ASYNC_ENABLE           4L
    #define SQL_ATTR_CONCURRENCY            SQL_CONCURRENCY
    #define SQL_ATTR_CURSOR_TYPE            SQL_CURSOR_TYPE
    #define SQL_ATTR_ENABLE_AUTO_IPD        15L
    #define SQL_ATTR_FETCH_BOOKMARK_PTR     16L
    #define SQL_ATTR_KEYSET_SIZE            SQL_KEYSET_SIZE
    #define SQL_ATTR_MAX_LENGTH             SQL_MAX_LENGTH
    #define SQL_ATTR_MAX_ROWS               SQL_MAX_ROWS
    #define SQL_ATTR_NOSCAN                 SQL_NOSCAN
    #define SQL_ATTR_PARAM_BIND_OFFSET_PTR  17L
    #define SQL_ATTR_PARAM_BIND_TYPE        18L
    #define SQL_ATTR_PARAM_OPERATION_PTR    19L
    #define SQL_ATTR_PARAM_STATUS_PTR       20L
    #define SQL_ATTR_PARAMS_PROCESSED_PTR   21L
    #define SQL_ATTR_PARAMSET_SIZE          22L
    #define SQL_ATTR_QUERY_TIMEOUT          SQL_QUERY_TIMEOUT
    #define SQL_ATTR_RETRIEVE_DATA          SQL_RETRIEVE_DATA
    #define SQL_ATTR_ROW_BIND_OFFSET_PTR    23L
    #define SQL_ATTR_ROW_BIND_TYPE          SQL_BIND_TYPE
    #define SQL_ATTR_ROW_NUMBER             SQL_ROW_NUMBER
    #define SQL_ATTR_ROW_OPERATION_PTR      24L
    #define SQL_ATTR_ROW_STATUS_PTR         25L
    #define SQL_ATTR_ROWS_FETCHED_PTR       26L
    #define SQL_ATTR_ROW_ARRAY_SIZE         27L
    #define SQL_ATTR_SIMULATE_CURSOR        SQL_SIMULATE_CURSOR
    #define SQL_ATTR_USE_BOOKMARKS          SQL_USE_BOOKMARKS
#endif

/* ODBC statement options */
#if (ODBCVER < 0x0300)
    #define SQL_STMT_OPT_MAX    SQL_ROW_NUMBER
    #define SQL_STMT_OPT_MIN    SQL_QUERY_TIMEOUT
#endif

/* SQLGetTypeInfo() constants */
#if (ODBCVER >= 0x0300)
    #define SQL_COL_PRED_CHAR   SQL_LIKE_ONLY
    #define SQL_COL_PRED_BASIC  SQL_ALL_EXCEPT_LIKE
#endif

/* ODBC attribute data types */
#if (ODBCVER >= 0x0300)
    #define SQL_IS_POINTER      (-4L)
    #define SQL_IS_UINTEGER     (-5L)
    #define SQL_IS_INTEGER      (-6L)
    #define SQL_IS_USMALLINT    (-7L)
    #define SQL_IS_SMALLINT     (-8L)
#endif

/* ODBC parameter binding types */
#if (ODBCVER >= 0x0300)
    #define SQL_PARAM_BIND_BY_COLUMN    0L
    #define SQL_PARAM_BIND_TYPE_DEFAULT SQL_PARAM_BIND_BY_COLUMN
#endif

/* ODBC query timeout special value */
#define SQL_QUERY_TIMEOUT_DEFAULT   0L

/* ODBC maximum rows special value */
#define SQL_MAX_ROWS_DEFAULT    0L

/* ODBC no scan values */
#define SQL_NOSCAN_OFF      0L
#define SQL_NOSCAN_ON       1L
#define SQL_NOSCAN_DEFAULT  SQL_NOSCAN_OFF

/* ODBC maximum length special value */
#define SQL_MAX_LENGTH_DEFAULT  0L

/* ODBC asynchronous enable values */
#define SQL_ASYNC_ENABLE_OFF        0L
#define SQL_ASYNC_ENABLE_ON         1L
#define SQL_ASYNC_ENABLE_DEFAULT    SQL_ASYNC_ENABLE_OFF

/* ODBC bind types */
#define SQL_BIND_BY_COLUMN      0L
#define SQL_BIND_TYPE_DEFAULT   SQL_BIND_BY_COLUMN

/* ODBC concurrency options */
#define SQL_CONCUR_READ_ONLY    1L
#define SQL_CONCUR_LOCK         2L
#define SQL_CONCUR_ROWVER       3L
#define SQL_CONCUR_VALUES       4L
#define SQL_CONCUR_DEFAULT      SQL_CONCUR_READ_ONLY

/* ODBC cursor types */
#define SQL_CURSOR_FORWARD_ONLY     0L
#define SQL_CURSOR_KEYSET_DRIVEN    1L
#define SQL_CURSOR_DYNAMIC          2L
#define SQL_CURSOR_STATIC           3L
#define SQL_CURSOR_TYPE_DEFAULT     SQL_CURSOR_FORWARD_ONLY

/* ODBC rowset size special value */
#define SQL_ROWSET_SIZE_DEFAULT 1L

/* ODBC keyset size special value */
#define SQL_KEYSET_SIZE_DEFAULT 0L

/* ODBC simulate cursor options */
#define SQL_SC_NON_UNIQUE   0L
#define SQL_SC_TRY_UNIQUE   1L
#define SQL_SC_UNIQUE       2L

/* ODBC retrieve data options */
#define SQL_RD_OFF      0L
#define SQL_RD_ON       1L
#define SQL_RD_DEFAULT  SQL_RD_ON

/* ODBC use bookmarks options */
#define SQL_UB_OFF          0L
#define SQL_UB_ON           1L
#define SQL_UB_DEFAULT      SQL_UB_OFF
#if (ODBCVER >= 0x0300)
    #define SQL_UB_FIXED    SQL_UB_ON
    #define SQL_UB_VARIABLE 2L
#endif

/* ODBC extended descriptor fields */
#if (ODBCVER >= 0x0300)
    #define SQL_DESC_ARRAY_SIZE         20L
    #define SQL_DESC_ARRAY_STATUS_PTR   21L
    #define SQL_DESC_AUTO_UNIQUE_VALUE  SQL_COLUMN_AUTO_INCREMENT
    #define SQL_DESC_BASE_COLUMN_NAME   22L
    #define SQL_DESC_BASE_TABLE_NAME    23L
    #define SQL_DESC_BIND_OFFSET_PTR    24L
    #define SQL_DESC_BIND_TYPE          25L
    #define SQL_DESC_CASE_SENSITIVE     SQL_COLUMN_CASE_SENSITIVE
    #define SQL_DESC_CATALOG_NAME       SQL_COLUMN_QUALIFIER_NAME
    #define SQL_DESC_CONCISE_TYPE       SQL_COLUMN_TYPE
    #define SQL_DESC_DATETIME_INTERVAL_PRECISION    26L
    #define SQL_DESC_DISPLAY_SIZE       SQL_COLUMN_DISPLAY_SIZE
    #define SQL_DESC_FIXED_PREC_SCALE   SQL_COLUMN_MONEY
    #define SQL_DESC_LABEL              SQL_COLUMN_LABEL
    #define SQL_DESC_LITERAL_PREFIX     27L
    #define SQL_DESC_LITERAL_SUFFIX     28L
    #define SQL_DESC_LOCAL_TYPE_NAME    29L
    #define SQL_DESC_MAXIMUM_SCALE      30L
    #define SQL_DESC_MINIMUM_SCALE      31L
    #define SQL_DESC_NUM_PREC_RADIX     32L
    #define SQL_DESC_PARAMETER_TYPE     33L
    #define SQL_DESC_ROWS_PROCESSED_PTR 34L
#endif
#if (ODBCVER >= 0x0350)
    #define SQL_DESC_ROWVER             35L
#endif
#if (ODBCVER >= 0x0300)
    #define SQL_DESC_SCHEMA_NAME        SQL_COLUMN_OWNER_NAME
    #define SQL_DESC_SEARCHABLE         SQL_COLUMN_SEARCHABLE
    #define SQL_DESC_TYPE_NAME          SQL_COLUMN_TYPE_NAME
    #define SQL_DESC_TABLE_NAME         SQL_COLUMN_TABLE_NAME
    #define SQL_DESC_UNSIGNED           SQL_COLUMN_UNSIGNED
    #define SQL_DESC_UPDATABLE          SQL_COLUMN_UPDATABLE
#endif

/* ODBC diagnostic fields */
#if (ODBCVER >= 0x0300)
    #define SQL_DIAG_CURSOR_ROW_COUNT   (-1249L)
    #define SQL_DIAG_ROW_NUMBER         (-1248L)
    #define SQL_DIAG_COLUMN_NUMBER      (-1247L)
#endif

/* ODBC extended data types */
#define SQL_DATE            9L
#if (ODBCVER >= 0x0300)
    #define SQL_INTERVAL    10L
#endif
#define SQL_TIME            10L
#define SQL_TIMESTAMP       11L
#define SQL_LONGVARCHAR     (-1L)
#define SQL_BINARY          (-2L)
#define SQL_VARBINARY       (-3L)
#define SQL_LONGVARBINARY   (-4L)
#define SQL_BIGINT          (-5L)
#define SQL_TINYINT         (-6L)
#define SQL_BIT             (-7L)
#if (ODBCVER >= 0x0350)
    #define SQL_GUID        (-11L)
#endif

/* ODBC interval codes and data types */
#if (ODBCVER >= 0x0300)
    #define SQL_CODE_YEAR               1L
    #define SQL_CODE_MONTH              2L
    #define SQL_CODE_DAY                3L
    #define SQL_CODE_HOUR               4L
    #define SQL_CODE_MINUTE             5L
    #define SQL_CODE_SECOND             6L
    #define SQL_CODE_YEAR_TO_MONTH      7L
    #define SQL_CODE_DAY_TO_HOUR        8L
    #define SQL_CODE_DAY_TO_MINUTE      9L
    #define SQL_CODE_DAY_TO_SECOND      10L
    #define SQL_CODE_HOUR_TO_MINUTE     11L
    #define SQL_CODE_HOUR_TO_SECOND     12L
    #define SQL_CODE_MINUTE_TO_SECOND   13L
    #define SQL_INTERVAL_YEAR           (100L + SQL_CODE_YEAR)
    #define SQL_INTERVAL_MONTH          (100L + SQL_CODE_MONTH)
    #define SQL_INTERVAL_DAY            (100L + SQL_CODE_DAY)
    #define SQL_INTERVAL_HOUR           (100L + SQL_CODE_HOUR)
    #define SQL_INTERVAL_MINUTE         (100L + SQL_CODE_MINUTE)
    #define SQL_INTERVAL_SECOND         (100L + SQL_CODE_SECOND)
    #define SQL_INTERVAL_YEAR_TO_MONTH  (100L + SQL_CODE_YEAR_TO_MONTH)
    #define SQL_INTERVAL_DAY_TO_HOUR    (100L + SQL_CODE_DAY_TO_HOUR)
    #define SQL_INTERVAL_DAY_TO_MINUTE  (100L + SQL_CODE_DAY_TO_MINUTE)
    #define SQL_INTERVAL_DAY_TO_SECOND  (100L + SQL_CODE_DAY_TO_SECOND)
    #define SQL_INTERVAL_HOUR_TO_MINUTE (100L + SQL_CODE_HOUR_TO_MINUTE)
    #define SQL_INTERVAL_HOUR_TO_SECOND (100L + SQL_CODE_HOUR_TO_SECOND)
    #define SQL_INTERVAL_MINUTE_TO_SECOND   (100L + SQL_CODE_MINUTE_TO_SECOND)
#else
    #define SQL_INTERVAL_YEAR           (-80L)
    #define SQL_INTERVAL_MONTH          (-81L)
    #define SQL_INTERVAL_YEAR_TO_MONTH  (-82L)
    #define SQL_INTERVAL_DAY            (-83L)
    #define SQL_INTERVAL_HOUR           (-84L)
    #define SQL_INTERVAL_MINUTE         (-85L)
    #define SQL_INTERVAL_SECOND         (-86L)
    #define SQL_INTERVAL_DAY_TO_HOUR    (-87L)
    #define SQL_INTERVAL_DAY_TO_MINUTE  (-88L)
    #define SQL_INTERVAL_DAY_TO_SECOND  (-89L)
    #define SQL_INTERVAL_HOUR_TO_MINUTE (-90L)
    #define SQL_INTERVAL_HOUR_TO_SECOND (-91L)
    #define SQL_INTERVAL_MINUTE_TO_SECOND   (-92L)
#endif

/* ODBC Unicode data types */
#if (ODBCVER <= 0x0300)
    #define SQL_UNICODE             (-95L)
    #define SQL_UNICODE_VARCHAR     (-96L)
    #define SQL_UNICODE_LONGVARCHAR (-97L)
    #define SQL_UNICODE_CHAR        SQL_UNICODE
#else
    #define SQL_UNICODE             SQL_WCHAR
    #define SQL_UNICODE_VARCHAR     SQL_WVARCHAR
    #define SQL_UNICODE_LONGVARCHAR SQL_WLONGVARCHAR
    #define SQL_UNICODE_CHAR        SQL_WCHAR
#endif

/* ODBC driver data types */
#if (ODBCVER < 0x0300)
    #define SQL_TYPE_DRIVER_START   SQL_INTERVAL_YEAR
    #define SQL_TYPE_DRIVER_END     SQL_UNICODE_LONGVARCHAR
#endif

/* ODBC C data types */
#define SQL_C_CHAR                          SQL_CHAR
#define SQL_C_LONG                          SQL_INTEGER
#define SQL_C_SHORT                         SQL_SMALLINT
#define SQL_C_FLOAT                         SQL_REAL
#define SQL_C_DOUBLE                        SQL_DOUBLE
#if (ODBCVER >= 0x0300)
    #define SQL_C_NUMERIC                   SQL_NUMERIC
#endif
#define SQL_C_DEFAULT                       99L
#define SQL_SIGNED_OFFSET                   (-20L)
#define SQL_UNSIGNED_OFFSET                 (-22L)
#define SQL_C_DATE                          SQL_DATE
#define SQL_C_TIME                          SQL_TIME
#define SQL_C_TIMESTAMP                     SQL_TIMESTAMP
#if (ODBCVER >= 0x0300)
    #define SQL_C_TYPE_DATE                 SQL_TYPE_DATE
    #define SQL_C_TYPE_TIME                 SQL_TYPE_TIME
    #define SQL_C_TYPE_TIMESTAMP            SQL_TYPE_TIMESTAMP
    #define SQL_C_INTERVAL_YEAR             SQL_INTERVAL_YEAR
    #define SQL_C_INTERVAL_MONTH            SQL_INTERVAL_MONTH
    #define SQL_C_INTERVAL_DAY              SQL_INTERVAL_DAY
    #define SQL_C_INTERVAL_HOUR             SQL_INTERVAL_HOUR
    #define SQL_C_INTERVAL_MINUTE           SQL_INTERVAL_MINUTE
    #define SQL_C_INTERVAL_SECOND           SQL_INTERVAL_SECOND
    #define SQL_C_INTERVAL_YEAR_TO_MONTH    SQL_INTERVAL_YEAR_TO_MONTH
    #define SQL_C_INTERVAL_DAY_TO_HOUR      SQL_INTERVAL_DAY_TO_HOUR
    #define SQL_C_INTERVAL_DAY_TO_MINUTE    SQL_INTERVAL_DAY_TO_MINUTE
    #define SQL_C_INTERVAL_DAY_TO_SECOND    SQL_INTERVAL_DAY_TO_SECOND
    #define SQL_C_INTERVAL_HOUR_TO_MINUTE   SQL_INTERVAL_HOUR_TO_MINUTE
    #define SQL_C_INTERVAL_HOUR_TO_SECOND   SQL_INTERVAL_HOUR_TO_SECOND
    #define SQL_C_INTERVAL_MINUTE_TO_SECOND SQL_INTERVAL_MINUTE_TO_SECOND
#endif
#define SQL_C_BINARY                        SQL_BINARY
#define SQL_C_BIT                           SQL_BIT
#if (ODBCVER >= 0x0300)
    #define SQL_C_SBIGINT                   (SQL_BIGINT + SQL_SIGNED_OFFSET)
    #define SQL_C_UBIGINT                   (SQL_BIGINT + SQL_UNSIGNED_OFFSET)
#endif
#define SQL_C_TINYINT                       SQL_TINYINT
#define SQL_C_SLONG                         (SQL_C_LONG + SQL_SIGNED_OFFSET)
#define SQL_C_SSHORT                        (SQL_C_SHORT + SQL_SIGNED_OFFSET)
#define SQL_C_STINYINT                      (SQL_TINYINT + SQL_SIGNED_OFFSET)
#define SQL_C_ULONG                         (SQL_C_LONG + SQL_UNSIGNED_OFFSET)
#define SQL_C_USHORT                        (SQL_C_SHORT + SQL_UNSIGNED_OFFSET)
#define SQL_C_UTINYINT                      (SQL_TINYINT + SQL_UNSIGNED_OFFSET)
#define SQL_C_BOOKMARK                      SQL_C_ULONG
#if (ODBCVER >= 0x0350)
    #define SQL_C_GUID                      SQL_GUID
#endif
#if (ODBCVER >= 0x0300)
    #define SQL_C_VARBOOKMARK               SQL_C_BINARY
#endif

/* ODBC special data type constants */
#define SQL_TYPE_NULL       0L
#if (ODBCVER < 0x0300)
    #define SQL_TYPE_MIN    SQL_BIT
    #define SQL_TYPE_MAX    SQL_VARCHAR
#endif

/* ODBC special driver data type constants */
#if (ODBCVER >= 0x0380)
    #define SQL_DRIVER_C_TYPE_BASE      0x00004000L
    #define SQL_DRIVER_SQL_TYPE_BASE    0x00004000L
    #define SQL_DRIVER_DESC_FIELD_BASE  0x00004000L
    #define SQL_DRIVER_DIAG_FIELD_BASE  0x00004000L
    #define SQL_DRIVER_INFO_TYPE_BASE   0x00004000L
    #define SQL_DRIVER_CONN_ATTR_BASE   0x00004000L
    #define SQL_DRIVER_STMT_ATTR_BASE   0x00004000L
#endif

/* ODBC diagnostic row and column number special values */
#if (ODBCVER >= 0x0300)
    #define SQL_NO_ROW_NUMBER           (-1L)
    #define SQL_NO_COLUMN_NUMBER        (-1L)
    #define SQL_ROW_NUMBER_UNKNOWN      (-2L)
    #define SQL_COLUMN_NUMBER_UNKNOWN   (-3L)
#endif

/* SQLBindParameter() constants */
#define SQL_DEFAULT_PARAM           (-5L)
#define SQL_IGNORE                  (-6L)
#if (ODBCVER >= 0x0300)
    #define SQL_COLUMN_IGNORE       SQL_IGNORE
#endif
#define SQL_LEN_DATA_AT_EXEC_OFFSET (-100L)
#define SQL_LEN_DATA_AT_EXEC( x )   (-(x) + SQL_LEN_DATA_AT_EXEC_OFFSET)

/* ODBC driver attribute binary length */
#define SQL_LEN_BINARY_ATTR_OFFSET  (-100L)
#define SQL_LEN_BINARY_ATTR( x )    (-(x) + SQL_LEN_BINARY_ATTR_OFFSET)

/* Driver Manager constants */
#define SQL_PARAM_TYPE_DEFAULT  SQL_PARAM_INPUT_OUTPUT
#define SQL_SETPARAM_VALUE_MAX  (-1L)

/* ODBC column attributes */
#define SQL_COLUMN_COUNT            0L
#define SQL_COLUMN_NAME             1L
#define SQL_COLUMN_TYPE             2L
#define SQL_COLUMN_LENGTH           3L
#define SQL_COLUMN_PRECISION        4L
#define SQL_COLUMN_SCALE            5L
#define SQL_COLUMN_DISPLAY_SIZE     6L
#define SQL_COLUMN_NULLABLE         7L
#define SQL_COLUMN_UNSIGNED         8L
#define SQL_COLUMN_MONEY            9L
#define SQL_COLUMN_UPDATABLE        10L
#define SQL_COLUMN_AUTO_INCREMENT   11L
#define SQL_COLUMN_CASE_SENSITIVE   12L
#define SQL_COLUMN_SEARCHABLE       13L
#define SQL_COLUMN_TYPE_NAME        14L
#define SQL_COLUMN_TABLE_NAME       15L
#define SQL_COLUMN_OWNER_NAME       16L
#define SQL_COLUMN_QUALIFIER_NAME   17L
#define SQL_COLUMN_LABEL            18L
#define SQL_COLATT_OPT_MAX          SQL_COLUMN_LABEL
#define SQL_COLATT_OPT_MIN          SQL_COLUMN_COUNT
#if (ODBCVER < 0x0300)
    #define SQL_COLUMN_DRIVER_START 1000L
#endif

/* ODBC column updatable values */
#define SQL_ATTR_READONLY           0L
#define SQL_ATTR_WRITE              1L
#define SQL_ATTR_READWRITE_UNKNOWN  2L

/* ODBC column searchable values */
#define SQL_UNSEARCHABLE    0L
#define SQL_LIKE_ONLY       1L
#define SQL_ALL_EXCEPT_LIKE 2L
#define SQL_SEARCHABLE      3L
#define SQL_PRED_SEARCHABLE SQL_SEARCHABLE

/* SQLGetData() special return value */
#define SQL_NO_TOTAL    (-4L)

/* ODBC function identifiers */
#define SQL_API_ALL_FUNCTIONS           0
#define SQL_API_SQLCOLATTRIBUTES        6
#if (ODBCVER >= 0x0300)
    #define SQL_API_SQLBULKOPERATIONS   24
#endif
#define SQL_API_SQLDRIVERCONNECT        41
#define SQL_API_SQLBROWSECONNECT        55
#define SQL_API_SQLCOLUMNPRIVILEGES     56
#define SQL_API_SQLDESCRIBEPARAM        58
#define SQL_API_SQLEXTENDEDFETCH        59
#define SQL_API_SQLFOREIGNKEYS          60
#define SQL_API_SQLMORERESULTS          61
#define SQL_API_SQLNATIVESQL            62
#define SQL_API_SQLNUMPARAMS            63
#define SQL_API_SQLPARAMOPTIONS         64
#define SQL_API_SQLPRIMARYKEYS          65
#define SQL_API_SQLPROCEDURECOLUMNS     66
#define SQL_API_SQLPROCEDURES           67
#define SQL_API_SQLSETPOS               68
#define SQL_API_SQLSETSCROLLOPTIONS     69
#define SQL_API_SQLTABLEPRIVILEGES      70
#define SQL_API_SQLDRIVERS              71
#define SQL_API_SQLBINDPARAMETER        72
#if (ODBCVER >= 0x0300)
    #define SQL_API_SQLALLOCHANDLESTD   73
#endif
#define SQL_API_LOADBYORDINAL           199
#if (ODBCVER >= 0x0300)
    #define SQL_API_ODBC3_ALL_FUNCTIONS 999
    #define SQL_API_ODBC3_ALL_FUNCTIONS_SIZE    250
#endif
#if (ODBCVER < 0x0300)
    #define SQL_EXT_API_START           40
    #define SQL_EXT_API_LAST            SQL_API_BINDPARAMETER
    #define SQL_NUM_FUNCTIONS           23
    #define SQL_NUM_EXTENSIONS          (SQL_EXT_API_LAST - SQL_EXT_API_START + 1)
#endif

/* SQLGetInfo() indices */
#define SQL_INFO_FIRST                          0
#define SQL_ACTIVE_CONNECTIONS                  0
#define SQL_ACTIVE_STATEMENTS                   1
#define SQL_DRIVER_HDBC                         3
#define SQL_DRIVER_HENV                         4
#define SQL_DRIVER_HSTMT                        5
#define SQL_DRIVER_NAME                         6
#define SQL_DRIVER_VER                          7
#define SQL_ODBC_API_CONFORMANCE                9
#define SQL_ODBC_VER                            10
#define SQL_ROW_UPDATES                         11
#define SQL_ODBC_SAG_CLI_CONFORMANCE            12
#define SQL_ODBC_SQL_CONFORMANCE                15
#define SQL_PROCEDURES                          21
#define SQL_CONCAT_NULL_BEHAVIOR                22
#define SQL_CURSOR_ROLLBACK_BEHAVIOR            24
#define SQL_EXPRESSIONS_IN_ORDERBY              27
#define SQL_MAX_OWNER_NAME_LEN                  32
#define SQL_MAX_PROCEDURE_NAME_LEN              33
#define SQL_MAX_QUALIFIER_NAME_LEN              34
#define SQL_MULT_RESULT_SETS                    36
#define SQL_MULTIPLE_ACTIVE_TXN                 37
#define SQL_OUTER_JOINS                         38
#define SQL_OWNER_TERM                          39
#define SQL_PROCEDURE_TERM                      40
#define SQL_QUALIFIER_NAME_SEPARATOR            41
#define SQL_QUALIFIER_TERM                      42
#define SQL_SCROLL_OPTIONS                      44
#define SQL_TABLE_TERM                          45
#define SQL_CONVERT_FUNCTIONS                   48
#define SQL_NUMERIC_FUNCTIONS                   49
#define SQL_STRING_FUNCTIONS                    50
#define SQL_SYSTEM_FUNCTIONS                    51
#define SQL_TIMEDATE_FUNCTIONS                  52
#define SQL_CONVERT_BIGINT                      53
#define SQL_CONVERT_BINARY                      54
#define SQL_CONVERT_BIT                         55
#define SQL_CONVERT_CHAR                        56
#define SQL_CONVERT_DATE                        57
#define SQL_CONVERT_DECIMAL                     58
#define SQL_CONVERT_DOUBLE                      59
#define SQL_CONVERT_FLOAT                       60
#define SQL_CONVERT_INTEGER                     61
#define SQL_CONVERT_LONGVARCHAR                 62
#define SQL_CONVERT_NUMERIC                     63
#define SQL_CONVERT_REAL                        64
#define SQL_CONVERT_SMALLINT                    65
#define SQL_CONVERT_TIME                        66
#define SQL_CONVERT_TIMESTAMP                   67
#define SQL_CONVERT_TINYINT                     68
#define SQL_CONVERT_VARBINARY                   69
#define SQL_CONVERT_VARCHAR                     70
#define SQL_CONVERT_LONGVARBINARY               71
#define SQL_ODBC_SQL_OPT_IEF                    73
#define SQL_CORRELATION_NAME                    74
#define SQL_NON_NULLABLE_COLUMNS                75
#define SQL_DRIVER_HLIB                         76
#define SQL_DRIVER_ODBC_VER                     77
#define SQL_LOCK_TYPES                          78
#define SQL_POS_OPERATIONS                      79
#define SQL_POSITIONED_STATEMENTS               80
#define SQL_BOOKMARK_PERSISTENCE                82
#define SQL_STATIC_SENSITIVITY                  83
#define SQL_FILE_USAGE                          84
#define SQL_COLUMN_ALIAS                        87
#define SQL_GROUP_BY                            88
#define SQL_KEYWORDS                            89
#define SQL_OWNER_USAGE                         91
#define SQL_QUALIFIER_USAGE                     92
#define SQL_QUOTED_IDENTIFIER_CASE              93
#define SQL_SUBQUERIES                          95
#define SQL_UNION                               96
#define SQL_MAX_ROW_SIZE_INCLUDES_LONG          103
#define SQL_MAX_CHAR_LITERAL_LEN                108
#define SQL_TIMEDATE_ADD_INTERVALS              109
#define SQL_TIMEDATE_DIFF_INTERVALS             110
#define SQL_NEED_LONG_DATA_LEN                  111
#define SQL_MAX_BINARY_LITERAL_LEN              112
#define SQL_LIKE_ESCAPE_CLAUSE                  113
#define SQL_QUALIFIER_LOCATION                  114
#if (ODBCVER >= 0x0201) && (ODBCVER < 0x0300)
    #define SQL_OJ_CAPABILITIES                 65003
#endif
#if (ODBCVER < 0x0300)
    #define SQL_INFO_LAST                       SQL_QUALIFIER_LOCATION
    #define SQL_INFO_DRIVER_START               1000
#endif
#if (ODBCVER >= 0x0300)
    #define SQL_ACTIVE_ENVIRONMENTS             116
    #define SQL_ALTER_DOMAIN                    117
    #define SQL_SQL_CONFORMANCE                 118
    #define SQL_DATETIME_LITERALS               119
    #define SQL_ASYNC_MODE                      10021
    #define SQL_BATCH_ROW_COUNT                 120
    #define SQL_BATCH_SUPPORT                   121
    #define SQL_CATALOG_LOCATION                SQL_QUALIFIER_LOCATION
    #define SQL_CATALOG_NAME_SEPARATOR          SQL_QUALIFIER_NAME_SEPARATOR
    #define SQL_CATALOG_TERM                    SQL_QUALIFIER_TERM
    #define SQL_CATALOG_USAGE                   SQL_QUALIFIER_USAGE
    #define SQL_CONVERT_WCHAR                   122
    #define SQL_CONVERT_INTERVAL_DAY_TIME       123
    #define SQL_CONVERT_INTERVAL_YEAR_MONTH     124
    #define SQL_CONVERT_WLONGVARCHAR            125
    #define SQL_CONVERT_WVARCHAR                126
    #define SQL_CREATE_ASSERTION                127
    #define SQL_CREATE_CHARACTER_SET            128
    #define SQL_CREATE_COLLATION                129
    #define SQL_CREATE_DOMAIN                   130
    #define SQL_CREATE_SCHEMA                   131
    #define SQL_CREATE_TABLE                    132
    #define SQL_CREATE_TRANSLATION              133
    #define SQL_CREATE_VIEW                     134
    #define SQL_DRIVER_HDESC                    135
    #define SQL_DROP_ASSERTION                  136
    #define SQL_DROP_CHARACTER_SET              137
    #define SQL_DROP_COLLATION                  138
    #define SQL_DROP_DOMAIN                     139
    #define SQL_DROP_SCHEMA                     140
    #define SQL_DROP_TABLE                      41
    #define SQL_DROP_TRANSLATION                142
    #define SQL_DROP_VIEW                       143
    #define SQL_DYNAMIC_CURSOR_ATTRIBUTES1      144
    #define SQL_DYNAMIC_CURSOR_ATTRIBUTES2      145
    #define SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1 146
    #define SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2 147
    #define SQL_INDEX_KEYWORDS                  148
    #define SQL_INFO_SCHEMA_VIEWS               149
    #define SQL_KEYSET_CURSOR_ATTRIBUTES1       150
    #define SQL_KEYSET_CURSOR_ATTRIBUTES2       151
    #define SQL_MAX_ASYNC_CONCURRENT_STATEMENTS 10022
    #define SQL_ODBC_INTERFACE_CONFORMANCE      152
    #define SQL_PARAM_ARRAY_ROW_COUNTS          153
    #define SQL_PARAM_ARRAY_SELECTS             154
    #define SQL_SCHEMA_TERM                     SQL_OWNER_TERM
    #define SQL_SCHEMA_USAGE                    SQL_OWNER_USAGE
    #define SQL_SQL92_DATETIME_FUNCTIONS        155
    #define SQL_SQL92_FOREIGN_KEY_DELETE_RULE   156
    #define SQL_SQL92_FOREIGN_KEY_UPDATE_RULE   157
    #define SQL_SQL92_GRANT                     158
    #define SQL_SQL92_NUMERIC_VALUE_FUNCTIONS   159
    #define SQL_SQL92_PREDICATES                160
    #define SQL_SQL92_RELATIONAL_JOIN_OPERATORS 161
    #define SQL_SQL92_REVOKE                    162
    #define SQL_SQL92_ROW_VALUE_CONSTRUCTOR     163
    #define SQL_SQL92_STRING_FUNCTIONS          164
    #define SQL_SQL92_VALUE_EXPRESSIONS         165
    #define SQL_STANDARD_CLI_CONFORMANCE        166
    #define SQL_STATIC_CURSOR_ATTRIBUTES1       167
    #define SQL_STATIC_CURSOR_ATTRIBUTES2       168
    #define SQL_AGGREGATE_FUNCTIONS             169
    #define SQL_DDL_INDEX                       170
    #define SQL_DM_VER                          171
    #define SQL_INSERT_STATEMENT                172
    #define SQL_CONVERT_GUID                    173
    #define SQL_UNION_STATEMENT                 SQL_UNION
#endif
#if (ODBCVER >= 0x0380)
    #define SQL_ASYNC_DBC_FUNCTIONS             10023
#endif
#define SQL_DTC_TRANSITION_COST                 1750

/* SQL_ALTER_TABLE flags */
#if (ODBCVER >= 0x0300)
    #define SQL_AT_ADD_COLUMN_SINGLE                0x00000020L
    #define SQL_AT_ADD_COLUMN_DEFAULT               0x00000040L
    #define SQL_AT_ADD_COLUMN_COLLATION             0x00000080L
    #define SQL_AT_SET_COLUMN_DEFAULT               0x00000100L
    #define SQL_AT_DROP_COLUMN_DEFAULT              0x00000200L
    #define SQL_AT_DROP_COLUMN_CASCADE              0x00000400L
    #define SQL_AT_DROP_COLUMN_RESTRICT             0x00000800L
    #define SQL_AT_ADD_TABLE_CONSTRAINT             0x00001000L
    #define SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE    0x00002000L
    #define SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT   0x00004000L
    #define SQL_AT_CONSTRAINT_NAME_DEFINITION       0x00008000L
    #define SQL_AT_CONSTRAINT_INITIALLY_DEFERRED    0x00010000L
    #define SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE   0x00020000L
    #define SQL_AT_CONSTRAINT_DEFERRABLE            0x00040000L
    #define SQL_AT_CONSTRAINT_NON_DEFERRABLE        0x00080000L
#endif

/* ODBC convert return flags */
#define SQL_CVT_CHAR                    0x00000001L
#define SQL_CVT_NUMERIC                 0x00000002L
#define SQL_CVT_DECIMAL                 0x00000004L
#define SQL_CVT_INTEGER                 0x00000008L
#define SQL_CVT_SMALLINT                0x00000010L
#define SQL_CVT_FLOAT                   0x00000020L
#define SQL_CVT_REAL                    0x00000040L
#define SQL_CVT_DOUBLE                  0x00000080L
#define SQL_CVT_VARCHAR                 0x00000100L
#define SQL_CVT_LONGVARCHAR             0x00000200L
#define SQL_CVT_BINARY                  0x00000400L
#define SQL_CVT_VARBINARY               0x00000800L
#define SQL_CVT_BIT                     0x00001000L
#define SQL_CVT_TINYINT                 0x00002000L
#define SQL_CVT_BIGINT                  0x00004000L
#define SQL_CVT_DATE                    0x00008000L
#define SQL_CVT_TIME                    0x00010000L
#define SQL_CVT_TIMESTAMP               0x00020000L
#define SQL_CVT_LONGVARBINARY           0x00040000L
#if (ODBCVER >= 0x0300)
    #define SQL_CVT_INTERVAL_YEAR_MONTH 0x00080000L
    #define SQL_CVT_INTERVAL_DAY_TIME   0x00100000L
    #define SQL_CVT_WCHAR               0x00200000L
    #define SQL_CVT_WLONGVARCHAR        0x00400000L
    #define SQL_CVT_WVARCHAR            0x00800000L
    #define SQL_CVT_GUID                0x01000000L
#endif

/* ODBC convert functions */
#define SQL_FN_CVT_CONVERT  0x00000001L
#if (ODBCVER >= 0x0300)
    #define SQL_FN_CVT_CAST 0x00000002L
#endif

/* ODBC string functions */
#define SQL_FN_STR_CONCAT               0x00000001L
#define SQL_FN_STR_INSERT               0x00000002L
#define SQL_FN_STR_LEFT                 0x00000004L
#define SQL_FN_STR_LTRIM                0x00000008L
#define SQL_FN_STR_LENGTH               0x00000010L
#define SQL_FN_STR_LOCATE               0x00000020L
#define SQL_FN_STR_LCASE                0x00000040L
#define SQL_FN_STR_REPEAT               0x00000080L
#define SQL_FN_STR_REPLACE              0x00000100L
#define SQL_FN_STR_RIGHT                0x00000200L
#define SQL_FN_STR_RTRIM                0x00000400L
#define SQL_FN_STR_SUBSTRING            0x00000800L
#define SQL_FN_STR_UCASE                0x00001000L
#define SQL_FN_STR_ASCII                0x00002000L
#define SQL_FN_STR_CHAR                 0x00004000L
#define SQL_FN_STR_DIFFERENCE           0x00008000L
#define SQL_FN_STR_LOCATE_2             0x00010000L
#define SQL_FN_STR_SOUNDEX              0x00020000L
#define SQL_FN_STR_SPACE                0x00040000L
#if (ODBCVER >= 0x0300)
    #define SQL_FN_STR_BIT_LENGTH       0x00080000L
    #define SQL_FN_STR_CHAR_LENGTH      0x00100000L
    #define SQL_FN_STR_CHARACTER_LENGTH 0x00200000L
    #define SQL_FN_STR_OCTET_LENGTH     0x00400000L
    #define SQL_FN_STR_POSITION         0x00800000L
#endif

/* ODBC SQL92 string functions */
#if (ODBCVER >= 0x0300)
    #define SQL_SSF_CONVERT         0x00000001L
    #define SQL_SSF_LOWER           0x00000002L
    #define SQL_SSF_UPPER           0x00000004L
    #define SQL_SSF_SUBSTRING       0x00000008L
    #define SQL_SSF_TRANSLATE       0x00000010L
    #define SQL_SSF_TRIM_BOTH       0x00000020L
    #define SQL_SSF_TRIM_LEADING    0x00000040L
    #define SQL_SSF_TRIM_TRAILING   0x00000080L
#endif

/* ODBC numeric functions */
#define SQL_FN_NUM_ABS      0x00000001L
#define SQL_FN_NUM_ACOS     0x00000002L
#define SQL_FN_NUM_ASIN     0x00000004L
#define SQL_FN_NUM_ATAN     0x00000008L
#define SQL_FN_NUM_ATAN2    0x00000010L
#define SQL_FN_NUM_CEILING  0x00000020L
#define SQL_FN_NUM_COS      0x00000040L
#define SQL_FN_NUM_COT      0x00000080L
#define SQL_FN_NUM_EXP      0x00000100L
#define SQL_FN_NUM_FLOOR    0x00000200L
#define SQL_FN_NUM_LOG      0x00000400L
#define SQL_FN_NUM_MOD      0x00000800L
#define SQL_FN_NUM_SIGN     0x00001000L
#define SQL_FN_NUM_SIN      0x00002000L
#define SQL_FN_NUM_SQRT     0x00004000L
#define SQL_FN_NUM_TAN      0x00008000L
#define SQL_FN_NUM_PI       0x00010000L
#define SQL_FN_NUM_RAND     0x00020000L
#define SQL_FN_NUM_DEGREES  0x00040000L
#define SQL_FN_NUM_LOG10    0x00080000L
#define SQL_FN_NUM_POWER    0x00100000L
#define SQL_FN_NUM_RADIANS  0x00200000L
#define SQL_FN_NUM_ROUND    0x00400000L
#define SQL_FN_NUM_TRUNCATE 0x00800000L

/* ODBC SQL92 numeric functions */
#if (ODBCVER >= 0x0300)
    #define SQL_SNVF_BIT_LENGTH         0x00000001L
    #define SQL_SNVF_CHAR_LENGTH        0x00000002L
    #define SQL_SNVF_CHARACTER_LENGTH   0x00000004L
    #define SQL_SNVF_EXTRACT            0x00000008L
    #define SQL_SNVF_OCTET_LENGTH       0x00000010L
    #define SQL_SNVF_POSITION           0x00000020L
#endif

/* ODBC time/date functions */
#define SQL_FN_TD_NOW                   0x00000001L
#define SQL_FN_TD_CURDATE               0x00000002L
#define SQL_FN_TD_DAYOFMONTH            0x00000004L
#define SQL_FN_TD_DAYOFWEEK             0x00000008L
#define SQL_FN_TD_DAYOFYEAR             0x00000010L
#define SQL_FN_TD_MONTH                 0x00000020L
#define SQL_FN_TD_QUARTER               0x00000040L
#define SQL_FN_TD_WEEK                  0x00000080L
#define SQL_FN_TD_YEAR                  0x00000100L
#define SQL_FN_TD_CURTIME               0x00000200L
#define SQL_FN_TD_HOUR                  0x00000400L
#define SQL_FN_TD_MINUTE                0x00000800L
#define SQL_FN_TD_SECOND                0x00001000L
#define SQL_FN_TD_TIMESTAMPADD          0x00002000L
#define SQL_FN_TD_TIMESTAMPDIFF         0x00004000L
#define SQL_FN_TD_DAYNAME               0x00008000L
#define SQL_FN_TD_MONTHNAME             0x00010000L
#if (ODBCVER >= 0x0300)
    #define SQL_FN_TD_CURRENT_DATE      0x00020000L
    #define SQL_FN_TD_CURRENT_TIME      0x00040000L
    #define SQL_FN_TD_CURRENT_TIMESTAMP 0x00080000L
    #define SQL_FN_TD_EXTRACT           0x00100000L
#endif

/* ODBC SQL92 date/time functions */
#if (ODBCVER >= 0x0300)
    #define SQL_SDF_CURRENT_DATE        0x00000001L
    #define SQL_SDF_CURRENT_TIME        0x00000002L
    #define SQL_SDF_CURRENT_TIMESTAMP   0x00000004L
#endif

/* ODBC system functions */
#define SQL_FN_SYS_USERNAME 0x00000001L
#define SQL_FN_SYS_DBNAME   0x00000002L
#define SQL_FN_SYS_IFNULL   0x00000004L

/* ODBC time/date interval functions */
#define SQL_FN_TSI_FRAC_SECOND  0x00000001L
#define SQL_FN_TSI_SECOND       0x00000002L
#define SQL_FN_TSI_MINUTE       0x00000004L
#define SQL_FN_TSI_HOUR         0x00000008L
#define SQL_FN_TSI_DAY          0x00000010L
#define SQL_FN_TSI_WEEK         0x00000020L
#define SQL_FN_TSI_MONTH        0x00000040L
#define SQL_FN_TSI_QUARTER      0x00000080L
#define SQL_FN_TSI_YEAR         0x00000100L

/* ODBC cursor attributes */
#if (ODBCVER >= 0x0300)
    #define SQL_CA1_NEXT                    0x00000001L
    #define SQL_CA1_ABSOLUTE                0x00000002L
    #define SQL_CA1_RELATIVE                0x00000004L
    #define SQL_CA1_BOOKMARK                0x00000008L
    #define SQL_CA1_LOCK_NO_CHANGE          0x00000040L
    #define SQL_CA1_EXCLUSIVE               0x00000080L
    #define SQL_CA1_UNLOCK                  0x00000100L
    #define SQL_CA1_POS_POSITION            0x00000200L
    #define SQL_CA1_POS_UPDATE              0x00000400L
    #define SQL_CA1_POS_DELETE              0x00000800L
    #define SQL_CA1_POS_REFRESH             0x00001000L
    #define SQL_CA1_POSITIONED_UPDATE       0x00002000L
    #define SQL_CA1_POSITIONED_DELETE       0x00004000L
    #define SQL_CA1_SELECT_FOR_UPDATE       0x00008000L
    #define SQL_CA1_BULK_ADD                0x00010000L
    #define SQL_CA1_BULK_UPDATE_BY_BOOKMARK 0x00020000L
    #define SQL_CA1_BULK_DELETE_BY_BOOKMARK 0x00040000L
    #define SQL_CA1_BULK_FETCH_BY_BOOKMARK  0x00080000L
    #define SQL_CA2_READ_ONLY_CONCURRENCY   0x00000001L
    #define SQL_CA2_LOCK_CONCURRENCY        0x00000002L
    #define SQL_CA2_OPT_ROWVER_CONCURRENCY  0x00000004L
    #define SQL_CA2_OPT_VALUES_CONCURRENCY  0x00000008L
    #define SQL_CA2_SENSITIVITY_ADDITIONS   0x00000010L
    #define SQL_CA2_SENSITIVITY_DELETIONS   0x00000020L
    #define SQL_CA2_SENSITIVITY_UPDATES     0x00000040L
    #define SQL_CA2_MAX_ROWS_SELECT         0x00000080L
    #define SQL_CA2_MAX_ROWS_INSERT         0x00000100L
    #define SQL_CA2_MAX_ROWS_DELETE         0x00000200L
    #define SQL_CA2_MAX_ROWS_UPDATE         0x00000400L
    #define SQL_CA2_MAX_ROWS_CATALOG        0x00000800L
    #define SQL_CA2_MAX_ROWS_AFFECTS_ALL \
        (SQL_CA2_MAX_ROWS_SELECT | SQL_CA2_MAX_ROWS_INSERT | SQL_CA2_MAX_ROWS_DELETE | \
        SQL_CA2_MAX_ROWS_UPDATE | SQL_CA2_MAX_ROWS_CATALOG)
    #define SQL_CA2_CRC_EXACT               0x00001000L
    #define SQL_CA2_CRC_APPROXIMATE         0x00002000L
    #define SQL_CA2_SIMULATE_NON_UNIQUE     0x00004000L
    #define SQL_CA2_SIMULATE_TRY_UNIQUE     0x00008000L
    #define SQL_CA2_SIMULATE_UNIQUE         0x00010000L
#endif

/* ODBC API conformance values */
#define SQL_OAC_NONE    0x0000
#define SQL_OAC_LEVEL1  0x0001
#define SQL_OAC_LEVEL2  0x0002

/* ODBC CLI conformance values */
#define SQL_OSCC_NOT_COMPLIANT  0x0000
#define SQL_OSCC_COMPLIANT      0x0001

/* ODBC SQL conformance values */
#define SQL_OSC_MINIMUM     0x0000
#define SQL_OSC_CORE        0x0001
#define SQL_OSC_EXTENDED    0x0002

/* ODBC concatenation behavior values */
#define SQL_CB_NULL     0x0000
#define SQL_CB_NON_NULL 0x0001

/* ODBC scroll option flags */
#define SQL_SO_FORWARD_ONLY     0x00000001L
#define SQL_SO_KEYSET_DRIVEN    0x00000002L
#define SQL_SO_DYNAMIC          0x00000004L
#define SQL_SO_MIXED            0x00000008L
#define SQL_SO_STATIC           0x00000010L

/* ODBC fetch directions */
#define SQL_FD_FETCH_BOOKMARK   0x00000040L

/* ODBC correlation name values */
#define SQL_CN_NONE         0x0000
#define SQL_CN_DIFFERENT    0x0001
#define SQL_CN_ANY          0x0002

/* ODBC non-nullable columns values */
#define SQL_NNC_NULL        0x0000
#define SQL_NNC_NON_NULL    0x0001

/* ODBC null collation values */
#define SQL_NC_START    0x0002
#define SQL_NC_END      0x0004

/* ODBC file usage values */
#define SQL_FILE_NOT_SUPPORTED  0x0000
#define SQL_FILE_TABLE          0x0001
#define SQL_FILE_QUALIFIER      0x0002
#define SQL_FILE_CATALOG        SQL_FILE_QUALIFIER

/* ODBC get data values */
#define SQL_GD_BLOCK                0x00000004L
#define SQL_GD_BOUND                0x00000008L
#if (ODBCVER >= 0x0380)
    #define SQL_GD_OUTPUT_PARAMS    0x00000010L
#endif

/* ODBC positioned statements flags */
#define SQL_PS_POSITIONED_DELETE    0x00000001L
#define SQL_PS_POSITIONED_UPDATE    0x00000002L
#define SQL_PS_SELECT_FOR_UPDATE    0x00000004L

/* ODBC group by values */
#define SQL_GB_NOT_SUPPORTED            0x0000
#define SQL_GB_GROUP_BY_EQUALS_SELECT   0x0001
#define SQL_GB_GROUP_BY_CONTAINS_SELECT 0x0002
#define SQL_GB_NO_RELATION              0x0003
#if (ODBCVER >= 0x0300)
    #define SQL_GB_COLLATE              0x0004
#endif

/* ODBC owner usage flags */
#define SQL_OU_DML_STATEMENTS       0x00000001L
#define SQL_OU_PROCEDURE_INVOCATION 0x00000002L
#define SQL_OU_TABLE_DEFINITION     0x00000004L
#define SQL_OU_INDEX_DEFINITION     0x00000008L
#define SQL_OU_PRIVILEGE_DEFINITION 0x00000010L

/* ODBC schema usage flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SU_DML_STATEMENTS       SQL_OU_DML_STATEMENTS
    #define SQL_SU_PROCEDURE_INVOCATION SQL_OU_PROCEDURE_INVOCATION
    #define SQL_SU_TABLE_DEFINITION     SQL_OU_TABLE_DEFINITION
    #define SQL_SU_INDEX_DEFINITION     SQL_OU_INDEX_DEFINITION
    #define SQL_SU_PRIVILEGE_DEFINITION SQL_OU_PRIVILEGE_DEFINTION
#endif

/* ODBC qualifier usage flags */
#define SQL_QU_DML_STATEMENTS           0x00000001L
#define SQL_QU_DML_PROCEDURE_INVOCATION 0x00000002L
#define SQL_QU_DML_TABLE_DEFINITION     0x00000004L
#define SQL_QU_DML_INDEX_DEFINITION     0x00000008L
#define SQL_QU_DML_PRIVILEGE_DEFINITION 0x00000010L

/* ODBC catalog usage flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CU_DML_STATEMENTS       SQL_QU_DML_STATEMENTS
    #define SQL_CU_PROCEDURE_INVOCATION SQL_QU_PROCEDURE_INVOCATION
    #define SQL_CU_TABLE_DEFINITION     SQL_QU_TABLE_DEFINITION
    #define SQL_CU_INDEX_DEFINITION     SQL_QU_INDEX_DEFINITION
    #define SQL_CU_PRIVILEGE_DEFINITION SQL_QU_PRIVILEGE_DEFINITION
#endif

/* ODBC subqueries flags */
#define SQL_SQ_COMPARISON               0x00000001L
#define SQL_SQ_EXISTS                   0x00000002L
#define SQL_SQ_IN                       0x00000004L
#define SQL_SQ_QUANTIFIED               0x00000008L
#define SQL_SQ_CORRELATED_SUBQUERIES    0x00000010L

/* ODBC union flags */
#define SQL_U_UNION     0x00000001L
#define SQL_U_UNION_ALL 0x00000002L

/* ODBC bookmark persistence values */
#define SQL_BP_CLOSE        0x00000001L
#define SQL_BP_DELETE       0x00000002L
#define SQL_BP_DROP         0x00000004L
#define SQL_BP_TRANSACTION  0x00000008L
#define SQL_BP_UPDATE       0x00000010L
#define SQL_BP_OTHER_HSTMT  0x00000020L
#define SQL_BP_SCROLL       0x00000040L

/* ODBC static sensitivity values */
#define SQL_SS_ADDITIONS    0x00000001L
#define SQL_SS_DELETIONS    0x00000002L
#define SQL_SS_UPDATES      0x00000004L

/* ODBC view values */
#define SQL_CV_CREATE_VIEW  0x00000001L
#define SQL_CV_CHECK_OPTION 0x00000002L
#define SQL_CV_CASCADED     0x00000004L
#define SQL_CV_LOCAL        0x00000008L

/* ODBC lock type flags */
#define SQL_LCK_NO_CHANGE   0x00000001L
#define SQL_LCK_EXCLUSIVE   0x00000002L
#define SQL_LCK_UNLOCK      0x00000004L

/* ODBC position operation flags */
#define SQL_POS_POSITION    0x00000001L
#define SQL_POS_REFRESH     0x00000002L
#define SQL_POS_UPDATE      0x00000004L
#define SQL_POS_DELETE      0x00000008L
#define SQL_POS_ADD         0x00000010L

/* ODBC qualifier location values */
#define SQL_QL_START    0x0001
#define SQL_QL_END      0x0002

/* ODBC aggregate function flags */
#if (ODBCVER >= 0x0300)
    #define SQL_AF_AVG      0x00000001L
    #define SQL_AF_COUNT    0x00000002L
    #define SQL_AF_MAX      0x00000004L
    #define SQL_AF_MIN      0x00000008L
    #define SQL_AF_SUM      0x00000010L
    #define SQL_AF_DISTINCT 0x00000020L
    #define SQL_AF_ALL      0x00000040L
#endif

/* ODBC conformance flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SC_SQL92_ENTRY              0x00000001L
    #define SQL_SC_FIPS127_2_TRANSITIONAL   0x00000002L
    #define SQL_SC_SQL92_INTERMEDIATE       0x00000004L
    #define SQL_SC_SQL92_FULL               0x00000008L
#endif

/* ODBC date/time literal flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DL_SQL92_DATE                       0x00000001L
    #define SQL_DL_SQL92_TIME                       0x00000002L
    #define SQL_DL_SQL92_TIMESTAMP                  0x00000004L
    #define SQL_DL_SQL92_INTERVAL_YEAR              0x00000008L
    #define SQL_DL_SQL92_INTERVAL_MONTH             0x00000010L
    #define SQL_DL_SQL92_INTERVAL_DAY               0x00000020L
    #define SQL_DL_SQL92_INTERVAL_HOUR              0x00000040L
    #define SQL_DL_SQL92_INTERVAL_MINUTE            0x00000080L
    #define SQL_DL_SQL92_INTERVAL_SECOND            0x00000100L
    #define SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH     0x00000200L
    #define SQL_DL_SQL92_INTERVAL_DAY_TO_HOUR       0x00000400L
    #define SQL_DL_SQL92_INTERVAL_DAY_TO_MINUTE     0x00000800L
    #define SQL_DL_SQL92_INTERVAL_DAY_TO_SECOND     0x00001000L
    #define SQL_DL_SQL92_INTERVAL_HOUR_TO_MINUTE    0x00002000L
    #define SQL_DL_SQL92_INTERVAL_HOUR_TO_SECOND    0x00004000L
    #define SQL_DL_SQL92_INTERVAL_MINUTE_TO_SECOND  0x00008000L
#endif

/* ODBC catalog location values */
#if (ODBCVER >= 0x0300)
    #define SQL_CL_START    SQL_QL_START
    #define SQL_CL_END      SQL_QL_END
#endif

/* ODBC batch row count flags */
#if (ODBCVER >= 0x0300)
    #define SQL_BRC_PROCEDURES  0x00000001L
    #define SQL_BRC_EXPLICIT    0x00000002L
    #define SQL_BRC_ROLLED_UP   0x00000004L
#endif

/* ODBC batch support flags */
#if (ODBCVER >= 0x0300)
    #define SQL_BS_SELECT_EXPLICIT      0x00000001L
    #define SQL_BS_ROW_COUNT_EXPLICIT   0x00000002L
    #define SQL_BS_SELECT_PROC          0x00000004L
    #define SQL_BS_ROW_COUNT_PROC       0x00000008L
#endif

/* ODBC parameter array row count values */
#if (ODBCVER >= 0x0300)
    #define SQL_PARC_BATCH      1
    #define SQL_PARC_NO_BATCH   2
#endif

/* ODBC parameter array select values */
#if (ODBCVER >= 0x0300)
    #define SQL_PAS_BATCH       1
    #define SQL_PAS_NO_BATCH    2
    #define SQL_PAS_NO_SELECT   3
#endif

/* ODBC index keyword flags */
#if (ODBCVER >= 0x0300)
    #define SQL_IK_NONE     0x00000000L
    #define SQL_IK_ASC      0x00000001L
    #define SQL_IK_DESC     0x00000002L
    #define SQL_IK_ALL      (SQL_IK_ASC | SQL_IK_DESC)
#endif

/* ODBC information schema view flags */
#if (ODBCVER >= 0x0300)
    #define SQL_ISV_ASSERTIONS              0x00000001L
    #define SQL_ISV_CHARACTER_SETS          0x00000002L
    #define SQL_ISV_CHECK_CONSTRAINTS       0x00000004L
    #define SQL_ISV_COLLATIONS              0x00000008L
    #define SQL_ISV_COLUMN_DOMAIN_USAGE     0x00000010L
    #define SQL_ISV_COLUMN_PRIVILEGES       0x00000020L
    #define SQL_ISV_COLUMNS                 0x00000040L
    #define SQL_ISV_CONSTRAINT_COLUMN_USAGE 0x00000080L
    #define SQL_ISV_CONSTRAINT_TABLE_USAGE  0x00000100L
    #define SQL_ISV_DOMAIN_CONSTRAINTS      0x00000200L
    #define SQL_ISV_DOMAINS                 0x00000400L
    #define SQL_ISV_KEY_COLUMN_USAGE        0x00000800L
    #define SQL_ISV_REFERENTIAL_CONSTRAINTS 0x00001000L
    #define SQL_ISV_SCHEMATA                0x00002000L
    #define SQL_ISV_SQL_LANGUAGES           0x00004000L
    #define SQL_ISV_TABLE_CONSTRAINTS       0x00008000L
    #define SQL_ISV_TABLE_PRIVILEGES        0x00010000L
    #define SQL_ISV_TABLES                  0x00020000L
    #define SQL_ISV_TRANSLATIONS            0x00040000L
    #define SQL_ISV_USAGE_PRIVILEGES        0x00080000L
    #define SQL_ISV_VIEW_COLUMN_USAGE       0x00100000L
    #define SQL_ISV_VIEW_TABLE_USAGE        0x00200000L
    #define SQL_ISV_VIEWS                   0x00400000L
#endif

/* ODBC asynchronous modes */
#if (ODBCVER >= 0x0300)
    #define SQL_AM_NONE         0L
    #define SQL_AM_CONNECTION   1L
    #define SQL_AM_STATEMENT    2L
#endif

/* ODBC alter domain flags */
#if (ODBCVER >= 0x0300)
    #define SQL_AD_CONSTRAINT_NAME_DEFINITION           0x00000001L
    #define SQL_AD_ADD_DOMAIN_CONSTRAINT                0x00000002L
    #define SQL_AD_DROP_DOMAIN_CONSTRAINT               0x00000004L
    #define SQL_AD_ADD_DOMAIN_DEFAULT                   0x00000008L
    #define SQL_AD_DROP_DOMAIN_DEFAULT                  0x00000010L
    #define SQL_AD_ADD_CONSTRAINT_INITIALLY_DEFERRED    0x00000020L
    #define SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE   0x00000040L
    #define SQL_AD_ADD_CONSTRAINT_DEFERRABLE            0x00000080L
    #define SQL_AD_ADD_CONSTRAINT_NON_DEFERRABLE        0x00000100L
#endif

/* ODBC create schema flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CS_CREATE_SCHEMA            0x00000001L
    #define SQL_CS_AUTHORIZATION            0x00000002L
    #define SQL_CS_DEFAULT_CHARACTER_SET    0x00000004L
#endif

/* ODBC create translation flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CTR_CREATE_TRANSLATION  0x00000001L
#endif

/* ODBC create assertion flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CA_CREATE_ASSERTION                 0x00000001L
    #define SQL_CA_CONSTRAINT_INITIALLY_DEFERRED    0x00000010L
    #define SQL_CA_CONSTRAINT_INITIALLY_IMMEDIATE   0x00000020L
    #define SQL_CA_CONSTRAINT_DEFERRABLE            0x00000040L
    #define SQL_CA_CONSTRAINT_NON_DEFERRABLE        0x00000080L
#endif

/* ODBC create character set flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CCS_CREATE_CHARACTER_SET    0x00000001L
    #define SQL_CCS_COLLATE_CLAUSE          0x00000002L
    #define SQL_CCS_LIMITED_COLLATION       0x00000004L
#endif

/* ODBC create collation flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CCOL_CREATE_COLLATION   0x00000001L
#endif

/* ODBC create domain flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CDO_CREATE_DOMAIN                   0x00000001L
    #define SQL_CDO_DEFAULT                         0x00000002L
    #define SQL_CDO_CONSTRAINT                      0x00000004L
    #define SQL_CDO_COLLATION                       0x00000008L
    #define SQL_CDO_CONSTRAINT_NAME_DEFINITION      0x00000010L
    #define SQL_CDO_CONSTRAINT_INITIALLY_DEFERRED   0x00000020L
    #define SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE  0x00000040L
    #define SQL_CDO_CONSTRAINT_DEFERRABLE           0x00000080L
    #define SQL_CDO_CONSTRAINT_NON_DEFERRABLE       0x00000100L
#endif

/* ODBC create table flags */
#if (ODBCVER >= 0x0300)
    #define SQL_CT_CREATE_TABLE                     0x00000001L
    #define SQL_CT_COMMIT_PRESERVE                  0x00000002L
    #define SQL_CT_COMMIT_DELETE                    0x00000004L
    #define SQL_CT_GLOBAL_TEMPORARY                 0x00000008L
    #define SQL_CT_LOCAL_TEMPORARY                  0x00000010L
    #define SQL_CT_CONSTRAINT_INITIALLY_DEFERRED    0x00000020L
    #define SQL_CT_CONSTRAINT_INITIALLY_IMMEDIATE   0x00000040L
    #define SQL_CT_CONSTRAINT_DEFERRABLE            0x00000080L
    #define SQL_CT_CONSTRAINT_NON_DEFERRABLE        0x00000100L
    #define SQL_CT_COLUMN_CONSTRAINT                0x00000200L
    #define SQL_CT_COLUMN_DEFAULT                   0x00000400L
    #define SQL_CT_COLUMN_COLLATION                 0x00000800L
    #define SQL_CT_TABLE_CONSTRAINT                 0x00001000L
    #define SQL_CT_CONSTRAINT_NAME_DEFINITION       0x00002000L
#endif

/* ODBC DDL index flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DI_CREATE_INDEX 0x00000001L
    #define SQL_DI_DROP_INDEX   0x00000002L
#endif

/* ODBC drop collation flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DC_DROP_COLLATION   0x00000001L
#endif

/* ODBC drop domain flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DD_DROP_DOMAIN  0x00000001L
    #define SQL_DD_RESTRICT     0x00000002L
    #define SQL_DD_CASCADE      0x00000004L
#endif

/* ODBC drop schema flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DS_DROP_SCHEMA  0x00000001L
    #define SQL_DS_RESTRICT     0x00000002L
    #define SQL_DS_CASCADE      0x00000004L
#endif

/* ODBC drop character set flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DCS_DROP_CHARACTER_SET  0x00000001L
#endif

/* ODBC drop assertion flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DA_DROP_ASSERTION   0x00000001L
#endif

/* ODBC drop table flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DT_DROP_TABLE   0x00000001L
    #define SQL_DT_RESTRICT     0x00000002L
    #define SQL_DT_CASCADE      0x00000004L
#endif

/* ODBC drop translation flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DTR_DROP_TRANSLATION    0x00000001L
#endif

/* ODBC drop view flags */
#if (ODBCVER >= 0x0300)
    #define SQL_DV_DROP_VIEW    0x00000001L
    #define SQL_DV_RESTRICT     0x00000002L
    #define SQL_DV_CASCADE      0x00000004L
#endif

/* ODBC insert statement flags */
#if (ODBCVER >= 0x0300)
    #define SQL_IS_INSERT_LITERALS  0x00000001L
    #define SQL_IS_INSERT_SEARCHED  0x00000002L
    #define SQL_IS_INSERT_INTO      0x00000004L
#endif

/* ODBC interface conformance values */
#if (ODBCVER >= 0x0300)
    #define SQL_OIC_CORE    1L
    #define SQL_OIC_LEVEL1  2L
    #define SQL_OIC_LEVEL2  3L
#endif

/* ODBC SQL92 foreign key delete flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SFKD_CASCADE        0x00000001L
    #define SQL_SFKD_NO_ACTION      0x00000002L
    #define SQL_SFKD_SET_DEFAULT    0x00000004L
    #define SQL_SFKD_SET_NULL       0x00000008L
#endif

/* ODBC SQL92 foreign key update flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SFKU_CASCADE        0x00000001L
    #define SQL_SFKU_NO_ACTION      0x00000002L
    #define SQL_SFKU_SET_DEFAULT    0x00000004L
    #define SQL_SFKU_SET_NULL       0x00000008L
#endif

/* ODBC SQL92 grant flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SG_USAGE_ON_DOMAIN          0x00000001L
    #define SQL_SG_USAGE_ON_CHARACTER_SET   0x00000002L
    #define SQL_SG_USAGE_ON_COLLATION       0x00000004L
    #define SQL_SG_USAGE_ON_TRANSLATION     0x00000008L
    #define SQL_SG_WITH_GRANT_OPTION        0x00000010L
    #define SQL_SG_DELETE_TABLE             0x00000020L
    #define SQL_SG_INSERT_TABLE             0x00000040L
    #define SQL_SG_INSERT_COLUMN            0x00000080L
    #define SQL_SG_REFERENCES_TABLE         0x00000100L
    #define SQL_SG_REFERENCES_COLUMN        0x00000200L
    #define SQL_SG_SELECT_TABLE             0x00000400L
    #define SQL_SG_UPDATE_TABLE             0x00000800L
    #define SQL_SG_UPDATE_COLUMN            0x00001000L
#endif

/* ODBC SQL92 predicate flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SP_EXISTS                   0x00000001L
    #define SQL_SP_ISNOTNULL                0x00000002L
    #define SQL_SP_ISNULL                   0x00000004L
    #define SQL_SP_MATCH_FULL               0x00000008L
    #define SQL_SP_MATCH_PARTIAL            0x00000010L
    #define SQL_SP_MATCH_UNIQUE_FULL        0x00000020L
    #define SQL_SP_MATCH_UNIQUE_PARTIAL     0x00000040L
    #define SQL_SP_OVERLAPS                 0x00000080L
    #define SQL_SP_UNIQUE                   0x00000100L
    #define SQL_SP_LIKE                     0x00000200L
    #define SQL_SP_IN                       0x00000400L
    #define SQL_SP_BETWEEN                  0x00000800L
    #define SQL_SP_COMPARISON               0x00001000L
    #define SQL_SP_QUANTIFIED_COMPARISON    0x00002000L
#endif

/* ODBC SQL92 relational join operator flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SRJO_CORRESPONDING_CLAUSE   0x00000001L
    #define SQL_SRJO_CROSS_JOIN             0x00000002L
    #define SQL_SRJO_EXCEPT_JOIN            0x00000004L
    #define SQL_SRJO_FULL_OUTER_JOIN        0x00000008L
    #define SQL_SRJO_INNER_JOIN             0x00000010L
    #define SQL_SRJO_INTERSECT_JOIN         0x00000020L
    #define SQL_SRJO_LEFT_OUTER_JOIN        0x00000040L
    #define SQL_SRJO_NATURAL_JOIN           0x00000080L
    #define SQL_SRJO_RIGHT_OUTER_JOIN       0x00000100L
    #define SQL_SRJO_UNION_JOIN             0x00000200L
#endif

/* ODBC SQL92 revoke flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SR_USAGE_ON_DOMAIN          0x00000001L
    #define SQL_SR_USAGE_ON_CHARACTER_SET   0x00000002L
    #define SQL_SR_USAGE_ON_COLLATION       0x00000004L
    #define SQL_SR_USAGE_ON_TRANSLATION     0x00000008L
    #define SQL_SR_GRANT_OPTION_FOR         0x00000010L
    #define SQL_SR_CASCADE                  0x00000020L
    #define SQL_SR_RESTRICT                 0x00000040L
    #define SQL_SR_DELETE_TABLE             0x00000080L
    #define SQL_SR_INSERT_TABLE             0x00000100L
    #define SQL_SR_INSERT_COLUMN            0x00000200L
    #define SQL_SR_REFERENCES_TABLE         0x00000400L
    #define SQL_SR_REFERENCES_COLUMN        0x00000800L
    #define SQL_SR_SELECT_TABLE             0x00001000L
    #define SQL_SR_UPDATE_TABLE             0x00002000L
    #define SQL_SR_UPDATE_COLUMN            0x00004000L
#endif

/* ODBC SQL92 row value constructor flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SRVC_VALUE_EXPRESSION   0x00000001L
    #define SQL_SRVC_NULL               0x00000002L
    #define SQL_SRVC_DEFAULT            0x00000004L
    #define SQL_SRVC_ROW_SUBQUERY       0x00000008L
#endif

/* ODBC SQL92 value expression flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SVE_CASE        0x00000001L
    #define SQL_SVE_CAST        0x00000002L
    #define SQL_SVE_COALESCE    0x00000004L
    #define SQL_SVE_NULLIF      0x00000008L
#endif

/* ODBC standard CLI conformance flags */
#if (ODBCVER >= 0x0300)
    #define SQL_SCC_XOPEN_CLI_VERSION1  0x00000001L
    #define SQL_SCC_ISO92_CLI           0x00000002L
#endif

/* ODBC union statement flags */
#if (ODBCVER >= 0x0300)
    #define SQL_US_UNION        SQL_U_UNION
    #define SQL_US_UNION_ALL    SQL_U_UNION_ALL
#endif

/* ODBC DTC transition cost flags */
#define SQL_DTC_ENLIST_EXPENSIVE    0x00000001L
#define SQL_DTC_UNENLIST_EXPENSIVE  0x00000002L

/* ODBC asynchronous DBC function flags */
#if (ODBCVER >= 0x0380)
    #define SQL_ASYNC_DBC_NOT_CAPABLE   0x00000000L
    #define SQL_ASYNC_DBC_CAPABLE       0x00000001L
#endif

/* Fetch orientations */
#if (ODBCVER >= 0x0300)
    #define SQL_FETCH_FIRST_USER    31L
    #define SQL_FETCH_FIRST_SYSTEM  32L
#endif

/* SQLSetPos() constants */
#define SQL_ENTIRE_ROWSET   0

/* SQLSetPos() operations */
#define SQL_POSITION                0
#define SQL_REFRESH                 1
#define SQL_UPDATE                  2
#define SQL_DELETE                  3
#define SQL_ADD                     4
#define SQL_SETPOS_MAX_OPTION_VALUE SQL_ADD
#if (ODBCVER >= 0x0300)
    #define SQL_UPDATE_BY_BOOKMARK  5
    #define SQL_DELETE_BY_BOOKMARK  6
    #define SQL_FETCH_BY_BOOKMARK   7
#endif

/* SQLSetPos() lock options */
#define SQL_LOCK_NO_CHANGE          0
#define SQL_LOCK_EXCLUSIVE          1
#define SQL_LOCK_UNLOCK             2
#define SQL_SETPOS_MAX_LOCK_VALUE   SQL_LOCK_UNLOCK

/* Column types */
#define SQL_BEST_ROWID  1
#define SQL_ROWVER      2

/* ODBC pseudocolumns */
#define SQL_PC_NOT_PSEUDO   1

/* SQLStatistics() constants */
#define SQL_QUICK   0
#define SQL_ENSURE  1

/* ODBC index special values */
#define SQL_TABLE_STAT  0

/* SQLTables() constants */
#if (ODBCVER >= 0x0300)
    #define SQL_ALL_CATALOGS    "%"
    #define SQL_ALL_SCHEMAS     "%"
    #define SQL_ALL_TABLE_TYPES "%"
#endif

/* SQLDriverConnect() options */
#define SQL_DRIVER_NOPROMPT             0
#define SQL_DRIVER_COMPLETE             1
#define SQL_DRIVER_PROMPT               2
#define SQL_DRIVER_COMPLETE_REQUIRED    3

/* SQLExtendedFetch() fetch types */
#define SQL_FETCH_BOOKMARK  8

/* SQLExtendedFetch() row status values */
#define SQL_ROW_SUCCESS                 0
#define SQL_ROW_DELETED                 1
#define SQL_ROW_UPDATED                 2
#define SQL_ROW_NOROW                   3
#define SQL_ROW_ADDED                   4
#define SQL_ROW_ERROR                   5
#if (ODBCVER >= 0x0300)
    #define SQL_ROW_SUCCESS_WITH_INFO   6
    #define SQL_ROW_PROCEED             0
    #define SQL_ROW_IGNORE              1
#endif

/* ODBC description array status values */
#if (ODBCVER >= 0x0300)
    #define SQL_PARAM_SUCCESS           0
    #define SQL_PARAM_SUCCESS_WITH_INFO 6
    #define SQL_PARAM_ERROR             5
    #define SQL_PARAM_UNUSED            7
    #define SQL_PARAM_DIAG_UNAVAILABLE  1
    #define SQL_PARAM_PROCEED           0
    #define SQL_PARAM_IGNORE            1
#endif

/* SQLForeignKeys() constants */
#define SQL_CASCADE                 0
#define SQL_RESTRICT                1
#define SQL_SET_NULL                2
#if (ODBCVER >= 0x0250)
    #define SQL_NO_ACTION           3
    #define SQL_SET_DEFAULT         4
#endif
#if (ODBCVER >= 0x0300)
    #define SQL_INITIALLY_DEFERRED  5
    #define SQL_INITIALLY_IMMEDIATE 6
    #define SQL_NOT_DEFERRABLE      7
#endif

/* ODBC parameter types */
#define SQL_PARAM_TYPE_UNKNOWN              0
#define SQL_PARAM_INPUT                     1
#define SQL_PARAM_INPUT_OUTPUT              2
#define SQL_RESULT_COL                      3
#define SQL_PARAM_OUTPUT                    4
#define SQL_RETURN_VALUE                    5
#if (ODBCVER >= 0x0380)
    #define SQL_PARAM_INPUT_OUTPUT_STREAM   8
    #define SQL_PARAM_OUTPUT_STREAM         16
#endif

/* ODBC procedure types */
#define SQL_PT_UNKNOWN      0
#define SQL_PT_PROCEDURE    1
#define SQL_PT_FUNCTION     2

/* ODBC keywords */
#define SQL_ODBC_KEYWORDS \
    "ABSOLUTE,ACTION,ADA,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT," \
    "AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE," \
    "CAST,CATALOG,CHAR,CHAR_LENGTH,CHARACTER,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE," \
    "COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS," \
    "CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE," \
    "CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC," \
    "DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR," \
    "DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE," \
    "EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT," \
    "FOR,FOREIGN,FORTRAN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR," \
    "IDENTITY,IMMEDIATE,IN,INCLUDE,INDEX,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE," \
    "INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST," \
    "LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES," \
    "NATIONAL,NATURAL,NCHAR,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON," \
    "ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PASCAL,PLI,POSITION," \
    "PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL," \
    "REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,SCHEMA,SCROLL,SECOND," \
    "SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCA," \
    "SQLCODE,SQLERROR,SQLSTATE,SQLWARNING,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY," \
    "THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION," \
    "TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER," \
    "USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE," \
    "YEAR,ZONE"

/* Type subcodes for standards conformance */
#ifdef ODBC_STD
    #define SQL_YEAR                SQL_CODE_YEAR
    #define SQL_MONTH               SQL_CODE_MONTH
    #define SQL_DAY                 SQL_CODE_DAY
    #define SQL_HOUR                SQL_CODE_HOUR
    #define SQL_MINUTE              SQL_CODE_MINUTE
    #define SQL_SECOND              SQL_CODE_SECOND
    #define SQL_YEAR_TO_MONTH       SQL_CODE_YEAR_TO_MONTH
    #define SQL_DAY_TO_HOUR         SQL_CODE_DAY_TO_HOUR
    #define SQL_DAY_TO_MINUTE       SQL_CODE_DAY_TO_MINUTE
    #define SQL_DAY_TO_SECOND       SQL_CODE_DAY_TO_SECOND
    #define SQL_HOUR_TO_MINUTE      SQL_CODE_HOUR_TO_MINUTE
    #define SQL_HOUR_TO_SECOND      SQL_CODE_HOUR_TO_SECOND
    #define SQL_MINUTE_TO_SECOND    SQL_CODE_MINUTE_TO_SECOND
#endif

/* Old constants for compatibility */
#define SQL_DATABASE_NAME           16
#define SQL_FD_FETCH_PREV           SQL_FD_FETCH_PRIOR
#define SQL_FETCH_PREV              SQL_FETCH_PRIOR
#define SQL_CONCUR_TIMESTAMP        SQL_CONCUR_ROWVER
#define SQL_SCCO_OPT_TIMESTAMP      SQL_SCCO_OPT_ROWVER
#define SQL_CC_DELETE               SQL_CB_DELETE
#define SQL_CR_DELETE               SQL_CB_DELETE
#define SQL_CC_CLOSE                SQL_CB_CLOSE
#define SQL_CR_CLOSE                SQL_CB_CLOSE
#define SQL_CC_PRESERVE             SQL_CB_PRESERVE
#define SQL_CR_PRESERVE             SQL_CB_PRESERVE
#define SQL_FETCH_RESUME            7
#define SQL_SCROLL_FORWARD_ONLY     0L
#define SQL_SCROLL_KEYSET_DRIVEN    (-1L)
#define SQL_SCROLL_DYNAMIC          (-2L)
#define SQL_SCROLL_STATIC           (-3L)

/* Functions in ODBC32.DLL */
DWORD SQL_API       ODBCGetTryWaitValue();
BOOL SQL_API        ODBCSetTryWaitValue( DWORD );
SQLRETURN SQL_API   SQLBindParameter( SQLHSTMT, SQLUSMALLINT, SQLSMALLINT, SQLSMALLINT, SQLSMALLINT, SQLULEN, SQLSMALLINT, SQLPOINTER, SQLLEN, SQLLEN * );
SQLRETURN SQL_API   SQLBrowseConnect( SQLHDBC, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLSMALLINT * );
SQLRETURN SQL_API   SQLColAttributes( SQLHSTMT, SQLUSMALLINT, SQLUSMALLINT, SQLPOINTER, SQLSMALLINT, SQLSMALLINT *, SQLLEN * );
SQLRETURN SQL_API   SQLColumnPrivileges( SQLHSTMT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT );
SQLRETURN SQL_API   SQLDescribeParam( SQLHSTMT, SQLUSMALLINT, SQLSMALLINT *, SQLULEN *, SQLSMALLINT *, SQLSMALLINT * );
SQLRETURN SQL_API   SQLDriverConnect( SQLHDBC, SQLHWND, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLSMALLINT *, SQLUSMALLINT );
SQLRETURN SQL_API   SQLDrivers( SQLHENV, SQLUSMALLINT, SQLCHAR *, SQLSMALLINT, SQLSMALLINT *, SQLCHAR *, SQLSMALLINT, SQLSMALLINT * );
SQLRETURN SQL_API   SQLExtendedFetch( SQLHSTMT, SQLUSMALLINT, SQLLEN, SQLULEN *, SQLUSMALLINT * );
SQLRETURN SQL_API   SQLForeignKeys( SQLHSTMT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT );
SQLRETURN SQL_API   SQLMoreResults( SQLHSTMT );
SQLRETURN SQL_API   SQLNativeSql( SQLHDBC, SQLCHAR *, SQLINTEGER, SQLCHAR *, SQLINTEGER, SQLINTEGER * );
SQLRETURN SQL_API   SQLNumParams( SQLHSTMT, SQLSMALLINT * );
SQLRETURN SQL_API   SQLParamOptions( SQLHSTMT, SQLULEN, SQLULEN * );
SQLRETURN SQL_API   SQLPrimaryKeys( SQLHSTMT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT );
SQLRETURN SQL_API   SQLProcedureColumns( SQLHSTMT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT );
SQLRETURN SQL_API   SQLProcedures( SQLHSTMT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT );
SQLRETURN SQL_API   SQLSetPos( SQLHSTMT, SQLSETPOSIROW, SQLUSMALLINT, SQLUSMALLINT );
SQLRETURN SQL_API   SQLSetScrollOptions( SQLHSTMT, SQLUSMALLINT, SQLLEN, SQLUSMALLINT );
SQLRETURN SQL_API   SQLTablePrivileges( SQLHSTMT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT, SQLCHAR *, SQLSMALLINT );
#if (ODBCVER >= 0x0300)
SQLRETURN SQL_API   SQLAllocHandleStd( SQLSMALLINT, SQLHANDLE, SQLHANDLE * );
SQLRETURN SQL_API   SQLBulkOperations( SQLHSTMT, SQLSMALLINT );
#endif

/* Macros */
#define SQL_POSITION_TO( p1, p2 ) \
    SQLSetPos( p1, p2, SQL_POSITION, SQL_LOCK_NO_CHANGE )
#define SQL_LOCK_RECORD( p1, p2, p3 ) \
    SQLSetPos( p1, p2, SQL_POSITION, p3 )
#define SQL_REFRESH_RECORD( p1, p2, p3 ) \
    SQLSetPos( p1, p2, SQL_REFRESH, p3 )
#define SQL_UPDATE_RECORD( p1, p2 ) \
    SQLSetPos( p1, p2, SQL_UPDATE, SQL_LOCK_NO_CHANGE )
#define SQL_DELETE_RECORD( p1, p2 ) \
    SQLSetPos( p1, p2, SQL_DELETE, SQL_LOCK_NO_CHANGE )
#define SQL_ADD_RECORD( p1, p2 ) \
    SQLSetPos( p1, p2, SQL_ADD, SQL_LOCK_NO_CHANGE )

/* Macros for standards conformance */
#ifdef ODBC_STD
    #define SQLAllocHandle      SQLAllocHandleStd
    #define SQLAllocEnv( x )    SQLAllocHandleStd( SQL_HANDLE_ENV, SQL_NULL_HANDLE, x )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#include <sqlucode.h>

#endif /* __SQLEXT */
