{****************************************************************************}
{                                                                            }
{ VenomGFX - graphics library for Freepascal, DOS target                     }
{                                                                            }
{ Written by Laaca and Christian T. Magnus a.k.a. VENOM.                     }
{ And at last but not at least there are used some routines by another       }
{ authors too.                                                               }
{                                                DOS-u-akbar!                }
{****************************************************************************}

{$ASMMODE INTEL}
{$MODE FPC}

{$IFDEF VER2}{$DEFINE NEWFPC}{$ENDIF}
{$IFDEF VER3}{$DEFINE NEWFPC}{$ENDIF}
{$IFDEF NEWFPC}{$CALLING OLDFPCCALL}{$ENDIF}
{$RANGECHECKS OFF}

{$DEFINE EnableInline}
{$IFDEF EnableInline}
   {$INLINE ON}
{$ELSE}
   {$INLINE OFF}
{$ENDIF}

{$Q-}            {These directives must be turned off}
{$R-}            {because else it would crash in the mouse interrupt routine}
{$S-}
{$D-}

{_$DEFINE SIMPLIER_GTF_CALC} {for enabling remove "_" char}

UNIT VenomGFX;


INTERFACE
uses Objects;

var Locked_interface_data_start:byte;    {DO NOT MOVE THIS DECLARATION!}

CONST
         MouseINT = $33;
         MAX_poly = 20000;
         ENDPOLY = 0;

TYPE     PVirtualWindow = ^VirtualWindow;
{!! DON'T CHANGE THE ORDER OF THE VARIABLES IN THE VIRTUALWINDOW STRUCTURE !!}
         VirtualWindow = packed Record
                    {0}   Segment        : Word;
                    {2}   VWOffset       : LongInt;
                    {6}   Size           : LongInt;
                    {10}  Breite         : LongInt;
                    {14}  BreiteMinus1   : LongInt;
                    {18}  TransCol       : Word;
                          {color which is in some procs used as transparent}
                    {20}  flags          : byte;
                          {0.bit - has bitmap (always set)}
                          {1.bit - has RLE map}
                          {2.bit - transparency}
                          {3.bit - in locked memory (for mouse handler)}
                    {21}  reserved1      : byte;
                    {22}  position       : LongInt;
                          {used by mouse driver}
                    {26}  ByteBreite     : LongInt;
                    {30}  Hoehe          : LongInt;
                    {34}  RLEmap         : LongInt;
                    {38}  HoeheMinus1    : LongInt;
                    {42}  RLEsize        : Longint;
                    {46} End;

         mouse_record = packed record    { For mouse handling }
            workplace:virtualwindow;  { most often VGA }
            locked:boolean;
            has_wheel:boolean;
            x,y,b,w:integer;       { W is wheel. Available only in DOS with CTMOUSE driver }
            _wdif:shortint;      { relative change of W until last call }
            wheelrange:longint;
            dx,dy:shortint;       {horizontal and vertical change from last call}
            old_x,old_y: longint;
            hotspot_x,hotspot_y: longint;
            last_lpx,last_lpy:longint; {where was when last time left b. was pressed}
            last_lrx,last_lry:longint; {where was when last time left b. was released}
            last_lp_time:dword;        {time when of last left b. was pressed}

            last_rpx,last_rpy:longint; {where was when last time left b. was pressed}
            last_rrx,last_rry:longint; {where was when last time left b. was released}
            last_rp_time:dword;       {time when of last left b. was pressed}

            numbuttons : byte;
            cursor:virtualwindow;
            background:virtualwindow;
            drawing_on_callback:boolean; {if TRUE the cursor is drawed automaticaly by callback; if FALSE is it up to you}
            callback_routine:procedure;  {By default calls MouseDraw. You can assign another proc}
            putcursor:procedure(var dest,sprite:virtualwindow;x,y:longint;hc:word);
            delcursor:procedure(var dest,sprite:virtualwindow;x,y:longint);
            getcursor:procedure(var source,sprite:virtualwindow;x,y:longint);
            visible:boolean;
            busy:boolean;   {bude spinat handler}
            busy2:boolean;  {bude se spinat v bankovacich kreslicich procs}
         end;


         TPointArray = array[0..MAX_POLY] of record x,y:longint;end;
         PPointArray = ^TPointArray;

         PolyType = record
             num:longint;
             point:PPointArray;
             end;

         Palette = packed array[0..255,1..3] of byte;
         PPalette = ^Palette;
         BGRApalette = packed array[0..255] of packed record b,g,r,a:byte;end;
         pBGRApalette = ^BGRApalette;

         RawVGAchar = packed array[0..255,1..32] of Byte;


VAR
         VESA_vendor     : string;
         VESA_vendorname : string;
         VESA_productname: string;

         AdaptedPalette: array[0..255] of word;
         VGA           : VirtualWindow;  {screen}
         VGB           : VirtualWindow;  {invisible page of screen or buffer}
         {To know if we already allocated DOS descriptors/segments}

         SVGA_pci_config : packed record
           {0}bBus:byte;
           {1}bDev:byte;
           {2}bFunc:byte;
           {3}vendor_ID:word;
           {5}device_ID:word;
           {7}LFB:dword;
           {11}MMIO:dword;
           {15}IRQ:byte;
           {15}HeaderType:byte;
           {16}LFB_size:dword;
           {20}MMIO_size:dword;
         end;

         Sinus               : Array[0..720] of Real; {For the 360 Rotation-Routines}
         CoSin               : Array[0..720] of Real;

         debug1,debug2:longint;

         CPU_Info_MMX:boolean;
         CPU_Info_SSE:boolean;
         CPU_Info_SSE2:boolean;
         CPU_Info_FPU:Boolean;
         CPU_Info_CMOV:Boolean;
         CPU_Info_3DNOW:Boolean;
         CPU_Info_Stepping_ID:Byte;
         CPU_Info_Modellnummer:byte;
         CPU_Info_Familie:Byte;
         CPU_Info_Vendor:String[13];
         CPU_Brand_String:string;

         mmx_sim_reg:array[0..1] of longint; {for internal use of some MMX procedures}

         mouse:mouse_record;         { For mouse handling }


         MOUSEDEF:pvirtualwindow;         {standard mouse cursor}
         MOUSECLK:pvirtualwindow;         {clock like cursor}
         MOUSEHND:pvirtualwindow;         {hand like cursor}

         Monitor_range : record
         horizmin,horizmax,
         vertmin,vertmax:byte;
         end;

         VesaBaseInfo : packed Record
                { 0}        Signatur             : Array[1..4] of Char;
                { 4}        VesaVersion          : Array[1..2] of Byte;
                { 6}        OEM_ID               : LongInt;
                {10}        Eigenschaften        : LongInt;
                {14}        VideoModi            : LongInt;   { PTR na modelist }
                {18}        Videospeicher        : Word;      { Velikost videopameti v }
                                                              { 64KB uzlicich }
                            { rozsireni VESA 2.0 }
                {20}        OEM_Version          : Array[1..2] of Byte;
                {22}        Verleger             : LongInt;
                {26}        Produkt_ID           : LongInt;
                {30}        Produkt_Revision     : LongInt;
                            { VBE/AF extension - not really used }
                {34}        Accel_VBE_version    : word;
                {38}        Accel_Videomode_PTR  : longint;
                            { other }
                {42}        Leer                 : Array[1..214] of Byte;
                            OEM_Scratchpad       : Array[1..256] of Byte;
                           End;

rawvga8, rawvga14, rawvga16:RawVGAchar;

const

{konstanty typu car}
SolidLn   = $ffff;
DottedLn  = $aaaa;
CenterLn  = $fc78;
DashedLn  = $f8f8;

{konstanty pro konce car}
e_sharp    = 0;
e_round    = 3;
e_stRound  = 1;
e_endRound = 2;

{konstanty pro SetFontStyle pro parametr "flags"}
prop_fn   = 1;   {vybere proporcionalni variantu fontu (lze-li)}
unprop_fn = 0;   {vybere neproporcionalni variantu fontu (lze-li)}

{pro mys}
M_left  = 1;
M_right = 2;

mouse_not_installed_message:string = 'No mouse driver installed.'+#13#10+
                                     'Please, load CTMouse or similar.';

lfb_not_available_message:string = 'Your graphics card doesn''t support LFB access for desired mode.';
init_mode_failed_message:string = 'Failed to set videomode ';

PAG_NO  = 0;      {pagging not installed}
PAG_DBL = 1;      {uses switching of videopages}
PAG_BUF = 2;      {uses virtualwindow as offscreen buffer}
pagging_mode:byte = PAG_NO;
page_active: byte = 0;

PAG_NOCLEAR = -1; {don't clear non viewed page after flip}

HNEG = 1 shl 2;
VNEG = 1 shl 3;


{for third parametr of procedure Init_Graph}
ANY_ACCESS  = 0;
BANK_ACCESS = 1;
LFB_ACCESS  = 2;

{for procedure Init_Graph as a optional parameter FQ.
 Use it in this way: Init_Graph(something,something,something,BEST_FQ or b);
 Tries to find optimal fq. from monitor info. If fails, sets value in B}
BEST_FQ = $4000;

{$INCLUDE VENOMCUR.INC}

{----------------------------- DIVERSES -------------------------------------}

 PROCEDURE Init_Textmode;

 PROCEDURE Error(SourceText1,SourceText2:String);

 FUNCTION  Get_CPU:Boolean;

 PROCEDURE EnoughMemoryOf(Zeiger:Pointer;Memory:LongInt);

 FUNCTION  GetDOSString(Adresse:LongInt):String;
 FUNCTION  GetDOSWord(Adresse:LongInt):Word;
 FUNCTION  GetDOSByte(Adresse:LongInt):Byte;

{--------------------------------- MONITOR ----------------------------------}

 Procedure GetNativeResolution(var x,y:longint);
 {Get native or "recomended" resolution of monitor}
 Function SetLogicDisplay(x,y:longint):boolean;
 PROCEDURE SetBorderColor(Color:Byte);
 FUNCTION  GetBorderColor:Byte;
 Procedure Get_Monitor_Fq_Range;    {returns operational freq. limits of monitor}
 Function GetMonitorSize(var x,y:byte):boolean; {gets size of monitor in cm. projectors
                                        give values 0,0. if function is not
                                        supported, func. will be false}

{---------------------------------- MOUSE -----------------------------------}

 Procedure MouseDraw;
 { Normaly is called by callback through mouse.callback_routine. You can however
   still call it manualy }

 function Init_mouse(var where:virtualwindow;cursor:pvirtualwindow;handler:boolean):boolean;
 function Init_mouse(var where:virtualwindow;cursor:pvirtualwindow):boolean;
 function Init_mouse(var where:virtualwindow):boolean;
 { Installs mouse driver. CURSOR can be any virtualwindow. There are few
   predefined: MOUSEDEF, MOUSECLK and MOUSEHND }

 procedure Kill_mouse;
 { Uninstalls mouse driver }

 procedure MouseHide;
 Procedure MouseArea(x1,y1,x2,y2:longint);
 procedure MouseShow;
 Procedure MouseRefresh;
 Procedure MouseSpeed(x,y:longint);
 Procedure MouseWheelRange(i:longint); { Default if +-1000 }
 Procedure MouseRel;                   { Waits for releasing mouse }
 Procedure MouseLock;
 Procedure MouseUnlock;
 Function MouseInArea(x1,y1,x2,y2:longint):boolean;
 Function MouseInArea(mdata:mouse_record;x1,y1,x2,y2:longint):boolean;
 Procedure MouseSetCursor(p:pvirtualwindow);
 Function MouseGetCursor:pointer;
 Procedure MouseSetPosition(x,y:longint);
 Procedure MouseGetPosition;
 Procedure MouseWatch;
 Procedure MouseSelfCopy(v:virtualwindow;vpozx,vpozy:longint);
 Procedure MouseBackup(var backup:mouse_record);
 Function MouseMoved:boolean;
 Function MousePressed:boolean;
 Function Mouse_L:boolean;
 Function Mouse_R:boolean;

{----------------------------- CONVERSION -----------------------------------}

 FUNCTION  RealStr(RealZahl:Real;Vork,Nachk:Byte):String;
 FUNCTION  LongIntStr(LongIntZahl:LongInt):String;

 Function RGB2word(r,g,b:byte):word;
 Function MyRGB2word(r,g,b:byte):word; {R,G,B are from 0 to 255 and have same importance}
 Function RGB32_16(d:dword):dword;     {color conversion from 32 bit to 16}

 Function Split_R(w:word):byte;
 Function Split_G(w:word):byte;
 Function Split_B(w:word):byte;
 Procedure Word2RGB(w:word;var r,g,b:byte);
 Function DarkenColor(w:word;b:byte):word;
 Function VGA2word(b:byte):word;       { Emulation of VGA palette entries }

{----------------------------- DELAY ----------------------------------------}

 Procedure WaitRetrace;
 Procedure WaitRetrace(var v:virtualwindow);
 Function FromTimer:dword;
 Function TimerTicksFrom(last,d:dword):boolean;
 {Similar like "if FromTimer>last+d then true" but solves problem with}
 {Timer wrapping on MaxDword value}

{-------------------- VIDEOMODE AND VIDEOMEMORY ROUTINES --------------------}
 Function Init_Graph(Mode:Word):byte;
 {Should be called in this way: Init_Graph(Find_Mode(xres,yres))}
 Function Init_Graph(Mode:Word;vid_access:byte):byte;
 {Except resolution specifies also vertival refresh frequency}
 Function Init_Graph(Mode:Word;vid_access:byte;fq:word):byte;
 {For 3rd parameter use constants ANY_ACCESS, BANK_ACCESS, LFB_ACCESS}

 Procedure Init_Pagging(color:longint);
 {enables you to use VGB target and automated switching of videopages}
 {after each switch is non active page cleared with color COLOR}
 {If you don't want to clear it, use COLOR=PAG_NOCLEAR}
 {If you want to use buffer in place of second videopage (it is much faster)}
 {call before this funkcion "pagging_mode:=PAG_BUF"}

 PROCEDURE Kill_Graph;     { Should be called only on the end of program }
 Procedure ToText;         { temporary switches to text mode }
 Procedure ToVGA;          { temporary switches to VGA mode 13h }
 Procedure ToSVGA(m:word); { temporary switches to some SVGA mode }
 Procedure ToSVGA; {switches back to "home" graphics mode from temp. switch}

 Function Find_mode(width,height:word):longint;
 {use it as parameter for Init_Graph}
 Function Best_mode(width,height:word):longint;
 {Get native or "best" resolution from monitor. If graphics card can't support
  it use the closest available or exactly half of the native resolution
  The half of native resolution will not be used if it will be smaller than
  WIDTHxHEIGHT values. These values also serves as a fallback if info from
  monitor is not available}

 Procedure Videosignal_Off;     { switch off the videosignal }
 Procedure Videosignal_On;      { switch the videosignal again on }

 PROCEDURE ReadVesaBaseInfos;
 PROCEDURE ReadVesaModeInfos(Mode:Word);
 FUNCTION  GraphModeSupport(Mode:Word):Boolean;
 Function GetCurrentVideomode:word;
 Function GetRefreshRate:word;

 PROCEDURE Init_VW(var VWPage:VirtualWindow;Breite,Hoehe:LongInt;Clear:Boolean);
 PROCEDURE Init_VW(var VWPage:VirtualWindow;Breite,Hoehe:LongInt);
 PROCEDURE Kill_VW(var VWPage:VirtualWindow);
 Procedure Make_RLEmap(var v:virtualwindow;color:word);
 {Makes additional RLE map for sprite to speed-up procedure PutHCSprite}
 {COLOR specifies which color will be used as transparent and this color will
  be saved into V.TransCol}
 Procedure Make_RLEmap(var v:virtualwindow);
 {Like above but transparent color as taken from v.TransCol }
 Procedure Del_RLEmap(var v:virtualwindow);
 {Deletes RLE_map}
 Procedure PrepareTexture(var v:virtualwindow);
 {Will be used in textured LineHorz and derivates}
 Procedure SetLineMode(mode:byte);
 {Way how to draw horizontal lines (it affects all solid promitives)
  Use these constants wit it:}
 Procedure SetLineMode(mode:byte;var v:virtualwindow);
 {This variant combines procedure SetLineMode(mode:byte) and PrepareTexture}


 Function GetLineMode:byte;
 const lm_normal        = 0;
       lm_texture       = 1;
       lm_maskedtexture = 2;
       lm_xor           = 3;


 Procedure Lock_VW(var v:virtualwindow);
 {Locks occupied region in memory to prevent swapping out
 (needed by mouse handler).
 NOTE: doesn't lock strucure itself, only data in VWoffset and RLEmap}

 Procedure Kill_pagging;

 PROCEDURE Flip_VW  (var Source, dest:virtualwindow);
 PROCEDURE Flip_SVGA(     var source:virtualwindow);

 Procedure Flip_VW_and_clrscr(var Source, dest:virtualwindow;c:word);
 Procedure Flip_SVGA_and_clrscr(var source:virtualwindow;c:word);

 PROCEDURE Flip_SVGB(     var source:virtualwindow);
 Procedure Flip_SVGB_and_clrscr(var source:virtualwindow;c:word);

 Procedure Flip_Page;
 Procedure SetProtectmodeInterface;
 Procedure BankShowTestScreen(var dest:virtualwindow;b1,b2:word);
 {for testing purposes (DEST can be VGA or VGB)}


 {---------------Routines for specific cards (experimental)------------------5}
 Procedure VESA_set_bank_wr;
 Procedure VESA_set_bank_rd;
 Procedure NVidia_set_bank;
 Procedure ATIMach64_set_bank_wr;
 Procedure ATIMach64_set_bank_rd;

 Procedure SetAlternateBankRoutine(writeproc,readproc:pointer);
 Function SetupSpecificCard_ATIMach64:boolean;


 {------------------------- GRAPHICS PRIMITIVES -----------------------------}

 var PutPixel:procedure(var dest:VirtualWindow;x,y:longint;color:word);
     PutClippedPixel:procedure(var dest:VirtualWindow;x,y:longint;color:word);
     GetPixel:function(var source:virtualwindow;x,y:LongInt):word;
     GetClippedPixel:function(var source:virtualwindow;x,y:LongInt):Word;
     LineHorz:procedure(var dest:virtualwindow;x1,x2,y:LongInt;Color:Word);
     LineVert:procedure(var dest:virtualwindow;x,y1,y2:LongInt;color:word);

     Bar:procedure(var dest:VirtualWindow;x1,y1,x2,y2:longint;color:word);

 Procedure PutTransPixel(var dest:virtualwindow;x,y:longint;color:word;strength:Byte);
 PROCEDURE Line(var dest:virtualwindow;x1,y1,x2,y2:LongInt;color:word);
 PROCEDURE LineClipped(var dest:virtualwindow;x1,y1,x2,y2:LongInt;Farbe:word);
 PROCEDURE LineSlow   (var dest:virtualwindow;x1,y1,x2,y2:Longint;Farbe:Word);
 procedure LineThick(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;ending:byte;color:word);
 {ENDING: 0=no round endpoints,     1=round endpoint on start
          2=round endpoint on end,  3=both endpoints are round}
 procedure FastLineThick(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;ending:byte;color:word);


 procedure LineThickWithMask(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;mask,color:word);
 procedure LineThickWithMask(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;mask:word;ending:byte;color:word);


 Procedure LineWithMask(var dest:virtualwindow;x1,y1,x2,y2:Longint;Mask,Color:Word);
 PROCEDURE LineSmooth(var dest:virtualwindow;x1,y1,x2,y2:LongInt;color:Word;factor:byte);
 PROCEDURE Rectangle(var dest:virtualwindow;x1,y1,x2,y2:LongInt;c:Word);
 PROCEDURE Rectangle(var dest:virtualwindow;x1,y1,x2,y2:LongInt;t:byte;mask,c:Word);
 Procedure Triangle(var dest:virtualwindow;x1,y1,x2,y2,x3,y3:longint;color:word);
 Procedure FilledTriangle(var dest:virtualwindow;x1,y1,x2,y2,x3,y3:longint;color:word);
 Procedure Polygon(var dest:virtualwindow;p:PolyType;color:word);
 Procedure Polygon(var dest:virtualwindow;p:PolyType;t:byte;mask,color:word);
 Procedure FilledPolygon(var dest:virtualwindow;p:PolyType;t:byte;mask,color1,color2:word);
 Procedure FilledPolygon(var dest:virtualwindow;p:PolyType;color1,color2:word);

(*{}{}{}{} Procedure Bar(var dest:virtualwindow;x1,y1,x2,y2:longint;c:word);
 Procedure Bar(var dest:virtualwindow;x1,y1,x2,y2:longint;c:word);*)

 Procedure Floodfill(dest:virtualwindow;x,y:longint;color,border:word);
 Procedure Floodfill(dest:virtualwindow;x,y:longint;color:word);

 Procedure Inversion(var dest:VirtualWindow;x1,y1,x2,y2:longint);

 Procedure Circle(var dest:virtualwindow;x0,y0,Radius:LongInt;c:Word);
 Procedure Circle(var dest:virtualwindow;x0,y0,Radius:LongInt;t:byte;c:Word);
 Procedure FilledCircle(var dest:virtualwindow;x0,y0,Radius:LongInt;c,d:Word);
 Procedure FilledCircle(var dest:virtualwindow;x0,y0,Radius:LongInt;t:byte;c,d:Word);
 procedure Ellipse(var dest:virtualwindow;x0,y0,radiusX,radiusY:longint;c:word);
 procedure Ellipse(var dest:virtualwindow;x0,y0,radiusX,radiusY:longint;t:byte;c:word);
 Procedure FilledEllipse(var dest:virtualwindow;x0,y0,RadiusX,RadiusY:longint;c,d:word);
 Procedure FilledEllipse(var dest:virtualwindow;x0,y0,RadiusX,RadiusY:longint;t:byte;c,d:word);
 Procedure Sector(var dest:virtualwindow;x,y,xr,yr,zacatek,konec:longint;c:word);
 Procedure Arc(var dest:virtualwindow;x,y,xr,yr,zacatek,konec:longint;c:word);
 Procedure PieSlice(var dest:virtualwindow;x,y,xr,yr,zacatek,konec:longint;c,d:word);
 Procedure PieSlice3D(var dest:virtualwindow;x,y,xr,yr,h,zacatek,konec:longint;c,d:word);
 Procedure RoundBar(var dest:virtualwindow;x1,y1,x2,y2,r:longint;c,d:word);
 Procedure RoundRect(var dest:virtualwindow;x1,y1,x2,y2,r:longint;c:word);
 procedure ComputeRotatedEllipse(var p:PolyType;x,y,a,b,uhel,extra:longint);
 procedure ComputeRotatedArc(var p:PolyType;x,y,a,b,uhel,zacatek,konec,extra:longint);
 Procedure RotatedEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;c:word);
 Procedure RotatedEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;t:byte;c:word);
 Procedure RotatedFilledEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;t:byte;c,d:word);
 Procedure RotatedFilledEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;c,d:word);
 Procedure RotatedChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;c:word);
 Procedure RotatedChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;t:byte;c:word);
 Procedure RotatedFilledChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;c,d:word);
 Procedure RotatedFilledChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;t:byte;c,d:word);
 Procedure RotatedPieSlice(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;c,d:word);
 Procedure RotatedNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;c:word);
 Procedure RotatedNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;t:byte;mask,c:word);

 {Draws regular N-agon (pentagon,hexagon,etc.) with size R and rotation UHEL}
 Procedure RotatedFilledNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;c,d:word);
 Procedure RotatedFilledNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;t:byte;mask,c,d:word);
 const rotate_granularity:byte = 4;
       {The higher number the more rough Rotated primitives will be but the
        drawing will be faster. It looks good approximately until 20.
        Note: Values higher than 127 have special meaning (see RotatedNShape)}


 FUNCTION  CalculateLine      (x1,y1,x2,y2:LongInt):LongInt;
 FUNCTION  CalculateDetailLine(x1,y1,x2,y2:LongInt):LongInt;

 Procedure Init_Poly(var poly:PolyType;s:string);
 {example: Init_Poly(p,'10,10,400,80,200,290')}
 Procedure Kill_Poly(var poly:PolyType);

{----------------------------- ALPHA ROUTINES -------------------------------}

 PROCEDURE Alpha(dest,X,Y : Longint; r,g,b : shortint);
 PROCEDURE AlphaLight(var dest:virtualwindow;X,Y : Longint; r,g,b : Word);
 PROCEDURE AlphaLightClipped(var dest:virtualwindow;X,Y : Longint; r,g,b : Word);
 PROCEDURE AlphaLightLine(var dest:virtualwindow;x1,y1,x2,y2:LongInt;r,g,b:Word);
 PROCEDURE AlphaLightHORZLine(var dest:virtualwindow;X,Y,X2 : Longint; r,g,b : Word);

{------------------------------- Image loaders ------------------------------}
 {Here is only loader for BMP files. Another image formats can be loaded by
  addon units like VNM_GIF or VNM_PNG                                      }

 Function Load_Image(s:string;var v:virtualwindow):byte;
 {General image loader for any graphics format. It analyses filename extension
  and calls proper specific loader for it. Here in VenomGFX is only one
  specific loader - Load_BMP. All other loaders are in separete units.
  All you have to do is inlude the desired loader unit in "uses" statement in
  your main program. This will cause that Venom_GFX "learns" how to handle
  such image format.}


 const {constants for results of "Load_Image" function}
       LI_ok = 0;       {everything OK}
       LI_bad = 255;    {file extension not specified, can't determine loader}
       LI_ext = 254;    {unregistered file extension}
       {all other error codes are reserved for specific image loaders}

 Function Load_BMP(s:string;var v:virtualwindow):byte;

 Function _Load_BMP(h:PStream;var v:virtualwindow):byte;
 {more or less internal routine but exported here as is used by alternate
  JPG loader which is in addon unit}

 Function Save_BMP(var v:virtualwindow;s:string):boolean; { Saves into BMP}

{----------------------------- SPRITE Routines ------------------------------}

 Procedure Clr(var dest:virtualwindow;Color:Word);


 PROCEDURE Scroll(var Source,dest:virtualwindow;x,y:LongInt);

 Procedure PutSpriteRegion(var dest,source:virtualwindow;x1,y1,x2,y2,dstx,dsty:longint);
 PROCEDURE Syntesis(var Dest,Source,Mapa:VirtualWindow;c:word);
 { If Mapa^=c then Dest^:=Source^ else Dest^:=Mapa^ }


 {-----THIS SET OF SPRITE FUNCTIONS WORKS ALSO FOR BANKED VGA SCREENS--------}
 PROCEDURE PutHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
 {as transparent color SPRITE.TransCol will be used}
 PROCEDURE PutHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);
 {as transparent color HideColor will be used}
 PROCEDURE PutClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
 {as transparent color SPRITE.TransCol will be used}
 PROCEDURE PutClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);
 {as transparent color HideColor will be used}
 Procedure PutSprite_and_clear(var Dest, Sprite:VirtualWindow;x,y:longint;c:word);
 {although not in name but this procedure is clipped}

 PROCEDURE PutSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
 PROCEDURE GetSprite(var Source,Sprite:VirtualWindow;x,y:LongInt);
 PROCEDURE PutClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
 PROCEDURE GetClippedSprite(var source,sprite:VirtualWindow;x,y:LongInt);
 {Paste (get) sprite to (from) screen}
 PROCEDURE GetHCSprite(var source:virtualwindow;Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);
 {Paste (get) sprite to (from) screen but ignore color Hidecolor}
 PROCEDURE GetClippedHCSprite(var source:virtualwindow;Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);


 PROCEDURE PutViewportClippedSprite(var Dest:virtualwindow;x1,y1,x2,y2:longint;Sprite:VirtualWindow;x,y:LongInt);


 Procedure MoveSprite(var Dest,Sprite,BackSpr:VirtualWindow;ox,oy,x,y:longint);
 {Moves SPRITE from position OX,OY into new position X,Y. Automaticly handles
  the background update. BACKSPR has to be filled with proper background and
  in procedure is properly updated}

 Procedure MoveSprite_with_bigbuffer(var Dest,Sprite,Backbuf:VirtualWindow;ox,oy,x,y:longint);
 {Similar to previous procedure but in this variant in BACKBUF has to be
  stored not only Sprite background but background of whole screen

  This procedure is faster than previous one but needs more memory.}
 {---------------------------------------------------------------------------}
 {---------------------------------------------------------------------------}

 {---------------------SPRITE FUNCTIONS WITH EFECTS (NOT FOR BANKED VGA)-----}
 PROCEDURE PutBrightSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rBright,gBright,bBright:ShortInt);
 {Before pasting into screen in/de-creases the RGB composites of SPRITE by
  rBright, gBright and bBright}
 PROCEDURE PutBrightClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rBright,gBright,bBright:ShortInt);
 PROCEDURE PutBrightHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rBright,gBright,bBright:ShortInt);
 PROCEDURE PutBrightClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rBright,gBright,bBright:ShortInt);


 PROCEDURE PutTransSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rLight,gLight,bLight:Byte);
 {Before pasting into screen decreases the RGB composites of SCREEN by
  rLight, gLight and bLight}
 PROCEDURE PutTransClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rLight,gLight,bLight:Byte);
 PROCEDURE PutTransHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rLight,gLight,bLight:Byte);
 PROCEDURE PutTransClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rLight,gLight,bLight:Byte);


 PROCEDURE PutAlphaSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
 {Same result as PutTransSprite(Dest,Sprite,x,y,0,0,0)}
 PROCEDURE PutAlphaClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
 PROCEDURE PutAlphaHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);
 PROCEDURE PutAlphaClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);


 PROCEDURE FadeSprite(var Source, dest:virtualwindow);

 FUNCTION  ScaleSprite(var SourSprite:VirtualWindow;Breite,Hoehe:LongInt):VirtualWindow;
 FUNCTION SmoothScaleSprite2(var SourSprite:VirtualWindow;Breite,Hoehe:LongInt):VirtualWindow;

 PROCEDURE AdjustSpriteLightness    (var SourSprite:VirtualWindow;r,g,b:ShortInt               );
 PROCEDURE AdjustSpriteHCLightness  (var SourSprite:VirtualWindow;r,g,b:ShortInt;HideColor:Word);

 Procedure DecreaseSpriteLightness(var sprite:virtualwindow;r,g,b:longint);
 {supports MMX}
 PROCEDURE IncreaseSpriteLightness(var sprite:virtualWindow;r,g,b:longint);
 {supports MMX}

 Function AverageSprites(var src1,src2:virtualwindow):virtualwindow;
 Function DifferenceSprites(var src1,src2:virtualwindow):virtualwindow;
 Function Is_Bitmap_Empty(var p;size:longint):boolean;
 Procedure Desaturation(var cil:virtualwindow;hodnota,hodnota2:real);
 Procedure MakeSpriteMap(var sour:virtualwindow;var buffer;c:word);
 Procedure RoundWave(Src,dsst:VirtualWindow;x,y,z:real);
 {src and dsst should have the same size. Nice results gives f.e.
  RoundWave(v,w,40,77,38);}
 procedure SquareWave(Src,Dst:Virtualwindow;x,y,z:real);
 {src and dst should have the same size. Nice results gives f.e.
  SquareWave(v,v2,80,17,11)   or    SquareWave(v,v2,6,87,18)}
 PROCEDURE CopySprite(var Sour, dest:virtualwindow);
 {Dest must be prepared and the same size as Sour. Only bitmap is copied}
 Procedure DuplicateSprite(source:virtualwindow;var dest:virtualwindow);
 {Dest is newly created and has all features like SOURCE}
 Function Rotate180(var source:virtualwindow):VirtualWindow;
 Function Rotate90p(var source:virtualwindow):VirtualWindow;
 Function Rotate90m(var source:virtualwindow):VirtualWindow;
 Function FlipHorz(var source:virtualwindow):VirtualWindow;
 Function FlipVert(var source:virtualwindow):VirtualWindow;

 { Original Venom's VERY FAST routines which scales and rotates a sprite at the same time !!! }
 PROCEDURE Rotate_Scale_Sprite  (var Sour, dest:virtualwindow;x,y,Breite,Hoehe,Winkel:LongInt);
 PROCEDURE Rotate_Scale_SpriteHC(var Sour, dest:virtualwindow;x,y,Breite,Hoehe,Winkel:LongInt;Hcolor:Word);

 {-------------------------------- TEXT OUTPUT ------------------------------}
 Procedure OutText(var virt:Virtualwindow;x,y:longint;s:string;color:word);
 {basic procedure for writting texts. Uses font set by SetFontStyle}

 Procedure SetFontStyle(rez:string;velikost:byte);
 Procedure SetFontStyle(rez:string;velikost,flags:byte);
 {REZ can be "vga" for VGA charset or some font file located on disk.
  For VGA charset fonts I recomend to use the FLAGS modificator "prop_fn"
  (it forces the propotional variant of VGA font)}

 Function GetTextSize:byte;
 Function Get_Pointer_To_Downloaded_VGA_fonts(size:byte):pointer;
 {For internal use in addon units. POINTER is in the fact the PZnaky256 object
  as defined in VNMFNHLP unit. The font is unproporcional}


 Procedure Kill_Font(font:string);
 {deletes font from memory}

 var PutChar_FN:function(var dest:virtualwindow;p:pointer;x,y,xd,yd:longint;charbytes:byte;c:word):byte;
 {this  is meaned as internal and will be used from internal routines or from
  extending unit FONTY or FNFONT2}
 {---------------------------------------------------------------------------}


 { Miscellaneous routines used in my old projects.                           }
 { They are not maintained anymore                                           }
 Procedure Fade_SVGA(a:byte);
 { fade screen in bank mode }
 Procedure SetWholePalette(var p:palette);
 { for 256c modes. sets palette }
 Procedure SetPaletteEntry(c,r,g,b:byte);
 { for 256c modes. sets register in palette }
 Function FindPaletteEntry(var p:palette;r,g,b:byte;var v:byte):boolean;
 { for 256c modes. searches RGB color in palette }
 Procedure HicolorTo256(zdroj:virtualwindow;var cil:virtualwindow;var pal:palette);
 { for 256c modes. converts sprite to 256 colors }
 Procedure GetSprite256(zdroj,cil:virtualwindow;x,y:longint);
 { for 256c modes. reads sprite to 256 colors format }
 Procedure ReplaceColor256(zdroj:virtualwindow;o,n:byte);
 { for 256c modes. replaces color O to color N }
 {---------------------------------------------------------------------------}

 Procedure SaveVGAPalette;

{============================================================================}


var Locked_interface_data_end:byte;        {DO NOT MOVE THIS DECLARATION!}

IMPLEMENTATION
uses GO32,DOS,VenomMng,VnmFnHlp,GRPfile{$IFNDEF SIMPLIER_GTF_CALC},VenomGTF{$ENDIF};


var Locked_implementation_data_start:byte; {DO NOT MOVE THIS DECLARATION!}

const
      protected_vesa_interface:boolean = false;
      char_generator_hooked:boolean = false;

      UNDEFINED_BANK = 20000;

type
BMP_header = packed record
{00}         magic:word;
{02}         sizebmp:longint;
{06}         reserved:longint;
{10}         offset_to_data:longint;
{14}         header_size:longint;
{18}         width:longint;
{22}         height:longint;
{26}         numplanes:word;
{28}         bits_per_pixel:word;
{30}         compressed:longint;
{34}         sizeimage:longint;
{38}         xres:longint;
{42}         yres:longint;
{46}         clrused:longint;
{50}         clrimportant:longint;{ve Windows je pouzito pro rotaci barev }
             end;                 {pri zobrazovani animovaneho loga. Pokud=0,}
                                  {tak jsou vsechny barvy staticke. pokud=1,}
                                  {je staticka jenom 0, pokud=2, jsou staticke}
                                  {0 a 1 a ostatni se cykli, atd...}

WordArray = array[0..65535] of word;
fillstacktype=array[1..16384] of longint;


var
     Regs                : TRealRegs;
     SelectedMode        : Word;
     Manual_freq         : boolean;
     xpos1,ypos1         : Word;
     xpos2,ypos2         : Word;
     Old_cs,_cs,TextSize : Word;
     MouseHandlerInstalled: Boolean;   {je instalovan handler mysi?}
     timer_installed     : boolean;
     timer_busy          : boolean;
     pag_color           : longint;
     fillstack           :^fillstacktype;
     fstop               : longint;        {pro FloodFill}
     fontvw              : virtualwindow;
     ScanLine            : array[0..4096{max posible X-resolution}] of word;
     Texture             : PVirtualWindow; {pro texturovane cary}
     font_last_bitmap    : pointer;
     Font_horiz_clip     : byte;
     ActualCharset       :pointer;  {ukazatel na aktualni variantu VGA fontu}
     ActualCharsetHigh   :byte;     {velikost aktualniho VGA fontu}
     ActualCharsetProp   :boolean;  {je aktualni VGA font proporcionaln?}
     ActualLineMode      : byte;

     is_vga_from_charset_prepared:boolean;
     vga8charset:TZnaky256;     {trvale ulozeni VGA8 (nacte se pri initu)}
     vga14charset:TZnaky256;    {trvale ulozeni VGA14}
     vga16charset:TZnaky256;    {trvale ulozeni VGA16}

     ready_vga_proportional_8:boolean;
     ready_vga_proportional_14:boolean;
     ready_vga_proportional_16:boolean;

     prop_vga_charset:PZnaky256;
     prop_vga_8,prop_vga_14,prop_vga_16:PZnaky256;

     _MOUSEDEF,_MOUSECLK,_MOUSEHND:virtualwindow;

     InternalPutPixel:procedure(var Dest:VirtualWindow;x,y:LongInt;Color:Word);
     {used in more high level functions like circles and ellipses}


     LinePosition        : Array[0..2000] of LongInt;

            VesaModeInfo : packed Record
                { 0}        Modus_Attribute      : Word;
                { 2}        WinA_Attr            : Byte;
                { 3}        WinB_Attr            : Byte;
                { 4}        Granularitaet        : Word;
                { 6}        Fenster_Groesse      : Word;
                { 8}        Seg_Fenster_A        : Word;
                {10}        Seg_Fenster_B        : Word;
                {12}        BankRoutine          : Pointer;
                {16}        BytesPerScanline     : Word;
                {18}        HAufloesung          : Word;
                {20}        VAufloesung          : Word;
                {22}        Videozellen_Breite   : Byte;
                {23}        Videozellen_Hoehe    : Byte;
                {24}        Anz_Speicherplanes   : Byte;
                {25}        Bpp                  : Byte;
                {26}        Raster_Banks         : Byte;
                {27}        Speicherorganisation : Byte;
                {28}        Groesse_RasterBanks  : Byte;
                {29}        Video_Pages          : Byte;
                {30}        Reserviert           : Byte;
                {31}        Red_Mask_Size        : Byte;
                {32}        Red_Mask_Field       : Byte;
                {33}        Green_Mask_Size      : Byte;
                {34}        Green_Mask_Field     : Byte;
                {35}        Blue_Mask_Size       : Byte;
                {36}        Blue_Mask_Field      : Byte;
                {37}        Reserved_Mask_Size   : Byte;
                {38}        Reserved_Mask_Field  : Byte;
                {39}        Direct_Color_Organi  : Byte;
                            { VESA 2.0   }
                {40}        LFB_Adresse          : Dword;
                {44}        reserved1            : longint;
                {48}        reserved2            : word;
                            { VESA 3.0   }
                {50}        LinBytesPerScanLine     : word;
                {52}        BnkNumberOfImagePlanes  : byte;
                {53}        LinNumberOfImagePlanes  : byte;
                {54}        LinRedMaskSize          : byte;
                {55}        LinRedMaskPosition      : byte;
                {56}        LinGreenMaskSize        : byte;
                {57}        LinGreenMaskPosition    : byte;
                {58}        LinBlueMaskSize         : byte;
                {59}        LinBlueMaskPosition     : byte;
                {60}        LinRSVDmaskSize         : byte;
                {61}        LinRSVDfieldPosition    : byte;
                {62}        MaxPixelClock           : longint;
                {63}        reserved                : array[0..182] of byte;
                            { neni soucasti standardu VESA - to jsou jen moje pracovni udaje ! }
                            LFB_Supported        : Boolean;
                            Banks                : Byte;
                            BSize {=BankByteSize}: LongInt;
                            End;

vbPMI: pointer;                {Protected mode interface}
vbPMIsize: longint;            {Size of pmode interface}
vbPMFSeg: word;                {Selector required for PMode functions}
vbPMISetWindow: pointer;       {Pointer to setWindow function}
vbPMISetDisplayStart: pointer; {Pointer to setDisplayStart function}

CRTCInfoBlock : packed record
HorizontalTotal:word;
HorizontalSyncStart:word;
HorizontalSyncEnd:word;
VerticalTotal:word;
VerticalSyncStart:word;
VerticalSyncEnd:word;
Flags:byte;
PixelClock:dword;    { units of Hz }
RefreshRate:word;    { units of 0.01 Hz }
reserved:array[0..39] of byte;
end;


bank_internal:record
    xxx,zzz,bank2,zbytek2,lines,bank_ecx,
    bank_edi:longint;
    mem_offset:longint;
    zapis:longint; {jsou inicializovany ve VENOMGFX.PAS}
    hc:word;
    grann               : longint;  {pro bankovani - granularita }
    bank_rd,bank_wr     : longint;  {prave pouzivany cteci a zapisovaci bank}
    numm                : longint;  {pocet banku }
    firstbank           : longint;
    firstblockpos       : longint;
    firstblocksize      : longint;
    lastblocksize       : longint;
    _bisgm,bisgm        : longint;  {nejvyssi zobrazitelny bank}
    seg_wr,seg_rd       : longint;  {segments of read and write access}
                                     {in banked videomodes}
    win_wr,win_rd       : byte;     {ktere okno pouzit pro cteni a pro zapis}
    internal32_0,internal32_1:longint; {pro pouziti specialnimi ovladaci}
    SetBank_wr,SetBank_rd:pointer;  {pointer na proceduru prepnuti banku}
    {procedures for setting the write and read banks in banked modes}
    end;


ArcCall:record
  X,Y,XStart,YStart,XEnd,YEnd:longint;
  ellipsescan:procedure(var dest:virtualwindow;x1,x2,y:longint;c,d:word);
  result:byte;
  end;

{$include VENOMDDC.INC}
my_ddc     : VESA_EDID;
ddc_support: boolean;
{--------------------------- MOUSE VARIABLES ----------------------------}

mouse_regs    : trealregs; external name '___v2prt0_rmcb_regs';
mouse_seginfo : tseginfo;
mystack:pointer;
oldss,oldsp:longint;

mouse_internal:record
backup_ds:word;
end;

oldint1c : tseginfo;
newint1c : tseginfo;
int1c_ds : Word; external name '___v2prt0_ds_alias';

mouse_driver_installed: longbool;


Locked_implementation_data_end:byte; {DO NOT MOVE THIS DECLARATION!}


{-Forward procedures--------------------------------------------------------}

 {internals}
 Procedure SetLFBmodeVariables;forward;
 Procedure SetBankmodeVariables;forward;
 Procedure Clear_Graphics_variables;forward;
{---------------------------------------------------------------------------}

Function FromTimer:dword;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
asm
mov eax,fs:[$400+$6c]
end;


Function TimerTicksFrom(last,d:dword):boolean;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{Similar like "if FromTimer>last+d then true" but solves problem with}
{Timer wrapping on MaxDword value}
{DESTROYS: NONE (only return value into EAX)}
asm
push ecx
push ebx

call FromTimer     {FromTimer je ted v EAX}
mov ecx,eax        {a ted v ECX}
xor eax,eax
mov ebx,last       {Minula hodnota timeru je ted v EBX}

cmp ecx,ebx
jb @interval_uplynul  {osetri wrapping - nedodrzi vsak interval}

add ebx,d          {EBX:=Last+D}
cmp ecx,ebx
jb @je_mensi

@interval_uplynul:
inc eax

@je_mensi:

pop ebx
pop ecx
end;


Function MemB(segm,offs:word):byte;assembler;
asm
movzx ebx,segm
shl ebx,4
movzx eax,offs
add ebx,eax
mov al,fs:[ebx]
end;

Function RMString(segm,offs:word;len:byte):string;
var a:longint;
    s:string;
begin
s:='';
for a:=0 to len-1 do s:=s+char(MemB(segm,offs+a));
RMstring:=s;
end;


Function UpString(s:string):string;
var a:byte;
begin
for a:=1 to Length(s) do s[a]:=UpCase(s[a]);
UpString:=s;
end;


PROCEDURE Init_Textmode;assembler;
asm
mov ax,4f02h
mov bx,3
int 10h
mov ax,3
int 10h
End;


FUNCTION Get_CPU:Boolean;
VAR CPUResult    : Byte;
    VendorString : Array[0..11] of Char;
    brand_id     : longint;
    is_brand_string:boolean;
    b,a:byte;
    p:pchar;
    s:string;

Begin
 CPU_Info_Vendor  := 'unknown';
 CPU_Brand_String := 'unknown';
 is_brand_string  := false;
 p:=@s;
 ASM
  Mov CPU_Info_Familie     ,7        { Infos auf default setzen }
  Mov CPU_Info_Modellnummer,$FF
  Mov CPU_Info_Stepping_ID ,$FF
  Mov CPU_Info_MMX         ,0
  Mov CPU_Info_FPU         ,0
  Mov CPU_Info_SSE         ,0
  Mov CPU_Info_SSE2        ,0
  Mov CPU_Info_CMOV        ,0
  Mov CPU_Info_3DNOW       ,0


  PushfD                             {je vubec instrukce CPUID podporovana?}
  Pop eax                            {A mame instalovane alespon pentium?}
  Bt eax,21
  Setc dl
  Btc eax,21
  Push eax
  PopfD

  PushfD
  Pop eax
  Bt eax,21
  Setc cl

  Mov CPUResult,0

  Cmp dl,cl
  Je @Ende                           {Ne? Tak jdeme pryc}
  Mov CPUResult,1                    {Ano? Budeme pokracovat}

  Xor eax,eax                        {EAX=0/CPUID}
  CPUID
  Lea esi,VendorString               {Zpracovani retezce VendorString}
  Mov [esi  ],ebx
  Mov [esi+4],edx
  Mov [esi+8],ecx

  Cmp EAX,1                          {Lze volat CPUID s volacim parametrem 1?}
  Jb @Ende                           {Ne? konec}

  Mov eax,1
  CPUID                              {CPUID pri EAX=1 --> zakladni info}
  Bt edx,23
  Setc CPU_Info_MMX                  {MMX?}

  Bt edx,25
  Setc CPU_Info_SSE                  {SSE?}

  Bt edx,26
  Setc CPU_Info_SSE2                 {SSE2?}

  Bt edx,0
  Setc CPU_Info_FPU                  {FPU?}

  bt edx,15
  Setc CPU_Info_CMOV                 {CMOVx?}
  and ebx,0ffh
  mov brand_id,ebx
  Mov ebx,eax

  And eax,1111b                      {bity pro urceni Stepping_Id}
  Mov CPU_Info_Stepping_Id,al
  Mov eax,ebx

  Shr eax,4                          {bity pro urceni Modelu}
  And eax,1111b
  Mov CPU_Info_Modellnummer,al
  Mov eax,ebx

  Shr eax,8                          {bity pro urceni Rodiny(family)}
  And eax,1111b
  Mov CPU_Info_Familie,al

  Mov eax,80000000h
  CPUID
  cmp eax,80000001h
  jb @ende

  push eax
  Mov eax,80000001h                  {Rozsirene CPUID info}
  CPUID
  Bt edx,31
  Setc CPU_Info_3DNOW                {3DNow?}
  pop eax

  cmp eax,80000004h
  jb @ende

  mov esi,p
  inc esi
  mov is_brand_string,1
  Mov eax,80000002h
  CPUID
  mov [esi],eax
  mov [esi+4],ebx
  mov [esi+8],ecx
  mov [esi+12],edx
  add esi,16

  Mov eax,80000003h
  CPUID
  mov [esi],eax
  mov [esi+4],ebx
  mov [esi+8],ecx
  mov [esi+12],edx
  add esi,16

  Mov eax,80000004h
  CPUID
  mov [esi],eax
  mov [esi+4],ebx
  mov [esi+8],ecx
  mov [esi+12],edx
  @Ende:
 END;

CPU_Info_Vendor:= VendorString;

if is_brand_string then
   for b:=47 downto 0 do if p[b]<>#0 then Break;  {koncovy znak}
       if b=0 then is_brand_string:=false else
          for a:=b downto 0 do if p[a]=#0 then
              begin
              inc(p,a+1);
              Break;
              end;

if is_brand_string then
   begin
   s:=p;
   while s[length(s)]=' ' do dec(s[0]);
   if s<>'' then
      begin
      while s[1]=' ' do delete(s,1,1);
      if s[2]=' ' then delete(s,1,1);
      while s[1]=' ' do delete(s,1,1);
      if s<>'' then CPU_Brand_String:=s;
      end;
   end;

if is_brand_string=false then
   begin
   case CPU_Info_Familie of
   3      : CPU_Brand_String:='80386';
   4      : CPU_Brand_String:='80486';
   5      : CPU_Brand_String:='Pentium (TM) class processor';
   6      : case CPU_Info_Modellnummer of
            0,1:CPU_Brand_String:='Pentium Pro class processor';
            3,5,6:CPU_Brand_String:='Pentium II class processor';
            7,8,$a,$b:CPU_Brand_String:='Pentium III class processor';
            else CPU_Brand_String:='Processor based on P6 core';
            end;{case}
   End;
   end;
Get_CPU:= Boolean(CPUResult);
End;


Function IF_PCI_BIOS:boolean;
begin
regs.ax:=$b101;
regs.di:=0;
Intr($1a,regs);
IF_PCI_BIOS:=regs.dx=$4350; {edx=$20494350}
end;


Function Read_SVGA_PCI_data(device_ID,vendor_id:word):boolean;
begin
with regs do begin
  ax:=$b102;
  cx:=device_id;
  dx:=vendor_id;
  si:=0;
end;
Intr($1a,regs);
if regs.ah=0 then
   begin
   SVGA_pci_config.bbus:=regs.bh;
   SVGA_pci_config.bdev:=regs.bl shr 3;
   SVGA_pci_config.bfunc:=regs.bl and 7;
   SVGA_pci_config.vendor_id:=vendor_id;
   SVGA_pci_config.device_id:=device_id;
   end;
Read_SVGA_PCI_data:=regs.ah=0;
end;


Function Read_SVGA_PCI_cfg_byte(reg:word):byte;
begin
regs.ax:=$0b108;
regs.bh:=SVGA_pci_config.bBus;
regs.bl:=(SVGA_pci_config.bDev shl 3) or SVGA_pci_config.bFunc;
regs.di:=reg;
intr($1a,regs);
Read_SVGA_PCI_cfg_byte:=regs.cl;
end;


Function Read_SVGA_PCI_cfg_word(reg:word):word;
begin
regs.ax:=$0b109;
regs.bh:=SVGA_pci_config.bBus;
regs.bl:=(SVGA_pci_config.bDev shl 3) or SVGA_pci_config.bFunc;
regs.di:=reg;
intr($1a,regs);
Read_SVGA_PCI_cfg_word:=regs.cx;
end;



Function Read_SVGA_PCI_cfg_dword(reg:word):dword;
var d:dword;
begin
asm
mov ax,0b10ah
mov bh,SVGA_pci_config.bBus
mov bl,SVGA_pci_config.bDev;shl bl,3;add bl,SVGA_pci_config.bFunc
mov di,reg
int 1ah
mov d,ecx
end;
Read_SVGA_PCI_cfg_dword:=d;
end;


Procedure Write_SVGA_PCI_cfg_dword(reg:word;data:dword);
begin
asm
mov ax,0b10Dh
mov bh,SVGA_pci_config.bBus
mov bl,SVGA_pci_config.bDev;shl bl,3;add bl,SVGA_pci_config.bFunc

mov ecx,data
mov di,reg

int 1ah
end;
end;



Function Decode_SVGA_PCI_BAR_size(reg:word):dword;
var o,a:dword;
begin
o:=Read_SVGA_PCI_cfg_dword(reg);
Write_SVGA_PCI_cfg_dword(reg,$FFFFFFFF);
a:=Read_SVGA_PCI_cfg_dword(reg);
Write_SVGA_PCI_cfg_dword(reg,o);
a:=a and $FFFFFFF0;
a:=not(a);
inc(a);
Decode_SVGA_PCI_BAR_size:=a;
end;


Procedure Get_SVGA;
var pci:word;
    ven,dev:word;
begin
FillChar(SVGA_pci_config,SizeOf(SVGA_pci_config),0);
pci:=word(MemB($C000,$18))+word(MemB($C000,$19))*256;
if RMstring($C000,pci,4)='PCIR' then
   begin
   ven:=word(MemB($C000,pci+4))+word(MemB($C000,pci+5))*256;
   dev:=word(MemB($C000,pci+6))+word(MemB($C000,pci+7))*256;
   if If_PCI_BIOS then
      if Read_SVGA_PCI_data(dev,ven) then
         begin
         SVGA_pci_config.LFB:=Read_SVGA_PCI_cfg_dword($14) and $FFFFFFF0;
         SVGA_pci_config.MMIO:=Read_SVGA_PCI_cfg_dword($10) and $FFFFFFF0;
         SVGA_pci_config.IRQ:=Read_SVGA_PCI_cfg_byte($3c);
         SVGA_pci_config.headertype:=Read_SVGA_PCI_cfg_byte($0e) and 3;
         SVGA_pci_config.LFB_size:=Decode_SVGA_PCI_BAR_size($14);
         SVGA_pci_config.MMIO_size:=Decode_SVGA_PCI_BAR_size($10);
         end;
   end;
end;


Function Get_Windows_version:byte;assembler;
{DOS=0, Win 3.x=1, Win9x=2, Win NT/2K/XP...=3}
asm
              mov    ax,160Ah
              int    2fh
              or     ax, ax
              jne    @NoWin95    {volani nepodporovano - DOS nebo WinNT}
              cmp    bx, 0395h   {starsi nez Win95?}
              jae    @Win3
	      mov    al, 1
	      jmp    @Done	 { Win 3.1 }
@Win3:        cmp    bh, 3       { Win 95 oder 98 }
              jz     @Win95
              cmp    bh, 4       { Win 95 oder 98 }
              jnz    @NoWin95
@Win95:       mov    al, 2
	      jmp    @Done       { Win 95/98/ME }
@NoWin95:     mov    ax, $3306   { Get True Version Number }
              int    $21
              cmp    bx, $3205   { Win NT/2000 DOS Box }
              jne    @NoWin
              mov    al,3
              jmp    @Done
@NoWin:
              mov al,0
@Done:
end;



PROCEDURE Error(SourceText1,SourceText2:String);
Begin
 INIT_TEXTMODE;
 write(SourceText1);
 writeln(SourceText2);
 Halt;
End;


PROCEDURE EnoughMemoryOf(Zeiger:Pointer;Memory:LongInt);
Begin
 If Zeiger=Nil then ERROR('Error ! Not enough memory for a coherent block of '+LongIntStr(Memory)+' Bytes !','');
End;


Procedure Word2RGB(w:word;var r,g,b:byte);
begin
b:=w and 31;
r:=w shr 11 and 31;
g:=w shr 5 and 63;
end;


{----------------------------- MONITOR --------------------------------------}


PROCEDURE SetBorderColor(Color:Byte);
Begin
 FillChar(Regs,SizeOf(Regs),0);
 regs.ax:= $1001;
 regs.bh:= color;
 If not RealIntr($10,Regs) then ERROR('Interrupt Error ! Setting border color failed','');
End;


FUNCTION GetBorderColor:Byte;
Begin
 FillChar(Regs,SizeOf(Regs),0);
 regs.ax:= $1008;
 If not RealIntr($10,Regs) then ERROR('Interrupt Error ! Reading border color failed','');
 GetBorderColor:= regs.bh;
End;



{----------------------------- CONVERSION -----------------------------------}

FUNCTION RealStr(RealZahl:Real;Vork,Nachk:Byte):String;
Begin
 RealStr:= '';
 Str(RealZahl:Vork:Nachk,RealStr);
End;


FUNCTION LongIntStr(LongIntZahl:LongInt):String;
Begin
 Str(LongIntZahl,LongIntStr);
End;


FUNCTION DezToHex(Wert:Word):String;
VAR      Wert2 : Array[0..3] of Char;
         kette:string;
         loop1,loop2:longint;
Begin
 For Loop1:=0 to 3 do Wert2[Loop1]:='0';
 Loop1:=3;
 REPEAT
  Loop2:=Wert-(Wert shr 4)*16;
  If Loop2<10 then Wert2[Loop1]:=chr(48+Loop2) else
  If Loop2> 9 then Wert2[Loop1]:=chr(55+Loop2);
  Wert:=Wert shr 4;
  dec(Loop1);
 UNTIL Wert=0;
 DezToHex:='$'+Wert2;
End;


FUNCTION DezToBin(Wert:Word):String;
var kette:string;
    loop1,loop2:longint;
Begin
 Loop1:=Wert;
 Kette:='';
 REPEAT
  If Loop1 mod 2 = 0 then Kette:='0'+Kette else Kette:='1'+Kette;
  Loop1:=Loop1 shr 1;
 UNTIL Loop1=0;
 If length(Kette)<8 then for Loop1:=1 to (8-length(Kette)) do Kette:='0'+Kette;
 DezToBin:=Kette;
End;



{----------------------------- GRAFIKROUTINEN -------------------------------}


FUNCTION GetDOSString(Adresse:LongInt):String;
VAR      StringBuffer : Array[1..256] of Char;
         loop1:byte;
         Kette:string;
Begin
 DOSMemGet(Word(Adresse shr 16),Word(Adresse),StringBuffer,SizeOf(StringBuffer));
 Loop1:=  1;
 Kette:= '';
 WHILE (StringBuffer[Loop1]<>#0) and (Loop1<Sizeof(StringBuffer)) do
 begin
  Kette:= Kette + StringBuffer[Loop1];
  Inc(Loop1);
 end;
 GetDOSString:= Kette;
End;


FUNCTION GetDOSWord(Adresse:LongInt):Word;
VAR      Wert : Word;
Begin
 DOSMemGet(Word(Adresse shr 16),Word(Adresse),Wert,SizeOf(Wert));
 GetDOSWord:= Wert;
End;


FUNCTION GetDOSByte(Adresse:LongInt):Byte;
VAR      Wert : Byte;
Begin
 DOSMemGet(Word(Adresse shr 16),Word(Adresse),Wert,Sizeof(Wert));
 GetDOSByte:= Wert;
End;


Procedure CheckSpecificCards;
begin
if (pos('MACH64',vesa_vendor)<>0) or (pos('MACH64',vesa_productname)<>0)
   then SetupSpecificCard_ATIMach64;
end;

PROCEDURE ReadVesaBaseInfos;
VAR       LowMemPtr : LongInt;
          p:array[0..255] of byte;
          q:pchar;
Begin
 LowMemPtr:= Global_DOS_Alloc(512);       { Zeiger auf DOS Speicher }

 FillChar(VesaBaseInfo,SizeOf(VesaBaseInfo),0);
 VesaBaseInfo.Signatur[1]:= 'V';          { VBE 2.0 ist desired }
 VesaBaseInfo.Signatur[2]:= 'B';
 VesaBaseInfo.Signatur[3]:= 'E';
 VesaBaseInfo.Signatur[4]:= '2';

 DOSMemPut(Word(LowMemPtr shr 16),0,VesaBaseInfo,512);

 FillChar(Regs,SizeOf(Regs),0);           { Flag-Register lschen }
 Regs.eax := $4F00;                       { Interrupt-Registerwert setzen }
 Regs.es  := Word(LowMemPtr shr 16);
 Regs.edi := 0;
 RealIntr($10,Regs);                      { Graphikinterrupt 10h rufen }

 If (Regs.EAX and $4F) <> $4F then
 ERROR('Video Hardware Error ! Reading general VESA infos failed !','');
                                          { Generelle VESA Infos laden }
 DOSMemGet(Word(LowMemPtr shr 16),0,VesaBaseInfo,512);

 Global_DOS_Free(Word(LowMemPtr));        { Speicher wieder freigeben }

 If (VesaBaseInfo.Signatur[1]+VesaBaseInfo.Signatur[2]+VesaBaseInfo.Signatur[3]+VesaBaseInfo.Signatur[4])<>'VESA' then
 ERROR('Video Hardware Error ! VESA SVGA signature not found !','');

 If (VesaBaseInfo.VesaVersion[2]<1) or ((VesaBaseInfo.VesaVersion[2]=1) and (VesaBaseInfo.VesaVersion[1]<2)) then
 ERROR('Video Hardware Error ! VESA version 1.2 or higher is required !','Please download update your VESA version.');

 q:=@p;
 if VesaBaseInfo.OEM_ID <> 0 then
    begin
    seg_move(Segment_To_Descriptor(VesaBaseInfo.OEM_ID shr 16),
             VesaBaseInfo.OEM_ID and $FFFF,get_ds, longint(q), 256);
    VESA_vendor:=q;
    end ;

if VesaBaseInfo.VesaVersion[2]>1 then
   begin
   if VesaBaseInfo.Verleger <> 0 then
      begin
      seg_move(Segment_To_Descriptor(VesaBaseInfo.Verleger shr 16),
               VesaBaseInfo.Verleger and $FFFF,get_ds, longint(q), 256);
      VESA_vendorname:=q;
      end;
   if VesaBaseInfo.Produkt_ID <> 0 then
      begin
      seg_move(Segment_To_Descriptor(VesaBaseInfo.Produkt_ID shr 16),
               VesaBaseInfo.Produkt_ID and $FFFF,get_ds, longint(q), 256);
      VESA_productname:=q;
      end;
   end;
End;


PROCEDURE ReadVesaModeInfos(Mode:Word);
VAR       LowMemPtr : LongInt;
Begin
 LowMemPtr:= Global_DOS_Alloc(256);       { Zeiger auf DOS Speicher }

 FillChar(VesaModeInfo,SizeOf(VesaModeInfo),0);

 FillChar(Regs,SizeOf(Regs),0);           { Flag-Register lschen }

 Regs.es:= Word(LowMemPtr shr 16);        { Interrupt-Registerwert setzen }
 Regs.cx:= Mode;
 Regs.ax:= $4F01;
 RealIntr($10,Regs);                      { Graphikinterrupt 10h rufen }

 If (Regs.EAX and $4F) <> $4F then ERROR('Video Hardware Error ! Reading VESA mode infos failed !','');
                                          { Modusspezifische VESA Info laden }
 DOSMemGet(Word(LowMemPtr shr 16),0,VesaModeInfo,256);

 Global_DOS_Free(Word(LowMemPtr));        { Speicher wieder freigeben }
End;


Function GetGraphMode(mode:word):word;
VAR       LowMemPtr : LongInt;
Begin
 LowMemPtr:= Global_DOS_Alloc(256);       { Zeiger auf DOS Speicher }

 FillChar(VesaModeInfo,SizeOf(VesaModeInfo),0);

 FillChar(Regs,SizeOf(Regs),0);           { Flag-Register lschen }

 Regs.es:= Word(LowMemPtr shr 16);        { Interrupt-Registerwert setzen }
 Regs.cx:= Mode;
 Regs.ax:= $4F01;
 RealIntr($10,Regs);                      { Graphikinterrupt 10h rufen }

 If (Regs.EAX and $4F) <> $4F then ERROR('Video Hardware Error ! Reading VESA mode infos failed !','');
                                          { Modusspezifische VESA Info laden }
 DOSMemGet(Word(LowMemPtr shr 16),0,VesaModeInfo,256);

 Global_DOS_Free(Word(LowMemPtr));        { Speicher wieder freigeben }
End;


Function GetCurrentVideomode:word;
begin
FillChar(Regs,SizeOf(Regs),0);           { Flag-Register lschen }
regs.ax:=$4F03;
RealIntr($10,Regs);
if (Regs.EAX and $4f) <> $4f then ERROR('Error in exacuting VESA function 4f03h.','');
GetCurrentVideomode:=Regs.BX;
end;


Function GetRefreshRate:word;
begin
GetRefreshRate:=CRTCinfoblock.RefreshRate div 100;
end;


Function Find_mode(width,height:word):longint;
var segm,ofss,i:word;
    mode:array[0..255] of word;

begin
ReadVESAbaseInfos; {musi byt bezprostredne pred scanovanim videomodu protoze}
                   {vraceny odkaz na tabulku videomodu ma platnost jen do}
                   {pristiho volani nejake VESA sluzby}
segm := Segment_To_Descriptor(VesaBaseInfo.Videomodi shr 16);
ofss := VesaBaseInfo.Videomodi and $FFFF;
seg_move(segm, ofss, get_ds, longint(@mode), SizeOf(mode));
for i:=0 to 255 do
   if mode[i]=$FFFF then Exit(0) else
      begin
      ReadVESAmodeInfos(mode[i]);
      if (VESAMODEINFO.HAufloesung=width)
         and
         (VESAMODEINFO.VAufloesung=height)
         and
         (VESAMODEINFO.bpp=16)
         and
         (VESAMODEINFO.green_mask_size=6) {i pres kladny bpp=16 by totiz mohlo dojit k zamene za 15-bitove rezimy}
         then Exit(mode[i]);
      end;
Find_mode:=0;
end;


Function Best_mode(width,height:word):longint;
var xn,yn:longint;
    segm,ofss,i,j:word;
    modes:byte;
    dst,dist:longint;
    MyMode:array[1..255] of
           record
              num:word;
              xr:longint;
              yr:longint;
           end;
    allmodes:array[0..255] of word;
begin
GetNativeResolution(xn,yn);
if xn=0 then Best_mode:=Find_mode(width,height)
   else begin{1}
   segm:=Segment_To_Descriptor(VesaBaseInfo.Videomodi shr 16);
   ofss:=VesaBaseInfo.Videomodi and $FFFF;
   seg_move(segm, ofss, get_ds, longint(@allmodes), SizeOf(allmodes));
   modes:=0;
   i:=0;
   while allmodes[i]<>$FFFF do
      begin
      ReadVESAmodeInfos(allmodes[i]);

      if (VESAMODEINFO.bpp=16) and (VESAMODEINFO.green_mask_size=6) then
         begin
         inc(modes);
         MyMode[modes].xr:=VESAMODEINFO.HAufloesung;
         myMode[modes].yr:=VESAMODEINFO.VAufloesung;
         MyMode[modes].num:=allmodes[i];
         if (mymode[modes].xr=xn) and (mymode[modes].yr=yn) then Exit(allmodes[i]);
         {nasli jsme presne odpovidajici videorezim? Skvele!}
         end;
      inc(i);
      if i=255 then Exit(0);
      end;

   dst:=maxlongint;
   for i:=1 to modes do
       begin
       if (mymode[i].xr=xn div 2) and (mymode[i].yr=yn div 2) and
          (mymode[i].xr>=width) then Exit(mymode[i].num);
          {nasli jsme presne polovicni rozliseni oproti optimalnimu a toto
           polovicni rozliseni je rovno zachrannemu nebo vetsi
           (tzn. neni neprijatelne nizke). Priklad 1600x1200 -> 800x600}
       dist:=abs(yn-mymode[i].yr)*1000+abs(xn-mymode[i].xr);
       if dist<dst then
          begin
          j:=i;
          dst:=dist;
          end;
       end;
   Best_mode:=mymode[j].num;
   end;{1}
end;


FUNCTION GraphModeSupport(Mode:Word):Boolean;
VAR      Fazit : Boolean;
         Temp2 : LongInt;
         Temp  : Word;
Begin
ReadVESAbaseInfos;
{musi tu byt - informace VesaBaseInfo.Videomodi ma jen docasnou platnost}
if mode<$14 then Exit(true);
 Temp2:= 0;
 Fazit           := False;
 GraphmodeSupport:= False;
 REPEAT
  Temp:= GetDOSWord(VesaBaseInfo.VideoModi+Temp2);
  If Temp = Mode then Fazit:= True;
  Inc(Temp2,2);
 UNTIL (Temp=$FFFF) or Fazit;
 GraphModeSupport:= Fazit;
End;


Function SetupSpecificCard_ATIMach64:boolean;
{Vzato ze zdrojaku pro ovladac z FreeBE/AF}
var floating,iobase:word;

    Function Get_Mach64_port(io_sel,mm_sel:longint):longint;
    begin
    if floating<>0 then Exit((mm_sel shl 2)+iobase)
                   else Exit((io_sel shl 10)+iobase);
    end;

var scratch,old:longint;
begin
Regs.ax:=$a012;
Regs.cx:=0;
RealIntr($10,Regs);
if Regs.ah<>0 then Exit(false);  {Mach64 nenalezena}
floating:=Regs.cx;
iobase:=Regs.dx;
if iobase=0 then iobase:=$2ec;
{Jeste potvrdime, zda jde skutecne o Mach64 kompatibilni kartu}
scratch:=Get_Mach64_port($11,$21);
old:=InportL(scratch);
OutPortL(scratch,$55555555);
if InportL(scratch)<>$55555555 then
   begin
   OutPortL(scratch,old);
   Exit(false);
   end;
OutPortL(scratch,$aaaaaaaa);
if InportL(scratch)<>$aaaaaaaa then
   begin
   OutPortL(scratch,old);
   Exit(false);
   end;
OutPortL(scratch,old);
{OK, Mach64 je potvrzena}
bank_internal.internal32_0:=Get_Mach64_port($15,$2d);  {mach64_wpsel}
bank_internal.internal32_1:=Get_Mach64_port($16,$2e);  {mach64_rpsel}
SetupSpecificCard_ATIMach64:=true;
end;


{$IFDEF SIMPLIER_GTF_CALC}
Function calc_crtc_timing(xres,yres,xadjust,yadjust,freq:longint):longint;
{Spocita potrebne hodnoty pro pruchod paprsku.
 Vyplni strukturu CrtcInfoBlock a ve vysledku funkce vrati zakladni frekvenci
 pixelu}
var
HTotal, VTotal:longint;
HDisp, VDisp:longint;
HSS, VSS:longint;
HSE, VSE:longint;
HSWidth, VSWidth:longint;
SS, SE:longint;
doublescan:boolean;
begin
doublescan:=false;
  if (yres < 400) then
      begin
      doublescan := TRUE;
      yres :=yres*2;
      end;

HDisp := xres;
Htotal:=round(HDisp*1.27) and (not 7);
HSWidth := round((HTotal - HDisp) / 5) and (not 7);
HSS := HDisp + 16;
HSE := HSS + HSWidth;
VDisp := yres;
VTotal := round(VDisp * 1.07);
VSWidth := round(VTotal / 100) + 1;
VSS := VDisp + round((VTotal - VDisp) / 5) + 1;
VSE := VSS + VSWidth;

SS := HSS + xadjust;
SE := HSE + xadjust;

if (xadjust < 0)  then
   if SS < HDisp + 8 then
      begin
      SS := HDisp + 8;
      SE := SS + HSWidth;
      end else
   else
   if HTotal - 24 < SE  then
      begin
      SE := HTotal - 24;
      SS := SE - HSWidth;
      end;

HSS := SS;
HSE := SE;
SS := VSS + yadjust;
SE := VSE + yadjust;

if (yadjust < 0)  then
   if SS < VDisp + 3 then
      begin
      SS := VDisp + 3;
      SE := SS + VSWidth;
      end else
   else
   if VTotal - 4 < SE then
      begin
      SE := VTotal - 4;
      SS := SE - VSWidth;
      end;
VSS := SS;
VSE := SE;
crtcinfoblock.HorizontalTotal     := HTotal;
crtcinfoblock.HorizontalSyncStart := HSS;
crtcinfoblock.HorizontalSyncEnd   := HSE;
crtcinfoblock.VerticalTotal       := VTotal;
crtcinfoblock.VerticalSyncStart   := VSS;
crtcinfoblock.VerticalSyncEnd     := VSE;
crtcinfoblock.Flags               := HNEG or VNEG;
if doublescan then
   crtcinfoblock.flags:=crtcinfoblock.flags or byte(doublescan);

calc_crtc_timing:=dword(crtcinfoblock.HorizontalTotal * crtcinfoblock.VerticalTotal * freq);
end;
{$ENDIF}


Function get_closest_pixel_clock(mode_no,vclk:longint):dword;
{Uses VESA 3.0 function 0x4F0B to find the closest pixel clock to the
 requested value.}
var r:registers;
begin
r.ax:=$4f0B;
r.bl:=0;
r.ecx:=vclk;
r.dx:=mode_no;
intr($10,r);
if r.ah<>0 then get_closest_pixel_clock:=0 else get_closest_pixel_clock:=r.ecx;
end;

PROCEDURE Kill_Graph;
Begin
 if pagging_mode<>PAG_NO then Kill_Pagging;
 if mouse_driver_installed then Kill_Mouse;
 {Protected_VESA_Interface rusit nebudu a necham ho zrusit az ukoncenim programu}
 {if protected_vesa_interface then
    begin
    FreeMem(vbPMI, vbPMIsize);
    Free_LDT_Descriptor(vbPMFSeg);
    end;}
 if VGA.Segment<>dosmemselector then Free_LDT_Descriptor(VGA.Segment);
Clear_Graphics_Variables;
 INIT_TEXTMODE;
 SelectedMode:= 0;
End;

Procedure Get_DDC_Info;
var LowMemPtr:longint;
begin
ddc_support:=false;
LowMemPtr:= Global_DOS_Alloc(sizeof(VESA_EDID));
FillChar(my_ddc,sizeof(VESA_EDID),0);
FillChar(Regs,SizeOf(Regs),0);
Regs.bx:= 0;
Regs.ax:= $4F15;
RealIntr($10,Regs);
if regs.al<>$4f then Exit else
   if regs.ah<>0 then Exit;
FillChar(Regs,SizeOf(Regs),0);
Regs.es:= Word(LowMemPtr shr 16);
Regs.bx:= 1;
Regs.ax:= $4F15;
RealIntr($10,Regs);
DOSMemGet(Word(LowMemPtr shr 16),0,my_ddc,sizeof(VESA_EDID));
Global_DOS_Free(Word(LowMemPtr));
ddc_support:=true;
end;

Function GetMonitorSize(var x,y:byte):boolean;
begin
if not ddc_support then Exit(false);
x:=my_ddc.max_horiz_size;
y:=my_ddc.max_vert_size;
GetMonitorSize:=true;
end;

Procedure Get_Monitor_Fq_Range;
var a:word;
    t:^EDID_text_identification;
    p:pbyte;
begin
FillChar(monitor_range,sizeof(monitor_range),0);
if not ddc_support then Exit;
p:=addr(my_ddc.det_tim_id1);
for a:=1 to 4 do
    begin
    t:=pointer(p);
    if (t^.magic[1]=0) and (t^.magic[2]=0) and (t^.magic[3]=0) then
       if t^.text_identifier=$FD then
          begin
          monitor_range.vertmin:=t^.min_vert_refresh_hz;
          monitor_range.vertmax:=t^.max_vert_refresh_hz;
          monitor_range.horizmin:=t^.min_horiz_freq_kHz;
          monitor_range.horizmin:=t^.max_horiz_freq_kHz;
          Exit;
          end;
    inc(p,18);
    end;
end;


Procedure GetNativeResolution(var x,y:longint);
var w:word;
    b1,b2:byte;

begin
w:=my_ddc.std_tim_id[1];
b1:=Lo(w);
b2:=Hi(w);
x:=(b1+31)*8;
b2:=b2 shr 6;
case b2 of
   1:y:=round(x*0.75);
   2:y:=round(x*0.8);
   3:y:=round(x*0.5625);
   else begin y:=0;x:=0;end;
end;
end;

Function GetBest_Fq(x,y:longint):longint;
var a,b1,b2:byte;
    w:word;
    r:real;
    fq,xx,yy,l,max:longint;

  Function Hd(b,c,d:byte):byte; {neposlouchat hlasky prekladace, ze D neni pouzito}
  begin
  if (l and (1 shl b))<>0 then if b>max then begin fq:=c;max:=b;end;
  end;

begin
if not ddc_support then Exit(0);
if my_ddc.max_vert_size=0 then Exit(0); {exit, jinak by nastalo deleni nulou}
if real(my_ddc.max_horiz_size / my_ddc.max_vert_size)>1.4 then Exit(60);
   {sirokouhle zobrazovadlo bude nejspis LCD displej a dost mozna na notebooku
   kde muzeme ocekavat cbyby v implementaci cehokoliv, proto skoncime s
   bezpecnou hodnotou 60Hz}
fq:=0;
{ Metoda c.1 }
for a:=1 to 8 do
    begin
    w:=my_ddc.std_tim_id[a];
    b1:=Lo(w);
    b2:=Hi(w);
    xx:=(b1+31)*8;
    if xx=x then
       begin
       b1:=b2 shr 6;
         case b1 of
         1:r:=xx*0.75;
         2:r:=xx*0.8;
         3:r:=xx*0.5625;
         else r:=0;
         end;
       yy:=round(r);
       if yy=y then
          begin
          b2:=b2 and 63 + 60;
          if b2>fq then fq:=b2;
          end;
       end;
    end;
if fq<>0 then Exit(fq);

{ Metoda c.2 }
l:=my_ddc.est_timings2 shl 8 + my_ddc.est_timings1;
max:=0;
   case x of
   720 :Hd(0,70,Hd(1,88,0));
   640 :Hd(2,60,Hd(3,67,Hd(4,72,Hd(5,75,0))));
   800 :Hd(6,56,Hd(7,60,Hd(8,72,Hd(9,75,0))));
   832 :Hd(10,75,0);
   1024:Hd(11,87,Hd(12,60,Hd(13,70,Hd(14,75,0))));
             {ale interlaced(???)}
   1280:Hd(15,75,0);
   end;
GetBest_Fq:=fq;
end;


Procedure SetProtectmodeInterface;
var offs:longint;
begin
vbPMFSeg := Allocate_Ldt_Descriptors(1); {z nejakeho duvodu to vadi DEBUGGINGU}
Regs.ax := $4F0A;
Regs.bl := 0;
RealIntr($10, Regs);
vbPMISize := Regs.cx;
GetMem(vbPMI, vbPMIsize);
DosMemGet(Regs.es, Regs.di, vbPMI^, vbPMISize);
Offs:=Get_Segment_Base_Address(DosMemSelector) + Regs.es * 16 + Regs.di;
Set_Segment_Base_Address(vbPMFSeg, Offs);
Set_Segment_Limit(vbPMFSeg, Get_Page_Size);

vbPMISetWindow:=vbPMI + WordArray(vbPMI^)[0];        {pro $4f05}
vbPMISetDisplayStart:=vbPMI + WordArray(vbPMI^)[1];  {pro $4f07}

protected_vesa_interface:=true;
end;


Function PrepareGraph(var mode:word;vid_access:byte):boolean;
begin
ReadVesaModeInfos(mode);

VesaModeInfo.LFB_Supported:=(VesaModeInfo.Modus_attribute and 128) = 128;

if (VesaBaseInfo.VesaVersion[2]<2)
   or (Get_windows_version=3) {Windows NT a nasledovnici neumi LFB}
   then VesaModeInfo.LFB_Supported:=false;

if VesaModeInfo.LFB_Supported then
   if vid_access=BANK_ACCESS then
       VesaModeInfo.LFB_Supported:=false else else
    if vid_access=LFB_ACCESS then exit(false);

if VesaModeInfo.LFB_Supported then mode:=mode or $4000;
SelectedMode:= Mode;
PrepareGraph:=true;
end;


Procedure AdjustForUserFrequency(mode:word;fq:word);
{nastavi globalni promennou Manual_freq}
var pixclock:dword;
    xr,yr,c:longint;
begin
Manual_freq:=false;
CRTCinfoBlock.RefreshRate:=0;
if VesaBaseInfo.VesaVersion[2]<3 then Exit;

xr:=VesaModeInfo.Haufloesung;
yr:=VesaModeInfo.Vaufloesung;

if (fq and BEST_FQ) <> 0 then { aktivni vyhledani opt. fq }
   begin
   c:=GetBest_Fq(xr,yr);
   if c=0 then fq:=fq and 255 else fq:=c;
   end;
if (fq=0) or (fq=60) then Exit;

if (VESAMODEINFO.Modus_Attribute and 16) = 0 then { Jestlize to je textovy rezim tak...}
   begin
   xr:=xr*VESAMODEINFO.Videozellen_Breite;
   yr:=yr*VESAMODEINFO.Videozellen_Hoehe;
   end;

{$IFNDEF SIMPLIER_GTF_CALC}
    Calc_CRTC_timing(mode,xr,yr,fq,crtcinfoblock);
    if crtcinfoblock.pixelclock=0 then Exit;
{$ELSE}
    pixclock:=calc_crtc_timing(xr, yr, 0, 0, fq);      {nahrubo...}
    pixclock:=get_closest_pixel_clock(mode,pixclock);  {nejblize k dispozici...}

    if pixclock>0 then
       begin
       crtcinfoblock.PixelClock  := pixclock;
       crtcinfoblock.RefreshRate := fq * 100;
       {
       f0 := pixclock / (crtcinfoblock.HorizontalTotal * crtcinfoblock.VerticalTotal);
       c:=round(f0+0.5);
       }
       end else Exit;
{$ENDIF}
Manual_freq:=true;
end;


Function SwitchGraph(mode:word):boolean;
var w:word;
    long:dword;
begin
FillChar(Regs,SizeOf(Regs),0);
Regs.EAX:= $4F02;
Regs.EBX:=Mode;
if manual_freq then
   begin
   {K zamysleni - nedelat prepnuti ve dvou krocich?}
      {tj. prepnuti do default grafiky a az pak prepnuti do spec. frekvence?}
   long:=Global_DOS_alloc(sizeOf(CRTCInfoBlock));
   w:=Hi(long);
   dosmemput(w,0,crtcinfoblock, sizeof(CRTCInfoBlock));
   Regs.es := w;
   Regs.edi := 0;
   Regs.ebx:=mode or $0800;
   end;
RealIntr($10,Regs);
if manual_freq then Global_DOS_free(Lo(long));
SwitchGraph:=(Regs.RealEAX and $4F)=$4F;
end;


Function Init_Graph(Mode:Word;vid_access:byte;fq:word):byte;
var a:byte;
Begin
Init_Graph:=0;
if not PrepareGraph(mode,vid_access)    {nacteme informace o modu a rozhodnem}
   then Error(lfb_not_available_message,''); {zda banky nebo LFB}

AdjustForUserFrequency(mode,fq);  {ev. pripravime uzivatelskou frekv.}

if not SwitchGraph(mode) then      {a definitivne prepneme}
   Error(init_mode_failed_message,DezToHex(mode and $799));

{--------------------------------------------------------------------------------}
if VesaModeInfo.LFB_supported then
   begin
   VGA.Segment := Allocate_LDT_Descriptors(1);
   Set_Segment_Base_Address(VGA.Segment,Get_Linear_Addr(longint(VesaModeInfo.LFB_Adresse),VesaBaseInfo.VideoSpeicher shl 16));
   Set_Segment_Limit(VGA.Segment,(VesaBaseInfo.VideoSpeicher shl 16)-1);
   VGA.VWOffset      := 0;
   SetLFBmodeVariables;
   Init_Graph:=LFB_ACCESS;
   end
   else begin
   VGA.Segment       := dosmemselector;
   VGA.VWOffset      := 0;  {This value will not be used in banked routines}
                            {directly but added to seg_wr and seg_rd}

   VesaModeInfo.Banks:= Byte(VGA.Size div (VesaModeInfo.Granularitaet shl 10));
   VesaModeInfo.BSize:= (VesaModeInfo.Granularitaet shl 10);
   SetBankModeVariables;
   Init_Graph:=BANK_ACCESS;
   end;
VGA.Size          := LongInt(VesaModeInfo.HAufloesung)*LongInt(VesaModeInfo.VAufloesung) shl 1;
VGA.Breite        := LongInt(VesaModeInfo.HAufloesung);
VGA.BreiteMinus1  := VGA.Breite-1;
VGA.ByteBreite    := VGA.Breite shl 1;
VGA.Hoehe         := LongInt(VesaModeInfo.VAufloesung);
VGA.HoeheMinus1   := VGA.Hoehe-1;
End;


Function Init_Graph(Mode:Word;vid_access:byte):byte;
begin
Init_Graph:=Init_Graph(mode,vid_access,0);
end;


Function Init_Graph(Mode:Word):byte;
begin
Init_Graph:=Init_Graph(mode,ANY_ACCESS,0);
end;


PROCEDURE Init_VW(var VWPage:VirtualWindow;Breite,Hoehe:LongInt;Clear:Boolean);
var i,j,k,l,m:dword;
      p:pointer;
Begin
 VWPage.Segment     := Get_DS;
 VWPage.Size        := Breite * Hoehe shl 1;
 VWPage.Breite      := Breite;
 VWPage.BreiteMinus1:= Breite-1;
 VWPage.ByteBreite  := Breite shl 1;
 VWPage.Hoehe       := Hoehe;
 VWPage.HoeheMinus1 := Hoehe-1;
 VWPage.flags       := 1; {ma bitmapu}
 VWPage.RLEmap      := 0;
 VWPage.TransCol    := 0;
 VWPage.Position    := 0;
 k:=VWPage.Size;
{$IFDEF GRADUALALLOCATION}
 m:=1024*768*2;
 if k<=m then
    Getmem(Pointer(VWPage.VWOffset),k)
    else begin
    GetMem(p,16);

    i:=k mod m;
    l:=k div m;
    for j:=1 to l do
        ReAllocMem(p,j*m);
    if i<>0 then ReAllocMem(p,j*m+i);
    i:=j*m+i;
    VWPage.VWOffset:=longint(p);
    end;
{$ELSE}
p:=nil;
GetMem(p,k);
if not assigned(p) then
   begin writeln(#7);error('Could not allocate memory in VenomGFX unit!','');end
   else VWPage.VWOffset:=longint(p);
{$ENDIF}
 EnoughMemoryOf(Pointer(VWPage.VWOffset),VWPage.Size);
 If Clear then Clr(VWPage,0);
End;


PROCEDURE Init_VW(var VWPage:VirtualWindow;Breite,Hoehe:LongInt);
begin
Init_VW(VWPage,Breite,Hoehe,false);
end;


function Internal_Make_RLEmap(src,dest:pointer;breite,hoehe:longint;c:word):dword;assembler;
var xxx:longint;
asm

mov esi,src
mov edi,dest


mov edx,hoehe
shl edx,2
add edx,edi

mov [edi],edx   {odkaz na zacatek 1.radku}
mov xxx,edi     {XXX bude slouzit jako ukazatel na seznam radek}
add xxx,4
mov edi,edx
mov edx,hoehe

@dalsi_radek:

mov ecx,breite
xor ebx,ebx

@dalsi_bod:
mov ax,[esi]
add esi,2
cmp ax,c
jz @dira    {Jsme-li na pruhledne barve, tak jdi na DIRA}

   @PLOCHA:
    cmp ebx,0
    jge @neni_prechod_z_diry
       {prechod diry}
        mov [edi],bl
        inc edi
        xor ebx,ebx
       {------------}
    @neni_prechod_z_diry:
       cmp ebx,127
       jl @plocha_pridej_ebx
       {EBX dosahlo nejvyssi hodnoty shortintu}
        mov [edi],bl
        inc edi
        xor ebx,ebx
       {--------------------------------------}

    @plocha_pridej_ebx:
       inc ebx
    Loop @dalsi_bod
    jmp @SPOLU
   @END_plocha:


   @DIRA:
   cmp ebx,0
    jle @neni_prechod_z_plochy
       {prechod diry}
        mov [edi],bl
        inc edi
        xor ebx,ebx
       {------------}
    @neni_prechod_z_plochy:
       cmp ebx,-128
       jg @dira_uber_ebx
       {EBX dosahlo nejvyssi hodnoty shortintu}
        mov [edi],bl
        inc edi
        xor ebx,ebx
       {--------------------------------------}

    @dira_uber_ebx:
       dec ebx
    Loop @dalsi_bod
    jmp @SPOLU
   @END_dira:

@SPOLU:
mov [edi],bl
inc edi
mov byte [edi],0
inc edi
cmp edx,1
jz @Preskoc_tvorbu_odkazu
{do ukazatele na seznam radek zapiseme odkaz na dalsi radku}
push esi
mov esi,xxx
mov [esi],edi
add xxx,4
pop esi
{zpracovali jsme vsechny pixely v radku}
@Preskoc_tvorbu_odkazu:
dec edx
jnz @dalsi_radek

sub edi,dest
mov eax,edi
end;


Procedure Make_RLEmap(var v:virtualwindow;color:word);
var l:longint;
    p:pointer;
    d:dword;
begin
v.flags:=v.flags or 2;  {nastavim 1.bit}
l:=(v.size div 2)+v.hoehe*5+2;
GetMem(pointer(v.RLEmap),l);
d:=Internal_Make_RLEmap(pointer(v.vwoffset),pointer(v.RLEmap),v.breite,v.hoehe,color);
v.RLEsize:=d;
ReallocMem(pointer(v.RLEmap),d);
v.TransCol:=color;
end;


Procedure Make_RLEmap(var v:virtualwindow);
begin
Make_RLEmap(v,v.TransCol);
end;


Procedure Del_RLEmap(var v:virtualwindow);
begin
if (v.flags and 2)<>0 then FreeMem(pointer(v.rlemap));
v.flags:=v.flags and (not 2) {smaze priznak RLE mapy}
end;


Procedure PrepareTexture(var v:virtualwindow);
begin
texture:=@v;
end;


Procedure Lock_VW(var v:virtualwindow);
{uzamkne bitmapu a RLE mapu (pro handler mysi)}
{POZOR - neuzamyka hlavni zaznam, jen data za VWoffset a RLEmap}
begin
Lock_Data(pointer(v.VWoffset)^,v.size);
if (v.flags and 2)<>0 then
   Lock_Data(pointer(v.RLEmap)^,v.RLEsize);
end;


Procedure Init_Pagging(color:longint);
var i,j:dword;
begin
pag_color:=color;
i:=VESABASEINFO.videospeicher;
i:=i*65536;
j:=vga.size;
if (i>=j) {and VESAMODEINFO.LFB_supported} and (pagging_mode<>PAG_BUF) then
   begin         {Je dost pameti na strankovani}
   vgb:=vga;
   vgb.VWoffset:=vga.VWoffset+j;
   pagging_mode:=PAG_DBL;
   end
   else begin
   Init_VW(vgb,vga.breite,vga.hoehe,false);
   pagging_mode:=PAG_BUF;
   end;
page_active:=1;
if pag_color<>PAG_NOCLEAR then Clr(vgb,pag_color);
end;

PROCEDURE Kill_VW(var VWPage:VirtualWindow);
Begin
if (VWpage.flags and 8)<>0 then
   begin
   UNLock_Data(pointer(vwpage.VWoffset)^,vwpage.size);
   if (vwpage.flags and 2)<>0 then
      UNLock_Data(pointer(vwpage.RLEmap)^,vwpage.RLEsize);
   end;
Freemem(Pointer(VWPage.VWOffset),VWPage.Size);
Del_RLEmap(VWpage);
End;


Function Is_Bitmap_Empty(var p;size:longint):boolean;assembler;
asm
mov esi,p
xor ah,ah
mov ecx,size
@krok:
mov al,[esi]
cmp al,0
jnz @konec
inc esi
dec ecx
jnz @krok
inc ah
@konec:
mov al,ah
end;

Procedure MakeSpriteMap(var sour:virtualwindow;var buffer;c:word);assembler;
asm
mov edi,buffer
mov esi,sour
mov ecx,[esi+6]  {size}
mov esi,[esi+2]  {VWoffset}
shr ecx,1
@smycka:
lodsw
cmp ax,c
mov al,0      {MOV priznaky nemeni}
jnz @preskoc
inc al
@preskoc:
stosb
loop @smycka
end;


{===========================================================================}
{===========================================================================}
Procedure StartPoint_code_lock;
{Tato procedura nedela nic, ale pouziju ji jako zacatek zamknute oblasti
 pameti, tak aby spravne fungoval handler mysi}
begin
end;
{===========================================================================}


PROCEDURE WaitRetrace; Assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
Asm
 Mov dx,3DAh
 @l1:
 in al,dx
 and al,08h
 jnz @l1
 @l2:
 in al,dx
 and al,08h
 jz @l2
End;


Procedure WaitRetrace(var v:virtualwindow);
begin
if v.segment<>Get_DS then WaitRetrace;
end;


Function VESA1LogicDisplay(x,y:longint):boolean;assembler;
asm
push ebx;push ecx
mov eax,4f07h
xor ebx,ebx
mov ecx,x
mov edx,y
int 10h;
pop ecx;pop ebx
mov al,0
cmp ah,0
jz @bez_chyby
mov al,1
@bez_chyby:
end;

Function VESA2LogicDisplay(x,y:longint):boolean;assembler;
asm
lea esi,vga
mov ecx,[esi+26]  {ByteBreite}
mov eax,y
mul ecx
mov ecx,x
shl ecx,1
add ecx,eax
push es
mov ax,vbpmfseg
mov es,ax
mov eax,4f0h
xor ebx,ebx
shr ecx,2
mov edx,ecx
shr edx,16
call vbpmisetdisplaystart
pop es
end;

Function SetLogicDisplay(x,y:longint):boolean;
var o:longint;
begin
if protected_vesa_interface then VESA2logicDisplay(x,y)
                            else VESA1logicDisplay(x,y);
end;

Procedure SpriteClipping;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{ Input:  EDI = Dest
          ESI = Sprite
          EAX    = X
          EBX    = Y

  Output: EAX    = Starting position for input
          EBX    = Starting position for output
          ECX    = number of bytes transfered on each line
          EDX    = number of lines
          Carry flag: set if sprite if out of view
          Zerro flag: set if clipping was performed
}
asm
push ebp
xor ebp,ebp
cmp eax,[edi+10]                {DEST.BREITE}
jge @Mimo                   {if X>=Dest.breite then goto Mimo}
cmp ebx,[edi+30]                {DEST.HOEHE}
jge @mimo                  {if Y>=Dest.hoehe then goto Mimo}

xor ecx,ecx

mov edx,[esi+30]                {SPRITE.HOEHE}
cmp ebx,0
jge @Y_kladne              {if Y>=0 then goto Y_kladne}

    {Y<0----------}
    add edx,ebx            {Decreases Height by Y}
    cmp edx,0
    jle @mimo
    sub ecx,ebx            {EAX=0-EBX}
    imul ecx,[esi+26]      {SPRITE.BYTEBREITE}
                           {we have to change first visible line of sprite}
    xor ebx,ebx            {sets the Y position to 0}
    inc ebp                {sets flag, that clipping was performed}
    {-------------}

@Y_kladne:
add edx,ebx
cmp edx,[edi+30]                {DEST.HOEHE}
jle @Dolu_OK

    {Y+height>=Dest.hoehe-------------}
    mov edx,[edi+30]
    inc ebp                {sets flag, that clipping was performed}
    {---------------------------------}

@Dolu_OK:
sub edx,ebx

push edx
mov edx,ecx                {sprite offset is now in EDX}

mov ecx,[esi+10]
cmp eax,0
jge @X_kladne
    {X<0-----------}
    add ecx,eax            {Decrease Width by X}
    cmp ecx,0
    jle @pop_mimo
    sub edx,eax            {move the sprite offset of X}
    sub edx,eax            {and again because we have two bytes per pixel}
    xor eax,eax            {sets the X position to 0}
    inc ebp                {sets flag, that clipping was performed}
    {--------------}

@X_kladne:
add ecx,eax
cmp ecx,[edi+10]
jle @Doprava_OK

    {X+width>=Dest.breite-------------}
    mov ecx,[edi+10]
    inc ebp                {sets flag, that clipping was performed}
    {---------------------------------}

@Doprava_OK:
sub ecx,eax

imul ebx,[edi+26]          {DEST.BYTEBREITE}
                   {EBX=Y*Dest.Bytebreite}
add ebx,eax        {EBX=EBX+X...}
add ebx,eax        {...+X  (we have two bytes per pixel)}

mov eax,edx        {sprite offset into EAX}
pop edx            {restore height}
shl ecx,1          {we have two bytes per pixel}


cmp ebp,0  {was clipping performed? - sets or clears ZF}
clc        {clears CF}
jmp @konec

@pop_mimo:
pop edx

@mimo:
cmp esi,edi {leads to be ZF set}
cmp ebp,0   {sets ZF}
stc         {sets CF}

@konec:
pop ebp
end;


Procedure FontClipping;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{ Input:  EDI = Dest
          ESI = Sprite
          EAX    = X
          EBX    = Y

  Output: EAX    = Starting position for input
          EBX    = Starting position for output
          ECX    = number of bytes transfered on each line
          EDX    = number of lines
          Font_horiz_clip = clipping code
              1 - too right, fully out of view
              2 - too left, fully out of view
              3 - partially too right
              4 - partially too left

          Carry flag: set if sprite if out of view
          Zerro flag: set if clipping was performed
}
asm

cmp eax,[edi+10]                {DEST.BREITE}
mov Font_horiz_clip,1   {moc vpravo}
jge @Mimo                   {if X>=Dest.breite then goto Mimo}
cmp ebx,[edi+30]                {DEST.HOEHE}
jge @mimo                  {if Y>=Dest.hoehe then goto Mimo}

mov Font_horiz_clip,0
xor ecx,ecx
mov edx,[esi+30]                {SPRITE.HOEHE}
cmp ebx,0
jge @Y_kladne              {if Y>=0 then goto Y_kladne}

    {Y<0----------}
    add edx,ebx            {Decreases Height by Y}
    cmp edx,0
    jle @mimo
    sub ecx,ebx            {EAX=0-EBX}
    imul ecx,[esi+26]      {SPRITE.BYTEBREITE}
                           {we have to change first visible line of sprite}
    xor ebx,ebx            {sets the Y position to 0}
    {-------------}

@Y_kladne:
add edx,ebx
cmp edx,[edi+30]                {DEST.HOEHE}
jle @Dolu_OK

    {Y+height>=Dest.hoehe-------------}
    mov edx,[edi+30]
    {---------------------------------}

@Dolu_OK:
sub edx,ebx

push edx
mov edx,ecx                {sprite offset is now in EDX}

mov ecx,[esi+10]
cmp eax,0
jge @X_kladne
    {X<0-----------}
    add ecx,eax            {Decrease Width by X}
    cmp ecx,0
    mov Font_horiz_clip,2 {moc vlevo}
    jle @pop_mimo
    sub edx,eax            {move the sprite offset of X}
    sub edx,eax            {and again because we have two bytes per pixel}
    xor eax,eax            {sets the X position to 0}
    mov Font_horiz_clip,4 {castecne moc vlevo}
    {--------------}

@X_kladne:
add ecx,eax
cmp ecx,[edi+10]
jle @Doprava_OK

    {X+width>=Dest.breite-------------}
    mov ecx,[edi+10]
    mov Font_horiz_clip,3 {castecne moc vpravo}
    {---------------------------------}

@Doprava_OK:
sub ecx,eax

imul ebx,[edi+26]          {DEST.BYTEBREITE}
                   {EBX=Y*Dest.Bytebreite}
add ebx,eax        {EBX=EBX+X...}
add ebx,eax        {...+X  (we have two bytes per pixel)}

mov eax,edx        {sprite offset into EAX}
pop edx            {restore height}
shl ecx,1          {we have two bytes per pixel}

clc        {clears CF}
jmp @konec

@pop_mimo:
pop edx

@mimo:
stc         {sets CF}

@konec:
end;



Procedure BarClipping;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{ Input:  EDI = Dest
          EAX    = X1
          EBX    = Y1
          ECX    = X2
          EDX    = Y2

  Output:
          EBX    = Starting position for output
          ECX    = number of bytes transfered on each line
          EDX    = number of lines
          Carry flag: set if sprite if out of view
}
asm
{--ev. prohozeni X1 s X2 a Y1 s Y2--}
cmp eax,ecx
jle @X2_vetsi_X1
xchg eax,ecx
@X2_vetsi_X1:
cmp ebx,edx
jle @Y2_vetsi_Y1
xchg ebx,edx
@Y2_vetsi_Y1:


{------Osetri pripady mimo vyrez---------}
cmp edx,0       {Y2<0 ?}
jl @mimo
cmp ecx,0       {X2<0 ?}
jl @mimo
cmp eax,[edi+10]  {DEST.BREITE}
jge @mimo
cmp ebx,[edi+30]  {DEST.HOEHE}
jge @mimo

{------Poresi X1 a X2--------------------}
cmp eax,0       {X1<0 ?}
jg @X1_vetsi_0
xor eax,eax

@X1_vetsi_0:
cmp ecx,[edi+10]  {DEST.BREITE}
jl @X2_se_vejde

mov ecx,[edi+10]
dec ecx

@X2_se_vejde:

{------Poresi Y1 a Y2--------------------}
cmp ebx,0       {Y1<0 ?}
jg @Y1_vetsi_0
xor ebx,ebx

@Y1_vetsi_0:
cmp edx,[edi+30]  {DEST.HOEHE}
jl @Y2_se_vejde

mov edx,[edi+30]
dec edx

@Y2_se_vejde:

sub edx,ebx
sub ecx,eax
inc edx
inc ecx
shl ecx,1

imul ebx,[edi+26] {DEST.BYTEBREITE}
add ebx,eax
add ebx,eax

clc
jmp @uvnitr

@mimo:
stc

@uvnitr:

end;


Procedure HorizLineClipping;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:  EDI = Dest
         EAX = x1
         ECX = x2
         EBX = y

OUTPUT:  EAX = x1
         ECX = scanline length in pixels (not in bytes)
         Carry flag: set if sprite if out of view

DESTROYS: nothing}
asm
cmp ebx,ds:[edi+30]  {vga.hoehe}
jae @Mimo            {y<0 nebo y>maxY?  ==> Ende}

cmp eax,ecx          {x1 vs. x2}
jng @dale            {x1<x2?  ==> Dale}
    xchg eax,ecx              {EAX=mensi souradnice, ECX=vetsi}
@dale:
cmp ecx,0           {x2 vs. 0}
jl @Mimo            {x2<0? ==> Ende}
cmp eax,ds:[edi+10]  {vga.breite}         {x1 vs. vga.breite}
jge @Mimo           {x1>=vga.breite  ==> Ende}
cmp ecx,ds:[edi+10]  {vga.breite}         {x2 vs. vga.breite}
jl @jump2           {x2<=vga.breite?  ==> Jump2}
   mov ecx,ds:[edi+10] {x2:=vga.breite-1}
   dec ecx
@jump2:
cmp eax,0           {x1 vs. 0}
jge @jump3          {x1>=0?  ==> jump3}
   mov eax,0        {x1:=0}
@jump3:
sub ecx,eax
inc ecx
clc
jmp @konec
@Mimo:
stc
@Konec:
end;


Procedure VertLineClipping;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:  EDI = Dest
         EAX = y1
         ECX = y2
         EBX = x

OUTPUT:  EAX = y1
         ECX = column height in pixels
         Carry flag: set if sprite if out of view

DESTROYS: nothing}

asm
cmp ebx,ds:[edi+10]  {breite}
jae @Mimo            {je x<0 nebo x>maxX?}

cmp eax,ecx
jng @dale                 {y2<y1?}
  xchg eax,ecx            {EAX=mensi souradnice, ECX=vetsi}
@dale:
cmp ecx,0
  jl @Mimo                  {y2<0}
cmp eax,ds:[edi+30]  {hoehe}
  jge @Mimo
cmp ecx,ds:[edi+30]  {hoehe}
  jl @jump2
   mov ecx,ds:[edi+30]
   dec ecx
@jump2:
   cmp eax,0
   jge @jump3
   mov eax,0
@jump3:
   sub ecx,eax
   inc ecx
clc
jmp @konec
@Mimo:
stc
@Konec:
end;


Procedure BitmapaNaPixmapu;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{Decompress a bitmap into virtualwindow content}

{ Input:  ESI = bitmap which shall be uncompressed
          EDI = buffer of VirtualWindow structure
          ECX = number of bytes to decompress (into 16-bit pixmap)

  Output: ECX = 0

  Destroys: ESI,EDI, flags}
asm
cmp esi,font_last_bitmap
jz @preskoc
push ebx
push eax
mov font_last_bitmap,esi
@dalsi_bajty:
    mov al,[esi];inc esi     {vytahnu bajt}
    sal al,1;sbb ebx,ebx;mov [edi+0],bx
    sal al,1;sbb ebx,ebx;mov [edi+2],bx
    sal al,1;sbb ebx,ebx;mov [edi+4],bx
    sal al,1;sbb ebx,ebx;mov [edi+6],bx
    sal al,1;sbb ebx,ebx;mov [edi+8],bx
    sal al,1;sbb ebx,ebx;mov [edi+10],bx
    sal al,1;sbb ebx,ebx;mov [edi+12],bx
    sal al,1;sbb ebx,ebx;mov [edi+14],bx
    add edi,16
    dec ecx
    jnz @dalsi_bajty
pop eax
pop ebx
@preskoc:
end;


Procedure TextureToScanline_horz;assembler;
var start_x,txt_start_y,txt_start_x,txt_brt,txt_ecx1,txt_ecx2:longint;
{INPUT: EAX = X start position
        ECX = line length in pixels (not in bytes)
        EBX = Y position

OUTPUT:   Filled ScanLine buffer
DESTROYS: EDX,EBX,ESI,EDI}


asm
lea edi,ScanLine   {to je proste pole, nikoliv VirtualWindow}
mov esi,Texture
push eax
push eax

mov eax,ebx
xor edx,edx
idiv dword ds:[esi+30]  {EDX:EAX / hoehe (t.j. Y/hoehe) ==> podil v EAX, zbytek v EDX}
mov txt_start_y,edx

mov ebx,ds:[esi+10]   {breite}
pop eax
xor edx,edx
idiv ebx
mov txt_start_x,edx
mov txt_ecx2,edx
sub ebx,txt_ecx2
mov txt_ecx1,ebx

mov ebx,ds:[esi+26]   {bytebreite}
mov txt_brt,ebx
imul ebx,txt_start_y
mov esi,ds:[esi+2]    {pointer}
add esi,ebx

add esi,txt_start_x   {txt_start_x se bude pricitat 2x, protoze jsou 2B/px}
add esi,txt_start_x   {Ted uz je ESI definitivni}

{pripravne prace jsou hotovy, jdeme vykreslovat do pomocneho bufferu}
{v txt_ecx1 = pocet pixelu od txt_start_x dal}
{v txt_ecx2 = pocet pixelu do txt_start_x}

push ecx
@smycka:

mov edx,ecx
cmp ecx,txt_ecx1
jg @postupne_vykreslovani

@zaverecny_usek:
   sar ecx,1;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
jmp @Hotovo

@postupne_vykreslovani:
   mov ecx,txt_ecx1  {1.cast, t.j. cast do P.kraje textury}
   sar ecx,1;rep movsd;adc ecx,ecx;rep movsw

   sub esi,txt_brt
   mov ecx,edx
   sub ecx,txt_ecx1
   cmp ecx,txt_ecx2
   jg @pokracujeme
   mov txt_ecx2,ecx

@pokracujeme:
   mov ecx,txt_ecx2  {2.cast, t.j. znovu od L.kraje textury}
   sar ecx,1;rep movsd;adc ecx,ecx;rep movsw
   mov ecx,edx
   sub ecx,txt_ecx1
   sub ecx,txt_ecx2
{cmp ecx,0}
jnz @smycka
@Hotovo:
pop ecx    {pocet pixelu na radek}
pop eax    {souradnice X1}
End;


Procedure TextureToScanline_vert;assembler;
var txt_start_y,txt_start_x,txt_brt,txt_ecx1,txt_ecx2,old_esi:longint;
{INPUT: EAX = Y start position
        EBX = X position
        ECX = line length in pixels (not in bytes)


OUTPUT:   Filled ScanLine buffer
DESTROYS: EDX,EBX,ESI,EDI}

asm
lea edi,ScanLine   {to je proste pole, nikoliv VirtualWindow}
mov esi,Texture
push eax
xchg eax,ebx
push eax
mov eax,ebx
xor edx,edx
mov ebx,ds:[esi+30]  {hoehe}
idiv ebx             {EDX:EAX / EBX (t.j. Y/hoehe) ==> podil v EAX, zbytek v EDX}
mov txt_start_y,edx
mov txt_ecx2,edx
sub ebx,txt_ecx2
mov txt_ecx1,ebx

mov ebx,ds:[esi+10]   {breite}
pop eax
xor edx,edx
idiv ebx
mov txt_start_x,edx

mov ebx,ds:[esi+26]   {bytebreite}
mov txt_brt,ebx
imul ebx,txt_start_y
mov esi,ds:[esi+2]    {pointer}
add esi,txt_start_x   {txt_start_x se bude pricitat 2x, protoze jsou 2B/px}
add esi,txt_start_x   {Ted uz je ESI definitivni}
mov old_esi,esi
add esi,ebx

{pripravne prace jsou hotovy, jdeme vykreslovat do pomocneho bufferu}
{v txt_ecx1 = pocet pixelu od txt_start_x dal}
{v txt_ecx2 = pocet pixelu do txt_start_x}

push ecx
@smycka:

mov edx,ecx
cmp ecx,txt_ecx1
jg @postupne_vykreslovani

@zaverecny_usek:
   mov ax,ds:[esi]
   mov ds:[edi],ax  {vime, ze DS a ES jsou shodne}
   add esi,txt_brt
   add edi,2
   loop @zaverecny_usek
   jmp @Hotovo

@postupne_vykreslovani:
   mov ecx,txt_ecx1  {1.cast, t.j. cast do P.kraje textury}

@pv1:
   mov ax,ds:[esi]
   mov ds:[edi],ax
   add esi,txt_brt
   add edi,2
   loop @pv1


   mov esi,old_esi

cmp txt_ecx2,0
jz @pv3
   mov ecx,edx
   sub ecx,txt_ecx1
   cmp ecx,txt_ecx2
   jg @pokracujeme
   mov txt_ecx2,ecx

@pokracujeme:
   mov ecx,txt_ecx2  {2.cast, t.j. znovu od L.kraje textury}
@pv2:
   mov ax,ds:[esi]
   mov ds:[edi],ax
   add esi,txt_brt
   add edi,2
   loop @pv2

@pv3:
   mov ecx,edx
   sub ecx,txt_ecx1
   sub ecx,txt_ecx2
{cmp ecx,0}
jnz @smycka
@Hotovo:
pop ecx    {pocet pixelu na radek}
pop eax    {souradnice X1}
End;



Procedure FastCopyBlock;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:   DS:ESI = source
          ES:EDI = destination
          ECX    = number of transferred bytes

DESTROYS: ECX, (ESI anf EDI are moved to new position)}
asm
cmp ecx,64
jl @go_x86

@zkus_mmx:
cmp ss:[cpu_info_mmx],0  {DS muze byt zmeneno, proto se odvolavam pres SS}
je @go_x86

@go_mmx:{------------------------------------------------------------------}
@SCHLEIFE_MMX:   {Kdyz je podporovano MMX}
MovQ mm0,[esi    ];MovQ mm1,[esi+  8];
MovQ mm2,[esi+ 16];MovQ mm3,[esi+ 24];
MovQ mm4,[esi+ 32];MovQ mm5,[esi+ 40];
MovQ mm6,[esi+ 48];MovQ mm7,[esi+ 56];
MovQ es:[edi    ],mm0;MovQ es:[edi+  8],mm1;
MovQ es:[edi+ 16],mm2;MovQ es:[edi+ 24],mm3;
MovQ es:[edi+ 32],mm4;MovQ es:[edi+ 40],mm5;
MovQ es:[edi+ 48],mm6;MovQ es:[edi+ 56],mm7
Add esi,64
Add edi,64
sub ecx,64
cmp ecx,64
JGE @SCHLEIFE_MMX
cmp ecx,8
jl @do_emms

@MMX_Zbytek:
MovQ  mm0,[esi];
MovQ  [edi],mm0;
add esi,8
add edi,8
sub ecx,8
cmp ecx,8
jge @MMX_Zbytek

@do_emms:
emms

@go_x86:{------------------------------------------------------------------}
shr ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
end;



Procedure FastCopyAndDelBlock;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:   DS:ESI = source
          ES:EDI = destination
          ECX    = number of transferred bytes
          EAX    = color used for repainting (High and Lo word must be equal)

DESTROYS: ECX, (ESI and EDI are moved to new position)}
asm
cmp ecx,64
jl @go_x86

@go_mmx:{------------------------------------------------------------------}
cmp ss:[cpu_info_mmx],0    {DS muze byt zmeneno, proto se odvolavam pres SS}
je @go_x86
MovD mm0,eax
MovD mm1,eax
Psllq mm0,32
Paddusw mm0,mm1
MovQ ss:[mmx_sim_reg],mm0  {DS muze byt zmeneno, proto se odvolavam pres SS}
@SCHLEIFE_MMX:   {Kdyz je podporovano MMX}
MovQ mm0,[esi    ];MovQ mm1,[esi+  8];
MovQ mm2,[esi+ 16];MovQ mm3,[esi+ 24];
MovQ mm4,[esi+ 32];MovQ mm5,[esi+ 40];
MovQ mm6,[esi+ 48];MovQ mm7,[esi+ 56];
MovQ es:[edi    ],mm0;MovQ es:[edi+  8],mm1;
MovQ es:[edi+ 16],mm2;MovQ es:[edi+ 24],mm3;
MovQ es:[edi+ 32],mm4;MovQ es:[edi+ 40],mm5;
MovQ es:[edi+ 48],mm6;MovQ es:[edi+ 56],mm7
MovQ mm0,ss:[mmx_sim_reg]
MovQ [esi    ],mm0;MovQ [esi+  8],mm0;
MovQ [esi+ 16],mm0;MovQ [esi+ 24],mm0;
MovQ [esi+ 32],mm0;MovQ [esi+ 40],mm0;
MovQ [esi+ 48],mm0;MovQ [esi+ 56],mm0

Add esi,64
Add edi,64
sub ecx,64
cmp ecx,64
JGE @SCHLEIFE_MMX
cmp ecx,8
jl @do_emms

@MMX_Zbytek:
MovQ  mm1,[esi];
MovQ  es:[edi],mm1;
MovQ  [esi],mm0
add esi,8
add edi,8
sub ecx,8
cmp ecx,8
jge @MMX_Zbytek

@do_emms:
emms

@go_x86:{------------------------------------------------------------------}
push ebx

shr ecx,2
pushf

jz @skip4
@smycka:

   mov ebx,[esi]
   mov es:[edi],ebx
   mov [esi],eax

   add edi,4
   add esi,4
   dec ecx
   jnz @smycka

@skip4:
popf
jnc @konec
mov bx,[esi]
mov es:[edi],bx
mov [esi],ax
add edi,2
add esi,2

@konec:
pop ebx
end;


Procedure FastDelBlock;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:   EAX = color (Lo word of EAX must be already copied into high word)
          ES:EDI = destination
          ECX    = number of transferred bytes

DESTROYS: ECX, (EDI is moved to new position)}
asm
cmp ecx,64
jl @go_x86

@zkus_mmx:
cmp ss:[cpu_info_mmx],0     {DS muze byt zmeneno, proto se odvolavam pres SS}
je @go_x86

@go_mmx:{------------------------------------------------------------------}
MovD mm0,eax
MovD mm1,eax
Psllq mm0,32
Paddusw mm0,mm1
{MovQ ss:[mmx_sim_reg],mm0}
@SCHLEIFE_MMX:   {Kdyz je podporovano MMX}
{MovQ mm0,ss:[mmx_sim_reg]}
MovQ es:[edi    ],mm0;MovQ es:[edi+  8],mm0;
MovQ es:[edi+ 16],mm0;MovQ es:[edi+ 24],mm0;
MovQ es:[edi+ 32],mm0;MovQ es:[edi+ 40],mm0;
MovQ es:[edi+ 48],mm0;MovQ es:[edi+ 56],mm0
Add edi,64
sub ecx,64
cmp ecx,64
JGE @SCHLEIFE_MMX
cmp ecx,8
jl @do_emms

@MMX_Zbytek:
MovQ  es:[edi],mm0;
add edi,8
sub ecx,8
cmp ecx,8
jge @MMX_Zbytek

@do_emms:
emms

@go_x86:{------------------------------------------------------------------}
shr ecx,2;rep stosd;adc ecx,ecx;rep stosw  {fast 32bit write}
end;



Procedure Set_Bank_rdwr;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF} {nastavi soucasne zapisove i cteci okno}
{INPUT:    DX = bank number}
{          DS musn't be changed!}
{DESTROYS: BX,AX}
asm
mov al,bank_internal.win_rd
cmp al,bank_internal.win_wr
jz @spolecne_okno
call bank_internal.SetBank_rd
@spolecne_okno:
call bank_internal.SetBank_wr
end;


Procedure VESA_set_bank_wr;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:    DX = bank number}
{          DS musn't be changed!}
{DESTROYS: BX,AX}
asm
xor bh,bh
mov bl,bank_internal.win_wr
mov ax,4f05h
int 10h
end;

Procedure VESA_set_bank_rd;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:    DX = bank number}
{          DS musn't be changed!}
{DESTROYS: BX,AX}
asm
xor bh,bh
mov bl,bank_internal.win_rd
mov ax,4f05h
int 10h
end;


Procedure NVidia_set_bank;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{Works for both - read and writting. I tested it on Riva TNT2 and on GeForce4}
{I am not sure if it works with newer chips too}
{INPUT:    DX = bank number}
{DESTROYS: BX,AX}
asm
push edx
mov bx,dx
shl bx,1
mov dx,3d4h
mov ax,571fh
out dx,ax
mov ah,bl
mov al,1dh
out dx,ax
mov al,1eh
out dx,ax
or bh,bh
jz @skip
mov ah,bh
mov al,29h
or ah,3
out dx,ax
@skip:
pop edx
end;


Procedure ATIMach64_set_bank_wr;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:    DX = bank number}
{          DS musn't be changed!}
{DESTROYS: EAX}
asm
push edx
shl edx,1
movzx eax,dx
mov ah,al
inc ah
shl eax,8
shr ax,8
mov edx,bank_internal.internal32_0 {mach64_wpsel}
out dx,eax
pop edx
end;


Procedure ATIMach64_set_bank_rd;assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
{INPUT:    DX = bank number}
{          DS musn't be changed!}
{DESTROYS: EAX}
asm
push edx
shl edx,1
movzx eax,dx
mov ah,al
inc ah
shl eax,8
shr ax,8
mov edx,bank_internal.internal32_1 {mach64_rpsel}
out dx,eax
pop edx
end;


Procedure SetAlternateBankRoutine(writeproc,readproc:pointer);
{Be careuful, the bank switching procedures should be in locked memory to be
 safe for mouse handler}
begin
bank_internal.SetBank_wr:=writeproc;
bank_internal.SetBank_rd:=readproc;
end;


PROCEDURE ClrSprite(var Sprite:VirtualWindow;Color:Word); Assembler;
{Pro vybarvovani LFB obrazovek i spritu definovanych pres Init_VW}
Asm
push es
 Mov edi,Sprite
 Mov ecx,ds:[edi+6]  {size}
 mov es, ds:[edi  ]
 Mov edi,ds:[edi+2]  {VWoffset}

  Mov ax,Color
  Shl eax,16
  Mov ax,Color

Call FastDelBlock

pop es
End;


Function LFBPutChar_FN(var dest:virtualwindow;p:pointer;x,y,xd,yd:longint;charbytes:byte;c:word):byte;assembler;
{kam, data, x, y, sirka, vyska, komprese, poc.bytu, barva}
var xxx:longint;
{ For unit FNfont2 }

asm
cmp p,0
jz @Konec

lea esi,fontvw        {nacetl jsem si renderovaci policko pro znaky}

mov eax,xd            {vypocitam rozmery renderovaciho policka - sirka...}
mov ebx,yd            {...vyska}
mov ecx,eax
shl ecx,1             {...bytebreite}

mov [esi+10],eax  {breite}
mov [esi+30],ebx  {hoehe}
mov [esi+26],ecx  {bytebreite}

mov edi,dest
mov eax,x
mov ebx,y
call FontClipping
jc @Konec


{--cmp neco;jz @rozpakovano}

push edi          {schovam EDI, protoze ji prepisu}
push esi
push ecx
push edx
mov edi,[esi+2]   {bitmapu rozepisu do 16-bitove pixmapy}
mov esi,p         {vezmu bitmapu}
movzx ecx,charbytes

call BitmapaNaPixmapu

pop edx
pop ecx
pop esi
pop edi


@rozpakovano:

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov es,[edi+0]

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov bx,c

@SCANLINES_LOOP:
    push esi
    push edi
    push ecx
  @Radka:
    cmp word ptr [esi],0
    je @Preskocit
    mov es:[edi],bx
  @Preskocit:
    add esi,2
    add edi,2
    sub ecx,2
    jnz @Radka

    pop ecx
    pop edi
    pop esi
    add edi,eax
    add esi,xxx

  Dec edx
  JNZ @SCANLINES_LOOP

pop es
@Konec:
mov al,Font_horiz_clip
end;




PROCEDURE LFBPutPixel(var dest:virtualwindow;x,y:LongInt;Color:Word); Assembler;
Asm
 Push es

  Mov edi,Dest
  Mov eax,ds:[edi+10]
  Mul y
  Add eax,x
  Shl eax,1
  Mov es ,ds:[edi  ]
  Mov edi,ds:[edi+2]
  Add edi,eax
  Mov ax,Color
  Mov es:[edi],ax

 Pop es
End;


FUNCTION LFBGetPixel(var source:virtualwindow;x,y:LongInt):Word; Assembler;
Asm
 Push es

  Mov edi,Source
  Mov eax,ds:[edi+10]
  Mul y
  Add eax,x
  Shl eax,1
  Mov es ,ds:[edi  ]
  Mov edi,ds:[edi+2]
  Add edi,eax
  Mov ax,es:[edi]

 Pop es
End;


PROCEDURE PutClippedLFBPixel(var dest:virtualwindow;x,y:LongInt;Color:Word); Assembler;
Asm
 Mov edi,Dest

 Mov eax,ds:[edi+14]
 Cmp x,eax
 Ja @Ende
 Mov eax,ds:[edi+38]
 Cmp y,eax
 Ja @Ende

 Push es

  mov eax,ds:[edi+10]
  Mul y
  Add eax,x
  Shl eax,1
  Mov es ,ds:[edi  ]
  Mov edi,ds:[edi+2]
  Add edi,eax
  Mov ax,Color
  Mov es:[edi],ax

 Pop es
 @Ende:
End;


FUNCTION GetClippedLFBPixel(var source:virtualwindow;x,y:LongInt):Word; Assembler;
Asm
 Xor ax,ax
 Mov edi,Source

 Mov ebx,ds:[edi+14]
 Cmp x,ebx
 Ja @Ende
 Mov ebx,ds:[edi+38]
 Cmp y,ebx
 Ja @Ende

 Push es

  Mov eax,ds:[edi+10]
  Mul y
  Add eax,x
  Shl eax,1
  Mov es ,ds:[edi  ]
  Mov edi,ds:[edi+2]
  Add edi,eax
  Mov ax,es:[edi]

 Pop es
 @Ende:
End;


PROCEDURE LFBLineHorz(var dest:virtualwindow;x1,x2,y:LongInt;Color:Word); Assembler;
Asm
  Mov edi,Dest
  mov eax,x1
  mov ecx,x2
  mov ebx,y
Call HorizLineClipping
jc @Ende

push es
   Mov ebx,ds:[edi+26]
   Mov es ,ds:[edi   ]
   Mov edi,ds:[edi+ 2]

   IMul ebx,y
   shl eax,1
   add ebx,eax
   Add edi,ebx

   {mam startovni pozici}
   mov ax,Color
   shl eax,16
   mov ax,color
   sar ecx,1;rep stosd;adc ecx,ecx;rep stosw  {fast 32bit write}

 Pop es

 @ENDE:
End;


PROCEDURE LFBLineHorzXOR(var dest:virtualwindow;x1,x2,y:LongInt;Color:Word); Assembler;
Asm
  Mov edi,Dest
  mov eax,x1
  mov ecx,x2
  mov ebx,y
Call HorizLineClipping
jc @Ende

push es
   Mov ebx,ds:[edi+26]
   Mov es ,ds:[edi   ]
   Mov edi,ds:[edi+ 2]

   IMul ebx,y
   shl eax,1
   add ebx,eax
   Add edi,ebx

   {mam startovni pozici}
   mov ax,color
   shl eax,16
   mov ax,color

   sar ecx,1
   jecxz @M1
   pushf
   @L1:
   xor es:[edi],eax
   add edi,4
   loop @L1
   popf
   jnc @S1
   @M1:
   xor es:[edi],ax
   add edi,2
   @S1:
 Pop es

 @ENDE:
End;



PROCEDURE LFBLineHorzTexture(var dest:virtualwindow;x1,x2,y:LongInt;dummy:Word); Assembler;
{Expects some PVirtualwindow in "Texture" variable}
{Effect of this procedure depends on how is set the transparency of Texture}
{(you can select transparent color by setting the 2.bit of Flags and TransCol
  values of Texture)}
Asm
Mov edi,Dest
  mov eax,x1
  mov ecx,x2
  mov ebx,y
Call HorizLineClipping
jc @Ende

Call TextureToScanline_horz

mov esi,Texture
test byte ds:[esi+20],4    {2.bit pole Flags}
jnz @transparence

lea esi,ScanLine      {vlezu na zacatek pripraveneho pomocneho bufferu}
push es
   mov edi,dest
   Mov ebx,ds:[edi+26]
   Mov es ,ds:[edi   ]
   Mov edi,ds:[edi+ 2]

   IMul ebx,y
   add edi,ebx
   add edi,eax
   add edi,eax
sar ecx,1;rep movsd;adc ecx,ecx;rep movsw
Pop es
jmp @ende

@transparence:
mov dx,ds:[esi+18]  {TransCol}
lea esi,ScanLine      {vlezu na zacatek pripraveneho pomocneho bufferu}
push es
   mov edi,dest
   Mov ebx,ds:[edi+26]
   Mov es ,ds:[edi   ]
   Mov edi,ds:[edi+ 2]

   IMul ebx,y
   add edi,ebx
   add edi,eax
   add edi,eax

@smycka:
mov ax,ds:[esi]
cmp ax,dx
jz @preskoc
mov es:[edi],ax
@preskoc:
add esi,2
add edi,2
dec ecx
jnz @smycka
Pop es

@Ende:
end;


PROCEDURE LFBLineHorzMasked(var dest:virtualwindow;x1,x2,y:LongInt;color:Word); Assembler;
{Expects some PVirtualwindow in "Texture" variable}

Asm
Mov edi,Dest
  mov eax,x1
  mov ecx,x2
  mov ebx,y
Call HorizLineClipping
jc @Ende

Call TextureToScanline_horz

push es
   mov edi,dest
   Mov ebx,ds:[edi+26]
   Mov es ,ds:[edi   ]
   Mov edi,ds:[edi+ 2]

   IMul ebx,y
   add edi,ebx
   add edi,eax
   add edi,eax

mov esi,Texture
mov dx,ds:[esi+18]  {TransCol}
mov bx,color
test byte ds:[esi+20],4    {2.bit pole Flags}
jnz @transparence


lea esi,ScanLine      {vlezu na zacatek pripraveneho pomocneho bufferu}
@smycka1:
mov ax,ds:[esi]
cmp ax,dx
jnz @zadana_barva1
mov ax,bx
@zadana_barva1:
mov es:[edi],ax
add esi,2
add edi,2
dec ecx
jnz @smycka1
jmp @hotovo


@transparence:
lea esi,ScanLine      {vlezu na zacatek pripraveneho pomocneho bufferu}
@smycka2:
mov ax,ds:[esi]
cmp ax,dx
jz @zadana_barva2
mov es:[edi],bx
@zadana_barva2:
add esi,2
add edi,2
dec ecx
jnz @smycka2

@hotovo:
Pop es
@Ende:
end;



PROCEDURE LFBLineVert(var dest:virtualwindow;x,y1,y2:LongInt;color:word);assembler;
asm
Mov edi,Dest
  mov eax,y1
  mov ecx,y2
  mov ebx,x
Call VertLineClipping
jc @Ende

mov ebx,[edi+26]
mul ebx                       {Y1 := Y1*dest.ByteBreite}
add eax,x
add eax,x

push es
mov es,[edi+0]
add eax,[edi+2]
mov edi,eax

      mov ax,color
    @HL:
      mov es:[edi], ax
      add edi,ebx
    LOOP @HL
  pop es
@ende:
End;

PROCEDURE LFBLineVertXOR(var dest:virtualwindow;x,y1,y2:LongInt;color:word);assembler;
asm
Mov edi,Dest
  mov eax,y1
  mov ecx,y2
  mov ebx,x
Call VertLineClipping
jc @Ende

mov ebx,[edi+26]
mul ebx                       {Y1 := Y1*dest.ByteBreite}
add eax,x
add eax,x

push es
mov es,[edi+0]
add eax,[edi+2]
mov edi,eax

  mov ax,color
    @HL:
      xor es:[edi],ax
      add edi,ebx
    LOOP @HL
  pop es
@ende:
End;



PROCEDURE LFBLineVertTexture(var dest:virtualwindow;x,y1,y2:LongInt;dummy:Word);assembler;
asm
Mov edi,Dest
  mov eax,y1
  mov ecx,y2
  mov ebx,x
Call VertLineClipping
jc @Ende

Call TextureToScanline_vert

{v EAX je porad Y1}
push es
mov edi,dest
mov ebx,[edi+26]
mul ebx                       {Y1 := Y1*dest.ByteBreite}
add eax,x
add eax,x
mov es,[edi+0]
add eax,[edi+2]
mov edi,eax


mov esi,Texture
mov dx,ds:[esi+18]         {TransCol}
test byte ds:[esi+20],4    {2.bit pole Flags}
lea esi,ScanLine      {vlezu na zacatek pripraveneho pomocneho bufferu}
                      {(LEA nemeni priznaky)}
jnz @transparence

@HL1:
mov ax,ds:[esi]
mov es:[edi],ax
add esi,2
add edi,ebx
LOOP @HL1
pop es
jmp @ende

@Transparence:
@HL2:
mov ax,ds:[esi]
cmp ax,dx
jz @skip
mov es:[edi],ax
@skip:
add esi,2
add edi,ebx
LOOP @HL2
pop es

@ende:
end;


PROCEDURE LFBLineVertMasked(var dest:virtualwindow;x,y1,y2:LongInt;color:Word);assembler;
var tc:byte;
asm
Mov edi,Dest
  mov eax,y1
  mov ecx,y2
  mov ebx,x
Call VertLineClipping
jc @Ende

Call TextureToScanline_vert

{v EAX je porad Y1}
push es
mov edi,dest
mov ebx,[edi+26]
mul ebx                       {Y1 := Y1*dest.ByteBreite}
add eax,x
add eax,x
mov es,[edi+0]
add eax,[edi+2]
mov edi,eax


mov esi,Texture
mov dx,ds:[esi+18]         {TransCol}
mov tc,dx
mov dx,color
test byte ds:[esi+20],4    {2.bit pole Flags}
lea esi,ScanLine      {vlezu na zacatek pripraveneho pomocneho bufferu}
                      {(LEA nemeni priznaky)}
jnz @transparence

@HL1:
mov ax,ds:[esi]
cmp ax,tc
jnz @zadana_barva1
mov ax,dx
@zadana_barva1:
mov es:[edi],ax
add esi,2
add edi,ebx
LOOP @HL1
pop es
jmp @ende

@Transparence:
@HL2:
mov ax,ds:[esi]
cmp ax,tc
jz @skip
mov es:[edi],dx
@skip:
add esi,2
add edi,ebx
LOOP @HL2
pop es

@Ende:
end;


Procedure LFBBar(var dest:virtualwindow;x1,y1,x2,y2:longint;color:word);assembler;
asm
mov eax,x1
mov ebx,y1
mov ecx,x2
mov edx,y2
mov edi,dest
call BarClipping
jc @Konec

push es
mov ax,[edi+0]
mov es,ax

add ebx,[edi+2]
mov edi,[edi+26]  {DEST.BYTEBREITE}
xchg ebx,edi

Mov ax,color
Shl eax,16
Mov ax,color

@znovu:
   push edi
   push ecx
   sar ecx,2;rep stosd;adc ecx,ecx;rep stosw  {fast 32bit write}
   pop ecx
   pop edi
   add edi,ebx
   sub edx,1
   jnz @znovu
 Pop es
@konec:
end;


Procedure LFBBarXOR(var dest:virtualwindow;x1,y1,x2,y2:longint;color:word);assembler;
asm
mov eax,x1
mov ebx,y1
mov ecx,x2
mov edx,y2
mov edi,dest
call BarClipping
jc @Konec

push es
mov ax,[edi+0]
mov es,ax

add ebx,[edi+2]
mov edi,[edi+26]  {DEST.BYTEBREITE}
xchg ebx,edi

Mov ax,color
Shl eax,16
Mov ax,color

@znovu:
   push edi
   push ecx

   sar ecx,2
   jecxz @M1
   pushf
   @L1:
   xor es:[edi],eax
   add edi,4
   loop @L1
   popf
   jnc @S1
   @M1:
   xor es:[edi],ax
   add edi,2
   @S1:

   pop ecx
   pop edi
   add edi,ebx
   sub edx,1
   jnz @znovu
 Pop es
@konec:
end;


Procedure LFBPutSprite_and_clear(var Dest, Sprite:VirtualWindow;x,y:longint;c:word);assembler;
{Procedure has clipping}
var xxx:longint;
asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @JenMazani

{Pozor, pri pripadnych upravach je treba dodrzet, aby bylo vlozeni sprajtu
 clippovane, ale vymazani sprajtu musi kompletni, tzn. i vcetne casti, ktere
 nebyly vykresleny na obrazovku}

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

{Varianta 1 - kopirovani i mazani}
 mov bx,c
 shl ebx,16
 mov bx,c               {a v EBX je ted zkopirovana barva}

 @SCANLINES_LOOP:
    push esi
    push edi
    push ecx
    sar ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
    pop ecx
    pop edi
    pop esi
    add edi,eax
    add esi,xxx

  Dec edx
  JNZ @SCANLINES_LOOP
 pop es
 mov esi,sprite
{Varianta 2 - jen vymazani obsahu spritu}
@jenMazani:
   mov ax,c
   shl eax,16
   mov ax,c               {a v EBX je ted zkopirovana barva}
   mov ecx,[esi+6]        {size}
   mov edi,[esi+2]        {vwoffset do EDI}
   sar ecx,2;rep stosd;adc ecx,ecx;rep stosw  {fast 32bit write}
   {toto je mozne jen proto, ze vime, ze DS=ES a sprajt ma standardni DS}
{---------------------------------------}
@konec:
End;


PROCEDURE LFBPutSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);assembler;
 Asm
  Push es

  mov  edi,Dest
  mov  ax,ds:[edi  ]
  Mov  es,ax

  mov  esi,Sprite

  mov  ecx,ds:[esi+26]      { Sprite.ByteBreite }
  mov  eax,y
  mov  ebx,ds:[edi+26]
  mul  ebx                  { vysledek v EDX:EAX }
  Mov  edx,ds:[esi+30]      { Sprite.Hoehe  }

  Add  eax,x
  add  eax,x

  Add  eax,ds:[edi+2]         { DestOffset }
  mov  edi,eax

  Mov  esi,ds:[esi+2]       { Sprite Offset in esi }

  @SCANLINES_LOOP:
  push ecx
  push edi

  {@mmxloop: movq mm0,ds:[esi];movq es:[edi],mm0
  add esi,8;sub ecx,8;add edi,8;cmp ecx,8;jge @mmxloop}

  sar ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}

  pop edi
  add edi,ebx
  pop ecx
  dec edx
  jnz @scanlines_loop

{emms}

 Pop es
End;



PROCEDURE LFBGetSprite(var Source,Sprite:VirtualWindow;x,y:LongInt);assembler;
var SpriteBreitediv2,SpriteBreitemod2:longint;
Asm
Push es
Push ds
  mov esi,source
  mov ax,es:[esi]
  mov ds,ax
  mov eax,es:[esi+26]               {ByteBreite}
push eax
  Mul  y
  Shl  x,1
  Add  eax,x
  Add  eax,es:[esi+2]               {SourceOffset}
  Mov  esi,eax                { Mam pocatecni pozici }
  Mov  ebx,eax                { Zkopiruju ji do EBX }
  mov edi,sprite
  mov edx,es:[edi+30]         { Sprite.hoehe }
  mov eax,es:[edi+10]         {Breite}
  shr eax,1                   {a mam breite div 2}
  mov SpriteBreiteDiv2,eax
  mov eax,es:[edi+10]         {Breite}
  and eax,1                   {a mam breite mod 2}
  mov SpriteBreiteMod2,eax
  Mov edi,es:[edi+2]          { Sprite Offset in edi }
pop eax
  @SCANLINES_LOOP:
    Mov ecx,SpriteBreiteDiv2
    Rep MovsD
    Mov ecx,SpriteBreiteMod2
    Rep MovsW
    Add ebx,eax
    Mov esi,ebx
  Dec edx
  JNZ @SCANLINES_LOOP
Pop ds
Pop es
End;


PROCEDURE LFBPutClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);assembler;
var xxx:longint;
asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

@SCANLINES_LOOP:
    push esi
    push edi
    push ecx
    sar ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
    pop ecx
    pop edi
    pop esi
    add edi,eax
    add esi,xxx

  Dec edx
  JNZ @SCANLINES_LOOP

Pop es

@Konec:
End;


PROCEDURE LFBGetClippedSprite(var source,sprite:VirtualWindow;x,y:LongInt);assembler;
var xxx:longint;
asm
mov esi,sprite
mov edi,source
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push ds
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov ds,ax

mov eax,es:[edi+26] {ByteBreite}
mov edi,es:[edi+2]
add edi,ebx

xchg esi,edi

@SCANLINES_LOOP:
    push esi
    push edi
    push ecx
    sar ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
    pop ecx
    pop edi
    pop esi
    add edi,xxx
    add esi,eax

  Dec edx
  JNZ @SCANLINES_LOOP

Pop ds
@Konec:
End;


PROCEDURE LFBPutHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);assembler;
{Umi vykreslit sprajt butdo normalne nebo s urychlenim pomoci RLE mapy}
VAR  xxx,bytebreite:longint;
 Asm
 push es
  mov  edi,Dest
  mov  ax,ds:[edi  ]
  Mov  es,ax
  mov  esi,Sprite
  mov  ecx,ds:[esi+26]      {Sprite.ByteBreite}
  mov  eax,y
  mov  ebx,ds:[edi+26]      {Dest.Bytebreite}
  mul  ebx                  {vysledek v EDX:EAX}
  Mov  edx,ds:[esi+30]      {Sprite.Hoehe}
  Add  eax,x
  add  eax,x

  Add  eax,ds:[edi+2]         { DestOffset }
  mov  edi,eax                {DEST offset v EDI}

  test byte [esi+20],2      {je propravena RLE mapa?}
  jnz @RLE_map

  {prubeh bez RLE mapy}
  Mov  esi,ds:[esi+2]       {SPRITE Offset v ESI }
  mov eax,bytebreite

  @SCANLINES_LOOP:
    push edi
    push ecx
  @Radka:
    mov ax,[esi]
    cmp ax,Hidecolor
    je @Preskocit
    mov es:[edi],ax
  @Preskocit:
    add esi,2
    add edi,2
    sub ecx,2
    jnz @Radka
    pop ecx
    pop edi
    add edi,ebx
  Dec edx
  JNZ @SCANLINES_LOOP

  jmp @Ende


{------------------------------------}
{Prubeh s RLE mapou}
@RLE_map:
  mov xxx,edi
  mov ByteBreite,ebx
  mov ebx,ds:[esi+34]      {zacatek RLE mapy}
  Mov esi,ds:[esi+2]       {SPRITE Offset v ESI }


  @RLE_SCANLINES_LOOP:

    push ebx               {ulozim seznam na radky}
    mov ebx,ds:[ebx]       {odkaz na n-ty radek RLE mapy}

    @RLE_SCANLINE_LOOP:
    movsx ecx,byte ds:[ebx]
    inc ebx
    cmp ecx,0
    jz @RLE_END_LOOP       {ECX=0? Skoc na konec radku}
    jg @RLE_MOVE           {ECX>0? Skoc na presun}

    @RLE_SKIP:             {ECX<0, tzn. preskocime -ECX pixelu}
    sub esi,ecx
    sub edi,ecx
    sub esi,ecx
    sub edi,ecx
    jmp @RLE_SCANLINE_LOOP

    @RLE_MOVE:
    shr ecx,1;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}

    jmp @RLE_SCANLINE_LOOP

   @RLE_END_LOOP:
    mov edi,xxx
    Add edi,ByteBreite
    mov xxx,edi
    pop ebx
    add ebx,4
  Dec edx
  JNZ @RLE_SCANLINES_LOOP
{------------------------------------}
@ende:
  Pop es
End;


PROCEDURE GetHCSprite(var source:virtualwindow;Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);assembler;
VAR       SourceOffset : LongInt;
          SpriteOffset : LongInt;
          SourceBreite : LongInt;
          SpriteBreite : Longint;
          SourceByteBreite:Longint;
 Asm
  Push es
  Push ds
  mov edi,sprite
  mov esi,source
  mov eax,[edi+2];mov SpriteOffset,eax;
  mov eax,[esi+2];mov SourceOffset,eax;

  Mov  ds,[esi]                  {source.segment}
  mov eax,es:[edi+10];mov SpriteBreite,eax
  Mov eax,es:[esi+26];mov SourceByteBreite,eax

  Mul y
  Shl x,1
  Add eax,x
  Add eax,SourceOffset
  Mov esi,eax
  Mov ebx,eax                { Und in ebx festhalten }

  Mov edx,es:[edi+30]           {Sprite.Hoehe}
  Mov edi,SpriteOffset       { Sprite Offset in edi }


  @SCANLINES_LOOP:

    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov es:[edi],ax
     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Add ebx,SourceByteBreite
    Mov esi,ebx

  Dec edx
  JNZ @SCANLINES_LOOP
  Pop ds
  Pop es
End;


PROCEDURE LFBPutClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:word);assembler;
var xxx,dbb,sedx:longint;
asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec
push es
pushf                   {ulozim aktualni priznaky. Pozdeji me bude zajimat ZF}
test byte [esi+20],2    {je pripravena RLE mapa?}
jnz @RLE_mapa


{-------------Prubeh bez RLE mapy-----------}
popf                    {Pokud nebude pouzita RLE mapa, tak me ZF nezajima}
add eax,[esi+2]
mov esi,[esi+26] {ByteBreite}
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

@SCANLINES_LOOP:
    push esi
    push edi
    push ecx
  @Radka:
    mov bx,[esi]
    cmp bx,Hidecolor
    je @Preskocit
    mov es:[edi],bx
  @Preskocit:
    add esi,2
    add edi,2
    sub ecx,2
    jnz @Radka

    pop ecx
    pop edi
    pop esi
    add edi,eax
    add esi,xxx

  Dec edx
  JNZ @SCANLINES_LOOP
Pop es
jmp @konec

{--------------Prubeh s RLE mapou------------}
@RLE_mapa:
push dword [edi+26] {dest.ByteBreite}
pop dword dbb            {v DBB mame dest.ByteBreite}
add ebx,[edi+2]
mov di,[edi+0]
mov es,di
mov edi,ebx              {v EDI mame startovaci adresu v DEST}

push eax
mov ebx,ds:[esi+34]      {v EBX mame startovaci adresu RLE mapy}
add eax,[esi+2]
mov esi,[esi+26] {sprite.ByteBreite}
xchg esi,eax
mov xxx,eax              {v XXX mame sprite.ByteBreite}
pop eax                  {v EAX mame posun od zacatku sprajtu}

popf      {obnovim ulozene priznaky a bude me zajimat ZF}
jnz @RLE_clipping
{--------------------Varianta bez clippingu-------------------}

  @RLE_SCANLINES_LOOP:

    push ebx               {ulozim seznam na radky}
    mov ebx,ds:[ebx]       {odkaz na n-ty radek RLE mapy}

    push edi

    @RLE_SCANLINE_LOOP:
    movsx ecx,byte ds:[ebx]
    inc ebx
    cmp ecx,0
    jz @RLE_END_LOOP       {ECX=0? Skoc na konec radku}
    jg @RLE_MOVE           {ECX>0? Skoc na presun}

    @RLE_SKIP:             {ECX<0, tzn. preskocime -ECX pixelu}
    sub esi,ecx
    sub edi,ecx
    sub esi,ecx
    sub edi,ecx
    jmp @RLE_SCANLINE_LOOP

    @RLE_MOVE:
    shr ecx,1;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
    jmp @RLE_SCANLINE_LOOP

   @RLE_END_LOOP:
    pop edi
    add edi,dbb

    pop ebx
    add ebx,4
  Dec edx
  JNZ @RLE_SCANLINES_LOOP
jmp @RLE_konec


@RLE_clipping:
{--------------Varianta kdy musim osetrit clipping------------}
  mov sedx,edx
  xor edx,edx              {Delenec je v EDX:EAX, proto musim nulovat EDX}
  div xxx                  {podil v EAX, zbytek v EDX}
  shl eax,2                {EAX:=EAX*4}
  add ebx,eax              {EBX nazmeruju na prvni zpracovavanou radku}
  mov eax,edx              {v EAX mame pocet vynechanych bajtu v zac.radku}
  shr eax,1                {prevedeme na pocet pixelu}
  mov edx,ecx              {sirka viditelneho useku (v bajtech) do EDX}
  shr edx,1                {prepocitam do poctu pixelu}


@RLE_CLIP_SCANLINES_LOOP:
    push edx
    push esi
    push ebx               {ulozim seznam na radky}
    mov ebx,ds:[ebx]       {odkaz na n-ty radek RLE mapy}
    push edi

    {------- napred musim preskocit levou cast radku --------}
    push eax
    cmp eax,0
    jz @RLE_CLIP_SCANLINE_LOOP
@RLE_CLIP_FIRSTSKIP:
    movsx ecx,byte ds:[ebx]
    inc ebx
    cmp ecx,0
    jz @RLE_CLIP_END_LOOP  {ECX=0? Skoc na konec radku. POP EAX bude az tam}
    jg @RLE_CLIP_SK_POZ

@RLE_CLIP_SK_NEG:  {Kdyz je ECX<0}
    add eax,ecx
    cmp eax,0
    jz @RLE_CLIP_SCANLINE_LOOP
    jl @RLE_PODTECENI1
    jmp @RLE_CLIP_FIRSTSKIP

@RLE_PODTECENI1:
    mov ecx,eax
    jmp @RLE_CLIP_SKIP

@RLE_CLIP_SK_POZ:  {Kdyz je ECX>0}
    sub eax,ecx
    cmp eax,0
    jz @RLE_CLIP_SCANLINE_LOOP
    jl @RLE_PODTECENI2

    jmp @RLE_CLIP_FIRSTSKIP

@RLE_PODTECENI2:
    mov ecx,eax
    neg ecx
    jmp @RLE_CLIP_MOVE


@RLE_CLIP_SCANLINE_LOOP:
    {------- ted uz jsme v zobrazovane casti ---------}
    movsx ecx,byte ds:[ebx]
    inc ebx

    @RLE_CLIP_NOW_OK:
    cmp ecx,0
    jz @RLE_CLIP_END_LOOP       {ECX=0? Skoc na konec radku}
    jg @RLE_cLIP_MOVE           {ECX>0? Skoc na presun}

    @RLE_CLIP_SKIP:             {ECX<0, tzn. preskocime -ECX pixelu}
    sub esi,ecx
    sub edi,ecx
    sub esi,ecx
    sub edi,ecx

    add edx,ecx
    cmp edx,0
    jle @RLE_CLIP_END_LOOP
    jmp @RLE_CLIP_SCANLINE_LOOP

    @RLE_CLIP_MOVE:
    sub edx,ecx
    sbb eax,eax
    and eax,edx
    add ecx,eax
    {Vyse uvedeny blok je ekvivalentem tohoto:}
     {sub edx,ecx;jnc @RLE_CLIP_MOVE_CONT;add ecx,edx;@RLE_CLIP_MOVE_CONT:}
    shr ecx,1;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}

    cmp edx,0
    jle @RLE_CLIP_END_LOOP
    jmp @RLE_CLIP_SCANLINE_LOOP

   @RLE_CLIP_END_LOOP:
    pop eax
    pop edi
    add edi,dbb
    pop ebx
    add ebx,4
    pop esi
    add esi,xxx
    pop edx
  Dec sedx
  JNZ @RLE_CLIP_SCANLINES_LOOP

@RLE_konec:
Pop es

@Konec:
End;


PROCEDURE GetClippedHCSprite(var source:virtualwindow;Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);assembler;
var xxx:longint;
asm
mov esi,sprite
mov edi,source
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push ds
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov ds,ax

mov eax,es:[edi+26] {ByteBreite}
mov edi,es:[edi+2]
add edi,ebx

xchg esi,edi

@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

  @Radka:
    mov bx,[esi]
    cmp bx,HideColor
    je @Preskoc
    mov es:[edi],ax
  @Preskoc:
    add esi,2
    add edi,2
    sub ecx,2
    jnz @Radka

    pop ecx
    pop edi
    pop esi
    add edi,xxx
    add esi,eax

  Dec edx
  JNZ @SCANLINES_LOOP

Pop ds
@Konec:
End;


{===========================================================================}
{$INCLUDE venombnk.inc}

Procedure SetBankModeVariables;
begin
bank_internal.grann:=64 div vesamodeinfo.granularitaet;  { pocet bloku granularity }
bank_internal.numm:=(LongInt(VesaModeInfo.HAufloesung)*LongInt(VesaModeInfo.VAufloesung) shl 1) div 65536;
bank_internal._bisgm:=bank_internal.numm*bank_internal.grann;
bank_internal.bisgm:=bank_internal._bisgm;
bank_internal.mem_offset:=0;
bank_internal.firstbank:=0;
bank_internal.firstblockpos:=0;
bank_internal.firstblocksize:=65356;
bank_internal.lastblocksize:=65356;

bank_internal.SetBank_wr:=@VESA_set_bank_wr;   {can be changed to another routine, f.e.}
                                    {NVIDIA_set_bank}
bank_internal.SetBank_rd:=@VESA_set_bank_rd;   {can be changed to another routine, f.e.}
                                    {NVIDIA_set_bank}

with vesamodeinfo do
begin
{napred budu predpokladat, ze pro cteni i zapis budu pouzivat okno 0}
bank_internal.Seg_wr:=Seg_Fenster_A;
bank_internal.Seg_rd:=Seg_Fenster_A;
bank_internal.win_rd:=0;
bank_internal.win_wr:=0;

if (WinA_attr and 1)=0 then
   begin
   {kdyz okno 0 vubec neexistuje, tak pro cteni i zapis pouziju okno 1}
   bank_internal.Seg_wr:=Seg_Fenster_B;
   bank_internal.Seg_rd:=Seg_Fenster_B;
   bank_internal.win_wr:=1;
   bank_internal.win_rd:=1;
   end
   else begin
   if (WinA_attr and 2)=0 then
      begin
      {Okno 0 je jenom pro zapis - na cteni musim pouzit okno 1}
      bank_internal.Seg_rd:=Seg_Fenster_B;bank_internal.win_rd:=1;
      end;
   if (WinA_attr and 4)=0 then
      begin
      {Okno 0 je jenom pro cteni - na zapis musim pouzit okno 1}
      bank_internal.Seg_wr:=Seg_Fenster_B;bank_internal.win_wr:=1;
      end;
   end;
bank_internal.Seg_wr:=bank_internal.Seg_wr*16;
bank_internal.Seg_rd:=bank_internal.Seg_rd*16;
{Musim nasobit 16 - VESA dava realmodove segmenty}
{jenze je chci pouzivat jako offsety uvnitr selectoru}

{Jeste nastavi interni promenne pro bankovaci rutiny}

bank_internal.zapis:=1;    {defaultni chovani je rutina, ktera na}
                                {obrazovku zapisuje a necte ji}
end;


{Ted zbyva nastavit proceduralni promenne}
{pixelove rutiny}
PutPixel:=@PutPixelBA;
PutClippedPixel:=@PutClippedPixelBA;
GetPixel:=@GetPixelBA;
GetClippedPixel:=@GetClippedPixelBA;
InternalPutPixel:=@PutClippedPixelBA;

SetLineMode(lm_normal);

{znaky}
PutChar_FN:=@PutChar_FNBA;
end;


Procedure SetLFBmodeVariables;
begin
{pixelove rutiny}
PutPixel:=@LFBPutPixel;
PutClippedPixel:=@PutClippedLFBPixel;
GetPixel:=@LFBGetPixel;
GetClippedPixel:=@GetClippedLFBPixel;
InternalPutPixel:=@PutClippedLFBPixel;

SetLineMode(lm_normal);

{znaky}
PutChar_FN:=@LFBPutChar_FN;
end;



PROCEDURE LFBFlip_VW(var Source, dest:virtualwindow); Assembler;
Asm
 Push ds
 Push es
 Mov esi,Source
 Mov ax,ds:[esi  ]
 Mov esi,ds:[esi+2]

 Mov edi,Dest
 Mov ecx,ds:[edi+6]
 Mov es ,ds:[edi  ]
 Mov edi,ds:[edi+2]

 mov ds,ax
 Call FastCopyBlock

 Pop es
 pop ds
End;



Procedure Flip_VW(var Source, dest:virtualwindow);
var v:virtualwindow;
begin
if source.segment=dosmemselector then
   if dest.segment=dosmemselector
      then begin
      Init_VW(v,source.breite,source.hoehe);
      BankSVGA_to_VW(source,v);
      Bankflip_SVGA(v,dest);
      Kill_VW(v);
      end
      else BankSVGA_to_VW(source,dest)
   else
   if dest.segment=dosmemselector
      then Bankflip_SVGA(source,dest)
      else LFBFlip_VW(source,dest);
end;


Procedure LFBFlip_VW_and_clrscr(var Source, dest:virtualwindow;c:word);assembler;
Asm
 Push es
 Mov esi,Source
 Mov bx ,ds:[esi  ]
 Mov esi,ds:[esi+2]

 Mov edi,Dest
 Mov ecx,ds:[edi+6]
 Mov es ,ds:[edi  ]
 Mov edi,ds:[edi+2]

 mov ax,c
 shl eax,16
 mov ax,c

 Call FastCopyAndDelBlock

 Pop es
End;


Procedure Flip_VW_and_clrscr(var Source, dest:virtualwindow;c:word);
var v:virtualwindow;
begin
if source.segment=dosmemselector then
   if dest.segment=dosmemselector
      then begin
      Init_VW(v,source.breite,source.hoehe);
      BankSVGA_to_VW(source,v);
      Bankflip_SVGA(v,dest);
      Kill_VW(v);
      Clr(source,c);
      end
      else begin
      {Je mozne pouzit proceduru: BankSVGA_to_VW_and_clrscr(source,dest,c);
       ...ale praxe ukazuje, ze je asi rychlejsi proste zavolat dvojici
       procedur na samostatne kopirovani a samostatne mazani, t.j.:}
      BankSVGA_to_VW(source,dest);
      Clr(source,c);
      end
   else
   if dest.segment=dosmemselector
      then begin
      {Je mozne pouzit proceduru: BankFlip_SVGA_and_clrscr(source,dest,c);
       ...ale praxe ukazuje, ze je asi rychlejsi proste zavolat dvojici
       procedur na samostatne kopirovani a samostatne mazani, t.j.:}
      BankSVGA_to_VW(source,dest);
      Clr(source,c);
      end
      else LFBFlip_VW_and_clrscr(source,dest,c);
end;


PROCEDURE Flip_SVGA(var source:virtualwindow);
begin
if VESAMODEINFO.LFB_Supported then
   Flip_VW(Source,vga) else BankFlip_SVGA(Source,vga);
end;


Procedure Flip_SVGA_and_clrscr(var source:virtualwindow;c:word);
begin
if VESAMODEINFO.LFB_Supported then
   Flip_VW_and_clrscr(Source,vga,c) else BankFlip_SVGA_and_clrscr(Source,vga,c);
end;


PROCEDURE Flip_SVGB(var source:virtualwindow);
begin
if VESAMODEINFO.LFB_Supported or (pagging_mode=PAG_BUF) then
   Flip_VW(Source,vgb) else BankFlip_SVGA(Source,vgb);
end;


Procedure Flip_SVGB_and_clrscr(var source:virtualwindow;c:word);
begin
if VESAMODEINFO.LFB_Supported or (pagging_mode=PAG_BUF) then
   Flip_VW_and_clrscr(Source,vgb,c) else BankFlip_SVGA_and_clrscr(Source,vgb,c);
end;



Procedure Flip_page;
var v:virtualwindow;
    b:boolean;
begin
if pagging_mode=PAG_NO then Exit;
if pagging_mode=PAG_DBL then
   begin
   MouseLock;     {teoreticky by se MouseLock/Unlock volat melo...}
   if mouse_driver_installed and mouse.visible then MouseSelfCopy(vgb,0,0);
   if page_active=1 then begin b:=SetLogicDisplay(0,vga.hoehe);page_active:=2;end
                    else begin b:=SetLogicDisplay(0,0);page_active:=1;end;

   b:=mouse.workplace.vwoffset=vga.vwoffset;
   if B then
      begin
      mouse.workplace:=vgb;
      end;
   MouseUnlock;
   v:=vga;
   vga:=vgb;
   vgb:=v;
   WaitRetrace;     {neni mi jasne, proc musi byt az PO zmene, ale je to tak}
   if pag_color<>PAG_NOCLEAR then clr(vgb,pag_color);
   end
   else begin
   {WaitRetrace;}
   mouselock;
   if mouse_driver_installed and mouse.visible then MouseSelfCopy(vgb,0,0);
   mouseunlock;
   if pag_color<>PAG_NOCLEAR
      then Flip_SVGA_and_clrscr(vgb,pag_color)
      else Flip_SVGA(vgb);
   end;
end;

Procedure Kill_pagging;
begin
if pagging_mode=PAG_BUF then Kill_VW(vgb) else
if pagging_mode=PAG_DBL then SetLogicDisplay(0,0);
end;

PROCEDURE Syntesis(var Dest,Source,Mapa:VirtualWindow;c:word);assembler;
Asm
 Push ds
 Push es
   Mov esi,Source
   Mov ax ,ds:[esi  ]
   Mov esi,ds:[esi+2]

   mov ebx,Mapa
   mov ebx,ds:[ebx+2]

   Mov edi,Dest
   Mov ecx,ds:[edi+6]
   Mov es ,ds:[edi  ]
   Mov edi,ds:[edi+2]
   Mov ds ,ax

   shr ecx,1

@dalsi_word:
   mov ax,ds:[ebx];add ebx,2
   or ax,ax
   jnz @pixel_v_mape

   mov ax,ds:[esi]
@pixel_v_mape:
   mov es:[edi],ax

@spoj:
   add esi,2
   add edi,2

   dec ecx
   jnz @dalsi_word

 pop es
 pop ds
end;

Procedure LFBPutSpriteRegion(var dest, source:virtualwindow;x1,y1,x2,y2,dstx,dsty:longint);assembler;
{1. procedure is fully clipped}
{2. Both - Dest and Source, can be VGA in LFB mode}
VAR       srcbytebreite    : LongInt;
          dstbytebreite    : LongInt;
          srcstart         : Longint;
 Asm
{Prvni faze clippingu - Source vs. vyrez}
  mov edi,source
  mov eax,x1
  mov ebx,y1
  mov ecx,x2
  mov edx,y2
  Call BarClipping
  jc @Konec           {zadany rozsah mimo zdroj, neni co zobrazovat}

  mov srcstart,ebx    {pocatek zobrazeni Source po zpracovani clippingem}

{Druha faze clippingu - Dest vs. source}

  mov esi,source             {ted vystupuje jakoby v roli Sprite}
  mov edi,dest

  push dword [esi+10]              {ulozim rozmery Source}
  push dword [esi+26]
  push dword [esi+30]

  {Zamenim rozmery Source za hodnoty, ktere by odpovidaly samotnemu vyrezu}
  mov  [esi+30],edx          {hoehe}
  mov  [esi+26],ecx          {bytebreite}
  shr ecx,1
  mov  [esi+10],ecx          {breite}

  mov eax,dstx
  mov ebx,dsty
  Call SpriteClipping

  pop dword [esi+30]               {obnovim skutecne rozmery Source}
  pop dword [esi+26]
  pop dword [esi+10]
  jc @konec {predchozimi POP priznaky zmeneny nebyly, neni co zobr. -> konec}
{----------------------------------------------------------------------------}
push es
push ds
  mov eax,[edi+26]
  mov dstbytebreite,eax
  mov eax,[esi+26]
  mov srcbytebreite,eax
  mov es,[edi+0]
  mov edi,ds:[edi+2]
  add edi,ebx       {a mame startovni pozici pro DEST}
  mov ax,[esi+0]
  mov esi,[esi+2]
  mov ds,ax         {a od ted nemuzu pristupovat k SOURCE ani DEST}
  add esi,srcstart

  @SCANLINES_LOOP:
  push esi
  push edi
  push ecx
  sar ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
  pop ecx
  pop edi
  pop esi
  add edi,dstbytebreite
  add esi,srcbytebreite
  dec edx
  jnz @SCANLINES_LOOP

pop ds
Pop es

@konec:
End;

Procedure Desaturation(var cil:virtualwindow;hodnota,hodnota2:real);
var r,g,b:byte;
    r1,g1,b1:real;
    r2,g2,b2:byte;
    x,y:longint;
    t:word;
begin
for y:=0 to cil.hoeheminus1 do
    for x:=0 to cil.breiteminus1 do
        begin
        t:=GetPixel(cil,x,y);
        Word2RGB(t,r,g,b);
        r:=r*2;
        b:=b*2;
        r1:=(g+b+r*hodnota) / hodnota2;
        b1:=(g+r+b*hodnota) / hodnota2;
        g1:=(r+b+g*hodnota) / hodnota2;
        if r1>255 then r2:=255 else r2:=round(r1);
        if g1>255 then g2:=255 else g2:=round(g1);
        if b1>255 then b2:=255 else b2:=round(b1);
        t:=MyRGB2word(r2,g2,b2);
        PutPixel(cil,x,y,t);
        end;
end;




Procedure BarFromLineHorz(var dest:virtualwindow;x1,y1,x2,y2:longint;color:word);
var a:longint;
begin
for a:=y1 to y2 do LineHorz(dest,x1,x2,a,color);
end;


Procedure Videosignal_Off;assembler;
asm
mov dx,3c4h
mov al,1
out dx,al
inc dx
in al,dx
or al,20h
out dx,al
end;

Procedure Videosignal_On;assembler;
asm
mov dx,3c4h
mov al,1
out dx,al
inc dx
in al,dx
and al,0dfh
out dx,al
end;


Function RGB2word(r,g,b:byte):word;assembler;
{Hodnoty R,B jsou v rozsahu 0-31 a G je 0-63 a jsou poskladany do wordu}
asm
mov ah,r
movzx bx,g
mov al,b
shl ah,3
shl bx,5
and al,31
or ax,bx
end;


Function MyRGB2word(r,g,b:byte):word;assembler;
{Hodnoty R,G,B jsou v rozsahu 0-255 a jsou prepocitany na barvu typu word}
ASM
  XOR EAX,EAX
  MOV AL,b
  SHR AL,3
  MOV AH,r
  AND AX,0F81Fh

  MOVZX BX,g
  SHL BX,3
  AND BX,07E0h
  OR AX,BX
END;


Function RGB32_16(d:dword):dword;assembler;
asm
mov eax,d
movzx bx,ah
mov ah,al
shr eax,8
shr al,3
and ax,0f81fh

shl bx,3
and bx,07E0h
or ax,bx
and eax,0000FFFFh
end;


Function Split_R(w:word):byte;assembler;
asm
movzx eax,w
shr eax,11
end;

Function Split_G(w:word):byte;assembler;
asm
movzx eax,w
shr eax,5
and eax,63
end;

Function Split_B(w:word):byte;assembler;
asm
movzx eax,w
and eax,31
end;

Function DarkenColor(w:word;b:byte):word;assembler;
asm
mov ax,w
mov dl,b
mov bx,ax
mov cx,ax
shr ax,11          {R}
shr bx,5;and bx,63 {G}
and cx,31          {B}
sub al,dl
jnc @ok1
  xor al,al
@ok1:

shl dl,1           {G has twice times "weight"}
sub bl,dl
jnc @ok2
  xor bl,bl
@ok2:
shr dl,1
sub cl,b
jnc @ok3
  xor cl,cl
@ok3:
shl ax,11
shl bx,5
add ax,bx
add ax,cx
end;


Procedure Clr(var dest:virtualwindow;Color:Word);
begin
if dest.segment=dosmemselector then BankClr(dest,color)
   else ClrSprite(dest,color);
end;


Procedure PutSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
begin
if dest.segment=dosmemselector
   then BankPutClippedSprite(dest,sprite,x,y)
   else LFBPutSprite(dest,sprite,x,y);
end;

Procedure GetSprite(var Source,Sprite:VirtualWindow;x,y:LongInt);
begin
if source.segment=dosmemselector
   then BankGetClippedSprite(source,sprite,x,y)
   else LFBGetSprite(source,sprite,x,y);
end;

Procedure PutClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
begin
if dest.segment=dosmemselector
   then BankPutClippedSprite(dest,sprite,x,y)
   else LFBPutClippedSprite(dest,sprite,x,y);
end;

Procedure GetClippedSprite(var source,sprite:VirtualWindow;x,y:LongInt);
begin
if source.segment=dosmemselector
   then BankGetClippedSprite(source,sprite,x,y)
   else LFBGetClippedSprite(source,sprite,x,y);
end;

Procedure PutHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
{as transparent color SPRITE.TransCol will be used}
begin
if dest.segment=dosmemselector
   then BankPutClippedHCSprite(dest,sprite,x,y,sprite.TransCol)
   else LFBPutHCSprite(dest,sprite,x,y,sprite.TransCol);
end;


Procedure PutHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);
{as transparent color HideColor will be used}
var ofl:byte;
begin
ofl:=sprite.flags;
if HideColor<>Sprite.TransCol then
   sprite.flags:=sprite.flags and 253; {vymaze 1.bit}
if dest.segment=dosmemselector
   then BankPutClippedHCSprite(dest,sprite,x,y,HideColor)
   else LFBPutHCSprite(dest,sprite,x,y,HideColor);
sprite.flags:=ofl;
end;

Procedure PutClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);
{as transparent color SPRITE.TransCol will be used}
begin
if dest.segment=dosmemselector
   then BankPutClippedHCSprite(dest,sprite,x,y,sprite.TransCol)
   else LFBPutClippedHCSprite(dest,sprite,x,y,sprite.TransCol);
end;

Procedure PutClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);
{as transparent color HideColor will be used}
var ofl:byte;
begin
ofl:=sprite.flags;
if HideColor<>Sprite.TransCol then
   sprite.flags:=sprite.flags and 253; {vymaze 1.bit}
if dest.segment=dosmemselector
   then BankPutClippedHCSprite(dest,sprite,x,y,HideColor)
   else LFBPutClippedHCSprite(dest,sprite,x,y,HideColor);
sprite.flags:=ofl;
end;


Procedure PutSprite_and_clear(var Dest, Sprite:VirtualWindow;x,y:longint;c:word);
{procedure is clipped}
begin
if dest.segment=dosmemselector
   then begin
   BankPutClippedSprite(dest,sprite,x,y);
   ClrSprite(sprite,c);
   end
   else LFBPutSprite_and_clear(dest,sprite,x,y,c);
end;


Procedure PutSpriteRegion(var dest, source:virtualwindow;x1,y1,x2,y2,dstx,dsty:longint);
var b:byte;
    v:virtualwindow;
begin
if (dest.segment=dosmemselector) or (source.segment=dosmemselector)
   then begin
   if (x2<0) or (y2<0) or (x1>=source.breite) or (y1>=source.hoehe) then Exit;
   if x1<0 then x1:=0;
   if y1<0 then y1:=0;
   if x2>=source.breite then x2:=source.breite-1;
   if y2>=source.hoehe then y2:=source.hoehe-1;
   Init_VW(v,x2-x1+1,y2-y1+1);
   GetSprite(source,v,x1,y1);
   PutClippedSprite(dest,v,dstx,dsty);
   Kill_VW(v);
   end
   else LFBPutSpriteRegion(dest,source,x1,y1,x2,y2,dstx,dsty);
end;


Function Min_value(a,b:longint):longint;
begin
if a<b then Min_value:=a else Min_Value:=b;
end;

Function Max_value(a,b:longint):longint;
begin
if a>b then Max_value:=a else Max_Value:=b;
end;


Function EqualRectangles(ax1,ay1,ax2,ay2,bx1,by1,bx2,by2:longint):boolean;
begin
EqualRectangles:=(ax1=bx1) and (ay1=by1) and (ax2=bx2) and (ay2=by2);
end;


Function Intersection(ax1,ay1,ax2,ay2,bx1,by1,bx2,by2:longint;var cx1,cy1,cx2,cy2:longint):byte;
{0 = no intersection}
{1 = rectangles are equal}
{2 = rectangle A contains whole rectangle B}
{3 = rectangle B contains whole rectangle A}
{4 = there is intersection between rectangles A and B}
begin
cx1:=0;
cy1:=0;
cx2:=0;
cy2:=0;
Intersection:=0;

if (ax1<=bx2) and (ax2>=bx1) and (ay1<=by2) and (ay2>=by1) then
   begin      {Vime, ze je alespon nejaky prunik}

   if EqualRectangles(ax1,ay1,ax2,ay2,bx1,by1,bx2,by2) then
      begin   {Nejsou zadane ctyruhelniky shodne?}
      cx1:=ax1;cy1:=ay1;cx2:=ax2;cy2:=ay2;
      Exit(1);
      end;

   Intersection:=4;

   cx1:=max_value(ax1,bx1);
   cy1:=max_value(ay1,by1);
   cx2:=min_value(ax2,bx2);
   cy2:=min_value(ay2,by2);

   if EqualRectangles(ax1,ay1,ax2,ay2,cx1,cy1,cx2,cy2) then Intersection:=3 else
   if EqualRectangles(bx1,by1,bx2,by2,cx1,cy1,cx2,cy2) then Intersection:=2
   end;
end;




PROCEDURE PutViewportClippedSprite(var Dest:virtualwindow;x1,y1,x2,y2:longint;Sprite:VirtualWindow;x,y:LongInt);
var sx1,sy1,sx2,sy2:longint;
    nx1,ny1,nx2,ny2:longint;
    b:byte;
    prac:virtualwindow;


begin
sx1:=x;
sy1:=y;
sx2:=x+sprite.breiteminus1;
sy2:=y+sprite.hoeheminus1;

b:=Intersection(x1,y1,x2,y2,sx1,sy1,sx2,sy2,nx1,ny1,nx2,ny2);

if b=0 then Exit;
if (b=1) or (b=2) then PutClippedSprite(dest,sprite,x,y) else
   begin
   Init_vw(prac,nx2-nx1+1,ny2-ny1+1,false);

   if x<x1 then sx1:=x-x1 else sx1:=0;
   if y<x1 then sy1:=y-y1 else sy1:=0;

   PutClippedSprite(prac,sprite,sx1,sy1);
   PutClippedSprite(dest,prac,nx1,ny1);

   kill_vw(prac);

   end;
end;


Procedure MoveSprite(var Dest,Sprite,BackSpr:VirtualWindow;ox,oy,x,y:longint);
{Presune sprajt SPRITE z pozice OX,OY na pozici X,Y. V BackSpr musi byt ulozene
 pozadi zakryte aktualni polohou sprajtu. Pri presunu je radne obnoveno a
 BACKSPR je aktualizovana}

{Postup je zamereny na to, aby se cela dotcena oblast menila v jednom kroku,
 aby to neblikalo.}

var ox2,oy2:longint;
    nx2,ny2:longint;
    ux1,uy1,ux2,uy2:longint;
    temp:Virtualwindow;

begin
if (x=ox) and (y=oy) then Exit; {pozice se nemeni? - exit}

ox2:=ox+sprite.breiteminus1;
oy2:=oy+sprite.hoeheminus1;
nx2:=x+sprite.breiteminus1;
ny2:=y+sprite.hoeheminus1;

if x<ox then ux1:=x else ux1:=ox;  {mensi X1}
if y<oy then uy1:=y else uy1:=oy;  {mensi Y1}
if nx2>ox2 then ux2:=nx2 else ux2:=ox2;  {vetsi X2}
if ny2>oy2 then uy2:=ny2 else uy2:=oy2;  {vetsi Y2}

Init_VW(temp,ux2-ux1+1,uy2-uy1+1,false); {buffer pokryvajici celou dotcenou oblast}

GetClippedSprite(dest,temp,ux1,uy1);         {nahraju aktualni stav obrazovky}
PutClippedSprite(temp,BackSpr,ox-ux1,oy-uy1);{obnovim pozadi}

GetClippedSprite(temp,BackSpr,x-ux1,y-uy1);  {pripravim nove pozadi}
PutClippedSprite(temp,Sprite,x-ux1,y-uy1);   {sprajt umistim na novou pozici}

PutClippedSprite(dest,temp,ux1,uy1);     {a vykreslim buffer na obrazovku}

Kill_VW(temp);                           {smazu pracovni buffer}
end;


Procedure MoveSprite_with_bigbuffer(var Dest,Sprite,Backbuf:VirtualWindow;ox,oy,x,y:longint);
{Similar to previous procedure but in this variant in BACKBUF has to be
stored not only Sprite background but background of whole screen}
var ox2,oy2:longint;
    nx2,ny2:longint;
    ux1,uy1,ux2,uy2:longint;
    temp:Virtualwindow;
begin
if (x=ox) and (y=oy) then Exit; {pozice se nemeni? - exit}

ox2:=ox+sprite.breiteminus1;
oy2:=oy+sprite.hoeheminus1;
nx2:=x+sprite.breiteminus1;
ny2:=y+sprite.hoeheminus1;

if x<ox then ux1:=x else ux1:=ox;  {mensi X1}
if y<oy then uy1:=y else uy1:=oy;  {mensi Y1}
if nx2>ox2 then ux2:=nx2 else ux2:=ox2;  {vetsi X2}
if ny2>oy2 then uy2:=ny2 else uy2:=oy2;  {vetsi Y2}

Init_VW(temp,ux2-ux1+1,uy2-uy1+1,false); {buffer pokryvajici celou dotcenou oblast}
GetClippedSprite(backbuf,temp,ux1,uy1);
PutClippedSprite(temp,Sprite,x-ux1,y-uy1);   {sprajt umistim na novou pozici}
PutClippedSprite(dest,temp,ux1,uy1);     {a vykreslim buffer na obrazovku}
Kill_VW(temp);                           {smazu pracovni buffer}
end;


PROCEDURE Scroll(var Source, dest:virtualwindow;x,y:LongInt); Assembler;
VAR       SourceBreite : LongInt;
Asm
 Push ds
 Push es

 Mov esi,Source
 Mov eax,ds:[esi+26]
 Mov SourceBreite,eax
 Mul y
 Shl x,1
 Add eax,x
 Mov cx ,ds:[esi  ]
 Mov esi,ds:[esi+2]
 Add esi,eax

 Mov edi,Dest
 Mov ebx,ds:[edi+10]
 shr ebx,1
 Mov eax,ds:[edi+30]
 Mov es ,ds:[edi   ]
 Mov edi,ds:[edi+ 2]
 Mov edx,esi
 Mov ds,cx

 @SCANLINES_LOOP:

   Mov ecx,ebx
   Rep MovsD

   Add edx,SourceBreite
   Mov esi,edx

 Dec eax
 JNZ @SCANLINES_LOOP

 Pop es
 Pop ds
End;




PROCEDURE Rectangle(var dest:virtualwindow;x1,y1,x2,y2:LongInt;c:Word);
begin
LineHorz(dest,x1,x2,y1,c);
LineHorz(dest,x1,x2,y2,c);
LineVert(dest,x1,y1,y2,c);
LineVert(dest,x2,y1,y2,c);
end;

PROCEDURE Rectangle(var dest:virtualwindow;x1,y1,x2,y2:LongInt;t:byte;mask,c:Word);
var a,b:byte;
begin
a:=t div 2;
b:=t-a;
LineThickWithMask(dest,x1-a,y1,x2+b-1,y1,t,mask,0,c);
LineThickWithMask(dest,x1,y1,x1,y2,t,mask,0,c);
LineThickWithMask(dest,x2,y2,x2,y1,t,mask,0,c);
LineThickWithMask(dest,x2+b-1,y2,x1-a,y2,t,mask,0,c);
end;

PROCEDURE Circle(var dest:virtualwindow;x0,y0,Radius:LongInt;c: Word);
VAR x,y,p : longint;
Begin
 x:=0;
 y:=-radius;
 p:=y shl 1+3;
 While x<=-y do begin
  InternalPutPixel(Dest,x0+x,y0+y,c);
  InternalPutPixel(Dest,x0-x,y0+y,c);
  InternalPutPixel(Dest,x0+x,y0-y,c);
  InternalPutPixel(Dest,x0-x,y0-y,c);
  InternalPutPixel(Dest,x0+y,y0+x,c);
  InternalPutPixel(Dest,x0-y,y0+x,c);
  InternalPutPixel(Dest,x0+y,y0-x,c);
  InternalPutPixel(Dest,x0-y,y0-x,c);
  if p>=0 then
  begin
   inc(y);
   inc(p,(x+y) shl 2+6);
  end else inc(p,x shl 2+6);
  inc(x);
 End;
END;


Procedure Circle(var dest:virtualwindow;x0,y0,Radius:LongInt;t:byte;c:Word);
begin
if t=0 then Exit else
if t=1 then Circle(dest,x0,y0,Radius,c) else
RotatedEllipse(dest,x0,y0,radius,radius,0,t,c);
end;


Procedure FilledCircle(var dest:virtualwindow;x0,y0,Radius:LongInt;c,d:Word);
VAR x,y,p : longint;
Begin
 x:=0;
 y:=-radius;
 p:=y shl 1+3;
 While x<=-y do begin
 LineHorz (Dest,x0-x,x0+x,y0+y,d);
  LineHorz (Dest,x0-x,x0+x,y0-y,d);
  LineHorz (Dest,x0-y,x0+y,y0+x,d);
  LineHorz (Dest,x0-y,x0+y,y0-x,d);
  if p>=0 then
  begin
   inc(y);
   inc(p,(x+y) shl 2+6);
  end else inc(p,x shl 2+6);
  inc(x);
 End;
if c<>d then Circle(dest,x0,y0,radius,c)
END;


Procedure FilledCircle(var dest:virtualwindow;x0,y0,Radius:LongInt;t:byte;c,d:Word);
begin
if t=0 then Exit else
if t=1 then FilledCircle(dest,x0,y0,radius,c,d) else
RotatedFilledEllipse(dest,x0,y0,radius,radius,0,t,c,d);
end;


procedure Ellipse(var dest:virtualwindow;x0,y0,radiusX,radiusY:longint;c:word);
var x,y,a,b,as,tas,bs,tbs:longint;
    d,dx,dy:longint;
Begin
if radiusX=0 then begin
             LineVert(Dest,x0,y0-radiusY,y0+radiusY,c);
             Exit;
             end;
if radiusY=0 then begin
             LineHorz(dest,x0-radiusX,x0+radiusX,y0,c);
             Exit;
             end;
x:=0; y:=radiusY; a:=radiusX; b:=radiusY; as:=a*a;
tas:=as shl 1; bs:=b*b; tbs:=bs shl 1;
d:=bs-as*b+(as shr 2); dx:=0; dy:=tas*b;
while dx<dy do begin
               InternalPutPixel(dest,x0+x,y0+y,c);
               InternalPutPixel(dest,x0-x,y0+y,c);
               InternalPutPixel(dest,x0+x,y0-y,c);
               InternalPutPixel(dest,x0-x,y0-y,c);
               if d>0 then begin y:=y-1; dy:=dy-tas; d:=d-dy; end;
               Inc(x); dx:=dx+tbs; d:=d+bs+dx;
               end;
d:=d+((3*(as-bs)div 2-(dx+dy))div 2);
while y>0 do begin
             InternalPutPixel(dest,x0+x,y0+y,c);
             InternalPutPixel(dest,x0-x,y0+y,c);
             InternalPutPixel(dest,x0+x,y0-y,c);
             InternalPutPixel(dest,x0-x,y0-y,c);
             if d<0 then begin Inc(x); dx:=dx+tbs; d:=d+dx; end;
             y:=y-1; dy:=dy-tas; d:=d+as-dy;
             end;
InternalPutPixel(dest,x0+x,y0,c);
InternalPutPixel(dest,x0-x,y0,c);
End;{_ellipse}


procedure Ellipse(var dest:virtualwindow;x0,y0,radiusX,radiusY:longint;t:byte;c:word);
begin
if t=0 then Exit else
if t=1 then Ellipse(dest,x0,y0,radiusX,radiusY,c) else
RotatedEllipse(vga,x0,y0,radiusX,radiusY,0,t,c);
end;


Procedure FilledEllipse(var dest:virtualwindow;x0,y0,RadiusX,RadiusY:longint;c,d:word);
var x,y,a,b,as,tas,bs,tbs:longint;
    dd,dx,dy:longint;
Begin
if radiusX=0 then begin
             LineVert(Dest,x0,y0-radiusY,y0+radiusY,c);
             Exit;
             end;
if radiusY=0 then begin
             LineHorz(dest,x0-radiusX,x0+radiusX,y0,c);
             Exit;
             end;
x:=0; y:=radiusY; a:=radiusX; b:=radiusY; as:=a*a;
tas:=as shl 1; bs:=b*b; tbs:=bs shl 1;
dd:=bs-as*b+(as shr 2); dx:=0; dy:=tas*b;
while dx<dy do begin
               LineHorz(dest,x0-x,x0+x,y0+y,d);
               LineHorz(dest,x0-x,x0+x,y0-y,d);
               if dd>0 then begin y:=y-1; dy:=dy-tas; dd:=dd-dy; end;
               Inc(x); dx:=dx+tbs; dd:=dd+bs+dx;
               end;
dd:=dd+((3*(as-bs)div 2-(dx+dy))div 2);
while y>0 do begin
             LineHorz(dest,x0-x,x0+x,y0+y,d);
             LineHorz(dest,x0-x,x0+x,y0-y,d);
             if dd<0 then begin Inc(x); dx:=dx+tbs; dd:=dd+dx; end;
             y:=y-1; dy:=dy-tas; dd:=dd+as-dy;
             end;
LineHorz(dest,x0-x,x0+x,y0,d);
if c<>d then Ellipse(dest,x0,y0,radiusX,RadiusY,c);
End;{_filledellipse}


Procedure FilledEllipse(var dest:virtualwindow;x0,y0,RadiusX,RadiusY:longint;t:byte;c,d:word);
begin
if t=0 then Exit else
if t=1 then FilledEllipse(dest,x0,y0,RadiusX,RadiusY,c,d) else
RotatedFilledEllipse(vga,x0,y0,radiusX,radiusY,0,t,c,d);
end;


Procedure EllipseScan(var dest:virtualwindow;x1,x2,y:longint;c,d:word);
var plx1, plx2: smallint;
begin
If (x1 = -maxlongint) Then
   If (x2 = maxlongint-1) Then  {na tomto radku neni oblouk elipsy}
      If (((Y < ArcCall.Y) and (Y > ArcCall.YStart)) or
          ((Y > ArcCall.Y) and (Y < ArcCall.YStart))) Then
         {Nicnene, co kdyz jsme uvnitr vysece?}
         {plati ze:                           }
         {y-y1=(y2-y1)/(x2-x1)*(x-x1) =>      }
         {x = (y-y1)/(y2-y1)*(x2-x1)+x1       }
         Begin
           plx1 := (y-ArcCall.Y)*(ArcCall.XStart-ArcCall.X)
                   div (ArcCall.YStart-ArcCall.Y)+ArcCall.X;
           plx2 := (y-ArcCall.Y)*(ArcCall.XEnd-ArcCall.X)
                   div (ArcCall.YEnd-ArcCall.Y)+ArcCall.X;
           If plx1 > plx2 then            {prohozeni promennych}
             begin
               plx1 := plx1 xor plx2;
               plx2 := plx1 xor plx2;
               plx1 := plx1 xor plx2;
             end;
         End
       Else exit   {jsme uplne mimo vysec}
     Else
       {zleva je radka ohranicena okrajem vysece, zprava kusem oblouku}
       {levy bod tedy dopocitam pomoci rovnice primky, pravy znam}
       Begin
         If (y < ArcCall.Y) then
           begin
             plx1 := (y-ArcCall.Y)*(ArcCall.XEnd-ArcCall.X)
                     div (ArcCall.YEnd-ArcCall.Y)+ArcCall.X
           end
         else if (y > ArcCall.Y) then
           begin
             plx1 := (y-ArcCall.Y)*(ArcCall.XStart-ArcCall.X)
                     div (ArcCall.YStart-ArcCall.Y)+ArcCall.X
             end
         else plx1 := ArcCall.X;
         plx2 := x2;
       End
   Else
     If (x2 = maxlongint-1) Then
       {zprava je radka ohranicena okrajem vysece, zleva kusem oblouku}
       {pravy bod tedy dopocitam pomoci rovnice primky, levy znam}
       Begin
         If (y < ArcCall.Y) then
           begin
             plx2 := (y-ArcCall.Y)*(ArcCall.XStart-ArcCall.X)
                     div (ArcCall.YStart-ArcCall.Y)+ArcCall.X
           end
         else if (y > ArcCall.Y) then
           begin
             plx2 := (y-ArcCall.Y)*(ArcCall.XEnd-ArcCall.X)
                     div (ArcCall.YEnd-ArcCall.Y)+ArcCall.X
           end
         else plx2 := ArcCall.X;
         plx1 := x1;
       End
     Else begin {zname oba body}
     plx1 := x1;
     plx2 := x2;
     End;
If plx2>plx1 then LineHorz(dest,plx1,plx2,y,d);
end;


Procedure EllipseScan2(var dest:virtualwindow;x1,x2,y:longint;c,d:word);
var plx1, plx2: smallint;
begin
If (x1 = -maxlongint) Then
   If (x2 = maxlongint-1) Then  {na tomto radku neni oblouk elipsy}
      If (((Y < ArcCall.Y) and (Y > ArcCall.YStart)) or
          ((Y > ArcCall.Y) and (Y < ArcCall.YStart))) Then
         {Nicnene, co kdyz jsme uvnitr vysece?}
         {plati ze:                           }
         {y-y1=(y2-y1)/(x2-x1)*(x-x1) =>      }
         {x = (y-y1)/(y2-y1)*(x2-x1)+x1       }
         Begin
         exit;
           plx1 := (y-ArcCall.Y)*(ArcCall.XStart-ArcCall.X)
                   div (ArcCall.YStart-ArcCall.Y)+ArcCall.X;
           plx2 := (y-ArcCall.Y)*(ArcCall.XEnd-ArcCall.X)
                   div (ArcCall.YEnd-ArcCall.Y)+ArcCall.X;
           If plx1 > plx2 then            {prohozeni promennych}
             begin
               plx1 := plx1 xor plx2;
               plx2 := plx1 xor plx2;
               plx1 := plx1 xor plx2;
             end;
         End
       Else exit   {jsme uplne mimo vysec}
     Else
       {zleva je radka ohranicena okrajem vysece, zprava kusem oblouku}
       {levy bod tedy dopocitam pomoci rovnice primky, pravy znam}
       Begin
         If (y < ArcCall.Y) then
           begin
             plx1 := (y-ArcCall.Y)*(ArcCall.XEnd-ArcCall.X)
                     div (ArcCall.YEnd-ArcCall.Y)+ArcCall.X
           end
         else if (y > ArcCall.Y) then
           begin
             plx1 := (y-ArcCall.Y)*(ArcCall.XStart-ArcCall.X)
                     div (ArcCall.YStart-ArcCall.Y)+ArcCall.X
             end
         else plx1 := ArcCall.X;
         plx2 := x2;
       End
   Else
     If (x2 = maxlongint-1) Then
       {zprava je radka ohranicena okrajem vysece, zleva kusem oblouku}
       {pravy bod tedy dopocitam pomoci rovnice primky, levy znam}
       Begin
         If (y < ArcCall.Y) then
           begin
             plx2 := (y-ArcCall.Y)*(ArcCall.XStart-ArcCall.X)
                     div (ArcCall.YStart-ArcCall.Y)+ArcCall.X
           end
         else if (y > ArcCall.Y) then
           begin
             plx2 := (y-ArcCall.Y)*(ArcCall.XEnd-ArcCall.X)
                     div (ArcCall.YEnd-ArcCall.Y)+ArcCall.X
           end
         else plx2 := ArcCall.X;
         plx1 := x1;
       End
     Else begin {zname oba body}
     plx1 := x1;
     plx2 := x2;
     End;
If plx2>plx1 then LineHorz(dest,plx1,plx2,y,d);

end;


Procedure InternalEllipse(var dest:virtualwindow;X,Y,Xradius,Yradius,
                          stAngle,EndAngle,h:longint;fill:boolean;c,d:word);
Const ConvFac = Pi/180.0;
var j, Delta, DeltaEnd:real;
    NumOfPixels: longint;
    TempTerm:real;
    xtemp, ytemp, xp, yp, xm, ym, xnext, ynext, plxpyp, plxmyp:longint;
    plxpym,plxmym,tmpangle:longint;

begin
NumOfPixels:=Round(Sqrt(3)*sqrt(sqr(XRadius)+sqr(YRadius)));
{priblizny pocet pixelu, ze kterych by se skladala cela elipsa}
Delta := 90.0 / NumOfPixels;
{...a z kolika useku?}

TempTerm := (StAngle)*ConvFac;
ArcCall.X:=x;
ArcCall.Y:=y;
ArcCall.XStart := round(XRadius*Cos(TempTerm)) + X;
ArcCall.YStart := round(YRadius*Sin(TempTerm+Pi)) + Y;
TempTerm := (EndAngle)*ConvFac;
ArcCall.XEnd := round(XRadius*Cos(TempTerm)) + X;
ArcCall.YEnd := round(YRadius*Sin(TempTerm+Pi)) + Y;


j := 0;         {Vzhledem ke stranove symetrii staci pocitat jeden kvadrant}
DeltaEnd := 91; {ostatni se mohou zkopirovat. Dalo by se zoptimalizovat pro}
                {pripady, kdy oba konce lezi v jednom kvadrantu}

xnext := XRadius;
ynext := 0;

repeat
   xtemp := xnext;
   ytemp := ynext;

   TempTerm := (j+Delta)*ConvFac;  {pro sin i cos}
   xnext := round(XRadius*Cos(TempTerm));
   ynext := round(YRadius*Sin(TempTerm+Pi));

   xp := x + xtemp;
   xm := x - xtemp;
   yp := y + ytemp;
   ym := y - ytemp;
   plxpyp := maxlongint;
   plxmyp := -maxlongint-1;
   plxpym := maxlongint;
   plxmym := -maxlongint-1;


     If (j >= StAngle) and (j <= EndAngle) then
        begin
        InternalPutPixel(dest,xp,yp,c);
        plxpyp := xp;
        end;

     If ((180-j) >= StAngle) and ((180-j) <= EndAngle) then
        begin
        InternalPutPixel(dest,xm,yp,c);
        plxmyp := xm;
        end;

     If ((j+180) >= StAngle) and ((j+180) <= EndAngle) then
        begin
        InternalPutPixel(dest,xm,ym,c);
        if h>0 then
           begin
           LineVert(dest,xm,ym+1,ym+h,c);
           {InternalPutPixel(dest,xm,ym+h+1,c);}
           end;
        plxmym := xm;
        end;

     If ((360-j) >= StAngle) and ((360-j) <= EndAngle) then
        begin
        InternalPutPixel(dest,xp,ym,c);
        if h>0 then
           begin
           LineVert(dest,xp,ym+1,ym+h,c);
           {InternalPutPixel(dest,xp,ym+h+1,c);}
           end;
        plxpym := xp;
        end;


     If (fill=true) and (ynext <> ytemp) and (xp - xm >= 1) then
        begin
        {EllipseScan}ArcCall.EllipseScan(dest,plxmyp+1,plxpyp-1,yp,c,d);
        {EllipseScan}ArcCall.EllipseScan(dest,plxmym+1,plxpym-1,ym,c,d);
        end;


     j:=j+Delta;
   Until j > (DeltaEnd);
end;

Procedure PreinternalEllipse(var dest:virtualwindow;X,Y,Xradius,Yradius,
                          _stAngle,_EndAngle,h:longint;fill:boolean;c,d:word);

var ax,ay,stangle,endangle:longint;
begin
ArcCall.result:=0;
{vlasova tlouska prumeru v X nebo Y?}
If (xradius <=1)
   then if (yradius <=1)
           then InternalPutPixel(dest,x,y,c)
           else LineVert(dest,x,y-yradius div 2,yradius,c)
   else if (yradius <=1)
           then LineHorz(dest,x-xradius div 2,x,y,c)

   else begin
   ArcCall.result:=1;

   stangle := _stAngle mod 360;        {uprav pripadne "pretoceni kruhu"}
   EndAngle := _EndAngle mod 360;
   if stangle<0 then stangle:=360+stangle;    {a pores zaporne hodnoty}
   if endangle<0 then endangle:=360+endangle;

   if (stangle=endangle) and (_endangle>_stangle)
      then begin
      InternalEllipse(dest,x,y,XRadius,YRadius,0,360,h,fill,c,d);
      Exit;
      end;

   if endangle<stangle then
      begin
      InternalEllipse(dest,x,y,Xradius,Yradius,StAngle,360,h,fill,c,d);
      ax:=ArcCall.XStart;
      ay:=ArcCall.YStart;
      InternalEllipse(dest,x,y,Xradius,Yradius,0,EndAngle,h,fill,c,d);
      ArcCall.XStart:=ax;
      ArcCall.YStart:=ay;
      end
      else InternalEllipse(dest,x,y,Xradius,Yradius,StAngle,EndAngle,h,fill,c,d);
   end;
end;


Procedure Arc(var dest:virtualwindow;x,y,xr,yr,zacatek,konec:longint;c:word);
begin
PreInternalEllipse(dest,x,y,xr,yr,zacatek,konec,0,false,c,c);
end;


Procedure Sector(var dest:virtualwindow;x,y,xr,yr,zacatek,konec:longint;c:word);
begin
PreInternalEllipse(dest,x,y,xr,yr,zacatek,konec,0,false,c,c);
LineClipped(dest,x,y,arccall.xstart,arccall.ystart,c);
LineClipped(dest,x,y,arccall.xend,arccall.yend,c);
end;


Procedure PieSlice(var dest:virtualwindow;x,y,xr,yr,zacatek,konec:longint;c,d:word);
begin
PreInternalEllipse(dest,x,y,xr,yr,zacatek,konec,0,true,c,d);
LineClipped(dest,x,y,arccall.xstart,arccall.ystart,c);
LineClipped(dest,x,y,arccall.xend,arccall.yend,c);
end;

Procedure PieSlice3D(var dest:virtualwindow;x,y,xr,yr,h,zacatek,konec:longint;c,d:word);
begin
if zacatek<>konec then PreInternalEllipse(dest,x,y,xr,yr,zacatek,konec,h,true,d,c);
end;


procedure ComputeRotatedEllipse(var p:PolyType;x,y,a,b,uhel,extra:longint);
{Parametr extra allocates extra corners above}
var sn,cs,xp,yp,car:real;
    xr,yr,li,theta,n:longint;
begin
uhel:=uhel mod 360;
if uhel<0 then uhel:=360+uhel;
if (rotate_granularity and 128)<>0
   then car:=rotate_granularity and 127
   else car:=pi/2*(a+b+sqrt(2*(a*a+b*b)))/rotate_granularity;
n:=round(car);
p.num:=n+extra;
GetMem(p.point,(p.num+extra+1)*8);
sn:=sinus[uhel];
cs:=cosin[uhel];
for li := 0 to n-1 do
    begin
    theta := round((li/car) * 360);
    xp := a * cosin[theta];
    yp := b * sinus[theta];
    xr := Round (x - xp*cs + yp*sn);
    yr := Round (y + xp*sn + yp*cs);
    p.point^[li+1].x:=xr;
    p.point^[li+1].y:=yr;
    {PutPixel(vga,xr,yr,65200);
    debug;}
  end;
p.point^[0].x:=xr;
p.point^[0].y:=yr;
end;


procedure ComputeRotatedArc(var p:PolyType;x,y,a,b,uhel,zacatek,konec,extra:longint);
{Parametr extra allocates extra corners above}
var sn,cs,xp,yp,car:real;
    xr,yr,li,theta,n:longint;

begin
uhel:=uhel mod 360;
zacatek:=zacatek mod 360;
konec:=konec mod 360;
if uhel<0 then uhel:=360+uhel;
if zacatek<0 then zacatek:=360+zacatek;
if konec<0 then konec:=360+konec;
if konec<zacatek then konec:=konec+360;
if (rotate_granularity and 128)<>0
   then car:=rotate_granularity and 127
   else car:=pi/2*(a+b+sqrt(2*(a*a+b*b)))/rotate_granularity;
n:=round(car*(konec-zacatek) / 360);
p.num:=n+extra+1;
GetMem(p.point,(p.num+extra+1)*8);
sn:=sinus[uhel];
cs:=cosin[uhel];
for li := 0 to n do
    begin
    theta := round((li/car) * 360);
    xp := a * cosin[theta+zacatek+180];
    yp := b * sinus[theta+zacatek+180];
    xr := Round (x - xp*cs + yp*sn);
    yr := Round (y + xp*sn + yp*cs);
    p.point^[li+1].x:=xr;
    p.point^[li+1].y:=yr;
    end;
p.point^[0].x:=xr;
p.point^[0].y:=yr;
end;


Procedure RotatedPieSlice(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;c,d:word);
var p:polytype;
begin
ComputeRotatedArc(p,x,y,xr,yr,uhel,zacatek,konec,1);
p.point^[0].x:=x;
p.point^[0].y:=y;
p.point^[p.num].x:=x;
p.point^[p.num].y:=y;
FilledPolygon(dest,p,c,d);
Kill_Poly(p);
end;


Procedure RotatedChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;c:word);
var p:polytype;
begin
ComputeRotatedArc(p,x,y,xr,yr,uhel,zacatek,konec,0);
Polygon(dest,p,c);
Kill_Poly(p);
end;


Procedure RotatedFilledChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;c,d:word);
var p:PolyType;
begin
ComputeRotatedArc(p,x,y,xr,yr,uhel,zacatek,konec,0);
FilledPolygon(dest,p,c,d);
Kill_Poly(p);
end;


Procedure RotatedChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;t:byte;c:word);
{Parameter T means thicknes of the line}
var p:polytype;
begin
ComputeRotatedArc(p,x,y,xr,yr,uhel,zacatek,konec,0);
Polygon(dest,p,c);
Kill_Poly(p);
end;


Procedure RotatedFilledChord(var dest:virtualwindow;x,y,xr,yr,uhel,zacatek,konec:longint;t:byte;c,d:word);
{Parameter T means thicknes of the line}
var p:PolyType;
begin
ComputeRotatedArc(p,x,y,xr,yr,uhel,zacatek,konec,0);
FilledPolygon(dest,p,c,d);
Kill_Poly(p);
end;


Procedure RotatedEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;c:word);
var p:PolyType;
begin
ComputeRotatedEllipse(p,x,y,xr,yr,uhel,0);
Polygon(dest,p,c);
Kill_Poly(p);
end;

Procedure RotatedEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;t:byte;c:word);
{Parameter T means thicknes of the line}
var p:PolyType;
begin
ComputeRotatedEllipse(p,x,y,xr,yr,uhel,0);
Polygon(dest,p,t,$ffff,c);
Kill_Poly(p);
end;

Procedure RotatedFilledEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;c,d:word);
var p:PolyType;
begin
ComputeRotatedEllipse(p,x,y,xr,yr,uhel,0);
FilledPolygon(dest,p,c,d);
Kill_Poly(p);
end;


Procedure RotatedFilledEllipse(var dest:Virtualwindow;x,y,xr,yr,uhel:longint;t:byte;c,d:word);
{Parameter T means thicknes of the line}
var p:PolyType;
begin
ComputeRotatedEllipse(p,x,y,xr,yr,uhel,0);
FilledPolygon(dest,p,t,$ffff,c,d);
Kill_Poly(p);
end;



Procedure RotatedNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;t:byte;mask,c:word);
var p:PolyType;
    b:byte;
begin
if (n<=0) or (mask=0) then Exit;
if n=1 then PutPixel(dest,x,y,c) else
if n=2 then LineThickwithMask(dest,x-(r div 2),x+(x-(r div 2)),t,mask,y,0,c) else
   begin
   b:=rotate_granularity;
   rotate_granularity:=128 or n;
   ComputeRotatedEllipse(p,x,y,r,r,uhel,0);
   rotate_granularity:=b;
   Polygon(dest,p,t,mask,c);
   Kill_Poly(p);
   end;
end;


Procedure RotatedNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;c:word);
begin
RotatedNShape(dest,x,y,n,r,uhel,1,$ffff,c);
end;


Procedure RotatedFilledNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;t:byte;mask,c,d:word);
var p:PolyType;
    b:byte;
begin
if n<=0 then Exit;
if n=1 then PutPixel(dest,x,y,c) else
if n=2 then LineThickwithMask(dest,x-(r div 2),x+(x-(r div 2)),t,mask,y,0,c) else
   begin
   b:=rotate_granularity;
   rotate_granularity:=128 or n;
   ComputeRotatedEllipse(p,x,y,r,r,uhel,0);
   rotate_granularity:=b;
   FilledPolygon(dest,p,t,mask,c,d);
   Kill_Poly(p);
   end;
end;

Procedure RotatedFilledNShape(var dest:virtualwindow;x,y,n,r,uhel:longint;c,d:word);
begin
RotatedFilledNShape(dest,x,y,n,r,uhel,1,$ffff,c,d);
end;


Procedure RoundRect(var dest:virtualwindow;x1,y1,x2,y2,r:longint;c:word);
begin
if r=0 then Rectangle(dest,x1,y1,x2,y2,c)
   else begin
   Arc(dest,x1+r,y1+r,r,r,90,180,c);
   Arc(dest,x2-r,y1+r,r,r,0,90,c);
   Arc(dest,x1+r,y2-r,r,r,180,270,c);
   Arc(dest,x2-r,y2-r,r,r,270,360,c);
   LineHorz(dest,x1+r,x2-r,y1,c);
   LineHorz(dest,x1+r,x2-r,y2,c);
   LineVert(dest,x1,y1+r,y2-r,c);
   LineVert(dest,x2,y1+r,y2-r,c);
   end;
end;

Procedure RoundBar(var dest:virtualwindow;x1,y1,x2,y2,r:longint;c,d:word);
begin
if r=0 then Bar(dest,x1,y1,x2,y2,c)
   else begin
   PieSlice(dest,x1+r,y1+r,r,r,90,180,c,d);
   PieSlice(dest,x2-r,y1+r,r,r,0,90,c,d);
   Pieslice(dest,x1+r,y2-r,r,r,180,270,c,d);
   PieSlice(dest,x2-r,y2-r,r,r,270,360,c,d);
   Bar(dest,x1+r,y1+r,x2-r,y2-r,d);
   Bar(dest,x1,y1+r,x1+r,y2-r,d);
   Bar(dest,x2-r,y1+r,x2,y2-r,d);
   Bar(dest,x1+r,y1,x2-r,y1+r,d);
   Bar(dest,x1+r,y2-r,x2-r,y2,d);
   if c<>d then
      begin
      LineHorz(dest,x1+r,x2-r,y1,c);
      LineHorz(dest,x1+r,x2-r,y2,c);
      LineVert(dest,x1,y1+r,y2-r,c);
      LineVert(dest,x2,y1+r,y2-r,c);
      end;
   end;
end;

Procedure ToText;assembler;
asm mov ax,4f02h;mov bx,3;int 10h;mov ax,3;int 10h;end;
{ workaround for some buggy windows drivers, which don't properly set }
{ the refresh frequency }

Procedure ToVGA;assembler;
asm mov ax,13h;int 10h;end;

Procedure ToSVGA(m:word);assembler;
asm mov ax,4f02h;mov bx,m;int 10h;end;

Procedure ToSVGA;
begin
SwitchGraph(SelectedMode);
end;

Procedure HicolorTo256(zdroj:virtualwindow;var cil:virtualwindow;var pal:palette);
var a:array[0..255] of word;
    r:word;
    q:^byte;
    p:^word;
    b:longint;
    breite,hoehe,spa:longint;
    tal:pointer;
    z,c:byte;
    f:boolean;
begin
breite:=zdroj.breite;
hoehe:=zdroj.hoehe;
 cil.Segment     := Get_DS;
 cil.Size        := Breite * Hoehe;
 cil.Breite      := Breite;
 cil.BreiteMinus1:= Breite-1;
 cil.ByteBreite  := Breite shl 1;
 cil.Hoehe       := Hoehe;
 cil.HoeheMinus1 := Hoehe-1;
 Getmem(Pointer(cil.VWOffset),cil.Size);
 EnoughMemoryOf(Pointer(cil.VWOffset),cil.Size);
p:=pointer(zdroj.VWoffset);
q:=pointer(cil.VWoffset);
FillChar(a,512,255);
z:=0;
spa:=cil.size;
FillChar(pal,768,0);
tal:=@pal;
{ prevedeme pouzite barvy do 256 barevne palety }

asm
mov ecx,spa
push ecx
mov ecx,0
mov edi,q
mov esi,p

@smycka0:
mov dx,ds:[esi];add esi,2   { nacte ze zdroje WORD }
cmp ecx,0
je @nenasli
   mov ebx,0
   push esi
   lea esi,a;
   @cykl:
      lodsw
      cmp ax,dx
      je @znama_barva
      inc ebx
      cmp ebx,ecx
      jb @cykl
   pop esi
   jmp @nenasli

@znama_barva:
pop esi
mov es:[edi],bl;inc edi
jmp @koncovy_check

@nenasli:         { radcove nenasli }
mov ebx,ecx;add ebx,ecx;add ebx,ecx {EBX:=ECX*3}
push edi
mov edi,tal
add edi,ebx       { zjistime si pozici v tabulce... }

mov ax,dx;shr ax,11;shl ax,1;stosb  { red }
mov ax,dx;shr ax,5;and ax,63;stosb  { green }
mov ax,dx;and ax,31;shl ax,1;stosb  { blue }

lea edi,a
sub ebx,ecx
add edi,ebx
mov es:[edi],dx

pop edi
mov es:[edi],cl;inc edi   { zapis indexu do palety }

cmp ecx,255
jne @OK

mov ax,03;int 10h;

@OK:
inc ecx                   { nastavime se na dalsi vstup }

@koncovy_check:
pop eax
sub eax,1
jz @konec
push eax
jmp @smycka0

@konec:
end;
end;

Procedure GetSprite256(zdroj,cil:virtualwindow;x,y:longint);
var z,c,d,e,f,g,j:longint;
begin
z:=zdroj.vwoffset;
c:=cil.vwoffset;
d:=cil.breite;
e:=cil.hoehe;
if y<0 then begin g:=-d*y;y:=0;inc(e,y);end else g:=0;
if x<0 then begin g:=g-x;d:=d+x;x:=0;end;
if 639<d+x-1 then d:=639-x+1;
f:=cil.breite-d;
if 479<e+y-1 then e:=479-y+1;
j:=640-d;
asm
mov esi,z
mov edi,c
add edi,g
mov ebx,y
mov eax,640
mul ebx
add eax,x       { mame adresu v 32bitovem registru }
add esi,eax     { nastavime se na danou souradnici ve zdroji }
mov edx,d

@smycka:
mov ecx,edx
sar ecx,2;rep movsd;adc ecx,ecx;rep movsw  {fast 32bit write}
add esi,j
add edi,f
sub e,1
jnz @smycka
end;
end;

Procedure ReplaceColor256(zdroj:virtualwindow;o,n:byte);assembler;
asm
mov esi,zdroj
mov ebx,ds:[esi+10]   { sirka }
mov eax,ds:[esi+30]   { vyska }
mov esi,ds:[esi+2]    { data }
mul ebx
mov ecx,eax
@smycka:
mov al,ds:[esi]
cmp al,o
jne @nowrite
mov al,n
mov ds:[esi],al
@nowrite:
inc esi
loop @smycka
end;

Procedure Fade_SVGA(a:byte);assembler;
asm
push es
mov es,VGA.segment
xor eax,eax
mov al,a
mov esi,eax
mov eax,bank_internal.numm
mov edx,bank_internal.grann
mul edx

mov edx,eax
add edx,bank_internal.grann

@stmivaci_smycka:
push edx
{--------------------------------------------------------------------------}
@bankovaci_smycka:  { maximalni onanie, ach jo }
sub edx,bank_internal.grann
mov ecx,edx
call bank_internal.SetBank_wr {Nastavi bank}
{--------------------------------------------------------------------------}

mov edi,bank_internal.seg_wr
add edi,65532     { max.videopamet-4 bajty }
@pixelovaci_smycka:
mov eax,es:[edi]  { natahneme dvojslovo }
mov bx,ax
and ax,2047       { cervenofobni filtr }
shr bx,11
sub bx,1
adc bx,0          { bx = bx + CF }
shl bx,11
or ax,bx     {---------------- cervena -----------------}

mov bx,ax
and ax,63519      { zelenofobni filtr }
and bx,2016       { zelenofilni filtr }
shr bx,5
sub bx,1
adc bx,0          { bx = bx + CF }
sub bx,1
adc bx,0
shl bx,5
or ax,bx     {---------------- zelena ------------------}

mov bx,ax
and ax,65504
and bx,31
sub bx,1
adc bx,0          { bx = bx + CF }
or ax,bx     {----------------- modra ------------------}

{***************************************************************************}

rol eax,16

mov bx,ax
and ax,2047       { cervenofobni filtr }
shr bx,11
sub bx,1
adc bx,0          { bx = bx + CF }
shl bx,11
or ax,bx     {---------------- cervena -----------------}

mov bx,ax
and ax,63519      { zelenofobni filtr }
and bx,2016       { zelenofilni filtr }
shr bx,5
sub bx,1
adc bx,0          { bx = bx + CF }
sub bx,1
adc bx,0
shl bx,5
or ax,bx     {---------------- zelena ------------------}

mov bx,ax
and ax,65504
and bx,31
sub bx,1
adc bx,0          { bx = bx + CF }
or ax,bx     {----------------- modra ------------------}

ror eax,16
mov es:[edi],eax
sub edi,4
jnc @pixelovaci_smycka

mov edx,ecx
cmp edx,0
jnz @bankovaci_smycka
pop edx

mov ah,1
int 16h
jnz @konec

sub esi,1
jnz @stmivaci_smycka

@konec:
pop es
end;



PROCEDURE Line(var dest:virtualwindow;x1,y1,x2,y2:LongInt;color:word);assembler;
VAR       xxADD,yyADD : LongInt;
 ASM
  Mov eax,x1
  Cmp eax,x2
  Jl  @Kleiner1
   Je @Ende1
   Mov xxAdd,-1
   Jmp @Ende1
  @Kleiner1:
  Mov xxAdd,1
  @Ende1:

  Mov eax,y1
  Cmp eax,y2
  Jl  @Kleiner2
   Je @Ende2
   Mov yyAdd,-1
   Jmp @Ende2
  @Kleiner2:
  Mov yyAdd,1
  @Ende2:

  mov eax,x1
  sub eax,x2
  cdq
  xor eax,edx
  sub eax,edx
  mov ebx,eax

  mov eax,y1
  sub eax,y2
  cdq
  xor eax,edx
  sub eax,edx

  mov edi,dest
  push eax;push ebx;push ecx;push edx;push edi

  push color
  push y1
  push x1
  push edi
  call InternalPutPixel
  pop edi;pop edx;pop ecx;pop ebx;pop eax

  cmp eax,ebx {eax=yDIFF   ebx=xDIFF}
  jg @yDIFF_bigger
     {xDIFF bigger}
     {------------}
     mov ecx,ebx
     shr ecx,1
     neg ecx
     mov edx,x1            {ecx=REST}
     mov esi,y1

     {eax=yDIFF  ebx=xDIFF  ecx=REST  edx=x1  esi=y1}
    @XDcycle:
     cmp edx,x2
     jz @end_XDcycle
        {------------}
        add ecx,eax
        add edx,xxadd
        cmp ecx,0
        jng @x_rest0
            add esi,yyadd
            sub ecx,ebx
        @x_rest0:
        push eax;push ebx;push ecx;push edx;push edi
        push color
        push esi
        push edx
        push edi
        call InternalPutPixel
        pop edi;pop edx;pop ecx;pop ebx;pop eax
        {------------}
     jmp @XDcycle
     @end_XDcycle:
     jmp @konec
     {------------}

  @yDIFF_bigger:
     {------------}
     mov ecx,eax
     shr ecx,1
     neg ecx
     mov edx,y1            {ecx=REST}
     mov esi,x1

     {eax=yDIFF  ebx=xDIFF  ecx=REST  edx=y1  esi=x1}
    @YDcycle:
     cmp edx,y2
     jz @end_YDcycle
        {-------------}
        add ecx,ebx
        add edx,yyadd
        cmp ecx,0
        jng @y_rest0
            add esi,xxadd
            sub ecx,eax
        @y_rest0:
        push eax;push ebx;push ecx;push edx;push edi
        push color
        push edx
        push esi
        push edi
        call InternalPutPixel
        pop edi;pop edx;pop ecx;pop ebx;pop eax
        {-------------}
     jmp @YDcycle
     @end_YDcycle:
@konec:
End;

Function RotateWord(var w:word):word;assembler;
asm
mov esi,w
mov ax,[esi]
rol ax,1
mov [esi],ax
end;


Function RotateMask(var w:word):longint;assembler;
asm
mov esi,w
mov bx,[esi]
cmp bx,0
jnz @ok1
mov eax,-16
jmp @konec2
@ok1:
cmp bx,0ffffh
jnz @ok2
mov eax,16
jmp @konec2
@ok2:
mov ax,bx
xor ecx,ecx
rcl bx,1
jc @plne
@prazdne:
   dec ecx
   rcl bx,1
   jnc @prazdne
   mov eax,ecx
   neg ecx
   jmp @konec
@plne:
   inc ecx
   rcl bx,1
   jc @plne
   mov eax,ecx
   jmp @konec
@konec:
mov bx,[esi]
rol bx,cl
mov [esi],bx
@konec2:
end;


function test_lineclip (p,q: real; var u1,u2: real): boolean;
var  r: real;
     v:boolean;
begin
v := true;
if p < 0 then
   begin
   r := q / p;
   if r > u2 then v := false
      else if r > u1 then u1 := r
   end else{if p < 0}
   if p > 0 then
      begin
      r := q / p;
      if r < u1 then v := false
         else if r < u2 then u2 := r;     { aktualizace u2 }

      end else {if p > 0}
          { p = 0, usecka je rovnobezna s hranici }
      if q < 0 then v := false;           { cela usecka mimo hranici }
test_lineclip := v;
end;

Function ClipLine(var dest:virtualwindow;var x1,y1,x2,y2:longint):boolean;
var  u1, u2, dx, dy: real;
begin
u1 := 0;
u2 := 1;
dx := x2 - x1;
ClipLine:=false;
if test_lineclip (-dx, x1, u1, u2) then
   if test_lineclip (dx, dest.breiteminus1 - x1, u1, u2) then
      begin
      dy := y2-y1;
      if test_lineclip (-dy, y1, u1, u2) then
         if test_lineclip (dy, dest.hoeheminus1 - y1, u1, u2) then
            begin
            if u2 < 1 then
               begin
               x2 := x1 + round(u2 * dx);
               y2 := y1 + round(u2 * dy);
               end; {if u2 < 1}
            if u1 > 0 then
               begin
               x1 := x1 + round(u1 * dx);
               y1 := y1 + round(u1 * dy);
               end; {if u2 > 1}
            ClipLine:=true;
            end;
      end;
end;

PROCEDURE LineClipped(var dest:virtualwindow;x1,y1,x2,y2:LongInt;Farbe:word);
begin
if x1=x2 then LineVert(dest,x1,y1,y2,farbe) else
if y1=y2 then LineHorz(dest,x1,x2,y1,farbe) else
   begin
   if ClipLine(dest,x1,y1,x2,y2) then Line(dest,x1,y1,x2,y2,farbe);
   end;
End;


PROCEDURE LineSlow(var dest:virtualwindow;x1,y1,x2,y2:Longint; Farbe:word);
VAR       m,n  : Real;
          Temp : LongInt;
Begin
 If x1<>x2 then
 begin

  If x1>x2 then begin
                 Temp:= x1; x1:= x2; x2:= Temp;
                 Temp:= y1; y1:= y2; y2:= Temp;
                end;

  m:= (y1-y2)/(x1-x2);
  n:= y1 - m * x1;

  For Temp:= x1 to x2 do InternalPutPixel(Dest,Temp,Round(m * Temp + n),Farbe);

 end
 else
 begin
  If y1>y2 then begin Temp:= y1; y1:= y2; y2:= Temp; end;

  For Temp:= y1 to y2 do InternalPutPixel(Dest,x1,Temp,Farbe);
 end;
End;


procedure FastLineThick(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;ending:byte;color:word);
{ENDING: 0=no round endpoints,     1=round endpoint on start
         2=round endpoint on end,  3=both endpoints are round}
var a:shortint;
    o,i:longint;
    tt:byte;
    m,n:real;
    ex:boolean;
Begin
if t=0 then Exit;
if t=1 then begin LineClipped(dest,x1,y1,x2,y2,color);Exit;end;
ex:=true;
dec(t);
tt:=t div 2;
if x1=x2 then
   if y1=y2
      then if (ending and 3)<>0 then FilledCircle(dest,x1,y1,tt,color,color)
                       else Bar(dest,x1-tt,y1-tt,x1-tt+t-1,y1-tt+t-1,color)
      else begin
      if (ending and 1)<>0 then FilledCircle(dest,x1,y1,tt,color,color);
      if (ending and 2)<>0 then FilledCircle(dest,x1,y2,tt,color,color);
      Bar(dest,x1-tt,y1,x1-tt+t-1,y2,color);
      end else
   if y1=y2
      then begin
      if (ending and 1)<>0 then FilledCircle(dest,x1,y1,tt,color,color);
      if (ending and 2)<>0 then FilledCircle(dest,x2,y1,tt,color,color);
      Bar(dest,x1,y1-tt,x2,y1-tt+t-1,color);
      end
      else ex:=false;
if EX then exit;
if abs(x1-x2)>abs(y1-y2) then
   begin
   dec(y1,tt);
   dec(y2,tt);
   if x1>x2 then a:=-1 else a:=1;
   m:= (y1-y2)/(x1-x2);
   n:= y1 - m * x1;
   i:=x1-a;
   if (ending and 1)<>0 then FilledCircle(dest,x1,y1+tt,tt,color,color);
   if (ending and 2)<>0 then FilledCircle(dest,x2,y2+tt,tt,color,color);
   repeat
      inc(i,a);
      o:=round(m*i+n);
      LineVert(Dest,i,o,o+t,color);  {vertikalni carka}
   until i=x2;
   end
   else begin
   dec(x1,tt);
   dec(x2,tt);
   if y1>y2 then a:=-1 else a:=1;
   m:= (x1-x2)/(y1-y2);
   n:= x1 - m * y1;
   i:=y1-a;
   if (ending and 1)<>0 then FilledCircle(dest,x1+tt,y1,tt,color,color);
   if (ending and 2)<>0 then FilledCircle(dest,x2+tt,y2,tt,color,color);
   repeat
      inc(i,a);
      o:=round(m*i+n);
      LineHorz(Dest,o,o+t,i,color);  {horizontalni carka}
   until i=y2;
   end;
End;


procedure LineThick(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;ending:byte;color:word);
var a:shortint;
    o,i,tt,dx,dy,dx2,dy2,dx3,dy3:longint;
    r,u,m,n:real;
    p:polytype;
Begin
if t=0 then Exit;
if t=1 then begin LineClipped(dest,x1,y1,x2,y2,color);Exit;end;
tt:=t div 2;
if (x1=x2) and (y1=y2) then
   begin
   if (ending and 3)<>0
      then FilledCircle(dest,x1,y1,tt,color,color)
      else Bar(dest,x1-tt,y1-tt,x1-tt+t,y1-tt+t,color);
   Exit;
   end;

if (ending and 1)<>0 then FilledCircle(dest,x1,y1,tt,color,color{65535,65535});
if (ending and 2)<>0 then FilledCircle(dest,x2,y2,tt,color,color{65535,65535});

if x1=x2 then
   begin
   Bar(dest,x1-tt,y1,x1-tt+t-1,y2,color);
   Exit;
   end
   else
if y1=y2 then
   begin
   Bar(dest,x1,y1-tt,x2,y1-tt+t-1,color);
   Exit;
   end;


dx:=x1-x2;
dy:=y1-y2;
r:=sqrt(dx*dx+dy*dy);
u:=t/r;
m:=dx*u;
n:=dy*u;
dx:=round(m);
dy:=round(n);
dx2:=dx div 2;
dy2:=dy div 2;
dx3:=dx-dx2;
dy3:=dy-dy2;
p.num:=4;
GetMem(p.point,(p.num+1)*8);
p.point^[1].x:=x1-dy2;
p.point^[1].y:=y1+dx2;
p.point^[3].x:=x2+dy3;
p.point^[3].y:=y2-dx3;
p.point^[2].x:=x1+dy3;
p.point^[2].y:=y1-dx3;
p.point^[4].x:=x2-dy2;
p.point^[4].y:=y2+dx2;
p.point^[0]:=p.point^[4];
filledpolygon(dest,p,color,color);
kill_poly(p);
End;


procedure LineThickWithMask(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;mask:word;ending:byte;color:word);
var dx,dy,s,u,spx,zpx:longint;
    r,x,y:real;
    a,b:longint;
    rdx,rdy,rdx1,rdy1,nx,ny,mx,my:real;
    flag:boolean;
    en:byte;

Begin
if t=0 then Exit;
if mask=0 then Exit;
if (x1=x2) and (y1=y2) then
   begin
   s:=t div 2;
   if mask>32767 then Bar(dest,x1-s,y1-s,x1-s+t-1,y1-s+t-1,color);
   Exit;
   end;

if t=1 then
   if mask=$ffff then begin LineClipped(dest,x1,y1,x2,y2,color);Exit;end
                 else begin LineWithMask(dest,x1,y1,x2,y2,mask,color);Exit;end;
if mask=$ffff then begin LineThick(dest,x1,y1,x2,y2,t,ending,color);Exit;end;


x:=x1;
y:=y1;
dx:=x2-x1;
dy:=y2-y1;
r:=sqrt(dx*dx+dy*dy);    {delka cary (pres Pythagorovu vetu)}
rdx1:=dx/r;
rdy1:=dy/r;
u:=t-1;
rdx:=rdx1*u;
rdy:=rdy1*u;
spx:=round(r) div (t);      {z kolika superpixelu se cara bude skladat}
zpx:=round(r) mod (t);      {a kolik normalnch pixelu potom zbyde}
flag:=false;
s:=1;

en:=ending and 1;

repeat
a:=RotateMask(mask);  {kdyz A>0 tak jde o pocet plnych superpixelu}
                      {kdyz A<0 tak jdeo prazdne superpixely}
b:=abs(a);
if s+b-1>spx then
   if s>spx then b:=0
      else begin b:=spx-s+1;s:=spx;end
   else inc(s,b);
mx:=rdx*b;
my:=rdy*b;
nx:=x+mx;
ny:=y+my;
if (b<>abs(a)) then
   begin
   nx:=nx+rdx1*zpx;
   ny:=ny+rdy1*zpx;
   en:=en or (ending and 2);
   flag:=true;
   end;
if a>0 then LineThick(dest,round(x),round(y),round(nx),round(ny),t,en,color);
en:=0;
x:=x+mx+rdx1*b;
y:=y+my+rdy1*b;
until flag=true;
End;


procedure LineThickWithMask(var dest:virtualwindow;x1,y1,x2,y2:longint;t:byte;mask,color:word);
begin
LineThickWithMask(dest,x1,y1,x2,y2,t,mask,0,color);
end;


Procedure LineWithMask(var dest:virtualwindow;x1,y1,x2,y2:Longint;Mask,Color:Word);

VAR       m,n  : Real;
          Temp : LongInt;
Begin

if not ClipLine(dest,x1,y1,x2,y2) then Exit;
if mask=$ffff then begin Line(dest,x1,y1,x2,y2,color);Exit;end;
 If x1<>x2 then
 begin
  If x1>x2 then begin
                 Temp:= x1; x1:= x2; x2:= Temp;
                 Temp:= y1; y1:= y2; y2:= Temp;
                end;

  m:= (y1-y2)/(x1-x2);
  n:= y1 - m * x1;

  For Temp:= x1 to x2 do
      if odd(RotateWord(mask)) then InternalPutPixel(Dest,Temp,Round(m * Temp + n),color);

 end
 else
 begin
  If y1>y2 then begin Temp:= y1; y1:= y2; y2:= Temp; end;
  For Temp:= y1 to y2 do
      if odd(RotateWord(mask)) then InternalPutPixel(Dest,x1,Temp,color);

 end;

End;


FUNCTION CalculateLine(x1,y1,x2,y2:LongInt):LongInt;
VAR       xDIFF,yDIFF,xADD,yADD,Rest : LongInt;
Begin
 CalculateLine:= 1;
 ASM
  Mov eax,x1
  Cmp eax,x2
  Jl  @Kleiner1
   Je @Ende1
   Mov xAdd,-1
   Jmp @Ende1
  @Kleiner1:
  Mov xAdd,1
  @Ende1:

  Mov eax,y1
  Cmp eax,y2
  Jl  @Kleiner2
   Je @Ende2
   Mov yAdd,-1
   Jmp @Ende2
  @Kleiner2:
  Mov yAdd,1
  @Ende2:
 END;
 xDIFF:= abs(x1-x2);
 yDIFF:= abs(y1-y2);
 If xDIFF>yDIFF then
 begin
  Rest:=-(xDIFF shr 1);
  WHILE x1<>x2 do
  begin
   Inc(Rest,yDIFF);
   Inc(x1,xADD);
   If Rest>0 then
   begin
    Inc(y1,yADD);
    Dec(Rest,xDIFF);
   end;
   Inc(CalculateLine);
  end;
 end
 else
 begin
  Rest:=-(yDIFF shr 1);
  WHILE y1<>y2 do
  begin
   Inc(Rest,xDIFF);
   Inc(y1,yADD);
   If Rest>0 then
   begin
    Inc(x1,xADD);
    Dec(Rest,yDIFF);
   end;
   Inc(CalculateLine);
  end;
 end;
End;


FUNCTION CalculateDetailLine(x1,y1,x2,y2:LongInt):LongInt;
VAR      xDIFF,yDIFF,xADD,yADD,Rest : LongInt;
Begin
 CalculateDetailLine:= 1;
 ASM
  Mov eax,x1
  Cmp eax,x2
  Jl  @Kleiner1
   Je @Ende1
   Mov xAdd,-1
   Jmp @Ende1
  @Kleiner1:
  Mov xAdd,1
  @Ende1:

  Mov eax,y1
  Cmp eax,y2
  Jl  @Kleiner2
   Je @Ende2
   Mov yAdd,-1
   Jmp @Ende2
  @Kleiner2:
  Mov yAdd,1
  @Ende2:
 END;
 xDIFF:= abs(x1-x2);
 yDIFF:= abs(y1-y2);
 If xDIFF>yDIFF then
 begin
  Rest:=-(xDIFF shr 1);
  WHILE x1<>x2 do
  begin
   Inc(Rest,yDIFF);
   Inc(x1,xADD);
   If Rest>0 then
   begin
    Inc(CalculateDetailLine);
    Inc(y1,yADD);
    Dec(Rest,xDIFF);
   end;
   Inc(CalculateDetailLine);
  end;
 end
 else
 begin
  Rest:=-(yDIFF shr 1);
  WHILE y1<>y2 do
  begin
   Inc(Rest,xDIFF);
   Inc(y1,yADD);
   If Rest>0 then
   begin
    Inc(CalculateDetailLine);
    Inc(x1,xADD);
    Dec(Rest,yDIFF);
   end;
   Inc(CalculateDetailLine);
  end;
 end;
End;


Procedure SetLineMode(mode:byte);
begin
case mode of
lm_normal:begin
          if vga.segment=dosmemselector
             then begin LineHorz:=@LineHorzBA;LineVert:=@LineVertBA;Bar:=@BarBA;end
             else begin LineHorz:=@LFBLineHorz;LineVert:=@LFBLineVert;Bar:=@LFBBar;end;
          ActualLineMode:=mode;
          end;

lm_xor:begin
       if vga.segment=dosmemselector
             then begin LineHorz:=@LineHorzXORba;LineVert:=@LineVertXORba;Bar:=@BarXORba;end
             else begin LineHorz:=@LFBLineHorzXOR;LineVert:=@LFBLineVertXOR;Bar:=@LFBBarXOR;end;
          ActualLineMode:=mode;
       end;


lm_texture:if texture<>nil then
              begin
               if vga.segment=dosmemselector
                 then begin LineHorz:=@LineHorzTextureBA;LineVert:=@LineVertTextureBA;end
                 else begin LineHorz:=@LFBLineHorzTexture;LineVert:=@LFBLineVertTexture;end;
              Bar:=@BarFromLineHorz;
              ActualLineMode:=mode;
              end;

lm_maskedtexture:if texture<>nil then
                    begin
                    if vga.segment=dosmemselector
                       then begin LineHorz:=@LineHorzMaskedBA;LineVert:=@LineVertMaskedBA;end
                       else begin LineHorz:=@LFBLineHorzMasked;LineVert:=@LFBLineVertMasked;end;
                    Bar:=@BarFromLineHorz;
                    ActualLineMode:=mode;
                    end;

end; {case}
end;


Procedure SetLineMode(mode:byte;var v:virtualwindow);
{This variant combines procedure SetLineMode(mode:byte) and PrepareTexture}
begin
PrepareTexture(v);
SetLineMode(mode);
end;


Function GetLineMode:byte;
begin
GetLineMode:=ActualLineMode;
end;


Procedure PutTransPixel(var dest:virtualwindow;x,y:longint;Color:word;strength:Byte);assembler;
{Strength:= 0 = transparent    Strength:= 255 = opaque}
var r,g,b,sr,sg,sb:Byte;
 asm
 push es
  mov edi,dest
  mov ax,[edi+0]
  mov es,ax
  mov eax,[edi+26]  {Bytebreite}
  mul y
  mov edi,[edi+2]
  add eax,x
  add eax,x
  add edi,eax

  mov al,strength
  cmp al,255           {if the pixel is not to be faded we are just setting its new value}
  jne @faded_pixel

  {Pixel located}
  Mov ax,Color
  mov es:[edi],ax
  jmp @done

 @faded_pixel:
  {Put pixel faded to background color}
  Mov bx,Color  {Store color values in variables}
  mov b,bl
  and b,31
  shr bx,5
  mov g,bl
  and g,63
  shr bx,6
  mov r,bl

  mov bx,es:[edi]
  mov sb,bl
  and sb,31
  shr bx,5
  mov sg,bl
  and sg,63
  shr bx,6
  mov sr,bl

  {Pixel located}

  mov eax,0
  mov ecx,0
  mov ebx,0        {Reset working area}

  mov al,sr        {get old red}
  mov cl,255
  mov bl,strength
  sub cl,bl
  mul cl          //ax = old * (255-strength)
  mov ecx,eax     //Stored in ecx

  mov eax,0
  mov al,r
  mul bl          // ax = new*strength
  add ax,cx       // ax = old * (255-strength) + new*strength
  shr ax,8        // ax = (old * (255-strength) + new*strength)/255
  mov r,al

  mov eax,0
  mov ecx,0
  mov ebx,0        //Reset working area

  mov al,sg        // get old green
  mov cl,255
  mov bl,strength
  sub cl,bl
  mul cl          //ax=old * (255-strength)
  mov ecx,eax     //Stored in ecx

  mov eax,0
  mov al,g
  mul bl          // ax = new*strength
  add ax,cx       // ax = old * (255-strength) + new*strength
  shr ax,8        // ax = (old * (255-strength) + new*strength)/255
  mov g,al


  mov eax,0
  mov ecx,0
  mov ebx,0        //Reset working area

  mov al,sb        // get old blue
  mov cl,255
  mov bl,strength
  sub cl,bl
  mul cl          //ax=old * (255-strength)
  mov ecx,eax     //Stored in ecx

  mov eax,0
  mov al,b
  mul bl          // ax = new*strength
  add ax,cx       // ax = old * (255-strength) + new*strength
  shr ax,8        // ax = (old * (255-strength) + new*strength)/255
  mov b,al

  xor ebx,ebx
  mov al,r
  shl eax,11
  mov bl,g
  shl ebx,5
  add eax,ebx
  add al,b
  mov es:[edi],ax
@done:
pop es
end;


PROCEDURE LineSmooth(var dest:virtualwindow;x1,y1,x2,y2:LongInt;color:Word;factor:byte);
VAR       xDIFF,yDIFF,xADD,yADD,Rest : LongInt;
          aas,aat,epi:longint;
          r:real;
Begin
 ASM
  mov xadd,0
  mov yadd,0
  Mov eax,x1
  Cmp eax,x2
  Jl  @Kleiner1
   Je @Ende1
   sub xAdd,1   {xAdd=-1}
   Jmp @Ende1
  @Kleiner1:
  add xAdd,1    {xADD=1}
  @Ende1:

  Mov eax,y1
  Cmp eax,y2
  Jl  @Kleiner2
   Je @Ende2
   sub yAdd,1   {yAdd=-1}
   Jmp @Ende2
  @Kleiner2:
  add yAdd,1    {yAdd=1}
  @Ende2:
 END;
 xDIFF:=abs(x1-x2);
 yDIFF:=abs(y1-y2);
 If xDIFF>yDIFF then
 begin
  Rest:=-(xDIFF shr 1);
  r:=factor / 3 *YDIFF/XDIFF;
  epi:=Round(r);

  PutTransPixel(dest,x1-xadd,y1,color,factor div 2);
  PutTransPixel(dest,x1-xadd,y1-yadd,Color,epi);

  PutTransPixel(dest,x2+xadd,y2,color,factor div 2);
  PutTransPixel(dest,x2+xadd,y2+yadd,color,epi);

  dec(x1,xADD);
  {dec(x2,xADD);}
  WHILE x1<>x2 do
  begin
   Inc(Rest,yDIFF);
   Inc(x1,xADD);
   If Rest>0 then
   begin
    Inc(y1,yADD);
    Dec(Rest,xDIFF);
   end;

   Aas:=Round(-rest*factor / XDIFF);
   PutTransPixel(dest,x1,y1,Color,255);
   PutTransPixel(dest,x1,y1+yadd,Color,factor-Aas);
   PutTransPixel(dest,x1,y1-yadd,Color,Aas);

  end;
 end
 else
 begin
  Rest:=-(yDIFF shr 1);
  if YDIFF=0 then epi:=255 else
     begin
     r:=factor / 3 *XDIFF/YDIFF;
     epi:=Round(r);
     end;
  PutTransPixel(dest,x1,y1-yadd,color,factor div 2);
  PutTransPixel(dest,x1-xadd,y1-yadd,Color,epi);

  PutTransPixel(dest,x2,y2+yadd,color,factor div 2);
  PutTransPixel(dest,x2+xadd,y2+yadd,color,epi);


  dec(y1,yADD);
  WHILE y1<>y2 do
  begin
   Inc(Rest,xDIFF);
   Inc(y1,yADD);
   If Rest>0 then
   begin
    Inc(x1,xADD);
    Dec(Rest,yDIFF);
   end;

  Aas:=Round(-rest*factor / YDIFF);
  PutTransPixel(dest,x1,y1,Color,255);
  PutTransPixel(dest,x1+xadd,y1,color,factor-Aas);
  PutTransPixel(dest,x1-xadd,y1,color,Aas);

  end;
 end;
End;


Procedure Inversion(var dest:VirtualWindow;x1,y1,x2,y2:longint);assembler;
asm
mov eax,x1
mov ebx,y1
mov ecx,x2
mov edx,y2
mov edi,dest
call BarClipping
jc @Konec

push es
mov ax,[edi+0]
mov es,ax

add ebx,[edi+2]
mov edi,[edi+26]  {DEST.BYTEBREITE}
xchg ebx,edi


shr ecx,1

@cykl1:
push ecx
push edi
@cykl2:
mov ax,es:[edi]
xor ax,65535
mov es:[edi],ax
add edi,2
dec ecx
jnz @cykl2

pop edi
pop ecx
add edi,ebx
dec edx
jnz @cykl1

pop es
@Konec:
end;


{----------------------------- EINIGE DER ALPHA ROUTINEN --------------------}
PROCEDURE Alpha(dest,X,Y : Longint; r,g,b : shortint); Assembler;
ASM
push ds
  mov edi,dest
  mov ax,[edi+0]
  mov ds,ax
  mov eax,[edi+26]   {bytebreite}
  mul y
  add eax,x
  add eax,x
  mov edi,[edi+2]
  add edi,eax
  mov ax,[edi]

  mov bh, ah
  shr bh, 3 {bh = rot}
  add bh, r
  cmp bh, 0
  jge @@weiter1  {grer als 0 ?}
  xor bh,bh      {n ! auf 0 setzen}
 @@weiter1:
  cmp bh, 31
  jle @@weiter11 {kleiner als 31 ?}
  mov bh, 31     {n ! auf 31 setzen}
 @@weiter11:
  shl bh, 3

  mov bl, al
  and bl, 31 {bl = blau}
  add bl, b
  cmp bl, 0
  jge @@weiter2
  xor bl,bl
 @@weiter2:
  cmp bl, 31
  jle @@weiter21
  mov bl, 31
 @@weiter21:

  shr ax, 5
  and ax, 63 {ax = grn}
  add ax, g
  cmp ax, 0
  jge @@weiter3
  xor ax,ax
 @@weiter3:
  cmp ax, 63
  jle @@weiter31
  mov ax, 63
 @@weiter31:
  shl ax, 5

  Add al,bl
  Add ah,bh
  Mov [edi],ax
pop ds
End;


PROCEDURE AlphaLight(var dest:virtualwindow;X,Y : Longint; r,g,b : Word); Assembler;
Asm
  Mov edi,dest
  Mov eax,ds:[edi+10]
  Mul Y
  add eax, x
  shl eax, 1
  Mov edi,ds:[edi+2]
  Add edi, eax
  mov ax,[edi]
  mov bh, ah
  shr bh, 3 {bh = rot}
  add bh, r
  cmp bh, 31
  jle @@weiter11
  mov bh, 31
 @@weiter11:
  shl bh, 3

  mov bl, al
  and bl, 31 {bl = blau}
  add bl, b
  cmp bl, 31
  jle @@weiter21
  mov bl, 31
 @@weiter21:

  shr ax, 5
  and ax, 63 {ax = grn}
  add ax, g
 @@weiter3:
  cmp ax, 63
  jle @@weiter31
  mov ax, 63
 @@weiter31:
  shl ax, 5

  add al,bl
  add ah,bh
  mov [edi], ax
End;



PROCEDURE AlphaLightClipped(var dest:virtualwindow;X,Y : Longint; r,g,b : Word); Assembler;
Asm
  Mov edi,Dest
  Mov eax,ds:[edi+14]
  Cmp x,eax
  Ja @Ende
  Mov eax,ds:[edi+38]
  Cmp y,eax
  Ja @Ende

  Mov eax,ds:[edi+10]
  Mul Y
  add eax, x
  shl eax, 1
  Mov edi,ds:[edi+2]
  Add edi, eax
  mov ax,[edi]
  mov bh, ah
  shr bh, 3 {bh = rot}
  add bh, r
  cmp bh, 31
  jle @@weiter11
  mov bh, 31
 @@weiter11:
  shl bh, 3

  mov bl, al
  and bl, 31 {bl = blau}
  add bl, b
  cmp bl, 31
  jle @@weiter21
  mov bl, 31
 @@weiter21:

  shr ax, 5
  and ax, 63 {ax = grn}
  add ax, g
 @@weiter3:
  cmp ax, 63
  jle @@weiter31
  mov ax, 63
 @@weiter31:
  shl ax, 5

  add al,bl
  add ah,bh
  mov [edi], ax
  @Ende:
End;


PROCEDURE AlphaLightLine(var dest:virtualwindow;x1,y1,x2,y2:LongInt;r,g,b:Word);
VAR       xDIFF,yDIFF,xADD,yADD,Rest : LongInt;
Begin
 ASM
  Mov eax,x1
  Cmp eax,x2
  Jl  @Kleiner1
   Je @Ende1
   Mov xAdd,-1
   Jmp @Ende1
  @Kleiner1:
  Mov xAdd,1
  @Ende1:

  Mov eax,y1
  Cmp eax,y2
  Jl  @Kleiner2
   Je @Ende2
   Mov yAdd,-1
   Jmp @Ende2
  @Kleiner2:
  Mov yAdd,1
  @Ende2:
 END;
 xDIFF:=abs(x1-x2);
 yDIFF:=abs(y1-y2);
 AlphaLight(Dest,x1,y1,r,g,b);
 If xDIFF>yDIFF then
 begin
  Rest:=-(xDIFF shr 1);
  WHILE x1<>x2 do
  begin
   Inc(Rest,yDIFF);
   Inc(x1,xADD);
   If Rest>0 then
   begin
    Inc(y1,yADD);
    Dec(Rest,xDIFF);
   end;
   AlphaLight(Dest,x1,y1,r,g,b);
  end;
 end
 else
 begin
  Rest:=-(yDIFF shr 1);
  WHILE y1<>y2 do
  begin
   Inc(Rest,xDIFF);
   Inc(y1,yADD);
   If Rest>0 then
   begin
    Inc(x1,xADD);
    Dec(Rest,yDIFF);
   end;
   AlphaLight(Dest,x1,y1,r,g,b);
  end;
 end;
End;


PROCEDURE AlphaLightHORZLine(var dest:virtualwindow;X,Y,X2 : Longint; r,g,b : Word); Assembler;
Asm
  Mov edi,dest
  Mov eax,ds:[edi+10]
  Mul Y
  add eax, x
  shl eax, 1
  Mov edi,ds:[edi+2]
  Add edi, eax
  Mov ecx,X2

  @LOOPALL:

  mov ax,[edi]
  mov bh, ah
  shr bh, 3 {bh = rot}
  add bh, r
  cmp bh, 31
  jle @@weiter11
  mov bh, 31
 @@weiter11:
  shl bh, 3

  mov bl, al
  and bl, 31 {bl = blau}
  add bl, b
  cmp bl, 31
  jle @@weiter21
  mov bl, 31
 @@weiter21:

  shr ax, 5
  and ax, 63 {ax = grn}
  add ax, g
 @@weiter3:
  cmp ax, 63
  jle @@weiter31
  mov ax, 63
 @@weiter31:
  shl ax, 5
  add al,bl
  add ah,bh
  mov [edi], ax
  Add edi,2
  LOOP @LOOPALL
End;


Function Load_Image(s:string;var v:virtualwindow):byte;
var konc:string;
    a:byte;
    p:pointer;
    u:Function(s:string;var v:virtualwindow):byte;
begin
for a:=Length(s) downto 1 do
    if s[a]='.' then Break;
if a=1 then Exit(LI_bad);
konc:=Copy(s,a+1,255);
p:=Get_Image_Loader(konc);
if p=nil then Exit(LI_ext);
pointer(u):=p;
Load_Image:=u(s,v);
end;


Function _Load_BMP(h:PStream;var v:virtualwindow):byte;
var cil:pbyte;
    x,y,p:longint;
    doplnek:longint;
    _temp:pointer;
    temp:pbyte;
    header:BMP_header;
    paleta:BGRApalette;

begin
h^.read(header,sizeof(header));
if (header.magic<>$4d42) or (header.compressed<>0) or (not (header.bits_per_pixel in [8,24,32])) then
   Exit(1);
p:=header.width*header.bits_per_pixel div 8;
GetMem(_temp,p+32);
Init_VW(v,header.width,header.height,false);


case header.bits_per_pixel of

8: begin
   h^.read(paleta,256*4);
   for y:=0 to 255 do
       begin
       paleta[y].r:=paleta[y].r shr 3;
       paleta[y].g:=paleta[y].g shr 2;
       paleta[y].b:=paleta[y].b shr 3;
       end;
   h^.seek(header.offset_to_data);
   doplnek:=(header.width mod 4);
   if doplnek<>0 then doplnek:=4-doplnek;
   for y:=header.height-1 downto 0 do
       begin        {8 bitove BMP}
       temp:=_temp;
       h^.Read(temp^,p+doplnek);
       cil:=pointer(v.vwoffset);
       inc(cil,y*header.width*2);
       x:=header.width;
       asm
           mov esi,temp
           lea ebx,paleta
           mov edi,cil
       @cykl:
           movzx eax,byte [esi];
           inc esi
           shl eax,2
           movzx edx,byte [ebx+eax]
           inc eax
           movzx ecx,byte [ebx+eax]
           shl ecx,5
           or edx,ecx
           inc eax
           movzx ecx,byte [ebx+eax]
           shl ecx,11
           or edx,ecx
           mov [edi],dx;
           add edi,2
           dec x
           jnz @cykl
       end;
       end;
   end;

24:begin
   h^.seek(header.offset_to_data);
   doplnek:=(header.width mod 4);
   for y:=header.height-1 downto 0 do
    begin           {24 bitove BMP}
    temp:=_temp;
    h^.Read(temp^,p+doplnek);
    cil:=pointer(v.vwoffset);
    inc(cil,y*header.width*2);
    x:=header.width;
        asm
        mov ecx,x
        mov esi,temp
        mov edi,cil
    @cykl:
        mov al,[esi]
        shr al,3
        movzx bx,al
        inc esi
        movzx ax, byte [esi]
        shr ax,2
        shl ax,5
        add bx,ax
        inc esi
        movzx ax, byte [esi]
        shr ax,3
        shl ax,11
        add bx,ax
        inc esi
        mov [edi],bx
        add edi,2
        loop @cykl
        end;
    end;
   end;

32:begin
   h^.seek(header.offset_to_data);
   doplnek:=(header.width mod 4);
   if doplnek<>0 then doplnek:=4-doplnek;
   for y:=header.height-1 downto 0 do
    begin           {32 bitove BMP}
    temp:=_temp;
    h^.Read(temp^,p); {To by nebyl Microsoft, aby i ve formatu BMP nevymyslel}
                      {nejakou prasarnu. Pokud je BMP 32.bitove, tak oproti}
                      {specifikaci se delky radky nezaokrouhluji na}
                      {delitelnost ctyrmi}

    cil:=pointer(v.vwoffset);
    inc(cil,y*header.width*2);
    x:=header.width;
        asm
        mov ecx,x
        mov esi,temp
        mov edi,cil
    @cykl:

        mov al,[esi]
        shr al,3
        movzx bx,al
        inc esi
        movzx ax, byte [esi]
        shr ax,2
        shl ax,5
        add bx,ax
        inc esi
        movzx ax, byte [esi]
        shr ax,3
        shl ax,11
        add bx,ax
        inc esi
        inc esi
        mov [edi],bx
        add edi,2
        loop @cykl
        end;
    end;
    end;
end;  {case}

FreeMem(_temp);
_Load_BMP:=0;
end;

Function Save_BMP(var v:virtualwindow;s:string):boolean;
var h:BMP_header;
    o:longint;
    r,g,b:byte;
    t:word;
    i,j,k,l:dword;
    x:PChar;
    f:PBufStream;
begin
f:=New(PBufStream,Init(s,stCreate,30000));
if f^.ErrorInfo<>0 then
   begin
   Dispose(f,Done);
   Exit(false);
   end;
h.magic:=$4d42;   {BM}
h.sizebmp:=SizeOf(BMP_header)+v.breite*v.hoehe*3;
h.reserved:=0;
h.offset_to_data:=SizeOf(BMP_header);
h.header_size:=40;
h.width:=v.breite;
h.height:=v.hoehe;
h.numplanes:=1;
h.bits_per_pixel:=24;
h.compressed:=0;
h.sizeimage:=0;
h.xres:=0;
h.yres:=0;
h.clrused:=0;
h.clrimportant:=0;
k:=v.breite;
j:=k mod 4;
k:=k*3;
if j<>0 then inc(k,j);
GetMem(x,k);
f^.Write(h,SizeOf(BMP_header));
for j:=v.hoeheminus1 downto 0 do
    begin
    for i:=0 to v.breiteminus1 do
        begin
        t:=GetPixel(v,i,j);
        Word2RGB(t,r,g,b);
        r:=r shl 3;
        g:=g shl 2;
        b:=b shl 3;
        l:=i*3;
        x[l+0]:=char(b);
        x[l+1]:=char(g);
        x[l+2]:=char(r);
        end;
    f^.Write(x^,k);
    end;
Dispose(f,Done);
FreeMem(x,k);
Save_BMP:=true;
end;


Function Load_BMP(s:string;var v:virtualwindow):byte;
var h:PGrpStream;
begin
v.VWoffset:=0;
h:=New(PGrpStream,Init(s,stOpenRead));
Load_BMP:=_Load_BMP(h,v);
Dispose(h,Done);
end;


Procedure Register_BMP_Loader;
begin
RegisterImageLoader('BMP',@Load_BMP);
end;

{----------------------------- SPRITE Routinen ------------------------------}

Procedure SetWholePalette(var p:palette);
var b:byte;
begin
for b:=0 to 255 do
    begin
      OutPortb($3C8,b);
      OutPortb($3C9,P[b,1]);
      OutPortb($3C9,P[b,2]);
      OutPortb($3C9,P[b,3]);
    end;
end;

Procedure SetPaletteEntry(c,r,g,b:byte);
begin
OutPortb($3C8,c);
OutPortb($3C9,r);
OutPortb($3C9,g);
OutPortb($3C9,b);
end;

Procedure PrectiRegistrPalety(c:byte;var r,g,b:word);
begin
OutPortb($3C7,c);
r:=InPortb($3C9);
g:=InPortb($3C9);
b:=InPortb($3C9);
end;

Function FindPaletteEntry(var p:palette;r,g,b:byte;var v:byte):boolean;
var a:byte;
begin
for a:=0 to 255 do
   if (r=p[a,1]) and (g=p[a,2]) and (b=p[a,3]) then
      begin
      v:=a;
      FindPaletteEntry:=true;
      Exit;
      end;
v:=0;
FindPaletteEntry:=false;
end;

Function DAC_width:byte;assembler;
asm
mov eax,4f08h
xor ebx,ebx
mov bh,1
int 10h
mov al,bh
end;


Procedure SaveVGAPalette;
var a,r,g,b:word;
    bitu:byte;
    w:word;
begin
bitu:=DAC_width;
for a:=0 to 255 do
    begin
    PrectiRegistrPalety(a,r,g,b);
    if bitu=6 then begin r:=r shl 2;g:=g shl 2;b:=b shl 2;end;
    b:=b shr 3;g:=g shr 2;r:=r shr 3;
    w:=b+(r shl 11)+(g shl 5);
    adaptedpalette[a]:=w;
    end;
end;

Function VGA2word(b:byte):word;
begin
VGA2word:=adaptedpalette[b];
end;

Procedure InitAdaptedPalete;

const standard_palette:array[0..255] of word =
      ($0,$15,$540,$555,$A800,$A815,$AAA0,$AD55,$52AA,$52BF,$57EA,$57FF,$FAAA,
      $FABF,$FFEA,$FFFF,$0,$10A2,$2104,$2965,$39C7,$4228,$528A,$630C,$738E,$8410,
      $9492,$A514,$B5B6,$CE59,$E71C,$FFFF,$1F,$401F,$781F,$B81F,$F81F,$F817,$F80F,
      $F808,$F800,$FA00,$FBE0,$FDE0,$FFE0,$BFE0,$7FE0,$47E0,$7E0,$7E8,$7EF,$7F7,
      $7FF,$5FF,$3FF,$21F,$7BFF,$9BFF,$BBFF,$DBFF,$FBFF,$FBFB,$FBF7,$FBF3,$FBEF,
      $FCEF,$FDEF,$FEEF,$FFEF,$DFEF,$BFEF,$9FEF,$7FEF,$7FF3,$7FF7,$7FFB,$7FFF,
      $7EFF,$7DFF,$7CFF,$B5BF,$C5BF,$DDBF,$EDBF,$FDBF,$FDBD,$FDBB,$FDB8,$FDB6,
      $FE36,$FED6,$FF56,$FFF6,$EFF6,$DFF6,$C7F6,$B7F6,$B7F8,$B7FB,$B7FD,$B7FF,
      $B75F,$B6DF,$B63F,$E,$180E,$380E,$500E,$700E,$700A,$7007,$7003,$7000,$70E0,
      $71C0,$72A0,$7380,$5380,$3B80,$1B80,$380,$383,$387,$38A,$38E,$2AE,$1CE,
      $EE,$39CE,$41CE,$51CE,$61CE,$71CE,$71CC,$71CA,$71C8,$71C7,$7227,$72A7,$7307,
      $7387,$6387,$5387,$4387,$3B87,$3B88,$3B8A,$3B8C,$3B8E,$3B0E,$3AAE,$3A2E,
      $528E,$5A8E,$628E,$6A8E,$728E,$728D,$728C,$728B,$728A,$72CA,$730A,$734A,
      $738A,$6B8A,$638A,$5B8A,$538A,$538B,$538C,$538D,$538E,$534E,$530E,$52CE,
      $8,$1008,$2008,$3008,$4008,$4006,$4004,$4002,$4000,$4080,$4100,$4180,$4200,
      $3200,$2200,$1200,$200,$202,$204,$206,$208,$188,$108,$88,$2108,$2908,$3108,
      $3908,$4108,$4107,$4106,$4105,$4104,$4144,$4184,$41C4,$4204,$3A04,$3204,
      $2A04,$2204,$2205,$2206,$2207,$2208,$21C8,$2188,$2148,$2968,$3168,$3168,
      $3968,$4168,$4167,$4166,$4166,$4165,$4185,$41A5,$41E5,$4205,$3A05,$3205,
      $3205,$2A05,$2A06,$2A06,$2A07,$2A08,$29E8,$29A8,$2988,$0,$0,$0,$0,$0,
      $0,$0,$0);
begin
adaptedpalette:=standard_palette;
end;







PROCEDURE PutBrightSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rBright,gBright,bBright:Shortint);assembler;
VAR       SpriteOffset   : LongInt;
          ScanLines,bbb  : LongInt;
          spritebreite   : Longint;
          SpriteHoehe    : Longint;
          destbytebreite : longint;
          sr,sg,sb       : Byte;
          desr,desg,desb : Byte;
          NewR,NewG,NewB : Word;

 Asm
  Push es
  mov edi,dest
  Mov  es,[edi+0]                  {.segment}

  Mov  eax,[edi+26]{Dest.ByteBreite} { Destination Offset bestimmen }
  mov  destbytebreite,eax
  Mul  y
  Shl  x,1
  Add  eax,x
  Add  eax,[edi+2]{DestOffset}
  Mov  edi,eax
  Mov  bbb,eax                     { Und in ebx festhalten }

  mov esi,sprite
  mov ecx,[esi+10]                 {sprite breite}
  mov spritebreite,ecx
  mov ecx,[esi+30]                 {sprite hoehe}
  mov spritehoehe,ecx

  Mov  esi,[esi+2]                 { Sprite Offset in esi }

  @SCANLINES_LOOP:

    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }

     Mov dx,ax
     Shr ax,3
     Sub ah,rBright
     Cmp ah,0
     Jge @Jump1
      Xor ah,ah
     @Jump1:
     Mov sr,ah
     Shr al,2
     Sub al,gBright
     Cmp al,0
     Jge @Jump2
      Xor al,al
     @Jump2:
     Mov sg,al
     And dl,00011111b
     Sub dl,bBright
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in bh }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Mov eax,DestByteBreite
    Add bbb,eax
    Mov edi,bbb

  Dec SpriteHoehe
  JNZ @SCANLINES_LOOP
  Pop es
End;


PROCEDURE PutBrightClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rBright,gBright,bBright:ShortInt);assembler;
var xxx,edxx,eaxx:longint;
    sr,sg,sb:byte;
asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov edxx,edx
mov eaxx,eax


shr ecx,1
@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

{--------------------------------------------------}
@SCANLINE_LOOP:
     Mov ax,[esi]                  { Load Sprite r,g,b }
     Mov dx,ax
     Shr ax,3
     Sub ah,rBright
     Cmp ah,0
     Jge @Jump1
      Xor ah,ah
     @Jump1:
     Mov sr,ah
     Shr al,2
     Sub al,gBright
     Cmp al,0
     Jge @Jump2
      Xor al,al
     @Jump2:
     Mov sg,al
     And dl,00011111b
     Sub dl,bBright
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in ah }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     Add esi,2
     Add edi,2
    Dec ecx
    JNZ @SCANLINE_LOOP
{--------------------------------------------------}
    pop ecx
    pop edi
    pop esi
    add edi,eaxx
    add esi,xxx

  Dec edxx
  JNZ @SCANLINES_LOOP

Pop es
@Konec:
End;


PROCEDURE PutBrightHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rBright,gBright,bBright:ShortInt);assembler;
VAR       ScanLines      : LongInt;
          DestByteBreite : Longint;
          SpriteBreite   : Longint;
          spriteHoehe    : Longint;
          DestBreite,bbb : LongInt;
          sr,sg,sb       : Byte;
 Asm
  mov esi,sprite
  mov edi,dest
  Push es
  Mov  es,[edi+0]

  mov eax,[esi+10]{Sprite.Breite}
  mov SpriteBreite,eax
  mov eax,[esi+30]
  mov SpriteHoehe,eax
  Mov eax,[edi+26]{Dest.ByteBreite}{ Destination Offset bestimmen }
  mov DestByteBreite,eax
  Mul y
  Shl x,1
  Add eax,x
  Add eax,[edi+2] {DestOffset}
  Mov edi,eax
  Mov bbb,eax

  Mov esi,[esi+2] {SpriteOffset}      { Sprite Offset in esi }

  @SCANLINES_LOOP:

    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov dx,ax
     Shr ax,3
     Sub ah,rBright
     Cmp ah,0
     Jge @Jump1
      Xor ah,ah
     @Jump1:
     Mov sr,ah
     Shr al,2
     Sub al,gBright
     Cmp al,0
     Jge @Jump2
      Xor al,al
     @Jump2:
     Mov sg,al
     And dl,00011111b
     Sub dl,bBright
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in ah }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax
     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Mov eax,DestByteBreite
    Add bbb,eax
    Mov edi,bbb

  Dec SpriteHoehe
  JNZ @SCANLINES_LOOP
  Pop es
End;


PROCEDURE PutBrightClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rBright,gBright,bBright:ShortInt);assembler;
var       xxx,edxx,eaxx : LongInt;
          sr,sg,sb      : Byte;
asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov edxx,edx
mov eaxx,eax


shr ecx,1
@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

{--------------------------------------------------}
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov dx,ax
     Shr ax,3
     Sub ah,rBright
     Cmp ah,0
     Jge @Jump1
      Xor ah,ah
     @Jump1:
     Mov sr,ah
     Shr al,2
     Sub al,gBright
     Cmp al,0
     Jge @Jump2
      Xor al,al
     @Jump2:
     Mov sg,al
     And dl,00011111b
     Sub dl,bBright
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in ah }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP
    {--------------------------------------------------}
    pop ecx
    pop edi
    pop esi
    add edi,eaxx
    add esi,xxx

  Dec edxx
  JNZ @SCANLINES_LOOP
  Pop es

@Konec:
End;


PROCEDURE PutTransSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rLight,gLight,bLight:Byte);assembler;
VAR       DestOffset     : LongInt;
          SpriteHoehe    : LongInt;
          ScanLines,bbb  : LongInt;
          SpriteBreite     : LongInt;
          DestByteBreite : Longint;
          sr,sg,sb       : Byte;
          desr,desg,desb : Byte;
          NewR,NewG,NewB : Word;
 Asm
  mov esi,sprite
  mov edi,dest
  Push es
  Mov  es,[edi+0]   {Dest.Segment}

  mov  eax,[esi+10] {sprite.breite}
  mov  SpriteBreite,eax
  mov  eax,[esi+30] {sprite.hoehe}
  mov  spritehoehe,eax
  Mov  eax,[edi+26] {Dest.ByteBreite}   { Destination Offset bestimmen }
  mov  DestByteBreite,eax
  Mul  y
  Shl  x,1
  Add  eax,x
  Add  eax,[edi+2]  {DestOffset}
  Mov  edi,eax
  Mov  bbb,eax                          { Und in ebx festhalten }
  Mov  esi,[esi+2]  {SpriteOffset}      { Sprite Offset in esi }
  @SCANLINES_LOOP:
    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in bh }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Sub bh,rLight
     Cmp bh,0
     Jge @Jump1
      Xor bh,bh
     @Jump1:
     Sub bl,gLight
     Cmp bl,0
     Jge @Jump2
      Xor bl,bl
     @Jump2:
     Sub dl,bLight
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Mov eax,DestByteBreite
    Add bbb,eax
    Mov edi,bbb

  Dec SpriteHoehe
  JNZ @SCANLINES_LOOP
  Pop es
End;


PROCEDURE PutTransClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;rLight,gLight,bLight:Byte);assembler;
var       xxx,edxx,eaxx : LongInt;
          sr,sg,sb:byte;
asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov edxx,edx
mov eaxx,eax


shr ecx,1
@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

{--------------------------------------------------}

    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in ah }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Sub bh,rLight
     Cmp bh,0
     Jge @Jump1
      Xor bh,bh
     @Jump1:
     Sub bl,gLight
     Cmp bl,0
     Jge @Jump2
      Xor bl,bl
     @Jump2:
     Sub dl,bLight
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    pop ecx
    pop edi
    pop esi
    add edi,eaxx
    add esi,xxx

  Dec edxx
  JNZ @SCANLINES_LOOP
  Pop es
@Konec:
End;


PROCEDURE PutTransHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rLight,gLight,bLight:Byte);assembler;
VAR       SpriteHoehe    : Longint;
          SpriteBreite   : Longint;
          DestByteBreite : Longint;
          ScanLines      : LongInt;
          DestBreite,bbb : LongInt;
          sr,sg,sb       : Byte;
 Asm
  mov esi,sprite
  mov edi,dest
  Push es
  Mov  es,[edi+0]   {Dest.Segment}

  mov eax,[esi+10]  {Sprite.breite}
  mov SpriteBreite,eax
  mov eax,[esi+30]  {Sprite.hoehe}
  mov SpriteHoehe,eax
  Mov eax,[edi+26]                 { Destination Offset bestimmen }
  mov DestByteBreite,eax
  Mul y
  Shl x,1
  Add eax,x
  Add eax,[edi+2]   {Dest.Offset}
  Mov edi,eax
  Mov bbb,eax
  Mov esi,[esi+2]   {SpriteOffset} { Sprite Offset in esi }

  @SCANLINES_LOOP:

    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in ah }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Sub bh,rLight
     Cmp bh,0
     Jge @Jump1
      Xor bh,bh
     @Jump1:
     Sub bl,gLight
     Cmp bl,0
     Jge @Jump2
      Xor bl,bl
     @Jump2:
     Sub dl,bLight
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax
     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Mov eax,DestByteBreite
    Add bbb,eax
    Mov edi,bbb

  Dec SpriteHoehe
  JNZ @SCANLINES_LOOP
  Pop es
End;


PROCEDURE PutTransClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word;rLight,gLight,bLight:Byte);assembler;
var       xxx,edxx,eaxx  : LongInt;
          sr,sg,sb       : Byte;

asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov edxx,edx
mov eaxx,eax


shr ecx,1
@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

{--------------------------------------------------}
    @SCANLINE_LOOP:
     Mov ax,[esi]                  { Load Sprite r,g,b }
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3               {  rot in ah }
     Shr bl,2               { grn in bl }
     And dl,00011111b       { blau in dl }

     Sub bh,rLight
     Cmp bh,0
     Jge @Jump1
      Xor bh,bh
     @Jump1:
     Sub bl,gLight
     Cmp bl,0
     Jge @Jump2
      Xor bl,bl
     @Jump2:
     Sub dl,bLight
     Cmp dl,0
     Jge @Jump3
      Xor dl,dl
     @Jump3:

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP
    pop ecx
    pop edi
    pop esi
    add edi,eaxx
    add esi,xxx

  Dec edxx
  JNZ @SCANLINES_LOOP

  Pop es
@Konec:
End;




PROCEDURE PutAlphaSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);assembler;
VAR       SpriteBreite   : Longint;
          SpriteHoehe    : Longint;
          ScanLines      : LongInt;
          DestByteBreite : Longint;
          DestBreite,bbb : LongInt;
          sr,sg,sb       : Byte;
 Asm
  Push es
  mov esi,sprite
  mov edi,dest
  Mov  es,[edi+0]    {Dest.Segment}

  mov eax,[edi+26]
  mov DestByteBreite,eax
  mov eax,[esi+30]   {Sprite.hoehe}
  mov SpriteHoehe,eax
  mov eax,[esi+10]
  mov SpriteBreite,eax
  Mov  eax,[edi+10]  {Dest.Breite}   { Destination Offset bestimmen }
  Mul  y
  Add  eax,x
  Shl  eax,1
  Add  eax,[edi+2]   {DestOffset}
  Mov  edi,eax
  Mov  bbb,eax

  Mov  esi,[esi+2]   {SpriteOffset}  { Sprite Offset in esi }

  @SCANLINES_LOOP:

    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }
     Mov dx,bx

     Shr bx,3                      { Rot in bh }
     Shr bl,2                      { Grn in bl }
     And dl,00011111b              { Blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Mov eax,DestByteBreite
    Add bbb,eax
    Mov edi,bbb

  Dec SpriteHoehe
  JNZ @SCANLINES_LOOP
  Pop es
End;


PROCEDURE PutAlphaClippedSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt);assembler;
var       xxx,edxx,eaxx  : LongInt;
          sr,sg,sb       : Byte;

asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov edxx,edx
mov eaxx,eax


shr ecx,1
@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

{--------------------------------------------------}

     @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }
     Mov dx,bx

     Shr bx,3                      { Rot in bh }
     Shr bl,2                      { Grn in bl }
     And dl,00011111b              { Blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP
    pop ecx
    pop edi
    pop esi
    add edi,eaxx
    add esi,xxx

  Dec edxx
  JNZ @SCANLINES_LOOP
  Pop es
@Konec:
End;


PROCEDURE PutAlphaHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);assembler;
VAR       SpriteHoehe    : Longint;
          SpriteBreite   : Longint;
          DestByteBreite : Longint;
          DestBreite,bbb : LongInt;
          sr,sg,sb       : Byte;
 Asm
  Push es
  mov esi,sprite
  mov edi,dest
  Mov  es,[edi+0]    {Dest.Segment}

  mov eax,[edi+26]
  mov DestByteBreite,eax
  mov eax,[esi+30]   {Sprite.hoehe}
  mov SpriteHoehe,eax
  mov eax,[esi+10]
  mov SpriteBreite,eax
  Mov  eax,[edi+10]  {Dest.Breite}   { Destination Offset bestimmen }
  Mul  y
  Add  eax,x
  Shl  eax,1
  Add  eax,[edi+2]   {DestOffset}
  Mov  edi,eax
  Mov  bbb,eax

  Mov  esi,[esi+2]   {SpriteOffset}  { Sprite Offset in esi }

  @SCANLINES_LOOP:


    Mov ecx,SpriteBreite
    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }
     Mov dx,bx

     Shr bx,3                      { Rot in bh }
     Shr bl,2                      { Grn in bl }
     And dl,00011111b              { Blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax
     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP

    Mov eax,DestByteBreite
    Add bbb,eax
    Mov edi,bbb

  Dec SpriteHoehe
  JNZ @SCANLINES_LOOP
  Pop es
End;


PROCEDURE PutAlphaClippedHCSprite(var Dest,Sprite:VirtualWindow;x,y:LongInt;HideColor:Word);assembler;
var       xxx,edxx,eaxx  : LongInt;
          sr,sg,sb       : Byte;

asm
mov esi,sprite
mov edi,dest
mov eax,x
mov ebx,y
call SpriteClipping
jc @Konec

push es
add eax,[esi+2]
mov esi,[esi+26]
xchg esi,eax
mov xxx,eax
mov ax,[edi+0]
mov es,ax

mov eax,[edi+26] {ByteBreite}
mov edi,[edi+2]
add edi,ebx

mov edxx,edx
mov eaxx,eax


shr ecx,1
@SCANLINES_LOOP:
    push esi
    push edi
    push ecx

{--------------------------------------------------}

    @SCANLINE_LOOP:

     Mov ax,[esi]                  { Load Sprite r,g,b }
     Cmp ax,HideColor
     Je @FarbeNichtSetzen

     Mov dx,ax
     Shr ax,3
     Mov sr,ah
     Shr al,2
     Mov sg,al
     And dl,00011111b
     Mov sb,dl

     Mov bx,es:[edi]               { Load Destination r,g,b }

     Mov dx,bx
     Shr bx,3                      { Rot in bh }
     Shr bl,2                      { Grn in bl }
     And dl,00011111b              { Blau in dl }

     Add bh,sr
     Add bl,sg
     Add dl,sb

     Cmp bh,32
     Jb @NoChange1
      Mov bh,31
     @NoChange1:
     Cmp bl,64
     Jb @NoChange2
      Mov bl,63
     @NoChange2:
     Cmp dl,32
     Jb @NoChange3
      Mov dl,31
     @NoChange3:

     Mov al,bh
     Shl ax,6
     Add al,bl
     Shl ax,5
     Add al,dl

     Mov es:[edi],ax

     @FarbeNichtSetzen:

     Add esi,2
     Add edi,2

    Dec ecx
    JNZ @SCANLINE_LOOP
    pop ecx
    pop edi
    pop esi
    add edi,eaxx
    add esi,xxx

  Dec edxx
  JNZ @SCANLINES_LOOP

  Pop es

@Konec:
End;



{Sprites must have the same size!}
PROCEDURE FadeSprite(var Source, dest:virtualwindow); Assembler;
VAR       sr,sg,sb : Byte;
Asm
 Push es

 Mov edi,dest
 Mov ecx,ds:[edi+6]
 Shr ecx,1
 Mov  es,ds:[edi  ]
 Mov edi,ds:[edi+2]

 Mov esi,Source
 Mov esi,ds:[esi+2]

 @REPEAT:

    Mov ax,[esi]                  { Load Source r,g,b }

    Mov dx,ax
    Shr ax,3
    Mov sr,ah
    Shr al,2
    Mov sg,al
    And dl,00011111b
    Mov sb,dl

    Mov ax,es:[edi]               { Load Destination r,g,b }

    Mov dx,ax
    Shr ax,3
    Shr al,2
    And dl,00011111b

    Cmp ah,sr                     { Fading... }
    Jbe @JumpIt1
     Inc sr
    @JumpIt1:
    Jae @JumpIt2
     Dec sr
    @JumpIt2:

    Cmp al,sg
    Jbe @NotInc2
     Sub al,sg
     Cmp al,2
     Jb @Jump3
      Add sg,2
      Jmp @Ende2
     @Jump3:
     Inc sg
     jmp @Ende2
    @NotInc2:

    Cmp al,sg
    Jae @Ende2
     Push word ptr sg
     Sub sg,al
     Cmp sg,2
     Jb @Jump4
      Pop word ptr sg
      Sub sg,2
      jmp @Ende2
     @Jump4:
     Pop word ptr sg
     Dec sg
    @Ende2:

    Cmp dl,sb
    Jbe @JumpIt3
     Inc sb
    @JumpIt3:
    Jae @JumpIt4
     Dec sb
    @JumpIt4:

    Mov al,sr
    Shl ax,11
    Movzx dx,sg
    Shl dx,5
    Add dl,sb
    Add ax,dx

    Mov [esi],ax

    Add esi,2
    Add edi,2

 Dec ecx
 JNZ @REPEAT

 Pop es
End;



FUNCTION ScaleSprite(var SourSprite:VirtualWindow;Breite,Hoehe:LongInt):VirtualWindow;
VAR      DestOffset : LongInt;
         SourOffset : LongInt;
         xGanz      : LongInt;
         yGanz      : LongInt;
         SourSpriteByteBreite:longint;
         xRest      : Word;
         yRest      : Word;
         xRestTemp  : Word;
         yRestTemp  : Word;
         Temp       : Real;
Begin
 Init_VW(ScaleSprite,Breite,Hoehe,false);

 DestOffset:= ScaleSprite.VWOffset;
 SourOffset:= SourSprite.VWOffset;

 Temp := SourSprite.Breite / Breite;
 xRest:= Trunc(Frac(Temp)*65535);
 xGanz:= Trunc(Temp);

 Temp := SourSprite.Hoehe / Hoehe;
 yRest:= Trunc(Frac(Temp)*65535);
 yGanz:= Trunc(Temp);

 SourSpriteByteBreite:=SourSprite.ByteBreite;

 Asm
  Push es
  Mov  ax,ds
  Mov  es,ax
  Mov  edi,DestOffset
  Mov  esi,SourOffset

  Xor  ecx,ecx
  Shl  xGanz,1
  Mov  yRestTemp,0

  Mov ebx,Breite

  @Y_LOOP:

     Xor dx,dx
     Mov ebx,Breite
     @X_LOOP:

       MovsW

       Add esi,xGanz
       Add dx,xRest
       Jc @Jump
        Sub esi,2
       @Jump:

     Dec ebx
     JNZ @X_LOOP

     Add ecx,yGanz
     Mov ax,yRest
     Add yRestTemp,ax
     Jnc @NoInc2
      Inc ecx
     @NoInc2:

     Mov esi,SourOffset
     Mov eax,ecx
     Mul SourSpriteByteBreite
     Add esi,eax

  Dec Hoehe
  JNZ @Y_LOOP

  Pop es
 End;
End;


Procedure RGB(var v:virtualwindow;x,y:longint;var r,g,b:byte);
var t:word;
begin
if x>v.breiteminus1 then x:=v.breiteminus1;
if y>v.hoeheminus1 then y:=v.hoeheminus1;
t:=GetPixel(v,x,y);
Word2RGB(t,r,g,b);
end;

Function SmoothScaleSprite2(var SourSprite:VirtualWindow;Breite,Hoehe:LongInt):VirtualWindow;
var dst:Virtualwindow;
    x,y:real;
    stepx,stepy:real;
    i,j:longint;
    r1,g1,b1:byte;
    r2,g2,b2:byte;
    r3,g3,b3:byte;
    r4,g4,b4:byte;
begin
Init_VW(dst,breite,hoehe,false);

     y:=0.1;
     stepx:=(SourSprite.breite-0.2)/(2*breite);
     stepy:=(SourSprite.hoehe-0.2)/(2*hoehe);
     for j:=0 to hoehe-1 do begin
       x:=0.1;
       for i:=0 to breite-1 do begin
         RGB(soursprite,trunc(x      ),trunc(y      ),r1,g1,b1);
         RGB(soursprite,trunc(x      ),trunc(y+stepy),r2,g2,b2);
         RGB(soursprite,trunc(x+stepx),trunc(y      ),r3,g3,b3);
         RGB(soursprite,trunc(x+stepx),trunc(y+stepy),r4,g4,b4);

         x:=x+stepx*2;
         PutPixel(dst,i,j,RGB2word((r1+r2+r3+r4) div 4,(g1+g2+g3+g4) div 4,
                          (b1+b2+b3+b4) div 4));

         end;
       y:=y+stepy*2;
       end;
SmoothScaleSprite2:=dst;
end;



PROCEDURE AdjustSpriteLightness(var SourSprite:VirtualWindow;r,g,b:ShortInt); Assembler;
Asm
 Mov esi,SourSprite
 Mov ecx,ds:[esi+6]   {SIZE}
 Mov esi,ds:[esi+2]   {VWOFFSET}
 Shr ecx,1

 @REPEAT:

  Mov ax,[esi]

  Mov bl,al
  And bl,00011111b    { blue in bl }
  Shr ax,3            {  red in ah }
  Shr al,2            { green in al }

  Add ah,r
  Add al,g
  Add bl,b

  Cmp ah,31
  Jle @Jump1
   Mov ah,31
   Jmp @Jump2
  @Jump1:
  Cmp ah,0
  Jge @Jump2
   Xor ah,ah
  @Jump2:

  Cmp al,63
  Jle @Jump3
   Mov al,63
   Jmp @Jump4
  @Jump3:
  Cmp al,0
  Jge @Jump4
   Xor al,al
  @Jump4:

  Cmp bl,31
  Jle @Jump5
   Mov bl,31
   Jmp @Jump6
  @Jump5:
  Cmp bl,0
  Jge @Jump6
   Xor bl,bl
  @Jump6:

  Shl al,2
  Shl ax,3
  Add al,bl

  Mov [esi],ax

  Add esi,2

 LOOP @REPEAT
End;



PROCEDURE AdjustSpriteHCLightness(var SourSprite:VirtualWindow;r,g,b:ShortInt;HideColor:Word); Assembler;
Asm
 Mov esi,SourSprite
 Mov ecx,ds:[esi+6]
 Mov esi,ds:[esi+2]
 Shr ecx,1

 @REPEAT:

  Mov ax,[esi]

  Cmp ax,HideColor
  Je @NoChange

  Mov bl,al
  And bl,00011111b    { blue in bl }
  Shr ax,3            {  red in ah }
  Shr al,2            { green in al }

  Add ah,r
  Add al,g
  Add bl,b

  Cmp ah,31
  Jle @Jump1
   Mov ah,31
   Jmp @Jump2
  @Jump1:
  Cmp ah,0
  Jge @Jump2
   Xor ah,ah
  @Jump2:

  Cmp al,63
  Jle @Jump3
   Mov al,63
   Jmp @Jump4
  @Jump3:
  Cmp al,0
  Jge @Jump4
   Xor al,al
  @Jump4:

  Cmp bl,31
  Jle @Jump5
   Mov bl,31
   Jmp @Jump6
  @Jump5:
  Cmp bl,0
  Jge @Jump6
   Xor bl,bl
  @Jump6:

  Shl al,2
  Shl ax,3
  Add al,bl

  Mov [esi],ax

  @NoChange:

  Add esi,2

 dec ecx
 jnz @REPEAT
End;


Procedure DecreaseSpriteLightness(var sprite:virtualwindow;r,g,b:longint);assembler;
asm
push es
mov esi,sprite
mov ecx,[esi+6]                 {size}
mov ax,[esi+0]
mov es,ax
mov esi,[esi+2]
cmp ecx,8
jl @zbytek

cmp ss:[cpu_info_mmx],0
jz @zbytek

movd mm5,r
punpcklwd mm5,mm5
punpcklwd mm5,mm5               {R je rozepsane do celeho mm5}

movd mm6,g
punpcklwd mm6,mm6
punpcklwd mm6,mm6               {G je rozepsane do celeho mm6}


movd mm7,b
punpcklwd mm7,mm7
punpcklwd mm7,mm7               {B je rozepsane do celeho mm7}


@smycka:
movq mm1,es:[esi]                { pro R slozku }
movq mm2,mm1                  { pro G slozku }
movq mm3,mm1                  { pro B slozku }

psrlw mm1,11                  { R slozka osamostatnena }
psllw mm2,5
psrlw mm2,5+5                 { G slozka osamostatnena }
psllw mm3,11
psrlw mm3,11                  { B slozka osamostatnena }


psubusw mm1,mm5               { provede odecet R slozky }
psubusw mm2,mm6               { ...G slozky }
psubusw mm3,mm7               { ...B slozky }

psllw mm1,11                  { R na sve misto }
psllw mm2,5                   { G na sve misto }
                              { B na svem miste uz je }

por mm1,mm2
por mm1,mm3

movq es:[esi],mm1
add esi,8

sub ecx,8
cmp ecx,8
jge @smycka

emms
jecxz @konec

{-}@zbytek: {---------------------------}
shr ecx,1
{}@cykl_zbytku:
movzx eax,word ptr es:[esi]  {v EAX R}
mov ebx,eax                  {v EBX G}
mov edx,eax                  {v EDX B}
shr eax,11
shr ebx,5
and ebx,63
and edx,31
sub eax,r
sub ebx,g
sub edx,b
cmp eax,0
jge @r_ok
xor eax,eax
{}@r_ok:
cmp ebx,0
jge @g_ok
xor ebx,ebx
{}@g_ok:
cmp edx,0
jge @b_ok
xor edx,edx
{}@b_ok:
shl eax,11
shl ebx,5
or eax,ebx
or eax,edx
mov es:[esi],ax
add esi,2
dec ecx
jnz @cykl_zbytku


{---------------------------------------}
@konec:
pop es
end;


Procedure IncreaseSpriteLightness(var sprite:virtualwindow;r,g,b:longint);assembler;
const xm:packed array[1..8] of byte=(255,255,255,255,255,255,255,255);
asm
push es
mov esi,sprite
mov ecx,[esi+6]                 {size}
mov ax,[esi+0]
mov es,ax
mov esi,[esi+2]
cmp ecx,8
jl @zbytek

cmp ss:[cpu_info_mmx],0
jz @zbytek

movd mm5,r
punpcklwd mm5,mm5
punpcklwd mm5,mm5               {R je rozepsane do celeho mm5}

movd mm6,g
punpcklwd mm6,mm6
punpcklwd mm6,mm6               {G je rozepsane do celeho mm6}


movd mm7,b
punpcklwd mm7,mm7
punpcklwd mm7,mm7               {B je rozepsane do celeho mm7}


@smycka:
movq mm1,es:[esi]             { pro R slozku }

pxor mm1,xm                   {tmave zmenim na svetle a svetle na tmave}
                              {a dale budu pokracovat jako v procedure}
                              {DecreaseMMXSprite. Potom uplne na konci znovu}
                              {provedu PXOR}


movq mm2,mm1                  { pro G slozku }
movq mm3,mm1                  { pro B slozku }

psrlw mm1,11                  { R slozka osamostatnena }
psllw mm2,5
psrlw mm2,5+5                 { G slozka osamostatnena }
psllw mm3,11
psrlw mm3,11                  { B slozka osamostatnena }


psubusw mm1,mm5               { provede odecet R slozky }
psubusw mm2,mm6               { ...G slozky }
psubusw mm3,mm7               { ...B slozky }

psllw mm1,11                  { R na sve misto }
psllw mm2,5                   { G na sve misto }
                              { B na svem miste uz je }

por mm1,mm2
por mm1,mm3

pxor mm1,xm

movq es:[esi],mm1
add esi,8

sub ecx,8
cmp ecx,8
jge @smycka

emms
jecxz @konec
{-}@zbytek: {---------------------------}
shr ecx,1
{}@cykl_zbytku:
movzx eax,word ptr es:[esi]  {v EAX R}
mov ebx,eax                  {v EBX G}
mov edx,eax                  {v EDX B}
shr eax,11
shr ebx,5
and ebx,63
and edx,31
add eax,r
add ebx,g
add edx,b
cmp eax,31
jle @r_ok
mov eax,31
{}@r_ok:
cmp ebx,63
jle @g_ok
mov ebx,63
{}@g_ok:
cmp edx,31
jle @b_ok
mov edx,31
{}@b_ok:
shl eax,11
shl ebx,5
or eax,ebx
or eax,edx
mov es:[esi],ax
add esi,2
dec ecx
jnz @cykl_zbytku
{---------------------------------------}

@konec:
pop es
end;


Procedure CopySprite(var Sour, dest:virtualwindow);
begin
Flip_VW(sour,dest);
end;


Procedure DuplicateSprite(source:virtualwindow;var dest:virtualwindow);
var temp:longint;
begin
Init_VW(dest,source.breite,source.hoehe);
temp:=dest.VWoffset;
Move(source,dest,sizeof(virtualwindow));
dest.VWoffset:=temp;
dest.Segment:=Get_DS;  {pro pripad, ze duplikuju z VGA}

Flip_VW(source,dest);
if (dest.flags and 2)<>0 then
   begin
   GetMem(pointer(dest.RLEmap),dest.RLEsize);
   Move(pointer(source.RLEmap)^,pointer(dest.RLEmap)^,dest.RLEmap);
   end;
end;


Procedure _rotate180(var source, dest:virtualwindow);assembler;
var srcbytebreite:longint;
asm
mov esi,source
mov edi,dest

mov ecx,ds:[esi+6]     {size}
mov edi,[edi+2]
mov esi,[esi+2]
add esi,ecx
sub esi,2              {jsem na startovni pozici zdroje - pravy dolni roh}
shr ecx,1

@smycka:
mov ax,ds:[esi]
mov es:[edi],ax
add edi,2
sub esi,2
dec ecx
jnz @smycka
end;

Function Rotate180(var source:virtualwindow):VirtualWindow;
var v:virtualwindow;
begin
Init_VW(v,source.hoehe,source.breite,false);
_rotate180(source,v);
Rotate180:=v;
end;

Procedure _rotate90p(var source, dest:virtualwindow);assembler;
var srcbytebreite:longint;
asm
mov esi,source
mov edi,dest
mov eax,ds:[esi+26]    {bytebreite}
mov srcbytebreite,eax
mov edx,ds:[esi+10]    {breite}
mov ecx,ds:[esi+30]    {hoehe}
mov ebx,ecx
mov eax,ds:[esi+6]     {size}
mov edi,[edi+2]
mov esi,[esi+2]
add esi,eax
sub esi,srcbytebreite  {jsem na startovni pozici zdroje - levy dolni roh}

@dalsi_radek:
push esi
mov ecx,ebx

@smycka:
mov ax,ds:[esi]
mov es:[edi],ax
add edi,2
sub esi,srcbytebreite
dec ecx
jnz @smycka

pop esi
add esi,2
dec edx
jnz @dalsi_radek
end;

Function Rotate90p(var source:virtualwindow):VirtualWindow;
var v:virtualwindow;
begin
Init_VW(v,source.hoehe,source.breite,false);
_rotate90p(source,v);
Rotate90p:=v;
end;

Procedure _rotate90m(var source, dest:virtualwindow);assembler;
var srcbytebreite:longint;
asm
mov esi,source
mov edi,dest
mov eax,ds:[esi+26]    {bytebreite}
mov srcbytebreite,eax
mov edx,ds:[esi+10]    {breite}
mov ecx,ds:[esi+30]    {hoehe}
mov ebx,ecx
mov edi,[edi+2]
mov esi,[esi+2]
add esi,eax
sub esi,2  {jsem na startovni pozici zdroje - pravy horni roh}

@dalsi_radek:
push esi
mov ecx,ebx

@smycka:
mov ax,ds:[esi]
mov es:[edi],ax
add edi,2
add esi,srcbytebreite
dec ecx
jnz @smycka

pop esi
sub esi,2
dec edx
jnz @dalsi_radek
end;

Function Rotate90m(var source:virtualwindow):VirtualWindow;
var v:VirtualWindow;
begin
Init_VW(v,source.hoehe,source.breite,false);
_rotate90m(source,v);
Rotate90m:=v;
end;

Procedure _flipHorz(var source, dest:virtualwindow);assembler;
var srcbytebreite:longint;
asm
mov esi,source
mov edi,dest
mov eax,ds:[esi+26]    {bytebreite}
mov srcbytebreite,eax
mov ecx,ds:[esi+10]    {breite}
mov edx,ds:[esi+30]    {hoehe}
mov ebx,ecx
mov edi,[edi+2]
mov esi,[esi+2]
add esi,eax
sub esi,2  {jsem na startovni pozici zdroje - pravy horni roh}

@dalsi_radek:
push esi
mov ecx,ebx

@smycka:
mov ax,ds:[esi]
mov es:[edi],ax
add edi,2
sub esi,2
dec ecx
jnz @smycka

pop esi
add esi,srcbytebreite
dec edx
jnz @dalsi_radek
end;

Function FlipHorz(var source:virtualwindow):VirtualWindow;
var v:virtualwindow;
begin
Init_VW(v,source.breite,source.hoehe,false);
_FlipHorz(source,v);
Fliphorz:=v;
end;

Procedure _flipVert(var source, dest:virtualwindow);assembler;
var srcbytebreite:longint;
asm
mov esi,source
mov edi,dest
mov eax,ds:[esi+26]    {bytebreite}
mov srcbytebreite,eax
mov ecx,ds:[esi+10]    {breite}
mov edx,ds:[esi+30]    {hoehe}
mov ebx,ecx
mov eax,ds:[esi+6]     {size}
mov edi,[edi+2]
mov esi,[esi+2]
add esi,eax
sub esi,srcbytebreite  {jsem na startovni pozici zdroje - levy dolni roh}

@dalsi_radek:
push esi
mov ecx,ebx

@smycka:
mov ax,ds:[esi]
mov es:[edi],ax
add edi,2
add esi,2
dec ecx
jnz @smycka

pop esi
sub esi,srcbytebreite
dec edx
jnz @dalsi_radek
end;

Function FlipVert(var source:virtualwindow):VirtualWindow;
var v:virtualwindow;
begin
Init_VW(v,source.breite,source.hoehe,false);
_FlipVert(source,v);
FlipVert:=v;
end;


PROCEDURE Rotate_Scale_Sprite(var Sour, dest:virtualwindow;x,y,Breite,Hoehe,Winkel:LongInt);
VAR       RealWert                         : Real;
          yPos,Temp_TLx,Temp_TLy           : LongInt;
          xDIFF,yDIFF,xADD,yADD,Rest       : LongInt;
          Corner_TLx,Corner_TLy            : LongInt;
          Corner_TRx,Corner_TRy            : LongInt;
          Corner_BLx,Corner_BLy            : LongInt;
          Corner_BRx,Corner_BRy            : LongInt;
          Position,Loop                    : LongInt;
          PosGanz_X,PosGanz_Y,NewWinkel    : LongInt;
          PosRest_X,PosRest_Y              : Word;
          RestCounter_X,RestCounter_Y      : Word;
          SourSegment                      : Longint;
          SourVWoffset                     : Longint;
          SourByteBreite                   : Longint;
          DestSegment                      : Longint;
          DestVWoffset                     : Longint;
          DestByteBreite                   : Longint;
          DestBreite                       : Longint;

Begin

 { FIRST CALCULATE X/Y CORDS OF THE SPRITE CORNERS }


 RealWert:= Sqrt((Breite shr 1 * Breite shr 1) shl 1);
 SourSegment:=Sour.Segment;
 SourVWoffset:=Sour.VWOffset;
 SourByteBreite:=Sour.ByteBreite;
 DestSegment:=Dest.Segment;
 DestVWoffset:=Dest.VWOffset;
 DestByteBreite:=Dest.ByteBreite;
 DestBreite:=Dest.Breite;

 ASM
  Mov eax,Winkel;  Add eax, 45;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_TRx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_TRy:= y - Trunc( Sinus[NewWinkel] * RealWert );

 ASM
  Mov eax,Winkel;  Add eax,135;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_TLx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_TLy:= y - Trunc( Sinus[NewWinkel] * RealWert );

 ASM
  Mov eax,Winkel;  Add eax,225;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_BLx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_BLy:= y - Trunc( Sinus[NewWinkel] * RealWert );

 ASM
  Mov eax,Winkel;  Add eax,315;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_BRx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_BRy:= y - Trunc( Sinus[NewWinkel] * RealWert );


 { NOW PRECALCULATE X/Y POSITIONS IN THE FIRST LINE FOR ALL LINES (SPEED UP) }


  ASM
   Mov eax,Corner_TLx
   Mov Temp_TLx,eax
   Mov eax,Corner_TLy
   Mov Temp_TLy,eax
   Mov Position,0

   Mov eax,Temp_TLx
   Cmp eax,Corner_TRx
   Jl  @Kleiner1
    Je @Ende1
    Mov xAdd,-1
    Jmp @Ende1
   @Kleiner1:
   Mov xAdd,1
   @Ende1:

   Mov eax,Temp_TLy
   Cmp eax,Corner_TRy
   Jl  @Kleiner2
    Je @Ende2
    Mov yAdd,-1
    Jmp @Ende2
   @Kleiner2:
   Mov yAdd,1
   @Ende2:
  END;
  xDIFF:= abs(Temp_TLx-Corner_TRx);
  yDIFF:= abs(Temp_TLy-Corner_TRy);

  LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
  LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
  Inc(Position);

  If xDIFF>yDIFF then
  begin
   Rest:=-(xDIFF shr 1);
   WHILE Temp_TLx<>Corner_TRx do
   begin
    Inc(Rest    ,yDIFF);
    Inc(Temp_TLx,xADD );
    If Rest>0 then
    begin
     LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
     LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
     Inc(Position);
     Inc(Temp_TLy, yADD);
     Dec(Rest    ,xDIFF);
    end;
    LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
    LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
    Inc(Position);
   end;
  end
  else
  begin
   Rest:=-(yDIFF shr 1);
   WHILE Temp_TLy<>Corner_TRy do
   begin
    Inc(Rest    ,xDIFF);
    Inc(Temp_TLy, yADD);
    If Rest>0 then
    begin
     LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
     LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
     Inc(Position);
     Inc(Temp_TLx, xADD);
     Dec(Rest    ,yDIFF);
    end;
    LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
    LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
    Inc(Position);
   end;
  end;


 { COPY ALL LINES TO DESTINATIONSPRITE WITH AN INDEX INTO THE SOURCESPRITE }


 RealWert := Sour.BreiteMinus1 / Position;      { Used to scale sprite }
 PosRest_X:= Trunc(Frac(RealWert)*65535);
 PosGanz_X:= Trunc(RealWert) shl 1;           { Shl 1 for asm routine }

 RealWert := Sour.HoeheMinus1 / CalculateDetailLine(Corner_TLx,Corner_TLy,Corner_BLx,Corner_BLy);
 PosRest_Y:= Trunc(Frac(RealWert)*65535);
 PosGanz_Y:= Trunc(RealWert);

 ASM
  Mov eax,Corner_TLx
  Cmp eax,Corner_BLx
  Jl  @Kleiner1
   Je @Ende1
   Mov xAdd,-1
   Jmp @Ende1
  @Kleiner1:
  Mov xAdd,1
  @Ende1:

  Mov eax,Corner_TLy
  Cmp eax,Corner_BLy
  Jl  @Kleiner2
   Je @Ende2
   Mov yAdd,-1
   Jmp @Ende2
  @Kleiner2:
  Mov yAdd,1
  @Ende2:
 END;
 xDIFF:= Abs(Corner_TLx-Corner_BLx);
 yDIFF:= Abs(Corner_TLy-Corner_BLy);

 Asm
  Mov ypos,0

  Push es

  Mov es ,SourSegment
  Mov edi,SourVWOffset
  Mov eax,SourByteBreite
  Mul ypos
  Add edi,eax

  Xor ecx,ecx
  @LOOPIT:

   Lea esi,LinePosition         { read actual x-add from array }
   Mov eax,ecx
   Shl eax,3
   Add esi,eax
   Mov ebx,ds:[esi]
   Add ebx,Corner_TLx

   Mov edx,ds:[esi+4]           { read actual y-add from array }
   Add edx,Corner_TLy

   Push ds
    Mov eax,DestBreite         { Write Pixel to destination sprite }
    Mul edx
    Add eax,ebx
    Shl eax,1
    Mov ds ,DestSegment
    Mov esi,DestVWOffset
    Add esi,eax
    Mov dx,es:[edi]             { Get Pixel from source sprite }
    Mov ds:[esi],dx
   Pop ds

   Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
   Mov ax,PosRest_X
   Add RestCounter_X,ax
   Jnc @Jump
    Add edi,2
   @Jump:

  Inc ecx
  Cmp ecx,Position
  Jb  @LOOPIT

  Pop es

  Mov eax,PosGanz_Y             { Inc y-position in source sprite (scaled) }
  Add ypos,eax
  Mov ax,PosRest_Y
  Add RestCounter_Y,ax
  Jnc @JumpTo
   Inc ypos
  @JumpTo:
 End;

 If xDIFF>yDIFF then
 begin
  Rest:=-(xDIFF shr 1);
  WHILE (Corner_TLx<>Corner_BLx) do
  begin
   Inc(Rest,yDIFF);
   Inc(Corner_TLx,xADD);
   If Rest>0 then
   Asm
     Push es

     Mov es ,SourSegment
     Mov edi,SourVWOffset
     Mov eax,SourByteBreite
     Mul ypos
     Add edi,eax

     Xor ecx,ecx
     @LOOPIT:

      Lea esi,LinePosition         { read actual x-add from array }
      Mov eax,ecx
      Shl eax,3
      Add esi,eax
      Mov ebx,ds:[esi]
      Add ebx,Corner_TLx

      Mov edx,ds:[esi+4]           { read actual y-add from array }
      Add edx,Corner_TLy

      Push ds
       Mov eax,DestBreite         { Write Pixel to destination sprite }
       Mul edx
       Add eax,ebx
       Shl eax,1
       Mov ds ,DestSegment
       Mov esi,DestVWOffset
       Add esi,eax
       Mov dx,es:[edi]             { Get Pixel from source sprite }
       Mov ds:[esi],dx
      Pop ds

      Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
      Mov ax,PosRest_X
      Add RestCounter_X,ax
      Jnc @Jump
       Add edi,2
      @Jump:

      Inc ecx
      Cmp ecx,Position
      Jb  @LOOPIT

     Pop es

     Mov eax,PosGanz_Y             { Inc y-position in source sprite (scaled) }
     Add ypos,eax
     Mov ax,PosRest_Y
     Add RestCounter_Y,ax
     Jnc @JumpTo
      Inc ypos
     @JumpTo:

     Mov eax,yADD
     Add Corner_TLy,eax
     Mov eax,xDIFF
     Sub Rest,eax
   End;

   Asm
    Push es

    Mov es ,SourSegment
    Mov edi,SourVWOffset
    Mov eax,SourByteBreite
    Mul ypos
    Add edi,eax

    Xor ecx,ecx
    @LOOPIT:

     Lea esi,LinePosition          { read actual x-add from array }
     Mov eax,ecx
     Shl eax,3
     Add esi,eax
     Mov ebx,ds:[esi]
     Add ebx,Corner_TLx

     Mov edx,ds:[esi+4]            { read actual y-add from array }
     Add edx,Corner_TLy

     Push ds
      Mov eax,DestBreite          { Write Pixel to destination sprite }
      Mul edx
      Add eax,ebx
      Shl eax,1
      Mov ds ,DestSegment
      Mov esi,DestVWOffset
      Add esi,eax
      Mov dx,es:[edi]              { Get Pixel from source sprite }
      Mov ds:[esi],dx
     Pop ds

     Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
     Mov ax,PosRest_X
     Add RestCounter_X,ax
     Jnc @Jump
      Add edi,2
     @Jump:

    Inc ecx
    Cmp ecx,Position
    Jb  @LOOPIT

    Pop es

    Mov eax,PosGanz_Y              { Inc y-position in source sprite (scaled) }
    Add ypos,eax
    Mov ax,PosRest_Y
    Add RestCounter_Y,ax
    Jnc @JumpTo
     Inc ypos
    @JumpTo:
   End;

  end;
 end
 else
 begin
  Rest:=-(yDIFF shr 1);
  WHILE (Corner_TLy<>Corner_BLy) do
  begin
   Inc(Rest,xDIFF);
   Inc(Corner_TLy,yADD);
   If Rest>0 then
   Asm
     Push es

     Mov es ,SourSegment
     Mov edi,SourVWOffset
     Mov eax,SourByteBreite
     Mul ypos
     Add edi,eax

     Xor ecx,ecx
     @LOOPIT:

      Lea esi,LinePosition         { read actual x-add from array }
      Mov eax,ecx
      Shl eax,3
      Add esi,eax
      Mov ebx,ds:[esi]
      Add ebx,Corner_TLx

      Mov edx,ds:[esi+4]           { read actual y-add from array }
      Add edx,Corner_TLy

      Push ds
       Mov eax,DestBreite         { Write Pixel to destination sprite }
       Mul edx
       Add eax,ebx
       Shl eax,1
       Mov ds ,DestSegment
       Mov esi,DestVWOffset
       Add esi,eax
       Mov dx,es:[edi]             { Get Pixel from source sprite }
       Mov ds:[esi],dx
      Pop ds

      Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
      Mov ax,PosRest_X
      Add RestCounter_X,ax
      Jnc @Jump
       Add edi,2
      @Jump:

     Inc ecx
     Cmp ecx,Position
     Jb  @LOOPIT

     Pop es

     Mov eax,PosGanz_Y             { Inc y-position in source sprite (scaled) }
     Add ypos,eax
     Mov ax,PosRest_Y
     Add RestCounter_Y,ax
     Jnc @JumpTo
      Inc ypos
     @JumpTo:

     Mov eax,xADD
     Add Corner_TLx,eax
     Mov eax,yDIFF
     Sub Rest,eax
   End;

   Asm
    Push es

    Mov es ,SourSegment
    Mov edi,SourVWOffset
    Mov eax,SourByteBreite
    Mul ypos
    Add edi,eax

    Xor ecx,ecx
    @LOOPIT:

     Lea esi,LinePosition          { read actual x-add from array }
     Mov eax,ecx
     Shl eax,3
     Add esi,eax
     Mov ebx,ds:[esi]
     Add ebx,Corner_TLx

     Mov edx,ds:[esi+4]            { read actual y-add from array }
     Add edx,Corner_TLy

     Push ds
      Mov eax,DestBreite          { Write Pixel to destination sprite }
      Mul edx
      Add eax,ebx
      Shl eax,1
      Mov ds ,DestSegment
      Mov esi,DestVWOffset
      Add esi,eax
      Mov dx,es:[edi]              { Get Pixel from source sprite }
      Mov ds:[esi],dx
     Pop ds

     Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
     Mov ax,PosRest_X
     Add RestCounter_X,ax
     Jnc @Jump
      Add edi,2
     @Jump:

    Inc ecx
    Cmp ecx,Position
    Jb  @LOOPIT

    Pop es

    Mov eax,PosGanz_Y              { Inc y-position in source sprite (scaled) }
    Add ypos,eax
    Mov ax,PosRest_Y
    Add RestCounter_Y,ax
    Jnc @JumpTo
     Inc ypos
    @JumpTo:
   End;
  end;
 end;
End;


PROCEDURE Rotate_Scale_SpriteHC(var Sour, dest:virtualwindow;x,y,Breite,Hoehe,Winkel:LongInt;Hcolor:Word);
VAR       RealWert                         : Real;
          yPos,Temp_TLx,Temp_TLy           : LongInt;
          xDIFF,yDIFF,xADD,yADD,Rest       : LongInt;
          Corner_TLx,Corner_TLy            : LongInt;
          Corner_TRx,Corner_TRy            : LongInt;
          Corner_BLx,Corner_BLy            : LongInt;
          Corner_BRx,Corner_BRy            : LongInt;
          Position,Loop                    : LongInt;
          PosGanz_X,PosGanz_Y,NewWinkel    : LongInt;
          PosRest_X,PosRest_Y              : Word;
          RestCounter_X,RestCounter_Y      : Word;
          SourSegment                      : Longint;
          SourVWoffset                     : Longint;
          SourByteBreite                   : Longint;
          DestSegment                      : Longint;
          DestVWoffset                     : Longint;
          DestByteBreite                   : Longint;
          DestBreite                       : Longint;
begin
 { FIRST CALCULATE X/Y CORDS OF THE SPRITE CORNERS }


 RealWert:= Sqrt((Breite shr 1 * Breite shr 1) shl 1);
 SourSegment:=Sour.Segment;
 SourVWoffset:=Sour.VWOffset;
 SourByteBreite:=Sour.ByteBreite;
 DestSegment:=Dest.Segment;
 DestVWoffset:=Dest.VWOffset;
 DestByteBreite:=Dest.ByteBreite;
 DestBreite:=Dest.Breite;

 ASM
  Mov eax,Winkel;  Add eax, 45;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_TRx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_TRy:= y - Trunc( Sinus[NewWinkel] * RealWert );

 ASM
  Mov eax,Winkel;  Add eax,135;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_TLx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_TLy:= y - Trunc( Sinus[NewWinkel] * RealWert );

 ASM
  Mov eax,Winkel;  Add eax,225;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_BLx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_BLy:= y - Trunc( Sinus[NewWinkel] * RealWert );

 ASM
  Mov eax,Winkel;  Add eax,315;
  Cmp eax,361
  Jl @Jump1
   Sub eax,360
  @Jump1:
  Cmp eax,0
  Jg @Jump2
   Add eax,360
  @Jump2:
  Mov NewWinkel,eax
 END;
 Corner_BRx:= x + Trunc( Cosin[NewWinkel] * RealWert );
 Corner_BRy:= y - Trunc( Sinus[NewWinkel] * RealWert );


 { NOW PRECALCULATE X/Y POSITIONS IN THE FIRST LINE FOR ALL LINES (SPEED UP) }


  ASM
   Mov eax,Corner_TLx
   Mov Temp_TLx,eax
   Mov eax,Corner_TLy
   Mov Temp_TLy,eax
   Mov Position,0

   Mov eax,Temp_TLx
   Cmp eax,Corner_TRx
   Jl  @Kleiner1
    Je @Ende1
    Mov xAdd,-1
    Jmp @Ende1
   @Kleiner1:
   Mov xAdd,1
   @Ende1:

   Mov eax,Temp_TLy
   Cmp eax,Corner_TRy
   Jl  @Kleiner2
    Je @Ende2
    Mov yAdd,-1
    Jmp @Ende2
   @Kleiner2:
   Mov yAdd,1
   @Ende2:
  END;
  xDIFF:= abs(Temp_TLx-Corner_TRx);
  yDIFF:= abs(Temp_TLy-Corner_TRy);

  LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
  LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
  Inc(Position);

  If xDIFF>yDIFF then
  begin
   Rest:=-(xDIFF shr 1);
   WHILE Temp_TLx<>Corner_TRx do
   begin
    Inc(Rest    ,yDIFF);
    Inc(Temp_TLx,xADD );
    If Rest>0 then
    begin
     LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
     LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
     Inc(Position);
     Inc(Temp_TLy, yADD);
     Dec(Rest    ,xDIFF);
    end;
    LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
    LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
    Inc(Position);
   end;
  end
  else
  begin
   Rest:=-(yDIFF shr 1);
   WHILE Temp_TLy<>Corner_TRy do
   begin
    Inc(Rest    ,xDIFF);
    Inc(Temp_TLy, yADD);
    If Rest>0 then
    begin
     LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
     LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
     Inc(Position);
     Inc(Temp_TLx, xADD);
     Dec(Rest    ,yDIFF);
    end;
    LinePosition[Position shl 1  ]:= Temp_TLx-Corner_TLx;
    LinePosition[Position shl 1+1]:= Temp_TLy-Corner_TLy;
    Inc(Position);
   end;
  end;


 { COPY ALL LINES TO DESTINATIONSPRITE WITH AN INDEX INTO THE SOURCESPRITE }


 RealWert := Sour.BreiteMinus1 / Position;      { Used to scale sprite }
 PosRest_X:= Trunc(Frac(RealWert)*65535);
 PosGanz_X:= Trunc(RealWert) shl 1;           { Shl 1 for asm routine }

 RealWert := Sour.HoeheMinus1 / CalculateDetailLine(Corner_TLx,Corner_TLy,Corner_BLx,Corner_BLy);
 PosRest_Y:= Trunc(Frac(RealWert)*65535);
 PosGanz_Y:= Trunc(RealWert);

 ASM
  Mov eax,Corner_TLx
  Cmp eax,Corner_BLx
  Jl  @Kleiner1
   Je @Ende1
   Mov xAdd,-1
   Jmp @Ende1
  @Kleiner1:
  Mov xAdd,1
  @Ende1:

  Mov eax,Corner_TLy
  Cmp eax,Corner_BLy
  Jl  @Kleiner2
   Je @Ende2
   Mov yAdd,-1
   Jmp @Ende2
  @Kleiner2:
  Mov yAdd,1
  @Ende2:
 END;
 xDIFF:= Abs(Corner_TLx-Corner_BLx);
 yDIFF:= Abs(Corner_TLy-Corner_BLy);

 Asm
  Mov ypos,0

  Push es

  Mov es ,SourSegment
  Mov edi,SourVWOffset
  Mov eax,SourByteBreite
  Mul ypos
  Add edi,eax

  Xor ecx,ecx
  @LOOPIT:

   Lea esi,LinePosition         { read actual x-add from array }
   Mov eax,ecx
   Shl eax,3
   Add esi,eax
   Mov ebx,ds:[esi]
   Add ebx,Corner_TLx

   Mov edx,ds:[esi+4]           { read actual y-add from array }
   Add edx,Corner_TLy

   Push ds
    Mov eax,DestBreite         { Write Pixel to destination sprite }
    Mul edx
    Add eax,ebx
    Shl eax,1
    Mov ds ,DestSegment
    Mov esi,DestVWOffset
    Add esi,eax
    Mov dx,es:[edi]             { Get Pixel from source sprite }
    Cmp dx,HColor
    Je @NOVALIDCOLOR
    Mov ds:[esi],dx
    @NOVALIDCOLOR:
   Pop ds

   Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
   Mov ax,PosRest_X
   Add RestCounter_X,ax
   Jnc @Jump
    Add edi,2
   @Jump:

  Inc ecx
  Cmp ecx,Position
  Jb  @LOOPIT

  Pop es

  Mov eax,PosGanz_Y             { Inc y-position in source sprite (scaled) }
  Add ypos,eax
  Mov ax,PosRest_Y
  Add RestCounter_Y,ax
  Jnc @JumpTo
   Inc ypos
  @JumpTo:
 End;

 If xDIFF>yDIFF then
 begin
  Rest:=-(xDIFF shr 1);
  WHILE (Corner_TLx<>Corner_BLx) do
  begin
   Inc(Rest,yDIFF);
   Inc(Corner_TLx,xADD);
   If Rest>0 then
   Asm
     Push es

     Mov es ,SourSegment
     Mov edi,SourVWOffset
     Mov eax,SourByteBreite
     Mul ypos
     Add edi,eax

     Xor ecx,ecx
     @LOOPIT:

      Lea esi,LinePosition         { read actual x-add from array }
      Mov eax,ecx
      Shl eax,3
      Add esi,eax
      Mov ebx,ds:[esi]
      Add ebx,Corner_TLx

      Mov edx,ds:[esi+4]           { read actual y-add from array }
      Add edx,Corner_TLy

      Push ds
       Mov eax,DestBreite         { Write Pixel to destination sprite }
       Mul edx
       Add eax,ebx
       Shl eax,1
       Mov ds ,DestSegment
       Mov esi,DestVWOffset
       Add esi,eax
       Mov dx,es:[edi]             { Get Pixel from source sprite }
       Cmp dx,HColor
       Je @NOVALIDCOLOR
       Mov ds:[esi],dx
       @NOVALIDCOLOR:
      Pop ds

      Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
      Mov ax,PosRest_X
      Add RestCounter_X,ax
      Jnc @Jump
       Add edi,2
      @Jump:

      Inc ecx
      Cmp ecx,Position
      Jb  @LOOPIT

     Pop es

     Mov eax,PosGanz_Y             { Inc y-position in source sprite (scaled) }
     Add ypos,eax
     Mov ax,PosRest_Y
     Add RestCounter_Y,ax
     Jnc @JumpTo
      Inc ypos
     @JumpTo:

     Mov eax,yADD
     Add Corner_TLy,eax
     Mov eax,xDIFF
     Sub Rest,eax
   End;

   Asm
    Push es

    Mov es ,SourSegment
    Mov edi,SourVWOffset
    Mov eax,SourByteBreite
    Mul ypos
    Add edi,eax

    Xor ecx,ecx
    @LOOPIT:

     Lea esi,LinePosition          { read actual x-add from array }
     Mov eax,ecx
     Shl eax,3
     Add esi,eax
     Mov ebx,ds:[esi]
     Add ebx,Corner_TLx

     Mov edx,ds:[esi+4]            { read actual y-add from array }
     Add edx,Corner_TLy

     Push ds
      Mov eax,DestBreite          { Write Pixel to destination sprite }
      Mul edx
      Add eax,ebx
      Shl eax,1
      Mov ds ,DestSegment
      Mov esi,DestVWOffset
      Add esi,eax
      Mov dx,es:[edi]              { Get Pixel from source sprite }
      Cmp dx,HColor
      Je @NOVALIDCOLOR
      Mov ds:[esi],dx
      @NOVALIDCOLOR:
     Pop ds

     Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
     Mov ax,PosRest_X
     Add RestCounter_X,ax
     Jnc @Jump
      Add edi,2
     @Jump:

    Inc ecx
    Cmp ecx,Position
    Jb  @LOOPIT

    Pop es

    Mov eax,PosGanz_Y              { Inc y-position in source sprite (scaled) }
    Add ypos,eax
    Mov ax,PosRest_Y
    Add RestCounter_Y,ax
    Jnc @JumpTo
     Inc ypos
    @JumpTo:
   End;

  end;
 end
 else
 begin
  Rest:=-(yDIFF shr 1);
  WHILE (Corner_TLy<>Corner_BLy) do
  begin
   Inc(Rest,xDIFF);
   Inc(Corner_TLy,yADD);
   If Rest>0 then
   Asm
     Push es

     Mov es ,SourSegment
     Mov edi,SourVWOffset
     Mov eax,SourByteBreite
     Mul ypos
     Add edi,eax

     Xor ecx,ecx
     @LOOPIT:

      Lea esi,LinePosition         { read actual x-add from array }
      Mov eax,ecx
      Shl eax,3
      Add esi,eax
      Mov ebx,ds:[esi]
      Add ebx,Corner_TLx

      Mov edx,ds:[esi+4]           { read actual y-add from array }
      Add edx,Corner_TLy

      Push ds
       Mov eax,DestBreite         { Write Pixel to destination sprite }
       Mul edx
       Add eax,ebx
       Shl eax,1
       Mov ds ,DestSegment
       Mov esi,DestVWOffset
       Add esi,eax
       Mov dx,es:[edi]             { Get Pixel from source sprite }
       Cmp dx,HColor
       Je @NOVALIDCOLOR
       Mov ds:[esi],dx
       @NOVALIDCOLOR:
      Pop ds

      Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
      Mov ax,PosRest_X
      Add RestCounter_X,ax
      Jnc @Jump
       Add edi,2
      @Jump:

     Inc ecx
     Cmp ecx,Position
     Jb  @LOOPIT

     Pop es

     Mov eax,PosGanz_Y             { Inc y-position in source sprite (scaled) }
     Add ypos,eax
     Mov ax,PosRest_Y
     Add RestCounter_Y,ax
     Jnc @JumpTo
      Inc ypos
     @JumpTo:

     Mov eax,xADD
     Add Corner_TLx,eax
     Mov eax,yDIFF
     Sub Rest,eax
   End;

   Asm
    Push es

    Mov es ,SourSegment
    Mov edi,SourVWOffset
    Mov eax,SourByteBreite
    Mul ypos
    Add edi,eax

    Xor ecx,ecx
    @LOOPIT:

     Lea esi,LinePosition          { read actual x-add from array }
     Mov eax,ecx
     Shl eax,3
     Add esi,eax
     Mov ebx,ds:[esi]
     Add ebx,Corner_TLx

     Mov edx,ds:[esi+4]            { read actual y-add from array }
     Add edx,Corner_TLy

     Push ds
      Mov eax,DestBreite          { Write Pixel to destination sprite }
      Mul edx
      Add eax,ebx
      Shl eax,1
      Mov ds ,DestSegment
      Mov esi,DestVWOffset
      Add esi,eax
      Mov dx,es:[edi]              { Get Pixel from source sprite }
      Cmp dx,HColor
      Je @NOVALIDCOLOR
      Mov ds:[esi],dx
      @NOVALIDCOLOR:
     Pop ds

     Add edi,PosGanz_X            { Inc x-position in source sprite (scaled) }
     Mov ax,PosRest_X
     Add RestCounter_X,ax
     Jnc @Jump
      Add edi,2
     @Jump:

    Inc ecx
    Cmp ecx,Position
    Jb  @LOOPIT

    Pop es

    Mov eax,PosGanz_Y              { Inc y-position in source sprite (scaled) }
    Add ypos,eax
    Mov ax,PosRest_Y
    Add RestCounter_Y,ax
    Jnc @JumpTo
     Inc ypos
    @JumpTo:
   End;
  end;
 end;
End;


Procedure AsmAverage(var src1,src2,dst:virtualwindow);assembler;
asm
push ebp
mov esi,src1
mov ecx,[esi+6]    {size}
mov esi,[esi+2]    {vwoffset}
mov edi,src2
mov edi,[edi+2]    {vwoffset}
mov ebp,dst
mov ebp,[ebp+2]    {vwoffset}


mov edx,ecx
and edx,3
push edx

@cykl:
mov eax,[esi]
mov ebx,[edi]
mov edx,ebx
and ebx,eax   {v EBX je (A and B)}

xor eax,edx
and eax,0f7def7deh
shr eax,1
add eax,ebx
mov [ebp],eax
add esi,4
add edi,4
add ebp,4
sub ecx,4
jnz @cykl

pop edx
shr edx,1
cmp edx,0
jz @konec

{posledni pixel?}
movzx eax,word [esi]
movzx ebx,word [edi]
add eax,ebx
shr eax,1
mov [ebp],ax
{---------------}

@konec:
pop ebp
end;

Function AverageSprites(var src1,src2:virtualwindow):virtualwindow;
var dst:virtualwindow;
begin
Init_VW(dst,src1.breite,src1.hoehe,false);
AsmAverage(src1,src2,dst);
AverageSprites:=dst;
end;


procedure AsmDifference(var src1,src2,dst:virtualwindow);assembler;
asm
push ebp
mov esi,src1
mov ecx,[esi+6]    {size}
mov esi,[esi+2]    {vwoffset}
mov edi,src2
mov edi,[edi+2]    {vwoffset}
mov ebp,dst
mov ebp,[ebp+2]    {vwoffset}
mov edx,ecx
and edx,3
push edx

@cykl:
    mov eax,[edi]
    mov ebx,[esi]
    and eax,$001F001F
    and ebx,$001F001F
    or  eax,$00200020
    sub eax,ebx
    mov ebx,eax
    and ebx,$00200020
    shr ebx,5
    imul ebx,$1F
    xor eax,ebx

    mov edx,[edi]
    mov ebx,[esi]
    and edx,$07E007E0
    and ebx,$07E007E0
    shr edx,5
    shr ebx,5
    or  edx,$00400040
    sub edx,ebx
    mov ebx,edx
    and ebx,$00400040
    shr ebx,6
    imul ebx,$3F
    xor edx,ebx
    shl edx,5
    or  eax,edx

    mov edx,[edi]
    mov ebx,[esi]
    and edx,$F800F800
    and ebx,$F800F800
    shr edx,11
    shr ebx,11
    or  edx,$00200020
    sub edx,ebx
    mov ebx,edx
    and ebx,$00200020
    shr ebx,5
    imul ebx,$1F
    xor edx,ebx
    shl edx,11
    or  eax,edx
    xor eax,-1

    mov [ebp],eax
    add edi,4
    add esi,4
    add ebp,4
    sub ecx,4
jnz @cykl

pop edx
shr edx,1
cmp edx,0
jz @konec

{posledni pixel?}

{---------------}
@konec:
pop ebp
end;

Function DifferenceSprites(var src1,src2:virtualwindow):virtualwindow;
var dst:Virtualwindow;
begin
Init_VW(dst,src1.breite,src2.breite,false);
AsmDifference(src1,src2,dst);
DifferenceSprites:=dst;
end;


Procedure Mouse_blackwork(var r:trealregs;j:boolean);
begin
mouse.b := r.bl;
{stav tlacitek asi muzu updatovat i kdyz je mys "busy" a "locked"}

if (mouse.busy=false) and (mouse.locked=false) then
   begin
   mouse.busy:=true;
   mouse.x := r.cx div 8;
   mouse.y := r.dx div 8;
   mouse.dx := r.si;       {delta X}
   mouse.dy := r.di;       {delta Y}
   if (r.ax and 2)<>0 then        {position on last left click}
      begin
      mouse.last_lpx:=mouse.x;mouse.last_lpy:=mouse.y;
      mouse.last_lp_time:=FromTimer;
      end;

   if (r.ax and 4)<>0 then {position on last left release}
      begin mouse.last_lrx:=mouse.x;mouse.last_lry:=mouse.y;end;

   if (r.ax and 8)<>0 then        {position on last right click}
      begin
      mouse.last_rpx:=mouse.x;mouse.last_rpy:=mouse.y;
      mouse.last_rp_time:=FromTimer;
      end;

   if (r.ax and 16)<>0 then       {position on last right release}
      begin mouse.last_rrx:=mouse.x;mouse.last_rry:=mouse.y;end;


   if not mouse.visible then
      begin
      mouse.old_x:=mouse.x;
      mouse.old_y:=mouse.y;
      end;
   if mouse.has_wheel then
      begin
      mouse._wdif:=r.bh;
      inc(mouse.W,mouse._wdif);
      if mouse.W>mouse.wheelrange then mouse.W:=mouse.wheelrange else
      if mouse.W<-mouse.wheelrange then mouse.W:=-mouse.wheelrange;
      end;

   if J then mouse.callback_routine;
   mouse.busy:=false;
   end;
end;

Procedure Mouse_user_proc;
begin
Mouse_blackwork(mouse_regs,true);
end;
Procedure Mouse_user_proc_Dummy;
begin end;


procedure Mouse_callback_handler; assembler;{$IFDEF NEWFPC}nostackframe;{$ENDIF}
 asm
 cli
 push ds
 push eax
 mov ax,es
 mov ds,ax
 {cmp dword ptr mouse_driver_installed,0
 je @LNoCallback}
 cmp mouse.busy,0
 jne @LNoCallback
 cmp mouse.busy2,0
 jne @LNoCallback

 pushad {zalohuje vsechny registry (krome segmentovych a flags)}
 mov ax,DOSmemSelector
 mov fs,ax
 call Mouse_user_proc
 popad  {obnovi zalohovane registry}
@LNoCallback:

 pop eax
 pop ds

 push eax
 mov eax,[esi]
 mov es:[edi+2Ah],eax           {obnova realmodoveho IP a CS}
 add word ptr es:[edi+2Eh],4    {obnova realmodoveho SP}
 pop eax
 sti
 iret
 end;
procedure Mouse_callback_handler_Dummy;
begin end;


Procedure MouseDraw;
begin
if not mouse_driver_installed then Exit;
if (mouse.x=mouse.old_x) and (mouse.y=mouse.old_y) then Exit;
mouse.busy:=true;
if mouse.visible then
   begin
   mouse.delcursor(mouse.workplace,mouse.background,mouse.old_x-mouse.hotspot_x,mouse.old_y-mouse.hotspot_y);
   mouse.getcursor(mouse.workplace,mouse.background,mouse.x-mouse.hotspot_x,mouse.y-mouse.hotspot_y);
   mouse.putcursor(mouse.workplace,mouse.cursor,mouse.x-mouse.hotspot_x,mouse.y-mouse.hotspot_y,mouse.cursor.transcol);
   end;
mouse.old_x:=mouse.x;
mouse.old_y:=mouse.y;
mouse.busy:=false;
end;


Procedure MouseRefresh;
begin
if not mouse.visible then Exit;
mouse.busy:=true;
mouse.getcursor(mouse.workplace,mouse.background,mouse.x-mouse.hotspot_x,mouse.y-mouse.hotspot_y);
mouse.putcursor(mouse.workplace,mouse.cursor,mouse.x-mouse.hotspot_x,mouse.y-mouse.hotspot_y,mouse.cursor.transcol);
mouse.busy:=false;
end;


Procedure DestroyMouseCursor;
var p:pointer;
begin
p:=MouseGetCursor;
if (p<>@DEFAULT_POINTER) and (p<>@CLOCK_POINTER) and (p<>@HAND_POINTER) then
   Kill_VW(mouse.cursor);
end;


Procedure MouseSetCursor(p:pvirtualwindow);
var b:boolean;
begin
if Mouse_driver_installed then
   begin
   if mouse.visible then
      begin
      b:=true;
      MouseHide;
      end else b:=false;
   if mouse.cursor.VWoffset<>0 then
      begin
      DestroyMouseCursor;
      Kill_VW(mouse.background);
      end;
   end;

if (p<>MOUSEDEF) and (p<>MOUSECLK) and (p<>MOUSEHND) then
   begin
   Init_VW(mouse.cursor,p^.breite,p^.hoehe,false);
   Move(pointer(p^.VWoffset)^,pointer(mouse.cursor.VWoffset),p^.size);
   mouse.cursor.position:=p^.position;
   mouse.cursor.TransCol:=p^.TransCol;
   mouse.cursor.Position:=p^.Position;
   Lock_VW(mouse.cursor);
   end
   else Move(p^,mouse.cursor,sizeof(VirtualWindow));

mouse.hotspot_y:=mouse.cursor.Position div mouse.cursor.breite;
mouse.hotspot_x:=mouse.cursor.Position mod mouse.cursor.breite;


Init_VW(mouse.background,mouse.cursor.breite,mouse.cursor.hoehe,false);
if Mouse_driver_installed then
   if B then MouseShow;
end;


Function MouseGetCursor:pointer;
begin
MouseGetCursor:=pointer(mouse.cursor.VWoffset);
end;


procedure MouseHide;
begin
if not mouse_driver_installed then Exit;
if mouse.visible=false then Exit;
mouse.busy:=true;
{PutClippedSprite}mouse.delcursor(mouse.workplace,mouse.background,mouse.old_x-mouse.hotspot_x,mouse.old_y-mouse.hotspot_y);
mouse.visible:=false;
mouse.old_x:=mouse.x;
mouse.old_y:=mouse.y;
mouse.busy:=false;
end;

procedure MouseShow;
begin
if not mouse_driver_installed then Exit;
if mouse.visible=true then Exit;
mouse.busy:=true;

{GetClippedSprite}mouse.getcursor(mouse.workplace,mouse.background,mouse.x-mouse.hotspot_x,mouse.y-mouse.hotspot_y);
{PutClippedHCSprite}mouse.putcursor(mouse.workplace,mouse.cursor,mouse.x-mouse.hotspot_x,mouse.y-mouse.hotspot_y,mouse.cursor.transcol);
mouse.visible:=true;
mouse.old_x:=mouse.x;
mouse.old_y:=mouse.y;
mouse.busy:=false;
end;

Procedure MouseSetPosition(x,y:longint);
var r:trealregs;
begin
r.ecx:=x*8;
r.edx:=y*8;
r.eax:=4;
RealIntr(MouseInt,r);
MouseGetPosition;
end;

Procedure MouseGetPosition;
var r:trealregs;
begin
r.eax:=3;
RealIntr(MouseInt,r);
Mouse_blackwork(r,false);
end;

Procedure MouseWatch;
var r:trealregs;
begin
r.eax:=3;
RealIntr(MouseInt,r);
Mouse_blackwork(r,true);
end;


Function MouseMoved:boolean;
begin
MouseMoved:=(mouse.dx<>0) or (mouse.dy<>0);
end;


Function MousePressed:boolean;
begin
MousePressed:=mouse.b<>0;
end;


Procedure MouseArea(x1,y1,x2,y2:longint);
var r:trealregs;
begin
r.eax:=7;r.ecx:=x1*8;r.edx:=x2*8;RealIntr(MouseInt,r);
r.eax:=8;r.ecx:=y1*8;r.edx:=y2*8;RealIntr(MouseInt,r);
end;

Procedure MouseSpeed(x,y:longint);
var r:trealregs;
begin
r.eax:=$0f;
r.ecx:=x;
r.edx:=y;
RealIntr(MouseInt,r);
end;

Procedure MouseWheelRange(i:longint);
begin
mouse.wheelrange:=i;
end;


Function MouseInArea(mdata:mouse_record;x1,y1,x2,y2:longint):boolean;
begin
if mouse_driver_installed
   then MouseInArea:=(mdata.x>=x1) and (mdata.y>=y1) and (mdata.x<=x2) and (mdata.y<=y2)
   else MouseInArea:=false;
end;


Function MouseInArea(x1,y1,x2,y2:longint):boolean;
begin
MouseInArea:=MouseInArea(mouse,x1,y1,x2,y2);
end;


Procedure MouseRel;
begin
if mouse_driver_installed then while mouse.b<>0 do;
end;

Function Mouse_L:boolean;
begin Mouse_L:=(mouse.b and M_left)<>0;end;

Function Mouse_R:boolean;
begin Mouse_R:=(mouse.b and M_right)<>0;end;

Procedure MouseLock;
begin
mouse.locked:=true;
end;

Procedure MouseUnlock;
begin
mouse.locked:=false;
end;

Procedure MouseSelfCopy(v:virtualwindow;vpozx,vpozy:longint);
begin
GetClippedSprite(v,mouse.background,mouse.x-mouse.hotspot_x-vpozx,mouse.y-mouse.hotspot_y-vpozy);
PutClippedHCSprite(v,mouse.cursor,mouse.x-mouse.hotspot_x-vpozx,mouse.y-mouse.hotspot_y-vpozy,mouse.cursor.transcol);
end;


Procedure MouseBackup(var backup:mouse_record);
begin
move(mouse,backup,sizeof(mouse));
end;


Procedure VynulujMys;
begin
mouse_driver_installed:=false;
with mouse do
   begin
   last_lpx:=-1;
   last_lpy:=-1;
   last_lrx:=-1;
   last_lry:=-1;
   last_rpx:=-1;
   last_rpy:=-1;
   last_rrx:=-1;
   last_rry:=-1;
   numbuttons:=0;
   _wdif:=0;
   x:=0;
   y:=0;
   b:=0;
   end;
mouse.busy:=false;
mouse.busy2:=false;
end;


{===========================================================================}
{===========================================================================}
Procedure EndPoint_code_lock;
{Tato procedura nedela nic, ale pouziju ji jako konec zamknute oblasti
 pameti, tak aby spravne fungoval handler mysi}
begin
end;
{===========================================================================}


Procedure PripravStdUkazateleMysi;
{Propravi ukazatele mysi, ktere budou vzdy k dispozici}
begin
if _mousedef.VWoffset<>0 then Exit; {kdyz uz pripraveno je, tak nedelej znova}
{MOUSEDEF - standardni kurzor ve tvaru sipky}
Init_VW(_mousedef,DEFAULT_POINTER_WIDTH,DEFAULT_POINTER_HEIGHT,false);
Freemem(Pointer(_mousedef.VWOffset),_mousedef.Size);
{alokovany buffer muzu zrusit}
_mousedef.VWoffset:=longint(@DEFAULT_POINTER);
{protoze misto nej pouziju staticku buffer ze soubotu VENOMCUR.INC}
_mousedef.TransCol:=63488;
_mousedef.position:=_mousedef.breite+1; {bod (1,1)}
Make_RLEmap(_mousedef,_mousedef.TransCol);
Lock_VW(_mousedef);

{MOUSECLK - kurzor ve tvaru presypacich hodin}
Init_VW(_mouseclk,CLOCK_POINTER_WIDTH,CLOCK_POINTER_HEIGHT,false);
Freemem(Pointer(_mouseclk.VWOffset),_mouseclk.Size);
{alokovany buffer muzu zrusit}
_mouseclk.VWoffset:=longint(@CLOCK_POINTER);
{protoze misto nej pouziju staticku buffer ze soubotu VENOMCUR.INC}
_mouseclk.TransCol:=63488;
_mouseclk.position:=_mouseclk.breite+1; {bod (1,1)}
Make_RLEmap(_mouseclk,_mouseclk.TransCol);
Lock_VW(_mouseclk);


{MOUSEHND - kurzor ve tvaru ruky s natazenymi prsty}
Init_VW(_mousehnd,HAND_POINTER_WIDTH,HAND_POINTER_HEIGHT,false);
Freemem(Pointer(_mousehnd.VWOffset),_mousehnd.Size);
{alokovany buffer muzu zrusit}
_mousehnd.VWoffset:=longint(@HAND_POINTER);
{protoze misto nej pouziju staticku buffer ze soubotu VENOMCUR.INC}
_mousehnd.TransCol:=63488;
_mousehnd.position:=_mousehnd.breite+4; {bod (4,1)}
Make_RLEmap(_mousehnd,_mousehnd.TransCol);
Lock_VW(_mousehnd);
end;

function Init_mouse(var where:virtualwindow;cursor:pvirtualwindow;handler:boolean):boolean;
var r : trealregs;
begin
r.eax :=0;
realintr(mouseint, r);  {inicializace mysi}
if (r.eax <> $FFFF) then
   begin
   ToText;
   Writeln(mouse_not_installed_message);
   halt(0);
   end;

mouse.numbuttons := r.bx;
mouse.has_wheel:=false;
r.eax:=$11;realintr(mouseint, r);
if r.ax=$574d then
   if odd(r.cx) then
      begin
      mouse.has_wheel:=true;
      MouseWheelRange(1000);
      mouse.W:=0;
      end;

r.eax:=2;realintr(mouseint, r); { Pro zacatek vypnu mys }

mouse.x:=where.breite div 2;
mouse.y:=where.hoehe div 2;
MouseArea(0,0,where.breiteminus1,where.hoeheminus1);
r.eax:=4;r.ecx:=mouse.x*8;r.edx:=mouse.y*8;  { Nastavim polohu mysi }
realintr(mouseint, r);
PripravStdUkazateleMysi;
MouseSpeed(2,2);
mouse_driver_installed:=true;  {Je instalovana obsluha mysi}
mouse.visible:=false;          {(nemusi to ale nutne znamenat, ze i handler)}
mouse.last_lpx:=mouse.x;
mouse.last_lpy:=mouse.y;
mouse.last_lrx:=mouse.x;
mouse.last_lry:=mouse.y;
mouse.last_lp_time:=FromTimer;
mouse.last_rpx:=mouse.x;
mouse.last_rpy:=mouse.y;
mouse.last_rrx:=mouse.x;
mouse.last_rry:=mouse.y;
mouse.last_rp_time:=FromTimer;
mouse.workplace:=where;
mouse.hotspot_x:=0;
mouse.hotspot_y:=0;
mouse.locked:=false;
mouse.callback_routine:=@MouseDraw; {kreslici rutina pro handler}
mouse.cursor.vwoffset:=0; {znamena to, ze jeste neni inicializovan}
mouse.busy:=false;
mouse.busy2:=false;

MouseSetCursor(cursor);
if where.segment = dosmemselector then
   begin
   mouse.putcursor:=@BankPutClippedHCsprite;
   mouse.delcursor:=@BankPutClippedSprite;
   mouse.getcursor:=@BankGetClippedSprite;
   end
   else begin
   mouse.putcursor:=@PutClippedHCsprite;
   mouse.delcursor:=@PutClippedSprite;
   mouse.getcursor:=@GetClippedSprite;
   end;

lock_code(@StartPoint_code_lock,
          longint(@EndPoint_code_lock)-longint(@StartPoint_code_lock));
{oblast pameti potencialne ovlivnitelnou handlerem uzamknu pred swapovanim}

{jeste uzamknu datove oblasti}


lock_data(locked_interface_data_start,
         longint(@locked_interface_data_end)-longint(@locked_interface_data_start));

lock_data(locked_implementation_data_start,
         longint(@locked_implementation_data_end)-longint(@locked_implementation_data_start));


lock_data(mouse_regs, sizeof(mouse_regs));
lock_data(mouse_seginfo, sizeof(mouse_seginfo));
lock_data(dosmemselector, sizeof(dosmemselector));

if handler then
   begin
   MouseHandlerInstalled:=true; {Handler je instalovan}
   get_rm_callback(@mouse_callback_handler, mouse_regs, mouse_seginfo);
   r.eax := $0c;
   if mouse.has_wheel then r.ecx:=$7f+128 else r.ecx := $7f;
   r.es := mouse_seginfo.segment;
   r.edx := longint(mouse_seginfo.offset);
   realintr(mouseint, r);
   end;
end;


function Init_mouse(var where:virtualwindow;cursor:pvirtualwindow):boolean;
begin
Init_mouse:=Init_Mouse(where,cursor,true);
end;


function Init_mouse(var where:virtualwindow):boolean;
begin
Init_mouse:=Init_Mouse(where,MOUSEDEF,true);
end;


procedure Kill_mouse;
var r : trealregs;
begin
if not mouse_driver_installed then Exit;
MouseSpeed(8,8);     {vrati citlivost mysi na beznou uroven}
r.eax:=2;RealIntr(MouseInt,r);
DestroyMouseCursor;
Kill_VW(mouse.background);

if MouseHandlerInstalled then
   begin
   r.eax:=$0c;r.ecx:=0;r.edx:=0;RealIntr(mouseint,r);
   end;

unlock_code(@StartPoint_code_lock,
          longint(@EndPoint_code_lock)-longint(@StartPoint_code_lock));
{oblast pameti potencialne ovlivnitelnou handlerem uzamknu pred swapovanim}

{jeste uzamknu datove oblasti}

unlock_data(locked_interface_data_start,
         longint(@locked_interface_data_end)-longint(@locked_interface_data_start));

unlock_data(locked_implementation_data_start,
         longint(@locked_implementation_data_end)-longint(@locked_implementation_data_start));

unlock_data(mouse_regs, sizeof(mouse_regs));
unlock_data(mouse_seginfo, sizeof(mouse_seginfo));
unlock_data(dosmemselector, sizeof(dosmemselector));


MouseHandlerInstalled:=false;
mouse_driver_installed:=false;
end;


Procedure Triangle(var dest:virtualwindow;x1,y1,x2,y2,x3,y3:longint;color:word);
begin
LineClipped(dest,x1,y1,x2,y2,color);
LineClipped(dest,x2,y2,x3,y3,color);
LineClipped(dest,x1,y1,x3,y3,color);
end;

Procedure FilledTriangle(var dest:virtualwindow;x1,y1,x2,y2,x3,y3:longint;color:word);
{}Procedure xchange(var a,b:longint);
{}begin a:=a xor b;b:=a xor b;a:=a xor b;end;

var ymin,xmin,ymid,xmid,ymax,xmax,xmid2,i:longint;
    xn,yn,xn2,yd,im:longint;
Begin
{srovnani vrcholu podle souradnice y:}
if y1>y2 then begin xchange(y1,y2); xchange(x1,x2); end;
if y1>y3 then begin xchange(y1,y3); xchange(x1,x3); end;
if y2>y3 then begin xchange(y2,y3); xchange(x2,x3); end;
ymin:=y1; xmin:=x1; ymid:=y2; xmid:=x2; ymax:=y3; xmax:=x3;
{kdyz jsou vsechny body stejne vysoko, je to vodorovna cara a ne trojuhelnik:}
if ymax=ymin then begin
                  {nalezeni xove souradnice nejvic vlevo a nejvic vpravo:}
                  if x1>x2 then xchange(x1,x2);
                  if x1>x3 then xchange(x1,x3);
                  if x2>x3 then xchange(x2,x3);
                  LineHorz(dest,x1,x3,y1,color);
                  exit;
                  end;
{vrcholy jsou primo pod sebou - je to svisla cara:}
if (x1=x2)and(x2=x3) then begin
                          LineVert(dest,x1,y1,y2,color);
                          exit;
                          end;
xmid2:=(xmax-xmin)*(ymid-ymin)div(ymax-ymin)+xmin;
   {bod na care, ktera jde od nejhorejsiho vrcholu k nejdolejsimu, naproti prostrednimu vrcholu}
if xmid2<xmid then xchange(xmid2,xmid);

if ymin<>ymid then
   begin
   xn:=xmid-xmin;
   yn:=ymid-ymin;
   xn2:=xmid2-xmin;
   im:=0;
   for i:=ymin to ymid do
      begin
      LineHorz(dest,xn*im div yn+xmin,xn2*im div yn+xmin,i,color);
      inc(im);
      end;
   end;

if ymid<>ymax then
   begin
   xn:=xmax-xmid;
   yn:=ymax-ymid;
   xn2:=xmax-xmid2;
   im:=0;
   for i:=ymid to ymax do
      begin
      LineHorz(dest,xn*im div yn+xmid,xn2*im div yn+xmid2,i,color);
      inc(im);
      end;
   end;
End;


Procedure Init_Poly(var poly:PolyType;s:string);
var a,b,c:byte;
    n:boolean;
    i,j:longint;
    t:string;
begin
b:=0;
s:=s+',';
for a:=1 to Length(s) do if s[a]=',' then inc(b);
poly.num:=b div 2;
GetMem(poly.point,(poly.num+1)*8);

b:=0;
c:=1;
n:=false;
for a:=1 to Length(s) do
    begin
    if s[a]=',' then
       begin
       n:=not n;
       t:=Copy(s,c,a-c);
       c:=a+1;
       Val(t,i,j);
       if N then
          begin
          inc(b);
          poly.point^[b].x:=i;
          end else poly.point^[b].y:=i;
       end;
    end;
poly.point^[0]:=poly.point^[b];
end;

Procedure Polygon(var dest:virtualwindow;p:PolyType;color:word);
var i:longint;
begin
for i:=p.num downto 1 do
    LineClipped(dest,p.point^[i].x,p.point^[i].y,
                       p.point^[i-1].x,p.point^[i-1].y,color);

end;


Procedure Polygon(var dest:virtualwindow;p:PolyType;t:byte;mask,color:word);
var i:longint;
begin
for i:=p.num downto 1 do
    LineThickWithMask(dest,p.point^[i].x,p.point^[i].y,
                       p.point^[i-1].x,p.point^[i-1].y,t,mask,3,color);

end;

{$INCLUDE venompol.inc}
Procedure FilledPolygon(var dest:virtualwindow;p:PolyType;t:byte;mask,color1,color2:word);
var pocet_hran, prvni_hrana, posledni_hrana,
    radek, nejnizsi_y, pocet_pruseciku : longint;
begin
poly_tg:=@dest;
poly_barva:=color2;
Uvodni_zpracovani_hranice (p, pocet_hran, nejnizsi_y);
prvni_hrana := 1;              {inicializace ukazatelu}
posledni_hrana := 1;           {do setrideneho seznamu}
for radek := poly_hranice^[1].y_horni downto nejnizsi_y do
    begin
    Aktualizuj_seznam_hran(pocet_hran,radek,prvni_hrana, posledni_hrana);
    Nalezni_pruseciky_x(radek, pocet_pruseciku,prvni_hrana, posledni_hrana);
    Kresli_useky(radek, pocet_pruseciku, prvni_hrana);
    Uprav_seznam_hran (prvni_hrana, posledni_hrana);
    end;
Zrus_seznam_hran(p);
if (t=0) or (mask=0) then Exit;
if (t=1) or (mask=$ffff) then Polygon(dest,p,t,mask,color1)
   else begin
   Polygon(dest,p,t,$ffff,color2);
   Polygon(dest,p,t,mask,color1);
   end;
end;

Procedure FilledPolygon(var dest:virtualwindow;p:PolyType;color1,color2:word);
begin
FilledPolygon(dest,p,1,$ffff,color1,color2);
end;


Procedure Kill_Poly(var poly:PolyType);
begin
FreeMem(poly.point);
end;

Procedure FillPush(x,y:longint);
begin
x:=y*10000+x;
inc(fstop);
fillstack^[fstop]:=x;
end;

Function FillPop(var x,y:longint):boolean;
var a:longint;
begin
if fstop=0 then Exit(false);
a:=fillstack^[fstop];
dec(fstop);
y:=a div 10000;
x:=a mod 10000;
FillPop:=true;
end;

Procedure Floodfill(dest:virtualwindow;x,y:longint;color:word);
var seed:word;
    y1:longint;
    spanleft,spanright:boolean;
begin
seed:=GetPixel(dest,x,y);
if seed=color then Exit;
New(fillstack);
fstop:=0;

fillpush(x,y);
while(fillpop(x, y)) do
   begin
   y1:=y;
   while (y1>=0) and (GetPixel(dest,x,y1) = seed) do dec(y1);
   inc(y1);
   spanleft:=false;
   spanright:=false;
   while (y1 < dest.hoehe) and (GetPixel(dest,x,y1) = seed) do
      begin
      PutPixel(dest,x,y1,color);
      if (spanleft=false) and (x>0) and (GetPixel(dest,x-1,y1)=seed) then
         begin
         fillpush(x-1,y1);
         spanleft:=true;
         end else
         if (spanleft=true) and (x>0) and (GetPixel(dest,x-1,y1)<>seed) then
            spanleft:=false;

      if (spanright=false) and (x<dest.breite) and (GetPixel(dest,x+1,y1)=seed) then
         begin
         fillpush(x+1,y1);
         spanright:=true;
         end else
         if (spanright=true) and (x<dest.breite) and (GetPixel(dest,x+1,y1)<>seed) then
            spanright:=false;
      inc(y1);
      end;
   end;
Dispose(fillstack);
end;


Procedure Floodfill(dest:virtualwindow;x,y:longint;color,border:word);
var y1:longint;
    spanleft,spanright,ok:boolean;
    w:word;
begin
w:=getpixel(dest,x,y);
if (w=color) or (w=border) then Exit;
New(fillstack);
fstop:=0;

fillpush(x,y);
while(fillpop(x, y)) do
   begin
   y1:=y;
   while (y1>=0) do
      begin
      w:=GetPixel(dest,x,y1);
      if (w=color) or (w=border) then Break;
      dec(y1);
      end;
   inc(y1);
   spanleft:=false;
   spanright:=false;
   while (y1 < dest.hoehe) do
      begin
      w:=GetPixel(dest,x,y1);
      if (w=color) or (w=border) then Break;

      PutPixel(dest,x,y1,color);

      w:=GetPixel(dest,x-1,y1);
      ok:=(w=color) or (w=border);

      if (spanleft=false) and (x>0) and (not ok) then
         begin
         fillpush(x-1,y1);
         spanleft:=true;
         end else
         if (spanleft=true) and (x>0) and (ok) then
            spanleft:=false;

      w:=GetPixel(dest,x+1,y1);
      ok:=(w=color) or (w=border);
      if (spanright=false) and (x<dest.breite) and (not ok) then
         begin
         fillpush(x+1,y1);
         spanright:=true;
         end else
         if (spanright=true) and (x<dest.breite) and (ok) then
            spanright:=false;
      inc(y1);
      end;
   end;
Dispose(fillstack);
end;


Procedure RoundWave(Src,dsst:VirtualWindow;x,y,z:real);
{src and dsst should have the same size. Nice results gives f.e.
RoundWave(v,w,40,77,38);}
type xarray = array[0..100000] of longint;
     parray = ^xarray;
var
  xx,yy,cx,cy,i,xxx: longint;
  sx,sy: parray;

begin
  GetMem(sy,Dsst.breite*4);
  GetMem(sx,Dsst.hoehe*4);
  for i:=0 to Dsst.hoeheminus1 do sx^[i]:=Round(Sin(i/x)*z);
  for i:=0 to Dsst.breiteminus1 do sy^[i]:=Round(Sin(i/y)*z);
  asm
  mov esi,sy
  lea edi,dsst

  mov edx,[edi+38]      {hoeheminus1}
  mov xxx,edx
  mov ecx,[edi+10]      {breite}

  mov ax,[edi+0]
  push gs
  mov gs,ax
  mov edi,[edi+2]            {VWoffset}
  xor edx,edx

     @radky:
     push ecx
     mov esi,sx
     mov ebx,[esi+edx*4]       {EBX=xx}

        @sloupce:
        mov esi,sy
        mov eax,[esi+ecx*4]
        add eax,edx          {EAX=yy}
        lea esi,src
        cmp ebx,0;jl @preskoc
        cmp ebx,[esi+10];jge @preskoc
        cmp eax,0;jl @preskoc
        cmp eax,[esi+30];jge @preskoc

        push edx
        mov edx,[esi+26]       {Bytebreite}

        imul eax,edx
        add eax,ebx;add eax,ebx
        mov dx,[esi+0]
        push es
        mov es,dx
        mov esi,[esi+2]
        add esi,eax
        mov ax,es:[esi]
        mov gs:[edi],ax
        pop es
        pop edx

        @preskoc:
        add edi,2
        inc ebx
        dec ecx
        jnz @sloupce
     pop ecx
     inc edx
     cmp edx,xxx
     jng @radky
  pop gs
  end;
FreeMem(sy);
FreeMem(sx);
end;


procedure SquareWave(Src,Dst:Virtualwindow;x,y,z:real);
{src and dsst should have the same size. Nice results gives f.e.
SquareWave(v,v2,80,17,11)   or    SquareWave(v,v2,6,87,18)}
type xarray = array[0..100000] of longint;
     parray = ^xarray;
var
  xxx,yyy,i:longint;
  sx,sy: Parray;
begin
  GetMem(sx,Dst.breite shl 2);
  GetMem(sy,Dst.hoehe shl 2);
  for i:=0 to Dst.breiteminus1 do sx^[i]:=Round(Sin(i/x)*z);
  for i:=0 to Dst.hoeheminus1 do sy^[i]:=Round(Sin(i/y)*z);

asm
  lea edi,dst

  mov edx,[edi+38]      {hoeheminus1}
  mov xxx,edx
  mov ecx,[edi+10]      {breite}

  mov yyy,ecx

  mov ax,[edi+0]
  push gs
  mov gs,ax
  mov edi,[edi+2]            {VWoffset}

  lea esi,src
  mov ax,[esi+0]
  push es
  mov es,ax

  xor edx,edx
@radky:
  mov esi,sy
  mov ebx,[esi+edx*4]       {EBX=yy}
  add ebx,edx

  cmp ebx,0
  jl @preskoc
  lea esi,src
  cmp ebx,[esi+30]      {hoehe}
  jl @ok

  add edi,yyy
  add edi,yyy
  jge @preskoc
@ok:

  imul ebx,[esi+26]
  add ebx,[esi+2]

  xor ecx,ecx
@sloupce:
  mov esi,sx
  mov eax,[esi+ecx*4]
  add eax,ecx               {EAX=XX}

  cmp eax,0
  jl @preskocbod
  cmp eax,yyy
  jge @preskocbod

  push ebx
  shl eax,1
  add ebx,eax

  mov eax,es:[ebx]
  mov gs:[edi],eax
  pop ebx

@preskocbod:
  add edi,2
  inc ecx
  cmp ecx,yyy
  jne @sloupce

@preskoc:
  inc edx
  cmp edx,xxx
  jng @radky

pop es
pop gs
end;

FreeMem(sy);
FreeMem(sx);
end;

{----------------------------------------------------------------------------}
{Procedures and functions around VGA char generator}
Procedure VGAfont_2_FN(vyska:byte;kam:PVGACharset);
{Stahne jeden font z VGA do pameti}
var b:Byte;
begin
Disable;    {asm CLI}
OutPortW($3c4,$0402);
OutPortW($3c4,$0704);
OutPortW($3ce,$0204);
OutPortW($3ce,$0005);
OutPortW($3ce,$0006);
For b := 0 to 255 do dosmemget(SegA000,b*32,kam^[b,1],vyska);
OutPortW($3c4,$0302);
OutPortW($3c4,$0304);
OutPortW($3ce,$0004);
OutPortW($3ce,$1005);
OutPortW($3ce,$0e06);
Enable;     {asm STI}
end;





Procedure VGA_2_FN;
{Postupne stahne vsechny VGA fonty do pameti}
begin
asm mov ax,1102h;mov bl,0;int 10h;end;      {8x8}
VGAfont_2_FN(8,@rawvga8);
asm mov ax,3;int 10h;end;
asm mov ax,1101h;mov bl,0;int 10h;end;      {8x14}
VGAfont_2_FN(14,@rawvga14);
asm mov ax,3;int 10h;end;
asm mov ax,1104h;mov bl,0;int 10h;end;      {8x16}
VGAfont_2_FN(16,@rawvga16);
asm mov ax,3;int 10h;end;

{Ted mame stazeno z hardware do bloku pameti. Zacneme s "ucesanim"}

vga8charset.init(8);         {trvale ulozeni VGA8}
vga14charset.init(14);       {trvale ulozeni VGA14}
vga16charset.init(16);       {trvale ulozeni VGA16}

Pridej_9_bit(@rawvga8, @vga8charset, 8);
Pridej_9_bit(@rawvga14, @vga14charset, 14);
Pridej_9_bit(@rawvga16, @vga16charset, 16);
end;



Procedure VGA_charset_OutText(kam:pointer;x,y:longint;s:string;fnt:pointer;color:word);
var i,ox:longint;
    c:char;
    cr:boolean;
    virt:PVirtualWindow;
    ac:PZnaky256;
    z:PZnak;

begin
ox:=x;
cr:=false;
virt:=kam;
ac:=ActualCharset;
for i:=1 to Length(s) do
    begin
    c:=s[i];
    if c=#13 then
       begin
       x:=ox;
       inc(y,ac^.vel);
       cr:=true;
       end
       else
    if (c=#10) and (cr=true) then cr:=false
       else
       begin
       z:=ac^.PrepChar(byte(c));
       PutChar_FN(virt^,
                  z^.data,
                  x,y,
                  z^.sirka,
                  z^.vyska,
                  z^.dp,
                  color);

       inc(x,z^.shift);
       {Zkousel jsem i "sirka+1", ale "sirka+2" vypada asi o neco lepe.}
       cr:=false;
       end;
    end;
end;


Function VGA_charset_prepchar(fnt:pointer;znak:word):pointer;
var ac:PZnaky256;
begin
ac:=ActualCharset;
VGA_charset_prepchar:=@ac^.znaky256[byte(znak)];
end;


Function VGA_charset_GetInfo(fnt:pointer;param:longint):longint;
begin
case param of
1:{velikost}
  VGA_charset_GetInfo:=ActualCharsetHigh;

else VGA_charset_GetInfo:=0;
end; {case}
end;


Procedure Priprav_VGA_proporcni(size,flags:byte);
var prop_vga:PZnaky256;
begin
if size<9 then size:=8 else
   if size>15 then size:=16 else size:=14;

case size of
   8:begin
     if prop_vga_8=nil then
        begin
        prop_vga_8:=New(PZnaky256,Init(8));
        Preved_Font_na_proporcni(prop_vga_8,@vga8charset,size);
        end;
     ActualCharset:=prop_vga_8;
     end;

  14:begin
     if prop_vga_14=nil then
        begin
        prop_vga_14:=New(PZnaky256,Init(14));
        Preved_Font_na_proporcni(prop_vga_14,@vga14charset,size);
        end;
     ActualCharset:=prop_vga_14;
     end;

  16:begin
     if prop_vga_16=nil then
        begin
        prop_vga_16:=New(PZnaky256,Init(16));
        Preved_Font_na_proporcni(prop_vga_16,@vga16charset,size);
        end;
     ActualCharset:=prop_vga_16;
     end;
end; {case}


ActualCharsetProp:=true;
end;


Procedure VGA_charset_SetStyle(fnt:pointer;size,flags:byte);
begin
if (flags and prop_fn)<>0 then Priprav_VGA_proporcni(size,flags)
   else begin
   if size<9 then begin ActualCharset:=@vga8charset;ActualCharsethigh:=8;end else
      if size>15 then begin ActualCharset:=@vga16charset;ActualCharsethigh:=16;end else
      begin ActualCharset:=@vga14charset;ActualCharsethigh:=14;end;
   ActualCharsetProp:=false;
   end;
end;


Function Load_VGA_charset(s:string;size:byte):pointer;
begin
VGA_charset_SetStyle(nil,16,0);
Load_VGA_charset:=ActualCharset;
end;


Procedure VGA_charset_delete(fnt:pointer);
begin
{Pahyl - VGA font nelze odstranit}
end;


Procedure Register_VGA_chargen_Loader;
begin
is_vga_from_charset_prepared:=false;
Vga_2_FN;
RegisterFontEngine('   '{znacka pro znakovy generator VGA},
                   @Load_VGA_charset,
                   @VGA_charset_prepchar,
                   @VGA_charset_OutText,
                   @VGA_charset_setstyle,
                   @VGA_charset_GetInfo,
                   @VGA_charset_delete);
SetFontStyle('vga',16);

{a ted poznacim, ze zatim jeste nemame vytvorene proporcionalni varianty}
prop_vga_8:=nil;
prop_vga_14:=nil;
prop_vga_16:=nil;
ActualCharsetProp:=false;
end;


Procedure SetFontStyle(rez:string;velikost,flags:byte);
begin
Venom_mng_SetFontStyle(rez,velikost,flags);
end;


Procedure SetFontStyle(rez:string;velikost:byte);
begin
Venom_mng_SetFontStyle(rez,velikost,0);
end;


Procedure OutText(var virt:Virtualwindow;x,y:longint;s:string;color:word);
begin
Venom_mng_outstring(@virt,x,y,s,color);
end;


Function GetTextSize:byte;
begin
GetTextSize:=Venom_mng_getfontinfo(1);
end;


Function Get_Pointer_To_Downloaded_VGA_fonts(size:byte):pointer;
{For internal use in addon units. POINTER is in the fact the PZnaky256 object
 as defined in VNMFNHLP unit. The font is unproporcional}
begin
if size=16 then Exit(@vga16charset) else
if size=14 then Exit(@vga14charset) else Exit(@vga8charset)
end;


Procedure Kill_Font(font:string);
begin
Venom_mngr_kill_font(font);
end;


Procedure Clear_Graphics_variables;
begin
bank_internal.bank_rd:=UNDEFINED_BANK;
bank_internal.bank_wr:=UNDEFINED_BANK;
bank_internal.internal32_0:=$ffff;
bank_internal.internal32_1:=$ffff;

MouseHandlerInstalled:= false;
timer_installed:=false;
CRTCinfoBlock.RefreshRate:=0;
VynulujMys;
SetLFBmodeVariables;  {defaultne nastavim proceduralni promenne na LFB verze}
Init_VW(fontvw,400,400,true); {pripravi renderovaci policko pro fonty}
font_last_bitmap:=nil;
Texture:=nil;
end;

{----------------------------------------------------------------------------}

(******************************** INIT UNIT *********************************)
var w1:real;
    loop1:longint;
BEGIN
GET_CPU;
GET_SVGA;

VESA_vendor:='';
VESA_productname:='';
VESA_vendorname:='';
{$IFDEF RELEASE}
SetProtectmodeInterface;
{$ENDIF}
_mousedef.VWoffset:=0;
_mouseclk.VWoffset:=0;
_mousehnd.VWoffset:=0;
MOUSEDEF:=@_mousedef; {priradim ukazatele}
MOUSECLK:=@_mouseclk; {statickym strukturam}
MOUSEHND:=@_mousehnd; {jde o kurzory mysi}
Clear_Graphics_variables;
W1:= 0;
ArcCall.ellipsescan:=@EllipseScan;

For Loop1:= 0 to 720 do
    begin
    Sinus[Loop1]:= Sin(W1);
    CoSin[Loop1]:= Cos(W1);
    W1     := W1 + (Pi / 180);
    end;

ToText;
InitAdaptedPalete;
ReadVESAbaseInfos;

Register_BMP_Loader;
Register_VGA_chargen_Loader;
if Get_windows_version=0 then CheckSpecificCards;
{pouziva informace vracene funkci ReadVESAbaseinfos}
Get_DDC_Info;
END.
