-- crc32old.e - CRC-32 for Euphoria - 'clean' version 1.32
-- Copyright (C) 2002  Davi Tassinari de Figueiredo
--
-- If you wish to contact me, send an e-mail to davitf@eml.cc .
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/
--
--
-- License terms and disclaimer:
--
-- Permission is granted to anyone to use this software for any purpose,
-- including commercial applications, and to alter it and redistribute it
-- freely, subject to the following restrictions:
--
-- 1. The origin of this software must not be misrepresented; you must not
--    claim that you wrote the original software or remove the original
--    authors' names.
-- 2. Altered source versions must be plainly marked as such, and must not
--    be misrepresented as being the original software.
-- 3. All source distributions, with or without modifications, must be
--    distributed under this license. You may also opt to distribute the
--    software under the GNU General Public License, version 2 or (at your
--    option) any later version, in which case you should replace this
--    notice with an appropriate one. If this software's source code is
--    distributed as part of a larger product, this item does not apply to
--    the rest of the product.
-- 4. If you use this software in a product, an acknowledgment in the
--    product documentation is required. If the source code for the product
--    is not freely distributed, you must include information on how to
--    freely obtain the original software's source code.
--
-- This software is provided 'as-is', without any express or implied
-- warranty.  In no event will the authors be held liable for any damages
-- arising from the use of this software.
--
-- If you want to distribute this software in a way not allowed by this
-- license, or distribute the source under different license terms, contact
-- the authors for permission.


include machine.e

constant poly=#EDB88320

function make_crc_table()
    -- Compute CRC table

    atom c
    sequence table
    table=repeat(0,256)

    -- Calculate table value for each character

    for n=0 to 255 do   -- For each char do
	c=n
	for k=0 to 7 do -- For each bit do
	    if and_bits(c,1) then   -- Xor only if least-significant bit is 1
		c=xor_bits(poly,floor(c/2))
		if c<0 then c=c+#100000000 end if
	    else
		c=floor(c/2)
	    end if
	end for

	-- Convert number into bytes
	table[n+1]=int_to_bytes(c)
    end for

    return table
end function

global constant crc_table=make_crc_table() -- Compute table

sequence crc

global procedure init_crc()
    -- Set initial CRC
    crc = {#FF, #FF, #FF, #FF}
end procedure

global procedure update_crc(sequence buf)
    -- Update CRC
    for n=1 to length(buf) do
	crc=xor_bits(crc_table[xor_bits(crc[1],buf[n])+1],crc[2..4]&0)
    end for

end procedure

global function get_crc()
    -- Retrieve CRC
    return xor_bits( crc, #FF)
end function

global function crc32(sequence buf)
    -- Calculate the CRC for a string
    -- Does not interfere with the CRC for the routines above.
    sequence crc
    crc={#FF,#FF,#FF,#FF}

    for n=1 to length(buf) do
	crc=xor_bits(crc_table[xor_bits(crc[1],buf[n])+1],crc[2..4]&0)
    end for

    return xor_bits(#FF,crc)

end function

