        PAGE    60,120
	TITLE   TOPSPIN rev 3.0
;!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*
;	assemble with MASM:
;		MASM TOPSPIN.ASM
;       link with:
;               LINK TOPSPIN/CP:1,,,,
;       This will allocate minimum memory necessary for program to run.
;		EXEPACK TOPSPIN.EXE TS.EXE
;		DEL TOPSPIN.EXE
;	Using the /E option on the 3.60 linker causes the memory allocation to
;	bomb, this is the reason for using exepack.
;
;!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*
;  Copyright (C) 1987,1988,1989,2000 Robert Canup.
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or (at
; your option) any later version.
; 
; This program is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;******************************************************************************
;*
;*      TOPSPIN:
;*              A menu system for IBM PC-XT-AT's and compatible
;*      computers running PC-DOS, or MS-DOS V 2.0 or greater.
;*      This system includes built in batch streams which will supply
;*      characters to any well behaved DOS program. (i.e. any program
;*      which does not go directly to the hardware of the computer.
;*      FEATURES:
;*              1.) Function keys may be used as menu selection along with
;*                  number keys, and letters.
;*              2.) Lower case leters are converted to uppercase as required.
;*              3.) Stacking of menus allowed.
;*              4.) Comment fields allowed.
;*		5.) Exit from the program by means of the ESC key.
;*              6.) Resident program which steals keyboard interupt to supply
;*                  characters to any well behaved DOS program. (i.e. any
;*                  program which does not go directly to the hardware of the
;*                  computer.)
;*              7.) PROMPT, GET, and PUT facilities built into the program
;*                  to allow the program to ask, store, and retrieve
;*                  parameters for the menu sytem.
;*
;*
;*      REVISION NUMBER:
;*		3.0	6/5/2000 GPL version
;*		2.5	9/12/89 Corrected overwrite of comspec
;*		2.4	6/30/89 Corrected .dta name problem
;*		2.3	6/23/89 /e/b no escape, bell toggled off
;*		2.2	6/22/89 Scan code alt keys supported 
;*		2.1	6/18/89 Menu buffer reduced to 8 k tabs enabled
;*		2.0	6/11/89 Commercial version, no btrieve.
;*		1.28b	3/16/88 Fixed empty command line problem
;*		1.27b	3/14/88 Fixed A-Z, a-z problems.
;*		1.26b	3/11/88 Black Belt Software version.
;*		1.26	9/03/87 Captilization of menu name fixed
;*		1.25	9/03/87 Tilde fix
;*		1.24	9/02/87 Production version 
;*		1.23	8/31/87 Documentation changes
;*		1.22	8/31/87 Changed size of parameters to fit in 512 bytes
;*		1.21	8/30/87 Bug fixes on Lan version
;*		1.20	8/26/87 Lan version of program, name change
;*		1.19	8/25/87 Search whole environment area for COMSPEC=
;*		1.18	8/25/87 Search environment strings for COMSPEC=
;*		1.17	8/24/87 Incorporate abort for runstream
;*		1.16	8/24/87 Search \menu dir for menu
;*		1.15	8/24/87 CLS on ESC exit
;*		1.14	8/20/87 Error msgs included.
;*		1.13	8/20/87 Bug fixes.
;*		1.12	8/20/87 Multiple parm editing implemented.
;*		1.11	8/16/87 Bios clear screen implemented.
;*		1.1	8/16/87 Beta test version.
;*              1.0     7/25/87 Standard features inplemented.
;*
;******************************************************************************


GROPE	GROUP	DSEG,CSEG


PSP     SEGMENT AT 0

        ORG     2CH
ENVIRONMENT_STRING LABEL WORD
        ORG     5CH
FCB1    LABEL   BYTE
        ORG     6CH
FCB2    LABEL   BYTE
        ORG     80H
COMMAND_LINE    LABEL   BYTE

PSP     ENDS

DSEG    SEGMENT 'DATA'

parameter_block dw      0
                dw      OFFSET CLINE,DSEG
                dw      OFFSET FCB1,0
                dw      OFFSET FCB2,0
exp_count	db	0
data_buffer	db	100 DUP (0)		; This is our data buffer
pos_table	db	90 DUP (0)		; Set aside a position table
esc_flag	db	0ffh			; esc normaly allowed
bell_flag	db	0			; bell normaly off
status		dw	0			; return status
menu_nm		db	'\MENU',0		; name of menu directory
dta_nam		db	'\MENU\'		; name of current data file
		db	13 DUP (?)		; 
dta_handle	dw	0			; 
mkdir		equ	39h			; DOS make a directory command
create_file	equ	3ch			; DOS create a file command
read_bytes	equ	3fh			; DOS read bytes command
open_file	equ	3dh			; DOS open file command
close_file	equ	3eh			; DOS close file command
move_ptr	equ	42h			; DOS move file ptr command
write_bytes	equ	40h			; DOS write bytes command
paged_size	equ	512			; page size to use
extentz		db	'.MNU',0		; extent to add to menu name
filename        db      '/COMMAND.COM',0
		db	64 DUP(0)
cline           db      129 DUP(0)
clear_line      db      8,' /C CLS',0dh
test_code       db      'dir',0dh,'cls',0dh,'exit',0dh
counter         db      13
pointer         dw      OFFSET test_code
panic_flag      db      0                       ; control break prssd flg
old_terminate   dd      0                       ; addr of old term vector
old_cntrl_brk   dd      0                       ; addr of old cn brk vectr
old_isr         dd      0                       ; address of old int sv rt
com_line        db      128 dup(0)              ; storage for command line
comspec		db	'COMSPEC='		; target search string
runstream_active db     0                       ; active runstream flag
temp    dw      0                               ; temporary gp st loc
stack_sav       dd      0                       ; stack storage loc
trans_table	db	3,30,48,46,32,18,33,34,35,23,36,37,38,28,49,24
		db	25,16,19,31,20,22,47,17,45,21,44,1,43,27,7,12,57
		db	2,41,4,5,6,8,41,10,11,9,13,51,12,52,53
		db	11,2,3,4,5,6,7,8,9,10,39,39,51,13,52,53
		db	3,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
		db	25,16,19,31,20,22,47,17,45,21,44
		db	26,43,27,7,12
		db	41,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
		db	25,16,19,31,20,22,47,17,45,21,44
		db	26,43,27,41,83		
		db	3,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
		db	25,16,19,31,20,22,47,17,45,21,44,1,43,27,7,12,57
		db	2,41,4,5,6,8,41,10,11,9,13,51,12,52,53
		db	11,2,3,4,5,6,7,8,9,10,39,39,51,13,52,53
		db	3,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
		db	25,16,19,31,20,22,47,17,45,21,44
		db	26,43,27,7,12
		db	41,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
		db	25,16,19,31,20,22,47,17,45,21,44
		db	26,43,27,41,83		
menu_handle	dw	0
menu_buffer     db      8192 DUP(0)             ; buffer for menu
dummy_cr	db	cr			; dummy cr at end of buffer
buffer_size     equ     $-OFFSET menu_buffer    ; dynamic size of potential bfr
file_size       dw      0                       ; size of file actualy read
print_pointer   dw      0                       ; pointer to char to print
print_count     dw      0                       ; number of char left to print
new_line_flag   db      0                       ; at start of new line in prnt
temp_str	db	128 DUP(0)		; storage location for com lin
len_bufff	equ	504			; length of buffer
strng_len	equ	48			; length of indiv strings
save_buffer	db	len_bufff DUP(0)	; duplicate of menu_nam buffer
menu_nam	db	12 DUP(0)		; menu name.ext
novell_num	db	12 DUP(0)		; 12 digit Novell number
g_string	db	46			;
get_string      db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)               ; space for string from get
		db	46			;
		db      47 DUP(0)		; space for string from get
		db	46			;
		db      47 DUP(0)		; space for string from get
		db	46			;
		db      47 DUP(0)		; space for string from get
p_string	db	46			;
prompt_string	db	47 DUP(0)		; space for prompt string
slct	db	'             Selection >>$'
fn	db	0				; BIOS function storage loc
target_dir	db	'\MENU',0	
search_dir	db	'\MENU\'
handle	dw	0				; handle storage location
drive		db	0			; slot for current drive
expansion_flag	db	0			; flag for parm exp in runstrm
tilde_flag	db	0			; flag for suspended runstrm
header	db	3h,'/C '			; header for comm line
exp_pointer	dw	0			; addr of parm exp char
buff_input	equ	0ah			; DOS buffered input
lp_count	dw	0			; 2 byte loop count
get_c_drive	equ	19h			; DOS get current drive fn
set_c_drive	equ	0eh			; DOS set current drive fn
close	equ	3eh				; DOS close fn
write	equ	40h				; DOS write bytes fn
creat	equ	3ch				; DOS create fn
menu_error	db	'Sorry unable to read that menu',cr,lf,honker,'$'
ancient_dos	db	'Sorry DOS version 2.0 or late is required',cr,lf,'$'
can_not_open	db	'Program could not find file "CURRENT.DTA"',cr,lf,'$'
write_error	db	'An error occured while writing to "CURRENT.DTA"',cr,lf,'$'
close_error	db	'Unable to close file "CURRENT.DTA"',cr,lf,'$'
p_key		db	cr,lf,'Press any key to continue',cr,lf,'$'
pause_flag	db	0
read_error	db	'An error occured while reading "CURRENT.DTA"',cr,lf,'$'
open	equ	3dh				; DOS open a file fn
quote	equ	22h				; quote char
file_atrib	equ	0h			; read write file atrib
print_string	equ	09h			; DOS print strng fn
read	equ	3fh				; DOS read from a file
cr      equ     0dh                             ; cariage return char
lf      equ     0ah                             ; line feed char
p_cent  equ     25h                             ; % char
cntrl_c         equ     03h                     ; control c
lbs     equ     23h                             ; # char
escc	equ	1bh				; escape char
honker	equ	07h				; bell char

;
;******************************************************************************
;
eds     equ     $                               ; end of data segment(length)

DSEG    ENDS

	ASSUME	CS:GROPE,DS:GROPE

CSEG    SEGMENT 'CODE'


ISR     PROC    FAR                             ; interupt service routine
        cli                                     ; not reentrent so clear intf
        push    ds                              ; save the data segment
        push    ax                              ; and ax register
        mov     ax,grope                        ; establish addressabity
        mov     ds,ax                           ;
        pop     ax                              ; restore entry parm
	mov	fn,ah				; save function
	cmp	ah,0c0h				; see if we are to abort mnu
	jz	abort_menu
        cmp     ah,1                            ; see if a function we intcp
        ja      simple_bios                     ; if not then just do it
runstream_test:
        cmp     runstream_active,0ffh           ; see if a runstream to use
        jz      supply_key                      ; if active then continue
simple_bios:
	pop	ds				; restore addressability
	sti					; reenable interupts
        jmp	cs:dWORD PTR [old_isr]          ; if not then call BIOS
simple_exit:
        pop     ds                              ; restore the calling program
        sti                                     ; restore interuptability
        ret     2                               ; addressability. Because the
                                                ; int instruction issued by
                                                ; the calling progam pushed the
                                                ; flags onto the stack, it is
                                                ; necessary to clean the stack
                                                ; up when we return. We can't
                                                ; do an iret here because we
                                                ; pass back the flags from BIOS
abort_menu:
; If we are here we abort the menu by setting runstream_active to 00h and
; insuring the tilde flag is off
	mov	runstream_active,00h		; abort by turning off runstrm
	mov	tilde_flag,00h			; make sure all off
	jmp	simple_exit			; and leave

supply_key:
	call	FAR PTR get_key			; return zf
	jnz	simple_exit			; and finish up if we have char
	mov	ah,fn
	jmp	simple_bios			; else go get actual key stroke
get_key:
        push    bx                              ;
	mov	bx,pointer			; get the runstream pointer
	push	bx				; save value
	call	snd_key				; see if key to get
	pop	bx				; restore orig pointer
	cmp	BYTE PTR fn,01H			; if BIOS fn 1 keep pointer
	jne	bumped				; else go with increment ptr
	mov	pointer,bx			; pointer to old value
bumped:	
        pop     bx
	cmp	runstream_active,00h		; if active zf=0,char here
        ret	

breaker_breaker:                                ; we get here when The User
                                                ; has pressed the panic button
                                                ; so we set the panic flag, so
                                                ; that each time BIOS keybrd
                                                ; int is called we issue a
                                                ; DOS terminate command. We do
                                                ; this until we are back at
                                                ; the main_loop. At main_loop
                                                ; we reset the panic flag.
                                                ; we don't care about regs or
                                                ; addressability at this point
                                                ; so we don't save anything.
        mov     ax,dseg                         ; Point to the data segment.
        mov     ds,ax                           ; Establish addressability.
        mov     panic_flag,0ffh                 ; set the panic flag.
        mov     ax,4c00h                        ; terminate the program.
        int     21h                             ; Done.

ISR     ENDP                                    ;

SND_KEY	PROC

; When here we ck to see if we have a printable char or if we are to ret
; a control,fn,or an alt key expansion. The key scan code is ret in ax.
; Pointers are updated if fn 0 of bios was called, not updated if fn0 was
; called. At entry bx contains pointer to runstream char.
; rev 2.2 added alt key fns. use '&' to indicate and alt key.
; alt keys add 128 to the key stroke value
get_runstream_char:
	cmp	expansion_flag,0ffh		; see if param exp current.
	jne	get_r_cont			; continue if ok
	jmp	get_exp_char			; if yes get exp char
get_r_cont:
	xor	ah,ah				; prelim clear high byte
	mov	al,[bx]				; get the next key
	cmp	al,lf				; skip lf to progs
						; we can always send a^J
	jnz	lbs_comp			; continue if ok
	inc	bx				; so get next char
	jmp	get_r_cont			; and try again
lbs_comp:
	cmp	al,'#'				; see if at new command line
	jne	try_caret			; if not try a caret char
	inc	bx				; point to next pos in runstrm
	cmp	BYTE PTR [bx],'*'		; see if a comment
	jnz	next_intel_kluge		;
	jmp	skip_ln				; skip the line if a comment
next_intel_kluge:
	cmp	BYTE PTR [bx],':'		; only valid chars in runstrm
	jz	$+5
	jmp	done_stream			; behind a # all else terms str
	inc	bx				; get next char
	mov	al,[bx]				; and continue checking
try_caret:
	cmp	al,'^'				; see if caret fn
	jne	try_bar				; if not see if a bar function
	inc	bx				; get next char
	mov	al,[bx]				; then make a control char
	call	lc_to_uc			; convert to upper case if nec
	sub	al,40h				; convert to control char
	jmp	end_ch				; exit
try_bar:
	cmp	al,'|'				; see if fn key
	jne	alt_key				; see if alt key fn
	inc	bx				; else get next char
	xor	al,al				; clear al
	mov	ah,[bx]				; get key into ah
	add	ah,0ah				; convert to scan code
	jmp	end_ch				; exit
alt_key:
	cmp	al,'&'				; see if alt key fn
	jne	tilde				; if not see if a tilde
	inc	bx				; get next char
	mov	al,[bx]				; then make an alt key
	call	lc_to_uc			; convert to upper case if nec
	add	al,128				; convert to alt key
	inc	bx				; and get next char next time
	mov	pointer,bx			; save pointer location
	mov	bx,OFFSET trans_table		;
	xlat					; get scan code for key
	xchg	ah,al				; set aux byte = scan code
	xor	al,al				; set main byte = 0
	jmp	real_end
tilde:
	cmp	al,'~'				; see if runstream to be susp
	jne	pe_cent				; see if % char
	mov	runstream_active,00h		; clear runstream flag
	mov	tilde_flag,0ffh			; set tilde flag
	inc	bx
	mov	pointer,bx			; save pointer to screen
	pop	ax				; get rid of near ret
	pop	ax				; get rid of old pointer
	pop	bx				; restore original bx value
	pop	ax				; get rid of far ret
	pop	ax				; get rid of far ret
	mov	ah,fn				; get back original bios fn
	jmp	simple_bios			; and exit as though nada happn
pe_cent:
	cmp	al,'%'				; see if char is % flag
	jne	end_ch				; OK its a printable char
	cmp	fn,1				; if just fooling do nada
	je	end_ch				; so exit
	inc	bx				; go to next char
	mov	al,[bx]				; get it
	inc	bx				; skip number
	mov	pointer,bx			; save pointer
	sub	al,'0'				; convert to binary
	push	si				; 
	push	cx				; save parms
	mov	ch,al				; put search parm in reg
	call	get_parm_addr			; get the addr of the parm
	pop	cx				; restor reg
	mov	ah,0				; high byte modified
	jnz	pe_er_ex			; flee in terror if error
	mov	expansion_flag,0ffh		; set expansion flag on
	mov	al,[si]				; get the string len
						; algorithm throws away cr
						; no dec of al necessary
	mov	exp_count,al			; save count in string
	inc	si				; point past count to char
	mov	exp_pointer,si			; save pointer
	pop	si				; restore parms
	jmp	get_exp_char			; and get the char
pe_er_ex:
	pop	si				; restore parms
	inc	bx				; skip over useless pointer
	jmp	get_runstream_char		; get next char	
end_ch:
	inc	bx				; and get next char next time
	mov	pointer,bx			; save pointer location
	mov	bx,OFFSET trans_table		;
	mov	ah,al				; save value
	xlat					; get scan code for key
	xchg	ah,al
real_end:
	ret
done_stream:
        mov     runstream_active,00h            ; reset flag
	xor	ax,ax				; clear accum no char
        ret
skip_ln:
	inc	bx				; look for end of line cr,{lf}
	cmp	BYTE PTR [bx],0dh		; see if at end of line
	jnz	skip_ln				; go till found
	inc	bx				; bump pointer again
	cmp	BYTE PTR [bx],0ah		; see if line feed next
	je	nxt_byt				; if lf take next byte
	inc	bx				; else bump pointer
nxt_byt:
	mov	al,[bx]				; get next char after skpd ln
	jmp	get_runstream_char		; now start over
get_exp_char:
	mov	bx,exp_pointer			; get the addr of next char
	mov	al,[bx]				; get exp char
	mov	ah,exp_count			; get count into ah
	dec	ah				; see if any more to do
	jne	ret_char			;
done_expand:
	cmp	fn,1				; see if we keep position
	je	g_e_exit			; keep pointer here on fn1
						; and we send back dummy char
						; else we don't care about
						; the char and pointers so
						; go get next char to ret
	mov	expansion_flag,00h		; turn off expansion
	mov	bx,pointer			; set to correct addr
	jmp	get_runstream_char		; we don't care about pointers
ret_char:
	cmp	fn,1				; see if key stat only
	je	g_e_exit			; if it is keep pointer here
	inc	bx				; else bump to next char
	dec	ah				; set up to re inc next
g_e_exit:
	mov	exp_pointer,bx			; save pointer
	inc	ah				; set count back one
	mov	exp_count,ah			; and count
	ret					; and exit

SND_KEY	ENDP

LC_TO_UC	PROC

; Convert lower case to upper case as nec only al, flags affected
	cmp	al,'a'				; if less than a exit
	jb	lc_exit				; no need to do anything
	cmp	al,'z'				; see if in range
	ja	lc_exit				; return if not in range
	sub	al,20h				; convert to uppercase
lc_exit:
	ret

LC_TO_UC	ENDP

        ASSUME  CS:GROPE,SS:PSTACK,ES:PSP,DS:PSP         ; INITIAL CONDITIONS

TOPSPIN   PROC         FAR

;******************************************************************************
;*
;*      The first thing we do is establish the program as resident. We check
;*      to see if this version of DOS will allow us to have residency.
;*
;******************************************************************************
	cld					; program assumes direction flg
						; is cleared throughout. If a
						; proc sets df it is resp for
						; reseting the flag when it
						; quits.
                                                ; check for proper dos version
        mov     ah,30h                          ; request DOS version number
        int     21h                             ;
        cmp     al,2                            ; see if at least DOS V 2.0
        jnb     dos_ok                          ; continue if DOS version ok
                                                ; we have a problem if here,
                                                ; we want to exit, but the
                                                ; DOS versions earlier than
                                                ; 2.0 require PSP in CS to
                                                ; terminate a program. This
                                                ; would cause us a problem,
                                                ; since this is an .EXE
                                                ; program, and puting PSP in
                                                ; the CS register would cause
                                                ; us to lose addressability for
                                                ; the next instruction in the
                                                ; program. As a result we are
                                                ; forced to resort to the KLUGE
                                                ; in the following code.
                                                ; ds points to PSP at this time
        push    ds                              ; save as the segment address
        xor     ax,ax                           ; get the first address in PSP
        push    ax                              ; so that when we return we
        ret                                     ; go to PSP:0 , termination pt.
                                                ; Since this is a far proc
                                                ; the assembler will give us
                                                ; a far return, which is what
                                                ; we want.
dos_ok:
                                                ; Now we check the command line
                                                ; to see if there is any thing
                                                ; to do. if not then we exit in
                                                ; terror, as The User was just
                                                ; fooling.
        mov     ax,dseg                         ; estab addressability
        mov     es,ax
        ASSUME  ES:DSEG
        mov     ax,environment_string           ; get the segment addr of
                                                ; the environment string
                                                ; from psp
        mov     es:parameter_block,ax           ; and save in our block
        mov     ax,ds                           ; point to psp
        mov     es:parameter_block+8,ax         ; save in parm block
        mov     es:parameter_block+12,ax        ; save in parm block
        call    NEAR PTR any_thing_to_do        ; If nada to do exit;
        call    NEAR PTR get_menu               ; read in the menu speced by
	jc	panic_exit			; if no menu read exit
	ASSUME	DS:DSEG				
	call	NEAR PTR get_comspec		; install the comspec
	call	NEAR PTR get_current_drive	; find out where we came from
        call    NEAR PTR borrow_cntrl_brk       ; borrow cnt brk int.
        call    NEAR PTR borrow_key_board       ; and borrow the key board int.
	call	NEAR PTR get			; get the data in the file
big_loop:
        call    NEAR PTR cls                    ; Clear the screen
                                                ; The User in command line
        call    NEAR PTR print_menu             ; Show The User his options
        call    NEAR PTR accept_option          ; Get The User's choice
        call    NEAR PTR perform_option         ; Set approriate flags
	jmp	big_loop			; keep doing it	
        jmp     terminate			; and exit
TOPSPIN        ENDP

ANY_THING_TO_DO         PROC

	ASSUME	DS:PSP
        cmp     byte ptr command_line,0         ; See if any commands to perf.
        jz      exit                            ; If not then flee in terror,
        ret                                     ; else return.
exit:
	mov	ax,dseg				; addr our data seg
	mov	ds,ax				;
	mov	es,ax				;
	
	
	ASSUME	DS:PSP
panic_exit:
        mov     ax,4c01h                        ; Terminate with error msg.
        int     21h                             ;

ANY_THING_TO_DO         ENDP

CLS             PROC

	mov	ah,0fh				; int 10h fn to get mode
	int	10h				;
	mov	ah,0				; reset same mode
	int	10h				;
	ret
;                                                ; This routine clears the scrn
;                                                ; by the sneaky subtrifuge of
;                                                ; enacting a resident vers of
;                                                ; command.com with the com ln
;                                                ; set to /C CLS.
;        mov     ax,dseg                         ; save stack and ss, as these
;                                                ; are trashed by exec func.
;        mov     ds,ax                           ;
;        ASSUME DS:DSEG                          ; *KEY without this the
;                                                ; assembler has problems with
;                                                ; following code: insists on
;                                                ; generating ES: overide for
;                                                ; mov WORD PTR stack_sav,s*
;                                                ; overide with DS:produces
;                                                ; listing which is correct,
;                                                ; but actual code produced does
;                                                ; not match listing!! What is
;                                                ; happenning is that MASM
;                                                ; thinks DS points to psp and
;                                                ; reorgs code to point to psp
;                                                ; relative address. ES: overide
;                                                ; is MASM's way of trying to
;                                                ; fix situation. MASM is too
;                                                ; clever for its own good.
;	
;	call	set_current_drive		; reestablish first drive
;	mov	si,OFFSET clear_line		; point to the command line
;	mov	di,OFFSET cline			; and move it to cline
;	mov	cl,[si]				; get the length of string
;	xor	ch,ch				; move one byte only
;	inc	cx				; also move len byte
;	rep	movsb				; and move the line in
;	call	execute				; execute the program
;	ret					;
;
CLS             ENDP





GET_CURRENT_DRIVE	PROC

	mov	ah,get_c_drive			; ask dos for drive
	int	21h				;
	mov	drive,al			; save result
	ret

GET_CURRENT_DRIVE	ENDP

SET_CURRENT_DRIVE	PROC
	
	mov	dl,drive			; reestablish drive
	mov	ah,set_c_drive			; tell DOS
	int	21h				;
	ret

SET_CURRENT_DRIVE	ENDP


GET_MENU        PROC

        call    build_asciiz                    ; massage The User's file name
        call    open_com_line                   ; open The User's file
	jc	get_m_exit			; exit upon error
        call    read_com_line                   ; now read in the file
	jc	get_m_exit
        call    close_com_line                  ; now close it up, we're done
	ret
get_m_exit:
	call	search_menu_asciiz		; insert \menu\ into search 
        call    open_com_line                   ; open The User's file
	jc	get_mn_exit			; exit upon error
        call    read_com_line                   ; now read in the file
	jc	get_m_exit
        call    close_com_line                  ; now close it up, we're done
	ret
get_mn_exit:
	call	error				; report the error
        ret

GET_MENU        ENDP

BUILD_ASCIIZ    PROC

                                                ; When we get here we have
                                                ; encounterd a command line
                                                ; to execute. The first thing
                                                ; we then do is to find the
                                                ; speced program and load the
                                                ; menu into our data storage
                                                ; location. We do this by
                                                ; changing the command line
                                                ; into an asciiz string
        ASSUME  DS:PSP                          ; Restore assumption of adr.
        mov     ax,dseg                         ; establish addressability
        mov     es,ax                           ; for data movement
        ASSUME  ES:DSEG
        mov     si,OFFSET command_line          ; get the command line to move
        mov     cl,[si]                         ; get the length of it
        xor     ch,ch                           ; single byte move
        mov     di,OFFSET com_line              ; point to our command line
        inc     cx                              ; move the length byte also
        rep     movsb                           ; now move the command line
        push    es                              ; establish addressability
        pop     ds                              ;
        ASSUME  DS:DSEG
        mov     cl,com_line                     ; get length byte,ch=0
        mov     bx,OFFSET com_line              ; get the address of com line
        add     cx,2                            ; bump to one past end
        add     bx,cx                           ; now index to proper ln pos
        mov     byte ptr [bx],0                 ; and set command line to 0
                                                ; terminated string as needed
                                                ; by DOS for handle use.
        inc     com_line                        ; bump count to add in the zero
	mov	si,OFFSET com_line + 1		; now convert to all capitals
	mov	di,OFFSET com_line + 1		; so that when used as key it 
	mov	cl,com_line			; it will work properly
	sub	ch,ch				;
convlp:
	lodsb					; get first char cx<> 0
	call	lc_to_uc			; convert char
	stosb					; put back in string
	loop	convlp				; continue till all convted
						; rev 2.3 search for \
						; to see if /e or /b options
	mov	cl,com_line			; get count , ch = 0
	mov	al,'/'				; see if / in line
	mov	di,OFFSET com_line + 1		; point to the command line
	repne	scasb				; see if options 
	jne	period_search			; if not continue
	cmp	BYTE PTR [di],'E'		; see if /e option
	jne	esc_1				; aha esc allowed (norm off)
	mov	esc_flag,0h			; turn off escape active
esc_1:
	cmp	BYTE PTR [di],'B'		; aha bell allowed (norm off)
	jne	bell_1
	mov	bell_flag,0ffh			; turn on bell
bell_1:
	call	compress_line			; compress the line 
	jcxz	period_search			; out of string to search exit
	repne	scasb				;
	jne	period_search			; if not continue
	cmp	BYTE PTR [di],'E'		; see if /e option
	jne	esc_2				; aha esc allowed (norm off)
	mov	esc_flag,0h			; turn off escape active
esc_2:
	cmp	BYTE PTR [di],'B'		; aha bell allowed (norm off)
	jne	bell_2				;
	mov	bell_flag,0ffh			; turn on bell
bell_2:
	call	compress_line			; compress the line 
period_search:
	mov	cl,com_line			; get count , ch = 0
						; if found we assume The User
						; has added .mnu to menu name
						; if not found then we tack it
						; to the end of the string.
	mov	di,OFFSET com_line + 1		; point to the string to search
	mov	al,'.'				; put seach target in al
	repne	scasb				; and search
	je	convexit			; exit if found
	dec	di				; point back to the ending zero
	mov	si,OFFSET extentz		; point to the string to add
	mov	cx,5				; move the string ".mnu"0 here
	rep	movsb				;
	add	com_line,5			; bump count
convexit:
        ret

BUILD_ASCIIZ    ENDP

COMPRESS_LINE	PROC
; Rev 2.3 gets rid of /. on line
	push	cx				;
	push	di				;
	jcxz	move_zero			; just move 0 if nada in line
	mov	si,di				; get source
	dec	di				;
	inc	si				; point one past /.
	rep	movsb				; and move the text up
comp_exit:
	dec	com_line			; count down by two
	dec	com_line			;
	pop	di				; restore regs
	pop	cx				;
	dec	di				; di now off by one for next 
	dec	cx				; don't go below zero in cx
	je	comp_end			; exit if zero
	dec	cx				; finish adjusting count
comp_end:
	ret
move_zero:
	mov	BYTE PTR [di -1],0
	jmp	comp_exit
	
COMPRESS_LINE	ENDP

SEARCH_MENU_ASCIIZ	PROC

; We insert a \menu\ in the asciiz search string
	mov	si,OFFSET com_line+2		; save the old commmand line
	mov	di,OFFSET temp_str		; in the temp string
	mov	cx,126				; move the whole com line
	rep	movsb				;
	mov	si,OFFSET search_dir		; get \menu\
	mov	di,OFFSET com_line+2		; move it into the string
	mov	cx,6				;
	rep	movsb
	mov	si,OFFSET temp_str		; get back the old asciiz str
	mov	di,OFFSET com_line+8		; put after the \menu\
	mov	cx,120				; move rest of string
	rep	movsb				;
	add	com_line,6			; bump count by addition
	ret


SEARCH_MENU_ASCIIZ	ENDP


OPEN_COM_LINE   PROC

        mov     ax,3d00h                        ; open a file hndl, read only
        mov     dx,OFFSET com_line+2            ; get the asciiz string
                                                ; skip length byte and space
        int     21h                             ; ask DOS to open hndl
        mov     menu_handle,ax                  ; save the handle for later use
        ret

OPEN_COM_LINE   ENDP

READ_COM_LINE   PROC

        mov     bx,menu_handle                  ; get the handle to read from
        mov     cx,buffer_size                  ; attempt to read whole buffer
        mov     dx,OFFSET menu_buffer           ; point to the area for file
        mov     ax,3f00h                        ; DOS read from handle func
        int     21h                             ; attempt to read
        jnc     read_ok                         ; test if found
        jmp     error                           ; report error
read_ok:
        mov     file_size,ax                    ; save size of file read
        ret

READ_COM_LINE   ENDP

CLOSE_COM_LINE  PROC

        mov     bx,menu_handle                  ; close the handle
        mov     ax,3e00h                        ; DOS close function
        int     21h                             ; attempt to close
        cmp     al,06                           ; check for errors
        jnz     closed                          ; report errors
	stc					; set carry for error
        jmp     error                           ; report error
closed:
	clc					; return no error indicated
        ret

CLOSE_COM_LINE  ENDP

GET_COMSPEC	PROC

; This procedure searchs the environment strings for COMSPEC=. It then moves
; the ASCIIZ string following into filename. If COMPSEC= is not found default
; is left in filename. The end of the environment strings is marked by a 
; double 0.

	mov	ax,parameter_block		; get the segment of en strgs
	push	ds				; save addressability
	mov	ds,ax				; point to the environment str
	mov	di,OFFSET comspec		; point to target string
	xor	si,si				; start at beginning of strgs
	mov	cx,8				; 
	rep	cmpsb				; see if found yet
	jz	did_get				; exit if not found
	mov	cx,8000h			; search whole pot area
	mov	lp_count,cx			; get loop started
chk_lp:
 	mov	cx,lp_count			; restore count
chk_lp1:
	lodsb					; check for next 0
	or	al,al				;
	jz	chk_lp_exit			; if z exit
	loop	chk_lp1				; keep trying
	jmp	not_got				; exit if no comspec=
chk_lp_exit:
	cmp	BYTE PTR [si],0			; see if next byte z also
	je	not_got				; exit if it is
	mov	lp_count,cx			; save how much left
	mov	di,OFFSET comspec		; search for target
	mov	cx,8				; 
	rep	cmpsb				; see if found yet
	jz	did_get				; exit if not found
	jnz	chk_lp				; keep trying
did_get:
	mov	di,OFFSET filename		; else move comspec strg >flnm
mov_lp:
	lodsb					; get next byte
	stosb					; and save
	or	al,al				; see if zero moved yet
	jnz	mov_lp				; loop if not
not_got:
	pop	ds				; restore addressability
	ret

GET_COMSPEC	ENDP

PRINT_MENU      PROC

; This is one of the main
; functions of the program:
        mov     ax,OFFSET menu_buffer           ; point at the buffer
        mov     print_pointer,ax                ; and save it
        mov     ax,file_size                    ; get the size of the menu
        mov     print_count,ax                  ; init print counter
no_response:
        mov     new_line_flag,0ffh              ; and the new line flag
char_loop:
        call    control_char?                   ; see if control char
        jz      cariage_return                  ; ok check is cr?
        call    print_char                      ; otherwise print char
        mov     new_line_flag,00h               ; reset new line flag
        jmp     end_loop                        ; and continue
cariage_return:
        cmp     al,cr                           ; see if char is car ret
        jnz     per_cent                        ; if not continue checking
        call    print_char                      ; print the cr
        call    key_pressed?                    ; see if a key is pressed
        jz      ignore                          ; if not then continue
        call    valid_menu_key?                 ; check if a valid menu key
	jz	try_key				; try this key out
	call	get_keystroke			; throw away invalid key
        jmp     ignore                          ; ignore if not
try_key:
	ret
ignore:
        mov     new_line_flag,0ffh              ; set new line flag
        mov     al,lf                           ; print a line feed
        call    print_char
        call    next_line_feed?                 ; see if next char is line fd
        jnz     end_loop                        ; continue if not line feed
                                                ; if line feed skip over it
        call    bump_pointers                   ; bump the pointers
        jnz     end_loop                        ; continue if more to do
        ret                                     ; done so exit to respond
per_cent:
        cmp     al,p_cent                       ; see if what we want
        jnz     lb_sign                         ; if not must be pound sign
        call    expand_print                    ; print the expansion of %n
        call    bump_pointers                   ;
        jnz     skip_nex
        ret                                     ; done so exit to respond
skip_nex:
        mov     new_line_flag,00h               ; reset the new line flag
        jmp     end_loop
lb_sign:
        call    skip_line                       ; skip the line
        jnz     lb_continue                     ; continue if not off screen
        ret                                     ; exit if off screen
lb_continue:
        mov     new_line_flag,0ffh              ; start of new line
        jnz     end_loop                        ; continue loop
        ret                                     ; exit we are done
end_loop:
        call    bump_pointers                   ; see if more to do
        jz      exit_loop                       ; if so exit
        jmp     char_loop                       ; continue
exit_loop:
						; in this procedure print
						; the selection prompt
	mov	ah,09h				; Dos to write a string
	mov	dx,OFFSET slct			; point to string to write
	int	21h				; prompt is printed
        ret

PRINT_MENU      ENDP

CONTROL_CHAR?   PROC
                                                ; exit with zr if char is
                                                ; a control char, nz if not
        mov     bx,print_pointer                ; point to next char
        mov     al,[bx]                         ; and get the char
        cmp     al,cr                           ; see if control char
        jnz     check_for_per_cent              ; no; see if %
        ret                                     ; yes exit
check_for_per_cent:
        cmp     al,p_cent                       ; see if %
        jnz     check_for_lb_sign               ; no see if #
        ret                                     ; ok its a %
check_for_lb_sign:
        cmp     al,lbs                          ; check for a #
        ret                                     ; and exit


CONTROL_CHAR?   ENDP

CREAT_C_D	PROC

; This proc creates the current data file, as none exists.
; First we create the \MENU\ sub directory whether it exists or not
	mov	ah,mkdir		; make the directory
	mov	dx,OFFSET menu_nm	; directory to create
	int	21h			; tell DOS
	mov	dx,OFFSET dta_nam	; point to the name to write
	mov	ah,create_file		; now create the file
	mov	cl,0			; set file attributes to 0
	int	21h			;
	ret
	
CREAT_C_D	ENDP

PUT	PROC

; This procedure prints out any quoted material on line where ##< is found.
; the information is put in the file \menu\current.dta where it can be used
; later after a power down. The information is also put in get_string for use
; by the menu. Upon entry bx points to position following ##<. First we search
; for a quoted string. We find it by seeing if we can find an opening quote,
; before we find a cr. If not we just accept input.
	push	bx				; save entry parm
	call	open_c_d			; try to open the file
	jnc	no_create			; if it does don't make it
	call	creat_c_d			; open current.dta
	mov	dta_handle,ax			; return handle to storage 
no_create:
	pop	bx				; restore entry parm
	mov	dx,OFFSET g_string		; point to parameter string
	call	prompt				; get the prompted material
nxt_chr_to_chk:
	inc	bx				; look at next char
	cmp	BYTE PTR [bx],cr		; if at end exit loop
	jz	save_parms			; if so just save parm %0
	cmp	BYTE PTR [bx],'%'		; see if to percent yet
	jnz	nxt_chr_to_chk			; if not then continue
	inc	bx				; now get next char
	mov	ch,[bx]				; get the %n
	sub	ch,'0'				; convert to binary
	call	get_parm_addr			; get the parm addr for move
	mov	di,si				; swap for move
	mov	si,OFFSET get_string		; get the string to move
	mov	cl,[si]				;
	inc	cl				; also move the length byte
	xor	ch,ch				; zero , 1 byte count
	rep	movsb				; move the string
save_parms:
	call	write_data			; write data to file
	call	close_c_d			; now close current.dta
	ret					; done

PUT	ENDP


PROMPT	PROC	
; Entry ds:dx string to fill in , ds:bx quote line to use
; We ask for input , printing quoted material
; Exit: bx points at end of quoted string entry:dx + 1 filled in with string 
sloop:
	cmp	BYTE PTR [bx],quote		; see if a quote mark
	je	start_prt			; start printing if found
	cmp	BYTE PTR [bx],cr		; see if at end
	je	no_prt				; no print so give up
	inc	bx				; try next char
	jmp	sloop				; continue until at end
start_prt:
	inc	bx				; point to next char
	mov	ah,0eh				; BIOS tty fn
	mov	al,[bx]				; get char to write
	cmp	al,cr				; see if at end of string
	je	no_prt				; exit if done
	cmp	al,quote			; see if at end of string
	je	no_prt				; exit if done
	push	bx				; save pointer
	xor	bx,bx				; clear reg
	int	10h				; print char
	pop	bx				; restore pointer
	jmp	start_prt			; and continue printing
no_prt:
; now get input string
	push	bx				; save entry parm
	push	dx				; save pointer to string
	mov	ah,buff_input			; call dos input string svc
	int	21h				;
	pop	bx				; use as pointer
	inc	BYTE PTR [bx + 1]		; include cr in string len
	pop	bx				; point to quoted string
	ret

PROMPT	ENDP


OPN_ERR	PROC

	mov	dx,OFFSET can_not_open		; tell operator of error
	mov	ah,print_string			; print the string fn
	int	21h				;
	stc					; set carry for exit
	ret

OPN_ERR	ENDP


WRITE_DATA	PROC
; This proc writes the 480 bytes of parms to the current data file

	mov	cx,WORD PTR novell_num+4; get the low word of novell number
	mov	ax,480			; get size of parms table
	mul	cx			; produce index into \MENU\MENUNAME.DTA
	mov	cx,dx			; set up to move the file pointer
	mov	dx,ax			;
	mov	ah,move_ptr		;
	xor	al,al			; zero the move mode
	mov	bx,dta_handle		; get the handle of the data file
	int	21h			; move the pointer
	mov	bx,dta_handle		; get the pointer to data file
	mov	ah,write_bytes		; now read in the file
	mov	dx,OFFSET menu_nam	; point to the string to read buffer
	mov	cx,504			; read 504 bytes
	int	21h			; and read in the parms.
	ret

WRITE_DATA	ENDP

WRITE_ERR	PROC

	mov	dx,OFFSET write_error		; tell operator of error
	mov	ah,print_string			; print the string fn
	int	21h				;
	call	beep				; alert The User
	call	press_any			; press any key to cont
	ret

WRITE_ERR	ENDP

PRESS_ANY	PROC

	mov	dx,OFFSET P_KEY			; tell operator of error
	mov	ah,print_string			; print the string fn
	int	21h				;
	xor	ah,ah				; clear reg
	int	16h				; wait for a key
	ret

PRESS_ANY	ENDP


CLOSE_ERR	PROC

	mov	dx,OFFSET close_error		; tell operator of error
	mov	ah,print_string			; print the string fn
	int	21h				;
	call	beep				; alert The User
	call	press_any			; press any key to cont
	ret

CLOSE_ERR	ENDP

OPEN_C_D	PROC

; This proc opens the current DTA file
	mov	al,00000010b			; open using rd/wr status
	mov	ah,open_file			; DOS open file command
	mov	dx,OFFSET dta_nam		; point to the data name
	int	21h				; open file
	mov	dta_handle,ax			; save the handle
	ret					; ret error
	
OPEN_C_D	ENDP

CLOSE_C_D	PROC

; This proc closes the current DTA file		;
	mov	bx,dta_handle			; get the handle of the DTA 
	mov	ah,close_file			; 
	int	21h				;
	ret

CLOSE_C_D	ENDP

GET	PROC
; This proc, put, and get_menu are the only ones which need be modified to make
; Topspin LAN ready. The parms are now stored in "\menu\current.dat" as follows
; menu_nam	db	12
; our number	db	12
; g_string	db	480 DUP(0)		; actual data
; we calculate offset of correct parms in file from number_of_users data.
; modifications of data need not be handled multi user, as each node has 
; unique data. Adding a new menu or node to the system is a locked operation,
; as the file is rewritten.

	call	form_current_dta		; form the data name
	call	open_c_d			; open the file current.dat
	jc	get_out_of_here			; exit if not there
	call	read_data			; read in the parm string
	call	close_c_d			; and close the file
	ret
get_out_of_here:
	ret

GET	ENDP

NULL_G_STRING	PROC
; This proc restores data area to pristene condition if error occured.
	mov	di,OFFSET g_string		; get the pattern to repeat
	mov	bx,10				; do this 10 times
b_lp:
	mov	cx,strng_len-2			; and the number of bytes to wr
	mov	al,strng_len-1			; generate pattern
	stosb					;
	xor	al,al				; byte to fill with
	rep	stosb				;
	dec	bx				; bump count
	jnz	b_lp				; continue until built
	ret

NULL_G_STRING	ENDP

READ_DATA	PROC

; This procedure reads the current menu parms from the current data file
; in Rev 2.0 and above we do not use Btrieve, so the files are constructed as
; follows: MENUNAME.MNU			; the name of the menu
;	   \MENU\MENUNAME.DTA		; the name of the data file.
; In the data file we use the novel number as an index for writing and reading
; the data in the file. This allows us to have separate parms for each user in
; a NOVELL LAN. 
	mov	cx,WORD PTR novell_num+4; get the low word of novell number
	mov	ax,480			; get size of parms table
	mul	cx			; produce index into \MENU\MENUNAME.DTA
	mov	cx,dx			; set up to move the file pointer
	mov	dx,ax			;
	mov	ah,move_ptr		;
	xor	al,al			; zero the move mode
	mov	bx,dta_handle		; get the handle of the data file
	int	21h			; move the pointer
	mov	bx,dta_handle		; get the pointer to data file
	mov	ah,read_bytes		; now read in the file
	mov	dx,OFFSET menu_nam	; point to the string to read buffer
	mov	cx,504			; read 504 bytes
	int	21h			; and read in the parms.
	ret

READ_DATA	ENDP

FORM_CURRENT_DTA	PROC	NEAR
; This procedure creates the name of the current data file using the menu name
; as the name of the current data file.
	call	get_our_name		; first get the name of the current mnu
	mov	si,OFFSET menu_nam	; point to menu name
	mov	di,OFFSET dta_nam + 6	; point past the \MENU\
	mov	cx,9			; maximum of 8 characters in name
fcdlp:
	lodsb				; get byte
	cmp	al,'.'			; see if at end of string to move
	stosb				; save char
	loopne	fcdlp			; loop until a match or done
	mov	al,'D'			; now tack on 'DTA'
	stosb				;
	mov	al,'T'			;
	stosb				;
	mov	al,'A'			;
	stosb				;
	mov	al,0			;
	stosb				;	
	ret
	
FORM_CURRENT_DTA	ENDP

READ_ERR	PROC


	mov	dx,OFFSET read_error		; tell operator of error
	mov	ah,print_string			; print the string fn
	int	21h				;
	call	beep				; alert The User
	call	press_any			; press any key to cont
	ret


READ_ERR	ENDP


GET_OUR_NAME	PROC

; This procedure gets the name of the menu we are using, and inserts it in the
; menu_nam area. First we go to the com_line, getting number of parms there.
; we then offset to end of line (going backward in operation and:
;	repeat until either all used up or until char = "\" 
;		move a byte from end of name to end of menu_nam ,count each
;		byte moved.
;	THEN move formed string to start of menu.nam, right filling with " "
	sub	ch,ch				; one byte quantity
	mov	cl,com_line			; get max len of string
	mov	si,OFFSET com_line 		; point to string header
	mov	di,OFFSET menu_nam + 12		; point to end of key area
	sub	bx,bx				; clear count
	std					; go backwards
	add	si,cx				; point to last char in strng
bloop:
	lodsb					; get char
	cmp	al,'\'				; see if terminator
	jz	bloop_exit			; leave if it is
	stosb					; save in target
	inc	bx				;
	loop	bloop				; and continue move
bloop_exit:
						; bx has num of char moved
	inc	di				; point to first char in strng
	mov	si,di				; make new source
	cld					; move from low to high again
	mov	cx,bx				; put count in counter
	mov	di,OFFSET menu_nam		; put to start of area
	rep	movsb				; now move the string
	ret

GET_OUR_NAME	ENDP

GET_OUR_NUMBER	PROC

; This procedure gets the Novell network number for this station and inserts 
; it in the novell_num field
	xor	ax,ax				; zero registers to start
	mov	bx,ax				; so that we have less to do
	mov	cx,ax				; later
	mov	ah,0eeh				; call novell for phys st num
	int	21h				;
						; if no Novell we always get
						; the same result so save it
	mov	WORD PTR novell_num,ax		; save the result in field
	mov	WORD PTR novell_num + 2,bx	; if Novell present save number
	mov	WORD PTR novell_num + 4,cx	;
	ret

GET_OUR_NUMBER	ENDP

	
PRINT_CHAR      PROC
; Entry: al = char to print
; bx modified
                                                ; Print the char in al
                                                ; using IBM bios call
	cmp	al,0dh				; print cr and lf
	jz	prnt				;
	cmp	al,0ah				;
	jz	prnt				;
	cmp	al,09h				; see if tab
	jz	expand_tab			; if so expand tab
	cmp	al,' '				; see if printable
	jb	pc_exit				; exit if not
prnt:
        mov     ah,0eh                          ; print as teletype
        xor     bx,bx                           ; clear colors etc
        int     10h                             ; call bios
pc_exit:
        ret
expand_tab:
; Tabs every 8 positions 0,8,16 etc
	mov	bh,0				; read page 0
	mov	ah,3				; find cursor position
	int	10h				; call bios
	mov	al,dl				; get the position
	and	al,0fh				; mask off the low bits
	cmp	al,8				; if below 8 set to 8
	jb	make_8				; set count to 8
	and	dl,0f0h				; keep 
	add	dl,16				; set to next tab
	mov	ah,2				; set cursor position
	int	10h
	ret
make_8:
	and	dl,0f0h				; set position to 8
	add	dl,8				;
	mov	ah,2				; set cursor position
	int	10h
	ret
PRINT_CHAR      ENDP


KEY_PRESSED?    PROC

        mov     ax,0100h                        ; check to see if key rdy
        int     16h                             ; call bios
        ret                                     ; send back status

KEY_PRESSED?    ENDP

GET_KEYSTROKE	PROC

	xor	ax,ax				; get the key
	int	16h				;
	ret					;

GET_KEYSTROKE	ENDP

VALID_MENU_KEY?         PROC

						; entry: ax has key code
	cmp	al,escc				; escape a vld code!
	jnz	test_for_fn			; no see if an fn code
	cmp	esc_flag,0			; see if esc allowed
	je	bad_key				; if not then bad key else:
	pop	ax				; get rid of return addr
	jmp	terminate			; and exit completely
test_for_fn:
	or	al,al				; see if possible fn code
	jnz	not_fn_key			; no not a fn key
	cmp	ah,3bh				; see if in range of fn key
	jb	not_fn_key			; no not a fn key
	cmp	ah,45h				; see if in range of fn key
	ja	not_fn_key			; not not a fn key
	mov	al,ah				; aha fn key
	sub	al,3ah  			; so change to 1 to 10
	jmp	good_key			; continue key processing
not_fn_key:
	cmp	al,31h				; see if 1 to 9
	jb	not_number			;
	cmp	al,39h				;
	ja	not_number			;
	sub	al,26h				; convert 1-9 to 11-19
	jmp	good_key			; continue processing
not_number:
	cmp	al,41h				; see if A-Z
	jb	not_a_capital			;
	cmp	al,5ah				;
	ja	not_a_capital			;
	sub	al,2dh				; convert A-Z to 20-46
	jmp	good_key			;
not_a_capital:
	cmp	al,61h				; see if a-z
	jb	bad_key				; not a valid key
	cmp	al,7ah				;
	ja	bad_key				;
	sub	al,4dh				; convert a-z to 20-46
good_key:
	call	find_line			; return line address in buff
	jnz	bad_key				; bad key? say so.
        xor     ah,ah                           ; set valid status
        ret
bad_key:
	call	beep				; Honk at The User!
	or	al,0ffh				; turn off flag
	ret

VALID_MENU_KEY?         ENDP

FIND_LINE	PROC

						; Exit with si =addr of vld
						; line. zf =1 if ok =0 if not
						; al = line num at entry
	mov	dx,ax				; save entry parm
	xor	dh,dh				; single byte count
	mov	ax,'##'				; chars to look for
	call	locate_pair			; find the chars in ax
	ret
	
FIND_LINE	ENDP

BEEP	PROC
; rev 2.3 check flag to see if allowed
	cmp	bell_flag,0			; see if allowed
	je	beep_end			; exit if not	
	mov	al,honker			; honk at The User by sending
	mov	ah,0eh				; bell out to video screen
	xor	bx,bx				; no atributes
	int	10h				; tell bios
beep_end:
	ret					;

BEEP	ENDP

LOCATE_PAIR	PROC	
						; given the chars in ax
						; we search the menu to find
						; them. First we swap bytes in
						; ax for comparisom
	xchg	ah,al				; swap bytes
	mov	di,OFFSET menu_buffer		; point to area to search
	mov	cx,file_size			; get size to search
try_comp:
	repnz	scasb				; now look for char in al
	jcxz	no_found_line			; exit if not there
	cmp	ah,[di]				; now see if second byte matchs
	jnz	try_comp			; continue if not
	inc	di				; bump to next char
	dec	cx				; count down by one
	jcxz	no_found_line			; we didn't find it (effectly)
	dec	dx				; see if correct string
	jnz	try_comp			; continue trying
	mov	si,di				; put in reg for return
	ret					; we found it
no_found_line:					; not there, we exit
	or	al,al				; set zf= 0
	ret

LOCATE_PAIR	ENDP				;


NEXT_LINE_FEED?         PROC
                                                ; check to see if next char
                                                ; is a line feed
        mov     bx,print_pointer                ; point to current char
        cmp     BYTE PTR [bx+1],lf              ; see if next char is a line fd
        ret

NEXT_LINE_FEED?         ENDP

BUMP_POINTERS   PROC

        inc     WORD PTR print_pointer          ; point to next char to print
        dec     WORD PTR print_count            ; ret with flags set
        ret

BUMP_POINTERS   ENDP


EXPAND_PRINT    PROC
; Entry [print_pointer] has the address of the % char
                                                ; when here we get the approp
                                                ; char(s) from the get string
                                                ; print them and return.
        mov     bx,print_pointer                ; get the print pointer
        mov     ch,[bx+1]                       ; get the next char
        sub     ch,'0'                          ; convert to binary number
        call    get_parm_addr                   ; get the address of parm
        jz      expand		                ; continue if ok
        ret                                     ; return not ok
expand:
	lodsb					; get the length byte
	dec	al				; throw away cr
	mov	cl,al				; into the count regs
	xor	ch,ch				;
exp_loop:
	lodsb					; get the first byte in parm
	call	print_char			; print the expanded char
	loop	exp_loop			; continue until printed
	ret


EXPAND_PRINT    ENDP

GET_PARM_ADDR   PROC
; entry ch = number of parm (binary)
; exit si = addr of parm in memory.  zr if data found, nz if not found.
; modifies si,ax,cx
	cmp	ch,9				; valid 0 - 9
	ja	error_exit			; if out of range exit
	mov	al,strng_len			; get length of each string
	mul	ch				; index into the strings
        mov     si,OFFSET get_string            ; point to the string
	add	si,ax				; index to proper string
	cmp	BYTE PTR [si],0			; see if any parm there
	jz	error_exit			; nothing to do exit
	xor	cx,cx				; set zero flag
	ret
error_exit:
        or      al,0ffh                         ; set nz
        ret                                     ; and ret

GET_PARM_ADDR   ENDP

SKIP_LINE       PROC

        mov     bx,print_pointer                ; start discarding char
        cmp     BYTE PTR [bx],cr                ; see if cr yet
        jz      skip_exit                       ; exit if cr
        call    bump_pointers                   ; to next char
        jnz     skip_line                       ; continue if not end of scrn
        ret                                     ; ret if end of screen
skip_exit:
        call    bump_pointers                   ; skip cr
        jnz     skip_lf                         ; exit if at end of screen
	ret
skip_lf:
        call    next_line_feed?                 ; see if next char is line fd
        jnz     skip_end                        ; continue if not line feed
                                                ; if line feed skip over it
        call    bump_pointers                   ; bump the pointers
        jnz     skip_end                        ; continue if more to do
skip_end:
        ret                                     ; done so exit to respond

SKIP_LINE       ENDP



ACCEPT_OPTION   PROC

	call	get_keystroke			; wait for kbd input
	call	valid_menu_key?			; check for good key
	jnz	accept_option			; key trying
	ret

GETTER	PROC

; When here we have received instruction to get file from the "current.dat"
; infromation. Since we would normaly expand % characters in any case, the 
; difference is that we reread the "current.dat" file in this case.
putter:
; When here we perform put procedure
	mov	bx,si				; set up for put
	jmp	put				; and execute it
prompter:
; Issue prompt, wait for reply insert in command line
	mov	bx,si				; prompt for input
	cmp	BYTE PTR [si + 1],'!'		; see if he wants to pause
	jnz	n_pause				; continue if not
	mov	pause_flag,0ffh			;
n_pause:
	push	di				; save pointer
	mov	dx,OFFSET p_string		; get the prompt string
	call	prompt				; get input string
	cmp	BYTE PTR[p_string+1],1		; see if only cr
	jnz	n_pause1			; continue if ok
	pop	di				; clean up stack
	ret					; and exit , nothing to do
n_pause1:
	push	bx				; save pointer
	mov	al,lf				; print lf after accept
	call	print_char			;
	pop	bx
	pop	di				;
	inc 	bx				; point past "
	mov	si,bx				; in the entry prompt line
ldlp:
	lodsb					; get next char
	cmp	al,'%'				; see if char string goes here
	jz	fillin				; if so expand
	stosb					; save in string
	jmp	ldlp				; continue expanding string
fillin:
	push	si				; save pointer
	lodsb					; get the parm number
	sub	al,'0'				; convert to binary
	mov	ch,al				; set up to find
	call	get_parm_addr			; and get the addr to exand
	push	di				; save pointer
	mov	di,si				; move string
	mov	si,OFFSET prompt_string		; now execute string
	mov	ch,0				; single byte count
	mov	cl,[si]				; first move whole string
	jcxz	fillin_exit			; exit if nada to do
	push	si				; save for second operation
	push	cx				;
	inc	cx				; move len byte also
	rep	movsb				; into the parmeter area
	pop	cx				; restore info
	pop	si				;
	pop	di				;
	dec	cl				; throw away cr
	inc	si				; throw away len char
	add	cline,cl			; bump counter in c line
	rep	movsb				; put expansion char in string
	push	di				; save new pointer
fillin_exit:
	pop	di
	pop	si				; restore pointer
	inc	si				; skip over %n
	mov	bx,si				; copy for call
	call	num_rem				; get number remaining in scrn
	jmp	construct			; and execute
pauser:
; Set the pause flag
	mov	pause_flag,0ffh			; all we do different
	inc	si				; point to next char
	dec	cx				; count down by one
	jcxz	pause_exit			; leave if nada to do
	cmp	BYTE PTR [si],cr		; see if anything to do
	jnz	chck_rest			; if not continue
	mov	cline,0				; 0 the count in command line
	lodsb					; grab next char
	jmp	looop_ext			; and finish up
chck_rest:
	jmp	construct			; build the command line
pause_exit:
	ret

refetch:
; reload modified menu
	inc	si				; point past period
	call	construct			; build the line and execute it
        call    open_com_line                   ; open The User's file
        call    read_com_line                   ; now read in the file
        call    close_com_line                  ; now close it up, we're done
	ret

GETTER	ENDP

ACCEPT_OPTION   ENDP


PERFORM_OPTION  PROC
; When here we have as entry parm si pointing to char after appropriate
; ## in menu. We test for the following chars to be in line after ##:
; cx = number of char in string
; > get (read from \menu|current.dat)
; < put (write quoted prompt to screen accept response write to \menu\
;   current.dat)
; ? prompt (write quoted prompt to screen, accept response, treat as command
;   line input expansion)
; ! pause (set pause flag. Upon final exit to Topspin from runstream print
;   'Press any key to continue')
; . refetch menu (allow menu to be edited and reloaded)
; ; Ignore this option
	cmp	BYTE PTR [si],';'		; see if reject option
	jnz	p_con				; continue if not ';'
	jmp	beep				; else exit and honk
p_con:
	push	cx				; save entry parms
	push	si				;
	call	cls				; first clear the screen
	pop	si				;
	pop	cx				; entry parms saved
 tilde_loop:
	cmp	BYTE PTR [si],cr		; see if anything to do
	jnz	check_rest			; if not continue
	mov	cline,0				; 0 the count in command line
	lodsb					; grab next char
	jmp	looop_ext			; and finish up
; The above code allows us to load command.com with no parms-follwing
; runstream is legal : supplies chars to command.com to execute. Exit 
; command is necessary to return to menu.
check_rest:
	call	get_header			; move '3/C 'to cline
	cmp	BYTE PTR [si],'>'		; see if get mode
	jnz	intel_kluge1			; no long cond jumps
	jmp	get				; switch to getter
intel_kluge1:
	cmp	BYTE PTR [si],'<'		; see if put mode
	jnz	intel_kluge2			; no long conditional jumps
	jmp	putter				; switch to put mode
intel_kluge2:
	cmp	BYTE PTR [si],'?'		; see if prompt mode
	jnz	intel_kluge3			; no long conditional jumps
	jmp	prompter			; switch to prompt mode
intel_kluge3:
	cmp	BYTE PTR [si],'!'		; see if pause mode
	jnz	intel_kluge4			; no long conditional jumps
	jmp	pauser				; pause upon ret
intel_kluge4:
	cmp	BYTE PTR [si],'.'		; see if refetch menu mode
	jnz	intel_kluge5			; no long conditional jumps
	jmp	refetch				; refetch menu upon ret
intel_kluge5:					; di set up by get_header
construct:
	lodsb					; get byte into al
	cmp	al,'%'				; see if we expand char
	jnz	no_fat				; no continue
	lodsb					; get next char
	push	si				; save the pointer
	push	cx				; save count
	sub	al,'0'				; convert to binary parm
	mov	ch,al				; now get this addre
	call	get_parm_addr			; now returm add of parameter
	jnz	no_more_expand			; exit if nada to do
	lodsb					; get the next char
	dec	al				; throw away cr
	mov	cl,al				; put count into count reg
	xor	ch,ch				; single byte only
	add	cline,cl			; increase length of string
	rep	movsb				; and move the string in
no_more_expand:
	pop	cx				; restore count
	pop	si				; restore pointer
	jmp	construct			; and continue with next char
no_fat:
	stosb					; move into destination
	inc	BYTE PTR cline			; bump memory counter
	cmp	al,cr				; see if at end of line
 	loopnz	construct			; continue move
looop_ext:
	lodsb					; check next char
	cmp	al,lf				; if line fee ignore
	jnz	num_comp			; get the next char if lf
	lodsb					; if lf ignore
num_comp:
	cmp	al,'#'				; only legal thing is #
	jnz	no_runstream			; no runstream so execute
	lodsb					; get next char
chk_for_star:
	cmp	al,'*'				; see if comment line
	jne	colon_test			; if not then see if colon
star_loop:		
	lodsb					; skip comment line
	cmp	al,'#'				; search for start of next line
	je	ld_colon			; exit if it is
	jmp	star_loop			; last line #END in menu
ld_colon:
	lodsb					; get next char after '#'
	jmp	chk_for_star			; see if another comment line
colon_test:
	cmp	al,':'				; see if runstream
	jnz	no_runstream			; execute if no runstream
	mov	pointer,si			; save pointer to runstream
	mov	runstream_active,0ffh		; set runstream on
	mov	expansion_flag,00h		; no expansion on
	mov	tilde_flag,00h			; no tilde in effect
	call	execute				;
	cmp	pause_flag,0ffh			; see if pause flag set
	jnz	end_p				; exit if not
	mov	dx,OFFSET p_key			; print pause line
	mov	ah,print_string			; 
	int	21h
	call	get_keystroke			; wait for input
end_p:
	mov	pause_flag,00h			; reset pause flag
	cmp	tilde_flag,0ffh			; see if we continue fun
	je	more_fun			; continue if so
	ret
no_runstream:
	mov	pointer,si			; save pointer to runstream
	mov	runstream_active,00h		; set runstream on
	mov	expansion_flag,00h		; no expansion on
	mov	tilde_flag,00h			; no tilde in effect
	call	execute				;
	cmp	pause_flag,0ffh			; see if pause flag set
	jnz	end_p				; exit if not
	mov	dx,OFFSET p_key			; print pause line
	mov	ah,print_string			; 
	int	21h
	call	get_keystroke			; wait for input
	mov	pause_flag,00h			; no more waiting
	ret
more_fun:
	mov	tilde_flag,00h			; reset flag and continue
	mov	bx,pointer			; get the pointer back
	call	num_rem				; get number left in scrn
	mov	si,pointer			; now continue
at_lbs?:
	lodsb					; scan for #: to continue
	cmp	al,'#'				; see if at start
	loopnz	at_lbs?				; scan till there
	lodsb					; so see if at ':'
	cmp	al,'*'				; comment legal
	je	at_lbs?				; continue trying
	cmp	al,':'				; if not ':' then quit trying
	jnz	junk				; exit if not there
	jmp	tilde_loop			; so go build line
						; treat this line like ## line
junk:
	ret					; we are done - exit.

PERFORM_OPTION  ENDP

NUM_REM	PROC			
; Entry: bx= position in screen
; Exit: cx=count left in screen
	mov	cx,OFFSET menu_buffer		; find out how far we are
	sub	bx,cx				; count into screen
	mov	cx,file_size			; get size of buffer
	sub	cx,bx				; get amount remaining
	ret

NUM_REM	ENDP



EXECUTE	PROC

	push	es				; save the old es reg
        push    ds                              ; es:bx pointer
        pop     es                              ;
        mov     WORD PTR stack_sav,sp           ; save the stack addr
        mov     WORD PTR stack_sav+2,ss         ; and the segment reg
        mov     bx,OFFSET parameter_block       ; point to block for exec
        mov     dx,OFFSET filename              ;
        mov     ax,4b00h                        ; and execute the program
        int     21h                             ;
                                                ; all regs trashed, get back
exec_ret:
        mov     ax,dseg                         ;
        mov     ds,ax                           ;
; Order of the following two instructions is critical as int are not serviced
; until after the mov	ss,ea instruction.
        mov     ss,WORD PTR stack_sav+2         ; restore stack
        mov     sp,WORD PTR stack_sav           ;
	pop	es				; restore segment
        ret


EXECUTE ENDP

GET_HEADER	PROC

	push	si				; save entry parm
	push	cx				; save entry count
	mov	si,OFFSET header		; point to com line prefix
	mov	di,OFFSET cline			; move to cline
	mov	cl,[si]				; get length byte
	xor	ch,ch				; one byte len move
	inc	cx				; move string and len
	rep	movsb				;
	pop	cx				; restore entry count
	pop	si				; restore entry parm
	ret

GET_HEADER	ENDP

ERROR           PROC

; This reports an error occuring while trying to read in the menu
	pushf					; save the entry flags
	mov	dx,OFFSET menu_error		; tell The User about problem
	mov	ah,print_string			;
	int	21h				; call DOS
	popf					; return flags in error
        ret

ERROR           ENDP

DELIMITER?      PROC

        cmp     al,','                          ; see if comma
        jz      delim                           ; exit if it is
        cmp     al,' '                          ; see if space
	ja	delim				; if greate than it exit
	xor	al,al				; else set to 0 and exit
						; with zf set
delim:
        ret

DELIMITER?      ENDP

BORROW_KEY_BOARD        PROC

        call    read_key_vector                 ; first get the key vector
        call    write_key_vector                ; then set the new one
        ret                                     ; and exit
BORROW_KEY_BOARD        ENDP

BORROW_TERMINATE        PROC
        call    read_terminate_vector           ; first get the vector
        call    write_terminate_vector  	; then set the new one
        ret                                     ; and exit

BORROW_TERMINATE        ENDP

BORROW_CNTRL_BRK        PROC

        call    read_brk_vector                 ; first get the key vector
        call    write_brk_vector        	; then set the new one
        ret                                     ; and exit

BORROW_CNTRL_BRK        ENDP

READ_KEY_VECTOR         PROC

        mov     ax,3516h                        ; We now steal the key int
                                                ; by getting old address of int
        int     21h                             ; and saving the result
        mov     dx,es                           ;
        mov     ax,dseg                         ;
        mov     es,ax                           ;
        ASSUME  ES:DSEG
        mov     es:WORD PTR old_isr,bx          ; for later use when we are
                                                ; asked for it by a program;
        mov     es:WORD PTR old_isr+2,dx        ; so save the segment address
                                                ; of the old interupt service
                                                ; routine.
        ret

RESTORE_VECTORS         PROC

        push    ds                              ; save for addressability
        lds     dx,old_isr                      ; get address of int vctr
        mov     ax,2516h                        ; set keyboard int
        int     21h                             ;
        pop     ds                              ; restr and resave addr seg
        push    ds                              ;
        lds     dx,old_cntrl_brk                ; get adr of cntrl brk int
        mov     ax,2523h                        ; reset break addr
        int     21h                             ;
        pop     ds                              ;
        ret

RESTORE_VECTORS         ENDP

READ_KEY_VECTOR         ENDP
                                                ; The alogorithm we
                                                ; use for key board interupt
                                                ; capture makes us check to see
                                                ; if the there is a run stream
                                                ; active in the program when we
                                                ; are called. If there is then
                                                ; the keystroke is supplied by
                                                ; the internal program.
                                                ; We steal int 22h the
                                                ; terminate address, so that we
                                                ; can tell when the programs
                                                ; have exited back to the menu.
                                                ; We also steal int 23h, the
                                                ; control break int so that
                                                ; we can tell if The User is
                                                ; trying to abandon back to the
                                                ; menu system. If he is we
                                                ; issue terminate (4ch) DOS
                                                ; calls everytime the keyboard
                                                ; BIOS int is called. We do
                                                ; this until we are back at the
                                                ; main loop.
READ_BRK_VECTOR         PROC

        push    es                              ; Save addressability.
        mov     ax,3523h                        ; Get the cntrl brk int vector.
        int     21h                             ;
        mov     dx,es                           ; Save the segment addr of it.
        pop     es                              ; Restore addressability.
        mov     es:WORD PTR old_cntrl_brk,bx    ; Now save the old vector offst
        mov     es:WORD PTR old_cntrl_brk+2,dx  ; and the segment addr of it.
        ret

READ_BRK_VECTOR         ENDP

READ_TERMINATE_VECTOR          PROC

        push    es                              ; Save addressability.
        mov     ax,3522h                        ; Get the terminate int vector.
        int     21h                             ;
        mov     dx,es                           ; Save the segment addr of it.
        pop     es                              ; Restore addressability.
        mov     es:WORD PTR old_terminate,bx    ; Now save the old vector offst
        mov     es:WORD PTR old_terminate+2,dx  ; and the segment addr of it.
        ret

READ_TERMINATE_VECTOR          ENDP

WRITE_KEY_VECTOR        PROC
                                                ; If there is no run stream
                                                ; active then the BIOS is
                                                ; called directly.
        ASSUME  DS:GROPE,CS:GROPE		; Dummy assume so that we
                                                ; will get the correct offsets.
                                                ; So we now steal the int
	push	ds				; save for later use	

	mov	ax,grope			; establish addressability
	mov	ds,ax				;
        mov     dx,OFFSET grope:isr             ; by pointing to new int ser rt
        mov     ax,2516h                        ; DOS fn to set int
        int     21h                             ;
        pop     ds                              ; restore addressability

	ASSUME	DS:DSEG

        ret

WRITE_KEY_VECTOR        ENDP

WRITE_TERMINATE_VECTOR  PROC

        push    ds                              ; set ds to cs
        push    cs                              ;
        pop     ds                              ;
                                                ; ds contains segment addr of
	ASSUME	DS:CSEG
                                                ; cseg, so just set offsets.
        mov     dx,OFFSET exec_ret		; this is our terminate addr.
        mov     ax,2522h                        ; So tell DOS to set it up.
        int     21h                             ;
        pop     ds                              ;

	ASSUME	DS:DSEG

        ret

WRITE_TERMINATE_VECTOR  ENDP

WRITE_BRK_VECTOR        PROC

        push    ds                              ;
        push    cs                              ;
        pop     ds

	ASSUME	DS:CSEG

        mov     dx,OFFSET breaker_breaker       ; Aim at our break routine,
        mov     ax,2523h                        ; and tell DOS to set it up.
        int     21h                             ;
        pop     ds                              ; restore for data movement

	ASSUME	DS:DSEG

        ret

WRITE_BRK_VECTOR        ENDP

MAIN    PROC

terminate:
        mov     ax,dseg                         ; set up addressability
        mov     ds,ax                           ; regs clobbered, set up
        call    restore_vectors         	; restore all the vectors
	call	cls				; clear the screen
        mov     ax,4c00h                        ; terminate program not res
        int     21h

MAIN    ENDP

CRLF	PROC
	push	bx
	xor	bx,bx
	mov	ah,0eh				; print cr,lf
	mov	al,cr				;
	int	10h
	mov	ah,0eh				;
	mov	al,lf				;
	int	10h				;
	pop	bx
	ret

CRLF	ENDP

eocs    equ     $       

CSEG    ENDS
PSTACK  SEGMENT STACK   'STACK'

        DB      32 DUP ('STACK')
stck   equ     $                               ; end of stack segment(length)

PSTACK  ENDS
        END     TOPSPIN
