/**
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
 * http://creativecommons.org/licenses/by-nc-sa/4.0/
 * 
 * The original source can be found here:
 * https://p5js.org/examples/hello-p5-drawing.html
 * 
 * It was modified to run with DOjS by Andre Seidelt <superilu@yahoo.com>.
 */
Include('p5');

// All the paths
var paths = [];
// Are we painting?
var painting = false;
// How long until the next circle
var next = 0;
// Where are we now and where were we?
var current;
var previous;

function setup() {
	createCanvas(720, 400);
	current = createVector(0, 0);
	previous = createVector(0, 0);
};

function draw() {
	background(200);

	// If it's time for a new point
	if (painting) {
		// Grab mouse position      
		current.x = mouseX;
		current.y = mouseY;

		// New particle's force is based on mouse movement
		var force = PVector.sub(current, previous);
		force.mult(0.05);

		// Add new particle
		paths[paths.length - 1].add(current, force);

		// Store mouse values
		previous.x = current.x;
		previous.y = current.y;
	}

	// Draw all paths
	for (var i = 0; i < paths.length; i++) {
		paths[i].update();
		paths[i].display();
	}
}

// Start it up
function mousePressed() {
	next = 0;
	painting = true;
	previous.x = mouseX;
	previous.y = mouseY;
	paths.push(new Path());
}

// Stop
function mouseReleased() {
	painting = false;
}

// A Path is a list of particles
function Path() {
	this.particles = [];
};


Path.prototype.add = function (position, force) {
	// Add a new particle with a position, force, and hue
	this.particles.push(new Particle(position, force));
}

// Display plath
Path.prototype.update = function () {
	for (var i = 0; i < this.particles.length; i++) {
		this.particles[i].update();
	}
}

// Display plath
Path.prototype.display = function () {
	// Loop through backwards
	for (var i = this.particles.length - 1; i >= 0; i--) {
		// If we shold remove it
		if (this.particles[i].lifespan <= 0) {
			this.particles.splice(i, 1);
			// Otherwise, display it
		} else {
			this.particles[i].display(this.particles[i + 1]);
		}
	}
}

// Particles along the path
function Particle(position, force) {
	this.position = createVector(position.x, position.y);
	this.velocity = createVector(force.x, force.y);
	this.drag = 0.95;
	this.lifespan = 255;
}

Particle.prototype.update = function () {
	// Move it
	this.position.add(this.velocity);
	// Slow it down
	this.velocity.mult(this.drag);
	// Fade it out
	this.lifespan--;
}

// Draw particle and connect it with a line
// Draw a line to another
Particle.prototype.display = function (other) {
	stroke(0, this.lifespan);
	fill(0, this.lifespan / 2);
	circle(this.position.x, this.position.y, 8);
	// If we need to draw a line
	if (other) {
		line(this.position.x, this.position.y, other.position.x, other.position.y);
	}
}
