/*
 *  winable.h   Win32 accessibility functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

/* This file is retained solely for compatibility purposes.  For current versions of
 * Windows, the functions declared in this file are in winuser.h.  New code should not
 * use this header.
 */

#ifndef _WINABLE_
#define _WINABLE_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify accessibility functions */
#define WINABLEAPI  DECLSPEC_IMPORT

/* Windows event hook handle data type */
#if (WINVER < 0x0400)
typedef DWORD   HWINEVENTHOOK;
#endif

/* GUI thread information flags */
#if (WINVER < 0x0500)
    #define GUI_CARETBLINKING   0x00000001L
    #define GUI_INMOVESIZE      0x00000002L
    #define GUI_INMENUMODE      0x00000004L
    #define GUI_SYSTEMMENUMODE  0x00000008L
    #define GUI_POPUPMENUMODE   0x00000010L
#endif

/* Input types */
#if (_WIN32_WINNT < 0x0400)
    #define INPUT_MOUSE     0L
    #define INPUT_KEYBOARD  1L
    #define INPUT_HARDWARE  2L
#endif

/* Common object identifiers */
#if (WINVER < 0x0500)
    #define CHILDID_SELF    0
#endif

/* System object identifiers */
#if (WINVER < 0x0500)
    #define OBJID_WINDOW    0x00000000L
    #define OBJID_SYSMENU   0xFFFFFFFFL
    #define OBJID_TITLEBAR  0xFFFFFFFEL
    #define OBJID_MENU      0xFFFFFFFDL
    #define OBJID_CLIENT    0xFFFFFFFCL
    #define OBJID_VSCROLL   0xFFFFFFFBL
    #define OBJID_HSCROLL   0xFFFFFFFAL
    #define OBJID_SIZEGRIP  0xFFFFFFF9L
    #define OBJID_CARET     0xFFFFFFF8L
    #define OBJID_CURSOR    0xFFFFFFF7L
    #define OBJID_ALERT     0xFFFFFFF6L
    #define OBJID_SOUND     0xFFFFFFF5L
#endif

/* System alerts */
#if (WINVER < 0x0500)
    #define ALERT_SYSTEM_INFORMATIONAL  1L
    #define ALERT_SYSTEM_WARNING        2L
    #define ALERT_SYSTEM_ERROR          3L
    #define ALERT_SYSTEM_QUERY          4L
    #define ALERT_SYSTEM_CRITICAL       5L
    #define CALERT_SYSTEM               6L
#endif

/* SetWinEventHook() flags */
#if (WINVER < 0x0500)
    #define WINEVENT_OUTOFCONTEXT   0x00000000L
    #define WINEVENT_SKIPOWNTHREAD  0x00000001L
    #define WINEVENT_SKIPOWNPROCESS 0x00000002L
    #define WINEVENT_INCONTEXT      0x00000004L
#endif

/* Accessibility events */
#if (WINVER < 0x0500)
    #define EVENT_MIN                       0x00000001L
    #define EVENT_MAX                       0x7FFFFFFFL
    #define EVENT_SYSTEM_SOUND              0x00000001L
    #define EVENT_SYSTEM_ALERT              0x00000002L
    #define EVENT_SYSTEM_FOREGROUND         0x00000003L
    #define EVENT_SYSTEM_MENUSTART          0x00000004L
    #define EVENT_SYSTEM_MENUEND            0x00000005L
    #define EVENT_SYSTEM_MENUPOPUPSTART     0x00000006L
    #define EVENT_SYSTEM_MENUPOPUPEND       0x00000007L
    #define EVENT_SYSTEM_CAPTURESTART       0x00000008L
    #define EVENT_SYSTEM_CAPTUREEND         0x00000009L
    #define EVENT_SYSTEM_MOVESIZESTART      0x0000000AL
    #define EVENT_SYSTEM_MOVESIZEEND        0x0000000BL
    #define EVENT_SYSTEM_CONTEXTHELPSTART   0x0000000CL
    #define EVENT_SYSTEM_CONTEXTHELPEND     0x0000000DL
    #define EVENT_SYSTEM_DRAGDROPSTART      0x0000000EL
    #define EVENT_SYSTEM_DRAGDROPEND        0x0000000FL
    #define EVENT_SYSTEM_DIALOGSTART        0x00000010L
    #define EVENT_SYSTEM_DIALOGEND          0x00000011L
    #define EVENT_SYSTEM_SCROLLINGSTART     0x00000012L
    #define EVENT_SYSTEM_SCROLLINGEND       0x00000013L
    #define EVENT_SYSTEM_SWITCHSTART        0x00000014L
    #define EVENT_SYSTEM_SWITCHEND          0x00000015L
    #define EVENT_SYSTEM_MINIMIZESTART      0x00000016L
    #define EVENT_SYSTEM_MINIMIZEEND        0x00000017L
    #define EVENT_OBJECT_CREATE             0x00008000L
    #define EVENT_OBJECT_DESTROY            0x00008001L
    #define EVENT_OBJECT_SHOW               0x00008002L
    #define EVENT_OBJECT_HIDE               0x00008003L
    #define EVENT_OBJECT_REORDER            0x00008004L
    #define EVENT_OBJECT_FOCUS              0x00008005L
    #define EVENT_OBJECT_SELECTION          0x00008006L
    #define EVENT_OBJECT_SELECTIONADD       0x00008007L
    #define EVENT_OBJECT_SELECTIONREMOVE    0x00008008L
    #define EVENT_OBJECT_SELECTIONWITHIN    0x00008009L
    #define EVENT_OBJECT_STATECHANGE        0x0000800AL
    #define EVENT_OBJECT_LOCATIONCHANGE     0x0000800BL
    #define EVENT_OBJECT_NAMECHANGE         0x0000800CL
    #define EVENT_OBJECT_DESCRIPTIONCHANGE  0x0000800DL
    #define EVENT_OBJECT_VALUECHANGE        0x0000800EL
    #define EVENT_OBJECT_PARENTCHANGE       0x0000800FL
    #define EVENT_OBJECT_HELPCHANGE         0x00008010L
    #define EVENT_OBJECT_DEFACTIONCHANGE    0x00008011L
    #define EVENT_OBJECT_ACCELERATORCHANGE  0x00008012L
#endif

/* GUI thread information */
#if (WINVER < 0x0500)
typedef struct tagGUITHREADINFO {
    DWORD   cbSize;
    DWORD   flags;
    HWND    hwndActive;
    HWND    hwndFocus;
    HWND    hwndCapture;
    HWND    hwndMenuOwner;
    HWND    hwndMoveSize;
    HWND    hwndCaret;
    RECT    rcCaret;
} GUITHREADINFO;
typedef GUITHREADINFO   *PGUITHREADINFO;
typedef GUITHREADINFO   *LPGUITHREADINFO;
#endif

/* Mouse input information */
#if (_WIN32_WINNT < 0x0400)
typedef struct tagMOUSEINPUT {
    LONG        dx;
    LONG        dy;
    DWORD       mouseData;
    DWORD       dwFlags;
    DWORD       time;
    ULONG_PTR   dwExtraInfo;
} MOUSEINPUT;
typedef MOUSEINPUT  *PMOUSEINPUT;
typedef MOUSEINPUT  *LPMOUSEINPUT;
#endif

/* Keyboard input information */
#if (_WIN32_WINNT < 0x0400)
typedef struct tagKEYBDINPUT {
    WORD        wVk;
    WORD        wScan;
    DWORD       dwFlags;
    DWORD       time;
    ULONG_PTR   dwExtraInfo;
} KEYBDINPUT;
typedef KEYBDINPUT  *PKEYBDINPUT;
typedef KEYBDINPUT  *LPKEYBDINPUT;
#endif

/* Hardware input information */
#if (_WIN32_WINNT < 0x0400)
typedef struct tagHARDWAREINPUT {
    DWORD   uMsg;
    WORD    wParamL;
    WORD    wParamH;
} HARDWAREINPUT;
typedef HARDWAREINPUT   *PHARDWAREINPUT;
typedef HARDWAREINPUT   *LPHARDWAREINPUT;
#endif

/* Input information */
#if (_WIN32_WINNT < 0x0400)
typedef struct tagINPUT {
    DWORD   type;
    union {
        MOUSEINPUT      mi;
        KEYBDINPUT      ki;
        HARDWAREINPUT   hi;
    };
} INPUT;
typedef INPUT   *PINPUT;
typedef INPUT   *LPINPUT;
#endif

/* WinEvent hook callback */
#if (WINVER < 0x0500)
typedef VOID (CALLBACK *WINEVENTPROC)( HWINEVENTHOOK, DWORD, HWND, LONG, LONG, DWORD, DWORD );
#endif

/* Functions in USER32.DLL */
#if (WINVER < 0x0500)
WINABLEAPI BOOL WINAPI  GetGUIThreadInfo( DWORD, PGUITHREADINFO );
WINABLEAPI UINT WINAPI  GetWindowModuleFileNameA( HWND, LPSTR, UINT );
WINABLEAPI UINT WINAPI  GetWindowModuleFileNameW( HWND, LPWSTR, UINT );
WINABLEAPI VOID WINAPI  NotifyWinEvent( DWORD, HWND, LONG, LONG );
WINABLEAPI HWINEVENTHOOK WINAPI SetWinEventHook( DWORD, DWORD, HMODULE, WINEVENTPROC, DWORD, DWORD, DWORD );
WINABLEAPI BOOL WINAPI  UnhookWinEvent( HWINEVENTHOOK );
#endif
#if (_WIN32_WINNT < 0x0400)
WINABLEAPI UINT WINAPI  SendInput( UINT, LPINPUT, int );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define GetWindowModuleFileName GetWindowModuleFileNameW
#else
    #define GetWindowModuleFileName GetWindowModuleFileNameA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINABLE_ */
