
' ###########################################################################
' #                                                                         #
' #  EV4DE - Submission to Eevee's GAMES MADE QUICK??? 1                   #
' #  Copyright (C) 2017, OokiePigster <pig@ookiepigster.co.nz>              #
' #                                                                         #
' #  This program is free software: you can redistribute it and/or modify   #
' #  it under the terms of the GNU General Public License as published by   #
' #  the Free Software Foundation, either version 3 of the License, or      #
' #  (at your option) any later version.                                    #
' #                                                                         #
' #  This program is distributed in the hope that it will be useful,        #
' #  but WITHOUT ANY WARRANTY; without even the implied warranty of         #
' #  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          #
' #  GNU General Public License for more details.                           #
' #                                                                         #
' #  You should have received a copy of the GNU General Public License      #
' #  along with this program.  If not, see <http://www.gnu.org/licenses/>.  #
' #                                                                         #
' ###########################################################################
' #                                                                         #
' #  https://ookiepigster.itch.io/ev4de                                     #
' #                                                                         #
' ###########################################################################


DECLARE SUB AchievementsScreen ()
DECLARE SUB AddScore (points%)
DECLARE SUB ApplyMotion (motion AS ANY, position AS ANY)
DECLARE SUB ApplyScreenSettings ()
DECLARE SUB AutoDelay ()
DECLARE SUB BackgroundStars ()
DECLARE SUB CentrePrint (text$)
DECLARE SUB CheckUnlock (index%)
DECLARE SUB CompleteLevel ()
DECLARE SUB ConfirmQuit ()
DECLARE SUB CreateAsteroids (num%)
DECLARE SUB CreateCollectables ()
DECLARE SUB Delay (seconds!)
DECLARE SUB DoSound ()
DECLARE SUB DrawCollectable (kind%, x%, y%)
DECLARE SUB DrawModelPreview (model%, colour%, x%, y%)
DECLARE SUB DrawPlayer (model%, colour%, x%, y%, rot%, throttle!)
DECLARE SUB EditText (text$, key$, maxLength%)
DECLARE SUB ExplosionSound (speed%)
DECLARE SUB FirePlasma ()
DECLARE SUB GameOver ()
DECLARE SUB GetAchievement (id%)
DECLARE SUB LoadConfig ()
DECLARE SUB LoadHighScores ()
DECLARE SUB MainMenu ()
DECLARE SUB OnHitAsteroid ()
DECLARE SUB PauseGame ()
DECLARE SUB PickUpCollectable (kind%)
DECLARE SUB PutInRangeOfPlayer (position AS ANY, minDistance%, maxDistance%)
DECLARE SUB RandomTeleport ()
DECLARE SUB ReadJoystick (x!, y!)
DECLARE SUB RegisterScore (score%, gameType%)
DECLARE SUB Render ()
DECLARE SUB RenderAsteroid (asteroid AS ANY)
DECLARE SUB RenderCollectable (collectable AS ANY)
DECLARE SUB RenderGoal ()
DECLARE SUB RenderPlasmaBall (ball AS ANY)
DECLARE SUB RenderPlayer ()
DECLARE SUB RenderPointer ()
DECLARE SUB RenderStars ()
DECLARE SUB ResetHighScores ()
DECLARE SUB ResetPlayer ()
DECLARE SUB RunGame (gameType%)
DECLARE SUB SaveConfig ()
DECLARE SUB SaveHighScores ()
DECLARE SUB SettingsMenu ()
DECLARE SUB ShowEnding ()
DECLARE SUB ShowHighScores (gameType%, newIndex%)
DECLARE SUB ShowIntro ()
DECLARE SUB ShowNewAchievements ()
DECLARE SUB ShowTextScreen ()
DECLARE SUB SpawnAsteroid (asteroid AS ANY)
DECLARE SUB SpawnCollectable (collectable AS ANY)
DECLARE SUB SpawnPlasmaBall (ball AS ANY)
DECLARE SUB StartGame ()
DECLARE SUB StartLevel ()
DECLARE SUB TickAsteroid (asteroid AS ANY)
DECLARE SUB TickCollectable (collectable AS ANY)
DECLARE SUB TickPhysics ()
DECLARE SUB TickPlayer ()
DECLARE SUB UpdateScreen ()
DECLARE SUB UseCollectable ()
DECLARE SUB UserInput ()
DECLARE SUB WaitForKey ()
DECLARE SUB WaitForKeyAndRender ()
DECLARE FUNCTION Confirm% (question$, default%)
DECLARE FUNCTION Distance! (x1 AS SINGLE, y1 AS SINGLE, x2 AS SINGLE, y2 AS SINGLE)
DECLARE FUNCTION GetDateTime$ ()
DECLARE FUNCTION IsPressingKey% ()
DECLARE FUNCTION JoyButton% (n%)
DECLARE FUNCTION LPad$ (text$, size%)
DECLARE FUNCTION ToRadians! (degrees!)
DECLARE FUNCTION GetSystemDir$ ()


REM $DYNAMIC

DEFINT A-Z


TYPE TVec2D
    x AS SINGLE
    y AS SINGLE
END TYPE

TYPE TIntVec2D
    x AS INTEGER
    y AS INTEGER
END TYPE

TYPE TAsteroid
    position AS TVec2D
    motion AS TVec2D
    radius AS INTEGER
    exploding AS INTEGER
END TYPE

TYPE TPlayer
    position AS TVec2D
    motion AS TVec2D
    orientation AS SINGLE
    rotation AS SINGLE
    throttle AS SINGLE
    collectable AS INTEGER
    numCollectables AS INTEGER
    shields AS INTEGER
    keys AS INTEGER
END TYPE

TYPE TStar
    position AS TVec2D
    speed AS SINGLE
END TYPE

TYPE TCollectable
    position AS TVec2D
    kind AS INTEGER
END TYPE

TYPE TPlasmaBall
    position AS TVec2D
    motion AS TVec2D
    angle AS SINGLE
    time AS INTEGER
END TYPE

TYPE TScreenMode
    mode AS INTEGER
    size AS TIntVec2D
    charSize AS TIntVec2D
    terminalSize AS TIntVec2D
    flip AS INTEGER
    title AS STRING * 32
END TYPE

TYPE THighScore
    date AS STRING * 16
    score AS INTEGER
    player AS STRING * 14
END TYPE


CONST TRUE = -1
CONST FALSE = 0

CONST cPi = 3.141593
CONST cTau = cPi * 2
CONST cDegreesToRadians = 360 / cTau

CONST cIntroDuration = 3

CONST cMaxAsteroids = 64
CONST cAsteroidSpeed = 1
CONST cMinAsteroidRadius = 8
CONST cMaxAsteroidRadius = 32
CONST cMinAsteroidDistance = 320
CONST cMaxAsteroidDistance = 480
CONST cAsteroidExplodeTime = 32

CONST cTeleportMinDistance = cMaxAsteroidDistance + cMinAsteroidDistance
CONST cTeleportMaxDistance = cTeleportMinDistance + 256

CONST cMaxStars = 256

CONST cMaxCollectables = 4
CONST cCollectableRadius = 8
CONST cMinCollectableDistance = 384
CONST cMaxCollectableDistance = 768
CONST cCollectableCoolDown = .5
CONST cCollectableScore = 50
CONST cTimeBonusSeconds = 30

CONST cMaxPlasmaBalls = 4
CONST cPlasmaRadius = 8
CONST cPlasmaLifetime = 100
CONST cPlasmaSpeed = 4
CONST cPlasmaHitScore = 20

CONST cPlayerRadius = 22
CONST cStartingLives = 3
CONST cThrust = 1 / 16
CONST cRotationSpeed = .2

CONST cShieldRadius = cPlayerRadius + 12
CONST cShieldSpacing = 4

CONST cGoalRadius = 12
CONST cGoalDistanceBase = 512
CONST cGoalDistancePerLevel = 64
CONST cGoalBarrierRadius = 32
CONST cGoalBarrierSpacing = 16

CONST cNumHighScores = 16
CONST cScoreNameMaxLength = 14

CONST cNumScreenModes = 2
CONST cPlasmaGameDuration = 60 * 2
CONST cModelPreviewRotateSpeed = 90
CONST cLevelsPerUnlock = 3
CONST cNumBackgroundStars = 192

CONST cCollectableOneUp = 1
CONST cCollectableShield = 2
CONST cCollectablePlasma = 3
CONST cCollectableTeleport = 4
CONST cCollectableTime = 5
CONST cCollectableKey = 6
CONST cNumCollectables = 6

CONST cGameTypeStandard = 0
CONST cGameTypePlasma = 1
CONST cGameTypeDistance = 2
CONST cNumGameTypes = 3

CONST cModelDefault = 0
CONST cModelSpacePlane = 1
CONST cModelMunOrBust = 2
CONST cModelShuttle = 3
CONST cModelStingRay = 4
CONST cModelUFO = 5
CONST cModelEscapeCaptule = 6
CONST cModelLander = 7
CONST cModelN64 = 8
CONST cModelSatellite = 9
CONST cModelTieFighter = 10
CONST cModelTARDIS = 11
CONST cNumModels = 12


ON ERROR GOTO eDefault


DIM SHARED gAsteroids(cMaxAsteroids - 1) AS TAsteroid
DIM SHARED gNAsteroids AS INTEGER
DIM SHARED gCollectables(cMaxCollectables - 1) AS TCollectable
DIM SHARED gStars(cMaxStars - 1) AS TStar
DIM SHARED gPlasmaBalls(cMaxPlasmaBalls - 1) AS TPlasmaBall
DIM SHARED gPlayer AS TPlayer
DIM SHARED gGoal AS TVec2D
DIM SHARED gGoalBarriers AS INTEGER

DIM SHARED gTick AS LONG
DIM SHARED gQuit AS INTEGER

DIM SHARED gLevel AS INTEGER
DIM SHARED gLevelComplete AS INTEGER
DIM SHARED gLives AS INTEGER
DIM SHARED gScore AS INTEGER
DIM SHARED gScoreAdd AS INTEGER
DIM SHARED gIsExploding AS INTEGER
DIM SHARED gPaused AS INTEGER
DIM SHARED gGameType AS INTEGER
DIM SHARED gPlayerRadius AS INTEGER
DIM SHARED gTimeRemaining AS INTEGER

DIM SHARED gScreenSize AS TIntVec2D
DIM SHARED gRealScreenSize AS TIntVec2D
DIM SHARED gTerminalSize AS TIntVec2D
DIM SHARED gCharSize AS TIntVec2D
DIM SHARED gScreenModes(cNumScreenModes - 1) AS TScreenMode
DIM SHARED gScreenMode AS INTEGER

DIM SHARED gShades(3) AS INTEGER
DIM SHARED gCollectableSprites(1 TO cNumCollectables, 0 TO 7) AS INTEGER
DIM SHARED gModelNames(cNumModels - 1) AS STRING
DIM SHARED gColourNames(15) AS STRING
DIM SHARED gGameTypeNames(cNumGameTypes - 1) AS STRING

DIM SHARED gJoysticksEnabled AS INTEGER
DIM SHARED gJoyButtonsEnabled AS INTEGER
DIM SHARED gErr AS INTEGER
DIM SHARED gStatusText AS STRING
DIM SHARED gBackgroundStars(cNumBackgroundStars - 1) AS TStar
DIM SHARED gFPS AS SINGLE
DIM SHARED gShowFPS AS INTEGER

DIM SHARED gUnlock AS INTEGER
DIM SHARED gHighScores(cNumGameTypes - 1, cNumHighScores - 1) AS THighScore

DIM SHARED gEnableSound AS INTEGER
DIM SHARED gIncrementalThrottle AS INTEGER
DIM SHARED gPlayerModel AS INTEGER
DIM SHARED gPlayerColour AS INTEGER
DIM SHARED gInvertXAxis AS INTEGER
DIM SHARED gInvertYAxis AS INTEGER
DIM SHARED gSwapJoyButtons AS INTEGER
DIM SHARED gDeadzones AS INTEGER
DIM SHARED gEnableBackgroundStars AS INTEGER


' Joysticks are disabled initially, because absent joysticks can return
' arbitrary results. Joysticks are automatically enabled when they are seen
' behaving reasonably.
gJoysticksEnabled = FALSE
gJoyButtonsEnabled = FALSE

gIsExploding = FALSE

gEnableSound = TRUE
gScreenMode = 0
gIncrementalThrottle = FALSE
gUnlocked = 0
gPlayerModel = cModelDefault
gPlayerColour = 2
gInvertXAxis = FALSE
gInvertYAxis = FALSE
gSwapJoyButtons = FALSE
gDeadzones = 10
gEnableBackgroundStars = TRUE

gShades(0) = 0
gShades(1) = 8
gShades(2) = 7
gShades(3) = 15

gGameTypeNames(cGameTypeStandard) = "Standard"
gGameTypeNames(cGameTypePlasma) = "Target Practice"
gGameTypeNames(cGameTypeDistance) = "Distance Challenge"

gModelNames(cModelDefault) = "Default"
gModelNames(cModelSpacePlane) = "Space Plane"
gModelNames(cModelMunOrBust) = "M" + CHR$(129) + "n or Bust"
gModelNames(cModelShuttle) = "Space Shuttle"
gModelNames(cModelStingRay) = "StingRay"
gModelNames(cModelUFO) = "Flying Saucer"
gModelNames(cModelEscapeCaptule) = "Escape Captule"
gModelNames(cModelLander) = "Lander"
gModelNames(cModelN64) = "StarFighter 64"
gModelNames(cModelSatellite) = "Satellite"
gModelNames(cModelTieFighter) = "TIE Fighter"
gModelNames(cModelTARDIS) = "TARDIS"


' Load collectable sprites:
RESTORE dCollectableSprites
FOR i = 1 TO cNumCollectables
    FOR j = 0 TO 7
        READ gCollectableSprites(i, j)
    NEXT
NEXT

' Load screen modes:
RESTORE dScreenModes
FOR i = 0 TO cNumScreenModes - 1
    READ gScreenModes(i).mode
    READ gScreenModes(i).size.x, gScreenModes(i).size.y
    READ gScreenModes(i).flip
    READ gScreenModes(i).charSize.x, gScreenModes(i).charSize.y
    READ gScreenModes(i).terminalSize.x, gScreenModes(i).terminalSize.y
    READ gScreenModes(i).title
NEXT

' Load colour names:
RESTORE dColourNames
FOR i = 0 TO 15
    READ gColourNames(i)
NEXT


FOR i = 0 TO cNumBackgroundStars - 1
    gBackgroundStars(i).speed = -1
NEXT


LoadConfig
ApplyScreenSettings

ResetHighScores
LoadHighScores

IF gUnlock >= cNumModels THEN gUnlock = cNumModels - 1


' Randomise background stars:
FOR i = 0 TO cMaxStars - 1
    gStars(i).position.x = RND
    gStars(i).position.y = RND
    gStars(i).speed = .25 + RND * .75
NEXT

RANDOMIZE TIMER


ShowIntro
MainMenu
ShowEnding
END


dMainMenu:
    DATA 8
    DATA PLAY,     Start Game
    DATA PLASMA,   Target Practice
    DATA DISTANCE, Distance Challange
    DATA HELP,     Instructions
    DATA SETTINGS, Settings
    DATA SCORES,   High Scores
    DATA LEGAL,    License
    DATA EXIT,     Quit to DOS


dScreenModes:
    ' Screen modes without flipping are disabled to prevent seizures.
    '    ID:      Height: CharX: TermX:  Name
    '        Width:    Flip: CharY:  TermY:
    DATA 7,  320, 200, 1, 8, 8,  40, 25, "320x200"
    'DATA 7,  320, 200, 0, 8, 8,  40, 25, "320x200 (No screen flipping)"
    DATA 9,  640, 350, 1, 8, 14, 80, 25, "640x350"
    'DATA 9,  640, 350, 0, 8, 14, 80, 25, "640x350 (No screen flipping)"
    'DATA 12, 640, 480, 0, 8, 16, 80, 30, "640x480 (No screen flipping)"

    'DATA 8,  640, 200, -1, 8, 8,  80, 25, "640x200"
    'DATA 1,  320, 200,  0, 8, 8,  80, 25, "320x200 (Monochrome, no flipping)"


dColourNames:
    DATA Black, Navy, Green, Teal, Red,       Purple,  Brown,  Silver
    DATA Grey,  Blue, Lime,  Aqua, Light Red, Fuchsia, Yellow, White


dLicense:
    DATA "$EV4DE"
    DATA "$"
    DATA "$Copyright (C) 2017, OokiePigster"
    DATA "$<pig@ookiepigster.co.nz>"
    DATA "$"
    DATA "$This program is free software: you can"
    DATA "$redistribute it and/or modify it under"
    DATA "$the terms of the GNU General Public"
    DATA "$License as published by the Free"
    DATA "$Software Foundation, either version 3"
    DATA "$of the License, or (at your option)"
    DATA "$any later version."
DATA PAGE
    DATA "$This program is distributed in the"
    DATA "$hope that it will be useful, but"
    DATA "$WITHOUT ANY WARRANTY; without even the"
    DATA "$implied warranty of MERCHANTABILITY or"
    DATA "$FITNESS FOR A PARTICULAR PURPOSE.  See"
    DATA "$the GNU General Public License for"
    DATA "$more details."
    DATA "$"
    DATA "$You should have received a copy of the"
    DATA "$GNU General Public License along with"
    DATA "$this program.  If not, see"
    DATA "$<http://www.gnu.org/licenses/>."
    DATA "$"
    DATA "$The source code is available at"
    DATA "$<https://ookiepigster.itch.io/ev4de>."
DATA END


dInstructions:
    DATA "$- INSTRUCTIONS -"
    DATA "$"
    DATA "$Your job is to pilot a ship through"
    DATA "$space, while avoiding all of the"
    DATA "$asteroids."
    DATA "$"
    DATA "$To accelerate, activate the engine"
    DATA "$while facing forwards. To"
    DATA "$decelerate, activate the engine while"
    DATA "$facing backwards."
    DATA "$"
    DATA "$Remember that there's no atmospheric"
    DATA "$drag in space, so you'll keep moving"
    DATA "$or rotating until you push the other"
    DATA "$way."
    DATA "$"
    DATA "$Follow the yellow line to find the"
    DATA "$end of the level."
DATA PAGE
    DATA "$- CONTROLS -"
    DATA "$"
    DATA "$Use W, UP, or JOYSTICK UP to control"
    DATA "$the throttle and push your velocity"
    DATA "$vector in the direction you're facing."
    DATA "$"
    DATA "$Use A, LEFT, or JOYSTICK LEFT to"
    DATA "$rotate the ship anti-clockwise.
    DATA "$"
    DATA "$Use D, RIGHT, or JOYSTICK RIGHT to
    DATA "$rotate the ship clockwise.
    DATA "$"
    DATA "$Use SPACE or JOYSTICK TOP BUTTON to"
    DATA "$activate a power-up."
    DATA "$"
    DATA "$Use P or JOYSTICK BOTTOM BUTTON"
    DATA "$to pause the game."
    DATA "$"
    DATA "$For the best experience, use an"
    DATA "$analogue joystick with two buttons."
DATA PAGE
    DATA "$- COLLECTABLES -"
    DATA "$"
    DATA "$Touch these items to pick them up."
    DATA "$"
    DATA "C1"
    DATA "$Gives you an extra life."
    DATA "$"
    DATA "C2"
    DATA "$Gives you a force field."
    DATA "$"
    DATA "C3"
    DATA "$Gives you a plasma ball to shoot"
    DATA "$at asteroids."
DATA PAGE
    DATA "$- COLLECTABLES CONTINUED -"
    DATA "$"
    DATA "C4"
    DATA "$Activate this to teleport to a"
    DATA "$random location."
    DATA "$"
    DATA "C5"
    DATA "$Touch this in Target Practice mode"
    DATA "$to get a time bonus."
    DATA "$"
    DATA "C6"
    DATA "$Use this to unlock the red barrier"
    DATA "$at the end of some levels."
DATA PAGE
    DATA "$- GAME TYPES -"
    DATA "$"
    DATA "$STANDARD:"
    DATA "$Fly the ship to the yellow circle"
    DATA "$to progress to the next level."
    DATA "$"
    DATA "$TARGET PRACTICE:"
    DATA "$Blow up as many asteroids as you"
    DATA "$can with plasma balls in two"
    DATA "$minutes."
    DATA "$"
    DATA "$DISTANCE CHALLANGE:"
    DATA "$Fly as far as you can in one direction"
    DATA "$without dying."
DATA END


dCollectableSprites:
    ' One-up:
    DATA 0, 4, 12, 36, 116, 36, 14, 0
    ' Shield:
    DATA 60, 195, 129, 129, 66, 66, 36, 24
    ' Plasma ball:
    DATA 102, 129, 153, 36, 36, 153, 129, 102
    ' Teleport:
    DATA 18, 148, 64, 3, 192, 2, 41, 72
    ' Time bonus:
    DATA 60, 126, 223, 235, 247, 255, 126, 60
    ' Key:
    DATA 0, 2, 5, 253, 69, 2, 0, 0
    ' ???:
    DATA 255, 129, 129, 129, 129, 129, 129, 255

eHandle:
    gErr = ERR
RESUME NEXT


eDefault:
    SCREEN 0
    WIDTH 80, 25
    COLOR 7, 0
    CLS
    PRINT
    PRINT " Fatal error!"
    PRINT
    PRINT "  Error code:"; ERR
    PRINT
    PRINT "  Contact ";
    COLOR 9
    PRINT "@OokiePigster";
    COLOR 7
    PRINT " on Twitter for help."
    PRINT
END

REM $STATIC
SUB AddScore (points)
    IF gGameType = cGameTypeDistance THEN EXIT SUB
    gScoreAdd = gScoreAdd + points
END SUB

SUB ApplyMotion (motion AS TVec2D, position AS TVec2D)
    position.x = position.x + motion.x
    position.y = position.y + motion.y
END SUB

SUB ApplyScreenSettings
    DIM mode AS TScreenMode

    mode = gScreenModes(gScreenMode)

    gRealScreenSize = mode.size
    gCharSize = mode.charSize
    gScreenSize.x = mode.size.x
    gScreenSize.y = mode.size.y - gCharSize.y
    gTerminalSize = mode.terminalSize

    IF mode.flip THEN flipPage = 1 ELSE flipPage = 0

    SCREEN mode.mode, 0, 0, flipPage
    WIDTH mode.terminalSize.x, mode.terminalSize.y
    VIEW PRINT 1 TO mode.terminalSize.y
END SUB

SUB AutoDelay
    CONST cTargetFPS = 25
    CONST cTicksPerCheck = 8
    CONST cDefaultSleep = 20
   
    STATIC sSleep
    STATIC sCounter
    STATIC sInitialised
    STATIC sLastTime AS DOUBLE

    IF NOT sInitialised THEN
        sInitialised = TRUE
        sSleep = cDefaultSleep
    END IF

    sCounter = sCounter + 1
    IF sCounter >= cTicksPerCheck THEN
        sCounter = 0
        elapsed! = TIMER - sLastTime
        sLastTime = TIMER
        gFPS = cTicksPerCheck / elapsed!
        IF gFPS > cTargetFPS * 1.5 THEN
            sSleep = sSleep * 2
        END IF
        IF gFPS > cTargetFPS THEN
            sSleep = sSleep + 1
        ELSE
            sSleep = sSleep - 1
        END IF
    END IF

    IF sSleep < 0 THEN sSleep = 0

    FOR i = 0 TO sSleep
        FOR j = 0 TO 2000
        NEXT
    NEXT
END SUB

SUB BackgroundStars
    STATIC sReset

    IF NOT gEnableBackgroundStars THEN EXIT SUB
    FOR i = 0 TO cNumBackgroundStars - 1
        z = (gBackgroundStars(i).speed * .2) ^ 3
        x = gScreenSize.x \ 2 + gBackgroundStars(i).position.x * z
        y = gScreenSize.y \ 2 + gBackgroundStars(i).position.y * z
        IF (gBackgroundStars(i).speed < 0) OR (x < 0) OR (y < 0) OR (x >= gScreenSize.x) OR (y >= gRealScreenSize.y) THEN
            gBackgroundStars(i).speed = 12
            angle! = RND * cTau
            'gBackgroundStars(i).position.x = SIN(angle!) * RND * 4
            'gBackgroundStars(i).position.y = COS(angle!) * RND * 4
            gBackgroundStars(i).position.x = RND - .5
            gBackgroundStars(i).position.y = RND - .5
        ELSE
            PSET (x, y), 15
            gBackgroundStars(i).speed = gBackgroundStars(i).speed + 1
        END IF
    NEXT

    ' Probably best not to look at this.
    sReset = sReset + 1
    IF sReset >= cNumBackgroundStars THEN sReset = 0
    gBackgroundStars(sReset).speed = -1
END SUB

SUB CentrePrint (text$)
    PRINT SPACE$((gTerminalSize.x - LEN(text$)) / 2) + text$;
END SUB

SUB CheckUnlock (index)
    IF index >= cNumModels THEN
        index = cNumModels - 1
    END IF
    IF index <= gUnlock THEN
        EXIT SUB
    END IF
    FOR i = gUnlock + 1 TO index
        DO: LOOP WHILE IsPressingKey
        DO
            COLOR 15
            CLS
            LOCATE 2, 1
            CentrePrint "New ship unlocked:"
            LOCATE 4, 1
            CentrePrint gModelNames(i)
            LOCATE gTerminalSize.y - 2, 1
            CentrePrint "Press any key to continue..."
            DrawModelPreview i, gPlayerColour, gRealScreenSize.x \ 2, gRealScreenSize.y \ 2
            UpdateScreen
        LOOP UNTIL IsPressingKey
        DO: LOOP WHILE IsPressingKey
    NEXT
    gUnlock = index
    SaveConfig
END SUB

SUB CompleteLevel
    gLevelComplete = TRUE
    WaitForKeyAndRender
    gLevelComplete = FALSE

    CheckUnlock gLevel \ cLevelsPerUnlock

    AddScore gLevel * 10
    gLevel = gLevel + 1
    StartLevel
END SUB

FUNCTION Confirm (question$, default)
    sel = default <> 0
    enter = FALSE
    usingJoystick = FALSE

    DO: LOOP WHILE IsPressingKey

    DO UNTIL enter
        CLS
        COLOR 15
        LOCATE 11, 1
        CentrePrint question$
        LOCATE 13, gTerminalSize.x / 2 - 1
        PRINT "Yes"
        LOCATE 14, gTerminalSize.x / 2 - 1
        PRINT "No"
        LOCATE 14 + sel, gTerminalSize.x / 2 - 3
        COLOR 14
        PRINT ">"
        UpdateScreen

        SELECT CASE INKEY$
            CASE "w", "s", "a", "d", CHR$(0) + "H", CHR$(0) + "P", CHR$(0) + "K", CHR$(0) + "M"
                sel = NOT sel
            CASE " ", CHR$(13)
                enter = TRUE
            CASE CHR$(27)
                sel = default
                enter = TRUE
            CASE "y"
                sel = TRUE
                enter = TRUE
            CASE "n"
                sel = FALSE
                enter = FALSE
        END SELECT

        ReadJoystick joyX!, joyY!
        IF (ABS(joyX!) > .5) OR (ABS(joyY!) > .5) THEN
            IF NOT usingJoystick THEN
                sel = NOT sel
                usingJoystick = TRUE
            END IF
        ELSE
            usingJoystick = FALSE
        END IF
        IF JoyButton(0) OR JoyButton(1) THEN
            enter = TRUE
        END IF
    LOOP

    ' Wait until there are no keys or triggers, to avoid interacting with
    ' something else:
    DO: LOOP WHILE IsPressingKey

    Confirm = sel
END FUNCTION

SUB ConfirmQuit
    IF Confirm("Do you really want to quit?", FALSE) THEN
        gQuit = TRUE
    END IF
END SUB

SUB CreateAsteroids (num)
    gNAsteroids = num
    FOR i = 0 TO gNAsteroids - 1
        SpawnAsteroid gAsteroids(i)
    NEXT
END SUB

SUB CreateCollectables
    FOR i = 0 TO cMaxCollectables - 1
        SpawnCollectable gCollectables(i)
    NEXT
END SUB

SUB Delay (seconds!)
    start# = TIMER
    DO: LOOP UNTIL TIMER >= start# + seconds!
END SUB

FUNCTION Distance! (x1 AS SINGLE, y1 AS SINGLE, x2 AS SINGLE, y2 AS SINGLE)
    Distance! = ((ABS(x1 - x2) ^ 2) + (ABS(y1 - y2) ^ 2)) ^ .5
END FUNCTION

SUB DrawCollectable (kind, posX, posY)
    SELECT CASE kind
        CASE cCollectableOneUp
            colour = 2
        CASE cCollectableShield
            colour = 3
        CASE cCollectablePlasma
            colour = 4
        CASE cCollectableTeleport
            colour = 9
        CASE cCollectableTime
            colour = 11
        CASE cCollectableKey
            colour = 14
        CASE ELSE
            colour = 8
    END SELECT
    'CIRCLE (posX, posY), 6, colour, , , 1
    LINE (posX - 5, posY - 6)-STEP(9, 0), colour
    LINE (posX - 6, posY - 5)-STEP(0, 9), colour
    LINE (posX - 5, posY + 5)-STEP(9, 0), colour
    LINE (posX + 5, posY - 5)-STEP(0, 9), colour
    FOR x = 0 TO 7
        FOR y = 0 TO 7
            IF gCollectableSprites(kind, y) AND (2 ^ x) THEN
                PSET (posX + 3 - x, posY + y - 4), colour
            END IF
        NEXT
    NEXT
END SUB

SUB DrawModelPreview (model, colour, x, y)
    DrawPlayer model, colour, x, y, (TIMER * cModelPreviewRotateSpeed) MOD 360, .5 + SIN(TIMER * cPi) / 2
END SUB

SUB DrawPlayer (model, colour, x, y, rot, throttle!)
    ' Prepare to draw:
    DRAW "BM" + STR$(x) + "," + STR$(y)
    DRAW "C" + STR$(colour) + " TA" + STR$(rot)
    exhaust = (throttle! * 16 - 1) * (RND * .3 + .7)

    SELECT CASE model
        CASE cModelDefault
            ' Frame:
            DRAW "BU24  M+8,+4  M+4,+8  D32  M-4,+4  M-16,+0  M-4,-4  U32  M+4,-8  M+8,-4"
            ' Windscreen:
            DRAW "BM-4,+8  G4  D4  R16  U4  H4  L8"
            ' Left engine:
            DRAW "BM-16,+4  F4  D20  L8  U20  E4"
            ' Right engine:
            DRAW "BR40  F4  D20  L8  U20  E4"
            ' Engine connections:
            DRAW "BM-36,+12  R4  BD4  L4  BR28  R4  BU4  L4"
            ' Engine exhaust:
            DRAW "BM+8,+13"
            GOSUB sDrawExhaust
            DRAW "BL40"
            GOSUB sDrawExhaust

        CASE cModelSpacePlane
            ' Frame:
            DRAW "BU32  M+4,+4  M+4,+8  D36  L16  U36  M+4,-8  M+4,-4"
            ' Cockpit:
            DRAW "BD8  M+4,+8  D4  M-4,+4  M-4,-4  U4  M+4,-8"
            ' Wing tips:
            DRAW "BM-8,+32  M-16,+8  L8  U24  M+4,-8  M+4,+8  D24"
            DRAW "BM+32,-8  M+16,+8  R8  U24  M-4,-8  M-4,+8  D24"
            ' Wing fronts:
            DRAW "BU16  H16  BL16 G16"
            ' Exhaust:
            DRAW "BM-4,+17"
            GOSUB sDrawExhaust
            DRAW "BR56"
            GOSUB sDrawExhaust

        CASE cModelMunOrBust
            ' Parachute:
            DRAW "BU28  M+6,+2  F2  L16 E2  M+6,-2"
            ' Pod:
            DRAW "BM-8,+4  M-10,+16  R36  M-10,-16"
            ' Windows:
            DRAW "BD4   M+2,+4  L4  M-2,-4  R4"
            DRAW "BL12  M-2,+4  L4  M+2,-4  R4"
            ' Decoupler:
            DRAW "BM-14,+16  R36  BL16  U4  BL4  D4"
            ' Fuel tank:
            DRAW "BM-16,-4  D28  R36  U28"
            ' Engine:
            DRAW "BM-30,+28  D2  F2  R2  E2  BH2  F4  R8  E4"
            DRAW "BM-10,+4  M-2,+4  R8  M-2,-4  BM-2,+5"
            GOSUB sDrawExhaust

        CASE cModelShuttle
            ' Frame:
            DRAW "BU24  F4  M+4,+8  D32  L16  U32  M+4,-8  E4"
            ' Windscreen:
            DRAW "BD8  F4  L2  H2  G2  L2  E4"
            ' Wings:
            DRAW "BM-8,+4  M-4,+12  M-16,+12  D4  R20"
            DRAW "BR16 R20  U4  M-16,-12  M-4,-12"
            ' Flaps:
            DRAW "BM-36,+28  M+20,+4  BR16  M+20,-4"
            ' Tail:
            DRAW "BM-28,-4  D12"
            ' Engines:
            DRAW "BM-6,-4  M-2,+4  R8  M-2,-4  BR4  M-2,+4  R8  M-2,-4"
            ' Exhaust:
            DRAW "BM-10,+5"
            GOSUB sDrawExhaust
            DRAW "BR8"
            GOSUB sDrawExhaust

        CASE cModelStingRay
            ' Frame:
            DRAW "BU26  M+4,+2  F4  M+4,+8  F4  BD16  M-8,+4  G4  M-4,+8"
            DRAW "BU50  M-4,+2  G4  M-4,+8  G4  BD16  M+8,+4  F4  M+4,+8"
            ' Windscreen:
            DRAW "BU44  F4  D4  H4  G4  U4  E4"
            ' Left booster:
            DRAW "BM-22,+1  M+2,+1  F2  M+2,+4  D24  M-2,+8  L8  M-2,-8  U24  M+2,-4  E2  M+2,-1"
            ' Right booster:
            DRAW "BR44      M+2,+1  F2  M+2,+4  D24  M-2,+8  L8  M-2,-8  U24  M+2,-4  E2  M+2,-1"
            ' Exhaust:
            DRAW "BD40"
            GOSUB sDrawExhaust
            DRAW "BL44"
            GOSUB sDrawExhaust

        CASE cModelUFO
            ' Outer circle:
            DRAW "BU24  M+12,+4  F8  M+4,+12  M-4,+12  BG8  M-12,+4  M-12,-4  BH8  M-4,-12  M+4,-12  E8  M+12,-4"
            ' Inner circle:
            DRAW "BD12  M+8,+4  M+4,+8  M-4,+8  M-8,+4  M-8,-4  M-4,-8  M+4,-8  M+8,-4"
            ' Engines:
            DRAW "BM-16,+20  F4  D12  L8  U12  E4"
            DRAW "BR32       F4  D12  L8  U12  E4"
            DRAW "BM-32,+17"
            GOSUB sDrawExhaust
            DRAW "BR32"
            GOSUB sDrawExhaust

        CASE cModelEscapeCaptule
            ' Pod:
            DRAW "BM-8,-20  E4  M+4,-1  M+4,+1  F4  M+16,+24  L48  M+16,-24  R16"
            ' Window:
            DRAW "BM-4,+8  L8  M-2,+8  R12  M-2,-8"
            ' Base:
            DRAW "BM-28,+16  D12  M+1,+3  M+3,+1  R40  M+3,-1  M+1,-3  U12"
            ' Base markings:
            DRAW "BD12  L48  BM+8,-12  G8  BF4  E12  BM-4,+12  E12  BM-4,+12  E12  BM-4,+12  E12  BM-4,+12  E12  BM-4,+12  E4"
            ' Engine:
            DRAW "BM-16,+8  G4  L8  H4"
            DRAW "BM+6,+4  M-2,+4  R8  M-2,-4  BM-2,+5"
            GOSUB sDrawExhaust

        CASE cModelLander
            ' Pod:
            DRAW "BM+20,-24  L40  M+8,-4  R24  M+8,+4  D16  L40  U16"
            ' Windows:
            DRAW "BM+12,+4  M+3,+1  M+1,+3  M-1,+3  M-3,+1  M-3,-1  M-1,-3  M+1,-3  M+3,-1"
            DRAW "BR16      M+3,+1  M+1,+3  M-1,+3  M-3,+1  M-3,-1  M-1,-3  M+1,-3  M+3,-1"
            ' Middle bit:
            DRAW "BM-28,+12  M+8,+4  R24  M+8,-4"
            DRAW "BM-27,+4  D4  BR16  U4"
            DRAW "G6  BM+2,-6  G6  BM+2,-6  G6  BM+2,-6  G4  BF2  R12"
            ' Fuel tanks:
            DRAW "BG2   E4  M+6,-2  M+6,+2  F4  D12  L20  U12  R20"
            DRAW "BL48  E4  M+6,-2  M+6,+2  F4  D12  L20  U12  R20"
            DRAW "BM-4,+12  D4  R16  U4"
            ' Engines:
            DRAW "BL28      F4  R4  E4  BM-8,+4  M-2,+4  R8  M-2,-4"
            DRAW "BM+20,-4  F4  R4  E4  BM-8,+4  M-2,+4  R8  M-2,-4"
            DRAW "BL22  M+2,+4  R8  M+2,-4  BM-8,+4  M-2,+4  R8  M-2,-4"
            ' Exhaust:
            DRAW "BM-16,+1"
            GOSUB sDrawExhaust
            DRAW "BR28"
            GOSUB sDrawExhaust
            DRAW "BM-14,+4"
            exhaust = (exhaust - 4) * 1.2
            GOSUB sDrawExhaust

        CASE cModelN64
            ' Main body:
            DRAW "BD26  R4  M+7,-2  M+1,-3  M+8,-1  M+5,-4  M+1,-4  D4  M-2,-4  M-4,-3  M-4,-1  L4  M-3,-1  M-1,-3  M-1,-4  M-1,-8  M-3,-10  M-3,-2"
            DRAW "BD46  L4  M-7,-2  M-1,-3  M-8,-1  M-5,-4  M-1,-4  D4  M+2,-4  M+4,-3  M+4,-1  R4  M+3,-1  M+1,-3  M+1,-4  M+1,-8  M+3,-10  M+3,-2"

            ' Windows:
            DRAW "BD8  M-3,+4  M-1,+4  F1  R6  E1  M-1,-4  M-3,-4"
            DRAW "BM-24,+8  M-2,+4  R6  M-2,-4  L2"
            DRAW "BR46      M-2,+4  R6  M-2,-4  L2"

            ' Side pods:
            DRAW "BM-6,+12  M+4,-14  E2  R2  F2  M+2,+10  D4  M-2,+8"
            DRAW "BM-42,-8  M-4,-14  H2  L2  G2  M-2,+10  D4  M+2,+8"

            ' Logo:
            DRAW "BM+20,+4  E2  R8  F2  G2  L8  H2"

            ' Exhaust:
            DRAW "BM+22,+1"
            GOSUB sDrawExhaust
            DRAW "BL32"
            GOSUB sDrawExhaust

        CASE cModelSatellite
            ' Probe core:
            DRAW "BU24  M+8,+4  M+4,+8  M-4,+8  M-8,+4  M-8,-4  M-4,-8  M+4,-8  M+8,-4"
            ' Body:
            DRAW "BM-8,+20  D28  R16  U28"
            ' Solar panels:
            DRAW "BD12  R4  U12  R16  D24  L16  U12"
            DRAW "BL20  L4  U12  L16  D24  R16  U12"
            ' Engine:
            DRAW "BM+6,+16  M+2,+4  R8  M+2,-4  BM-8,+4  M-2,+4  R8  M-2,-4"
            ' Exhaust:
            DRAW "BM-2,+5"
            GOSUB sDrawExhaust
            ' Satellite dish:
            DRAW "C" + STR$(colour) + "BU57  TA+" + STR$(INT(rot + SIN(TIMER * 2) * 45) MOD 360) + "  M-4,-2  H2  R12  G2  M-4,+2  BU4  U6"

        CASE cModelTieFighter
            ' Pod:
            DRAW "BM-4,-8  M+4,+1  M+4,-1  F4  M+1,+4  M-1,+4  G4  M-4,+1  M-4,-1  H4  M-1,-4  M+1,-4  E4  M+4,-1  M+4,+1"
            ' Sides:
            DRAW "BL20  M-4,-16  M-4,+12  D24  M+4,+12  M+4,-16  U6  BU4  U6"
            DRAW "BR32  M+4,-16  M+4,+12  D24  M-4,+12  M-4,-16  U6  BU4  U6"
            ' Connections:
            DRAW "BM-36,+6  R8  M+4,-2  BD8  M-4,-2  L8"
            DRAW "BR40      L8  M-4,+2  BU8  M+4,+2  R8"
            ' Exhaust:
            'DRAW "BM-20,+11"
            'GOSUB sDrawExhaust

        CASE cModelTARDIS
            ' Frame:
            DRAW "BM-16,+20  U40  L1  U4  R34  D4  L1  D40  BL16  U40  BR16  L32"
            ' Windows:
            DRAW "BM+3,+4  R10  D8  L10  U8"
            DRAW "BR16     R10  D8  L10  U8"
            ' Sign:
            DRAW "BM-15,+14  D6  R8  U6  L8"
            ' Base:
            DRAW "BM-8,+22  R40  D4  L40  U4"
            ' Light:
            IF exhaust > 0 THEN
                DRAW "C" + MID$("8 7 157 8", ((TIMER * 6) MOD 5) * 2 + 1, 2)
            ELSE
                DRAW "C6"
            END IF
            DRAW "BM+19,-45  U3  R2  D3"

        CASE ELSE
            DRAW "U16 C4  U16"
            
    END SELECT

EXIT SUB

sDrawExhaust:
    IF (exhaust < 0) OR gLevelComplete THEN RETURN
    DRAW "C14  BL4  M+4,+" + STR$(exhaust) + "  M+4,-" + LTRIM$(STR$(exhaust)) + "BL4"
RETURN

END SUB

SUB EditText (text$, key$, maxLength)
    SELECT CASE key$
        CASE ""
        CASE CHR$(8)
            IF LEN(text$) THEN
                text$ = LEFT$(text$, LEN(text$) - 1)
            END IF
        CASE ELSE
            text$ = text$ + key$
    END SELECT
    IF LEN(text$) > maxLength THEN
        text$ = LEFT$(text$, maxLength)
    END IF
END SUB

SUB ExplosionSound (speed)
    IF NOT gEnableSound THEN EXIT SUB
    FOR i = 600 TO 0 STEP -speed
        SOUND 40 + RND * i, .05
    NEXT
    SOUND 0, .1
END SUB

SUB FirePlasma
    FOR i = 0 TO cMaxPlasmaBalls - 1
        IF gPlasmaBalls(i).time = 0 THEN
            SpawnPlasmaBall gPlasmaBalls(i)
            EXIT FOR
        END IF
    NEXT
    SpawnPlasmaBall gPlasmaBalls(gTick MOD cMaxPlasmaBalls)
    IF gEnableSound THEN
        FOR i = 440 TO 770 STEP 110
            SOUND i, .15
        NEXT
        SOUND 0, .1
    END IF
END SUB

SUB GameOver
    DO: LOOP WHILE IsPressingKey
    gScore = gScore + gScoreAdd
    gScoreAdd = 0
    DO
        COLOR 15
        CLS
        LOCATE gTerminalSize.y \ 2 - 3, 1
        CentrePrint "GAME OVER": PRINT
        PRINT
        CentrePrint "Score:" + STR$(gScore): PRINT

        SELECT CASE gGameType
            CASE cGameTypeDistance
                CentrePrint "Distance:" + STR$(Distance!(0, 0, gPlayer.position.x, gPlayer.position.y)): PRINT
            CASE cGameTypeStandard
                CentrePrint "Level:" + STR$(gLevel)
        END SELECT

        LOCATE gTerminalSize.y - 2
        CentrePrint "Press any key to continue..."
        UpdateScreen
    LOOP UNTIL IsPressingKey
    DO: LOOP WHILE IsPressingKey

    SELECT CASE gGameType
        CASE cGameTypeDistance
            CheckUnlock gScore \ 256
        CASE cGameTypePlamsa
            CheckUnlock gScore \ 1024
    END SELECT

    RegisterScore gScore, gGameType
END SUB

FUNCTION GetDateTime$
    d$ = MID$(DATE$, 7, 4) + "-" + LEFT$(DATE$, 5)
    t$ = LEFT$(TIME$, 5)
    GetDateTime$ = d$ + " " + t$
END FUNCTION

FUNCTION GetSystemDir$
    dir$ = ENVIRON$("EV4DE_DIR")
    IF dir$ = "" THEN dir$ = "C:"
    GetSystemDir$ = dir$
END FUNCTION

FUNCTION IsPressingKey
    IsPressingKey = (LEN(INKEY$) OR JoyButton(0) OR JoyButton(1)) <> 0
END FUNCTION

FUNCTION JoyButton (n)
    value = STRIG(1 + (n XOR (gSwapJoyButtons AND 1)) * 4)
    IF value = 0 THEN
        gJoyButtonsEnabled = TRUE
    END IF
    IF gJoyButtonsEnabled THEN
        JoyButton = value
    END IF
END FUNCTION

SUB LoadConfig
    file = FREEFILE
    gErr = 0
    ON ERROR GOTO eHandle
    OPEN GetSystemDir$ + "\EV4DE.CFG" FOR INPUT AS #file
    ON ERROR GOTO eDefault
    IF gErr THEN EXIT SUB

    DO UNTIL EOF(file)
        LINE INPUT #file, key$
        LINE INPUT #file, value$
        SELECT CASE key$
            CASE "SOUND"
                gEnableSound = VAL(value$) <> 0
            CASE "SCREEN"
                gScreenMode = VAL(value$)
            CASE "THROTTLE"
                gIncrementalThrottle = value$ = "INCREMENTAL"
            CASE "MODEL"
                gPlayerModel = VAL(value$)
            CASE "COLOUR"
                gPlayerColour = VAL(value$)
            CASE "UNLOCK"
                gUnlock = VAL(value$)
            CASE "INVERT_X_AXIS"
                gInvertXAxis = VAL(value$) <> 0
            CASE "INVERT_Y_AXIS"
                gInvertYAxis = VAL(value$) <> 0
            CASE "SWAP_JOY_BUTTONS"
                gSwapJoyButtons = VAL(value$) <> 0
            CASE "DEADZONES"
                gDeadzones = VAL(value$)
            CASE "BACKGROUND_STARS"
                gEnableBackgroundStars = VAL(value$) <> 0
        END SELECT
    LOOP

    CLOSE #file
END SUB

SUB LoadHighScores
    DIM entry AS THighScore

    file = FREEFILE
    gErr = 0
    ON ERROR GOTO eHandle
    OPEN GetSystemDir$ + "\EV4DE.SCO" FOR INPUT AS #file
    ON ERROR GOTO eDefault
    IF gErr THEN EXIT SUB

    INPUT #file, numGameTypes
    FOR gameTypeIndex = 0 TO numGameTypes - 1
        INPUT #file, gameType, numScores
        FOR i = 0 TO numScores - 1
            LINE INPUT #file, entry.date
            INPUT #file, entry.score
            LINE INPUT #file, entry.player
            gHighScores(gameType, i) = entry
        NEXT
    NEXT

    CLOSE #file
END SUB

FUNCTION LPad$ (text$, size)
    IF LEN(text$) >= size THEN
        LPad$ = text$
        EXIT FUNCTION
    END IF
    LPad$ = text$ + SPACE$(size - LEN(text$))
END FUNCTION

SUB MainMenu
    CONST cAnimWidth = 48
    CONST cAnimHeight = 16

    RESTORE dMainMenu
    READ numItems
    DIM items$(numItems - 1, 1)
    FOR i = 0 TO numItems - 1
        READ items$(i, 0), items$(i, 1)
    NEXT

    sel = 0
    hasMoved = FALSE
    anim = 0

    DO
        GOSUB sRenderMenu

        ReadJoystick joyX!, joyY!
        movement = joyY! * 128
        button = JoyButton(0) OR JoyButton(1)

        SELECT CASE INKEY$
            CASE "w", CHR$(0) + "H"
                movement = -127
            CASE "s", CHR$(0) + "P"
                movement = 127
            CASE "q", CHR$(27)
                EXIT SUB
            CASE " ", CHR$(13)
                button = TRUE
        END SELECT

        IF button THEN
            GOSUB sSelect
        ELSEIF NOT hasMoved THEN
            IF movement < -64 THEN
                sel = sel - 1
                IF sel < 0 THEN sel = sel + numItems
            ELSEIF movement > 64 THEN
                sel = sel + 1
                IF sel >= numItems THEN sel = sel - numItems
            END IF
        END IF
        hasMoved = ABS(movement) > 64
    LOOP
EXIT SUB

sSelect:
    SELECT CASE items$(sel, 0)
        CASE "PLAY"
            RunGame cGameTypeStandard
        CASE "PLASMA"
            RunGame cGameTypePlasma
        CASE "DISTANCE"
            RunGame cGameTypeDistance
        CASE "HELP"
            RESTORE dInstructions
            ShowTextScreen
        CASE "SETTINGS"
            SettingsMenu
        CASE "SCORES"
            ShowHighScores cGameTypeStandard, -1
        CASE "LEGAL"
            RESTORE dLicense
            ShowTextScreen
        CASE "EXIT"
            EXIT SUB
    END SELECT
    anim = 0
RETURN

sRenderMenu:
    CLS
    COLOR 10
    LOCATE 3, 1
    CentrePrint "EV4DE"
    itemsPos = (gTerminalSize.y - numItems) \ 2
    FOR i = 0 TO numItems - 1
        COLOR 14
        LOCATE i + itemsPos, gTerminalSize.x / 2 - 8
        IF i = sel THEN
            PRINT "> ";
        ELSE
            PRINT "  ";
        END IF
        COLOR 15
        PRINT items$(i, 1)
    NEXT

    IF anim >= 0 THEN
        animX = gRealScreenSize.x \ 2 + gCharSize.x \ 2
        animY = gCharSize.y * 2.5 - 1
        SELECT CASE anim
            CASE IS <= cAnimWidth
                LINE (animX - cAnimWidth \ 2, animY - cAnimHeight \ 2)-STEP((cAnimWidth - anim) \ 2, cAnimHeight), 0, BF
                LINE STEP(0, 0)-STEP(0, -cAnimHeight), 11
                LINE (animX + cAnimWidth \ 2, animY - cAnimHeight \ 2)-STEP(-(cAnimWidth - anim) \ 2, cAnimHeight), 0, BF
                LINE STEP(0, 0)-STEP(0, -cAnimHeight), 11
            CASE ELSE
                anim = -10
        END SELECT
        anim = anim + 1 + (anim AND 1)
    END IF

    LOCATE gTerminalSize.y - 2, 1
    COLOR 2
    CentrePrint "Made by OokiePigster for Eevee's": PRINT
    CentrePrint "GAMES MADE QUICK??? 1" + CHR$(171) + "."

    BackgroundStars

    UpdateScreen
RETURN

END SUB

SUB OnHitAsteroid
    gIsExploding = TRUE
    Render
    ExplosionSound 1
    WaitForKey
    key$ = INKEY$
    gIsExploding = FALSE

    IF (gGameType = cGameTypeDistance) OR (gGameType = cGameTypePlasma) THEN
        gLives = -1
    ELSE
        StartLevel
        gLives = gLives - 1
    END IF
END SUB

SUB PauseGame
    CONST cNumOptions = 4

    DIM items$(cNumOptions - 1)

    items$(0) = "Resume"
    items$(1) = "Settings"
    items$(2) = "Help"
    items$(3) = "Quit"

    gPaused = TRUE
    gStatusText = " "
    Render
    DO: LOOP WHILE IsPressingKey

    moving = 0
    sel = 0
    DO
        text$ = "  "
        FOR i = 0 TO cNumOptions - 1
            IF i = sel THEN
                text$ = text$ + "<" + items$(i) + ">  "
            ELSE
                text$ = text$ + " " + items$(i) + "   "
            END IF
        NEXT
        gStatusText = text$
        Render
       
        selecting = FALSE
        key$ = INKEY$
        ReadJoystick joyX!, joyY!
        IF ABS(joyX!) > .5 THEN
            IF NOT moving THEN
                IF joyX! > 0 THEN
                    sel = sel + 1
                ELSE
                    sel = sel - 1
                END IF
                moving = TRUE
            END IF
        ELSE
            moving = FALSE
        END IF
        IF JoyButton(0) OR JoyButton(1) THEN
            selecting = TRUE
        END IF
        SELECT CASE key$
            CASE CHR$(13), " "
                selecting = TRUE
            CASE "a", CHR$(0) + "K"
                sel = sel - 1
            CASE "d", CHR$(0) + "M"
                sel = sel + 1
            CASE "p", CHR$(27)
                EXIT DO
        END SELECT

        IF sel < 0 THEN
            sel = sel + cNumOptions
        ELSEIF sel >= cNumOptions THEN
            sel = sel - cNumOptions
        END IF

        IF selecting THEN
            SELECT CASE sel
                CASE 0
                    EXIT DO
                CASE 1
                    SettingsMenu
                CASE 2
                    RESTORE dInstructions
                    ShowTextScreen
                CASE 3
                    ConfirmQuit
                    IF gQuit THEN EXIT DO
            END SELECT
            sel = 0
        END IF
                
    LOOP
    gPaused = FALSE
    DO: LOOP WHILE IsPressingKey
END SUB

SUB PickUpCollectable (kind)
    IF gEnableSound THEN
        SOUND 600, .8
        SOUND 880, 1
        SOUND 0, .1
    END IF
    IF gGameType <> cGameTypePlasma THEN
        AddScore cCollectableScore
    END IF
    SELECT CASE kind
        CASE cCollectableShield
            gPlayer.shields = gPlayer.shields + 1
        CASE cCollectableOneUp
            gLives = gLives + 1
        CASE cCollectableTime
            gTimeRemaining = gTimeRemaining + cTimeBonusSeconds
        CASE cCollectableKey
            gPlayer.keys = gPlayer.keys + 1
        CASE ELSE
            IF gPlayer.collectable = kind THEN
                gPlayer.numCollectables = gPlayer.numCollectables + 1
            ELSE
                gPlayer.collectable = kind
                gPlayer.numCollectables = 1
            END IF
    END SELECT
END SUB

SUB PutInRangeOfPlayer (position AS TVec2D, minDistance, maxDistance)
    angle! = RND * cTau
    dist! = minDistance + RND * (maxDistance - minDistance)
    position.x = gPlayer.position.x + (SIN(angle!) * dist!)
    position.y = gPlayer.position.y + (COS(angle!) * dist!)
END SUB

SUB RandomTeleport
    PutInRangeOfPlayer gPlayer.position, cTeleportMinDistance, cTeleportMaxDistance
    FOR i = 0 TO 7
        SOUND 400, .2
        SOUND 800, .2
    NEXT
    SOUND 0, .1
END SUB

SUB ReadJoystick (x!, y!)
    IF (STICK(0) > 1) OR (STICK(1) > 1) THEN
        gJoysticksEnabled = TRUE
    END IF
    IF gJoysticksEnabled THEN
        x! = (STICK(0) - 128) / 128
        y! = (STICK(1) - 128) / 128
        IF ABS(x!) * 100 < gDeadzones THEN x! = 0
        IF ABS(y!) * 100 < gDeadzones THEN y! = 0
    ELSE
        x! = 0
        y! = 0
    END IF
END SUB

SUB RegisterScore (score, gameType)
    index = -1
    FOR i = 0 TO cNumHighScores - 1
        IF score > gHighScores(gameType, i).score THEN
            index = i
            EXIT FOR
        END IF
    NEXT
    IF index >= 0 THEN
        FOR i = cNumHighScores - 2 TO index STEP -1
            gHighScores(gameType, i + 1) = gHighScores(gameType, i)
        NEXT
        gHighScores(gameType, index).date = GetDateTime$
        gHighScores(gameType, index).score = score
        gHighScores(gameType, index).player = ""
        ShowHighScores gameType, index
    END IF
END SUB

SUB Render
    CLS

    IF gShowFPS THEN
        LOCATE 2, 2
        COLOR 7
        PRINT "FPS:"; gFPS
    END IF

    ' Stars:
    RenderStars

    ' Asteroids:
    FOR i = 0 TO gNAsteroids - 1
        RenderAsteroid gAsteroids(i)
    NEXT

    ' Collectables:
    FOR i = 0 TO cMaxCollectables - 1
        RenderCollectable gCollectables(i)
    NEXT

    ' Plasma balls:
    FOR i = 0 TO cMaxPlasmaBalls - 1
        RenderPlasmaBall gPlasmaBalls(i)
    NEXT

    ' Player:
    RenderPlayer

    ' Goal:
    IF gGameType = cGameTypeStandard THEN
        RenderGoal
        RenderPointer
    END IF

    ' Collectable:
    FOR i = 0 TO gPlayer.numCollectables - 1
        DrawCollectable gPlayer.collectable, gScreenSize.x - (16 + i * 16), gScreenSize.y - 16
    NEXT
    FOR i = 0 TO gPlayer.keys - 1
        DrawCollectable cCollectableKey, gScreenSize.x - (16 + i * 16), gScreenSize.y - 32
    NEXT

    ' Bottom text:
    LOCATE gTerminalSize.y, 1
    PRINT SPACE$(gTerminalSize.x);
    LOCATE gTerminalSize.y, 1
    COLOR 15
    IF gStatusText <> "" THEN
        CentrePrint gStatusText
        gStatusText = ""
    ELSEIF gPaused THEN
        CentrePrint "< Paused >  Press any key to continue."
    ELSEIF gLevelComplete THEN
        IF (TIMER * 10) AND 1 THEN COLOR 14
        CentrePrint "Level complete!"
    ELSEIF gIsExploding THEN
        CentrePrint "You died!  Press any key to continue."
    ELSE
        SELECT CASE gGameType
            CASE cGameTypeStandard
                CentrePrint "LIVES:" + LPad$(STR$(gLives), 4) + "SCORE:" + LPad$(STR$(gScore), 7) + "LEVEL:" + LPad$(STR$(gLevel), 2)
            CASE cGameTypePlasma
                CentrePrint "SCORE:" + LPad$(STR$(gScore), 6) + "TIME:" + LPad$(STR$(gTimeRemaining), 3)
            CASE cGameTypeDistance
                CentrePrint "SCORE:" + LPad$(STR$(gScore), 5)
        END SELECT
    END IF

    ' Border:
    LINE (0, 0)-(gScreenSize.x - 1, gScreenSize.y - 1), 2, B

    ' Paused overlay:
    IF gPaused THEN
        IF (TIMER * 2) AND 1 THEN
            LINE (4, 4)-STEP(4, 12), 7, BF
            LINE (12, 4)-STEP(4, 12), 7, BF
        END IF
        FOR i = 0 TO 7
            v = RND * gRealScreenSize.y
            LINE (0, v)-(gRealScreenSize.x, v), 0
        NEXT
    END IF

    ' Flip:
    UpdateScreen
END SUB

SUB RenderAsteroid (asteroid AS TAsteroid)
    x = asteroid.position.x + gScreenSize.x / 2 - gPlayer.position.x
    y = asteroid.position.y + gScreenSize.y / 2 - gPlayer.position.y
    IF asteroid.exploding THEN
        FOR i = 0 TO 360 - 1 STEP 45
            angle! = ToRadians!((i))
            CIRCLE (x - SIN(angle!) * asteroid.exploding * 2, y - COS(angle!) * asteroid.exploding * 2), asteroid.radius, 7, (angle! + cPi / 4) MOD cTau, (angle! + cPi / 2 - .001) MOD cTau, 1
        NEXT
    ELSE
        CIRCLE (x, y), asteroid.radius, 7, , , 1
    END IF
END SUB

SUB RenderCollectable (collectable AS TCollectable)
    IF collectable.kind = 0 THEN EXIT SUB
    x = gScreenSize.x / 2 + collectable.position.x - gPlayer.position.x
    y = gScreenSize.y / 2 + collectable.position.y - gPlayer.position.y
    DrawCollectable collectable.kind, x, y
END SUB

SUB RenderGoal
    x = gGoal.x + gScreenSize.x / 2 - gPlayer.position.x
    y = gGoal.y + gScreenSize.y / 2 - gPlayer.position.y

    CIRCLE (x, y), 8 + SIN(gTick / cPi) * 4, 14, , , 1

    FOR i = 0 TO gGoalBarriers - 1
        colour = 4
        IF gGoalBarriers - (i + 1) < gPlayer.keys THEN colour = 2
        CIRCLE (x, y), cGoalBarrierRadius + cGoalBarrierSpacing * i, colour, , , 1
    NEXT
END SUB

SUB RenderPlasmaBall (ball AS TPlasmaBall)
    IF ball.time = 0 THEN EXIT SUB
    x = ball.position.x + gScreenSize.x / 2 - gPlayer.position.x
    y = ball.position.y + gScreenSize.y / 2 - gPlayer.position.y
    IF (x >= 0) AND (y >= y) AND (x < gScreenSize.x) AND (y < gScreenSize.y) THEN
        FOR i = 0 TO 7
            angle! = RND * cTau
            colour = 4
            IF RND < .5 THEN colour = 14
            LINE (x, y)-STEP(SIN(angle!) * cPlasmaRadius, COS(angle!) * cPlasmaRadius), colour
        NEXT
    END IF
END SUB

SUB RenderPlayer
    IF gIsExploding THEN
        FOR i = 0 TO 20
            angle! = RND * cTau
            S! = SIN(angle!)
            c! = COS(angle!)
            start! = 8 + RND * 8
            length! = RND * 16
            colour = 4
            IF RND < .5 THEN colour = 14
            LINE (gScreenSize.x / 2 + S! * start!, gScreenSize.y / 2 + c! * start!)-STEP(S! * length!, c! * length!), colour
        NEXT
        EXIT SUB
    END IF

    rot = (gPlayer.orientation + 180) MOD 360
    IF rot < 0 THEN rot = rot + 360
    DrawPlayer gPlayerModel, gPlayerColour, gScreenSize.x \ 2, gScreenSize.y \ 2, rot, gPlayer.throttle

    ' Shields:
    FOR i = 0 TO gPlayer.shields - 1
        CIRCLE (gScreenSize.x \ 2, gScreenSize.y \ 2), cShieldRadius + i * cShieldSpacing, 3, , , 1
    NEXT
END SUB

SUB RenderPointer
    dist! = Distance!(gPlayer.position.x, gPlayer.position.y, gGoal.x, gGoal.y)
    IF (dist! < 128) OR gIsExploding THEN
        EXIT SUB
    END IF
   
    dx = gGoal.x - gPlayer.position.x
    dy = gGoal.y - gPlayer.position.y
    ux! = dx / dist!
    uy! = dy / dist!

    LINE (gScreenSize.x / 2 + ux! * 40, gScreenSize.y / 2 + uy! * 40)-STEP(ux! * 16, uy! * 16), 14
END SUB

SUB RenderStars
    FOR i = 0 TO cMaxStars - 1
        x = (gStars(i).position.x * gScreenSize.x - (gPlayer.position.x * gStars(i).speed)) MOD gScreenSize.x
        y = (gStars(i).position.y * gScreenSize.y - (gPlayer.position.y * gStars(i).speed)) MOD gScreenSize.y
        IF x < 0 THEN x = x + gScreenSize.x
        IF y < 0 THEN y = y + gScreenSize.y
        PSET (x, y), 15
    NEXT
END SUB

SUB ResetHighScores
    DIM default AS THighScore

    default.date = "0000-00-00 00:00"
    default.score = 0
    default.player = STRING$(15, "-")

    FOR gameType = 0 TO cNumGameTypes - 1
        FOR i = 0 TO cNumHighScores - 1
            default.score = 10 * (cNumHighScores - i) - (gameType + 1)
            gHighScores(gameType, i) = default
        NEXT
    NEXT
END SUB

SUB ResetPlayer
    gPlayer.position.x = 0
    gPlayer.position.y = 0
    gPlayer.motion.x = 0
    gPlayer.motion.y = 0
    gPlayer.rotation = 0
    gPlayer.orientation = 180
    gPlayer.throttle = 0
    gPlayer.keys = 0
END SUB

SUB RunGame (gameType)
    gGameType = gameType

    CLS
    UpdateScreen
    DO: LOOP WHILE IsPressingKey

    StartGame

    lastTimeInt& = 0

    DO UNTIL gQuit
        gTick = gTick + 1

        IF gPlayer.shields THEN
            gPlayerRadius = cShieldRadius + cShieldSpacing * (gPlayer.shields - 1)
        ELSE
            gPlayerRadius = cPlayerRadius
        END IF

        IF gGameType = cGameTypeDistance THEN
            gScore = Distance!(0, 0, gPlayer.position.x, gPlayer.position.y) / 16
        END IF

        UserInput
        TickPhysics
        Render
       
        IF gScoreAdd THEN
            gScore = gScore + 1
            gScoreAdd = gScoreAdd - 1
        END IF

        IF gGameType = cGameTypePlasma THEN
            IF lastTimeInt& <> INT(TIMER) THEN
                lastTimeInt& = INT(TIMER)
                IF (gPlayer.position.x <> 0) AND (gPlayer.position.y <> 0) THEN
                    gTimeRemaining = gTimeRemaining - 1
                END IF
            END IF
            IF gTimeRemaining < 0 THEN gLives = -1
        END IF

        IF gLives < 0 THEN
            GameOver
            EXIT DO
        END IF

        AutoDelay
    LOOP
END SUB

SUB SaveConfig
    IF gIncrementalThrottle THEN
        throttleMode$ = "INCREMENTAL"
    ELSE
        throttleMode$ = "DIRECT"
    END IF

    file = FREEFILE
    gErr = 0
    ON ERROR GOTO eHandle
    OPEN GetSystemDir$ + "\EV4DE.CFG" FOR OUTPUT AS #file
    ON ERROR GOTO eDefault

    IF gErr THEN
        IF Confirm("Failed to save settings. Try again?", TRUE) THEN
            SaveConfig
        END IF
        EXIT SUB
    END IF

    PRINT #file, "SOUND"
    PRINT #file, gEnableSound
    PRINT #file, "SCREEN"
    PRINT #file, gScreenMode
    PRINT #file, "THROTTLE"
    PRINT #file, throttleMode$
    PRINT #file, "MODEL"
    PRINT #file, gPlayerModel
    PRINT #file, "COLOUR"
    PRINT #file, gPlayerColour
    PRINT #file, "UNLOCK"
    PRINT #file, gUnlock
    PRINT #file, "INVERT_X_AXIS"
    PRINT #file, gInvertXAxis
    PRINT #file, "INVERT_Y_AXIS"
    PRINT #file, gInvertYAxis
    PRINT #file, "SWAP_JOY_BUTTONS"
    PRINT #file, gSwapJoyButtons
    PRINT #file, "DEADZONES"
    PRINT #file, gDeadzones
    PRINT #file, "BACKGROUND_STARS"
    PRINT #file, gEnableBackgroundStars
    CLOSE #file
END SUB

SUB SaveHighScores
    DIM entry AS THighScore

    file = FREEFILE
    OPEN GetSystemDir$ + "\EV4DE.SCO" FOR OUTPUT AS #file

    WRITE #file, cNumGameTypes
    FOR gameType = 0 TO cNumGameTypes - 1
        WRITE #file, gameType, cNumHighScores
        FOR i = 0 TO cNumHighScores - 1
            entry = gHighScores(gameType, i)
            PRINT #file, entry.date
            PRINT #file, entry.score
            PRINT #file, entry.player
        NEXT
    NEXT

    CLOSE #file
END SUB

SUB SettingsMenu
    CONST cNumOptions = 12

    sel = 0
    finished = FALSE
    changing = TRUE
    moving = TRUE
   
    DO
        CLS
        COLOR 9
        PRINT
        PRINT " Settings"
        PRINT
        COLOR 15
        PRINT "   Sound effects:    ";
        IF gEnableSound THEN PRINT "Enabled" ELSE PRINT "Disabled"
        
        PRINT "   Throttle mode:    ";
        IF gIncrementalThrottle THEN PRINT "Incremental" ELSE PRINT "Direct"
        
        PRINT "   Screen mode:      [" + LTRIM$(STR$(gScreenMode + 1)) + "/" + LTRIM$(STR$(cNumScreenModes)) + "] " + RTRIM$(gScreenModes(gScreenMode).title)

        PRINT "   Ship model:       " + gModelNames(gPlayerModel)
        
        PRINT "   Ship colour:      " + gColourNames(gPlayerColour)

        PRINT "   Joystick X axis:  ";
        IF gInvertXAxis THEN PRINT "Inverted" ELSE PRINT "Normal"
       
        PRINT "   Joystick Y axis:  ";
        IF gInvertYAxis THEN PRINT "Inverted" ELSE PRINT "Normal"

        PRINT "   Joystick buttons: ";
        IF gSwapJoyButtons THEN PRINT "Swapped" ELSE PRINT "Normal"

        PRINT "   Deadzones:       " + STR$(gDeadzones) + "%"

        PRINT "   Menu stars:       ";
        IF gEnableBackgroundStars THEN PRINT "Enabled" ELSE PRINT "Disabled"

        PRINT "   Clear Unlocks"
        
        PRINT "   Done"

        LOCATE gTerminalSize.y - 1, 1
        CentrePrint "Unlocked" + STR$(gUnlock + 1) + "/" + LTRIM$(STR$(cNumModels)) + " ships."
        DrawModelPreview gPlayerModel, gPlayerColour, gRealScreenSize.x \ 2, gRealScreenSize.y - (gCharSize.y * 4 + cPlayerRadius)
       
        LOCATE 4 + sel, 2
        COLOR 14
        PRINT ">";
        UpdateScreen

        change = 0

        ReadJoystick joyX!, joyY!
        IF JoyButton(0) THEN
            joyX! = 1
        ELSEIF JoyButton(1) THEN
            joyX! = -1
        END IF
        IF ABS(joyX!) > .5 THEN
            IF NOT changing THEN
                IF joyX! > 0 THEN
                    change = 1
                ELSE
                    change = -1
                END IF
                changing = TRUE
            END IF
        ELSE
            changing = FALSE
        END IF

        IF ABS(joyY!) > .5 THEN
            IF NOT moving THEN
                IF joyY! > 0 THEN
                    sel = sel + 1
                ELSE
                    sel = sel - 1
                END IF
                moving = TRUE
            END IF
        ELSE
            moving = FALSE
        END IF

        SELECT CASE INKEY$
            CASE "q", CHR$(27)
                finished = TRUE
            CASE "w", CHR$(0) + "H"
                sel = sel - 1
            CASE "s", CHR$(0) + "P"
                sel = sel + 1
            CASE "a", CHR$(0) + "K"
                change = -1
            CASE "d", CHR$(0) + "M", " ", CHR$(13)
                change = 1
            CASE CHR$(0) + "u"
                IF Confirm("Unlock all ships?", TRUE) THEN gUnlock = cNumModels - 1
        END SELECT

        IF sel < 0 THEN
            sel = sel + cNumOptions
        ELSEIF sel >= cNumOptions THEN
            sel = sel - cNumOptions
        END IF

        IF change THEN GOSUB sChangeSettings
    LOOP UNTIL finished
    SaveConfig
    DO: LOOP WHILE IsPressingKey
EXIT SUB

sChangeSettings:
    SELECT CASE sel
        CASE 0 ' Sound
            gEnableSound = NOT gEnableSound
            IF gEnableSound THEN
                SOUND 440, .5
                SOUND 0, .05
            END IF

        CASE 1 ' Throttle mode
            gIncrementalThrottle = NOT gIncrementalThrottle

        CASE 2 ' Resolution
            gScreenMode = gScreenMode + change
            IF gScreenMode < 0 THEN
                gScreenMode = gScreenMode + cNumScreenModes
            ELSEIF gScreenMode >= cNumScreenModes THEN
                gScreenMode = gScreenMode - cNumScreenModes
            END IF
            ApplyScreenSettings

        CASE 3 ' Ship
            gPlayerModel = gPlayerModel + change
            IF gPlayerModel < 0 THEN
                gPlayerModel = gPlayerModel + (gUnlock + 1)
            ELSEIF gPlayerModel > gUnlock THEN
                gPlayerModel = gPlayerModel - (gUnlock + 1)
            END IF

        CASE 4 ' Ship colour
            gPlayerColour = gPlayerColour + change
            IF gPlayerColour <= 0 THEN
                gPlayerColour = gPlayerColour + 15
            ELSEIF gPlayerColour > 15 THEN
                gPlayerColour = gPlayerColour - 15
            END IF

        CASE 5 ' Joystick X axis
            gInvertXAxis = NOT gInvertXAxis

        CASE 6 ' Joystick Y axis
            gInvertYAxis = NOT gInvertYAxis

        CASE 7 ' Swap joy buttons
            gSwapJoyButtons = NOT gSwapJoyButtons

        CASE 8 ' Deadzones
            gDeadzones = gDeadzones + change
            IF gDeadzones < 0 THEN
                gDeadzones = 0
            ELSEIF gDeadzones > 100 THEN
                gDeadzones = 100
            END IF

        CASE 9 ' Menu stars
            gEnableBackgroundStars = NOT gEnableBackgroundStars
            IF gEnableBackgroundStars THEN
                FOR i = 0 TO 20
                    BackgroundStars
                NEXT
            END IF

        CASE 10 ' Clear Unlocks
            IF Confirm("Clear all unlocked ship models?", FALSE) THEN
                gUnlock = 0
                gPlayerModel = 0
            END IF

        CASE 11 ' Done
            finished = TRUE

    END SELECT
RETURN

END SUB

SUB ShowEnding
    SCREEN 0
    WIDTH 80, 25
    COLOR 7, 0
    CLS
    PRINT
    PRINT " Thanks for playing ";
    COLOR 5
    PRINT "EV4DE";
    COLOR 7
    PRINT "!"
    PRINT
    PRINT " For more games by OokiePigster, go to ";
    COLOR 9
    PRINT "https://ookiepigster.itch.io";
    COLOR 7
    PRINT "."
    PRINT
    PRINT " For more submissions to GAMES MADE QUICK??? 1" + CHR$(171) + ", go to"
    COLOR 9
    PRINT " https://itch.io/jam/games-made-quick-one-and-a-half";
    COLOR 7
    PRINT "."
    PRINT
END SUB

SUB ShowHighScores (gameType, newIndex)
    DIM entry AS THighScore

    switching = FALSE
    newName$ = ""

    DO
        CLS
        COLOR 15
        LOCATE 2, 1
        IF newIndex < 0 THEN
            CentrePrint "- High Scores -"
            LOCATE 4, 1
            CentrePrint "Game type:  " + gGameTypeNames(gameType) + " "
        ELSE
            CentrePrint "You got a high score!"
            entryX = (gTerminalSize.x - cScoreNameMaxLength) \ 2
            LOCATE 4, entryX - 2
            PRINT "Name: " + newName$;
            IF (TIMER * 2) AND 1 THEN PRINT CHR$(22)
            LINE ((entryX + 3) * gCharSize.x - 3, 3 * gCharSize.y - 3)-STEP((cScoreNameMaxLength + 1) * gCharSize.x + 4, gCharSize.y + 4), 14, B
        END IF
        FOR i = 0 TO cNumHighScores - 1
            entry = gHighScores(gameType, i)
            IF i = newIndex THEN
                COLOR 14
            ELSE
                COLOR 15
            END IF
            LOCATE 6 + i, 1 + gTerminalSize.x \ 2 - 19
            PRINT entry.date + " " + LPad$(STR$(entry.score), 7) + entry.player
        NEXT
        LOCATE gTerminalSize.y - 2, 1
        IF newIndex < 0 THEN
            CentrePrint "Press DEL or JOYSTICK BOTTOM BUTTON"
            CentrePrint "to reset, or any other key to exit."
        ELSE
            CentrePrint "Type your name and press ENTER."
        END IF

        UpdateScreen

        key$ = INKEY$
        IF newIndex < 0 THEN
            IF JoyButton(1) THEN
                key$ = " "
            ELSEIF JoyButton(0) THEN
                key$ = CHR$(0) + "S"
            END IF
            ReadJoystick joyX!, joyY!
            IF ABS(joyX!) > .5 THEN
                IF NOT switching THEN
                    IF joyX! > 0 THEN
                        key$ = "d"
                    ELSE
                        key$ = "a"
                    END IF
                    switching = TRUE
                END IF
            ELSE
                switching = FALSE
            END IF
            SELECT CASE key$
                CASE ""
                CASE CHR$(0) + "S"
                    IF Confirm("Delete all high-scores?", FALSE) THEN
                        ResetHighScores
                    END IF
                CASE "a", CHR$(0) + "K"
                    IF newIndex < 0 THEN gameType = gameType - 1
                CASE "d", CHR$(0) + "M"
                    IF newIndex < 0 THEN gameType = gameType + 1
                CASE ELSE
                    EXIT DO
            END SELECT
        ELSE
            SELECT CASE key$
                CASE CHR$(13)
                    EXIT DO
                CASE ELSE
                    EditText newName$, key$, cScoreNameMaxLength
            END SELECT
            gHighScores(gameType, newIndex).player = newName$
        END IF

        IF gameType < 0 THEN
            gameType = gameType + cNumGameTypes
        ELSEIF gameType >= cNumGameTypes THEN
            gameType = gameType - cNumGameTypes
        END IF
    LOOP

    SaveHighScores

    DO: LOOP WHILE IsPressingKey
END SUB

SUB ShowIntro
    CLS
    COLOR 15
    LOCATE 8, 1
    CentrePrint "EV4DE"
    LOCATE 11, gTerminalSize.x / 2 - 7
    COLOR 7
    PRINT "by ";
    COLOR 13
    PRINT "OokiePigster"

    LOCATE 20, 1
    COLOR 8
    CentrePrint "Copyright (C) 2017, OokiePigster": PRINT
    CentrePrint "This program is free software,": PRINT
    CentrePrint "and comes with ABSOLUTELY NO": PRINT
    CentrePrint "WARRANTY; select `License' from the": PRINT
    CentrePrint "main menu for details."

    UpdateScreen

    startTime! = TIMER
    DO
        BackgroundStars
    LOOP UNTIL (TIMER - startTime! > cIntroDuration) OR IsPressingKey

    DO: LOOP WHILE IsPressingKey
END SUB

SUB ShowTextScreen
    DIM lines(0 TO 24) AS STRING
    nlines = 0
    lastPage = FALSE

    DO
        READ S$
        IF S$ = "\C" THEN
            FOR i = 0 TO gTerminalSize.y / 2 - 2
                lines(nlines) = "$"
                nlines = nlines + 1
            NEXT
        ELSEIF LEN(S$) AND (LEFT$(S$, 1) = "\") THEN
            FOR i = 0 TO VAL(MID$(S$, 2))
                lines(nlines) = "$"
                nlines = nlines + 1
            NEXT
        ELSEIF (S$ = "END") OR (S$ = "PAGE") THEN
            lastPage = S$ = "END"
            GOSUB sPage
            nlines = 0
        ELSE
            lines(nlines) = S$
            nlines = nlines + 1
        END IF
    LOOP UNTIL lastPage
EXIT SUB

sPage:
    FOR shade = 0 TO 3
        COLOR gShades(shade)
        GOSUB sRenderTextScreen
        Delay .05
    NEXT
    DO
        key$ = INKEY$
    LOOP UNTIL LEN(key$) OR IsPressingKey
    FOR shade = 3 TO 0 STEP -1
        COLOR gShades(shade)
        GOSUB sRenderTextScreen
        Delay .05
    NEXT
    IF key$ = CHR$(27) THEN EXIT SUB
RETURN

sRenderTextScreen:
    CLS
    row = 2
    FOR ln = 0 TO nlines - 1
        mode$ = LEFT$(lines(ln), 1)
        text$ = MID$(lines(ln), 2)
        SELECT CASE mode$
            CASE "$"
                LOCATE row, 1
                CentrePrint text$
                row = row + 1
            CASE "C"
                IF shade > 1 THEN
                    DrawCollectable VAL(text$), gScreenSize.x / 2, row * gCharSize.y
                END IF
                row = row + 2
        END SELECT
    NEXT
    LOCATE gTerminalSize.y - 1, 1
    CentrePrint "Press any key to continue..."
    UpdateScreen
    COLOR 15
RETURN

END SUB

SUB SpawnAsteroid (asteroid AS TAsteroid)
    PutInRangeOfPlayer asteroid.position, cMinAsteroidDistance, cMaxAsteroidDistance
    asteroid.motion.x = cAsteroidSpeed * (RND - .5)
    asteroid.motion.y = cAsteroidSpeed * (RND - .5)
    asteroid.radius = cMinAsteroidRadius + (RND ^ 2) * (cMaxAsteroidRadius - cMinAsteroidRadius)
    asteroid.exploding = 0
END SUB

SUB SpawnCollectable (collectable AS TCollectable)
    PutInRangeOfPlayer collectable.position, cMinCollectableDistance, cMaxCollectableDistance
    collectable.kind = 0
    DO
        SELECT CASE INT(RND * 12)
            CASE 0
                IF gGameType = cGameTypeStandard THEN
                    collectable.kind = cCollectableOneUp
                END IF
            CASE 1, 2
                collectable.kind = cCollectableShield
            CASE 3, 4
                collectable.kind = cCollectablePlasma
            CASE 5
                collectable.kind = cCollectableTeleport
            CASE 6, 7
                IF gGameType = cGameTypePlasma THEN
                    collectable.kind = cCollectableTime
                END IF
        END SELECT
    LOOP UNTIL collectable.kind

    IF (gGameType = cGameTypePlasma) AND (collectable.kind <> cCollectableTime) THEN
        collectable.kind = cCollectablePlasma
    END IF

    IF (gGameType = cGameTypeStandard) AND (gGoalBarriers > 0) AND (gPlayer.keys < gGoalBarriers) THEN
        collectable.kind = cCollectableKey
    END IF
END SUB

SUB SpawnPlasmaBall (ball AS TPlasmaBall)
    angle! = ToRadians!(gPlayer.orientation)
    dist! = cPlayerRadius
    ball.angle = angle!
    ball.position.x = gPlayer.position.x + SIN(angle!) * dist!
    ball.position.y = gPlayer.position.y + COS(angle!) * dist!
    ball.motion.x = gPlayer.motion.x + SIN(angle!) * cPlasmaSpeed
    ball.motion.y = gPlayer.motion.y + COS(angle!) * cPlasmaSpeed
    ball.time = cPlasmaLifetime
END SUB

SUB StartGame
    gQuit = FALSE
    gLives = cStartingLives
    gScore = 0
    gScoreAdd = 0
    gLevel = 1
    gPlayer.shields = 0
    gPlayer.numCollectables = 0
    gPlayer.collectable = 0

    SELECT CASE gGameType
        CASE cGameTypePlasma
            gPlayer.numCollectables = 10
            gPlayer.collectable = cCollectablePlasma
            gTimeRemaining = cPlasmaGameDuration
    END SELECT

    StartLevel
END SUB

SUB StartLevel
    gTick = 0

    ResetPlayer
    SELECT CASE gGameType
        CASE cGameTypePlasma
            numAsteroids = cMaxAsteroids
        CASE cGameTypeDistance
            numAsteroids = 32
        CASE ELSE
            numAsteroids = 4 + gLevel * 4
    END SELECT
    IF numAsteroids > cMaxAsteroids THEN
        numAsteroids = cMaxAsteroids
    END IF
    goalDistance = cGoalDistanceBase + cGoalDistancePerLevel * (gLevel - 1)
    PutInRangeOfPlayer gGoal, goalDistance * .9, goalDistance * 1.1
    gGoalBarriers = INT(RND * gLevel / 8)
    CreateAsteroids numAsteroids
    CreateCollectables
END SUB

SUB TickAsteroid (asteroid AS TAsteroid)
    ApplyMotion asteroid.motion, asteroid.position

    IF asteroid.exploding THEN
        asteroid.exploding = asteroid.exploding + 1
        IF asteroid.exploding >= cAsteroidExplodeTime THEN
            SpawnAsteroid asteroid
        END IF
        EXIT SUB
    END IF

    plasma = gTick MOD cMaxPlasmaBalls
    IF gPlasmaBalls(plasma).time THEN
        distanceFromPlasma! = Distance!(asteroid.position.x, asteroid.position.y, gPlasmaBalls(plasma).position.x, gPlasmaBalls(plasma).position.y)
        IF distanceFromPlasma! <= asteroid.radius + cPlasmaRadius THEN
            IF gEnableSound THEN
                FOR i = 200 TO 110 STEP -10
                    SOUND i, .1
                NEXT
                SOUND 0, .1
            END IF
            AddScore cPlasmaHitScore
            asteroid.exploding = 1
            gPlasmaBalls(plasma).time = 1
            IF gGameType = cGameTypePlasma THEN
                gPlayer.collectable = cCollectablePlasma
                gPlayer.numCollectables = gPlayer.numCollectables + 1
            END IF
        END IF
    END IF

    distanceFromPlayer! = Distance!(asteroid.position.x, asteroid.position.y, gPlayer.position.x, gPlayer.position.y)
    IF distanceFromPlayer! > cMaxAsteroidDistance THEN
        SpawnAsteroid asteroid
    ELSEIF distanceFromPlayer! < (asteroid.radius + gPlayerRadius) THEN
        IF gPlayer.shields THEN
            gPlayer.shields = gPlayer.shields - 1
            asteroid.exploding = 1
            IF gEnableSound THEN
                SOUND 100, 1
                SOUND 0, .1
            END IF
        ELSE
            OnHitAsteroid
        END IF
    END IF
END SUB

SUB TickCollectable (collectable AS TCollectable)
    kind = collectable.kind
    IF kind = 0 THEN EXIT SUB
    playerDistance! = Distance!(collectable.position.x, collectable.position.y, gPlayer.position.x, gPlayer.position.y)
    IF playerDistance! <= cPlayerRadius + cCollectableRadius THEN
        SpawnCollectable collectable
        PickUpCollectable kind
    ELSEIF playerDistance! > cMaxCollectableDistance THEN
        SpawnCollectable collectable
    END IF
END SUB

SUB TickPhysics
    IF (gPlayer.position.x <> 0) OR (gPlayer.position.y <> 0) THEN
        FOR i = 0 TO gNAsteroids - 1
            TickAsteroid gAsteroids(i)
        NEXT
    END IF

    FOR i = 0 TO cMaxCollectables - 1
        TickCollectable gCollectables(i)
    NEXT

    FOR i = 0 TO cMaxPlasmaBalls - 1
        IF gPlasmaBalls(i).time THEN
            ApplyMotion gPlasmaBalls(i).motion, gPlasmaBalls(i).position
            gPlasmaBalls(i).time = gPlasmaBalls(i).time - 1
        END IF
    NEXT

    TickPlayer
END SUB

SUB TickPlayer
    gPlayer.orientation = gPlayer.orientation + gPlayer.rotation
    vecRad! = ToRadians!(gPlayer.orientation)
    gPlayer.motion.x = gPlayer.motion.x + SIN(vecRad!) * gPlayer.throttle * cThrust
    gPlayer.motion.y = gPlayer.motion.y + COS(vecRad!) * gPlayer.throttle * cThrust
    ApplyMotion gPlayer.motion, gPlayer.position
    IF gGameType = cGameTypeStandard THEN
        goalDistance! = Distance!(gPlayer.position.x, gPlayer.position.y, gGoal.x, gGoal.y) - cPlayerRadius
        IF goalDistance! < cGoalRadius THEN
            CompleteLevel
        ELSEIF gGoalBarriers AND (goalDistance! < cGoalBarrierRadius + cGoalBarrierSpacing * (gGoalBarriers - 1)) THEN
            IF gPlayer.keys THEN
                gPlayer.keys = gPlayer.keys - 1
                gGoalBarriers = gGoalBarriers - 1
                IF gEnableSound THEN
                    SOUND 666, .9
                    SOUND 0, .1
                END IF
            ELSE
                OnHitAsteroid
            END IF
        END IF
    END IF
END SUB

FUNCTION ToRadians! (degrees!)
    ToRadians! = degrees! / cDegreesToRadians
END FUNCTION

SUB UpdateScreen
    IF gScreenModes(gScreenMode).flip THEN
        PCOPY 0, 1
    END IF
END SUB

SUB UseCollectable
    STATIC sLastUseTime!

    IF sLastUseTime! > TIMER + 1 THEN
        sLastUseTime! = 0
    ELSEIF (TIMER - sLastUseTime!) < cCollectableCoolDown THEN
        EXIT SUB
    END IF

    SELECT CASE gPlayer.collectable
        CASE cCollectablePlasma
            FirePlasma
        CASE cCollectableTeleport
            RandomTeleport
        CASE ELSE
            EXIT SUB
    END SELECT
    sLastUseTime! = TIMER
    gPlayer.numCollectables = gPlayer.numCollectables - 1
    IF gPlayer.numCollectables = 0 THEN
        gPlayer.collectable = 0
    END IF
END SUB

SUB UserInput
    STATIC sKey$
    STATIC sKeyTime

    ReadJoystick x!, y!

    IF gInvertXAxis THEN x! = -x!
    IF gInvertYAxis THEN y! = -y!
   
    key$ = INKEY$
    IF (key$ = "") AND sKeyTime THEN
        key$ = sKey$
    ELSE
        sKey$ = key$
        sKeyTime = 3
    END IF
    IF sKeyTime THEN
        sKeyTime = sKeyTime - 1
    END IF
    SELECT CASE key$
        CASE "q"
            sKeyTime = 0
            ConfirmQuit
        CASE "p", CHR$(27)
            sKeyTime = 0
            PauseGame
        CASE CHR$(0) + ";" ' F1
            sKeyTime = 0
            RESTORE dInstructions
            ShowTextScreen
        CASE CHR$(19) ' Ctrl+S
            sKeyTime = 0
            SettingsMenu
            PauseGame
        CASE CHR$(6) ' Ctrl+F
            sKeyTime = 0
            gShowFPS = NOT gShowFPS

        CASE " "
            sKeyTime = 0
            UseCollectable


        CASE "a", CHR$(0) + "K"
            x! = -1
        CASE "d", CHR$(0) + "M"
            x! = 1
        CASE "w", CHR$(0) + "H"
            y! = -1
        CASE "s", CHR$(0) + "P"
            y! = 1
    END SELECT

    IF JoyButton(1) THEN
        UseCollectable
    END IF
    IF JoyButton(0) THEN
        PauseGame
    END IF

    gPlayer.rotation = gPlayer.rotation - x! * cRotationSpeed
    IF gIncrementalThrottle THEN
        gPlayer.throttle = gPlayer.throttle - y! / 16
    ELSE
        gPlayer.throttle = -y!
    END IF
    IF gPlayer.throttle < 0 THEN
        gPlayer.throttle = 0
    ELSEIF gPlayer.throttle > 1 THEN
        gPlayer.throttle = 1
    END IF
    
END SUB

SUB WaitForKey
    DO: LOOP WHILE IsPressingKey
    DO: LOOP UNTIL IsPressingKey
    DO: LOOP WHILE IsPressingKey
END SUB

SUB WaitForKeyAndRender
    DO
        Render
        Delay .01
    LOOP WHILE IsPressingKey
    DO
        Render
        Delay .01
    LOOP UNTIL IsPressingKey
    DO
        Render
    LOOP WHILE IsPressingKey
END SUB

