/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include "Vga256.h"

#include <dpmi.h>
#include <string.h>
#include <sys/nearptr.h>
#include <pc.h>
#include <stdio.h>
//---------------------------------------------------------------------------
void SetVgaMode(unsigned char mode) {

 __dpmi_regs regs;

 memset(&regs,0,sizeof regs);
 regs.x.ax=mode;
 __dpmi_int(0x10,&regs);

}
//---------------------------------------------------------------------------
unsigned char *GrabScreenPtr() {

 unsigned char *scrPtr;

   if(__djgpp_nearptr_enable()==0) exit(1);

  scrPtr=(unsigned char*)(0xa0000+__djgpp_conventional_base);

  return scrPtr;


}
//---------------------------------------------------------------------------
void Release() {

 __djgpp_nearptr_disable();

}
//---------------------------------------------------------------------------
void PutPixel(unsigned char *ptrBuf,int x,int y,unsigned char color) {

 *(ptrBuf+x+y*320)=color;

}
//---------------------------------------------------------------------------
void WaitForRetrace() {

  char out=inportb(0x3da);

  while(!(out&0x8)) {
   out=inportb(0x3da);
  }

}
//---------------------------------------------------------------------------
void SetPalette(unsigned char *pal) {

 int i;

  outportb(0x3c8,0);
   for(i=0;i<768;i++) {
    outp(0x3c9,pal[i]);
   }

}
//---------------------------------------------------------------------------
void GetPalette(unsigned char *pal) {

 int i;

  outportb(0x3c7,0);
   for(i=0;i<768;i++) pal[i]=inportb(0x3c9);

}
//---------------------------------------------------------------------------
void LoadPalette(char *filename,unsigned char *pal) {

 FILE *palfile;

 if(filename!=NULL) {
  palfile=fopen(filename,"rb");
  fread(pal,1,768,palfile);
  fclose(palfile);
 }

 else memset(&pal[0],0,768);

}
//---------------------------------------------------------------------------
void SavePalToTex(char *filename,unsigned char *pal) {

  FILE *texfile;
  int i;

   texfile=fopen(filename,"wt");
    for(i=0;i<255;i+=3)
     fprintf(texfile,"Color n. %d %d %d %d\n",
                      (i/3),pal[i],pal[i+1],pal[i+2]);
   fclose(texfile);

}
//---------------------------------------------------------------------------
bool FadingFX(unsigned char *src_pal,unsigned char *dest_pal,
              char mode) {

 int i,cnt=0;

  switch(mode) {

   case FADING_INTRO:   for(i=0;i<768;i++)

                         if(src_pal[i]>dest_pal[i])
                             dest_pal[i]++;
                          else if(src_pal[i]==dest_pal[i]) cnt++;

                        break;

   case FADING_THE_END: for(i=0;i<768;i++)  {

                         if(dest_pal[i]>0)
                             dest_pal[i]--;
                          else if(dest_pal[i]==0) cnt++;

                        }

                        break;

   /*case FADE_TO_RED:   for(i=0;i<768;i++)

                         if((src_pal[i]<64)&&(i%3)==0)
                           dest_pal[i]++;
                         else dest_pal[i]--;

                        break;*/


  }

  if(cnt<768) return false;
   else return true;

}
//---------------------------------------------------------------------------
void ImgColorInfo(char *filename,unsigned char *img_buf,int size) {

  int i;
  unsigned char colCnt[256],col;

  FILE *texfile;

   memset(&colCnt[0],0,256);

   for(i=0;i<size;i++) {

     col=img_buf[i];
     colCnt[col]++;

   }

   texfile=fopen(filename,"wt");

    for(i=0;i<256;i++)
     fprintf(texfile,"Color n.%d was found %d time(s)\n",i,colCnt[i]);

}
//---------------------------------------------------------------------------




