/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <pc.h>
#include <unistd.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>
#include <string.h>

#include "Vga256.h"
#include "Sprite.h"
#include "Font.h"
#include "AWorm.h"
#include "Intro.h"

#define NUM_LEVELS 4
//---------------------------------------------------------------------------
int t=0;

unsigned char *scr;
DblBuf *DBuffer;
int currLev=0;

Sprite *LevelsBackGround;
LevelHeader *Levels;

Worm *MyWorm;
FontBMP *ptrFont;

int c=0;

unsigned char pal1[768],pal2[768],palblack[768];

void GeneralInit();
void Free();
void NewLevelInit();
void NextLevel();
//---------------------------------------------------------------------------
void GeneralInit() {

 SetVgaMode(GRAPH256_MODE);
 scr=GrabScreenPtr();
 DBuffer=new DblBuf;

 LoadPalette("art/system.pal",&pal1[0]);
 LoadPalette("art/system.pal",&pal2[0]);
 memset(&palblack[0],0,768);

 SetPalette(&pal1[0]);

 ptrFont=new FontBMP;
 ptrFont->Init(255);
 ptrFont->LoadFromFile("font/Calisto.fnt");

 LevelsBackGround=new Sprite[NUM_LEVELS];

 LevelsBackGround[0].LoadFrom_RAW_File("levels/Level1.raw");
 LevelsBackGround[1].LoadFrom_RAW_File("levels/Level2.raw");
 LevelsBackGround[2].LoadFrom_RAW_File("levels/Level3.raw");
 LevelsBackGround[3].LoadFrom_RAW_File("levels/Level4.raw");

 Levels=new LevelHeader[NUM_LEVELS];

 Levels[0].LoadFrom_SCP_File("levels/level1.scp");
 Levels[1].LoadFrom_SCP_File("levels/level2.scp");
 Levels[2].LoadFrom_SCP_File("levels/level3.scp");
 Levels[3].LoadFrom_SCP_File("levels/level4.scp");

 DBuffer->Init(scr);

}
//---------------------------------------------------------------------------
void NewLevelInit(int numLev) {

int cx;
char *str=Levels[numLev].LevelName;

 cx=160-(strlen(str)/2*6);

 MyWorm=new Worm;

 MyWorm->Init(&Levels[numLev],DBuffer);


    DBuffer->ClearBuf(0);
    ptrFont->GotoXY(cx,100);
    ptrFont->Print(Levels[numLev].LevelName,DBuffer->FrameBuf);
    DBuffer->Flip();

     while(!FadingFX(&pal1[0],&palblack[0],FADING_INTRO)) {
      SetPalette(&palblack[0]);
      usleep(20000);
     }

     while(!FadingFX(NULL,&palblack[0],FADING_THE_END)) {
      SetPalette(&palblack[0]);
      usleep(20000);
     }

    memset(&palblack[0],0,768);

    DBuffer->ClearBuf(0);
    DBuffer->ClearBufPat(LevelsBackGround[currLev].PtrSprite);
    WaitForRetrace();
    DBuffer->Flip();

     while(!FadingFX(&pal1[0],&palblack[0],FADING_INTRO)) {
      SetPalette(&palblack[0]);
      usleep(20000);
     }

     memset(&palblack[0],0,768);
  
}
//---------------------------------------------------------------------------
void TryAgain(int numLev) {

int cx;
char *str=Levels[numLev].LevelName;

 cx=160-(strlen(str)/2*6);

 MyWorm=new Worm;

 MyWorm->Init(&Levels[numLev],DBuffer);

 Levels[numLev].WormDeath=false;

    DBuffer->ClearBuf(0);
    ptrFont->GotoXY(cx,100);
    ptrFont->Print(Levels[numLev].LevelName,DBuffer->FrameBuf);
    DBuffer->Flip();

     while(!FadingFX(&pal1[0],&palblack[0],FADING_INTRO)) {
      SetPalette(&palblack[0]);
      usleep(20000);
     }

     while(!FadingFX(NULL,&palblack[0],FADING_THE_END)) {
      SetPalette(&palblack[0]);
      usleep(20000);
     }

    memset(&palblack[0],0,768);

    Levels[numLev].Arts[0].DrawSprite(228+(11*(Levels[numLev].NumLives)),
                                      189,
                                      LevelsBackGround[numLev].PtrSprite);

    DBuffer->ClearBuf(0);
    DBuffer->ClearBufPat(LevelsBackGround[currLev].PtrSprite);

    WaitForRetrace();
    DBuffer->Flip();

     while(!FadingFX(&pal1[0],&palblack[0],FADING_INTRO)) {
      SetPalette(&palblack[0]);
      usleep(20000);
     }

     memset(&palblack[0],0,768);
  
}
//---------------------------------------------------------------------------
void NextLevel() {

 DBuffer->ClearBuf(0);
 DBuffer->ClearBufPat(LevelsBackGround[currLev].PtrSprite);

 Levels[currLev].Animations(DBuffer);
 DBuffer->Flip();

 while(!FadingFX(NULL,&pal1[0],FADING_THE_END)) {

  SetPalette(&pal1[0]);
  usleep(20000);

 }

  memcpy(&pal1[0],&pal2[0],768);
  currLev++;

   if(currLev<NUM_LEVELS) NewLevelInit(currLev);

    else Free();


}
//---------------------------------------------------------------------------
void Free() {

 delete MyWorm;
 delete DBuffer;
 delete Levels;
 //delete LevelsBackGround;
 delete ptrFont;
 Release();

 SetVgaMode(TEXT_MODE);
 exit(0);


}
//---------------------------------------------------------------------------
void GameOver() {

 Free();

}
//---------------------------------------------------------------------------
int main() {

   GeneralInit();

    if(Intro(DBuffer,scr)==EXIT_FROM_LOGO) Free();

   NewLevelInit(currLev);

    while(c!=283) {

      DBuffer->ClearBuf(0);
      DBuffer->ClearBufPat(LevelsBackGround[currLev].PtrSprite);
      Levels[currLev].Animations(DBuffer);

      MyWorm->Crawl(&Levels[currLev],t);
      MyWorm->Display();

         if(kbhit()) {

          c=bioskey(0);

            switch(c) {

             case 18432: MyWorm->AddPivot(DIR_UP);
                         break;
             case 19200: MyWorm->AddPivot(DIR_LEFT);
                         break;
             case 20480: MyWorm->AddPivot(DIR_DOWN);
                         break;
             case 19712: MyWorm->AddPivot(DIR_RIGHT);
                         break;

            }
         }

      WaitForRetrace();
      DBuffer->Flip();

       if(Levels[currLev].NumLives<1) GameOver();

       if(Levels[currLev].LevelProgr==Levels[currLev].NumFood)
        NextLevel();

       if(Levels[currLev].WormDeath) TryAgain(currLev);

  }

   Release();
   SetVgaMode(TEXT_MODE);

    return 0;

}
//---------------------------------------------------------------------------