-- msg.e - Character conversion - HIP 2.1
-- Copyright (C) 2001  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file overwrites Euphoria built-ins puts and printf with routines
-- that convert the character set of the message before displaying.

include misc.e

constant
	 ch_dos = "Ƶǂӡآ壖",
	 ch_win = "",
	 ch_lnx = "aaaaaAAAAAeeeeEEEEiiiiIIIIoooooOOOOOuuuuUUUUyyYnNcC",
	 ch_src = ch_win

-- Choose character table to use
sequence chars

if platform() = DOS32 then chars = ch_dos
elsif platform() = WIN32 then chars = ch_dos
else chars = ch_lnx end if      -- no special chars

function fix_msg (object x)

    -- Changes the special characters in ch_src into their
    -- counterparts in chars.
    atom p

    if atom(x) then
	p = find (x, ch_src)
	if p then return chars[p] else return x end if
    end if

    for n = 1 to length(x) do
	p = find (x[n], ch_src)
	if p then x[n] = chars[p] end if
    end for
    return x

end function


global procedure puts_scr (object x)
    puts(1, fix_msg (x) )
end procedure


global procedure printf_scr (object st, object x)
    printf (1, fix_msg (st), x )
end procedure

