unit rezklav;
{Rezidentni obsluha klavesnice. Cte polohove kody, ktere pak pomoci tabulek}
{prevedu do ASCII znaku. Vse si udelam sam a nebudu zavisly na DOSovych}
{ovladacich klavesnice}
{Tato unita umi rozlisovat mezi normalnimi sipkami a sipkami na numericke
klavesnici. Pro pohodli programatora ale rovnez definuje kody, ktere mezi
nimi neodlisuji.
napr. Sipka vpravo na numericke klavesnici dava:
KEY_NUM_6 = true a KEY_CURSOR_RIGHT = true
Seda sipka vpravo dava:
KEY_G_CURSOR_RIGHT = true a KEY_CURSOR_RIGHT = true.
Vidite, ze KEY_CURSOR_RIGHT zustava spolecne.

Jestlize zavolate ZapniObsluhuKlavesnice s parametrem KL_S_BIOSEM, tak dal
budou normalne fungovat standardni funkce klavesnice jako
ReadKey, KeyPressed a vubec cely BIOS okolo klavesnice. Na druhou stranu se
musite starat, aby klavesnice nepipala.
Kdyz zavolate ZapniObsluhuKlavesnice(KL_BEZ_BIOSU) tak pipat zarucene nebude,
ale prestanou fungovat standardni pascali funkce okolo klavesnice.}


{Pri pohledu do zdrojaku zarazi velice bizarni chovani klavesy Pause.
Posila velice exotickou sekvenci a hlavne nesignalizuje uvolneni klavesy.
Zvlastne se taky taky chova Printscreen. Pri zmacknuti totiz vysle 4-bajtovou
sekvenci. Pokud ho ale nepustime, ale drzime dal, tak periodicky vysila
jinou, a to 2-bajtovou sekvenci. Periodicke vysilani maji rovnez oba Alty.}


{$IFDEF FPC}{$MODE FPC}{$ENDIF}

{$Q-}     {debugovaci informace musi byt v kazdem pripade povypinana}
{$R-}     {jinak se to cele zhrouti}
{$S-}
{$D-}
{$F+}

{$DEFINE OPATRNOST}   {Zda se, ze je mozne ji vypnout...}

interface
{$IFDEF FPC}
uses go32;
{$ELSE}
uses dos;
{$ENDIF}

const KL_S_BIOSEM  = true;
      KL_BEZ_BIOSU = false;

type kevent = record
     scan:byte;
     ascii:word;
     priznaky:word;
     end;

_xReadkey_Doplnek = function(b:byte):kevent;
_xKeyPressed_Doplnek = function(b:byte):boolean;


{Funkce starajici se o klavesnici pomoci sluzeb DOSu a BIOSu}
function xReadKey:kevent;
function xKeyPressed:boolean;
Procedure HlidejKlavesy;
Procedure ZhltniKlavesu;
function lKeyPressed:boolean;  {nahrada KeyPressed - nejak mi to funguje lepe}
Function KeyPriznaky:word;     {detekce CTRL, ALT a podobne}
function Je_CapsLock:boolean;
function Je_NumLock:boolean;
function Je_CTRL:boolean;
function Je_ALT:boolean;
Function Je_Shift:boolean;
Function PrelozAlt(w:word):byte;
Function PsaciKlavesa:boolean;

{Obsluha handleru}
procedure ZapniObsluhuKlavesnice(rezim:boolean);
procedure VypniObsluhuKlavesnice;

const
{kody klaves, jak je vraci funkce xReadkey (diky Mircosofte) }
xF1=315;  xShiftF1=340;  xCtrlF1=350;    xAltF1=360;
xF2=316;  xShiftF2=341;  xCtrlF2=351;    xAltF2=361;
xF3=317;  xShiftF3=342;  xCtrlF3=352;    xAltF3=362;
xF4=318;  xShiftF4=343;  xCtrlF4=353;    xAltF4=363;
xF5=319;  xShiftF5=344;  xCtrlF5=354;    xAltF5=364;
xF6=320;  xShiftF6=345;  xCtrlF6=355;    xAltF6=365;
xF7=321;  xShiftF7=346;  xCtrlF7=356;    xAltF7=366;
xF8=322;  xShiftF8=347;  xCtrlF8=357;    xAltF8=367;
xF9=323;  xShiftF9=348;  xCtrlF9=358;    xAltF9=368;
xF10=324; xShiftF10=349; xCtrlF10=359;   xAltF10=369;
xF11=389; xShiftF11=391; xCtrlF11=393;   xAltF11=395;
xF12=390; xShiftF12=392; xCtrlF12=394;   xAltF12=396;
xLSipka=331; {xShiftLSipka=331;} xCtrlLSipka=371;  xAltLsipka=411;
xPSipka=333; {xShiftPSipka=333;} xCtrlPSipka=372;  xAltPSipka=413;
xHSipka=328; {xShiftHSipka=328;} xCtrlHSipka=397;  xAltHSipka=408;
xDSipka=336; {xShiftDSipka=336;} xCtrlDSipka=401;  xAltDSipka=416;
xAltX =301;
xIns=338;xDel=339;xBackSpace=8;
xHome=327;xEndk=335;xPgUp=329;xPgDn=337;xCtrlPgUp=388;
xCtrlG=7;xEnter=13;xESC=27;xTAB=9;xCtrlPgDn=374;xMezera=32;

xsLSipka=75;  xsHome=71;  xsDel=83;
xsPSipka=77;  xsEndk=79;  xsBackSpace=14;
xsHSipka=72;  xspgup=73;  xsCTRLins=146;
xsDSipka=80;  xspgdn=81;  xsIns=82;


Je_klavesa:boolean = false;
xKlavesa:kevent = (scan:0;ascii:0;priznaky:0);

xReadkey_Doplnek : _xReadkey_Doplnek = nil;
xKeyPressed_Doplnek : _xKeyPressed_Doplnek = nil;


{$I rezklav.inc}  {kody klaves}
var


    kl_kod:word;
    kl_zmena:boolean;
    vsechny_klavesy : Array[0..160] of boolean;
    AltBuf:word;

implementation
const kbdint = $9;
      levy_shift = 42;
      pravy_shift = 54;
      odpocet:byte=0;
      nulovani_klavesnice:boolean = false;

alt_w: array [1..27] of word =
    (272,273,274,275,276,277,278,279,280,281,
     286,287,288,289,290,291,292,293,294,
     300,301,303,303,304,305,306,307);

alt_s: string = 'qwertyuiopasdfghjklzxcvbnm';

var
    {$IFDEF FPC}
    oldint9_handler:tseginfo;
    newint9_handler:tseginfo;
    backupDS:Word; external name '___v2prt0_ds_alias';
    {$ELSE}
    oldint9_handler:pointer;
    newint9_handler:pointer;
    {$ENDIF}

    paltbuf:array[0..6] of byte; {je to zahada, ale se stringem mi to nefungovalo}
    obsluha:pointer;
    bios:boolean;

procedure CtiKod;{$IFNDEF FPC}interrupt;{$ENDIF}
  procedure ZpracujJednotu(alternativa,spolecna,ja:byte);
  begin
  if ja<>0 then vsechny_klavesy[ja]:=(kl_kod<128);
  if kl_kod<128 then vsechny_klavesy[spolecna]:=true else
     if vsechny_klavesy[alternativa]=false then
        vsechny_klavesy[spolecna]:=false;
  end;

  procedure PrectiAltovyBuffer;
  var i,j:longint;
  begin
  if vsechny_klavesy[KEY_ALT]=false then
     begin
     altbuf:=0;
     j:=1;
     for i:=paltbuf[0] downto 1 do
         begin
         altbuf:=altbuf+paltbuf[i]*j;
         j:=j*10;
         end;
     paltbuf[0]:=0;
     end;
  end;

var klmod128,op:byte;
    ab:byte;

begin
{$IFDEF FPC}kl_kod:=InPortB($60);{$ELSE}kl_kod:=Port[$60];{$ENDIF}
if kl_kod=$e1 then
   if odpocet=0 then odpocet:=7 else else {krkolome osetreni Pause}
if kl_kod=$e0 then
   if odpocet=0 then odpocet:=2 else else

if odpocet<3 then
   begin
   kl_zmena:=true;
   klmod128:=kl_kod mod 128;

   vsechny_klavesy[KEY_PAUSE]:=false;     {vopruz z Pause}
   vsechny_klavesy[KEY_CTRLBREAK]:=false; {stejne se chova CTRL-break}

   op:=odpocet;
   odpocet:=0;
   case op of
      2:case klmod128 of
           69:vsechny_klavesy[KEY_PAUSE]:=true;         {Pause}
           70:vsechny_klavesy[KEY_CTRLBREAK]:=true;     {CTRL-break}
           55:vsechny_klavesy[KEY_PRINT]:=(kl_kod<128); {Printscreen poprve}
        end;

      1:case klmod128 of
           71..83:ZpracujJednotu(klmod128,klmod128+Priznak_jednoty,klmod128+Priznak_sedych_sipek);
           28:ZpracujJednotu(KEY_G_ENTER,KEY_ENTER,KEY_NUM_ENTER);{sedy Enter}
           56:begin
              ZpracujJednotu(KEY_LALT,KEY_ALT,KEY_PALT);          {pravy Alt}
              PrectiAltovyBuffer;
              end;
           29:ZpracujJednotu(KEY_LCTRL,KEY_CTRL,KEY_PCTRL);       {pravy Ctrl}
           55:vsechny_klavesy[KEY_PRINT]:=(kl_kod<128); {Printscreen opakovane}
           42,70:odpocet:=4;  {4-bajtova sekvence E0,neco,E0,neco}
           else vsechny_klavesy[klmod128]:=(kl_kod<128);
        end;

      0:begin
        vsechny_klavesy[klmod128]:=(kl_kod<128);
        case klmod128 of
           71..83:ZpracujJednotu(klmod128+Priznak_sedych_sipek,klmod128+Priznak_jednoty,klmod128);
           28:ZpracujJednotu(KEY_NUM_ENTER,KEY_ENTER,0); {num Enter}
           56:begin
              ZpracujJednotu(KEY_PALT,KEY_ALT,0);        {levy Alt}
              PrectiAltovyBuffer;
              end;
           29:ZpracujJednotu(KEY_PCTRL,KEY_CTRL,0);      {l. Ctrl}
           42:ZpracujJednotu(KEY_PSHIFT,KEY_SHIFT,0);    {l. Shift}
           54:ZpracujJednotu(KEY_LSHIFT,KEY_SHIFT,0);    {p. Shift}
        end;

        if (kl_kod<128) and (vsechny_klavesy[KEY_ALT]) then
           begin {drzime Alt a pritom byla}{zmacknuta klavesa na numericke klavesnici?}
           case kl_kod of
              71:ab:=7;
              72:ab:=8;
              73:ab:=9;
              75:ab:=4;
              76:ab:=5;
              77:ab:=6;
              79:ab:=1;
              80:ab:=2;
              81:ab:=3;
              82:ab:=0;
              56:ab:=11;    {komplikace - periodicke vysilani Altu}
              else ab:=10;
           end;
           if ab<>11 then
              if ab=10 then paltbuf[0]:=0 else
                 if paltbuf[0]<5 then
                    begin
                    inc(paltbuf[0]);
                    paltbuf[paltbuf[0]]:=ab;
                    end
                    else begin
                    paltbuf[0]:=1;
                    paltbuf[1]:=ab;
                    end;
           end;
        end;
   end; {case odpocet}
   if kl_kod>127 then kl_kod:=0 else
      if vsechny_klavesy[KEY_SHIFT] then inc(kl_kod,1000); {musim mit na pameti shifty}
   end;

if odpocet>0 then dec(odpocet);

{$IFDEF FPC}
if bios=false then
   OutPortB($20,$20);

{$ELSE}
if bios=false then
   Port[$20]:=$20 else
   begin
   asm
   call oldint9_handler
   end;
   end;
{$ENDIF}
end;
procedure CtiKod_dummy; begin end;

{$IFDEF FPC}
procedure int9_handler; assembler;
asm
cli
{$IFDEF OPATRNOST}
push ds
push es
push fs
push gs
pusha
{$ENDIF}
   mov ax,cs:[backupDS]
   mov ds,ax
   mov es,ax
   mov ax,dosmemselector
   mov fs,ax
   call obsluha
{$IFDEF OPATRNOST}
popa
pop gs
pop fs
pop es
pop ds
{$ENDIF}
jmp cs:[oldint9_handler]
sti
end;
procedure int9_dummy; begin end;

procedure int9_nbhandler; assembler;interrupt;
asm
cli
{$IFDEF OPATRNOST}
push ds
push es
push fs
push gs
pusha
{$ENDIF}
   mov ax,cs:[backupDS]
   mov ds,ax
   mov es,ax
   mov ax,dosmemselector
   mov fs,ax
   call obsluha
{$IFDEF OPATRNOST}
popa
pop gs
pop fs
pop es
pop ds
{$ENDIF}
sti
end;
procedure int9_nbdummy; begin end;
{$ENDIF FPC}

procedure ZapniObsluhuKlavesnice(rezim:boolean);
begin
kl_zmena:=false;
bios:=rezim;
altbuf:=0;
FillChar(paltbuf,sizeof(paltbuf),0);
FillChar(vsechny_klavesy,sizeof(vsechny_klavesy),0);
obsluha:=@CtiKod;

{$IFDEF FPC}
lock_data(obsluha, sizeof(obsluha));
lock_data(kl_kod, sizeof(kl_kod));
lock_data(bios, sizeof(bios));
lock_data(kl_zmena, sizeof(kl_zmena));
lock_data(odpocet, sizeof(odpocet));
lock_data(paltbuf, sizeof(paltbuf));
lock_data(altbuf, sizeof(altbuf));
lock_data(vsechny_klavesy,sizeof(vsechny_klavesy));
lock_data(dosmemselector, sizeof(dosmemselector));
lock_data(backupDS, sizeof(backupDS));
lock_data(oldint9_handler, sizeof(oldint9_handler));

lock_code(@CtiKod,longint(@CtiKod_dummy) - longint(@CtiKod));
if bios then
   begin
   lock_code(@int9_handler,longint(@int9_dummy)-longint(@int9_handler));
   newint9_handler.offset:=@int9_handler;
   end
   else begin
   lock_code(@int9_nbhandler,longint(@int9_nbdummy)-longint(@int9_nbhandler));
   newint9_handler.offset:=@int9_nbhandler;
   end;
newint9_handler.segment:=get_cs;
get_pm_interrupt(kbdint, oldint9_handler);
set_pm_interrupt(kbdint, newint9_handler);
{$ELSE}
newint9_handler:=@ctikod;
GetIntVec(kbdint, oldint9_handler);
SetIntVec(kbdint, newint9_handler);
{$ENDIF}
end;

procedure VypniObsluhuKlavesnice;
begin
{$IFDEF FPC}
set_pm_interrupt(kbdint, oldint9_handler);
unlock_data(dosmemselector, sizeof(dosmemselector));
unlock_data(kl_kod, sizeof(kl_kod));
unlock_data(bios, sizeof(bios));
unlock_data(kl_zmena, sizeof(kl_zmena));
unlock_data(odpocet, sizeof(odpocet));
unlock_data(paltbuf, sizeof(paltbuf));
unlock_data(altbuf, sizeof(altbuf));
unlock_data(vsechny_klavesy,sizeof(vsechny_klavesy));
unlock_data(obsluha, sizeof(obsluha));
unlock_data(backupDS, sizeof(backupDS));
unlock_data(oldint9_handler, sizeof(oldint9_handler));

unlock_code(@CtiKod,longint(@CtiKod_dummy) - longint(@CtiKod));
if bios then
   unlock_code(@int9_handler,longint(@int9_dummy)-longint(@int9_handler)) else
   unlock_code(@int9_nbhandler,longint(@int9_nbdummy)-longint(@int9_nbhandler));
{$ELSE}
SetIntVec(kbdint, oldint9_handler);
{$ENDIF}
end;


Function lKeyPressed:boolean;assembler;
asm
mov ah,11h
int 16h
mov al,1
jnz @stisknuto
mov al,0
@stisknuto:
end;

Function KeyPriznaky:word;assembler;
asm
mov ax,1200h
int 16h
end;

function xKeyPressed:boolean;
begin
if xKeyPressed_Doplnek=nil
   then xKeyPressed:=LKeyPressed
   else xKeyPressed:=xKeyPressed_Doplnek(0);
end;

function xReadKey:kevent;
var e:kevent;
    a,c:word;b:byte;
    regs:trealregs;

begin

{ae.ascii:=10;}

if xReadKey_Doplnek=nil
   then begin
   asm
@znovu:
   mov ax,1100h
   int 16h
   jz @znovu             {cekej, nez se v bufferu neco objevi}
   mov b,ah              {zapamatuj si scan kod/rozsireny kod}

   mov bh,255
@opet:
   mov ax,0600h
   mov dl,0ffh
   int 21h
   inc bh
   cmp al,0
   jz @opet
   mov ah,bh
   mov a,ax

   mov ax,1200h
   int 16h
   mov c,ax

   end;
   e.ascii:=a;
   e.scan:=b;
   e.priznaky:=c;
   end
   else e:=xReadkey_Doplnek(0);

xReadKey:=e;
End;{xreadkey}

function Je_CapsLock:boolean;
begin
Je_CapsLock:=(xKlavesa.priznaky and 64)<>0;
end;

function Je_NumLock:boolean;
begin
Je_Numlock:=(xKlavesa.priznaky and 32)<>0;
end;

function Je_CTRL:boolean;
begin
Je_CTRL:=(xKlavesa.priznaky and 4)<>0;
end;

function Je_ALT:boolean;
begin
Je_ALT:=(xKlavesa.priznaky and 8)<>0;
end;


Function Je_Shift:boolean;
begin
Je_shift:=(xKlavesa.priznaky and 3)<>0;
end;

Procedure HlidejKlavesy;
begin
Je_Klavesa:=xKeypressed;
if Je_klavesa=true then
   begin
   xKlavesa:=xReadKey;
   nulovani_klavesnice:=true;
   end
   else
   if nulovani_klavesnice then
      begin
      FillChar(xKlavesa,SizeOf(xKlavesa),0);
      nulovani_klavesnice:=false;
      end;
end;


Procedure ZhltniKlavesu;
begin
xKlavesa.scan:=0;
xKlavesa.ascii:=0;
end;


Function PrelozAlt(w:word):byte;
var i: byte;
begin
for i:=1 to 27 do
   if alt_w[i]=w then Exit(byte(alt_s[i]));
PrelozAlt:=0;
end;


Function PsaciKlavesa:boolean;
begin
if Je_alt=false then
   begin
   if (xKlavesa.Scan>70) and (xKlavesa.Scan<84) and (Je_NumLock=false)
      then Exit(false);
   if (xKlavesa.ASCII>31) and (xKlavesa.ASCII<256) then Exit(true);
   if (xKlavesa.Scan>1) and (xKlavesa.Scan<14) then Exit(true);
   if (xKlavesa.Scan>15) and (xKlavesa.Scan<28) then Exit(true);
   if (xKlavesa.Scan>29) and (xKlavesa.Scan<54) then Exit(true);
   if xKlavesa.Scan=41 then Exit(true);
   if xKlavesa.Scan=86 then Exit(true);
   end;
PsaciKlavesa:=false;
end;

end.
