;**********************************;
; WASM Input Module                ;
; By Eric Tauck                    ;
;                                  ;
; Defines:                         ;
;                                  ;
;   InpVer  verify an action       ;
;   InpEsc  prompt and escape      ;
;   InpStr  input a string         ;
;                                  ;
; Requires:                        ;
;                                  ;
;   CASE1.ASM                      ;
;   KEYBRD.ASM                     ;
;   PROMPT.ASM                     ;
;   VIDEO4.ASM                     ;
;   VIDEO5.ASM                     ;
;**********************************;

        jmp     _input_end

;========================================
; Display a prompt and wait for a 'Y'
; for yes or 'N' for no.
;
; In: AX= prompt; CL= width.
;
; Out: CY= set if cancel ('N' or ESC).

InpVer  PROC    NEAR

;--- display prompt

        call    ProVer          ;display prompt
        call    KeyClr          ;clear input

        mov     al, -1
        call    CurSet          ;cursor on
        push    ax              ;save cursor state

;--- wait for key

_ipver1 call    KeyWai          ;wait for key key
        cmp     ax, KEY_ESC     ;check if cancel
        je      _ipver2
        or      ah, ah          ;check if extended code
        jnz     _ipver1
        call    ChrUpr          ;convert to uppercase
        cmp     al, 'N'         ;check if No
        je      _ipver2
        cmp     al, 'Y'         ;check if Yes
        jne     _ipver1

;--- accept

        pop     ax
        call    CurSet          ;restore cursor state
        clc
        ret

;--- cancel

_ipver2 pop     ax
        call    CurSet          ;restore cursor state
        stc
        ret
        ENDP

;========================================
; Display a prompt and wait for the ESC
; key.  Any key except ESC is replaced.

InpEsc  PROC    NEAR

;--- display prompt

        call    ProEsc          ;display prompt
        call    KeyClr          ;clear input

;--- wait for key

        sub     al, al
        call    CurSet          ;cursor off
        push    ax              ;save state

        call    KeyWai          ;wait for key
        cmp     ax, KEY_ESC     ;check if escape
        je      _ipesc1         ;skip if so
        call    KeyRep          ;put keystroke back

_ipesc1 pop     ax
        call    CurSet          ;restore cursor
        ret
        ENDP

;========================================
; Input a string.
;
; In: AX= prompt; BX= place to store
;     input; CL= width.
;
; Out: AL= byte count; CY= set if no
;      input or cancel.

InpStr  PROC    NEAR
        push    di
        push    si
        push    bp

        mov     si, bx          ;home buffer location in SI

;--- display prompt

        call    ProWrt          ;display prompt
        dec     ax              ;total characters
        mov     di, ax

        call    CurPos          ;get home cursor position
        mov     bp, ax          ;save it

        mov     al, -1
        call    CurSet          ;cursor on
        push    ax              ;save state

        mov     cx, di          ;max characters in CL
        sub     ch, ch          ;current characters in CH
        mov     di, si          ;current buffer location in DI

;--- get keystroke

_ipget1 push    cx
        call    KeyWai          ;wait for a keystroke
        pop     cx
        cmp     ax, KEY_BKSP    ;BACKSPACE
        je      _ipget2
        cmp     ax,KEY_CTL_BKSP ;CTL-BACKSPACE
        je      _ipget3
        cmp     ax, KEY_ESC     ;ESCAPE
        je      _ipget4
        cmp     ax, KEY_ENTER   ;ENTER
        je      _ipget5
        or      ah, ah          ;check if extended key
        jnz     _ipget1
        cmp     al, 32          ;check if control key
        jb      _ipget1

;--- store character

        cmp     cl, ch          ;check if too long
        je      _ipget1         ;ignore if so

        inc     ch              ;increment bytes
        cld
        stosb                   ;store character

        push    cx
        call    WrtChr          ;display character
        call    CurAdv          ;advance cursor
        pop     cx
        jmps    _ipget1

;--- backspace, delete last character

_ipget2 or      ch, ch          ;check if any characters
        jz      _ipget1         ;ignore if not

        dec     ch              ;decrement bytes
        dec     di              ;decrement pointer

        push    cx
        call    CurPos          ;get current position
        dec     al              ;decrement column
        call    CurMov          ;position cursor
        mov     al, ' '         ;space
        call    WrtChr          ;blank last character
        pop     cx
        jmps    _ipget1

;--- ^backspace, delete whole line

_ipget3 or      ch, ch          ;check if any characters
        jz      _ipget1         ;ignore if not

        mov     di, si          ;reset pointer
        sub     ch, ch          ;zero bytes

        push    cx
        push    cx
        mov     ax, bp          ;home position
        call    CurMov          ;move cursor
        pop     cx
        mov     al, ' '         ;space
        inc     cl              ;extra space for end cursor
        call    WrtChrs         ;write characters
        pop     cx
        jmps    _ipget1

;--- escape, cancel input

_ipget4 mov     di, si          ;reset pointer

;--- finished with input

_ipget5 pop     ax
        call    CurSet          ;restore cursor

        mov     BYTE [di], 0    ;store NUL

        mov     ax, di          ;current location
        sub     ax, si          ;get bytes

        pop     bp
        pop     si
        pop     di
        cmp     ax, 1           ;set carry if no input
        ret
        ENDP

_input_end
