;**********************************;
; WASM Keyboard Module             ;
; By Eric Tauck                    ;
;                                  ;
; Defines:                         ;
;                                  ;
;   KeyGet  get key if available   ;
;   KeyWai  wait for a keystroke   ;
;   KeyRep  replace a keystroke    ;
;   KeyHit  return keyboard status ;
;   KeyClr  clear keyboard buffer  ;
;**********************************;

        jmps    _keybrd_end

_key_put        DW      0       ;put back keystroke

;========================================
; Keystroke constants.

KEY_BKSP        EQU     8
KEY_TAB         EQU     9
KEY_ENTER       EQU     13
KEY_ESC         EQU     27

KEY_SHF_TAB     EQU     -15

KEY_CTL_ENTER   EQU     10
KEY_CTL_SLASH   EQU     28
KEY_CTL_MINUS   EQU     31
KEY_CTL_BKSP    EQU     127

KEY_ALT_MINUS   EQU     -130
KEY_ALT_EQUAL   EQU     -131

;--- number keys

KEY_CTL_2       EQU     3
KEY_CTL_6       EQU     30

KEY_ALT_0       EQU     -129
KEY_ALT_1       EQU     -120
KEY_ALT_2       EQU     -121
KEY_ALT_3       EQU     -122
KEY_ALT_4       EQU     -123
KEY_ALT_5       EQU     -124
KEY_ALT_6       EQU     -125
KEY_ALT_7       EQU     -126
KEY_ALT_8       EQU     -127
KEY_ALT_9       EQU     -128

;--- letter keys

KEY_CTL_A       EQU     1
KEY_CTL_B       EQU     2
KEY_CTL_C       EQU     3
KEY_CTL_D       EQU     4
KEY_CTL_E       EQU     5
KEY_CTL_F       EQU     6
KEY_CTL_G       EQU     7
KEY_CTL_H       EQU     8
KEY_CTL_I       EQU     9
KEY_CTL_J       EQU     10
KEY_CTL_K       EQU     11
KEY_CTL_L       EQU     12
KEY_CTL_M       EQU     13
KEY_CTL_N       EQU     14
KEY_CTL_O       EQU     15
KEY_CTL_P       EQU     16
KEY_CTL_Q       EQU     17
KEY_CTL_R       EQU     18
KEY_CTL_S       EQU     19
KEY_CTL_T       EQU     20
KEY_CTL_U       EQU     21
KEY_CTL_V       EQU     22
KEY_CTL_W       EQU     23
KEY_CTL_X       EQU     24
KEY_CTL_Y       EQU     25
KEY_CTL_Z       EQU     26

KEY_ALT_A       EQU     -30
KEY_ALT_B       EQU     -48
KEY_ALT_C       EQU     -46
KEY_ALT_D       EQU     -32
KEY_ALT_E       EQU     -18
KEY_ALT_F       EQU     -33
KEY_ALT_G       EQU     -34
KEY_ALT_H       EQU     -35
KEY_ALT_I       EQU     -23
KEY_ALT_J       EQU     -36
KEY_ALT_K       EQU     -37
KEY_ALT_L       EQU     -38
KEY_ALT_M       EQU     -50
KEY_ALT_N       EQU     -49
KEY_ALT_O       EQU     -24
KEY_ALT_P       EQU     -25
KEY_ALT_Q       EQU     -16
KEY_ALT_R       EQU     -19
KEY_ALT_S       EQU     -31
KEY_ALT_T       EQU     -20
KEY_ALT_U       EQU     -22
KEY_ALT_V       EQU     -47
KEY_ALT_W       EQU     -17
KEY_ALT_X       EQU     -45
KEY_ALT_Y       EQU     -21
KEY_ALT_Z       EQU     -44

;--- arrow keys

KEY_LEFT        EQU     -75
KEY_RIGHT       EQU     -77
KEY_UP          EQU     -72
KEY_DOWN        EQU     -80
KEY_PGUP        EQU     -73
KEY_PGDN        EQU     -81
KEY_HOME        EQU     -71
KEY_END         EQU     -79

KEY_CTL_LEFT    EQU     -115
KEY_CTL_RIGHT   EQU     -116
KEY_CTL_PGUP    EQU     -132
KEY_CTL_PGDN    EQU     -118
KEY_CTL_HOME    EQU     -119
KEY_CTL_END     EQU     -117

KEY_INS         EQU     -82
KEY_DEL         EQU     -83

;--- function keys

KEY_F1          EQU     -59
KEY_F2          EQU     -60
KEY_F3          EQU     -61
KEY_F4          EQU     -62
KEY_F5          EQU     -63
KEY_F6          EQU     -64
KEY_F7          EQU     -65
KEY_F8          EQU     -66
KEY_F9          EQU     -67
KEY_F10         EQU     -68

KEY_SHF_F1      EQU     -84
KEY_SHF_F2      EQU     -85
KEY_SHF_F3      EQU     -86
KEY_SHF_F4      EQU     -87
KEY_SHF_F5      EQU     -88
KEY_SHF_F6      EQU     -89
KEY_SHF_F7      EQU     -90
KEY_SHF_F8      EQU     -91
KEY_SHF_F9      EQU     -92
KEY_SHF_F10     EQU     -93

KEY_CTL_F1      EQU     -94
KEY_CTL_F2      EQU     -95
KEY_CTL_F3      EQU     -96
KEY_CTL_F4      EQU     -97
KEY_CTL_F5      EQU     -98
KEY_CTL_F6      EQU     -99
KEY_CTL_F7      EQU     -100
KEY_CTL_F8      EQU     -101
KEY_CTL_F9      EQU     -102
KEY_CTL_F10     EQU     -103

KEY_ALT_F1      EQU     -104
KEY_ALT_F2      EQU     -105
KEY_ALT_F3      EQU     -106
KEY_ALT_F4      EQU     -107
KEY_ALT_F5      EQU     -108
KEY_ALT_F6      EQU     -109
KEY_ALT_F7      EQU     -110
KEY_ALT_F8      EQU     -111
KEY_ALT_F9      EQU     -112
KEY_ALT_F10     EQU     -113

;========================================
; Input a keystroke if available.
;
; Out: AX= keystroke (extended keystrokes
;      are returned as a special 16 bit
;      value equated above); CY= set if
;      keystroke unavailable.

KeyGet  PROC    NEAR
        cmp     _key_put, 1     ;check if key waiting
        jnc     _kychk1         ;jump if so (also CY is cleared)

        mov     ah, 6           ;direct console i/o
        mov     dl, 0FFH        ;input subfunction
        int     21H             ;execute
        jnz     _kychk2         ;jump if key
        sub     ax, ax          ;return zero (non-key)
        stc
        ret

;--- key in buffer

_kychk1 mov     ax, _key_put    ;return key
        mov     _key_put, 0     ;zero storage
        ret

;--- standard code

_kychk2 or      al, al          ;check if extended code
        jz      _kychk3         ;jump if so
        sub     ah, ah          ;zero high byte
        clc
        ret

;--- extended code

_kychk3 mov     ah, 6           ;direct console i/o
        mov     dl, 0FFH        ;input subfunction
        int     21H             ;execute
        sub     ah, ah          ;zero high byte
        neg     ax              ;return negative
        clc
        ret
        ENDP

;========================================
; Input a keystroke.
;
; Out: AX= keystroke (extended keystrokes
;      are returned as a special 16 bit
;      value equated above).

KeyWai  PROC    NEAR
_kyget1 call    KeyGet          ;get keystroke
        jc      _kyget1         ;loop until key
        ret
        ENDP

;========================================
; Replace a keystroke.
;
; In: AX= keystroke.

KeyRep  PROC    NEAR
        mov     _key_put, ax
        ret
        ENDP

;========================================
; Return the keyboard status.
;
; Out: CY= set if key unavailable.
;
; NOTE: ^S doesn't work right with this
; DOS function (at least my DOS). If ^S
; is pressed, DOS will pause within func-
; tion 0BH. When a second key is pressed
; to un-pause DOS, the keystroke is
; absorbed by DOS but the function says
; a keystroke is available (which there
; isn't).  The other functions use
; KeyGet which performs almost the same
; task but has no trouble with ^S.

KeyHit  PROC    NEAR
        cmp     _key_put, 1     ;check if greater than zero
        jnc     _kyhit1         ;jump if so, CY cleared
        mov     ah, 0BH         ;keyboard status function
        int     21H             ;execute
        cmp     al, 0FFH        ;set carry if not FFH
_kyhit1 ret
        ENDP

;========================================
; Clear keyboard buffer.

KeyClr  PROC    NEAR
_kyclr1 call    KeyGet
        jnc     _kyclr1
        ret
        ENDP

_keybrd_end
