;***************************************
; This demo OBJ module defines routines
; to load and store a value to and from
; a local variable.
;
; Defines:
;
;   Store  store a 16 bit value
;   Load   load a 16 bit value
;
; Assemble as:
;
;   WASM test test.obj

        INCLUDE 'object.inc'

        INIT    'TEST.ASM', 'WASM', 'CODE', ALIGN_PARA + COMBINE_PRIVATE

        PUBLIC  Store, 'STORE'
        PUBLIC  Load, 'LOAD'

        BEGIN

;--- store routine

Store   PROC    FAR
        push    bp
        mov     bp, sp          ;stack
        push    ds
        mov     ax, cs          ;load data segment
        mov     ds, ax          ;
        mov     ax, [bp+6]      ;get value from stack
        mov     storage, ax     ;save it
        pop     ds
        pop     bp
        ret     2
        ENDP

;--- load routine

Load    PROC    FAR
        push    ds
        mov     ax, cs          ;load data segment
        mov     ds, ax          ;
        mov     ax, storage     ;return value
        pop     ds
        ret
        ENDP

;--- storage variable

storage DW      ?               ;variable

        END
