
;CLOCK EXAMPLE BY D. E. JOHNSON
;ILLUSTRATE INTERRUPT SET-UP/OPERATION
;CLOCK = TYPE 8 INTERRUPT
;ATTRIBUTE OF FIRST CHAR CHANGES EVERY SECOND
;UNTIL A KEY IS PRESSED (THEN EXIT)
	MOV	AL,36H	;CNT0 CONTROL
	OUT	43H,AL	;SET FOR WORD TRANSFER
	MOV	AX,11925 ;COUNTS PER PERIOD
	OUT	40H,AL	;LSB TO CNT0
	MOV	AL,AH
	OUT	40H,AL	;MSB (CYCLE = .01 SEC)
	MOV	BX,2	;CLEAR BH & SET ADDR
	MOV	DS,BX	;TO DS:BX (=00022H)
	PUSH WORD [BX]	;SAVE OLD CLK-CS
	PUSH WORD [BX-2] ;& OLD CLK-IP
	CLI		;NO INTERRUPTS HERE
	MOV	[BX],CS ;SET NEW CLK-CS
	MOV WORD [BX-2],OFFSET CLKINT ;& CLK-IP
	STI		;INTERRUPTS O. K.
	MOV	AX,0B800H ;VIDEO MEMORY
	MOV	ES,AX
	PUSH	CS	;DS <-- CS
	POP	DS	;NORMAL DATA
	MOV	CX,100	;TICKS PER SECOND
;BH holds the previous CNT value (0 initially)
REPT	MOV	AL,CNT	;CHECK FOR CHANGE
	CMP	AL,BH	;DIFFERENT?
	JE	UNTIL
	MOV	BH,AL	;FOR NEXT CHANGE TEST
	LOOP	UNTIL	;EVERY .01 SEC 
	MOV	CL,100	;RESET COUNTER EACH SEC
	SEG	ES
	XOR BYTE [1],77H ;REVERSE 1ST ATTRIB.
UNTIL	MOV	AH,1
	INT	16H	;CHECK FOR KEYPRESS
	JZ	REPT	;UNTIL KEYPRESSED
;RESTORE & EXIT
	MOV	AL,0
	OUT	40H,AL	;65536 COUNTS/CYCLE
	OUT	40H,AL	;ORIGINAL VALUE
	MOV	BH,0	;BX=2 yet
	MOV	DS,BX	;TO DS:BX (=00022H)
	CLI
	POP WORD [BX-2] ;RESTORE CLK-IP
	POP WORD [BX]	;& CLK-CS
	STI
	RETN		;DOS RETURN
;*********INTERRUPT ROUTINE********************
CLKINT	PUSH	AX	;SAVE REG USED
	SEG	CS	;VARS IN CS (=ORIG. DS)
	INC BYTE CNT	;CHANGE EACH INTERRUPT
	MOV	AL,20H	;ACKNOWLEDGE CODE TO
	OUT	20H,AL	;INTERRUPT CONTROLLER
	POP	AX
	IRET		;RESTORE IP, CS & FLAGS
;************DATA VARIABLE*********************
CNT	DB	0	;INIT 0, INC EACH INT 8

