;****************************************
; GETKEY -- By Eric Tauck
;
; This program displays a prompt and then
; waits for and retrieves a keystroke from
; the keyboard.  The ASCII code of the
; key is compared to a list of characters
; on the command line and an error code
; index from right to left (starting at
; one) is returned.  This is useful for
; accepting input within batch files.
; Example batch file:
;
;  :loop
;  ECHO OFF
;  CLS
;  ECHO Application Menu
;  ECHO   A. Application One
;  ECHO   B. Application Two
;  ECHO   C. Finished
;  getkey "Enter choice: " abc
;  IF ERRORLEVEL 3 GOTO app1
;  IF ERRORLEVEL 2 GOTO app2
;  IF ERRORLEVEL 1 GOTO finished
;  GOTO loop
;  :app1
;  REM run application one
;  GOTO loop
;  :app2
;  REM run application two
;  GOTO loop
;  :finished
;  REM exit batch file

        mov     al, [0080H]     ;load bytes in command line
        mov     si, 0081H       ;load address of command line data

        or      al, al          ;check if any characters
        jz      b2              ;goto help message if not

;--- skip starting delimiters

b1      cmp     BYTE [si], 32   ;check if space or control character
        ja      b3              ;exit loop if so
        inc     si              ;next character
        dec     al              ;decrement character count
        jnz     b1              ;loop back if more characters

b2      mov     ah, 9           ;print string function
        mov     dx, OFFSET help ;address of help message
        int     21H             ;execute
        sub     bl, bl          ;return code
        jmps    b9              ;goto exit

;--- found start of characters, display message

b3      cmp     BYTE [si], '"'  ;check if double quote
        jne     b2              ;exit if so, goto help message
        mov     bl, al          ;save character count in BL

b4      inc     si
        dec     bl
        jz      b2
        mov     dl, [si]        ;load character
        cmp     dl, '"'         ;check if end of prompt
        je      b5
        mov     ah, 2           ;display function
        int     21H             ;execute
        jmp     b4              ;loop back

;--- skip separating delimiters

b5      inc     si              ;next character
        dec     bl              ;decrement character count
        jz      b2              ;goto help message if out of characters
        cmp     BYTE [si], 32   ;check if space or control character
        jbe     b5              ;continue looping if so
        
;--- get a keystroke

        mov     ah, 8           ;get input function
        int     21H             ;execute
        or      al, al          ;check if extended
        jnz     b6              ;jump if not
        mov     ah, 8           ;get second code
        int     21H             ;execute
        sub     bl, bl          ;return code
        jmps    b9              ;goto exit, can't handle special keys

;--- display key

b6      mov     dl, al          ;character to display
        mov     ah, 2           ;display function
        int     21H             ;execute

;--- convert to uppercase

        cmp     dl, 'a'         ;check if too low
        jb      b7
        cmp     dl, 'z'         ;check if too high
        ja      b7
        sub     dl, 'a'-'A'     ;convert to uppercase

;--- search for character

b7      mov     al, [si]        ;load character
        cmp     al, 'a'         ;check if too low
        jb      b8              ;jump if so
        cmp     al, 'z'         ;check if too high
        ja      b8              ;jump if so
        sub     al, 'a'-'A'     ;convert to uppercase

b8      cmp     al, dl          ;check if match
        je      b9              ;jump if so
        inc     si              ;next character
        dec     bl              ;decrement return code and bytes left
        jnz     b7              ;loop back if more

;--- finished, error code in AL

b9      mov     al, bl          ;return code
        mov     ah, 4CH         ;exit function
        int     21H             ;execute

;--- help message

help    DB      13,10
        DB      '  GETKEY -- By Eric Tauck',13,10
        DB      13,10
        DB      '  Usage: GETKEY "xxxxx" xxxxx',13,10
        DB      13,10
        DB      '    "xxxxx" is a text prompt (use "" for no prompt)',13,10
        DB      '     xxxxx is a sequence of possible input characters',13,10
        DB      13,10
        DB      '  Displays a prompt and then fetches and translates',13,10
        DB      '  a keystroke to a DOS level error code based on the',13,10
        DB      '  sequence of characters.  The error code may be used',13,10
        DB      '  to branch in a batch file.  The last character re-',13,10
        DB      '  turns error code one, the second to last returns',13,10
        DB      '  error code two, etc.',13,10
        DB      '$'
