;================================================
; Printer Reset
;
; Initialize first parallel printer through the
; BIOS printer routine. Once assembled, to
; reset the printer, type:
;
;   PRESET
;
; This routine has the effect of initializing
; the printer to its power on characteristics.

;--- equates

PORT    EQU     0                       ;printer port to initialize

;--- display message

        mov     dx, OFFSET pmess        ;message location
        mov     ah, 9                   ;string output
        int     21H                     ;execute

;--- reset printer port

        mov     ah, 1                   ;function number
        mov     dx, PORT                ;printer port number
        int     17H                     ;execute

;--- exit

        mov     ax, 4C00H               ;function and error code 0
        int     21h                     ;exit

;--- message

pmess   DB      13,10,'Printer ', PORT + '0' + 1 ,' reset', 13,10,'$'
