;**********************;
; SESSION ANSI Support ;
;    By Eric Tauck     ;
;**********************;

a_time1 EQU     36      ;first timeout value (for '['), 2 secs
a_time2 EQU     91      ;timeout value, 5 secs

a_err1  DB      'Timeout during ANSI sequence',0
a_err2  DB      'Too many ANSI arguments',0
a_err3  DB      'Invalid ANSI command: '
a_err3x DB      '?',0

;--- color mappings

a_colors        DB      BLACK, RED, GREEN, BROWN
                DB      BLUE, MAGENTA, CYAN, WHITE

;========================================
; Read an ANSI sequence.  Assume ESC has
; already been read.
;
; In: BX= serial record.

Ansi_Read PROC  NEAR
        push    di
        push    si
        push    bp

        mov     di, bx          ;serial record
        mov     si,OFFSET a_tab ;table
        mov     bp, a_MAX       ;maximum arguments

;--- verify that ESC is really part of ANSI sequence

        mov     ax, a_time1     ;first ANSI timeout value
        call    ComWai          ;wait for '['
        jc      ansrea1
        cmp     al, '['         ;check if '['
        je      ansrea2

;--- probably not an ANSI code

        mov     bx, di
        call    ComRep          ;replace character after ESC

ansrea1 pop     bp
        pop     si
        pop     di
        ret

;--- zero all arguments

ansrea2 push    di
        mov     di, si
        mov     cx, bp          ;number of arguments
        sub     al, al          ;store zero
        cld
        rep
        stosb                   ;fill with zeros
        pop     di
        jmps    ansrea5

;=== loop until non-digit

;--- update parameter by digit

ansrea3 sub     al, '0'         ;convert to digit
        xchg    al, dl          ;put total in AL
        mov     ah, 10          ;number base
        mul     al, ah          ;total times 10
        add     dl, al          ;new total

;--- wait for character

ansrea4 push    dx
        mov     ax, a_time2     ;second ANSI timeout value
        mov     bx, di
        call    ComWai          ;wait for byte
        pop     dx
        jc      ansrea7         ;exit if timeout

;--- process character

        cmp     al, '0'         ;lower range of digit
        jb      ansrea6
        cmp     al, '9'         ;upper range of digit
        jbe     ansrea3
        cmp     al, ';'         ;semicolon
        jne     ansrea6

;--- store value

        dec     bp              ;decrement argument count (requires n+1 args)
        jz      ansrea8         ;exit if too many arguments
        mov     [si], dl        ;store number
        inc     si              ;increment pointer

ansrea5 sub     dl, dl          ;zero current argument
        jmps    ansrea4         ;loop back

;--- command character

ansrea6 mov     [si], dl                ;store last number
        mov     dx, si                  ;final address
        sub     dx, OFFSET a_tab        ;subtract start of table
        inc     dx                      ;adjust
        mov     a_cnt, dx               ;save count

        mov     bx, di
        call    Ansi_Code               ;process code
        pop     bp
        pop     si
        pop     di
        ret

;--- error

ansrea7 mov     ax, OFFSET a_err1       ;timeout
        jmps    ansrea9
ansrea8 mov     ax, OFFSET a_err2       ;too many arguments
ansrea9 call    Command_Error           ;display error message
        pop     bp
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Substitute minimum arguments (ones) for
; zeros.
;
; In: AH,AL= values.
;
; Out: AH,AL= updated.

Ansi_Min PROC   NEAR
        sub     dl, dl
        cmp     dl, al
        cmc
        adc     al, 0
        cmp     dl, ah
        cmc
        adc     ah, 0
        ret
        ENDP

;========================================
; Process an ANSI code and its arguments.
;
; In: AL= code; BX= serial record.

Ansi_Code PROC  NEAR
        push    di
        push    si
        mov     di, rem_win             ;remote window
        mov     si, bx

        mov     dl, al                  ;save command character
        mov     bx, OFFSET a_tab        ;table address
        mov     ax, [bx]                ;load first two arguments

;--- H, f, move cursor

        cmp     dl, 'H'
        je      anscod1
        cmp     dl, 'f'
        jne     anscod2

anscod1 call    Ansi_Min
        sub     ax, 0101H       ;adjust for local coordinate system
        xchg    al, ah          ;swap row and column
        call    Window_Move
        pop     si
        pop     di
        ret

;--- A, cursor up

anscod2 cmp     dl, 'A'
        jne     anscod3

        call    Ansi_Min
        call    Window_Up
        pop     si
        pop     di
        ret

;--- B, cursor down

anscod3 cmp     dl, 'B'
        jne     anscod4

        call    Ansi_Min
        call    Window_Down
        pop     si
        pop     di
        ret

;--- C, cursor right

anscod4 cmp     dl, 'C'
        jne     anscod5

        call    Ansi_Min
        call    Window_Right
        pop     si
        pop     di
        ret

;--- D, cursor left

anscod5 cmp     dl, 'D'
        jne     anscod6

        call    Ansi_Min
        call    Window_Left
        pop     si
        pop     di
        ret

;--- s, save cursor location

anscod6 cmp     dl, 's'
        jne     anscod7

        call    Window_Save
        pop     si
        pop     di
        ret

;--- u, restore cursor location

anscod7 cmp     dl, 'u'
        jne     anscod8

        call    Window_Rest
        pop     si
        pop     di
        ret

;--- 1J clear to end of screen, 2J clear entire screen

anscod8 cmp     dl, 'J'
        jne     anscodB

        call    Ansi_Min
        dec     al
        jz      anscod9
        mov     dl, 'J'         ;reload command if error
        dec     al
        jnz     anscodB

        call    Window_Clear
        jmps    anscodA

anscod9 call    Window_EOS
anscodA pop     si
        pop     di
        ret

;--- K, clear from cursor to end of line

anscodB cmp     dl, 'K'
        jne     anscodC

        call    Window_EOL
        pop     si
        pop     di
        ret

;--- m, set color

anscodC cmp     dl, 'm'
        jne     anscodH

        mov     cx, a_cnt               ;load argument count

anscodD mov     ah, [bx]                ;load color
        inc     bx
        push    bx

        mov     al, ah
        mov     cx, OFFSET Window_Attr  ;attribute set
        cmp     ah, 10                  ;check if attribute set
        jb      anscodF                 ;jump if so

        mov     al, ah
        sub     al, 30                  ;convert to foreground color index
        mov     cx, OFFSET Window_Fore  ;color set routine

        sub     ah, 40                  ;convert to background color index
        jb      anscodE                 ;jump if not background color
        mov     al, ah
        mov     cx, OFFSET Window_Back  ;color set routine

anscodE cmp     al, 7                   ;check upper range
        ja      anscodG                 ;skip if too big

        mov     bl, al
        sub     bh, bh
        mov     al, [a_colors+bx]       ;load color

anscodF call    cx                      ;set color
anscodG pop     bx

        dec     a_cnt
        jnz     anscodD

        pop     si
        pop     di
        ret

;--- 6n, device status report (assume '6' argument)

anscodH cmp     dl, 'n'
        jne     anscodI

        push    bp
        StkAll  bp, 4

        mov     al, ESC
        mov     bx, si
        call    ComPut                  ;send ESC

        mov     al, '['
        mov     bx, si
        call    ComPut                  ;send bracket

        call    Window_Position         ;get position
        add     ax, 0101H               ;adjust
        push    ax                      ;save column

        mov     al, ah
        sub     ah, ah
        sub     dx, dx
        mov     cx, 10
        mov     bx, bp
        call    Num2Str                 ;convert to string
        mov     ax, bp
        call    StrLen                  ;get length
        mov     cx, ax
        mov     ax, bp
        mov     bx, si
        call    ComWri                  ;write string

        mov     al, ';'
        mov     bx, si
        call    ComPut

        pop     ax
        sub     ah, ah
        sub     dx, dx
        mov     cx, 10
        mov     bx, bp
        call    Num2Str                 ;convert to string
        mov     ax, bp
        call    StrLen                  ;get length
        mov     cx, ax
        mov     ax, bp
        mov     bx, si
        call    ComWri                  ;write string

        mov     al, 'R'
        mov     bx, si
        call    ComPut                  ;send R

        StkRel  4
        pop     bp

        pop     si
        pop     di
        ret

;--- invalid ANSI code

anscodI mov     a_err3x, dl             ;save command
        mov     ax, OFFSET a_err3
        call    Command_Error           ;display error message
        pop     si
        pop     di
        ret
        ENDP
