;*********************************;
; SESSION Command Line Parameters ;
;          By Eric Tauck          ;
;*********************************;

;--- data

errorm  DB      'Error in parameters, run "SESSION ?" for help',0

helpm   LABEL   BYTE
 DB 13,10
 DB 'Usage: SESSION [macro_file] [options]',13,10
 DB 13,10
 DB 'Serial Port                         | Configuration',13,10
 DB '----------------------------------- | ---------------------------------',13,10
 DB '/Pn    port number (1, 2)           | /Onnnn options (add values below)',13,10
 DB '/Bnnnn baud rate (300, 1200, 2400)  |      1 local echo',13,10
 DB '/Rn    parity (0=none,1=odd,2=even) |      2 split screen',13,10
 DB '/Dn    data bits (7, 8)             |     16 append LF to CR',13,10
 DB '/Sn    stop bits (1, 2)             |     32 strip high bit',13,10
 DB '                                    |     64 fast xmodem',13,10
 DB 'Video Mode                          |    128 1K xmodem',13,10
 DB '----------------------------------- |    256 enable ANSI',13,10
 DB '/Vnn video mode                     |    512 detect loss of carrier',13,10
 DB '   8 cols=80, rows=12 (VGA color)   |   2048 filter control chars',13,10
 DB '   9 cols=80, rows=14 (VGA color)   |   8192 enable macro debugging',13,10
 DB '  10 cols=80, rows=21 (VGA)         |',13,10
 DB '  11 cols=80, rows=25               | Miscellaneous',13,10
 DB '  12 cols=80, rows=28 (VGA)         | ---------------------------------',13,10
 DB '  13 cols=80, rows=43 (EGA, VGA)    | /Cn  color (0=def,1=color,2=b/w)',13,10
 DB '  14 cols=80, rows=50 (VGA)         | /Nn  noise (0=quiet, 1=noisy)',13,10
 DB '                                    | /Tnn text pacing (in ticks)'
 DB 0

;========================================
; Get and process all command line
; options.
;
; Out: AX= name of macro file or 0 if
;      none.

Get_Options     PROC    NEAR
        push    di
        push    si
        push    bp
        sub     bp, bp          ;macro file name
        jmps    getopt2

;--- loop for each argument

getopt1 mov     bp, si          ;return as macro file
        dec     bp              ;
        dec     bp              ;point to start

getopt2 call    ParGet          ;get parameter
        jc      getopt5         ;exit if done
        mov     si, ax

        call    StrUpr          ;convert to uppercase
        mov     ax, [si]        ;load first two bytes
        inc     si
        inc     si              ;skip option string

        cmp     al, '?'
        je      getopt4
        cmp     ah, '?'
        je      getopt4
        cmp     al, '/'
        jne     getopt1
        mov     di, OFFSET c_port
        cmp     ax, '/P'
        je      getopt6
        mov     di, OFFSET c_speed
        cmp     ax, '/B'
        je      getopt6
        mov     di, OFFSET c_party
        cmp     ax, '/R'
        je      getopt6
        mov     di, OFFSET c_data
        cmp     ax, '/D'
        je      getopt6
        mov     di, OFFSET c_stop
        cmp     ax, '/S'
        je      getopt6
        mov     di, OFFSET trmflg
        cmp     ax, '/O'
        je      getopt6
        mov     di, OFFSET pacetime
        cmp     ax, '/T'
        je      getopt6
        mov     di, OFFSET sndflg
        cmp     ax, '/N'
        je      getopt6
        mov     di, OFFSET mode
        cmp     ax, '/V'
        je      getopt6
        mov     di, OFFSET color
        cmp     ax, '/C'
        je      getopt6

;--- invalid option

getopt3 mov     ax, OFFSET errorm
        jmp     error2

;--- display help

getopt4 mov     ax, OFFSET helpm
        jmp     error2

;--- finished

getopt5 mov     ax, bp          ;return macro file name
        pop     bp
        pop     si
        pop     di
        ret

;--- store option value

getopt6 mov     ax, si
        mov     cx, 10          ;base 10
        call    Str2Num         ;convert to number
        jc      getopt3         ;jump if error
        mov     [di], ax        ;save parameter
        jmp     getopt2
        ENDP
