;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Ques_Look                   ;
; Check if operand at SI is a question mark. If ;
; so, AX returns type, BX value, and CX size.   ;
;===============================================;

Ques_Look Proc Near
 Cmp Byte [Si],1        ;check if length one
 Jne Noques
 Cmp Byte [Si+1],'?'    ;check if question mark
 Jne Noques

;----- successful

 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S8bit Or S16bit ;size
 Stc                    ;set carry
 Ret

;----- unsuccessful

Noques
 Clc
 Ret
 Endp                   ;Ques_Op

;===============================================;
;                  Const_Look                   ;
; Special program constant look up. Checks if   ;
; operand at SI is a special program constant.  ;
;===============================================;

Const_Look Proc Near
 Cmp Byte [Si+1],Const_Mark ;check if constant identifier
 Jne Notso2             ;jump if not

;----- check for constant

 Mov Di,Offset Constdir ;constant table
 Call Tab_Look          ;table look up
 Jnc Notso2             ;jump if not special operand

 Shl Bx                 ;offset into table
 Add Bx,Offset Constbran ;absolute offset
 Call Word [Bx]         ;call appropriate routine
 Stc
 Ret

;----- not a constant

Notso2
 Clc
 Ret

;----- constant table

Constbran Label Word
 Dw Offset Pres_Loc     ;$
 Dw Offset Pres_Loc     ;$LOC
 Dw Offset Prog_Bytes   ;$SIZE
 Dw Offset Cbyte_Count  ;$COUNT
 Dw Offset Cbyte_Chksum ;$SUM
 Dw Offset Cpro_Chksum  ;$CHKSUM
 Dw Offset Cversion     ;$VERSION
 Dw Offset Ctime1       ;$TIME1
 Dw Offset Ctime2       ;$TIME2
 Dw Offset Cdate1       ;$DATE1
 Dw Offset Cdate2       ;$DATE2
 Dw Offset Cend         ;$END
 Endp                   ;Const_Look

;===============================================;
;                   Pres_Loc                    ;
; Handles the dollar sign, the present          ;
; location counter value.                       ;
;===============================================;

Pres_Loc Proc Near
 Mov Ax,Immed           ;type
 Mov Bx,Loctr           ;value
 Mov Cx,S16bit          ;size
 Stc                    ;set carry
 Ret
 Endp                   ;Pres_Loc

;===============================================;
;                   Prog_Bytes                  ;
; Handles $SIZE. Returns the total size of the  ;
; program in bytes.                             ;
;===============================================;

Prog_Bytes Proc Near
 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Cmp Pass,2             ;check if pass two
 Jne Nopbret            ;jump if not
 Mov Bx,Obj_Total       ;program size
 Ret

Nopbret Sub Bx,Bx       ;return zero, don't know value
 Ret
 Endp                   ;Prog_Bytes

;===============================================;
;                   Cbyte_Count                 ;
; Handles $COUNT. Returns the present byte      ;
; count value.                                  ;
;===============================================;

Cbyte_Count Proc Near
 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Cmp Pass,2             ;check if pass two
 Jne Nobcret            ;jump if not
 Mov Bx,Counter_Num     ;counter
 Ret

Nobcret Sub Bx,Bx       ;return zero, don't know value
 Ret
 Endp                   ;Cbyte_Count

;===============================================;
;                 Cbyte_Checksum                ;
; Handles $SUM. Returns the present byte        ;
; checksum value.                               ;
;===============================================;

Cbyte_Chksum Proc Near
 Mov Ax,Immed           ;type
 Mov Cx,S8bit Or S16bit ;size
 Cmp Pass,2             ;check if pass two
 Jne Nobkret            ;jump if not
 Mov Bl,Counter_Chk     ;checksum
 Sub Bh,Bh
 Ret

Nobkret Sub Bx,Bx       ;return zero, don't know value
 Ret
 Endp                   ;Cbyte_Chksum

;===============================================;
;                  Cpro_Checksum                ;
; Handles $CHKSUM. Returns the present program  ;
; checksum value so far.                        ;
;===============================================;

Cpro_Chksum Proc Near
 Mov Ax,Immed           ;type
 Mov Cx,S8bit Or S16bit ;size
 Cmp Pass,2             ;check if pass two
 Jne Nopkret            ;jump if not
 Mov Bl,Program_Chk     ;checksum
 Sub Bh,Bh
 Ret

Nopkret Sub Bx,Bx       ;return zero, don't know value
 Ret
 Endp                   ;Cpro_Chksum

;===============================================;
;                    Cversion                   ;
; Handles $VERSION. Returns the assembler       ;
; version.                                      ;
;===============================================;

Cversion Proc Near
 Mov Ax,Immed           ;type
 Mov Bh, Version_Lo     ;tens
 Mov Bl, Version_Hi     ;ones
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Cversion

;===============================================;
;                     Ctime1                    ;
; Handles $TIME1. Return second and 1/100       ;
; second in system format.                      ;
;===============================================;

Ctime1 Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Not1ret            ;jump if not

 Dos_Function 2ch       ;get time
 Mov Bx,Dx              ;value
 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Ret

Not1ret
 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;return zero, only return on pass two
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Ctime1

;===============================================;
;                     Ctime2                    ;
; Handles $TIME2. Return hour and minute in     ;
; system format.                                ;
;===============================================;

Ctime2 Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Not2ret            ;jump if not

 Dos_Function 2ch       ;get time
 Mov Bx,Cx              ;value
 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Ret

Not2ret
 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;return zero, only return on pass two
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Ctime2

;===============================================;
;                     Cdate1                    ;
; Handles $DATE1. Return day and month in       ;
; system format.                                ;
;===============================================;

Cdate1 Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nod1ret            ;jump if not

 Dos_Function 2ah       ;get date
 Mov Bx,Dx              ;value
 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Ret

Nod1ret
 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;return zero, only return on pass two
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Cdate1

;===============================================;
;                     Cdate2                    ;
; Handles $DATE1. Return year in system format. ;
;===============================================;

Cdate2 Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nod2ret            ;jump if not

 Dos_Function 2ah       ;get date
 Mov Bx,Cx              ;value
 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Ret

Nod2ret
 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;return zero, only return on pass two
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Cdate2

;===============================================;
;                      Cend                     ;
; Handles $END. Return the last offset of pass  ;
; one.                                          ;
;===============================================;

Cend Proc Near
 Mov Ax,Immed           ;type
 Mov Bx,Endloc          ;value
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Cend

;===============================================;
;                   Spec_Look                   ;
; Special operand look up. Checks if the        ;
; operand at SI is a special operand. If so     ;
; the special operand is evaluated, the carry   ;
; is set, and AX returns the type, BX returns   ;
; the value, and CX returns the size.           ;
;===============================================;

Spec_Look Proc Near
 Mov Di,Offset Specdir  ;special operand table
 Call Tab_Look          ;table look up
 Jnc Notso              ;jump if not special operand

;----- special operand, get argument

 Mov Dl,Pres_Si
 Push Dx
 Push Fe_Start

 Push Bx
 Call Next_Oprnd        ;get and evaluate next operand
 Pop Di                 ;DI gets special operand index
 Jc Spoperr             ;jump if operator returned

 Shl Di                 ;offset into spec. op. table
 Add Di,Offset Specbran ;absolute offset
 Call Word [Di]         ;call appropriate routine

 Pop Fe_Start
 Pop Dx
 Mov Pres_Si,Dl
 Stc
 Ret

;----- no argument returned, operator must be ) or ]

Spoperr Mov Dl,Al       ;operator
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine

 Pop Fe_Start
 Pop Dx
 Mov Pres_Si,Dl

 Mov Ax, Undef          ;undefined
 Sub Bx, Bx             ;no value
 Mov Cx, Bx             ;no size
 Stc
 Ret

;----- not a functional operand

Notso
 Clc
 Ret

;----- special operand table

Specbran Label Word
 Dw Offset Type_Near    ;NEAR
 Dw Offset Type_Far     ;FAR
 Dw Offset Make_Off     ;OFFSET
 Dw Offset Make_Not     ;NOT
 Dw Offset Size_Byte    ;BYTE
 Dw Offset Size_Word    ;WORD
 Dw Offset Size_Dword   ;DWORD
 Dw Offset Size_Qword   ;QWORD
 Dw Offset Size_Tbyte   ;TBYTE
 Dw Offset Size_Any     ;ANYSIZE
 Dw Offset Stack_Reg    ;ST
 Dw Offset Ret_Val      ;VALUE
 Dw Offset Ret_Siz      ;SIZE
 Dw Offset Ret_Typ      ;TYPE
 Dw Offset Make_Neg     ;NEG
 Endp                   ;Spec_Look

;===============================================;
;                   Make_Not                    ;
; Handles NOT. Returns the logical not of its   ;
; argument.                                     ;
;===============================================;

Make_Not Proc Near
 Test Ax,Immed Or Undef ;must be immediate data
 Jz Noterr              ;jump if not

 Not Bx                 ;not BX
 Ret

;----- illegal argument

Noterr
 Mov Ax,017dh           ;error 125
 Call Error             ;error routine

 Mov Ax,Immed           ;set to immed
 Sub Bx,Bx              ;value
 Mov Cx,S8bit Or S16bit ;size
 Ret
 Endp                   ;Make_Not

;===============================================;
;                   Make_Off                    ;
; Handles OFFSET. Returns the offset of its     ;
; argument.                                     ;
;===============================================;

Make_Off Proc Near
 Test Ax,Addr Or Neart Or Fart Or Undef ;test if legal OFFSET types
 Jz Offerr2             ;jump if illegal

 Mov Ax,Immed           ;type
 Mov Cx,S16bit          ;size
 Ret

;----- illegal argument

Offerr2 Mov Ax,017ch    ;error 124
 Call Error             ;error routine

 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Make_Offset

;===============================================;
;                   Type_Near                   ;
; Handles NEAR. Sets its argument type to near. ;
;===============================================;

Type_Near Proc Near
 Test Ax,Addr Or Mem    ;test if data
 Jnz Tynear             ;jump if so
 Test Ax,None Or Immed Or Neart Or Fart Or Undef ;legal NEAR types
 Jz Nearerr             ;jump if illegal

 Mov Ax,Neart           ;type
 Ret

;----- indirect jump operand, set size

Tynear Mov Cx,S16bit    ;set size
 Ret

;----- illegal argument

Nearerr Mov Ax,017eh    ;error 126
 Call Error             ;error routine

 Mov Ax,Neart           ;type
 Sub Bx,Bx              ;value
 Mov Cx,Bx              ;size
 Ret
 Endp                   ;Type_Near

;===============================================;
;                   Type_Far                    ;
; Handles FAR. Sets its argument type to far.   ;
;===============================================;

Type_Far Proc Near
 Test Ax,Addr Or Mem    ;test if data
 Jnz Tyfar              ;jump if so
 Test Ax,None Or Neart Or Fart Or Undef ;legal FAR types
 Jz Farterr             ;jump if illegal

 Mov Ax,Fart            ;type
 Ret

;----- indirect jump operand, set size

Tyfar Mov Cx,S32bit     ;set size
 Ret

;----- illegal argument

Farterr Mov Ax,017fh    ;error 127
 Call Error             ;error routine

 Mov Ax,Fart            ;type
 Sub Bx,Bx              ;value
 Mov Cx,Bx              ;size
 Ret
 Endp                   ;Type_Far

;===============================================;
;                   Size_Byte                   ;
; Handles BYTE. Sets its argument size to byte. ;
;===============================================;

Size_Byte Proc Near
 Test Ax,None Or Immed Or Mem Or Addr Or Undef ;legal BYTE types
 Jz Byterr              ;jump if illegal

 Mov Cx,S8bit           ;size
 Ret

;----- illegal argument

Byterr Mov Ax,0180h     ;error 128
 Call Error             ;error routine

 Mov Ax,Undef           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S8bit           ;size
 Ret
 Endp                   ;Size_Byte

;===============================================;
;                   Size_Word                   ;
; Handles WORD. Sets its argument size to word. ;
;===============================================;

Size_Word Proc Near
 Test Ax,None Or Immed Or Mem Or Addr Or Undef ;legal WORD types
 Jz Worerr              ;jump if illegal

 Mov Cx,S16bit          ;size
 Ret

;----- illegal argument

Worerr Mov Ax,0181h     ;error 129
 Call Error             ;error routine

 Mov Ax,Undef           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S16bit          ;size
 Ret
 Endp                   ;Size_Word

;===============================================;
;                   Size_Dword                  ;
; Handles DWORD. Sets its argument size to      ;
; double word.                                  ;
;===============================================;

Size_Dword Proc Near
 Test Ax,None Or Mem Or Addr Or Undef ;legal DWORD types
 Jz Dwoerr              ;jump if illegal

 Mov Cx,S32bit          ;size
 Ret

;----- error

Dwoerr Mov Ax,0182h     ;error 130
 Call Error             ;error routine

 Mov Ax,Undef           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S32bit          ;size
 Ret
 Endp                   ;Size_Dword

;===============================================;
;                   Size_Qword                  ;
; Handles QWORD. Sets its argument size to      ;
; quadruple word (32 bits).                     ;
;===============================================;

Size_Qword Proc Near
 Test Ax,None Or Mem Or Addr Or Undef ;legal QWORD types
 Jz Qwoerr              ;jump if illegal

 Mov Cx,S64bit          ;size
 Ret

;----- illegal argument

Qwoerr Mov Ax,0184h     ;error 132
 Call Error             ;error routine

 Mov Ax,Undef           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S64bit          ;size
 Ret
 Endp                   ;Size_Qword

;===============================================;
;                   Size_Tbyte                  ;
; Handles TBYTE. Sets its argument size to 80   ;
; bits (for temporary real and BCD type).       ;
;===============================================;

Size_Tbyte Proc Near
 Test Ax,None Or Mem Or Addr Or Undef ;legal TBYTE types
 Jz Tboerr              ;jump if illegal

 Mov Cx,S80bit          ;size
 Ret

;----- illegal argument

Tboerr Mov Ax,0185h     ;error 133
 Call Error             ;error routine

 Mov Ax,Undef           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S80bit          ;size
 Ret
 Endp                   ;Size_Tbyte

;===============================================;
;                   Size_Any                    ;
; Handles ANY. Sets its argument size to all    ;
; possible sizes (all sizes match).             ;
;===============================================;

Size_Any Proc Near
 Test Ax,None Or Immed Or Mem Or Addr Or Undef ;legal ANY types
 Jz Anoerr              ;jump if illegal

 Mov Cx,Allsize         ;size
 Ret

;----- illegal argument

Anoerr Mov Ax,011dh     ;error 29
 Call Error             ;error routine

 Mov Ax,Undef           ;type
 Sub Bx,Bx              ;value
 Mov Cx,Allsize         ;size
 Ret
 Endp                   ;Size_Any

;===============================================;
;                   Stack_Reg                   ;
; Handles 8087 stack type, ST x. Returns the    ;
; data for an 8087 stack operand.               ;
;===============================================;

Stack_Reg Proc Near
 Test Ax,None Or Undef  ;none, interpreted as ST(0)
 Jnz Stackrt            ;jump if so
 Test Ax,Immed          ;must be immediate data
 Jz Sterror             ;error if not
 Test Cx,S8bit          ;test if 8 bit size
 Jz Sterror             ;error if not

;----- check the range of the number, must be 0-7

 Cmp Bx,7               ;how big?
 Jg Sterror             ;error if too big
 Cmp Bx,0               ;less than zero?
 Jl Sterror             ;error if too small

;----- normal operand

 Mov Ax,Stack           ;type
 Or Bx,Bx               ;check if top, ST(0)
 Jnz Nostktop           ;skip if not
 Or Ax,Stacktop         ;also stack top type
Nostktop Or Bx,Mod_Reg  ;set mod field
 Mov Cx,S16bit Or S32bit Or S64bit Or S80bit ;possible sizes
 Ret

;----- ST, interpreted as ST(0)

Stackrt Mov Ax,Stack Or Stacktop ;type
 Mov Bx,Mod_Reg         ;value
 Mov Cx,S16bit Or S32bit Or S64bit Or S80bit ;size
 Ret

;----- illegal argument

Sterror Mov Ax,0183h    ;error 131
 Call Error             ;error routine
 Jmps Stackrt           ;interpret as ST
 Endp                   ;Stack_Reg

;===============================================;
;                    Ret_Val                    ;
; Return value of operand.                      ;
;===============================================;

Ret_Val Proc Near
 Mov Ax,Immed           ;type
 Mov Cx,S8bit Or S16bit ;size
 Ret
 Endp                   ;Ret_Val

;===============================================;
;                    Ret_Siz                    ;
; Return size of operand.                       ;
;===============================================;

Ret_Siz Proc Near
 Mov Ax,Immed           ;type
 Mov Bx,Cx              ;value
 Mov Cx,S8bit Or S16bit ;size
 Ret
 Endp                   ;Ret_Siz

;===============================================;
;                   Ret_Typ                     ;
; Return type of operand.                       ;
;===============================================;

Ret_Typ Proc Near
 Mov Bx,Ax              ;value
 Mov Ax,Immed           ;type
 Mov Cx,S8bit Or S16bit ;size
 Ret
 Endp                   ;Ret_Typ

;===============================================;
;                   Make_Neg                    ;
; Negate operand.                               ;
;===============================================;

Make_Neg Proc Near
 Test Ax,Immed Or Undef ;must be immediate data
 Jz Negerr              ;jump if not

 Or Ax,Signed           ;set to signed
 Neg Bx                 ;negate BX
 Ret

;----- illegal argument

Negerr Mov Ax,010bh     ;error 11
 Call Error             ;error routine

 Mov Ax,Immed Or Signed ;set to signed
 Neg Bx
 Mov Cx,S8bit Or S16bit ;size
 Ret
 Endp                   ;Make_Neg

