/*
 *  ntstatus.h  NT status codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTSTATUS_
#define _NTSTATUS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Facility codes */
#define FACILITY_VOLMGR                 0x38
#define FACILITY_VIRTUALIZATION         0x37
#define FACILITY_VIDEO                  0x1B
#define FACILITY_USB_ERROR_CODE         0x10
#define FACILITY_TRANSACTION            0x19
#define FACILITY_TERMINAL_SERVER        0x0A
#define FACILITY_SXS_ERROR_CODE         0x15
#define FACILITY_NTSSPI                 0x09
#define FACILITY_RPC_STUBS              0x03
#define FACILITY_RPC_RUNTIME            0x02
#define FACILITY_NTWIN32                0x07
#define FACILITY_WIN32K_NTUSER          0x3E
#define FACILITY_WIN32K_NTGDI           0x3F
#define FACILITY_NDIS_ERROR_CODE        0x23
#define FACILITY_MUI_ERROR_CODE         0x0B
#define FACILITY_MONITOR                0x1D
#define FACILITY_MAXIMUM_VALUE          0x3F
#define FACILITY_IPSEC                  0x36
#define FACILITY_IO_ERROR_CODE          0x04
#define FACILITY_HYPERVISOR             0x35
#define FACILITY_HID_ERROR_CODE         0x11
#define FACILITY_GRAPHICS_KERNEL        0x1E
#define FACILITY_FWP_ERROR_CODE         0x22
#define FACILITY_FVE_ERROR_CODE         0x21
#define FACILITY_FIREWIRE_ERROR_CODE    0x12
#define FACILITY_FILTER_MANAGER         0x1C
#define FACILTIY_DRIVER_FRAMEWORK       0x20
#define FACILITY_DIS                    0x3C
#define FACILITY_DEBUGGER               0x01
#define FACILITY_COMMONLOG              0x1A
#define FACILITY_CLUSTER_ERROR_CODE     0x13
#define FACILITY_NTCERT                 0x08
#define FACILITY_BCD_ERROR_CODE         0x39
#define FACILITY_ACPI_ERROR_CODE        0x14

/* Status severity codes */
#define STATUS_SEVERITY_SUCCESS         0x0
#define STATUS_SEVERITY_INFORMATIONAL   0x1
#define STATUS_SEVERITY_WARNING         0x2
#define STATUS_SEVERITY_ERROR           0x3

/* Status codes */
#define STATUS_SUCCESS                                  0x00000000L
#define STATUS_WAIT_0                                   0x00000000L
#define STATUS_WAIT_1                                   0x00000001L
#define STATUS_WAIT_2                                   0x00000002L
#define STATUS_WAIT_3                                   0x00000003L
#define STATUS_WAIT_63                                  0x0000003FL
#define STATUS_ABANDONED                                0x00000080L
#define STATUS_ABANDONED_WAIT_0                         0x00000080L
#define STATUS_ABANDONED_WAIT_63                        0x000000BFL
#define STATUS_USER_APC                                 0x000000C0L
#define STATUS_KERNEL_APC                               0x00000100L
#define STATUS_ALERTED                                  0x00000101L
#define STATUS_TIMEOUT                                  0x00000102L
#define STATUS_PENDING                                  0x00000103L
#define STATUS_REPARSE                                  0x00000104L
#define STATUS_MORE_ENTRIES                             0x00000105L
#define STATUS_NOT_ALL_ASSIGNED                         0x00000106L
#define STATUS_SOME_NOT_MAPPED                          0x00000107L
#define STATUS_OPLOCK_BREAK_IN_PROGRESS                 0x00000108L
#define STATUS_VOLUME_MOUNTED                           0x00000109L
#define STATUS_RXACT_COMMITTED                          0x0000010AL
#define STATUS_NOTIFY_CLEANUP                           0x0000010BL
#define STATUS_NOTIFY_ENUM_DIR                          0x0000010CL
#define STATUS_NO_QUOTAS_FOR_ACCOUNT                    0x0000010DL
#define STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED         0x0000010EL
#define STATUS_PAGE_FAULT_TRANSITION                    0x00000110L
#define STATUS_PAGE_FAULT_DEMAND_ZERO                   0x00000111L
#define STATUS_PAGE_FAULT_COPY_ON_WRITE                 0x00000112L
#define STATUS_PAGE_FAULT_GUARD_PAGE                    0x00000113L
#define STATUS_PAGE_FAULT_PAGING_FILE                   0x00000114L
#define STATUS_CACHE_PAGE_LOCKED                        0x00000115L
#define STATUS_CRASH_DUMP                               0x00000116L
#define STATUS_BUFFER_ALL_ZEROS                         0x00000117L
#define STATUS_REPARSE_OBJECTS                          0x00000118L
#define STATUS_RESOURCE_REQUIREMENTS_CHANGED            0x00000119L
#define STATUS_TRANSLATION_COMPLETE                     0x00000120L
#define STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY          0x00000121L
#define STATUS_NOTHING_TO_TERMINATE                     0x00000122L
#define STATUS_PROCESS_NOT_IN_JOB                       0x00000123L
#define STATUS_PROCESS_IN_JOB                           0x00000124L
#define STATUS_VOLSNAP_HIBERNATE_READY                  0x00000125L
#define STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY       0x00000126L
#define STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED       0x00000127L
#define STATUS_INTERRUPT_STILL_CONNECTED                0x00000128L
#define STATUS_PROCESS_CLONED                           0x00000129L
#define STATUS_FILE_LOCKED_WITH_ONLY_READERS            0x0000012AL
#define STATUS_FILE_LOCKED_WITH_WRITERS                 0x0000012BL
#define STATUS_RESOURCEMANAGER_READ_ONLY                0x00000202L
#define STATUS_RING_PREVIOUSLY_EMPTY                    0x00000210L
#define STATUS_RING_PREVIOUSLY_FULL                     0x00000211L
#define STATUS_RING_PREVIOUSLY_ABOVE_QUOTA              0x00000212L
#define STATUS_RING_NEWLY_EMPTY                         0x00000213L
#define STATUS_RING_SIGNAL_OPPOSITE_ENDPOINT            0x00000214L
#define STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE            0x00000215L
#define STATUS_OPLOCK_HANDLE_CLOSED                     0x00000216L
#define STATUS_WAIT_FOR_OPLOCK                          0x00000367L
#define DBG_EXCEPTION_HANDLED                           0x00010001L
#define DBG_CONTINUE                                    0x00010002L
#define STATUS_FLT_IO_COMPLETE                          0x001C0001L
#define STATUS_DIS_ATTRIBUTE_BUILT                      0x003C0001L
#define STATUS_OBJECT_NAME_EXISTS                       0x40000000L
#define STATUS_THREAD_WAS_SUSPENDED                     0x40000001L
#define STATUS_WORKING_SET_LIMIT_RANGE                  0x40000002L
#define STATUS_IMAGE_NOT_AT_BASE                        0x40000003L
#define STATUS_RXACT_STATE_CREATED                      0x40000004L
#define STATUS_SEGMENT_NOTIFICATION                     0x40000005L
#define STATUS_LOCAL_USER_SESSION_KEY                   0x40000006L
#define STATUS_BAD_CURRENT_DIRECTORY                    0x40000007L
#define STATUS_SERIAL_MORE_WRITES                       0x40000008L
#define STATUS_REGISTRY_RECOVERED                       0x40000009L
#define STATUS_FT_READ_RECOVERY_FROM_BACKUP             0x4000000AL
#define STATUS_FT_WRITE_RECOVERY                        0x4000000BL
#define STATUS_SERIAL_COUNTER_TIMEOUT                   0x4000000CL
#define STATUS_NULL_LM_PASSWORD                         0x4000000DL
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH              0x4000000EL
#define STATUS_RECEIVE_PARTIAL                          0x4000000FL
#define STATUS_RECEIVE_EXPEDITED                        0x40000010L
#define STATUS_RECEIVE_PARTIAL_EXPEDITED                0x40000011L
#define STATUS_EVENT_DONE                               0x40000012L
#define STATUS_EVENT_PENDING                            0x40000013L
#define STATUS_CHECKING_FILE_SYSTEM                     0x40000014L
#define STATUS_FATAL_APP_EXIT                           0x40000015L
#define STATUS_PREDEFINED_HANDLE                        0x40000016L
#define STATUS_WAS_UNLOCKED                             0x40000017L
#define STATUS_SERVICE_NOTIFICATION                     0x40000018L
#define STATUS_WAS_LOCKED                               0x40000019L
#define STATUS_LOG_HARD_ERROR                           0x4000001AL
#define STATUS_ALREADY_WIN32                            0x4000001BL
#define STATUS_WX86_UNSIMULATE                          0x4000001CL
#define STATUS_WX86_CONTINUE                            0x4000001DL
#define STATUS_WX86_SINGLE_STEP                         0x4000001EL
#define STATUS_WX86_BREAKPOINT                          0x4000001FL
#define STATUS_WX86_EXCEPTION_CONTINUE                  0x40000020L
#define STATUS_WX86_EXCEPTION_LASTCHANCE                0x40000021L
#define STATUS_WX86_EXCEPTION_CHAIN                     0x40000022L
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE          0x40000023L
#define STATUS_NO_YIELD_PERFORMED                       0x40000024L
#define STATUS_TIMER_RESUME_IGNORED                     0x40000025L
#define STATUS_ARBITRATION_UNHANDLED                    0x40000026L
#define STATUS_CARDBUS_NOT_SUPPORTED                    0x40000027L
#define STATUS_WX86_CREATEWX86TIB                       0x40000028L
#define STATUS_MP_PROCESSOR_MISMATCH                    0x40000029L
#define STATUS_HIBERNATED                               0x4000002AL
#define STATUS_RESUME_HIBERNATED                        0x4000002BL
#define STATUS_FIRMWARE_UPDATED                         0x4000002CL
#define STATUS_DRIVERS_LEAKING_LOCKED_PAGES             0x4000002DL
#define STATUS_MESSAGE_RETRIEVED                        0x4000002EL
#define STATUS_SYSTEM_POWERSTATE_TRANSITION             0x4000002FL
#define STATUS_ALPC_CHECK_COMPLETION_LIST               0x40000030L
#define STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION     0x40000031L
#define STATUS_ACCESS_AUDIT_BY_POLICY                   0x40000032L
#define STATUS_ABANDON_HIBERFILE                        0x40000033L
#define STATUS_BIZRULES_NOT_ENABLED                     0x40000034L
#define DBG_REPLY_LATER                                 0x40010001L
#define DBG_UNABLE_TO_PROVIDE_HANDLE                    0x40010002L
#define DBG_TERMINATE_THREAD                            0x40010003L
#define DBG_TERMINATE_PROCESS                           0x40010004L
#define DBG_CONTROL_C                                   0x40010005L
#define DBG_PRINTEXCEPTION_C                            0x40010006L
#define DBG_RIPEXCEPTION                                0x40010007L
#define DBG_CONTROL_BREAK                               0x40010008L
#define DBG_COMMAND_EXCEPTION                           0x40010009L
#define STATUS_HEURISTIC_DAMAGE_POSSIBLE                0x40190001L
#define STATUS_GUARD_PAGE_VIOLATION                     0x80000001L
#define STATUS_DATATYPE_MISALIGNMENT                    0x80000002L
#define STATUS_BREAKPOINT                               0x80000003L
#define STATUS_SINGLE_STEP                              0x80000004L
#define STATUS_BUFFER_OVERFLOW                          0x80000005L
#define STATUS_NO_MORE_FILES                            0x80000006L
#define STATUS_WAKE_SYSTEM_DEBUGGER                     0x80000007L
#define STATUS_HANDLES_CLOSED                           0x8000000AL
#define STATUS_NO_INHERITANCE                           0x8000000BL
#define STATUS_GUID_SUBSTITUTION_MADE                   0x8000000CL
#define STATUS_PARTIAL_COPY                             0x8000000DL
#define STATUS_DEVICE_PAPER_EMPTY                       0x8000000EL
#define STATUS_DEVICE_POWERED_OFF                       0x8000000FL
#define STATUS_DEVICE_OFF_LINE                          0x80000010L
#define STATUS_DEVICE_BUSY                              0x80000011L
#define STATUS_NO_MORE_EAS                              0x80000012L
#define STATUS_INVALID_EA_NAME                          0x80000013L
#define STATUS_EA_LIST_INCONSISTENT                     0x80000014L
#define STATUS_INVALID_EA_FLAG                          0x80000015L
#define STATUS_VERIFY_REQUIRED                          0x80000016L
#define STATUS_EXTRANEOUS_INFORMATION                   0x80000017L
#define STATUS_RXACT_COMMIT_NECESSARY                   0x80000018L
#define STATUS_NO_MORE_ENTRIES                          0x8000001AL
#define STATUS_FILEMARK_DETECTED                        0x8000001BL
#define STATUS_MEDIA_CHANGED                            0x8000001CL
#define STATUS_BUS_RESET                                0x8000001DL
#define STATUS_END_OF_MEDIA                             0x8000001EL
#define STATUS_BEGINNING_OF_MEDIA                       0x8000001FL
#define STATUS_MEDIA_CHECK                              0x80000020L
#define STATUS_SETMARK_DETECTED                         0x80000021L
#define STATUS_NO_DATA_DETECTED                         0x80000022L
#define STATUS_REDIRECTOR_HAS_OPEN_HANDLES              0x80000023L
#define STATUS_SERVER_HAS_OPEN_HANDLES                  0x80000024L
#define STATUS_ALREADY_DISCONNECTED                     0x80000025L
#define STATUS_LONGJUMP                                 0x80000026L
#define STATUS_CLEANER_CARTRIDGE_INSTALLED              0x80000027L
#define STATUS_PLUGPLAY_QUERY_VETOED                    0x80000028L
#define STATUS_UNWIND_CONSOLIDATE                       0x80000029L
#define STATUS_REGISTRY_HIVE_RECOVERED                  0x8000002AL
#define STATUS_DLL_MIGHT_BE_INSECURE                    0x8000002BL
#define STATUS_DLL_MIGHT_BE_INCOMPATIBLE                0x8000002CL
#define STATUS_STOPPED_ON_SYMLINK                       0x8000002DL
#define STATUS_CANNOT_GRANT_REQUESTED_OPLOCK            0x8000002EL
#define STATUS_NO_ACE_CONDITION                         0x8000002FL
#define DBG_EXCEPTION_NOT_HANDLED                       0x80010001L
#define STATUS_CLUSTER_NODE_ALREADY_UP                  0x80130001L
#define STATUS_CLUSTER_NODE_ALREADY_DOWN                0x80130002L
#define STATUS_CLUSTER_NETWORK_ALREADY_ONLINE           0x80130003L
#define STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE          0x80130004L
#define STATUS_CLUSTER_NODE_ALREADY_MEMBER              0x80130005L
#define STATUS_FLT_BUFFER_TOO_SMALL                     0x801C0001L
#define STATUS_FVE_PARTIAL_METADATA                     0x80210001L
#define STATUS_FVE_TRANSIENT_STATE                      0x80210002L
#define STATUS_UNSUCCESSFUL                             0xC0000001L
#define STATUS_NOT_IMPLEMENTED                          0xC0000002L
#define STATUS_INVALID_INFO_CLASS                       0xC0000003L
#define STATUS_INFO_LENGTH_MISMATCH                     0xC0000004L
#define STATUS_ACCESS_VIOLATION                         0xC0000005L
#define STATUS_IN_PAGE_ERROR                            0xC0000006L
#define STATUS_PAGEFILE_QUOTA                           0xC0000007L
#define STATUS_INVALID_HANDLE                           0xC0000008L
#define STATUS_BAD_INITIAL_STACK                        0xC0000009L
#define STATUS_BAD_INITIAL_PC                           0xC000000AL
#define STATUS_INVALID_CID                              0xC000000BL
#define STATUS_TIMER_NOT_CANCELED                       0xC000000CL
#define STATUS_INVALID_PARAMETER                        0xC000000DL
#define STATUS_NO_SUCH_DEVICE                           0xC000000EL
#define STATUS_NO_SUCH_FILE                             0xC000000FL
#define STATUS_INVALID_DEVICE_REQUEST                   0xC0000010L
#define STATUS_END_OF_FILE                              0xC0000011L
#define STATUS_WRONG_VOLUME                             0xC0000012L
#define STATUS_NO_MEDIA_IN_DEVICE                       0xC0000013L
#define STATUS_UNRECOGNIZED_MEDIA                       0xC0000014L
#define STATUS_NONEXISTENT_SECTOR                       0xC0000015L
#define STATUS_MORE_PROCESSING_REQUIRED                 0xC0000016L
#define STATUS_NO_MEMORY                                0xC0000017L
#define STATUS_CONFLICTING_ADDRESSES                    0xC0000018L
#define STATUS_NOT_MAPPED_VIEW                          0xC0000019L
#define STATUS_UNABLE_TO_FREE_VM                        0xC000001AL
#define STATUS_UNABLE_TO_DELETE_SECTION                 0xC000001BL
#define STATUS_INVALID_SYSTEM_SERVICE                   0xC000001CL
#define STATUS_ILLEGAL_INSTRUCTION                      0xC000001DL
#define STATUS_INVALID_LOCK_SEQUENCE                    0xC000001EL
#define STATUS_INVALID_VIEW_SIZE                        0xC000001FL
#define STATUS_INVALID_FILE_FOR_SECTION                 0xC0000020L
#define STATUS_ALREADY_COMMITTED                        0xC0000021L
#define STATUS_ACCESS_DENIED                            0xC0000022L
#define STATUS_BUFFER_TOO_SMALL                         0xC0000023L
#define STATUS_OBJECT_TYPE_MISMATCH                     0xC0000024L
#define STATUS_NONCONTINUABLE_EXCEPTION                 0xC0000025L
#define STATUS_INVALID_DISPOSITION                      0xC0000026L
#define STATUS_UNWIND                                   0xC0000027L
#define STATUS_BAD_STACK                                0xC0000028L
#define STATUS_INVALID_UNWIND_TARGET                    0xC0000029L
#define STATUS_NOT_LOCKED                               0xC000002AL
#define STATUS_PARITY_ERROR                             0xC000002BL
#define STATUS_UNABLE_TO_DECOMMIT_VM                    0xC000002CL
#define STATUS_NOT_COMMITTED                            0xC000002DL
#define STATUS_INVALID_PORT_ATTRIBUTES                  0xC000002EL
#define STATUS_PORT_MESSAGE_TOO_LONG                    0xC000002FL
#define STATUS_INVALID_PARAMETER_MIX                    0xC0000030L
#define STATUS_INVALID_QUOTA_LOWER                      0xC0000031L
#define STATUS_DISK_CORRUPT_ERROR                       0xC0000032L
#define STATUS_OBJECT_NAME_INVALID                      0xC0000033L
#define STATUS_OBJECT_NAME_NOT_FOUND                    0xC0000034L
#define STATUS_OBJECT_NAME_COLLISION                    0xC0000035L
#define STATUS_PORT_DISCONNECTED                        0xC0000037L
#define STATUS_DEVICE_ALREADY_ATTACHED                  0xC0000038L
#define STATUS_OBJECT_PATH_INVALID                      0xC0000039L
#define STATUS_OBJECT_PATH_NOT_FOUND                    0xC000003AL
#define STATUS_OBJECT_PATH_SYNTAX_BAD                   0xC000003BL
#define STATUS_DATA_OVERRUN                             0xC000003CL
#define STATUS_DATA_LATE_ERROR                          0xC000003DL
#define STATUS_DATA_ERROR                               0xC000003EL
#define STATUS_CRC_ERROR                                0xC000003FL
#define STATUS_SECTION_TOO_BIG                          0xC0000040L
#define STATUS_PORT_CONNECTION_REFUSED                  0xC0000041L
#define STATUS_INVALID_PORT_HANDLE                      0xC0000042L
#define STATUS_SHARING_VIOLATION                        0xC0000043L
#define STATUS_QUOTA_EXCEEDED                           0xC0000044L
#define STATUS_INVALID_PAGE_PROTECTION                  0xC0000045L
#define STATUS_MUTANT_NOT_OWNED                         0xC0000046L
#define STATUS_SEMAPHORE_LIMIT_EXCEEDED                 0xC0000047L
#define STATUS_PORT_ALREADY_SET                         0xC0000048L
#define STATUS_SECTION_NOT_IMAGE                        0xC0000049L
#define STATUS_SUSPEND_COUNT_EXCEEDED                   0xC000004AL
#define STATUS_THREAD_IS_TERMINATING                    0xC000004BL
#define STATUS_BAD_WORKING_SET_LIMIT                    0xC000004CL
#define STATUS_INCOMPATIBLE_FILE_MAP                    0xC000004DL
#define STATUS_SECTION_PROTECTION                       0xC000004EL
#define STATUS_EAS_NOT_SUPPORTED                        0xC000004FL
#define STATUS_EA_TOO_LARGE                             0xC0000050L
#define STATUS_NOTEXISTENT_EA_ENTRY                     0xC0000051L
#define STATUS_NO_EAS_ON_FILE                           0xC0000052L
#define STATUS_EA_CORRUPT_ERROR                         0xC0000053L
#define STATUS_FILE_LOCK_CONFLICT                       0xC0000054L
#define STATUS_LOCK_NOT_GRANTED                         0xC0000055L
#define STATUS_DELETE_PENDING                           0xC0000056L
#define STATUS_CTL_FILE_NOT_SUPPORTED                   0xC0000057L
#define STATUS_UNKNOWN_REVISION                         0xC0000058L
#define STATUS_REVISION_MISMATCH                        0xC0000059L
#define STATUS_INVALID_OWNER                            0xC000005AL
#define STATUS_INVALID_PRIMARY_GROUP                    0xC000005BL
#define STATUS_NO_IMPERSONATION_TOKEN                   0xC000005CL
#define STATUS_CANT_DISABLE_MANDATORY                   0xC000005DL
#define STATUS_NO_LOGON_SERVERS                         0xC000005EL
#define STATUS_NO_SUCH_LOGON_SESSION                    0xC000005FL
#define STATUS_NO_SUCH_PRIVILEGE                        0xC0000060L
#define STATUS_PRIVILEGE_NOT_HELD                       0xC0000061L
#define STATUS_INVALID_ACCOUNT_NAME                     0xC0000062L
#define STATUS_USER_EXISTS                              0xC0000063L
#define STATUS_NO_SUCH_USER                             0xC0000064L
#define STATUS_GROUP_EXISTS                             0xC0000065L
#define STATUS_NO_SUCH_GROUP                            0xC0000066L
#define STATUS_MEMBER_IN_GROUP                          0xC0000067L
#define STATUS_MEMBER_NOT_IN_GROUP                      0xC0000068L
#define STATUS_LAST_ADMIN                               0xC0000069L
#define STATUS_WRONG_PASSWORD                           0xC000006AL
#define STATUS_ILL_FORMED_PASSWORD                      0xC000006BL
#define STATUS_PASSWORD_RESTRICTION                     0xC000006CL
#define STATUS_LOGON_FAILURE                            0xC000006DL
#define STATUS_ACCOUNT_RESTRICTION                      0xC000006EL
#define STATUS_INVALID_LOGON_HOURS                      0xC000006FL
#define STATUS_INVALID_WORKSTATION                      0xC0000070L
#define STATUS_PASSWORD_EXPIRED                         0xC0000071L
#define STATUS_ACCOUNT_DISABLED                         0xC0000072L
#define STATUS_NONE_MAPPED                              0xC0000073L
#define STATUS_TOO_MANY_LUIDS_REQUESTED                 0xC0000074L
#define STATUS_LUIDS_EXHAUSTED                          0xC0000075L
#define STATUS_INVALID_SUB_AUTHORITY                    0xC0000076L
#define STATUS_INVALID_ACL                              0xC0000077L
#define STATUS_INVALID_SID                              0xC0000078L
#define STATUS_INVALID_SECURITY_DESCR                   0xC0000079L
#define STATUS_PROCEDURE_NOT_FOUND                      0xC000007AL
#define STATUS_INVALID_IMAGE_FORMAT                     0xC000007BL
#define STATUS_NO_TOKEN                                 0xC000007CL
#define STATUS_BAD_INHERITANCE_ACL                      0xC000007DL
#define STATUS_RANGE_NOT_LOCKED                         0xC000007EL
#define STATUS_DISK_FULL                                0xC000007FL
#define STATUS_SERVER_DISABLED                          0xC0000080L
#define STATUS_SERVER_NOT_DISABLED                      0xC0000081L
#define STATUS_TOO_MANY_GUIDS_REQUESTED                 0xC0000082L
#define STATUS_GUIDS_EXHAUSTED                          0xC0000083L
#define STATUS_INVALID_ID_AUTHORITY                     0xC0000084L
#define STATUS_AGENTS_EXHAUSTED                         0xC0000085L
#define STATUS_INVALID_VOLUME_LABEL                     0xC0000086L
#define STATUS_SECTION_NOT_EXTENDED                     0xC0000087L
#define STATUS_NOT_MAPPED_DATA                          0xC0000088L
#define STATUS_RESOURCE_DATA_NOT_FOUND                  0xC0000089L
#define STATUS_RESOURCE_TYPE_NOT_FOUND                  0xC000008AL
#define STATUS_RESOURCE_NAME_NOT_FOUND                  0xC000008BL
#define STATUS_ARRAY_BOUNDS_EXCEEDED                    0xC000008CL
#define STATUS_FLOAT_DENORMAL_OPERAND                   0xC000008DL
#define STATUS_FLOAT_DIVIDE_BY_ZERO                     0xC000008EL
#define STATUS_FLOAT_INEXACT_RESULT                     0xC000008FL
#define STATUS_FLOAT_INVALID_OPERATION                  0xC0000090L
#define STATUS_FLOAT_OVERFLOW                           0xC0000091L
#define STATUS_FLOAT_STACK_CHECK                        0xC0000092L
#define STATUS_FLOAT_UNDERFLOW                          0xC0000093L
#define STATUS_INTEGER_DIVIDE_BY_ZERO                   0xC0000094L
#define STATUS_INTEGER_OVERFLOW                         0xC0000095L
#define STATUS_PRIVILEGED_INSTRUCTION                   0xC0000096L
#define STATUS_TOO_MANY_PAGING_FILES                    0xC0000097L
#define STATUS_FILE_INVALID                             0xC0000098L
#define STATUS_ALLOTTED_SPACE_EXCEEDED                  0xC0000099L
#define STATUS_INSUFFICIENT_RESOURCES                   0xC000009AL
#define STATUS_DFS_EXIT_PATH_FOUND                      0xC000009BL
#define STATUS_DEVICE_DATA_ERROR                        0xC000009CL
#define STATUS_DEVICE_NOT_CONNECTED                     0xC000009DL
#define STATUS_DEVICE_POWER_FAILURE                     0xC000009EL
#define STATUS_FREE_VM_NOT_AT_BASE                      0xC000009FL
#define STATUS_MEMORY_NOT_ALLOCATED                     0xC00000A0L
#define STATUS_WORKING_SET_QUOTA                        0xC00000A1L
#define STATUS_MEDIA_WRITE_PROTECTED                    0xC00000A2L
#define STATUS_DEVICE_NOT_READY                         0xC00000A3L
#define STATUS_INVALID_GROUP_ATTRIBUTES                 0xC00000A4L
#define STATUS_BAD_IMPERSONATION_LEVEL                  0xC00000A5L
#define STATUS_CANT_OPEN_ANONYMOUS                      0xC00000A6L
#define STATUS_BAD_VALIDATION_CLASS                     0xC00000A7L
#define STATUS_BAD_TOKEN_TYPE                           0xC00000A8L
#define STATUS_BAD_MASTER_BOOT_RECORD                   0xC00000A9L
#define STATUS_INSTRUCTION_MISALIGNMENT                 0xC00000AAL
#define STATUS_INSTANCE_NOT_AVAILABLE                   0xC00000ABL
#define STATUS_PIPE_NOT_AVAILABLE                       0xC00000ACL
#define STATUS_INVALID_PIPE_STATE                       0xC00000ADL
#define STATUS_PIPE_BUSY                                0xC00000AEL
#define STATUS_ILLEGAL_FUNCTION                         0xC00000AFL
#define STATUS_PIPE_DISCONNECTED                        0xC00000B0L
#define STATUS_PIPE_CLOSING                             0xC00000B1L
#define STATUS_PIPE_CONNECTED                           0xC00000B2L
#define STATUS_PIPE_LISTENING                           0xC00000B3L
#define STATUS_INVALID_READ_MODE                        0xC00000B4L
#define STATUS_IO_TIMEOUT                               0xC00000B5L
#define STATUS_FILE_FORCED_CLOSED                       0xC00000B6L
#define STATUS_PROFILING_NOT_STARTED                    0xC00000B7L
#define STATUS_PROFILING_NOT_STOPPED                    0xC00000B8L
#define STATUS_COULD_NOT_INTERPRET                      0xC00000B9L
#define STATUS_FILE_IS_A_DIRECTORY                      0xC00000BAL
#define STATUS_NOT_SUPPORTED                            0xC00000BBL
#define STATUS_REMOTE_NOT_LISTENING                     0xC00000BCL
#define STATUS_DUPLICATE_NAME                           0xC00000BDL
#define STATUS_BAD_NETWORK_PATH                         0xC00000BEL
#define STATUS_NETWORK_BUSY                             0xC00000BFL
#define STATUS_DEVICE_DOES_NOT_EXIST                    0xC00000C0L
#define STATUS_TOO_MANY_COMMANDS                        0xC00000C1L
#define STATUS_ADAPTER_HARDWARE_ERROR                   0xC00000C2L
#define STATUS_INVALID_NETWORK_RESPONSE                 0xC00000C3L
#define STATUS_UNEXPECTED_NETWORK_ERROR                 0xC00000C4L
#define STATUS_BAD_REMOTE_ADAPTER                       0xC00000C5L
#define STATUS_PRINT_QUEUE_FULL                         0xC00000C6L
#define STATUS_NO_SPOOL_SPACE                           0xC00000C7L
#define STATUS_PRINT_CANCELLED                          0xC00000C8L
#define STATUS_NETWORK_NAME_DELETED                     0xC00000C9L
#define STATUS_NETWORK_ACCESS_DENIED                    0xC00000CAL
#define STATUS_BAD_DEVICE_TYPE                          0xC00000CBL
#define STATUS_BAD_NETWORK_NAME                         0xC00000CCL
#define STATUS_TOO_MANY_NAMES                           0xC00000CDL
#define STATUS_TOO_MANY_SESSIONS                        0xC00000CEL
#define STATUS_SHARING_PAUSED                           0xC00000CFL
#define STATUS_REQUEST_NOT_ACCEPTED                     0xC00000D0L
#define STATUS_REDIRECTOR_PAUSED                        0xC00000D1L
#define STATUS_NET_WRITE_FAULT                          0xC00000D2L
#define STATUS_PROFILING_AT_LIMIT                       0xC00000D3L
#define STATUS_NOT_SAME_DEVICE                          0xC00000D4L
#define STATUS_FILE_RENAMED                             0xC00000D5L
#define STATUS_VIRTUAL_CIRCUIT_CLOSED                   0xC00000D6L
#define STATUS_NO_SECURITY_ON_OBJECT                    0xC00000D7L
#define STATUS_CANT_WAIT                                0xC00000D8L
#define STATUS_PIPE_EMPTY                               0xC00000D9L
#define STATUS_CANT_ACCESS_DOMAIN_INFO                  0xC00000DAL
#define STATUS_CANT_TERMINATE_SELF                      0xC00000DBL
#define STATUS_INVALID_SERVER_STATE                     0xC00000DCL
#define STATUS_INVALID_DOMAIN_STATE                     0xC00000DDL
#define STATUS_INVALID_DOMAIN_ROLE                      0xC00000DEL
#define STATUS_NO_SUCH_DOMAIN                           0xC00000DFL
#define STATUS_DOMAIN_EXISTS                            0xC00000E0L
#define STATUS_DOMAIN_LIMIT_EXCEEDED                    0xC00000E1L
#define STATUS_OPLOCK_NOT_GRANTED                       0xC00000E2L
#define STATUS_INVALID_OPLOCK_PROTOCOL                  0xC00000E3L
#define STATUS_INTERNAL_DB_CORRUPTION                   0xC00000E4L
#define STATUS_INTERNAL_ERROR                           0xC00000E5L
#define STATUS_GENERIC_NOT_MAPPED                       0xC00000E6L
#define STATUS_BAD_DESCRIPTOR_FORMAT                    0xC00000E7L
#define STATUS_INVALID_USER_BUFFER                      0xC00000E8L
#define STATUS_UNEXPECTED_IO_ERROR                      0xC00000E9L
#define STATUS_UNEXPECTED_MM_CREATE_ERR                 0xC00000EAL
#define STATUS_UNEXPECTED_MM_MAP_ERROR                  0xC00000EBL
#define STATUS_UNEXPECTED_MM_EXTEND_ERR                 0xC00000ECL
#define STATUS_NOT_LOGON_PROCESS                        0xC00000EDL
#define STATUS_LOGON_SESSION_EXISTS                     0xC00000EEL
#define STATUS_INVALID_PARAMETER_1                      0xC00000EFL
#define STATUS_INVALID_PARAMETER_2                      0xC00000F0L
#define STATUS_INVALID_PARAMETER_3                      0xC00000F1L
#define STATUS_INVALID_PARAMETER_4                      0xC00000F2L
#define STATUS_INVALID_PARAMETER_5                      0xC00000F3L
#define STATUS_INVALID_PARAMETER_6                      0xC00000F4L
#define STATUS_INVALID_PARAMETER_7                      0xC00000F5L
#define STATUS_INVALID_PARAMETER_8                      0xC00000F6L
#define STATUS_INVALID_PARAMETER_9                      0xC00000F7L
#define STATUS_INVALID_PARAMETER_10                     0xC00000F8L
#define STATUS_INVALID_PARAMETER_11                     0xC00000F9L
#define STATUS_INVALID_PARAMETER_12                     0xC00000FAL
#define STATUS_REDIRECTOR_NOT_STARTED                   0xC00000FBL
#define STATUS_REDIRECTOR_STARTED                       0xC00000FCL
#define STATUS_STACK_OVERFLOW                           0xC00000FDL
#define STATUS_NO_SUCH_PACKAGE                          0xC00000FEL
#define STATUS_BAD_FUNCTION_TABLE                       0xC00000FFL
#define STATUS_VARIABLE_NOT_FOUND                       0xC0000100L
#define STATUS_DIRECTORY_NOT_EMPTY                      0xC0000101L
#define STATUS_FILE_CORRUPT_ERROR                       0xC0000102L
#define STATUS_NOT_A_DIRECTORY                          0xC0000103L
#define STATUS_BAD_LOGON_SESSION_STATE                  0xC0000104L
#define STATUS_LOGON_SESSION_COLLISION                  0xC0000105L
#define STATUS_NAME_TOO_LONG                            0xC0000106L
#define STATUS_FILES_OPEN                               0xC0000107L
#define STATUS_CONNECTION_IN_USE                        0xC0000108L
#define STATUS_MESSAGE_NOT_FOUND                        0xC0000109L
#define STATUS_PROCESS_IS_TERMINATING                   0xC000010AL
#define STATUS_INVALID_LOGON_TYPE                       0xC000010BL
#define STATUS_NO_GUID_TRANSLATION                      0xC000010CL
#define STATUS_CANNOT_IMPERSONATE                       0xC000010DL
#define STATUS_IMAGE_ALREADY_LOADED                     0xC000010EL
#define STATUS_ABIOS_NOT_PRESENT                        0xC000010FL
#define STATUS_ABIOS_LID_NOT_EXIST                      0xC0000110L
#define STATUS_ABIOS_LID_ALREADY_OWNED                  0xC0000111L
#define STATUS_ABIOS_NOT_LID_OWNER                      0xC0000112L
#define STATUS_ABIOS_INVALID_COMMAND                    0xC0000113L
#define STATUS_ABIOS_INVALID_LID                        0xC0000114L
#define STATUS_ABIOS_SELECTOR_NOT_AVAILABLE             0xC0000115L
#define STATUS_ABIOS_INVALID_SELECTOR                   0xC0000116L
#define STATUS_NO_LDT                                   0xC0000117L
#define STATUS_INVALID_LDT_SIZE                         0xC0000118L
#define STATUS_INVALID_LDT_OFFSET                       0xC0000119L
#define STATUS_INVALID_LDT_DESCRIPTOR                   0xC000011AL
#define STATUS_INVALID_IMAGE_NE_FORMAT                  0xC000011BL
#define STATUS_RXACT_INVALID_STATE                      0xC000011CL
#define STATUS_RXACT_COMMIT_FAILURE                     0xC000011DL
#define STATUS_MAPPED_FILE_SIZE_ZERO                    0xC000011EL
#define STATUS_TOO_MANY_OPENED_FILES                    0xC000011FL
#define STATUS_CANCELLED                                0xC0000120L
#define STATUS_CANNOT_DELETE                            0xC0000121L
#define STATUS_INVALID_COMPUTER_NAME                    0xC0000122L
#define STATUS_FILE_DELETED                             0xC0000123L
#define STATUS_SPECIAL_ACCOUNT                          0xC0000124L
#define STATUS_SPECIAL_GROUP                            0xC0000125L
#define STATUS_SPECIAL_USER                             0xC0000126L
#define STATUS_MEMBERS_PRIMARY_GROUP                    0xC0000127L
#define STATUS_FILE_CLOSED                              0xC0000128L
#define STATUS_TOO_MANY_THREADS                         0xC0000129L
#define STATUS_THREAD_NOT_IN_PROCESS                    0xC000012AL
#define STATUS_TOKEN_ALREADY_IN_USE                     0xC000012BL
#define STATUS_PAGEFILE_QUOTA_EXCEEDED                  0xC000012CL
#define STATUS_COMMITMENT_LIMIT                         0xC000012DL
#define STATUS_INVALID_IMAGE_LE_FORMAT                  0xC000012EL
#define STATUS_INVALID_IMAGE_NOT_MZ                     0xC000012FL
#define STATUS_INVALID_IMAGE_PROTECT                    0xC0000130L
#define STATUS_INVALID_IMAGE_WIN_16                     0xC0000131L
#define STATUS_LOGON_SERVER_CONFLICT                    0xC0000132L
#define STATUS_TIME_DIFFERENCE_AT_DC                    0xC0000133L
#define STATUS_SYNCHRONIZATION_REQUIRED                 0xC0000134L
#define STATUS_DLL_NOT_FOUND                            0xC0000135L
#define STATUS_OPEN_FAILED                              0xC0000136L
#define STATUS_IO_PRIVILEGE_FAILED                      0xC0000137L
#define STATUS_ORDINAL_NOT_FOUND                        0xC0000138L
#define STATUS_ENTRYPOINT_NOT_FOUND                     0xC0000139L
#define STATUS_CONTROL_C_EXIT                           0xC000013AL
#define STATUS_LOCAL_DISCONNECT                         0xC000013BL
#define STATUS_REMOTE_DISCONNECT                        0xC000013CL
#define STATUS_REMOTE_RESOURCES                         0xC000013DL
#define STATUS_LINK_FAILED                              0xC000013EL
#define STATUS_LINK_TIMEOUT                             0xC000013FL
#define STATUS_INVALID_CONNECTION                       0xC0000140L
#define STATUS_INVALID_ADDRESS                          0xC0000141L
#define STATUS_DLL_INIT_FAILED                          0xC0000142L
#define STATUS_MISSING_SYSTEMFILE                       0xC0000143L
#define STATUS_UNHANDLED_EXCEPTION                      0xC0000144L
#define STATUS_APP_INIT_FAILURE                         0xC0000145L
#define STATUS_PAGEFILE_CREATE_FAILED                   0xC0000146L
#define STATUS_NO_PAGEFILE                              0xC0000147L
#define STATUS_INVALID_LEVEL                            0xC0000148L
#define STATUS_WRONG_PASSWORD_CODE                      0xC0000149L
#define STATUS_ILLEGAL_FLOAT_CONTEXT                    0xC000014AL
#define STATUS_PIPE_BROKEN                              0xC000014BL
#define STATUS_REGISTRY_CORRUPT                         0xC000014CL
#define STATUS_REGISTRY_IO_FAILED                       0xC000014DL
#define STATUS_NO_EVENT_PAIR                            0xC000014EL
#define STATUS_UNRECOGNIZED_VOLUME                      0xC000014FL
#define STATUS_SERIAL_NO_DEVICE_INITED                  0xC0000150L
#define STATUS_NO_SUCH_ALIAS                            0xC0000151L
#define STATUS_MEMBER_NOT_IN_ALIAS                      0xC0000152L
#define STATUS_MEMBER_IN_ALIAS                          0xC0000153L
#define STATUS_ALIAS_EXISTS                             0xC0000154L
#define STATUS_LOGON_NOT_GRANTED                        0xC0000155L
#define STATUS_TOO_MANY_SECRETS                         0xC0000156L
#define STATUS_SECRET_TOO_LONG                          0xC0000157L
#define STATUS_INTERNAL_DB_ERROR                        0xC0000158L
#define STATUS_FULLSCREEN_MODE                          0xC0000159L
#define STATUS_TOO_MANY_CONTEXT_IDS                     0xC000015AL
#define STATUS_LOGON_TYPE_NOT_GRANTED                   0xC000015BL
#define STATUS_NOT_REGISTRY_FILE                        0xC000015CL
#define STATUS_NT_CROSS_ENCRYPTION_REQUIRED             0xC000015DL
#define STATUS_DOMAIN_CTRLR_CONFIG_ERROR                0xC000015EL
#define STATUS_FT_MISSING_MEMBER                        0xC000015FL
#define STATUS_ILL_FORMED_SERVICE_ENTRY                 0xC0000160L
#define STATUS_ILLEGAL_CHARACTER                        0xC0000161L
#define STATUS_UNMAPPABLE_CHARACTER                     0xC0000162L
#define STATUS_UNDEFINED_CHARACTER                      0xC0000163L
#define STATUS_FLOPPY_VOLUME                            0xC0000164L
#define STATUS_FLOPPY_ID_MARK_NOT_FOUND                 0xC0000165L
#define STATUS_FLOPPY_WRONG_CYLINDER                    0xC0000166L
#define STATUS_FLOPPY_UNKNOWN_ERROR                     0xC0000167L
#define STATUS_FLOPPY_BAD_REGISTERS                     0xC0000168L
#define STATUS_DISK_RECALIBRATE_FAILED                  0xC0000169L
#define STATUS_DISK_OPERATION_FAILED                    0xC000016AL
#define STATUS_DISK_RESET_FAILED                        0xC000016BL
#define STATUS_SHARED_IRQ_BUSY                          0xC000016CL
#define STATUS_FT_ORPHANING                             0xC000016DL
#define STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT         0xC000016EL
#define STATUS_PARTITION_FAILURE                        0xC0000172L
#define STATUS_INVALID_BLOCK_LENGTH                     0xC0000173L
#define STATUS_DEVICE_NOT_PARTITIONED                   0xC0000174L
#define STATUS_UNABLE_TO_LOCK_MEDIA                     0xC0000175L
#define STATUS_UNABLE_TO_UNLOAD_MEDIA                   0xC0000176L
#define STATUS_EOM_OVERFLOW                             0xC0000177L
#define STATUS_NO_MEDIA                                 0xC0000178L
#define STATUS_NO_SUCH_MEMBER                           0xC000017AL
#define STATUS_INVALID_MEMBER                           0xC000017BL
#define STATUS_KEY_DELETED                              0xC000017CL
#define STATUS_NO_LOG_SPACE                             0xC000017DL
#define STATUS_TOO_MANY_SIDS                            0xC000017EL
#define STATUS_LM_CROSS_ENCRYPTION_REQUIRED             0xC000017FL
#define STATUS_KEY_HAS_CHILDREN                         0xC0000180L
#define STATUS_CHILD_MUST_BE_VOLATILE                   0xC0000181L
#define STATUS_DEVICE_CONFIGURATION_ERROR               0xC0000182L
#define STATUS_DRIVER_INTERNAL_ERROR                    0xC0000183L
#define STATUS_INVALID_DEVICE_STATE                     0xC0000184L
#define STATUS_IO_DEVICE_ERROR                          0xC0000185L
#define STATUS_DEVICE_PROTOCOL_ERROR                    0xC0000186L
#define STATUS_BACKUP_CONTROLLER                        0xC0000187L
#define STATUS_LOG_FILE_FULL                            0xC0000188L
#define STATUS_TOO_LATE                                 0xC0000189L
#define STATUS_NO_TRUST_LSA_SECRET                      0xC000018AL
#define STATUS_NO_TRUST_SAM_ACCOUNT                     0xC000018BL
#define STATUS_TRUSTED_DOMAIN_FAILURE                   0xC000018CL
#define STATUS_TRUSTED_RELATIONSHIP_FAILURE             0xC000018DL
#define STATUS_EVENTLOG_FILE_CORRUPT                    0xC000018EL
#define STATUS_EVENTLOG_CANT_START                      0xC000018FL
#define STATUS_TRUST_FAILURE                            0xC0000190L
#define STATUS_MUTANT_LIMIT_EXCEEDED                    0xC0000191L
#define STATUS_NETLOGON_NOT_STARTED                     0xC0000192L
#define STATUS_ACCOUNT_EXPIRED                          0xC0000193L
#define STATUS_POSSIBLE_DEADLOCK                        0xC0000194L
#define STATUS_NETWORK_CREDENTIAL_CONFLICT              0xC0000195L
#define STATUS_REMOTE_SESSION_LIMIT                     0xC0000196L
#define STATUS_EVENTLOG_FILE_CHANGED                    0xC0000197L
#define STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT        0xC0000198L
#define STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT        0xC0000199L
#define STATUS_NOLOGON_SERVER_TRUST_ACCOUNT             0xC000019AL
#define STATUS_DOMAIN_TRUST_INCONSISTENT                0xC000019BL
#define STATUS_FS_DRIVER_REQUIRED                       0xC000019CL
#define STATUS_IMAGE_ALREADY_LOADED_AS_DLL              0xC000019DL
#define STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING 0xC000019EL
#define STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME        0xC000019FL
#define STATUS_SECURITY_STREAM_IS_INCONSISTENT          0xC00001A0L
#define STATUS_INVALID_LOCK_RANGE                       0xC00001A1L
#define STATUS_INVALID_ACE_CONDITION                    0xC00001A2L
#define STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT              0xC00001A3L
#define STATUS_NOTIFICATION_GUID_ALREADY_DEFINED        0xC00001A4L
#define STATUS_NETWORK_OPEN_RESTRICTION                 0xC0000201L
#define STATUS_NO_USER_SESSION_KEY                      0xC0000202L
#define STATUS_USER_SESSION_DELETED                     0xC0000203L
#define STATUS_RESOURCE_LANG_NOT_FOUND                  0xC0000204L
#define STATUS_INSUFF_SERVER_RESOURCES                  0xC0000205L
#define STATUS_INVALID_BUFFER_SIZE                      0xC0000206L
#define STATUS_INVALID_ADDRESS_COMPONENT                0xC0000207L
#define STATUS_INVALID_ADDRESS_WILDCARD                 0xC0000208L
#define STATUS_TOO_MANY_ADDRESSES                       0xC0000209L
#define STATUS_ADDRESS_ALREADY_EXISTS                   0xC000020AL
#define STATUS_ADDRESS_CLOSED                           0xC000020BL
#define STATUS_CONNECTION_DISCONNECTED                  0xC000020CL
#define STATUS_CONNECTION_RESET                         0xC000020DL
#define STATUS_TOO_MANY_NODES                           0xC000020EL
#define STATUS_TRANSACTION_ABORTED                      0xC000020FL
#define STATUS_TRANSACTION_TIMED_OUT                    0xC0000210L
#define STATUS_TRANSACTION_NO_RELEASE                   0xC0000211L
#define STATUS_TRANSACTION_NO_MATCH                     0xC0000212L
#define STATUS_TRANSACTION_RESPONDED                    0xC0000213L
#define STATUS_TRANSACTION_INVALID_ID                   0xC0000214L
#define STATUS_TRANSACTION_INVALID_TYPE                 0xC0000215L
#define STATUS_NOT_SERVER_SESSION                       0xC0000216L
#define STATUS_NOT_CLIENT_SESSION                       0xC0000217L
#define STATUS_CANNOT_LOAD_REGISTRY_FILE                0xC0000218L
#define STATUS_DEBUG_ATTACH_FAILED                      0xC0000219L
#define STATUS_SYSTEM_PROCESS_TERMINATED                0xC000021AL
#define STATUS_DATA_NOT_ACCEPTED                        0xC000021BL
#define STATUS_NO_BROWSER_SERVERS_FOUND                 0xC000021CL
#define STATUS_VDM_HARD_ERROR                           0xC000021DL
#define STATUS_DRIVER_CANCEL_TIMEOUT                    0xC000021EL
#define STATUS_REPLY_MESSAGE_MISMATCH                   0xC000021FL
#define STATUS_MAPPED_ALIGNMENT                         0xC0000220L
#define STATUS_IMAGE_CHECKSUM_MISMATCH                  0xC0000221L
#define STATUS_LOST_WRITEBEHIND_DATA                    0xC0000222L
#define STATUS_CLIENT_SERVER_PARAMETERS_INVALID         0xC0000223L
#define STATUS_PASSWORD_MUST_CHANGE                     0xC0000224L
#define STATUS_NOT_FOUND                                0xC0000225L
#define STATUS_NOT_TINY_STREAM                          0xC0000226L
#define STATUS_RECOVERY_FAILURE                         0xC0000227L
#define STATUS_STACK_OVERFLOW_READ                      0xC0000228L
#define STATUS_FAIL_CHECK                               0xC0000229L
#define STATUS_DUPLICATE_OBJECTID                       0xC000022AL
#define STATUS_OBJECTID_EXISTS                          0xC000022BL
#define STATUS_CONVERT_TO_LARGE                         0xC000022CL
#define STATUS_RETRY                                    0xC000022DL
#define STATUS_FOUND_OUT_OF_SCOPE                       0xC000022EL
#define STATUS_ALLOCATE_BUCKET                          0xC000022FL
#define STATUS_PROPSET_NOT_FOUND                        0xC0000230L
#define STATUS_MARSHALL_OVERFLOW                        0xC0000231L
#define STATUS_INVALID_VARIANT                          0xC0000232L
#define STATUS_DOMAIN_CONTROLLER_NOT_FOUND              0xC0000233L
#define STATUS_ACCOUNT_LOCKED_OUT                       0xC0000234L
#define STATUS_HANDLE_NOT_CLOSABLE                      0xC0000235L
#define STATUS_CONNECTION_REFUSED                       0xC0000236L
#define STATUS_GRACEFUL_DISCONNECT                      0xC0000237L
#define STATUS_ADDRESS_ALREADY_ASSOCIATED               0xC0000238L
#define STATUS_ADDRESS_NOT_ASSOCIATED                   0xC0000239L
#define STATUS_CONNECTION_INVALID                       0xC000023AL
#define STATUS_CONNECTION_ACTIVE                        0xC000023BL
#define STATUS_NETWORK_UNREACHABLE                      0xC000023CL
#define STATUS_UNREACHABLE                              0xC000023DL
#define STATUS_PROTOCOL_UNREACHABLE                     0xC000023EL
#define STATUS_PORT_UNREACHABLE                         0xC000023FL
#define STATUS_REQUEST_ABORTED                          0xC0000240L
#define STATUS_CONNECTION_ABORTED                       0xC0000241L
#define STATUS_BAD_COMPRESSION_BUFFER                   0xC0000242L
#define STATUS_USER_MAPPED_FILE                         0xC0000243L
#define STATUS_AUDIT_FAILED                             0xC0000244L
#define STATUS_TIMER_RESOLUTION_NOT_SET                 0xC0000245L
#define STATUS_CONNECTION_COUNT_LIMIT                   0xC0000246L
#define STATUS_LOGIN_TIME_RESTRICTION                   0xC0000247L
#define STATUS_LOGIN_WKSTA_RESTRICTION                  0xC0000248L
#define STATUS_IMAGE_MP_UP_MISMATCH                     0xC0000249L
#define STATUS_INSUFFICIENT_LOGON_INFO                  0xC0000250L
#define STATUS_BAD_DLL_ENTRYPOINT                       0xC0000251L
#define STATUS_BAD_SERVICE_ENTRYPOINT                   0xC0000252L
#define STATUS_LPC_REPLY_LOST                           0xC0000253L
#define STATUS_IP_ADDRESS_CONFLICT1                     0xC0000254L
#define STATUS_IP_ADDRESS_CONFLICT2                     0xC0000255L
#define STATUS_REGISTRY_QUOTA_LIMIT                     0xC0000256L
#define STATUS_PATH_NOT_COVERED                         0xC0000257L
#define STATUS_NO_CALLBACK_ACTIVE                       0xC0000258L
#define STATUS_LICENSE_QUOTA_EXCEEDED                   0xC0000259L
#define STATUS_PWD_TOO_SHORT                            0xC000025AL
#define STATUS_PWD_TOO_RECENT                           0xC000025BL
#define STATUS_PWD_HISTORY_CONFLICT                     0xC000025CL
#define STATUS_PLUGPLAY_NO_DEVICE                       0xC000025EL
#define STATUS_UNSUPPORTED_COMPRESSION                  0xC000025FL
#define STATUS_INVALID_HW_PROFILE                       0xC0000260L
#define STATUS_INVALID_PLUGPLAY_DEVICE_PATH             0xC0000261L
#define STATUS_DRIVER_ORDINAL_NOT_FOUND                 0xC0000262L
#define STATUS_DRIVER_ENTRYPOINT_NOT_FOUND              0xC0000263L
#define STATUS_RESOURCE_NOT_OWNED                       0xC0000264L
#define STATUS_TOO_MANY_LINKS                           0xC0000265L
#define STATUS_QUOTA_LIST_INCONSISTENT                  0xC0000266L
#define STATUS_FILE_IS_OFFLINE                          0xC0000267L
#define STATUS_EVALUATION_EXPIRATION                    0xC0000268L
#define STATUS_ILLEGAL_DLL_RELOCATION                   0xC0000269L
#define STATUS_LICENSE_VIOLATION                        0xC000026AL
#define STATUS_DLL_INIT_FAILED_LOGOFF                   0xC000026BL
#define STATUS_DRIVER_UNABLE_TO_LOAD                    0xC000026CL
#define STATUS_DFS_UNAVAILABLE                          0xC000026DL
#define STATUS_VOLUME_DISMOUNTED                        0xC000026EL
#define STATUS_WX86_INTERNAL_ERROR                      0xC000026FL
#define STATUS_WX86_FLOAT_STACK_CHECK                   0xC0000270L
#define STATUS_VALIDATE_CONTINUE                        0xC0000271L
#define STATUS_NO_MATCH                                 0xC0000272L
#define STATUS_NO_MORE_MATCHES                          0xC0000273L
#define STATUS_NOT_A_REPARSE_POINT                      0xC0000275L
#define STATUS_IO_REPARSE_TAG_INVALID                   0xC0000276L
#define STATUS_IO_REPARSE_TAG_MISMATCH                  0xC0000277L
#define STATUS_IO_REPARSE_DATA_INVALID                  0xC0000278L
#define STATUS_IO_REPARSE_TAG_NOT_HANDLED               0xC0000279L
#define STATUS_REPARSE_POINT_NOT_RESOLVED               0xC0000280L
#define STATUS_DIRECTORY_IS_A_REPARSE_POINT             0xC0000281L
#define STATUS_RANGE_LIST_CONFLICT                      0xC0000282L
#define STATUS_SOURCE_ELEMENT_EMPTY                     0xC0000283L
#define STATUS_DESTINATION_ELEMENT_FULL                 0xC0000284L
#define STATUS_ILLEGAL_ELEMENT_ADDRESS                  0xC0000285L
#define STATUS_MAGAZINE_NOT_PRESENT                     0xC0000286L
#define STATUS_REINITIALIZATION_NEEDED                  0xC0000287L
#define STATUS_DEVICE_REQUIRES_CLEANING                 0xC0000288L
#define STATUS_DEVICE_DOOR_OPEN                         0xC0000289L
#define STATUS_ENCRYPTION_FAILED                        0xC000028AL
#define STATUS_DECRYPTION_FAILED                        0xC000028BL
#define STATUS_RANGE_NOT_FOUND                          0xC000028CL
#define STATUS_NO_RECOVERY_POLICY                       0xC000028DL
#define STATUS_NO_EFS                                   0xC000028EL
#define STATUS_WRONG_EFS                                0xC000028FL
#define STATUS_NO_USER_KEYS                             0xC0000290L
#define STATUS_FILE_NOT_ENCRYPTED                       0xC0000291L
#define STATUS_NOT_EXPORT_FORMAT                        0xC0000292L
#define STATUS_NOT_ENCRYPTED                            0xC0000293L
#define STATUS_WAKE_SYSTEM                              0xC0000294L
#define STATUS_WMI_GUID_NOT_FOUND                       0xC0000295L
#define STATUS_WMI_INSTANCE_NOT_FOUND                   0xC0000296L
#define STATUS_WMI_ITEMID_NOT_FOUND                     0xC0000297L
#define STATUS_WMI_TRY_AGAIN                            0xC0000298L
#define STATUS_SHARED_POLICY                            0xC0000299L
#define STATUS_POLICY_OBJECT_NOT_FOUND                  0xC000029AL
#define STATUS_POLICY_ONLY_IN_DS                        0xC000029BL
#define STATUS_VOLUME_NOT_UPGRADED                      0xC000029CL
#define STATUS_REMOTE_STORAGE_NOT_ACTIVE                0xC000029DL
#define STATUS_REMOTE_STORAGE_MEDIA_ERROR               0xC000029EL
#define STATUS_NO_TRACKING_SERVICE                      0xC000029FL
#define STATUS_SERVER_SID_MISMATCH                      0xC00002A0L
#define STATUS_DS_NO_ATTRIBUTE_OR_VALUE                 0xC00002A1L
#define STATUS_DS_INVALID_ATTRIBUTE_SYNTAX              0xC00002A2L
#define STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED              0xC00002A3L
#define STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS             0xC00002A4L
#define STATUS_DS_BUSY                                  0xC00002A5L
#define STATUS_DS_UNAVAILABLE                           0xC00002A6L
#define STATUS_DS_NO_RIDS_ALLOCATED                     0xC00002A7L
#define STATUS_DS_NO_MORE_RIDS                          0xC00002A8L
#define STATUS_DS_INCORRECT_ROLE_OWNER                  0xC00002A9L
#define STATUS_DS_RIDMGR_INIT_ERROR                     0xC00002AAL
#define STATUS_DS_OBJ_CLASS_VIOLATION                   0xC00002ABL
#define STATUS_DS_CANT_ON_NON_LEAF                      0xC00002ACL
#define STATUS_DS_CANT_ON_RDN                           0xC00002ADL
#define STATUS_DS_CANT_MOD_OBJ_CLASS                    0xC00002AEL
#define STATUS_DS_CROSS_DOM_MOVE_FAILED                 0xC00002AFL
#define STATUS_DS_GC_NOT_AVAILABLE                      0xC00002B0L
#define STATUS_DIRECTORY_SERVICE_REQUIRED               0xC00002B1L
#define STATUS_REPARSE_ATTRIBUTE_CONFLICT               0xC00002B2L
#define STATUS_CANT_ENABLE_DENY_ONLY                    0xC00002B3L
#define STATUS_FLOAT_MULTIPLE_FAULTS                    0xC00002B4L
#define STATUS_FLOAT_MULTIPLE_TRAPS                     0xC00002B5L
#define STATUS_DEVICE_REMOVED                           0xC00002B6L
#define STATUS_JOURNAL_DELETE_IN_PROGRESS               0xC00002B7L
#define STATUS_JOURNAL_NOT_ACTIVE                       0xC00002B8L
#define STATUS_NOINTERFACE                              0xC00002B9L
#define STATUS_DS_ADMIN_LIMIT_EXCEEDED                  0xC00002C1L
#define STATUS_DRIVER_FAILED_SLEEP                      0xC00002C2L
#define STATUS_MUTUAL_AUTHENTICATION_FAILED             0xC00002C3L
#define STATUS_CORRUPT_SYSTEM_FILE                      0xC00002C4L
#define STATUS_DATATYPE_MISALIGNMENT_ERROR              0xC00002C5L
#define STATUS_WMI_READ_ONLY                            0xC00002C6L
#define STATUS_WMI_SET_FAILURE                          0xC00002C7L
#define STATUS_COMMITMENT_MINIMUM                       0xC00002C8L
#define STATUS_REG_NAT_CONSUMPTION                      0xC00002C9L
#define STATUS_TRANSPORT_FULL                           0xC00002CAL
#define STATUS_DS_SAM_INIT_FAILURE                      0xC00002CBL
#define STATUS_ONLY_IF_CONNECTED                        0xC00002CCL
#define STATUS_DS_SENSITIVE_GROUP_VIOLATION             0xC00002CDL
#define STATUS_PNP_RESTART_ENUMERATION                  0xC00002CEL
#define STATUS_JOURNAL_ENTRY_DELETED                    0xC00002CFL
#define STATUS_DS_CANT_MOD_PRIMARYGROUPID               0xC00002D0L
#define STATUS_SYSTEM_IMAGE_BAD_SIGNATURE               0xC00002D1L
#define STATUS_PNP_REBOOT_REQUIRED                      0xC00002D2L
#define STATUS_POWER_STATE_INVALID                      0xC00002D3L
#define STATUS_DS_INVALID_GROUP_TYPE                    0xC00002D4L
#define STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN    0xC00002D5L
#define STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN     0xC00002D6L
#define STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER         0xC00002D7L
#define STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER     0xC00002D8L
#define STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER      0xC00002D9L
#define STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER   0xC00002DAL
#define STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_MEMBER    0xC00002DBL
#define STATUS_DS_HAVE_PRIMARY_MEMBERS                  0xC00002DCL
#define STATUS_WMI_NOT_SUPPORTED                        0xC00002DDL
#define STATUS_INSUFFICIENT_POWER                       0xC00002DEL
#define STATUS_SAM_NEED_BOOTKEY_PASSWORD                0xC00002DFL
#define STATUS_SAM_NEED_BOOTKEY_FLOPPY                  0xC00002E0L
#define STATUS_DS_CANT_START                            0xC00002E1L
#define STATUS_DS_INIT_FAILURE                          0xC00002E2L
#define STATUS_SAM_INIT_FAILURE                         0xC00002E3L
#define STATUS_DS_GC_REQUIRED                           0xC00002E4L
#define STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY            0xC00002E5L
#define STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS            0xC00002E6L
#define STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED        0xC00002E7L
#define STATUS_MULTIPLE_FAULT_VIOLATION                 0xC00002E8L
#define STATUS_CURRENT_DOMAIN_NOT_ALLOWED               0xC00002E9L
#define STATUS_CANNOT_MAKE                              0xC00002EAL
#define STATUS_SYSTEM_SHUTDOWN                          0xC00002EBL
#define STATUS_DS_INIT_FAILURE_CONSOLE                  0xC00002ECL
#define STATUS_DS_SAM_INIT_FAILURE_CONSOLE              0xC00002EDL
#define STATUS_UNFINISHED_CONTEXT_DELETED               0xC00002EEL
#define STATUS_NO_TGT_REPLY                             0xC00002EFL
#define STATUS_OBJECTID_NOT_FOUND                       0xC00002F0L
#define STATUS_NO_IP_ADDRESSES                          0xC00002F1L
#define STATUS_WRONG_CREDENTIAL_HANDLE                  0xC00002F2L
#define STATUS_CRYPTO_SYSTEM_INVALID                    0xC00002F3L
#define STATUS_MAX_REFERRALS_EXCEEDED                   0xC00002F4L
#define STATUS_MUST_BE_KDC                              0xC00002F5L
#define STATUS_STRONG_CRYPTO_NOT_SUPPORTED              0xC00002F6L
#define STATUS_TOO_MANY_PRINCIPALS                      0xC00002F7L
#define STATUS_NO_PA_DATA                               0xC00002F8L
#define STATUS_PKINIT_NAME_MISMATCH                     0xC00002F9L
#define STATUS_SMARTCARD_LOGON_REQUIRED                 0xC00002FAL
#define STATUS_KDC_INVALID_REQUEST                      0xC00002FBL
#define STATUS_KDC_UNABLE_TO_REFER                      0xC00002FCL
#define STATUS_KDC_UNKNOWN_ETYPE                        0xC00002FDL
#define STATUS_SHUTDOWN_IN_PROGRESS                     0xC00002FEL
#define STATUS_SERVER_SHUTDOWN_IN_PROGRESS              0xC00002FFL
#define STATUS_NOT_SUPPORTED_ON_SBS                     0xC0000300L
#define STATUS_WMI_GUID_DISCONNECTED                    0xC0000301L
#define STATUS_WMI_ALREADY_DISABLED                     0xC0000302L
#define STATUS_WMI_ALREADY_ENABLED                      0xC0000303L
#define STATUS_MFT_TOO_FRAGMENTED                       0xC0000304L
#define STATUS_COPY_PROTECTION_FAILURE                  0xC0000305L
#define STATUS_CSS_AUTHENTICATION_FAILURE               0xC0000306L
#define STATUS_CSS_KEY_NOT_PRESENT                      0xC0000307L
#define STATUS_CSS_KEY_NOT_ESTABLISHED                  0xC0000308L
#define STATUS_CSS_SCRAMBLED_SECTOR                     0xC0000309L
#define STATUS_CSS_REGION_MISMATCH                      0xC000030AL
#define STATUS_CSS_RESETS_EXHAUSTED                     0xC000030BL
#define STATUS_PKINIT_FAILURE                           0xC0000320L
#define STATUS_SMARTCARD_SUBSYSTEM_FAILURE              0xC0000321L
#define STATUS_NO_KERB_KEY                              0xC0000322L
#define STATUS_HOST_DOWN                                0xC0000350L
#define STATUS_UNSUPPORTED_PREAUTH                      0xC0000351L
#define STATUS_EFS_ALG_BLOB_TOO_BIG                     0xC0000352L
#define STATUS_PORT_NOT_SET                             0xC0000353L
#define STATUS_DEBUGGER_INACTIVE                        0xC0000354L
#define STATUS_DS_VERSION_CHECK_FAILURE                 0xC0000355L
#define STATUS_AUDITING_DISABLED                        0xC0000356L
#define STATUS_PRENT4_MACHINE_ACCOUNT                   0xC0000357L
#define STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER         0xC0000358L
#define STATUS_INVALID_IMAGE_WIN_32                     0xC0000359L
#define STATUS_INVALID_IMAGE_WIN_64                     0xC000035AL
#define STATUS_BAD_BINDINGS                             0xC000035BL
#define STATUS_NETWORK_SESSION_EXPIRED                  0xC000035CL
#define STATUS_APPHELP_BLOCK                            0xC000035DL
#define STATUS_ALL_SIDS_FILTERED                        0xC000035EL
#define STATUS_NOT_SAFE_MODE_DRIVER                     0xC000035FL
#define STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT        0xC0000361L
#define STATUS_ACCESS_DISABLED_BY_POLICY_PATH           0xC0000362L
#define STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER      0xC0000363L
#define STATUS_ACCESS_DISABLED_BY_POLICY_OTHER          0xC0000364L
#define STATUS_FAILED_DRIVER_ENTRY                      0xC0000365L
#define STATUS_DEVICE_ENUMERATION_ERROR                 0xC0000366L
#define STATUS_MOUNT_POINT_NOT_RESOLVED                 0xC0000368L
#define STATUS_INVALID_DEVICE_OBJECT_PARAMETER          0xC0000369L
#define STATUS_MCA_OCCURED                              0xC000036AL
#define STATUS_DRIVER_BLOCKED_CRITICAL                  0xC000036BL
#define STATUS_DRIVER_BLOCKED                           0xC000036CL
#define STATUS_DRIVER_DATABASE_ERROR                    0xC000036DL
#define STATUS_SYSTEM_HIVE_TOO_LARGE                    0xC000036EL
#define STATUS_INVALID_IMPORT_OF_NON_DLL                0xC000036FL
#define STATUS_DS_SHUTTING_DOWN                         0xC0000370L
#define STATUS_NO_SECRETS                               0xC0000371L
#define STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY    0xC0000372L
#define STATUS_FAILED_STACK_SWITCH                      0xC0000373L
#define STATUS_HEAP_CORRUPTION                          0xC0000374L
#define STATUS_SMARTCARD_WRONG_PIN                      0xC0000380L
#define STATUS_SMARTCARD_CARD_BLOCKED                   0xC0000381L
#define STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED         0xC0000382L
#define STATUS_SMARTCARD_NO_CARD                        0xC0000383L
#define STATUS_SMARTCARD_NO_KEY_CONTAINER               0xC0000384L
#define STATUS_SMARTCARD_NO_CERTIFICATE                 0xC0000385L
#define STATUS_SMARTCARD_NO_KEYSET                      0xC0000386L
#define STATUS_SMARTCARD_IO_ERROR                       0xC0000387L
#define STATUS_DOWNGRADE_DETECTED                       0xC0000388L
#define STATUS_SMARTCARD_CERT_REVOKED                   0xC0000389L
#define STATUS_ISSUING_CA_UNTRUSTED                     0xC000038AL
#define STATUS_REVOCATION_OFFLINE_C                     0xC000038BL
#define STATUS_PKINIT_CLIENT_FAILURE                    0xC000038CL
#define STATUS_SMARTCARD_CERT_EXPIRED                   0xC000038DL
#define STATUS_DRIVER_FAILED_PRIOR_UNLOAD               0xC000038EL
#define STATUS_SMARTCARD_SILENT_CONTEXT                 0xC000038FL
#define STATUS_PER_USER_TRUST_QUOTA_EXCEEDED            0xC0000401L
#define STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED            0xC0000402L
#define STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED         0xC0000403L
#define STATUS_DS_NAME_NOT_UNIQUE                       0xC0000404L
#define STATUS_DS_DUPLICATE_ID_FOUND                    0xC0000405L
#define STATUS_DS_GROUP_CONVERSION_ERROR                0xC0000406L
#define STATUS_VOLSNAP_PREPARE_HIBERNATE                0xC0000407L
#define STATUS_USER2USER_REQUIRED                       0xC0000408L
#define STATUS_STACK_BUFFER_OVERRUN                     0xC0000409L
#define STATUS_NO_S4U_PROT_SUPPORT                      0xC000040AL
#define STATUS_CROSSREALM_DELEGATION_FAILURE            0xC000040BL
#define STATUS_REVOCATION_OFFLINE_KDC                   0xC000040CL
#define STATUS_ISSUING_CA_UNTRUSTED_KDC                 0xC000040DL
#define STATUS_KDC_CERT_EXPIRED                         0xC000040EL
#define STATUS_KDC_CERT_REVOKED                         0xC000040FL
#define STATUS_PARAMETER_QUOTA_EXCEEDED                 0xC0000410L
#define STATUS_HIBERNATION_FAILURE                      0xC0000411L
#define STATUS_DELAY_LOAD_FAILED                        0xC0000412L
#define STATUS_AUTHENTICATION_FIREWALL_FAILED           0xC0000413L
#define STATUS_VDM_DISALLOWED                           0xC0000414L
#define STATUS_HUNG_DISPLAY_DRIVER_THREAD               0xC0000415L
#define STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE  0xC0000416L
#define STATUS_INVALID_CRUNTIME_PARAMETER               0xC0000417L
#define STATUS_NTLM_BLOCKED                             0xC0000418L
#define STATUS_DS_SRC_SID_EXISTS_IN_FOREST              0xC0000419L
#define STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST          0xC000041AL
#define STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST            0xC000041BL
#define STATUS_INVALID_USER_PRINCIPAL_NAME              0xC000041CL
#define STATUS_FATAL_USER_CALLBACK_EXCEPTION            0xC000041DL
#define STATUS_ASSERTION_FAILURE                        0xC0000420L
#define STATUS_VERIFIER_STOP                            0xC0000421L
#define STATUS_CALLBACK_POP_STACK                       0xC0000423L
#define STATUS_INCOMPATIBLE_DRIVER_BLOCKED              0xC0000424L
#define STATUS_HIVE_UNLOADED                            0xC0000425L
#define STATUS_COMPRESSION_DISABLED                     0xC0000426L
#define STATUS_FILE_SYSTEM_LIMITATION                   0xC0000427L
#define STATUS_INVALID_IMAGE_HASH                       0xC0000428L
#define STATUS_NOT_CAPABLE                              0xC0000429L
#define STATUS_REQUEST_OUT_OF_SEQUENCE                  0xC000042AL
#define STATUS_IMPLEMENTATION_LIMIT                     0xC000042BL
#define STATUS_ELEVATION_REQUIRED                       0xC000042CL
#define STATUS_NO_SECURITY_CONTEXT                      0xC000042DL
#define STATUS_PKU2U_CERT_FAILURE                       0xC000042FL
#define STATUS_BEYOND_VDL                               0xC0000432L
#define STATUS_ENCOUNTERED_WRITE_IN_PROGRESS            0xC0000433L
#define STATUS_PTE_CHANGED                              0xC0000434L
#define STATUS_PURGE_FAILED                             0xC0000435L
#define STATUS_CRED_REQUIRES_CONFIRMATION               0xC0000440L
#define STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE    0xC0000441L
#define STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER         0xC0000442L
#define STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE    0xC0000443L
#define STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE         0xC0000444L
#define STATUS_CS_ENCRYPTION_FILE_NOT_CSE               0xC0000445L
#define STATUS_INVALID_LABEL                            0xC0000446L
#define STATUS_DRIVER_PROCESS_TERMINATED                0xC0000450L
#define STATUS_AMBIGUOUS_SYSTEM_DEVICE                  0xC0000451L
#define STATUS_SYSTEM_DEVICE_NOT_FOUND                  0xC0000452L
#define STATUS_RESTART_BOOT_APPLICATION                 0xC0000453L
#define STATUS_INSUFFICIENT_NVRAM_RESOURCES             0xC0000454L
#define STATUS_INVALID_TASK_NAME                        0xC0000500L
#define STATUS_INVALID_TASK_INDEX                       0xC0000501L
#define STATUS_THREAD_ALREADY_IN_TASK                   0xC0000502L
#define STATUS_CALLBACK_BYPASS                          0xC0000503L
#define STATUS_FAIL_FAST_EXCEPTION                      0xC0000602L
#define STATUS_IMAGE_CERT_REVOKED                       0xC0000603L
#define STATUS_PORT_CLOSED                              0xC0000700L
#define STATUS_MESSAGE_LOST                             0xC0000701L
#define STATUS_INVALID_MESSAGE                          0xC0000702L
#define STATUS_REQUEST_CANCELED                         0xC0000703L
#define STATUS_RECURSIVE_DISPATCH                       0xC0000704L
#define STATUS_LPC_RECEIVE_BUFFER_EXPECTED              0xC0000705L
#define STATUS_LPC_INVALID_CONNECTION_USAGE             0xC0000706L
#define STATUS_LPC_REQUESTS_NOT_ALLOWED                 0xC0000707L
#define STATUS_RESOURCE_IN_USE                          0xC0000708L
#define STATUS_HARDWARE_MEMORY_ERROR                    0xC0000709L
#define STATUS_THREADPOOL_HANDLE_EXCEPTION              0xC000070AL
#define STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED    0xC000070BL
#define STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPELTION_FAILED    0xC000070CL
#define STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED    0xC000070DL
#define STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED 0xC000070EL
#define STATUS_THREADPOOL_RELEASED_DURING_OPERATION     0xC000070FL
#define STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING    0xC0000710L
#define STATUS_APC_RETURNED_WHILE_IMPERSONATING         0xC0000711L
#define STATUS_PROCESS_IS_PROTECTED                     0xC0000712L
#define STATUS_MCA_EXCEPTION                            0xC0000713L
#define STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE           0xC0000714L
#define STATUS_SYMLINK_CLASS_DISABLED                   0xC0000715L
#define STATUS_INVALID_IDN_NORMALIZATION                0xC0000716L
#define STATUS_NO_UNICODE_TRANSLATION                   0xC0000717L
#define STATUS_ALREADY_REGISTERED                       0xC0000718L
#define STATUS_CONTEXT_MISMATCH                         0xC0000719L
#define STATUS_PORT_ALREADY_HAS_COMPLETION_LIST         0xC000071AL
#define STATUS_CALLBACK_RETURNED_THREAD_PRIORITY        0xC000071BL
#define STATUS_INVALID_THREAD                           0xC000071CL
#define STATUS_CALLBACK_RETURNED_TRANSACTION            0xC000071DL
#define STATUS_CALLBACK_RETURNED_LDR_LOCK               0xC000071EL
#define STATUS_CALLBACK_RETURNED_LANG                   0xC000071FL
#define STATUS_CALLBACK_RETURNED_PRI_BACK               0xC0000720L
#define STATUS_CALLBACK_RETURNED_THREAD_AFFINITY        0xC0000721L
#define STATUS_DISK_REPAIR_DISABLED                     0xC0000800L
#define STATUS_DS_DOMAIN_RENAME_IN_PROGRESS             0xC0000801L
#define STATUS_DISK_QUOTA_EXCEEDED                      0xC0000802L
#define STATUS_DATA_LOST_REPAIR                         0xC0000803L
#define STATUS_CONTENT_BLOCKED                          0xC0000804L
#define STATUS_BAD_CLUSTERS                             0xC0000805L
#define STATUS_VOLUME_DIRTY                             0xC0000806L
#define STATUS_FILE_CHECKED_OUT                         0xC0000901L
#define STATUS_CHECKOUT_REQUIRED                        0xC0000902L
#define STATUS_BAD_FILE_TYPE                            0xC0000903L
#define STATUS_FILE_TOO_LARGE                           0xC0000904L
#define STATUS_FORMS_AUTH_REQUIRED                      0xC0000905L
#define STATUS_VIRUS_INFECTED                           0xC0000906L
#define STATUS_VIRUS_DELETED                            0xC0000907L
#define STATUS_BAD_MCFG_TABLE                           0xC0000908L
#define STATUS_CANNOT_BREAK_OPLOCK                      0xC0000909L
#define STATUS_WOW_ASSERTION                            0xC0009898L
#define STATUS_INVALID_SIGNATURE                        0xC000A000L
#define STATUS_HMAC_NOT_SUPPORTED                       0xC000A001L
#define STATUS_AUTH_TAG_MISMATCH                        0xC000A002L
#define STATUS_IPSEC_QUEUE_OVERFLOW                     0xC000A010L
#define STATUS_ND_QUEUE_OVERFLOW                        0xC000A011L
#define STATUS_HOPLIMIT_EXCEEDED                        0xC000A012L
#define STATUS_PROTOCOL_NOT_SUPPORTED                   0xC000A013L
#define STATUS_FASTPATH_REJECTED                        0xC000A014L
#define STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED   0xC000A080L
#define STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR   0xC000A081L
#define STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR   0xC000A082L
#define STATUS_XML_PARSE_ERROR                          0xC000A083L
#define STATUS_XMLDSIG_ERROR                            0xC000A084L
#define STATUS_WRONG_COMPARTMENT                        0xC000A085L
#define STATUS_AUTHIP_FAILURE                           0xC000A086L
#define STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS    0xC000A087L
#define STATUS_DS_OID_NOT_FOUND                         0xC000A088L
#define STATUS_HASH_NOT_SUPPORTED                       0xC000A100L
#define STATUS_HASH_NOT_PRESENT                         0xC000A101L
#define DBG_NO_STATE_CHANGE                             0xC0010001L
#define DBG_APP_NOT_IDLE                                0xC0010002L
#define RPC_NT_INVALID_STRING_BINDING                   0xC0020001L
#define RPC_NT_WRONG_KIND_OF_BINDING                    0xC0020002L
#define RPC_NT_INVALID_BINDING                          0xC0020003L
#define RPC_NT_PROTSEQ_NOT_SUPPORTED                    0xC0020004L
#define RPC_NT_INVALID_RPC_PROTSEQ                      0xC0020005L
#define RPC_NT_INVALID_STRING_UUID                      0xC0020006L
#define RPC_NT_INVALID_ENDPOINT_FORMAT                  0xC0020007L
#define RPC_NT_INVALID_NET_ADDR                         0xC0020008L
#define RPC_NT_NO_ENDPOINT_FOUND                        0xC0020009L
#define RPC_NT_INVALID_TIMEOUT                          0xC002000AL
#define RPC_NT_OBJECT_NOT_FOUND                         0xC002000BL
#define RPC_NT_ALREADY_REGISTERED                       0xC002000CL
#define RPC_NT_TYPE_ALREADY_REGISTERED                  0xC002000DL
#define RPC_NT_ALREADY_LISTENING                        0xC002000EL
#define RPC_NT_NO_PROTSEQS_REGISTERED                   0xC002000FL
#define RPC_NT_NOT_LISTENING                            0xC0020010L
#define RPC_NT_UNKNOWN_MGR_TYPE                         0xC0020011L
#define RPC_NT_UNKNOWN_IF                               0xC0020012L
#define RPC_NT_NO_BINDINGS                              0xC0020013L
#define RPC_NT_NO_PROTSEQS                              0xC0020014L
#define RPC_NT_CANT_CREATE_ENDPOINT                     0xC0020015L
#define RPC_NT_OUT_OF_RESOURCES                         0xC0020016L
#define RPC_NT_SERVER_UNAVAILABLE                       0xC0020017L
#define RPC_NT_SERVER_TOO_BUSY                          0xC0020018L
#define RPC_NT_INVALID_NETWORK_OPTIONS                  0xC0020019L
#define RPC_NT_NO_CALL_ACTIVE                           0xC002001AL
#define RPC_NT_CALL_FAILED                              0xC002001BL
#define RPC_NT_CALL_FAILED_DNE                          0xC002001CL
#define RPC_NT_PROTOCOL_ERROR                           0xC002001DL
#define RPC_NT_UNSUPPORTED_TRANS_SYN                    0xC002001FL
#define RPC_NT_UNSUPPORTED_TYPE                         0xC0020021L
#define RPC_NT_INVALID_TAG                              0xC0020022L
#define RPC_NT_INVALID_BOUND                            0xC0020023L
#define RPC_NT_NO_ENTRY_NAME                            0xC0020024L
#define RPC_NT_INVALID_NAME_SYNTAX                      0xC0020025L
#define RPC_NT_UNSUPPORTED_NAME_SYNTAX                  0xC0020026L
#define RPC_NT_UUID_NO_ADDRESS                          0xC0020028L
#define RPC_NT_DUPLICATE_ENDPOINT                       0xC0020029L
#define RPC_NT_UNKNOWN_AUTHN_TYPE                       0xC002002AL
#define RPC_NT_MAX_CALLS_TOO_SMALL                      0xC002002BL
#define RPC_NT_STRING_TOO_LONG                          0xC002002CL
#define RPC_NT_PROTSEQ_NOT_FOUND                        0xC002002DL
#define RPC_NT_PROCNUM_OUT_OF_RANGE                     0xC002002EL
#define RPC_NT_BINDING_HAS_NO_AUTH                      0xC002002FL
#define RPC_NT_UNKNOWN_AUTHN_SERVICE                    0xC0020030L
#define RPC_NT_UNKNOWN_AUTHN_LEVEL                      0xC0020031L
#define RPC_NT_INVALID_AUTH_IDENTITY                    0xC0020032L
#define RPC_NT_UNKNOWN_AUTHZ_SERVICE                    0xC0020033L
#define EPT_NT_INVALID_ENTRY                            0xC0020034L
#define EPT_NT_CANT_PERFORM_OP                          0xC0020035L
#define EPT_NT_NOT_REGISTERED                           0xC0020036L
#define RPC_NT_NOTHING_TO_EXPORT                        0xC0020037L
#define RPC_NT_INCOMPLETE_NAME                          0xC0020038L
#define RPC_NT_INVALID_VERS_OPTION                      0xC0020039L
#define RPC_NT_NO_MORE_MEMBERS                          0xC002003AL
#define RPC_NT_NOT_ALL_OBJS_UNEXPORTED                  0xC002003BL
#define RPC_NT_INTERFACE_NOT_FOUND                      0xC002003CL
#define RPC_NT_ENTRY_ALREADY_EXISTS                     0xC002003DL
#define RPC_NT_ENTRY_NOT_FOUND                          0xC002003EL
#define RPC_NT_NAME_SERVICE_UNAVAILABLE                 0xC002003FL
#define RPC_NT_INVALID_NAF_ID                           0xC0020040L
#define RPC_NT_CANNOT_SUPPORT                           0xC0020041L
#define RPC_NT_NO_CONTEXT_AVAILABLE                     0xC0020042L
#define RPC_NT_INTERNAL_ERROR                           0xC0020043L
#define RPC_NT_ZERO_DIVIDE                              0xC0020044L
#define RPC_NT_ADDRESS_ERROR                            0xC0020045L
#define RPC_NT_FP_DIV_ZERO                              0xC0020046L
#define RPC_NT_FP_UNDERFLOW                             0xC0020047L
#define RPC_NT_FP_OVERFLOW                              0xC0020048L
#define RPC_NT_NO_MORE_ENTRIES                          0xC0030001L
#define RPC_NT_SS_CHAR_TRANS_OPEN_FAIL                  0xC0030002L
#define RPC_NT_SS_CHAR_TRANS_SHORT_FILE                 0xC0030003L
#define RPC_NT_SS_IN_NULL_CONTEXT                       0xC0030004L
#define RPC_NT_SS_CONTEXT_MISMATCH                      0xC0030005L
#define RPC_NT_SS_CONTEXT_DAMAGED                       0xC0030006L
#define RPC_NT_SS_HANDLES_MISMATCH                      0xC0030007L
#define RPC_NT_SS_CANNOT_GET_CALL_HANDLE                0xC0030008L
#define RPC_NT_NULL_REF_POINTER                         0xC0030009L
#define RPC_NT_ENUM_VALUE_OUT_OF_RANGE                  0xC003000AL
#define RPC_NT_BYTE_COUNT_TOO_SMALL                     0xC003000BL
#define RPC_NT_BAD_STUB_DATA                            0xC003000CL
#define RPC_NT_CALL_IN_PROGRESS                         0xC0020049L
#define RPC_NT_NO_MORE_BINDINGS                         0xC002004AL
#define RPC_NT_GROUP_MEMBER_NOT_FOUND                   0xC002004BL
#define EPT_NT_CANT_CREATE                              0xC002004CL
#define RPC_NT_INVALID_OBJECT                           0xC002004DL
#define RPC_NT_NO_INTERFACES                            0xC002004FL
#define RPC_NT_CALL_CANCELLED                           0xC0020050L
#define RPC_NT_BINDING_INCOMPLETE                       0xC0020051L
#define RPC_NT_COMM_FAILURE                             0xC0020052L
#define RPC_NT_UNSUPPORTED_AUTHN_LEVEL                  0xC0020053L
#define RPC_NT_NO_PRINC_NAME                            0xC0020054L
#define RPC_NT_NOT_RPC_ERROR                            0xC0020055L
#define RPC_NT_UUID_LOCAL_ONLY                          0xC0020056L
#define RPC_NT_SEC_PKG_ERROR                            0xC0020057L
#define RPC_NT_NOT_CANCELLED                            0xC0020058L
#define RPC_NT_INVALID_ES_ACTION                        0xC0020059L
#define RPC_NT_WRONG_ES_VERSION                         0xC002005AL
#define RPC_NT_WRONG_STUB_VERSION                       0xC002005BL
#define RPC_NT_INVALID_PIPE_OBJECT                      0xC002005CL
#define RPC_NT_INVALID_PIPE_OPERATION                   0xC002005DL
#define RPC_NT_WRONG_PIPE_VERSION                       0xC002005EL
#define RPC_NT_PIPE_CLOSED                              0xC002005FL
#define RPC_NT_PIPE_DISCIPLINE_ERROR                    0xC0020060L
#define RPC_NT_PIPE_EMPTY                               0xC0020061L
#define RPC_NT_INVALID_ASYNC_HANDLE                     0xC0020062L
#define RPC_NT_INVALID_ASYNC_CALL                       0xC0020063L
#define RPC_NT_PROXY_ACCESS_DENIED                      0xC0020064L
#define RPC_NT_COOKIE_AUTH_FAILED                       0xC0020065L
#define RPC_NT_SEND_INCOMPLETE                          0x400200AFL
#define STATUS_ACPI_INVALID_OPCODE                      0xC0140001L
#define STATUS_ACPI_STACK_OVERFLOW                      0xC0140002L
#define STATUS_ACPI_ASSERT_FAILED                       0xC0140003L
#define STATUS_ACPI_INVALID_INDEX                       0xC0140004L
#define STATUS_ACPI_INVALID_ARGUMENT                    0xC0140005L
#define STATUS_ACPI_FATAL                               0xC0140006L
#define STATUS_ACPI_INVALID_SUPERNAME                   0xC0140007L
#define STATUS_ACPI_INVALID_ARGTYPE                     0xC0140008L
#define STATUS_ACPI_INVALID_OBJTYPE                     0xC0140009L
#define STATUS_ACPI_INVALID_TARGETTYPE                  0xC014000AL
#define STATUS_ACPI_INCORRECT_ARGUMENT_COUNT            0xC014000BL
#define STATUS_ACPI_ADDRESS_NOT_MAPPED                  0xC014000CL
#define STATUS_ACPI_INVALID_EVENTTYPE                   0xC014000DL
#define STATUS_ACPI_HANDLER_COLLISION                   0xC014000EL
#define STATUS_ACPI_INVALID_DATA                        0xC014000FL
#define STATUS_ACPI_INVALID_REGION                      0xC0140010L
#define STATUS_ACPI_INVALID_ACCESS_SIZE                 0xC0140011L
#define STATUS_ACPI_ACQUIRE_GLOBAL_LOCK                 0xC0140012L
#define STATUS_ACPI_ALREADY_INITIALIZED                 0xC0140013L
#define STATUS_ACPI_NOT_INITIALIZED                     0xC0140014L
#define STATUS_ACPI_INVALID_MUTEX_LEVEL                 0xC0140015L
#define STATUS_ACPI_MUTEX_NOT_OWNED                     0xC0140016L
#define STATUS_ACPI_MUTEX_NOT_OWNER                     0xC0140017L
#define STATUS_ACPI_RS_ACCESS                           0xC0140018L
#define STATUS_ACPI_INVALID_TABLE                       0xC0140019L
#define STATUS_ACPI_REG_HANDLER_FAILED                  0xC0140020L
#define STATUS_ACPI_POWER_REQUEST_FAILED                0xC0140021L
#define STATUS_CTX_WINSTATION_NAME_INVALID              0xC00A0001L
#define STATUS_CTX_INVALID_PD                           0xC00A0002L
#define STATUS_CTX_PD_NOT_FOUND                         0xC00A0003L
#define STATUS_CTX_CDM_CONNECT                          0xC00A0004L
#define STATUS_CTX_CDM_DISCONNECT                       0xC00A0005L
#define STATUS_CTX_CLOSE_PENDING                        0xC00A0006L
#define STATUS_CTX_NO_OUTBUF                            0xC00A0007L
#define STATUS_CTX_MODEM_INF_NOT_FOUND                  0xC00A0008L
#define STATUS_CTX_INVALID_MODEMNAME                    0xC00A0009L
#define STATUS_CTX_RESPONSE_ERROR                       0xC00A000AL
#define STATUS_CTX_MODEM_RESPONSE_TIMEOUT               0xC00A000BL
#define STATUS_CTX_MODEM_RESPONSE_NO_CARRIER            0xC00A000CL
#define STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE           0xC00A000DL
#define STATUS_CTX_MODEM_RESPONSE_BUSY                  0xC00A000EL
#define STATUS_CTX_MODEM_RESPONSE_VOICE                 0xC00A000FL
#define STATUS_CTX_TD_ERROR                             0xC00A0010L
#define STATUS_CTX_LICENSE_CLIENT_INVALID               0xC00A0012L
#define STATUS_CTX_LICENSE_NOT_AVAILABLE                0xC00A0013L
#define STATUS_CTX_LICENSE_EXPIRED                      0xC00A0014L
#define STATUS_CTX_WINSTATION_NOT_FOUND                 0xC00A0015L
#define STATUS_CTX_WINSTATION_NAME_COLLISION            0xC00A0016L
#define STATUS_CTX_WINSTATION_BUSY                      0xC00A0017L
#define STATUS_CTX_BAD_VIDEO_MODE                       0xC00A0018L
#define STATUS_CTX_GRAPHICS_INVALID                     0xC00A0022L
#define STATUS_CTX_NOT_CONSOLE                          0xC00A0024L
#define STATUS_CTX_CLIENT_QUERY_TIMEOUT                 0xC00A0026L
#define STATUS_CTX_CONSOLE_DISCONNECT                   0xC00A0027L
#define STATUS_CTX_CONSOLE_CONNECT                      0xC00A0028L
#define STATUS_CTX_SHADOW_DENIED                        0xC00A002AL
#define STATUS_CTX_WINSTATION_ACCESS_DENIED             0xC00A002BL
#define STATUS_CTX_INVALID_WD                           0xC00A002EL
#define STATUS_CTX_WD_NOT_FOUND                         0xC00A002FL
#define STATUS_CTX_SHADOW_INVALID                       0xC00A0030L
#define STATUS_CTX_SHADOW_DISABLED                      0xC00A0031L
#define STATUS_RDP_PROTOCOL_ERROR                       0xC00A0032L
#define STATUS_CTX_CLIENT_LICENSE_NOT_SET               0xC00A0033L
#define STATUS_CTX_CLIENT_LICENSE_IN_USE                0xC00A0034L
#define STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE          0xC00A0035L
#define STATUS_CTX_SHADOW_NOT_RUNNING                   0xC00A0036L
#define STATUS_CTX_LOGON_DISABLED                       0xC00A0037L
#define STATUS_CTX_SECURITY_LAYER_ERROR                 0xC00A0038L
#define STATUS_TS_INCOMPATIBLE_SESSIONS                 0xC00A0039L
#define STATUS_TS_VIDEO_SUBSYSTEM_ERROR                 0xC00A003AL
#define STATUS_PNP_BAD_MPS_TABLE                        0xC0040035L
#define STATUS_PNP_TRANSLATION_FAILED                   0xC0040036L
#define STATUS_PNP_IRQ_TRANSLATION_FAILED               0xC0040037L
#define STATUS_PNP_INVALID_ID                           0xC0040038L
#define STATUS_IO_REISSUE_AS_CACHED                     0xC0040039L
#define STATUS_MUI_FILE_NOT_FOUND                       0xC00B0001L
#define STATUS_MUI_INVALID_FILE                         0xC00B0002L
#define STATUS_MUI_INVALID_RC_CONFIG                    0xC00B0003L
#define STATUS_MUI_INVALID_LOCALE_NAME                  0xC00B0004L
#define STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME        0xC00B0005L
#define STATUS_MUI_FILE_NOT_LOADED                      0xC00B0006L
#define STATUS_RESOURCE_ENUM_USER_STOP                  0xC00B0007L
#define STATUS_FLT_NO_HANDLER_DEFINED                   0xC01C0001L
#define STATUS_FLT_CONTEXT_ALREADY_DEFINED              0xC01C0002L
#define STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST         0xC01C0003L
#define STATUS_FLT_DISALLOW_FAST_IO                     0xC01C0004L
#define STATUS_FLT_INVALID_NAME_REQUEST                 0xC01C0005L
#define STATUS_FLT_NOT_SAFE_TO_POST_OPERATION           0xC01C0006L
#define STATUS_FLT_NOT_INITIALIZED                      0xC01C0007L
#define STATUS_FLT_FILTER_NOT_READY                     0xC01C0008L
#define STATUS_FLT_POST_OPERATION_CLEANUP               0xC01C0009L
#define STATUS_FLT_INTERNAL_ERROR                       0xC01C000AL
#define STATUS_FLT_DELETING_OBJECT                      0xC01C000BL
#define STATUS_FLT_MUST_BE_NONPAGED_POOL                0xC01C000CL
#define STATUS_FLT_DUPLICATE_ENTRY                      0xC01C000DL
#define STATUS_FLT_CBDQ_DISABLED                        0xC01C000EL
#define STATUS_FLT_DO_NOT_ATTACH                        0xC01C000FL
#define STATUS_FLT_DO_NOT_DETACH                        0xC01C0010L
#define STATUS_FLT_INSTANCE_ALTITUDE_COLLISION          0xC01C0011L
#define STATUS_FLT_INSTANCE_NAME_COLLISION              0xC01C0012L
#define STATUS_FLT_FILTER_NOT_FOUND                     0xC01C0013L
#define STATUS_FLT_VOLUME_NOT_FOUND                     0xC01C0014L
#define STATUS_FLT_INSTANCE_NOT_FOUND                   0xC01C0015L
#define STATUS_FLT_CONTEXT_ASSOCIATION_NOT_FOUND        0xC01C0016L
#define STATUS_FLT_INVALID_CONTEXT_REGISTRATION         0xC01C0017L
#define STATUS_FLT_NAME_CACHE_MISS                      0xC01C0018L
#define STATUS_FLT_NO_DEVICE_OBJECT                     0xC01C0019L
#define STATUS_FLT_VOLUME_ALREADY_MOUNTED               0xC01C001AL
#define STATUS_FLT_ALREADY_ENLISTED                     0xC01C001BL
#define STATUS_FLT_CONTEXT_ALREADY_LINKED               0xC01C001CL
#define STATUS_FLT_NO_WAITER_FOR_REPLY                  0xC01C0020L
#define STATUS_SXS_SECTION_NOT_FOUND                    0xC0150001L
#define STATUS_SXS_CANT_GEN_ACTCTX                      0xC0150002L
#define STATUS_SXS_INVALID_ACTCTXDATA_FORMAT            0xC0150003L
#define STATUS_SXS_ASSEMBLY_NOT_FOUND                   0xC0150004L
#define STATUS_SXS_MANIFEST_FORMAT_ERROR                0xC0150005L
#define STATUS_SXS_MANIFEST_PARSE_ERROR                 0xC0150006L
#define STATUS_SXS_ACTIVATION_CONTEXT_DISABLED          0xC0150007L
#define STATUS_SXS_KEY_NOT_FOUND                        0xC0150008L
#define STATUS_SXS_VERSION_CONFLICT                     0xC0150009L
#define STATUS_SXS_WRONG_SECTION_TYPE                   0xC015000AL
#define STATUS_SXS_THREAD_QUERIES_DISABLED              0xC015000BL
#define STATUS_SXS_ASSEMBLY_MISSING                     0xC015000CL
#define STATUS_SXS_RELEASE_ACTIVATION_CONTEXT           0x4015000DL
#define STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET          0xC015000EL
#define STATUS_SXS_EARLY_DEACTIVATION                   0xC015000FL
#define STATUS_SXS_INVALID_DEACTIVATION                 0xC0150010L
#define STATUS_SXS_MULTIPLE_DEACTIVATION                0xC0150011L
#define STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY  0xC0150012L
#define STATUS_SXS_PROCESS_TERMINATION_REQUESTED        0xC0150013L
#define STATUS_SXS_CORRUPT_ACTIVATION_STACK             0xC0150014L
#define STATUS_SXS_CORRUPTION                           0xC0150015L
#define STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE     0xC0150016L
#define STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME      0xC0150017L
#define STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE         0xC0150018L
#define STATUS_SXS_IDENTITY_PARSE_ERROR                 0xC0150019L
#define STATUS_SXS_COMPONENT_STORE_CORRUPT              0xC015001AL
#define STATUS_SXS_FILE_HASH_MISMATCH                   0xC015001BL
#define STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT    0xC015001CL
#define STATUS_SXS_IDENTITIES_DIFFERENT                 0xC015001DL
#define STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT         0xC015001EL
#define STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY            0xC015001FL
#define STATUS_ADVANCED_INSTALLER_FAILED                0xC0150020L
#define STATUS_XML_ENCODING_MISMATCH                    0xC0150021L
#define STATUS_SXS_MANIFEST_TOO_BIG                     0xC0150022L
#define STATUS_SXS_SETTING_NOT_REGISTERED               0xC0150023L
#define STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE       0xC0150024L
#define STATUS_SXS_PRIMITIVE_INSTALLER_FAILED           0xC0150025L
#define STATUS_GENERIC_COMMAND_FAILED                   0xC0150026L
#define STATUS_SXS_FILE_HASH_MISSING                    0xC0150027L
#define STATUS_CLUSTER_INVALID_NODE                     0xC0130001L
#define STATUS_CLUSTER_NODE_EXISTS                      0xC0130002L
#define STATUS_CLUSTER_JOIN_IN_PROGRESS                 0xC0130003L
#define STATUS_CLUSTER_NODE_NOT_FOUND                   0xC0130004L
#define STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND             0xC0130005L
#define STATUS_CLUSTER_NETWORK_EXISTS                   0xC0130006L
#define STATUS_CLUSTER_NETWORK_NOT_FOUND                0xC0130007L
#define STATUS_CLUSTER_NETINTERFACE_EXISTS              0xC0130008L
#define STATUS_CLUSTER_NETINTERFACE_NOT_FOUND           0xC0130009L
#define STATUS_CLUSTER_INVALID_REQUEST                  0xC013000AL
#define STATUS_CLUSTER_INVALID_NETWORK_PROVIDER         0xC013000BL
#define STATUS_CLUSTER_NODE_DOWN                        0xC013000CL
#define STATUS_CLUSTER_NODE_UNREACHABLE                 0xC013000DL
#define STATUS_CLUSTER_NODE_NOT_MEMBER                  0xC013000EL
#define STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS             0xC013000FL
#define STATUS_CLUSTER_INVALID_NETWORK                  0xC0130010L
#define STATUS_CLUSTER_NO_NET_ADAPTERS                  0xC0130011L
#define STATUS_CLUSTER_NODE_UP                          0xC0130012L
#define STATUS_CLUSTER_NODE_PAUSED                      0xC0130013L
#define STATUS_CLUSTER_NODE_NOT_PAUSED                  0xC0130014L
#define STATUS_CLUSTER_NO_SECURITY_CONTEXT              0xC0130015L
#define STATUS_CLUSTER_NETWORK_NOT_INTERNAL             0xC0130016L
#define STATUS_CLUSTER_POISONED                         0xC0130017L
#define STATUS_CLUSTER_NON_CSV_PATH                     0xC0130018L
#define STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL             0xC0130019L
#define STATUS_TRANSACTIONAL_CONFLICT                   0xC0190001L
#define STATUS_INVALID_TRANSACTION                      0xC0190002L
#define STATUS_TRANSACTION_NOT_ACTIVE                   0xC0190003L
#define STATUS_TM_INITIALIZATION_FAILED                 0xC0190004L
#define STATUS_RM_NOT_ACTIVE                            0xC0190005L
#define STATUS_RM_METADATA_CORRUPT                      0xC0190006L
#define STATUS_TRANSACTION_NOT_JOINED                   0xC0190007L
#define STATUS_DIRECTORY_NOT_RM                         0xC0190008L
#define STATUS_COULD_NOT_RESIZE_LOG                     0x80190009L
#define STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE          0xC019000AL
#define STATUS_LOG_RESIZE_INVALID_SIZE                  0xC019000BL
#define STATUS_REMOTE_FILE_VERSION_MISMATCH             0xC019000CL
#define STATUS_CRM_PROTOCOL_ALREADY_EXISTS              0xC019000FL
#define STATUS_TRANSACTION_PROPAGATION_FAILED           0xC0190010L
#define STATUS_CRM_PROTOCOL_NOT_FOUND                   0xC0190011L
#define STATUS_TRANSACTION_SUPERIOR_EXISTS              0xC0190012L
#define STATUS_TRANSACTION_REQUEST_NOT_VALID            0xC0190013L
#define STATUS_TRANSACTION_NOT_REQUESTED                0xC0190014L
#define STATUS_TRANSACTION_ALREADY_ABORTED              0xC0190015L
#define STATUS_TRANSACTION_ALREADY_COMMITTED            0xC0190016L
#define STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER      0xC0190017L
#define STATUS_CURRENT_TRANSACTION_NOT_VALID            0xC0190018L
#define STATUS_LOG_GROWTH_FAILED                        0xC0190019L
#define STATUS_OBJECT_NO_LONGER_EXISTS                  0xC0190021L
#define STATUS_STREAM_MINIVERSION_NOT_FOUND             0xC0190022L
#define STATUS_STREAM_MINIVERSION_NOT_VALID             0xC0190023L
#define STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION  0xC0190024L
#define STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT 0xC0190025L
#define STATUS_CANT_CREATE_MODE_STREAM_MINIVERSIONS     0xC0190026L
#define STATUS_HANDLE_NO_LONGER_VALID                   0xC0190028L
#define STATUS_NO_TXF_METADATA                          0xC0190029L
#define STATUS_LOG_CORRUPTION_DETECTED                  0xC0190030L
#define STATUS_CANT_RECOVER_WITH_HANDLE_OPEN            0x80190031L
#define STATUS_RM_DISCONNECTED                          0xC0190032L
#define STATUS_ENLISTMENT_NOT_SUPERIOR                  0xC0190033L
#define STATUS_RECOVERY_NOT_NEEDED                      0xC0190034L
#define STATUS_RM_ALREADY_STARTED                       0xC0190035L
#define STATUS_FILE_IDENTITY_NOT_PERSISTENT             0xC0190036L
#define STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY      0xC0190037L
#define STATUS_CANT_CROSS_RM_BOUNDARY                   0xC0190038L
#define STATUS_TXF_DIR_NOT_EMPTY                        0xC0190039L
#define STATUS_INDOUBT_TRANSACTIONS_EXIST               0xC019003AL
#define STATUS_TM_VOLATILE                              0xC019003BL
#define STATUS_ROLLBACK_TIMER_EXPIRED                   0xC019003CL
#define STATUS_TXF_ATTRIBUTE_CORRUPT                    0xC019003DL
#define STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION           0xC019003EL
#define STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED           0xC019003FL
#define STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE    0xC0190040L
#define STATUS_TXF_METADATA_ALREADY_PRESENT             0xC0190041L
#define STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET      0xC0190042L
#define STATUS_TRANSACTION_REQUIRED_PROMOTION           0xC0190043L
#define STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION       0xC0190044L
#define STATUS_TRANSACTIONS_NOT_FROZEN                  0xC0190045L
#define STATUS_TRANSACTION_FREEZE_IN_PROGRESS           0xC0190046L
#define STATUS_NOT_SNAPSHOT_VOLUME                      0xC0190047L
#define STATUS_NO_SAVEPOINT_WITH_OPEN_FILES             0xC0190048L
#define STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION        0xC0190049L
#define STATUS_TM_IDENTITY_MISMATCH                     0xC019004AL
#define STATUS_FLOATED_SECTION                          0xC019004BL
#define STATUS_CANNOT_ACCEPT_TRANSACTED_WORK            0xC019004CL
#define STATUS_CANNOT_ABORT_TRANSACTIONS                0xC019004DL
#define STATUS_TRANSACTION_NOT_FOUND                    0xC019004EL
#define STATUS_RESOURCEMANAGER_NOT_FOUND                0xC019004FL
#define STATUS_ENLISTMENT_NOT_FOUND                     0xC0190050L
#define STATUS_TRANSACTIONMANAGER_NOT_FOUND             0xC0190051L
#define STATUS_TRANSACTIONMANAGER_NOT_ONLINE            0xC0190052L
#define STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION   0xC0190053L
#define STATUS_TRANSACTION_NOT_ROOT                     0xC0190054L
#define STATUS_TRANSACTION_OBJECT_EXPIRED               0xC0190055L
#define STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION   0xC0190056L
#define STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED        0xC0190057L
#define STATUS_TRANSACTION_RECORD_TOO_LONG              0xC0190058L
#define STATUS_NO_LINK_TRACKING_IN_TRANSACTION          0xC0190059L
#define STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION   0xC019005AL
#define STATUS_TRANSACTION_INTEGRITY_VIOLATED           0xC019005BL
#define STATUS_TRANSACTIONMANAGER_IDENTITY_MISMATCH     0xC019005CL
#define STATUS_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT         0xC019005DL
#define STATUS_TRANSACTION_MUST_WRITETHROUGH            0xC019005EL
#define STATUS_TRANSACTION_NO_SUPERIOR                  0xC019005FL
#define STATUS_EXPIRED_HANDLE                           0xC0190060L
#define STATUS_TRANSACTION_NOT_ENLISTED                 0xC0190061L
#define STATUS_LOG_SECTOR_INVALID                       0xC01A0001L
#define STATUS_LOG_SECTOR_PARITY_INVALID                0xC01A0002L
#define STATUS_LOG_SECTOR_REMAPPED                      0xC01A0003L
#define STATUS_LOG_BLOCK_INCOMPLETE                     0xC01A0004L
#define STATUS_LOG_INVALID_RANGE                        0xC01A0005L
#define STATUS_LOG_BLOCKS_EXHAUSTED                     0xC01A0006L
#define STATUS_LOG_READ_CONTEXT_INVALID                 0xC01A0007L
#define STATUS_LOG_RESTART_INVALID                      0xC01A0008L
#define STATUS_LOG_BLOCK_VERSION                        0xC01A0009L
#define STATUS_LOG_BLOCK_INVALID                        0xC01A000AL
#define STATUS_LOG_READ_MODE_INVALID                    0xC01A000BL
#define STATUS_LOG_NO_RESTART                           0xC01A000CL
#define STATUS_LOG_METADATA_CORRUPT                     0xC01A000DL
#define STATUS_LOG_METADATA_INVALID                     0xC01A000EL
#define STATUS_LOG_METADATA_INCONSISTENT                0xC01A000FL
#define STATUS_LOG_RESERVATION_INVALID                  0xC01A0010L
#define STATUS_LOG_CANT_DELETE                          0xC01A0011L
#define STATUS_LOG_CONTAINER_LIMIT_EXCEEDED             0xC01A0012L
#define STATUS_LOG_START_OF_LOG                         0xC01A0013L
#define STATUS_LOG_POLICY_ALREADY_INSTALLED             0xC01A0014L
#define STATUS_LOG_POLICY_NOT_INSTALLED                 0xC01A0015L
#define STATUS_LOG_POLICY_INVALID                       0xC01A0016L
#define STATUS_LOG_POLICY_CONFLICT                      0xC01A0017L
#define STATUS_LOG_PINNED_ARCHIVE_TAIL                  0xC01A0018L
#define STATUS_LOG_RECORD_NONEXISTENT                   0xC01A0019L
#define STATUS_LOG_RECORDS_RESERVED_INVALID             0xC01A001AL
#define STATUS_LOG_SPACE_RESERVED_INVALID               0xC01A001BL
#define STATUS_LOG_TAIL_INVALID                         0xC01A001CL
#define STATUS_LOG_FULL                                 0xC01A001DL
#define STATUS_LOG_MULTIPLEXED                          0xC01A001EL
#define STATUS_LOG_DEDICATED                            0xC01A001FL
#define STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS              0xC01A0020L
#define STATUS_LOG_ARCHIVE_IN_PROGRESS                  0xC01A0021L
#define STATUS_LOG_EPHEMERAL                            0xC01A0022L
#define STATUS_LOG_NOT_ENOUGH_CONTAINERS                0xC01A0023L
#define STATUS_LOG_CLIENT_ALREADY_REGISTERED            0xC01A0024L
#define STATUS_LOG_CLIENT_NOT_REGISTERED                0xC01A0025L
#define STATUS_LOG_FULL_HANDLER_IN_PROGRESS             0xC01A0026L
#define STATUS_LOG_CONTAINER_READ_FAILED                0xC01A0027L
#define STATUS_LOG_CONTAINER_WRITE_FAILED               0xC01A0028L
#define STATUS_LOG_CONTAINER_OPEN_FAILED                0xC01A0029L
#define STATUS_LOG_CONTAINER_STATE_INVALID              0xC01A002AL
#define STATUS_LOG_STATE_INVALID                        0xC01A002BL
#define STATUS_LOG_PINNED                               0xC01A002CL
#define STATUS_LOG_METADATA_FLUSH_FAILED                0xC01A002DL
#define STATUS_LOG_INCONSISTENT_SECURITY                0xC01A002EL
#define STATUS_LOG_APPENDED_FLUSH_FAILED                0xC01A002FL
#define STATUS_LOG_PINNED_RESERVATION                   0xC01A0030L
#define STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD         0xC01B00EAL
#define STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED   0x801B00EBL
#define STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST        0x401B00ECL
#define STATUS_MONITOR_NO_DESCRIPTION                   0xC01D0001L
#define STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT        0xC01D0002L
#define STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM      0xC01D0003L
#define STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK    0xC01D0004L
#define STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED    0xC01D0005L
#define STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK   0xC01D0006L
#define STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK   0xC01D0007L
#define STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA          0xC01D0008L
#define STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK    0xC01D0009L
#define STATUS_MONITOR_INVALID_MANUFACTURE_DATE         0xC01D000AL
#define STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER        0xC01E0000L
#define STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER         0xC01E0001L
#define STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER         0xC01E0002L
#define STATUS_GRAPHICS_ADAPTER_WAS_RESET               0xC01E0003L
#define STATUS_GRAPHICS_INVALID_DRIVER_MODEL            0xC01E0004L
#define STATUS_GRAPHICS_PRESENT_MODE_CHANGED            0xC01E0005L
#define STATUS_GRAPHICS_PRESENT_OCCLUDED                0xC01E0006L
#define STATUS_GRAPHICS_PRESENT_DENIED                  0xC01E0007L
#define STATUS_GRAPHICS_CANNOTCOLORCONVERT              0xC01E0008L
#define STATUS_GRAPHICS_DRIVER_MISMATCH                 0xC01E0009L
#define STATUS_GRAPHICS_PARTIAL_DATA_POPULATED          0x401E000AL
#define STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED    0xC01E000BL
#define STATUS_GRAPHICS_PRESENT_UNOCCLUDED              0xC01E000CL
#define STATUS_GRAPHICS_NO_VIDEO_MEMORY                 0xC01E0100L
#define STATUS_GRAPHICS_CANT_LOCK_MEMORY                0xC01E0101L
#define STATUS_GRAPHICS_ALLOCATION_BUSY                 0xC01E0102L
#define STATUS_GRAPHICS_TOO_MANY_REFERENCES             0xC01E0103L
#define STATUS_GRAPHICS_TRY_AGAIN_LATER                 0xC01E0104L
#define STATUS_GRAPHICS_TRY_AGAIN_NOW                   0xC01E0105L
#define STATUS_GRAPHICS_ALLOCATION_INVALID              0xC01E0106L
#define STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE    0xC01E0107L
#define STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED    0xC01E0108L
#define STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION    0xC01E0109L
#define STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE        0xC01E0110L
#define STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION   0xC01E0111L
#define STATUS_GRAPHICS_ALLOCATION_CLOSED               0xC01E0112L
#define STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE     0xC01E0113L
#define STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE       0xC01E0114L
#define STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE         0xC01E0115L
#define STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST         0xC01E0116L
#define STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE         0xC01E0200L
#define STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY          0xC01E0300L
#define STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED    0xC01E0301L
#define STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED  0xC01E0302L
#define STATUS_GRAPHICS_INVALID_VIDPN                   0xC01E0303L
#define STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE    0xC01E0304L
#define STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET    0xC01E0305L
#define STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED    0xC01E0306L
#define STATUS_GRAPHICS_MODE_NOT_PINNED                 0xC01E0307L
#define STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET     0xC01E0308L
#define STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET     0xC01E0309L
#define STATUS_GRAPHICS_INVALID_FREQUENCY               0xC01E030AL
#define STATUS_GRAPHICS_INVALID_ACTIVE_REGION           0xC01E030BL
#define STATUS_GRAPHICS_INVALID_TOTAL_REGION            0xC01E030CL
#define STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE   0xC01E0310L
#define STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE   0xC01E0311L
#define STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET  0xC01E0312L
#define STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY        0xC01E0313L
#define STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET         0xC01E0314L
#define STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET   0xC01E0315L
#define STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET   0xC01E0316L
#define STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET           0xC01E0317L
#define STATUS_GRAPHICS_TARGET_ALREADY_IN_SET           0xC01E0318L
#define STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH      0xC01E0319L
#define STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY   0xC01E031AL
#define STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET   0xC01E031BL
#define STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE  0xC01E031CL
#define STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET       0xC01E031DL
#define STATUS_GRAPHICS_NO_PREFERRED_MODE               0xC01E031EL
#define STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET   0xC01E031FL
#define STATUS_GRAPHICS_STALE_MODESET                   0xC01E0320L
#define STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET   0xC01E0321L
#define STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE     0xC01E0322L
#define STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN 0xC01E0323L
#define STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE          0xC01E0324L
#define STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION 0xC01E0325L
#define STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES 0xC01E0326L
#define STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY            0xC01E0327L
#define STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE   0xC01E0328L
#define STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET   0xC01E0329L
#define STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET    0xC01E032AL
#define STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR       0xC01E032BL
#define STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET    0xC01E032CL
#define STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET    0xC01E032DL
#define STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE 0xC01E032EL
#define STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE    0xC01E032FL
#define STATUS_GRAPHICS_RESOURCES_NOT_RELATED           0xC01E0330L
#define STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE        0xC01E0331L
#define STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE        0xC01E0332L
#define STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET       0xC01E0333L
#define STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER    0xC01E0334L
#define STATUS_GRAPHICS_NO_VIDPNMGR                     0xC01E0335L
#define STATUS_GRAPHICS_NO_ACTIVE_VIDPN                 0xC01E0336L
#define STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY            0xC01E0337L
#define STATUS_GRAPHICS_MONITOR_NOT_CONNECTED           0xC01E0338L
#define STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY          0xC01E0339L
#define STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE     0xC01E033AL
#define STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE      0xC01E033BL
#define STATUS_GRAPHICS_INVALID_STRIDE                  0xC01E033CL
#define STATUS_GRAPHICS_INVALID_PIXELFORMAT             0xC01E033DL
#define STATUS_GRAPHICS_INVALID_COLORBASIS              0xC01E033EL
#define STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE    0xC01E033FL
#define STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY          0xC01E0340L
#define STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT  0xC01E0341L
#define STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE             0xC01E0342L
#define STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN        0xC01E0343L
#define STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL 0xC01E0344L
#define STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION    0xC01E0345L
#define STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED  0xC01E0346L
#define STATUS_GRAPHICS_INVALID_GAMMA_RAMP              0xC01E0347L
#define STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED        0xC01E0348L
#define STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED     0xC01E0349L
#define STATUS_GRAPHICS_MODE_NOT_IN_MODESET             0xC01E034AL
#define STATUS_GRAPHICS_DATASET_IS_EMPTY                0xC01E034BL
#define STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET     0xC01E034CL
#define STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON    0xC01E034DL
#define STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE       0xC01E034EL
#define STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE     0xC01E034FL
#define STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS   0xC01E0350L
#define STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED 0x401E0351L
#define STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING       0xC01E0352L
#define STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED    0xC01E0353L
#define STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS    0xC01E0354L
#define STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT     0xC01E0355L
#define STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM  0xC01E0356L
#define STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN   0xC01E0357L
#define STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT   0xC01E0358L
#define STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED           0xC01E0359L
#define STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION  0xC01E035AL
#define STATUS_GRAPHICS_INVALID_CLIENT_TYPE             0xC01E035BL
#define STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET             0xC01E035CL
#define STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED   0xC01E0400L
#define STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED  0xC01E0401L
#define STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS            0xC01E042FL
#define STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER            0xC01E0430L
#define STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED         0xC01E0431L
#define STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED       0xC01E0432L
#define STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY         0xC01E0433L
#define STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED          0xC01E0434L
#define STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON       0xC01E0435L
#define STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE  0xC01E0436L
#define STATUS_GRAPHICS_LEADLINK_START_DEFERRED         0xC01E0437L
#define STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER          0xC01E0438L
#define STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY          0xC01E0439L
#define STATUS_GRAPHICS_START_DEFERRED                  0xC01E043AL
#define STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED     0xC01E043BL
#define STATUS_GRAPHICS_OPM_NOT_SUPPORTED               0xC01E0500L
#define STATUS_GRAPHICS_COPP_NOT_SUPPORTED              0xC01E0501L
#define STATUS_GRAPHICS_UAB_NOT_SUPPORTED               0xC01E0502L
#define STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS    0xC01E0503L
#define STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST  0xC01E0505L
#define STATUS_GRAPHICS_OPM_INTERNAL_ERROR              0xC01E050BL
#define STATUS_GRAPHICS_OPM_INVALID_HANDLE              0xC01E050CL
#define STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH  0xC01E050EL
#define STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED       0xC01E050FL
#define STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED        0xC01E0510L
#define STATUS_GRAPHICS_PVP_HFS_FAILED                  0xC01E0511L
#define STATUS_GRAPHICS_OPM_INVALID_SRM                 0xC01E0512L
#define STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP    0xC01E0513L
#define STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP 0xC01E0514L
#define STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA   0xC01E0515L
#define STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET          0xC01E0516L
#define STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH         0xC01E0517L
#define STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE    0xC01E0518L
#define STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS   0xC01E051AL
#define STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS   0xC01E051CL
#define STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST 0xC01E051DL
#define STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR       0xC01E051EL
#define STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS    0xC01E051FL
#define STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED     0xC01E0520L
#define STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST   0xC01E0521L
#define STATUS_GRAPHICS_I2C_NOT_SUPPORTED               0xC01E0580L
#define STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST       0xC01E0581L
#define STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA     0xC01E0582L
#define STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA        0xC01E0583L
#define STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED         0xC01E0584L
#define STATUS_GRAPHICS_DDCCI_INVALID_DATA              0xC01E0585L
#define STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE   0xC01E0586L
#define STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING   0xC01E0587L
#define STATUS_GRAPHICS_MCA_INTERNAL_ERROR              0xC01E0588L
#define STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND   0xC01E0589L
#define STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH    0xC01E058AL
#define STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM  0xC01E058BL
#define STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE 0xC01E058CL
#define STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS        0xC01E058DL
#define STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED  0xC01E05E0L
#define STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME   0xC01E05E1L
#define STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP  0xC01E05E2L
#define STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED 0xC01E05E3L
#define STATUS_GRAPHICS_INVALID_POINTER                 0xC01E05E4L
#define STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE    0xC01E05E5L
#define STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL       0xC01E05E6L
#define STATUS_GRAPHICS_INTERNAL_ERROR                  0xC01E05E7L
#define STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS 0xC01E05E8L
#define STATUS_FVE_LOCKED_VOLUME                        0xC0210000L
#define STATUS_FVE_NOT_ENCRYPTED                        0xC0210001L
#define STATUS_FVE_BAD_INFORMATION                      0xC0210002L
#define STATUS_FVE_TOO_SMALL                            0xC0210003L
#define STATUS_FVE_FAILED_WRONG_FS                      0xC0210004L
#define STATUS_FVE_BAD_PARTITION_SIZE                   0xC0210005L
#define STATUS_FVE_FS_NOT_EXTENDED                      0xC0210006L
#define STATUS_FVE_FS_MOUNTED                           0xC0210007L
#define STATUS_FVE_NO_LICENSE                           0xC0210008L
#define STATUS_FVE_ACTION_NOT_ALLOWED                   0xC0210009L
#define STATUS_FVE_BAD_DATA                             0xC021000AL
#define STATUS_FVE_VOLUME_NOT_BOUND                     0xC021000BL
#define STATUS_FVE_NOT_DATA_VOLUME                      0xC021000CL
#define STATUS_FVE_CONV_READ_ERROR                      0xC021000DL
#define STATUS_FVE_CONV_WRITE_ERROR                     0xC021000EL
#define STATUS_FVE_OVERLAPPED_UPDATE                    0xC021000FL
#define STATUS_FVE_FAILED_SECTOR_SIZE                   0xC0210010L
#define STATUS_FVE_FAILED_AUTHENTICATION                0xC0210011L
#define STATUS_FVE_NOT_OS_VOLUME                        0xC0210012L
#define STATUS_FVE_KEYFILE_NOT_FOUND                    0xC0210013L
#define STATUS_FVE_KEYFILE_INVALID                      0xC0210014L
#define STATUS_FVE_KEYFILE_NO_VMK                       0xC0210015L
#define STATUS_FVE_TPM_DISABLED                         0xC0210016L
#define STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO                0xC0210017L
#define STATUS_FVE_TPM_INVALID_PCR                      0xC0210018L
#define STATUS_FVE_TPM_NO_VMK                           0xC0210019L
#define STATUS_FVE_PIN_INVALID                          0xC021001AL
#define STATUS_FVE_AUTH_INVALID_APPLICATION             0xC021001BL
#define STATUS_FVE_AUTH_INVALID_CONFIG                  0xC021001CL
#define STATUS_FVE_DEBUGGER_ENABLED                     0xC021001DL
#define STATUS_FVE_DRY_RUN_FAILED                       0xC021001EL
#define STATUS_FVE_BAD_METADATA_POINTER                 0xC021001FL
#define STATUS_FVE_OLD_METADATA_COPY                    0xC0210020L
#define STATUS_FVE_REBOOT_REQUIRED                      0xC0210021L
#define STATUS_FVE_RAW_ACCESS                           0xC0210022L
#define STATUS_FVE_RAW_BLOCKED                          0xC0210023L
#define STATUS_FVE_NO_AUTOUNLOCK_MASTER_KEY             0xC0210024L
#define STATUS_FVE_MOR_FAILED                           0xC0210025L
#define STATUS_FVE_NO_FEATURE_LICENSE                   0xC0210026L
#define STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED  0xC0210027L
#define STATUS_FVE_CONV_RECOVERY_FAILED                 0xC0210028L
#define STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG            0xC0210029L
#define STATUS_FVE_INVALID_DATUM_TYPE                   0xC021002AL
#define STATUS_FVE_VOLUME_TOO_SMALL                     0xC0210030L
#define STATUS_FVE_ENH_PIN_INVALID                      0xC0210031L
#define STATUS_FWP_CALLOUT_NOT_FOUND                    0xC0220001L
#define STATUS_FWP_CONDITION_NOT_FOUND                  0xC0220002L
#define STATUS_FWP_FILTER_NOT_FOUND                     0xC0220003L
#define STATUS_FWP_LAYER_NOT_FOUND                      0xC0220004L
#define STATUS_FWP_PROVIDER_NOT_FOUND                   0xC0220005L
#define STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND           0xC0220006L
#define STATUS_FWP_SUBLAYER_NOT_FOUND                   0xC0220007L
#define STATUS_FWP_NOT_FOUND                            0xC0220008L
#define STATUS_FWP_ALREADY_EXISTS                       0xC0220009L
#define STATUS_FWP_IN_USE                               0xC022000AL
#define STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS          0xC022000BL
#define STATUS_FWP_WRONG_SESSION                        0xC022000CL
#define STATUS_FWP_NO_TXN_IN_PROGRESS                   0xC022000DL
#define STATUS_FWP_TXN_IN_PROGRESS                      0xC022000EL
#define STATUS_FWP_TXN_ABORTED                          0xC022000FL
#define STATUS_FWP_SESSION_ABORTED                      0xC0220010L
#define STATUS_FWP_INCOMPATIBLE_TXN                     0xC0220011L
#define STATUS_FWP_TIMEOUT                              0xC0220012L
#define STATUS_FWP_NET_EVENTS_DISABLED                  0xC0220013L
#define STATUS_FWP_INCOMPATIBLE_LAYER                   0xC0220014L
#define STATUS_FWP_KM_CLIENTS_ONLY                      0xC0220015L
#define STATUS_FWP_LIFETIME_MISMATCH                    0xC0220016L
#define STATUS_FWP_BUILTIN_OBJECT                       0xC0220017L
#define STATUS_FWP_TOO_MANY_CALLOUTS                    0xC0220018L
#define STATUS_FWP_NOTIFICATION_DROPPED                 0xC0220019L
#define STATUS_FWP_TRAFFIC_MISMATCH                     0xC022001AL
#define STATUS_FWP_INCOMPATIBLE_SA_STATE                0xC022001BL
#define STATUS_FWP_NULL_POINTER                         0xC022001CL
#define STATUS_FWP_INVALID_ENUMERATOR                   0xC022001DL
#define STATUS_FWP_INVALID_FLAGS                        0xC022001EL
#define STATUS_FWP_INVALID_NET_MASK                     0xC022001FL
#define STATUS_FWP_INVALID_RANGE                        0xC0220020L
#define STATUS_FWP_INVALID_INTERVAL                     0xC0220021L
#define STATUS_FWP_ZERO_LENGTH_ARRAY                    0xC0220022L
#define STATUS_FWP_NULL_DISPLAY_NAME                    0xC0220023L
#define STATUS_FWP_INVALID_ACTION_TYPE                  0xC0220024L
#define STATUS_FWP_INVALID_WEIGHT                       0xC0220025L
#define STATUS_FWP_MATCH_TYPE_MISMATCH                  0xC0220026L
#define STATUS_FWP_TYPE_MISMATCH                        0xC0220027L
#define STATUS_FWP_OUT_OF_BOUNDS                        0xC0220028L
#define STATUS_FWP_RESERVED                             0xC0220029L
#define STATUS_FWP_DUPLICATE_CONDITION                  0xC022002AL
#define STATUS_FWP_DUPLICATE_KEYMOD                     0xC022002BL
#define STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER       0xC022002CL
#define STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER    0xC022002DL
#define STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER      0xC022002EL
#define STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT    0xC022002FL
#define STATUS_FWP_INCOMPATIBLE_AUTH_METHOD             0xC0220030L
#define STATUS_FWP_INCOMPATIBLE_DH_GROUP                0xC0220031L
#define STATUS_FWP_EM_NOT_SUPPORTED                     0xC0220032L
#define STATUS_FWP_NEVER_MATCH                          0xC0220033L
#define STATUS_FWP_PROVIDER_CONTEXT_MISMATCH            0xC0220034L
#define STATUS_FWP_INVALID_PARAMETER                    0xC0220035L
#define STATUS_FWP_TOO_MANY_SUBLAYERS                   0xC0220036L
#define STATUS_FWP_CALLOUT_NOTIFICATION_FAILED          0xC0220037L
#define STATUS_FWP_INVALID_AUTH_TRANSFORM               0xC0220038L
#define STATUS_FWP_INVALID_CIPHER_TRANSFORM             0xC0220039L
#define STATUS_FWP_INCOMPATIBLE_CIPHER_TRANSFORM        0xC022003AL
#define STATUS_FWP_INVALID_TRANSFORM_COMBINATION        0xC022003BL
#define STATUS_FWP_DUPLICATE_AUTH_METHOD                0xC022003CL
#define STATUS_FWP_TCPIP_NOT_READY                      0xC0220100L
#define STATUS_FWP_INJECT_HANDLE_CLOSING                0xC0220101L
#define STATUS_FWP_INJECT_HANDLE_STALE                  0xC0220102L
#define STATUS_FWP_CANNOT_PEND                          0xC0220103L
#define STATUS_FWP_DROP_NOICMP                          0xC0220104L
#define STATUS_NDIS_CLOSING                             0xC0230002L
#define STATUS_NDIS_BAD_VERSION                         0xC0230004L
#define STATUS_NDIS_BAD_CHARACTERISTICS                 0xC0230005L
#define STATUS_NDIS_ADAPTER_NOT_FOUND                   0xC0230006L
#define STATUS_NDIS_OPEN_FAILED                         0xC0230007L
#define STATUS_NDIS_DEVICE_FAILED                       0xC0230008L
#define STATUS_NDIS_MULTICAST_FULL                      0xC0230009L
#define STATUS_NDIS_MULTICAST_EXISTS                    0xC023000AL
#define STATUS_NDIS_MULTICAST_NOT_FOUND                 0xC023000BL
#define STATUS_NDIS_REQUEST_ABORTED                     0xC023000CL
#define STATUS_NDIS_RESET_IN_PROGRESS                   0xC023000DL
#define STATUS_NDIS_NOT_SUPPORTED                       0xC02300BBL
#define STATUS_NDIS_INVALID_PACKET                      0xC023000FL
#define STATUS_NDIS_ADAPTER_NOT_READY                   0xC0230011L
#define STATUS_NDIS_INVALID_LENGTH                      0xC0230014L
#define STATUS_NDIS_INVALID_DATA                        0xC0230015L
#define STATUS_NDIS_BUFFER_TOO_SHORT                    0xC0230016L
#define STATUS_NDIS_INVALID_OID                         0xC0230017L
#define STATUS_NDIS_ADAPTER_REMOVED                     0xC0230018L
#define STATUS_NDIS_UNSUPPORTED_MEDIA                   0xC0230019L
#define STATUS_NDIS_GROUP_ADDRESS_IN_USE                0xC023001AL
#define STATUS_NDIS_FILE_NOT_FOUND                      0xC023001BL
#define STATUS_NDIS_ERROR_READING_FILE                  0xC023001CL
#define STATUS_NDIS_ALREADY_MAPPED                      0xC023001DL
#define STATUS_NDIS_RESOURCE_CONFLICT                   0xC023001EL
#define STATUS_NDIS_MEDIA_DISCONNECTED                  0xC023001FL
#define STATUS_NDIS_INVALID_ADDRESS                     0xC0230022L
#define STATUS_NDIS_INVALID_DEVICE_REQUEST              0xC0230010L
#define STATUS_NDIS_PAUSED                              0xC023002AL
#define STATUS_NDIS_INTERFACE_NOT_FOUND                 0xC023002BL
#define STATUS_NDIS_UNSUPPORTED_REVISION                0xC023002CL
#define STATUS_NDIS_INVALID_PORT                        0xC023002DL
#define STATUS_NDIS_INVALID_PORT_STATE                  0xC023002EL
#define STATUS_NDIS_LOW_POWER_STATE                     0xC023002FL
#define STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED           0xC0232000L
#define STATUS_NDIS_DOT11_MEDIA_IN_USE                  0xC0232001L
#define STATUS_NDIS_DOT11_POWER_STATE_INVALID           0xC0232002L
#define STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL            0xC0232003L
#define STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL       0xC0232004L
#define STATUS_NDIS_INDICATION_REQUIRED                 0x40230001L
#define STATUS_NDIS_OFFLOAD_POLICY                      0xC023100FL
#define STATUS_NDIS_OFFLOAD_CONNECTION_REFUSED          0xC0231012L
#define STATUS_NDIS_OFFLOAD_PATH_REJECTED               0xC0231013L
#define STATUS_HV_INVALID_HYPERCALL_CODE                0xC0350002L
#define STATUS_HV_INVALID_HYPERCALL_INPUT               0xC0350003L
#define STATUS_HV_INVALID_ARGUMENT                      0xC0350004L
#define STATUS_HV_INVALID_PARAMETER                     0xC0350005L
#define STATUS_HV_ACCESS_DENIED                         0xC0350006L
#define STATUS_HV_INVALID_PARTITION_STATE               0xC0350007L
#define STATUS_HV_OPERATION_DENIED                      0xC0350008L
#define STATUS_HV_UNKNOWN_PROPERTY                      0xC0350009L
#define STATUS_HV_PROPERTY_VALUE_OUT_OF_RANGE           0xC035000AL
#define STATUS_HV_INSUFFICIENT_MEMORY                   0xC035000BL
#define STATUS_HV_PARTITION_TOO_DEEP                    0xC035000CL
#define STATUS_HV_INVALID_PARTITION_ID                  0xC035000DL
#define STATUS_HV_INVALID_VP_INDEX                      0xC035000EL
#define STATUS_HV_INVALID_PORT_ID                       0xC0350011L
#define STATUS_HV_INVALID_CONNECTION_ID                 0xC0350012L
#define STATUS_HV_INSUFFICIENT_BUFFERS                  0xC0350013L
#define STATUS_HV_NOT_ACKNOWLEDGED                      0xC0350014L
#define STATUS_HV_ACKNOWLEDGED                          0xC0350016L
#define STATUS_HV_INVALID_SAVE_RESTORE_STATE            0xC0350017L
#define STATUS_HV_INVALID_SYNIC_STATE                   0xC0350018L
#define STATUS_HV_OBJECT_IN_USE                         0xC0350019L
#define STATUS_HV_INVALID_PROXIMITY_DOMAIN_INFO         0xC035001AL
#define STATUS_HV_NO_DATA                               0xC035001BL
#define STATUS_HV_INACTIVE                              0xC035001CL
#define STATUS_HV_NO_RESOURCES                          0xC035001DL
#define STATUS_HV_FEATURE_UNAVAILABLE                   0xC035001EL
#define STATUS_HV_NOT_PRESENT                           0xC0351000L
#define STATUS_VID_DUPLICATE_HANDLER                    0xC0370001L
#define STATUS_VID_TOO_MANY_HANDLERS                    0xC0370002L
#define STATUS_VID_QUEUE_FULL                           0xC0370003L
#define STATUS_VID_HANDLER_NOT_PRESENT                  0xC0370004L
#define STATUS_VID_INVALID_OBJECT_NAME                  0xC0370005L
#define STATUS_VID_PARTITION_NAME_TOO_LONG              0xC0370006L
#define STATUS_VID_MESSAGE_QUEUE_NAME_TOO_LONG          0xC0370007L
#define STATUS_VID_PARTITION_ALREADY_EXISTS             0xC0370008L
#define STATUS_VID_PARTITION_DOES_NOT_EXIST             0xC0370009L
#define STATUS_VID_PARTITION_NAME_NOT_FOUND             0xC037000AL
#define STATUS_VID_MESSAGE_QUEUE_ALREADY_EXISTS         0xC037000BL
#define STATUS_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT         0xC037000CL
#define STATUS_VID_MB_STILL_REFERENCED                  0xC037000DL
#define STATUS_VID_CHILD_GPA_PAGE_SET_CORRUPTED         0xC037000EL
#define STATUS_VID_INVALID_NUMA_SETTINGS                0xC037000FL
#define STATUS_VID_INVALID_NUMA_NODE_INDEX              0xC0370010L
#define STATUS_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED    0xC0370011L
#define STATUS_VID_INVALID_MEMORY_BLOCK_HANDLE          0xC0370012L
#define STATUS_VID_PAGE_RANGE_OVERFLOW                  0xC0370013L
#define STATUS_VID_INVALID_MESSAGE_QUEUE_HANDLE         0xC0370014L
#define STATUS_VID_INVALID_GPA_RANGE_HANDLE             0xC0370015L
#define STATUS_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE   0xC0370016L
#define STATUS_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED     0xC0370017L
#define STATUS_VID_INVALID_PPM_HANDLE                   0xC0370018L
#define STATUS_VID_MBPS_ARE_LOCKED                      0xC0370019L
#define STATUS_VID_MESSAGE_QUEUE_CLOSED                 0xC037001AL
#define STATUS_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED     0xC037001BL
#define STATUS_VID_STOP_PENDING                         0xC037001CL
#define STATUS_VID_INVALID_PROCESSOR_STATE              0xC037001DL
#define STATUS_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT      0xC037001EL
#define STATUS_VID_KM_INTERFACE_ALREADY_INITIALIZED     0xC037001FL
#define STATUS_VID_MB_PROPERTY_ALREADY_SET_RESET        0xC0370020L
#define STATUS_VID_MMIO_RANGE_DESTROYED                 0xC0370021L
#define STATUS_VID_INVALID_CHILD_GPA_PAGE_SET           0xC0370022L
#define STATUS_VID_RESERVE_PAGE_SET_IS_BEING_USED       0xC0370023L
#define STATUS_VID_RESERVE_PAGE_SET_TOO_SMALL           0xC0370024L
#define STATUS_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE   0xC0370025L
#define STATUS_VID_MBP_COUNT_EXCEEDED_LIMIT             0xC0370026L
#define STATUS_VID_SAVED_STATE_CORRUPT                  0xC0370027L
#define STATUS_VID_SAVED_STATE_UNRECOGNIZED_ITEM        0xC0370028L
#define STATUS_VID_SAVED_STATE_INCOMPATIBLE             0xC0370029L
#define STATUS_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED    0x80370001L
#define STATUS_IPSEC_BAD_SPI                            0xC0360001L
#define STATUS_IPSEC_SA_LIFETIME_EXPIRED                0xC0360002L
#define STATUS_IPSEC_WRONG_SA                           0xC0360003L
#define STATUS_IPSEC_REPLAY_CHECK_FAILED                0xC0360004L
#define STATUS_IPSEC_INVALID_PACKET                     0xC0360005L
#define STATUS_IPSEC_INTEGRITY_CHECK_FAILED             0xC0360006L
#define STATUS_IPSEC_CLEAR_TEXT_DROP                    0xC0360007L
#define STATUS_IPSEC_AUTH_FIREWALL_DROP                 0xC0360008L
#define STATUS_IPSEC_THROTTLE_DROP                      0xC0360009L
#define STATUS_IPSEC_DOSP_BLOCK                         0xC0368000L
#define STATUS_IPSEC_DOSP_RECEIVED_MULTICAST            0xC0368001L
#define STATUS_IPSEC_DOSP_INVALID_PACKET                0xC0368002L
#define STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED           0xC0368003L
#define STATUS_IPSEC_DOSP_MAX_ENTRIES                   0xC0368004L
#define STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED            0xC0368005L
#define STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES   0xC0368006L
#define STATUS_VOLMGR_INCOMPLETE_REGENERATION           0x80380001L
#define STATUS_VOLMGR_INCOMPLETE_DISK_MIGRATION         0x80380002L
#define STATUS_VOLMGR_DATABASE_FULL                     0xC0380001L
#define STATUS_VOLMGR_DISK_CONFIGURATION_CORRUPTED      0xC0380002L
#define STATUS_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC    0xC0380003L
#define STATUS_VOLMGR_PACK_CONFIG_UPDATE_FAILED         0xC0380004L
#define STATUS_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME   0xC0380005L
#define STATUS_VOLMGR_DISK_DUPLICATE                    0xC0380006L
#define STATUS_VOLMGR_DISK_DYNAMIC                      0xC0380007L
#define STATUS_VOLMGR_DISK_ID_INVALID                   0xC0380008L
#define STATUS_VOLMGR_DISK_INVALID                      0xC0380009L
#define STATUS_VOLMGR_DISK_LAST_VOTER                   0xC038000AL
#define STATUS_VOLMGR_DISK_LAYOUT_INVALID               0xC038000BL
#define STATUS_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS    0xC038000CL
#define STATUS_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED  0xC038000DL
#define STATUS_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL  0xC038000EL
#define STATUS_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS    0xC038000FL
#define STATUS_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS   0xC0380010L
#define STATUS_VOLMGR_DISK_MISSING                      0xC0380011L
#define STATUS_VOLMGR_DISK_NOT_EMPTY                    0xC0380012L
#define STATUS_VOLMGR_DISK_NOT_ENOUGH_SPACE             0xC0380013L
#define STATUS_VOLMGR_DISK_REVECTORING_FAILED           0xC0380014L
#define STATUS_VOLMGR_DISK_SECTOR_SIZE_INVALID          0xC0380015L
#define STATUS_VOLMGR_DISK_SET_NOT_CONTAINED            0xC0380016L
#define STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS     0xC0380017L
#define STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES      0xC0380018L
#define STATUS_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED        0xC0380019L
#define STATUS_VOLMGR_EXTENT_ALREADY_USED               0xC038001AL
#define STATUS_VOLMGR_EXTENT_NOT_CONTIGUOUS             0xC038001BL
#define STATUS_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION       0xC038001CL
#define STATUS_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED         0xC038001DL
#define STATUS_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION     0xC038001EL
#define STATUS_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH    0xC038001FL
#define STATUS_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED      0xC0380020L
#define STATUS_VOLMGR_INTERLEAVE_LENGTH_INVALID         0xC0380021L
#define STATUS_VOLMGR_MAXIMUM_REGISTERED_USERS          0xC0380022L
#define STATUS_VOLMGR_MEMBER_IN_SYNC                    0xC0380023L
#define STATUS_VOLMGR_MEMBER_INDEX_DUPLICATE            0xC0380024L
#define STATUS_VOLMGR_MEMBER_INDEX_INVALID              0xC0380025L
#define STATUS_VOLMGR_MEMBER_MISSING                    0xC0380026L
#define STATUS_VOLMGR_MEMBER_NOT_DETACHED               0xC0380027L
#define STATUS_VOLMGR_MEMBER_REGENERATING               0xC0380028L
#define STATUS_VOLMGR_ALL_DISKS_FAILED                  0xC0380029L
#define STATUS_VOLMGR_NO_REGISTERED_USERS               0xC038002AL
#define STATUS_VOLMGR_NO_SUCH_USER                      0xC038002BL
#define STATUS_VOLMGR_NOTIFICATION_RESET                0xC038002CL
#define STATUS_VOLMGR_NUMBER_OF_MEMBERS_INVALID         0xC038002DL
#define STATUS_VOLMGR_NUMBER_OF_PLEXES_INVALID          0xC038002EL
#define STATUS_VOLMGR_PACK_DUPLICATE                    0xC038002FL
#define STATUS_VOLMGR_PACK_ID_INVALID                   0xC0380030L
#define STATUS_VOLMGR_PACK_INVALID                      0xC0380031L
#define STATUS_VOLMGR_PACK_NAME_INVALID                 0xC0380032L
#define STATUS_VOLMGR_PACK_OFFLINE                      0xC0380033L
#define STATUS_VOLMGR_PACK_HAS_QUORUM                   0xC0380034L
#define STATUS_VOLMGR_PACK_WITHOUT_QUORUM               0xC0380035L
#define STATUS_VOLMGR_PARTITION_STYLE_INVALID           0xC0380036L
#define STATUS_VOLMGR_PARTITION_UPDATE_FAILED           0xC0380037L
#define STATUS_VOLMGR_PLEX_IN_SYNC                      0xC0380038L
#define STATUS_VOLMGR_PLEX_INDEX_DUPLICATE              0xC0380039L
#define STATUS_VOLMGR_PLEX_INDEX_INVALID                0xC038003AL
#define STATUS_VOLMGR_PLEX_LAST_ACTIVE                  0xC038003BL
#define STATUS_VOLMGR_PLEX_MISSING                      0xC038003CL
#define STATUS_VOLMGR_PLEX_REGENERATING                 0xC038003DL
#define STATUS_VOLMGR_PLEX_TYPE_INVALID                 0xC038003EL
#define STATUS_VOLMGR_PLEX_NOT_RAID5                    0xC038003FL
#define STATUS_VOLMGR_PLEX_NOT_SIMPLE                   0xC0380040L
#define STATUS_VOLMGR_STRUCTURE_SIZE_INVALID            0xC0380041L
#define STATUS_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS    0xC0380042L
#define STATUS_VOLMGR_TRANSACTION_IN_PROGRESS           0xC0380043L
#define STATUS_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE     0xC0380044L
#define STATUS_VOLMGR_VOLUME_CONTAINS_MISSING_DISK      0xC0380045L
#define STATUS_VOLMGR_VOLUME_ID_INVALID                 0xC0380046L
#define STATUS_VOLMGR_VOLUME_LENGTH_INVALID             0xC0380047L
#define STATUS_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE    0xC0380048L
#define STATUS_VOLMGR_VOLUME_NOT_MIRRORED               0xC0380049L
#define STATUS_VOLMGR_VOLUME_NOT_RETAINED               0xC038004AL
#define STATUS_VOLMGR_VOLUME_OFFLINE                    0xC038004BL
#define STATUS_VOLMGR_VOLUME_RETAINED                   0xC038004CL
#define STATUS_VOLMGR_NUMBER_OF_EXTENTS_INVALID         0xC038004DL
#define STATUS_VOLMGR_DIFFERENT_SECTOR_SIZE             0xC038004EL
#define STATUS_VOLMGR_BAD_BOOT_DISK                     0xC038004FL
#define STATUS_VOLMGR_PACK_CONFIG_OFFLINE               0xC0380050L
#define STATUS_VOLMGR_PACK_CONFIG_ONLINE                0xC0380051L
#define STATUS_VOLMGR_NOT_PRIMARY_PACK                  0xC0380052L
#define STATUS_VOLMGR_PACK_LOG_UPDATE_FAILED            0xC0380053L
#define STATUS_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID   0xC0380054L
#define STATUS_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID 0xC0380055L
#define STATUS_VOLMGR_VOLUME_MIRRORED                   0xC0380056L
#define STATUS_VOLMGR_PLEX_NOT_SIMPLE_SPANNED           0xC0380057L
#define STATUS_VOLMGR_NO_VALID_LOG_COPIES               0xC0380058L
#define STATUS_VOLMGR_PRIMARY_PACK_PRESENT              0xC0380059L
#define STATUS_VOLMGR_NUMBER_OF_DISKS_INVALID           0xC038005AL
#define STATUS_VOLMGR_MIRROR_NOT_SUPPORTED              0xC038005BL
#define STATUS_VOLMGR_RAID5_NOT_SUPPORTED               0xC038005CL
#define STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED             0x80390001L
#define STATUS_BCD_TOO_MANY_ELEMENTS                    0xC0390002L
#define STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED         0x80390003L
#define STATUS_VHD_DRIVE_FOOTER_MISSING                 0xC03A0001L
#define STATUS_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH       0xC03A0002L
#define STATUS_VHD_DRIVE_FOOTER_CORRUPT                 0xC03A0003L
#define STATUS_VHD_FORMAT_UNKNOWN                       0xC03A0004L
#define STATUS_VHD_FORMAT_UNSUPPORTED_VERSION           0xC03A0005L
#define STATUS_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH      0xC03A0006L
#define STATUS_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION    0xC03A0007L
#define STATUS_VHD_SPARSE_HEADER_CORRUPT                0xC03A0008L
#define STATUS_VHD_BLOCK_ALLOCATION_FAILURE             0xC03A0009L
#define STATUS_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT       0xC03A000AL
#define STATUS_VHD_INVALID_BLOCK_SIZE                   0xC03A000BL
#define STATUS_VHD_BITMAP_MISMATCH                      0xC03A000CL
#define STATUS_VHD_PARENT_NOT_FOUND                     0xC03A000DL
#define STATUS_VHD_CHILD_PARENT_ID_MISMATCH             0xC03A000EL
#define STATUS_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH      0xC03A000FL
#define STATUS_VHD_METADATA_READ_FAILURE                0xC03A0010L
#define STATUS_VHD_METADATA_WRITE_FAILURE               0xC03A0011L
#define STATUS_VHD_INVALID_SIZE                         0xC03A0012L
#define STATUS_VHD_INVALID_FILE_SIZE                    0xC03A0013L
#define STATUS_VIRTDISK_PROVIDER_NOT_FOUND              0xC03A0014L
#define STATUS_VIRTDISK_NOT_VIRTUAL_DISK                0xC03A0015L
#define STATUS_VHD_PARENT_VHD_ACCESS_DENIED             0xC03A0016L
#define STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH           0xC03A0017L
#define STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED    0xC03A0018L
#define STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT   0xC03A0019L
#define STATUS_VIRTUAL_DISK_LIMITATION                  0xC03A001AL
#define STATUS_VHD_INVALID_TYPE                         0xC03A001BL
#define STATUS_VHD_INVALID_STATE                        0xC03A001CL
#define STATUS_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE    0xC03A001DL
#define STATUS_QUERY_STORAGE_ERROR                      0x803A0001L
#define STATUS_DIS_NOT_PRESENT                          0xC03C0001L
#define STATUS_DIS_ATTRIBUTE_NOT_FOUND                  0xC03C0002L
#define STATUS_DIS_UNRECOGNIZED_ATTRIBUTE               0xC03C0003L
#define STATUS_DIS_PARTIAL_DATA                         0xC03C0004L

/* Macro to create Filter Manager NT error codes from COM error codes */
#define FILTER_FLT_NTSTATUS_FROM_HRESULT( x ) \
    ((NTSTATUS)(((x) & 0xC0007FFFL) | (FACILITY_FILTER_MANAGER << 16) | 0x40000000L))

/* Macro to create NT error codes from Win32 error codes */
#define NTSTATUS_FROM_WIN32( x ) \
    ((NTSTATUS)(x) <= 0) ? (NTSTATUS)(x) : (NTSTATUS)(((x) & 0x0000FFFFL) | \
    (FACILITY_NTWIN32 << 16) | ERROR_SEVERITY_ERROR))

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTSTATUS_ */
