////////////////////////////////////////////////////////////////////////////////
//
//  File Management System - Header File
//
//  (c) Copyright 2003 Point Mad. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
#include"menu.h"
#include"vfile.h"

#ifndef _fms_h_included_
#define _fms_h_included_

extern p_bitmap ICONDir32;
extern p_bitmap ICONDir16;

typedef struct TFileMan *PFileMan;
typedef struct TFileMan {
	
	l_text Name;
	l_text Runner;
	l_text Extention;
	
	l_bool (*Run) 		( PFileInfo f, l_text ex );

	
	p_bitmap Icon16;
	p_bitmap Icon32;
	p_bitmap Icon48;
	
	p_bitmap  (*GetIcon) 			( PFileInfo f, l_ulong Size, l_ulong *ToFree );
	l_text    (*GetNiceName) 	( PFileInfo f, l_text name );
	void   		(*GetAllThings) ( PFileInfo f, l_text name, l_text*n, p_bitmap*i16, p_bitmap*i32, p_bitmap*i48, l_ulong *fi );
	
	
	
	
	PMenuItem (*GenerateSubMenuItems) ( PFileMan o, PFileInfo f, PMenuItem next );
	
	l_bool    (*HandleMenuMsg) ( PFileMan o, PFileInfo f, l_ulong msg );
	
} TFileMan;


l_bool FileHandleMenuMsg ( l_text file, l_ulong msg );
PMenu FileGetMenu ( l_text file );
l_bool FileRun ( l_text file, l_text ex );
PFileMan FileGetFileman  ( PFileInfo f );

p_bitmap 	FileGetIcon 		 	( l_text file, l_ulong Size, l_ulong *ToFree );
l_text   	FileGetNiceName 	( l_text file, l_text name );
void 			FileGetAllThings 	( l_text file, l_text name, l_text*n, p_bitmap*i16, p_bitmap*i32, p_bitmap*i48, l_ulong *fi );

p_bitmap 	FileGetIconEx 		 	( PFileInfo f, l_ulong Size, l_ulong *ToFree );
l_text   	FileGetNiceNameEx 	( PFileInfo f );
void 			FileGetAllThingsEx 	( PFileInfo f, l_text*n, p_bitmap*i16, p_bitmap*i32, p_bitmap*i48, l_ulong *fi );

l_bool FileRunEx ( PFileInfo f, l_text ex );

l_bool FileHandleMenuMsgEx ( PFileInfo f, l_ulong msg );
PMenu FileGetMenuEx ( PFileInfo f, l_ulong Flags  );



PFileMan NewFileManager ( l_text Name, l_text Runner, l_text Extention, l_bool (*Run) ( PFileInfo, l_text ),
													p_bitmap Icon16, p_bitmap Icon32, p_bitmap Icon48,
													p_bitmap (*GetIcon) ( PFileInfo, l_ulong, l_ulong* ), l_text (*GetNiceName) ( PFileInfo, l_text ),
													void   		(*GetAllThings) ( PFileInfo, l_text, l_text*, p_bitmap*, p_bitmap*, p_bitmap*, l_ulong * ) );
#endif /* _fms_h_included_ */
