/**
*	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
*
*	FILE:			skin.c
*
*	PROJECT:		Phoenix engine - Core
*
*	DESCRIPTION:	Skinning functions.
*
*	CONTRIBUTORS:
*					Lukas Lipka
*
*	TODO:			@
*
*	BUG:			@
*
*	MISTAKE:		@
*
*	IDEA:			@ Support for non-rectangular shapes (lukas)
*/

#include <kernel.h>

#define SKIN_DIR	"./SYSTEM/SKINS/"

l_ulong AppVersion = ULONG_ID(0,5,2,0);
char    AppName[] = "Skin System";
l_uid	nUID = "skin";

PSkin	SkinItems = NULL;

l_bool 	UseSkins = true;

l_color _SysColors[25];
l_color *SysColors = _SysColors;

PSkin GetSkinItem(l_text szName)
{
	PSkin p = SkinItems;

	do
	{
		if (!stricmp(szName, p->Name)) return p;

		p = p->Next;
	}
	while (p);

	return 0;
}

void DrawSkin(p_bitmap out, PSkin si, l_int x1, l_int y1, l_int x2, l_int y2)
{
	if ( !si )
	{
		DebugError("No skin");
		return;
	}

	masked_blit(si->Skin, out, 0, 0, x1, y1, si->Left, si->Top);
	masked_blit(si->Skin, out, 0, si->Skin->h-si->Bottom, x1, y2-si->Bottom+1, si->Left, si->Bottom);
	masked_blit(si->Skin, out, si->Skin->w-si->Right, 0, x2-si->Right+1, y1, si->Right, si->Top);
	masked_blit(si->Skin, out, si->Skin->w-si->Right, si->Skin->h-si->Bottom, x2-si->Right+1, y2-si->Bottom+1, si->Right, si->Bottom);

	masked_stretch_blit(si->Skin, out, 0, si->Top, si->Left, si->Skin->h-si->Top-si->Bottom, x1, y1+si->Top, si->Left, (y2-y1+1)-si->Top-si->Bottom);
	masked_stretch_blit(si->Skin, out, si->Skin->w-si->Right, si->Top, si->Right, si->Skin->h-si->Top-si->Bottom, x2-si->Right+1, y1+si->Top, si->Right, (y2-y1+1)-si->Top-si->Bottom);

	masked_stretch_blit(si->Skin, out, si->Left, 0, si->Skin->w-si->Left-si->Right, si->Top, x1+si->Left, y1, (x2-x1+1)-si->Left-si->Right, si->Top);
	masked_stretch_blit(si->Skin, out, si->Left, si->Skin->h-si->Bottom, si->Skin->w-si->Left-si->Right, si->Bottom, x1+si->Left, y2-si->Bottom+1, (x2-x1+1)-si->Left-si->Right, si->Bottom);

	masked_stretch_blit(si->Skin, out, si->Left, si->Top, si->Skin->w-si->Left-si->Right, si->Skin->h-si->Top-si->Bottom, x1+si->Left, y1+si->Top, (x2-x1)-si->Left-si->Right+1, (y2-y1)-si->Top-si->Bottom+1);

}

void SkinSystemInstall()
{
	l_text szFile = malloc(strlen(SKIN_DIR)+64);
	l_int Items = 0;
	FILE* f;

	_SysColors[0]  = makecol(  0,  0,  0);
	_SysColors[1]  = makecol(246,246,246);
	_SysColors[2]  = makecol(255,255,255);
	_SysColors[3]  = makecol(128,128,128);
	_SysColors[4]  = makecol(255,255,255);

	_SysColors[5]  = makecol(255,255,255);
	_SysColors[6]  = makecol(  0,  0,  0);
	_SysColors[7]  = makecol(195,195,195);
	_SysColors[8]  = makecol(195,195,195);
	_SysColors[9]  = makecol( 64, 64,255);

	_SysColors[10] = makecol(  0,  0,255);
	_SysColors[11] = makecol(255,255,255);

	_SysColors[12] = makecol(192,192,255);
	_SysColors[13] = makecol(  0,  0,  0);

	strcpy(szFile, SKIN_DIR);
	strcat(szFile, KeyGetText("/USER/GUI/SKIN","ozone.ini"));

	DebugMessage(szFile);

	f = fopen(szFile, "r");

	if (!f)
	{
		UseSkins = false;
		return;
	}

	while (!feof(f))
	{
		l_char c[256];
		fgets(c, 256, f);
		if (!c[0]) continue;
		if (c[strlen(c)-1] < 32) c[strlen(c)-1] = 0;
		if (c[0] == '[' && (c[strlen(c)-1] == ']' || c[strlen(c)-2] == ']') && stricmp(c+1, "Information]"))
		{
			l_text szPath		= malloc(1024);
			l_bool Platform		= false;
			PSkin p 			= (PSkin)malloc(sizeof(TSkin));
			memset(p, 0, sizeof(TSkin));

			/**
			 * Fuck this dirty hack :GRR:
			 */
			if (c[strlen(c)-2] == ']') Platform = true;

			p->Name = (char*)strdup(c+1);

			if (Platform) p->Name[strlen(c+1)-2] = '\0';
			else p->Name[strlen(c+1)-1] = '\0';

			/**
			*	Load image
			*/
			strcpy(szPath, SKIN_DIR);
			strcat(szPath, INIGetNew(szFile, p->Name, "bmp", NULL));
			p->Skin = LoadImage(szPath);

			/**
			*	Load image offsets
			*/
			p->Left = INIGetInteger(szFile, p->Name, "left", 3);
			p->Right = INIGetInteger(szFile, p->Name, "right", 3);
			p->Top = INIGetInteger(szFile, p->Name, "top", 3);
			p->Bottom = INIGetInteger(szFile, p->Name, "bottom", 3);

			/**
			*	Load skin items font and color
			*/
			strcpy(szPath, SKIN_DIR);
			strcat(szPath, INIGetNew(szFile, p->Name, "font", ""));
			p->Font = FontLoad(szPath);
			p->FontColor = INIGetColor(szFile, p->Name, "color", makecol(0,0,0));

			/*
			DebugMessage("Loading font for %s - %s", p->Name, szPath);
			*/

			DebugMessage("%s - w=%i h=%i OFFSETS[%i, %i, %i, %i]", p->Name, p->Skin->w, p->Skin->h, p->Top, p->Bottom, p->Left, p->Right);
			Items++;

			p->Next = NULL;

			free(szPath);

			if (!SkinItems) SkinItems = p;
			else
			{
				PSkin w = SkinItems;

				if (w->Next)
				{
					do w = w->Next;
					while (w->Next);
				}
				w->Next = p;
			}
		}
	}

	DebugMessage("Skin system loaded a total of '%i' skin items", Items);

	fclose(f);
	free(szFile);
}

l_bool LibMain ( l_text Args )
{
	SkinSystemInstall();

	APPEXPORT(GetSkinItem);
	APPEXPORT(DrawSkin);
	APPEXPORT(SysColors);
	APPEXPORT(UseSkins);

	return true;
}

void Close (void)
{
	PSkin p = SkinItems;
	PSkin tmp;
	l_int Items = 0;

	SkinItems = NULL;

	while ( p )
	{
		tmp = p->Next;

		if ( p->Name ) free(p->Name);
		if ( p->Skin ) destroy_bitmap(p->Skin);

		free(p);

		p = tmp;
		Items++;
	}

	DebugMessage("Skin system destroyed a total of '%i' skin items", Items);
}
