////////////////////////////////////////////////////////////////////////////////
//
//  Widgets - Core File
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////

// Need : Allegro
//        List
//        Metrics
//        Mouse Driver
//        Keyboard Driver

/* to do reminder
-> Allow alpha blending widget background update OK Should work but _very_ slow
-> Make optimisations
-> Change alpha prepare calls
*/



#include "kernel.h"
#include "widget.h"

l_uid 	nUID 				= "widget";
l_ulong AppVersion 	= ULONG_ID(0,0,0,33);
char    AppName[] 	= "Widgets System";

PWidget DeskTop			= NULL;
PWidget TopWidget		= NULL;
PWidget MasterWidget	= NULL;
PWidget FocusedWidget	= NULL;

PWidget *LookFor	= NULL;

p_bitmap buffer	= NULL;
void WidgetRefreshAbsolutePos ( PWidget o );

l_ubig LastMouseMove = 0;
l_ubig LastNotified = 0;
l_ubig LastMouseClickLeft = 0;
l_ubig LastMouseClickRight = 0;
l_ubig LastMouseClickMiddle = 0;
//l_int DoubleClickSpeed = 0;
#define DoubleClickSpeed (100*Mouse->DblClkSpeed)

l_bool AlphaAllow = true;

////////////////////////////////////////////////////////////////////////////////
// OSD Data
l_bool   OSD		= 0;
l_bool   OSDIsRect	= 0;
TRect     OSDRect	= { 0, 0, 0, 0 };
l_color  OSDColor	= 0;
////////////////////////////////////////////////////////////////////////////////
PWidget TopWidgetUnderPoint ( PWidget o, TPoint p ) {
	if ( o->Last ) {
    PWidget a = o->Last->Next;
    PWidget b = a;
    do {
      if ( _PointInRect(p,a->Absolute) && ( a->Flags & WFVisible ) ) return TopWidgetUnderPoint(a,p);
	    a = a->Next;
    } while ( a != b );
  }
  return o;
}
////////////////////////////////////////////////////////////////////////////////
PWidget GetTopWidgetUnderMouse ( void ) {
	return TopWidgetUnderPoint(DeskTop,Mouse->State.p);
}
////////////////////////////////////////////////////////////////////////////////
// OSD related
////////////////////////////////////////////////////////////////////////////////
void DrawOSDOnRect ( p_bitmap out, TRect r ) {
  if ( OSDIsRect ) {
	  if ( _RectOverlay(r, OSDRect ) ) {
		  TRect Tmp;
		  RectIntersept(&Tmp,r,OSDRect);
	    xor_mode(TRUE);
	    if ( Tmp.a.x == OSDRect.a.x ) vline(out,Tmp.a.x,Tmp.a.y,Tmp.b.y,OSDColor);
	    if ( Tmp.b.x == OSDRect.b.x ) vline(out,Tmp.b.x,Tmp.a.y,Tmp.b.y,OSDColor);
	   	if ( Tmp.a.y == OSDRect.a.y ) hline(out,Tmp.a.x,Tmp.a.y,Tmp.b.x,OSDColor);
	    if ( Tmp.b.y == OSDRect.b.y ) hline(out,Tmp.a.x,Tmp.b.y,Tmp.b.x,OSDColor);
		  xor_mode(FALSE);
    }
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetOSDRect ( TRect r ) {
	MouseHide();
	PauseMultitasking();
	xor_mode(TRUE);
	set_clip(screen,0,0,screen->w-1,screen->h-1);
	if ( OSD && OSDIsRect ) {
    rect(screen,OSDRect.a.x,OSDRect.a.y,OSDRect.b.x,OSDRect.b.y,OSDColor);
    OSDRect = r;
  } else {
	  OSD = 1;
	  OSDIsRect = 1;
	  OSDRect = r;
  }
  rect(screen,OSDRect.a.x,OSDRect.a.y,OSDRect.b.x,OSDRect.b.y,OSDColor);
  xor_mode(FALSE);
  UnPauseMultitasking();
  MouseShow();
}
////////////////////////////////////////////////////////////////////////////////
void WidgetUnOSD ( void ) {
  if ( OSD && OSDIsRect ) {
		MouseHide();
		PauseMultitasking();
    xor_mode(TRUE);
    set_clip(screen,0,0,screen->w-1,screen->h-1);
    rect(screen,OSDRect.a.x,OSDRect.a.y,OSDRect.b.x,OSDRect.b.y,OSDColor);
    xor_mode(FALSE);
    UnPauseMultitasking();
    MouseShow();
  }
	  OSD = 0;
	  OSDIsRect = 0;
}
////////////////////////////////////////////////////////////////////////////////
// Draw related
////////////////////////////////////////////////////////////////////////////////
PWidget WidgetGetFirstAlpha ( PWidget o ) {
	if ( !AlphaAllow ) return NULL;
	do {
		if ( o->Alpha ) return o;
	} while ( o = o->Parent );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
void WidgetGenerateCacheExBrothers ( PList l, PWidget o, PWidget i, l_ulong Flags,PWidget extoa ) {
	if ( o->Parent ) {
    PWidget a = o->Parent->Last->Next;
    if ( extoa ) if ( extoa->Parent == o->Parent ) a = extoa->Next;
    while ( a != o ) {
	    if ( ( a->Flags & WFVisible ) && _RectOverlay(i->DrawAbsolute, a->DrawAbsolute) ) {
	      RemoveZoneInList(l,a->DrawAbsolute);
      }
	    a = a->Next;
    }
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetGenerateCacheExSubs ( PList l, PWidget o, l_ulong Flags,PWidget extoa ) {
	if ( o->Last ) {
  PWidget a = o->Last->Next;
  PWidget b = o->Last->Next;

	if ( extoa ) if ( extoa->Parent == o ) a = extoa->Next;

  if ( a != extoa ) do {
	  if ( ( a->Flags & WFVisible ) && _RectOverlay(o->DrawAbsolute, a->DrawAbsolute) ) {
    	RemoveZoneInList(l,a->DrawAbsolute);
   	}
	  a = a->Next;
  } while ( a != b );
}
}
////////////////////////////////////////////////////////////////////////////////
PList WidgetGenerateCache ( PWidget o, TRect *w, l_ulong Flags,PWidget extoa ) {
	PWidget a = o;
	PList l = NULL;
	 //DebugMessage ("WidgetGenerateCache(%s)",o->Name);

	if ( w ) { // *w and o->Absolute MUST have a common part
		TRect Tmp;
		RectIntersept(&Tmp,o->DrawAbsolute,*w);
		l = NewListFromRect(Tmp);
  } else if ( o->DrawAbsolute.a.x-o->DrawAbsolute.b.x+1 || o->DrawAbsolute.a.y-o->DrawAbsolute.b.y+1 )
	  l = NewListFromRect(o->DrawAbsolute);
	else
		return NewList();

	WidgetGenerateCacheExSubs(l,o,Flags,extoa);
	do {
	  WidgetGenerateCacheExBrothers(l,a,o,Flags,extoa);
  } while ( a = a->Parent );

  return l;
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDePrepareAlpha ( PWidget oa ) {
	if ( oa->ACache ) {
		destroy_bitmap(oa->ACache);
		oa->ACache = NULL;
		oa->APoint.x = 0;
		oa->APoint.y = 0;
	}
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawAllToOnRect ( PWidget o, PWidget to, PRect w, p_bitmap Out, PPoint d, PWidget extoa );
////////////////////////////////////////////////////////////////////////////////
void WidgetPrepareAlpha ( PWidget oa, PWidget o ) {
	//DebugMessage("################ %s",o->Name);
	if ( !AlphaAllow ) return;
	if ( oa->ACache ) WidgetDePrepareAlpha(oa);
	oa->ACache = create_bitmap(GetWidth(o->DrawAbsolute),GetHeight(o->DrawAbsolute));
	clear(oa->ACache);
	oa->APoint.x = -o->DrawAbsolute.a.x;
	oa->APoint.y = -o->DrawAbsolute.a.y;
	WidgetDrawAllToOnRect(oa->Parent,oa,&o->DrawAbsolute,oa->ACache,&oa->APoint,oa);
}
////////////////////////////////////////////////////////////////////////////////
// Independant function, as it can usefull for some widget
void WidgetDrawFromBuffer ( PWidget o, PList l, p_bitmap Out, p_bitmap Buffer, PPoint d, TRect *w ) {
	if ( !( o->Flags & WFVisible ) ) return;
	if ( l ) {
    PListItem a = l->Last;
    PListItem b = a;
    if ( !a ) return;
    if ( d ) {
	    set_clip(Out,max(0,o->DrawAbsolute.a.x+d->x),
                max(0,o->DrawAbsolute.a.y+d->y),
                min(Out->w-1,o->DrawAbsolute.b.x+d->x),
                min(Out->h-1,o->DrawAbsolute.b.y+d->y));

		  //blit(Buffer,screen,0,screen->h/2,0,0,screen->w, screen->h/2 );
	    do {
			  PRect r = a->Data;
		    blit(Buffer,Out,r->a.x,    						 r->a.y,
		                    r->a.x+d->x,          r->a.y+d->y,
		                    r->b.x-r->a.x+1, r->b.y-r->a.y+1 );
		    a = a->Next;
	    } while ( a != b ) ;
    } else {
	    	    set_clip(Out,max(0,o->DrawAbsolute.a.x),
	                    max(0,o->DrawAbsolute.a.y),
	                    min(Out->w-1,o->DrawAbsolute.b.x),
	                    min(Out->h-1,o->DrawAbsolute.b.y));
	    do {
			  PRect r = a->Data;
			  if ( OSD ) DrawOSDOnRect(Buffer,*r);
			  MouseRecap(Buffer,*r);
		    blit(Buffer,Out,r->a.x,       		r->a.y,
		                    r->a.x,          r->a.y,
		                    r->b.x-r->a.x+1, r->b.y-r->a.y+1 );
		    a = a->Next;
	    } while ( a != b ) ;
    }
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetRefresh ( PWidget o, PRect w, p_bitmap Out, PPoint d, l_ulong Flags, PWidget extoa )
{
	PWidget oa;
	PList l;

	if ( !( o->Flags & WFVisible ) ) return;

	l = 	WidgetGenerateCache(o,w,Flags,extoa);

	if ( l->Last ) { // There is at least something to draw


		oa = WidgetGetFirstAlpha(o);

	  PauseMultitasking(); // Disable multitasking to prevent graphics bugs
		if ( !o->Draw )
		{
			// No custom draw function //////////////////////////////////////////////////
			// As default is rectfill, no buffer is needed,
			// It's faster than ever !!
			// *BUT* No alpha blending support

			PListItem a = l->Last;
			PListItem b = a;

      acquire_bitmap(Out);

      if ( d ) {
	     	set_clip(Out,max(0,o->DrawAbsolute.a.x+d->x),
		                    max(0,o->DrawAbsolute.a.y+d->y),
		                    min(Out->w-1,o->DrawAbsolute.b.x+d->x),
		                    min(Out->h-1,o->DrawAbsolute.b.y+d->y));
	      do {
			    PRect r = a->Data;
			  	rectfill(Out,r->a.x+d->x,r->a.y+d->y,r->b.x+d->x,r->b.y+d->y,o->BackgroundColor);
		      a = a->Next;
	      } while ( a != b ) ;

      } else {
	     	set_clip(Out,max(0,o->DrawAbsolute.a.x),
		                    max(0,o->DrawAbsolute.a.y),
		                    min(Out->w-1,o->DrawAbsolute.b.x),
		                    min(Out->h-1,o->DrawAbsolute.b.y));
	      do {
			    PRect r = a->Data;
			  	rectfill(Out,r->a.x,r->a.y,r->b.x,r->b.y,o->BackgroundColor);
			  	if ( OSD ) DrawOSDOnRect(Out,*r);
		      MouseRecap(Out,*r);
		      a = a->Next;
	      } while ( a != b ) ;
    	}

      release_bitmap(Out);
    } else  if ((l->Last == l->Last->Next) && !( o->Flags & WFForceBuffer ) && !d && !oa) {
	    // Only a rect to draw, so we can draw directly to screen /////////////////
	    // Faster
	    PRect r = l->Last->Data;

	   	acquire_bitmap(Out);

	    set_clip(Out,max(0,r->a.x),
	                    max(0,r->a.y),
	                    min(Out->w-1,r->b.x),
	                    min(Out->h-1,r->b.y));
	    o->Draw	(o,Out,r);
	    if ( OSD ) DrawOSDOnRect(Out,*r);
	    MouseRecap(Out,*r);

	    release_bitmap(Out);
    } else if ( o->Flags & WFForceNonBuffer && !( o->Flags & WFForceBuffer ) && !d && !oa  ) {
	    // Widget do not want to use automatic buffer /////////////////////////////
	    // Not always faster
		  PListItem a = l->Last;
      PListItem b = a;
      acquire_bitmap(Out);

      do {
		    PRect r = a->Data;
		    set_clip(Out,max(0,r->a.x),
	                      max(0,r->a.y),
	                      min(Out->w-1,r->b.x),
	                      min(Out->h-1,r->b.y));
		  	o->Draw	(o,Out,r);
		  	if ( OSD ) DrawOSDOnRect(Out,*r);
		  	MouseRecap(Out,*r);
	      a = a->Next;
      } while ( a != b );

      release_bitmap(Out);
    } else if ( buffer ) {
	    ///////////////////////////////////////////////////////////////////////////

			TRect Tmp = o->Absolute;
			if ( w ) RectIntersept(&Tmp,o->DrawAbsolute,*w);

	    if ( oa == o ) WidgetPrepareAlpha(oa,o);


	    set_clip(buffer,max(0,o->DrawAbsolute.a.x),
	                    max(0,o->DrawAbsolute.a.y),
	                    min(buffer->w-1,o->DrawAbsolute.b.x),
	                    min(buffer->h-1,o->DrawAbsolute.b.y));

	    o->Draw	(o,buffer,&Tmp);
	    if ( oa )
		    if ( oa->ACache ) {
			  	set_trans_blender(255, 255, 255, oa->Alpha);
	      	draw_trans_sprite(buffer,oa->ACache, -oa->APoint.x, -oa->APoint.y);
	    	}
	    acquire_bitmap(Out);
  	  WidgetDrawFromBuffer(o,l,Out,buffer,d,w);
  	  release_bitmap(Out);
    }
    UnPauseMultitasking();
  }
  FreeList(l);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawAllOnRect ( PWidget o, PRect w, p_bitmap Out, PPoint d,PWidget extoa ) {
	if ( !RectOverlay (o->DrawAbsolute,*w) || !( o->Flags & WFVisible ) ) return;
	o->Refresh(o,w,Out,d,1,extoa);
	if ( o->Last ) {
    PWidget a = o->Last;
    PWidget b = a;
    if ( a ) do {
      WidgetDrawAllOnRect(a,w,Out,d,extoa);
      a = a->Prev;
    } while ( a != b );
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawAllToOnRect ( PWidget o, PWidget to, PRect w, p_bitmap Out, PPoint d, PWidget extoa ) {
	if ( !RectOverlay (o->DrawAbsolute,*w) || !( o->Flags & WFVisible ) ) return;
	o->Refresh(o,w,Out,d,1,extoa);
	if ( o->Last ) {
    PWidget a = to->Next;
    PWidget b = o->Last->Next;
    do {
      WidgetDrawAllOnRect(a,w,Out,d,extoa);
      a = a->Next;
    } while ( a != b );
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawOnRectEx ( PWidget o, TRect w, PWidget Ignore ) {
	if ( RectOverlay (o->DrawAbsolute,w) && ( o->Flags & WFVisible ) ) {
	  o->Refresh(o,&w,screen,NULL,0,0);
	  if ( o->Last ) {
      PWidget a = o->Last;
      PWidget b = a;
      if ( a ) do {
        if ( a != Ignore ) WidgetDrawOnRect(a,w,Ignore);
        a = a->Next;
      } while ( a != b );
    }
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawAllEx ( PWidget o ) {
	if ( !( o->Flags & WFVisible ) ) return;
	o->Refresh(o,NULL,screen,NULL,0,0);
	if ( o->Last ) {
    PWidget a = o->Last;
    PWidget b = a;
    if ( a ) do {
      WidgetDrawAll(a);
      a = a->Next;
    } while ( a != b );
  }
}
////////////////////////////////////////////////////////////////////////////////
void DrawOverlayingAlphaBlendindChilds  ( PWidget o, PRect w ) {
  if ( o->Last ) {
    PWidget a = o->Last;
    PWidget b = a;
    if ( a ) do {
      if ( RectOverlay(a->DrawAbsolute,*w) && ( a->Flags & WFVisible ) && a->Alpha )
      	WidgetDrawOnRectEx(a,*w,NULL);
      a = a->Next;
    } while ( a != b );
  }
}
////////////////////////////////////////////////////////////////////////////////
void DrawOverlayingAlphaBlendindBrothers ( PWidget o, PWidget a, PRect w ) {
	if ( o->Last ) {
	  PWidget b = o->Last;
	  a = a->Prev;
	  while ( a != b ) {
		  if ( ( a->Flags & WFVisible ) && RectOverlay(a->DrawAbsolute,*w) && a->Alpha ) {
	    	WidgetDrawOnRectEx(a,*w,NULL);
    	}
		  a = a->Prev;
	  } ;

	}
}
////////////////////////////////////////////////////////////////////////////////
void DrawOverlayingAlphaBlendind  ( PWidget o, PRect w ) {
	PWidget aa = o;
	PWidget a = aa->Parent;
	DrawOverlayingAlphaBlendindChilds(o,w?w:&o->DrawAbsolute);
	while ( a ) {
	  DrawOverlayingAlphaBlendindBrothers(a,aa,w?w:&o->DrawAbsolute);
	  aa = a;
	  a = aa->Parent;
  };
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawOnRect ( PWidget o, TRect w, PWidget Ignore ) {
	WidgetDrawOnRectEx(o,w,Ignore);
	if ( AlphaAllow ) DrawOverlayingAlphaBlendind(o,&w);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDrawAll ( PWidget o ) {
	WidgetDrawAllEx(o);
	if ( AlphaAllow ) DrawOverlayingAlphaBlendind(o,NULL);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDraw ( PWidget o, PRect w ) {
	o->Refresh(o,w,screen,NULL,0,0);
	if ( AlphaAllow ) DrawOverlayingAlphaBlendind(o,w);
}
////////////////////////////////////////////////////////////////////////////////
// Widget Tree related
////////////////////////////////////////////////////////////////////////////////
// Remove i from o childs, BUT no redraw
void RemoveWidgetEx ( PWidget o, PWidget i ) {
  if ( i->Next == i ) { // Alone ...
	  o->Last = NULL;
  } else {
	  i->Next->Prev = i->Prev;
	  i->Prev->Next = i->Next;
	  if ( o->Last == i ) o->Last = i->Prev;
  }
	i->Parent = NULL;
}
////////////////////////////////////////////////////////////////////////////////
// Remove i from o childs, and redraw
void WidgetRemove ( PWidget o, PWidget i ) {
	//WidgetKillRelatedCache(o);

  RemoveWidgetEx(o,i);
  WidgetDrawOnRect(o,i->DrawAbsolute,NULL);

  if ( ( i->Flags & WFSelected ) && o->Last ) {
    PWidget a = o->Last->Next;
    PWidget b = a;
    do {
      WidgetDrawAll(a);
      if ( a->Flags &WFSelectable ) {
	      WidgetSelect(a);
				return;
      }
      a = a->Next;
    } while ( a != b );
  }
}
////////////////////////////////////////////////////////////////////////////////
void InsertWidgetBefore ( PWidget o, PWidget i, PWidget b )
{
	PWidget t = b;


	if ( !o->Last )
	{
		i->Next = i;
		i->Prev = i;
		o->Last = i;
	}
	else
	{
		if ( b )
		{
			i->Prev = b->Prev;
			i->Next = b;
			b->Prev->Next = i;
			b->Prev = i;
		}
		else
		{
			i->Next = o->Last->Next;
			i->Prev = o->Last;
			o->Last->Next->Prev = i;
			o->Last->Next = i;
			o->Last = i;
		}
	}

	i->Parent = o;

	WidgetRefreshAbsolutePos(i);

	/**
	*	Call setup only once, not on z-order cahnge
	*/
	if ( i->Setup )
	{
		i->Setup(i);
		i->Setup = 0;
	}
}
////////////////////////////////////////////////////////////////////////////////
// Add i to o childs
void WidgetInsert ( PWidget o, PWidget i )
{

	WidgetUnSelectAllSubs(o);
	if ( o->Flags & WFSelectable ) o->Flags |= WFSelected;

	if ( o->Last )
		InsertWidgetBefore(o, i, o->Last->Next);
	else
		InsertWidgetBefore(o, i, NULL);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetFirstEx ( PWidget o, PWidget i  ) {
  RemoveWidgetEx(o,i);
  InsertWidgetBefore(o, i, o->Last->Next);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetFirst ( PWidget o ) {

	if ( o->Parent ) o->Parent->SetFirstEx(o->Parent,o);

	WidgetSelect(o);

	WidgetDraw(o,NULL);
	WidgetDrawAll(o);
}
////////////////////////////////////////////////////////////////////////////////
// Widget Positions and related...
////////////////////////////////////////////////////////////////////////////////
void WidgetRefreshAbsolutePos ( PWidget o ) {
	TRect Tmp;
	if ( o->Parent ) {
		RectMove(&Tmp,o->Parent->ChildArea,o->Parent->Absolute.a);
	  RectMove(&o->Absolute,o->Relative,Tmp.a);
	 	if ( RectOverlay(o->Absolute,o->Parent->ChildDrawAbs) ) {
	 		RectIntersept(&o->DrawAbsolute,o->Absolute,o->Parent->ChildDrawAbs); // It can have a part out of it owner !!!
		} else {
			RectAssign(&o->DrawAbsolute,0,0,-1,-1);
		}
	 }

	RectMove(&Tmp,o->ChildArea,o->Absolute.a);
	RectIntersept(&o->ChildDrawAbs,Tmp,o->DrawAbsolute); // It can have a part out of it owner !!!

	if ( o->Last ) {
    PWidget a = o->Last;
    PWidget b = a;
    if ( a ) do {
      WidgetRefreshAbsolutePos(a);
      a = a->Next;
    } while ( a != b );
  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetRefreshAbsolutePosEx ( PWidget o ) {
	TRect Tmp;
	if ( o->Parent ) {
		RectMove(&Tmp,o->Parent->ChildArea,o->Parent->Absolute.a);
	  RectMove(&o->Absolute,o->Relative,Tmp.a);
	 	if ( RectOverlay(o->Absolute,o->Parent->ChildDrawAbs) ) {
	 		RectIntersept(&o->DrawAbsolute,o->Absolute,o->Parent->ChildDrawAbs); // It can have a part out of it owner !!!
		} else {
			RectAssign(&o->DrawAbsolute,0,0,-1,-1);
		}
	 }

	RectMove(&Tmp,o->ChildArea,o->Absolute.a);
	RectIntersept(&o->ChildDrawAbs,Tmp,o->DrawAbsolute); // It can have a part out of it owner !!!

}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetChildArea( PWidget o, TRect r ) {
	o->ChildArea = r;
	WidgetRefreshAbsolutePos(o);

}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetRect ( PWidget o, TRect r ) {
	TRect p = o->ChildArea;

	o->ChildArea.b.x = r.b.x-r.a.x-o->Relative.b.x+o->ChildArea.b.x+o->Relative.a.x;
	o->ChildArea.b.y = r.b.y-r.a.y-o->Relative.b.y+o->ChildArea.b.y+o->Relative.a.y;
	o->Relative = r;

	WidgetRefreshAbsolutePosEx(o);

	  if ( o->Last ) {
	    PWidget a = o->Last;
	    PWidget b = a;
	    r = o->ChildArea;
	    do {
	     	if ( a->Flags & WF_AUTORESIZE ) {
		    	TRect n = a->Relative;
		     	if ( a->Flags & WF_MAGNETRIGHT ) {
			     	if ( a->Flags & WF_FIXEDWIDTH ) n.a.x -= p.b.x-o->ChildArea.b.x;
			     	n.b.x -= p.b.x-o->ChildArea.b.x;
		     	}
		     	if ( a->Flags & WF_MAGNETBOTTOM ) {
			     	if ( a->Flags & WF_FIXEDHEIGHT ) n.a.y -= p.b.y-o->ChildArea.b.y;
			     	n.b.y -= p.b.y-o->ChildArea.b.y;
		     	}
		     	WidgetSetRect(a,n);
		     	WidgetSendSEvent(a,EV_MESSAGE,MSG_NOTIFY_AUTO_RESIZE,NULL);
	    	} else
	    		WidgetRefreshAbsolutePos(a);
	      a = a->Next;
	    } while ( a != b );
	  }
}
////////////////////////////////////////////////////////////////////////////////
void WidgetMove ( PWidget o, l_long dX, l_long dY ) {
  TRect r = o->Relative;
  TRect t = o->DrawAbsolute;
	r.a.x += dX; r.a.y += dY;
	r.b.x += dX; r.b.y += dY;
  WidgetSetRect(o,r);
  WidgetDrawAll(o);
  WidgetDrawOnRect(o->Parent,t,o);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetMoveToPoint ( PWidget o, l_int x, l_int y ) {
	WidgetMove(o,x-o->Relative.a.x,y-o->Relative.a.y);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetMetrics ( PWidget o, l_int x, l_int y, l_int w, l_int h ){
	TRect r = o->Relative;
	TRect t = o->DrawAbsolute;
	r.a.x = x;
	r.a.y = y;
	r.b.x = w;
	r.b.y = h;
	WidgetSetRect(o, r);
	WidgetDrawAll(o);
	WidgetDrawOnRect(o->Parent, t, o);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetResize ( PWidget o, l_long dW, l_long dH ) {
  TRect r = o->Relative;
  TRect t = o->DrawAbsolute;
	r.b.x += dW; r.b.y += dH;
  WidgetSetRect(o,r);
  WidgetDrawAll(o);                // To be optimized
  WidgetDrawOnRect(o->Parent,t,o); //
}
////////////////////////////////////////////////////////////////////////////////
void WidgetResizeToSize ( PWidget o, l_long SizeX, l_long SizeY ) {
	TRect r = o->Relative;
	TRect t = o->DrawAbsolute;
	r.b.x = o->Absolute.a.x + SizeX;
	r.b.y = o->Absolute.a.y + SizeY;
	WidgetSetRect(o, r);
	WidgetDrawAll(o);                // To be optimized
	WidgetDrawOnRect(o->Parent, t, o);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetPreCenter ( PWidget o ) {
	TRect r = o->Relative;
	TRect rr = o->Parent->ChildArea;
	l_long w = r.b.x - r.a.x, h = r.b.y - r.a.y;
	l_long ww = rr.b.x - rr.a.x, hh = rr.b.y - rr.a.y;
	o->Relative.a.x = (ww-w)/2;
	o->Relative.a.y = (hh-h)/2;
	o->Relative.b.x = o->Relative.a.x+w;
	o->Relative.b.y = o->Relative.a.y+h;
	WidgetRefreshAbsolutePos(o);
}
////////////////////////////////////////////////////////////////////////////////
// Event related
////////////////////////////////////////////////////////////////////////////////
l_bool WidgetSendEventEx ( PWidget o, TEvent Ev ) {

	//DebugMessage("%x :: %d %x",o,Ev.Type,Ev.Message);

	if ( ( o->Flags & WFExecuting ) && Ev.Type == EV_MESSAGE ) {
		DebugMessage("Catch message( %x, %x )",o,Ev.Message);
	  o->MessageBuffer = Ev.Message;
	  return true;
  }

  if ( o->AppEvHdl )
    if ( o->AppEvHdl(o,&Ev) ) return true;

	if ( o->EventHandler )
	  if ( o->EventHandler(o,&Ev) ) return true;

  return false;
}
////////////////////////////////////////////////////////////////////////////////
/* ** Due to unknown threading bugs, this section is unactivated **

	void WidgetRedirectEvent ( void *Dest, PDynLdEvent Ev ) {
  if ( !WidgetSendEventEx(WIDGET(Dest), Ev->Ev ) ) {

	  if ( WIDGET(Dest)->Parent && ( Ev->Ev.Type != EV_MOUSE ) )
	    WidgetSendEvent( WIDGET(Dest)->Parent, Ev->Ev );
  }
}
*/
////////////////////////////////////////////////////////////////////////////////
l_bool WidgetSendEvent ( PWidget o, TEvent Ev ) {
	/* ** Due to unknown threading bugs, this section is unactivated **
  if ( o->AppOwner ) {
		if ( o->AppOwner->Type == DYNLD_TYPEAPP ) { // Only App can handle events, Dl and old style programs can't
	    AppSendEventEv( o->AppOwner, Ev, o, &WidgetRedirectEvent );
	    return true;
    }
  }*/

	if ( WidgetSendEventEx(o,Ev) ) return true;
	if ( o->Parent && ( Ev.Type != EV_MOUSE ) && !( (Ev.Type == EV_MESSAGE) && (Ev.Message == MSG_NOTIFY_AUTO_RESIZE) )  )
	  return WidgetSendEvent( o->Parent, Ev );
	else
    return false;
}
////////////////////////////////////////////////////////////////////////////////
l_bool WidgetSendPEvent ( PWidget o, PEvent Ev ) {
	l_bool r = WidgetSendEvent(o,*Ev);
	free(Ev);
	return r;
}
////////////////////////////////////////////////////////////////////////////////
l_bool WidgetSendEEvent ( PWidget o, l_int Type, l_ulong Message, void *Extra, TKeybState  Keyb, TMouseState Mouse ) {
	TEvent Ev;
	Ev.Type = Type;
	Ev.Message = Message;
	Ev.Extra = Extra;
	Ev.Keyb = Keyb;
	Ev.Mouse = Mouse;
	return WidgetSendEvent(o,Ev);
}
////////////////////////////////////////////////////////////////////////////////
l_bool WidgetSendSEvent ( PWidget o, l_int Type, l_ulong Message, void *Extra ) {
	TEvent Ev;
	Ev.Type = Type;
	Ev.Message = Message;
	Ev.Extra = Extra;
	Ev.Keyb = KState;
	Ev.Mouse = Mouse->State;
	return WidgetSendEvent(o,Ev);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetFocusExNoNotify ( PWidget o ) {
	if ( o->FocusBack ) o = o->FocusBack;
	if ( o->Flags & WFFocusable ) {
		if ( FocusedWidget ) FocusedWidget->Flags &=~ WFFocused;
		o->Flags |= WFFocused;
		FocusedWidget = o;
	}
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetFocusEx ( PWidget o ) {
	if ( o->FocusBack ) o = o->FocusBack;
	if ( o->Flags & WFFocusable ) {
		PWidget Old = FocusedWidget;
		if ( FocusedWidget ) FocusedWidget->Flags &=~ WFFocused;
		o->Flags |= WFFocused;
		FocusedWidget = o;
		if ( Old )
			WidgetSendSEvent(Old,EV_MESSAGE,WEvNotifyLostFocus,NULL);
	}
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSetFocus ( PWidget o ) {

	if ( o->FocusBack ) o = o->FocusBack;
	if ( FocusedWidget == o ) return;

	if ( o->Flags & WFFocusable )
	{
		WidgetSetFocusEx(o);

		if ( FocusedWidget )
			WidgetSendSEvent(FocusedWidget,EV_MESSAGE,WEvNotifyFocused,NULL);
	}
	else
	{
		if ( o->Parent )
			WidgetSetFocus(o->Parent);
		else if ( FocusedWidget )
			WidgetSendSEvent(FocusedWidget,EV_MESSAGE,WEvNotifySameFocus,NULL);
	}
}
////////////////////////////////////////////////////////////////////////////////
void WidgetSelect ( PWidget o ) {

	if ( o->Flags & WFSelectable && !(o->Flags & WFSelected) )
	{
		o->Flags |= WFSelected;
		WidgetSendSEvent(o,EV_MESSAGE,WEvNotifySelect,NULL);
	}

	if ( o->Parent )
	{
		PWidget a = o->Parent->Last;
		PWidget b = a;

		if ( a )
		do
		{
			if ( (a != o) && (a->Flags & WFSelected) && (a->Flags & WFSelectable) )
			{
				a->Flags &= ~WFSelected;
				WidgetSendSEvent(a,EV_MESSAGE,WEvNotifyUnSelect,NULL);
			}

			a = a->Next;
		}
		while ( a != b );

		WidgetSelect(o->Parent);
	}
}
////////////////////////////////////////////////////////////////////////////////
void WidgetUnSelectAllSubs ( PWidget o ) {
	if ( o->Last ) {
    PWidget a = o->Last;
    PWidget b = a;
    if ( a ) do {
      if ( a->Flags & WFSelected && a->Flags & WFSelectable  ) {
	      a->Flags &= ~WFSelected;
      	//if (  )
      		WidgetSendSEvent(a,EV_MESSAGE,WEvNotifyUnSelect,NULL);
    	}
      a = a->Next;
    } while ( a != b );
	}
}
////////////////////////////////////////////////////////////////////////////////
_PRIVATE void  WidgetEventHandler ( PEvent Event )
{
	/**
	*	Mouse event
	*/
	if ( Event->Type == EV_MOUSE )
	{
    	PWidget OldTopWidget = TopWidget;

    	if ( MasterWidget )
			TopWidget = MasterWidget;
		else
			TopWidget = GetTopWidgetUnderMouse();

		if ( OldTopWidget != TopWidget )
		{
			LastMouseMove = ATime;
			if ( OldTopWidget )
				WidgetSendSEvent(OldTopWidget,EV_MOUSE,WEvMouseLeft,NULL);

			WidgetSendSEvent(TopWidget,EV_MOUSE,WEvMouseEnter,NULL);
		}

		if ( WidgetSendEventEx )
		{
			if ( Event->Message )
			{
				WidgetSendSEvent(TopWidget,EV_MOUSE,Event->Message,NULL);
			}

			if ( Mouse->Moved )
			{
				LastMouseClickRight = 0;
				LastMouseClickMiddle = 0;
				LastMouseClickLeft = 0;
				LastMouseMove = ATime;
				WidgetSendSEvent(TopWidget,EV_MOUSE,WEvMouseMove,NULL);
			}

			if ( Mouse->ButtonChanges )
			{
				if ( ((Mouse->ButtonChanges & BUTTON_LEFT) && (Mouse->State.b & BUTTON_LEFT)) || ((Mouse->ButtonChanges & BUTTON_RIGHT) && (Mouse->State.b & BUTTON_RIGHT)) )
				{
					WidgetSetFocus(TopWidget);
					WidgetSelect(TopWidget);
				}

				if ( !TopWidget ) return;

				// Left mouse down [X| | ]
				if ( (Mouse->ButtonChanges & BUTTON_LEFT) && (Mouse->State.b & BUTTON_LEFT) )
				{
					if (ATime-LastMouseClickLeft  <= DoubleClickSpeed)
					{
						if ( WidgetSendSEvent(TopWidget,EV_MOUSE, WEvMouseLDClk, NULL) ) return;
					}
					else LastMouseClickLeft = ATime;

					if ( WidgetSendSEvent(TopWidget,EV_MOUSE, WEvMouseLDown, NULL) ) return;
				}

				// Middle mouse down [ |X| ]
				if ( (Mouse->ButtonChanges & BUTTON_MIDDLE) && (Mouse->State.b & BUTTON_MIDDLE) )
				{
					if (ATime-LastMouseClickMiddle  <= DoubleClickSpeed)
					{
						if ( WidgetSendSEvent(TopWidget,EV_MOUSE, WEvMouseMDClk, NULL) ) return;
					}
					else LastMouseClickMiddle = ATime;

					if ( WidgetSendSEvent(TopWidget,EV_MOUSE, WEvMouseMDown, NULL) ) return;
				}

				// Right mouse down [ | |X]
				if ( (Mouse->ButtonChanges & BUTTON_RIGHT) && (Mouse->State.b & BUTTON_RIGHT) )
				{
					if (ATime-LastMouseClickRight  <= DoubleClickSpeed)
					{
						if ( WidgetSendSEvent(TopWidget,EV_MOUSE, WEvMouseRDClk, NULL) ) return;
					}
					else LastMouseClickRight = ATime;

					if ( WidgetSendSEvent(TopWidget,EV_MOUSE, WEvMouseRDown, NULL) ) return;
				}

				// Left mouse up/click [X| | ]

				if ( (Mouse->ButtonChanges & BUTTON_LEFT) && !(Mouse->State.b & BUTTON_LEFT) )
					if ( WidgetSendSEvent(TopWidget,EV_MOUSE,WEvMouseLUp,NULL) ) return;

				// Middle mouse up/click [ |X| ]
				if ( (Mouse->ButtonChanges & BUTTON_RIGHT) && !(Mouse->State.b & BUTTON_RIGHT) )
					if ( WidgetSendSEvent(TopWidget,EV_MOUSE,WEvMouseRUp,NULL) ) return;

				// Right mouse up/click [ | |X]
				if ( (Mouse->ButtonChanges & BUTTON_MIDDLE) && !(Mouse->State.b & BUTTON_MIDDLE) )
					if ( WidgetSendSEvent(TopWidget,EV_MOUSE,WEvMouseMUp,NULL) ) return;

			}
		}
	}

	/**
	*	Keyboard event
	*/
	if ( Event->Type == EV_KEYBOARD )
	{
		if (!FocusedWidget) return;

		WidgetSendEvent(FocusedWidget, *Event);
	}
}
////////////////////////////////////////////////////////////////////////////////
// Widget Unitilisation
////////////////////////////////////////////////////////////////////////////////
void FreeWidget ( PWidget o ) {
	if ( o->FreeEx ) o->FreeEx(o);
	if ( o->Name ) free(o->Name);
	free(o);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDisposeEx ( PWidget o ) {
	if ( TopWidget == o )    TopWidget = NULL;
	if ( MasterWidget == o )  MasterWidget = NULL;
	if ( FocusedWidget == o ) FocusedWidget = NULL;
	if ( LookFor ) if ( *LookFor == o ) *LookFor = NULL;

	if ( o->Last )
	{
		PWidget a = o->Last;
		PWidget b = a, n;

		do
		{
			n = a->Next;
			WidgetDisposeEx(a);
			a = n;
		} while ( a != b );
	}

	FreeWidget(o);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetDispose ( PWidget o ) {
	if ( !o ) return;
	if ( o->Parent )
		RemoveWidget(o->Parent,o);
	WidgetDisposeEx(o);
}
////////////////////////////////////////////////////////////////////////////////
void WidgetMakeSync ( PWidget *o ) {
	LookFor = o;
}
////////////////////////////////////////////////////////////////////////////////
void WidgetUnMakeSync ( PWidget *o ) {
	LookFor = NULL;
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
l_ulong WidgetExecute ( PWidget o ) {
	l_char Done = 0;
	l_ulong Msg = 0;
	if ( o->Flags & WFExecuting ) return 0;

	/* ** Due to unknown threading bugs, this section is unactivated **
  if ( o->AppOwner ) {
		if ( o->AppOwner->Type == DYNLD_TYPEAPP ) {
      TDynLdEvent Ev = {0,0,0,0,0};
      if ( o->AppOwner->ThreadId != ThreadId() ) DebugError("PANIC :: WidegtExecute called by non-widget owner");
		  while ( AppGetNextEvent(o->AppOwner,&Ev) ) {
			  if ( Ev.Ev.Type == EV_MESSAGE && Ev.Dest == o ) {
			    return Ev.Ev.Message;
		    } else {
	        AppRedirectEvent(o->AppOwner,&Ev);
	        Yield();
        }
      }
      // Application has recieved exit message, but we deleted it, so we resend it
      AppSendEvent(o->AppOwner,EV_MESSAGE,MSG_KILLAPP,NULL,NULL,NULL);
      return 0;
		}
  }*/

	o->Flags |= WFExecuting;

	DebugMessage("Executing %x",o);
	while ( !o->MessageBuffer ) {
		/*PollEvents();
		Yield();*/
		SysPoll();
  }
	o->Flags &= ~WFExecuting;

	DebugMessage("Return Message %x",o->MessageBuffer);
	Msg = o->MessageBuffer;
	o->MessageBuffer = 0;
  return Msg;
}
////////////////////////////////////////////////////////////////////////////////
// Widget Initialisation
////////////////////////////////////////////////////////////////////////////////
PWidget IntialiseWidget ( PApplication App, PWidget o, TRect r, l_text Name ) {

	if ( !o ) return NULL;

	o->Relative			= r;
	o->Absolute			= r;
	RectAssign(&o->ChildArea,0,0,r.b.x-r.a.x,r.b.y-r.a.y);
	o->ChildDrawAbs		= r;
	o->DrawAbsolute		= r;
	//RectAssign(&o->SizeLimits,0,0,0,0);
	o->Name				= TextDup(Name);
	o->Flags			= WFVisible;
	o->AppOwner			= App;

	o->Refresh			= &WidgetRefresh;

	o->Remove = &WidgetRemove;
	o->Insert = &WidgetInsert;
	o->SetFirstEx =	&WidgetSetFirstEx;
	return o;
}
////////////////////////////////////////////////////////////////////////////////
PWidget NewWidget ( PApplication App, TRect r, l_text Name )
{
	PWidget o = (PWidget)malloc(sizeof(TWidget));
	memset(o,0,sizeof(TWidget));
	o =IntialiseWidget(App, o, r, Name);
	return o;
}
////////////////////////////////////////////////////////////////////////////////
void SwitchTextMode ( void ) {
	if ( buffer ) { destroy_bitmap(buffer); buffer = NULL; }
	__MouseStop();
	__KeyboardStop();
	__ScreenTextMode();
}
////////////////////////////////////////////////////////////////////////////////
void SwitchGraphicsMode ( void ) {

	__ScreenRestartGraphics();
	__KeyboardRestart();
	__MouseRestart();
	buffer = create_system_bitmap(GSScreenWidth, GSScreenHeight);
	WidgetDrawAll(DeskTop);
  	MouseShow();
}
////////////////////////////////////////////////////////////////////////////////
PWidget StartMask;

void StartMaskDraw ( PWidget o, p_bitmap buffer, PRect w )
{
	blit(StartLogo, buffer, w->a.x-StartRect.a.x, w->a.y-StartRect.a.y, w->a.x, w->a.y, w->b.x-w->a.x+1, w->b.y-w->a.y+1);
}
////////////////////////////////////////////////////////////////////////////////
void DisposeStartupLogo ( void ) {
	WidgetDispose(StartMask);
	destroy_bitmap(StartLogo);
	StartLogo = NULL;
}
////////////////////////////////////////////////////////////////////////////////
void WidgetInit ( void )
{
	TRect r;
	AlphaAllow = KeyGetInt("/SYSTEM/WIDGET/ALPHAALLOW",false);
	if ( GSScreenDepth < 15 ) AlphaAllow = false;
	OSDColor = GetColorFromHex(KeyGetText("/USER/COLOR/OSD", "888888"));
	RectAssign(&r,0,0,GSScreenWidth-1,GSScreenHeight-1);
	DeskTop = NewWidget(&Me, r,"desktop");
	StartMask = NewWidget(&Me, StartRect,"StartMask");
	StartMask->Draw = &StartMaskDraw;
	InsertWidget(DeskTop,StartMask);
	WidgetDraw(DeskTop,NULL);
	OSD = 0;
	set_mouse_range(DeskTop->Absolute.a.x,DeskTop->Absolute.a.y,DeskTop->Absolute.b.x,DeskTop->Absolute.b.y);
	InstallEventHandler(WidgetEventHandler);
}
////////////////////////////////////////////////////////////////////////////////
PTimer DelayMouseOverTimerId;
void DelayMouseOverTimer ( void *Arg ) {
	if ( LastNotified != LastMouseMove && ATime-LastMouseMove >= 200 ) {
		LastNotified = LastMouseMove;
		if ( TopWidget ) WidgetSendSEvent(TopWidget,EV_MOUSE,WEvMouseEnterDelay,NULL);
	}
}
////////////////////////////////////////////////////////////////////////////////
l_bool LibMain (l_text Args)
{
	buffer = create_system_bitmap(GSScreenWidth, GSScreenHeight);
	if ( !buffer )
	{
		DebugError("Widget :: Could not init double buffer, disabling widgets");
		return false;
	}
	clear_bitmap(buffer);

	WidgetInit();

	LastMouseMove = ATime;
	LastNotified  = ATime;
	DelayMouseOverTimerId = NewTimer(&Me, 50, &DelayMouseOverTimer, NULL);

	APPEXPORT(DeskTop);
	APPEXPORTAS(DeskTop, "Desktop");

	APPEXPORT(IntialiseWidget);
	APPEXPORT(WidgetInsert);
	APPEXPORT(WidgetRemove);
	APPEXPORT(NewWidget);
	APPEXPORT(WidgetDrawOnRect);
	APPEXPORT(WidgetMove);
	APPEXPORT(WidgetSetOSDRect);
	APPEXPORT(WidgetUnOSD);
	APPEXPORT(MasterWidget);
	APPEXPORT(WidgetResize);
	APPEXPORT(WidgetResizeToSize);
	APPEXPORT(WidgetMoveToPoint);
	APPEXPORT(WidgetSetMetrics);
	APPEXPORT(WidgetSetFirstEx);

	APPEXPORT(WidgetSendEvent);
	APPEXPORT(WidgetDispose);
	APPEXPORT(WidgetDrawAll);
	APPEXPORT(WidgetExecute);
	APPEXPORT(WidgetSetFirst);

	APPEXPORT(WidgetSetFocusEx);
	APPEXPORT(WidgetSetFocus);
	APPEXPORT(FocusedWidget);

	APPEXPORT(WidgetPreCenter);

	APPEXPORT(WidgetUnMakeSync);
	APPEXPORT(WidgetMakeSync);

	APPEXPORT(WidgetSetChildArea);
	APPEXPORT(WidgetSendPEvent);
	APPEXPORT(DisposeStartupLogo);
	APPEXPORT(WidgetSetRect);
	APPEXPORT(WidgetSetFocusExNoNotify);


	APPEXPORT(WidgetDraw);
	APPEXPORT(WidgetSendSEvent);
	APPEXPORT(WidgetSendEEvent);

	APPEXPORT(SwitchGraphicsMode);
	APPEXPORT(SwitchTextMode);

	return true;
}

void Close (void)
{
	KillTimer(DelayMouseOverTimerId);

	/**
	 * Dont handle events when the system is unloaded
	 */
	RemoveEventHandler(WidgetEventHandler);

	if ( buffer ) destroy_bitmap(buffer);

	WidgetDisposeEx(DeskTop);
}
