;	Copyright 1993-2022, Jerome Shidel.
;
;	This project and related files are subject to the terms of the Mozilla
; Public License, v. 2.0. If a copy of the MPL was not distributed with this
; file, You can obtain one at http://mozilla.org/MPL/2.0/.
;
; v2.00 - Ported from Ancient Turbo Pascal Version to NASM

use16

cpu 8086

org 0x100

%include 'MACROS.ASM'

	StdOutStr   	Text_Title
	StdOutStr   	Text_Copyright
	StdOutStr   	Text_Version
	MIXER_GetVersion
	StdOutIntByte	ah
	StdOutChar		'.'
	StdOutIntByte	al
	StdOutCRLF

	push			ds
	GetEnvStr		String_Blaster	; if VAR not found, points to NULL and CF
	ParseStr		Opts_Blaster, si
	pop				ds

	ParseStr		Opts_CommandLn, PSP_CMDLN

	StdOutCRLF

StatusDisplay:
	mov				si, StatusTypes
	cld
.Display:
	mov				cx, 0x0e
	lodsb
	test			al, al
	jz				.Done
.PrintStr:
	dec				cx
	StdOut			al
	lodsb
	test			al, al
	jnz				.PrintStr
	lodsw
	push			ax  ; pop later as di
	cmp				ax, 0x01
	ja				.NotVolume
	StdOutStr		Text_Volume
	sub				cx, 7
.NotVolume:
	StdOut			0x3a
	mov				dl, 0x20
	cmp				cx, 0x10
	ja				.NoPadding
.PrintPadding:
	int				0x21
	loop			.PrintPadding
.NoPadding:
	lodsb
	xor				ah, ah
    MIXER_CALL 		SBPMixer
	pop				di 	; was pushed as ax
	jc				.ResultError
	cmp				di, 0x0002
	ja				.ResultLookup
	cmp				di, 0x0001
	ja				.ResultHexWord
	jb				.ResultMono
	cmp				al, ah
	je				.ResultMono
	StdOutStr		Text_Left
	StdOutIntByte	ah
	StdOutStr		Text_Right
	StdOutIntByte	al
	jmp				.ResultDone
.ResultMono:
	StdOutIntByte	al
	jmp				.ResultDone
.ResultHexWord:
	StdOutStr		Text_HexWord
	StdOutHexWord	ax
	jmp				.ResultDone
.ResultLookup:
	mov				cx, ax
	mov				dx, ax
.FindLoop:
	mov				al, [di]
	test			al, al
	jz				.ResultUnknown
	test			cx, cx
	jz				.FindFound
.FindSearch:
	mov				al, [di]
	inc				di
	test			al, al
	jnz				.FindSearch
	dec				cx
	jmp				.FindLoop
.FindFound:
	StdOutStr		di
	jmp				.ResultDone
.ResultUnknown:
	StdOutStr		Text_Unknown
	StdOutHexWord	dx
.ResultDone:
	StdOutCRLF
	jmp				.Display
.ResultError:
	StdOutStr		Text_Error
	StdOutCRLF
	jmp				.Display

.Done:

	Terminate		0

Opts_Blaster:
	mov				al, [si]
	LowerCaseChar	al
	cmp				al, 'a'	; Is BASE PORT option
	jne				.Ignore
	dec				cx
	inc				si
	LenStrHexToWord	cx, si
	jc				.Ignore
	MIXER_SetBasePort ax
.Ignore:
	ret

Opts_CommandLn:
	mov				di, SettingTypes
	mov				ax, [si]
	cmp				al, '/'
	jne				.ReadValue
	mov				bx, [di+1]			; when a switch, reset to MASTER Volume
	mov				[SettingMode], bx
	cmp				cx, 1
	je				.InvalidSwitch
	UpperCaseChar	ah
.FindSwitch:
	mov				bx, [di]
	add				di, 2
	test			bl, bl
	jz				.InvalidSwitch
	cmp				bl, ah
	je				.FoundSwitch
	inc				di
	jmp				.FindSwitch
.FoundSwitch:
	mov				bl, [di]
	test			bh, bh
	jnz				.ProcessLater
	mov				ax, bx
	test			al, al
	jz				ShowHelp
	xor				ah, ah
    MIXER_CALL 		SBPMixer
	jmp				.Done

.ProcessLater:
	mov				[SettingMode], bx
	jmp				.Done

.ReadValue:
	xor				bx, bx
.FindComma:
	mov				al, [si+bx]
	cmp				al, 0x2c
	je				.HasComma
	cmp				bx, cx
	je				.NoComma
	inc				bx
	jmp				.FindComma

.HasComma:
	LenStrToWord	bx, si
	jc				.InvalidSwitch
	mov				dx, ax
	sub				cx, bx
	add				si, bx
	inc				si
	dec				cx
	LenStrToWord	cx, si
	jc				.InvalidSwitch
	mov				ah, dl
	mov				bx, ax
	mov				ax, [SettingMode]
	jmp				.SetValue

.NoComma:
	LenStrToWord	cx, si
	jc				.InvalidSwitch
	mov				bx, ax
	mov				ax, [SettingMode]
	cmp				ah, 2
	jb				.SetValue		; 1=As Is
	mov				bh, bl
	je				.SetValue		; 2=Both channels the same
	xor				bh, bh			; 3=Mono value

.SetValue:
	xor				ah, ah
	; StdOutHexWord	ax
	; StdOutChar		'/'
	; StdOutHexWord	bx
	; StdOutCRLF
	; mov				cx, bx
    MIXER_CALL 		SBPMixer
.Done:
	ret
.InvalidSwitch:
	stc
	ret

ShowHelp:
	StdOutCRLF
	StdOutStr		Text_Help
	; Program Terminated in PROCS.ASM

%include 'PROCS.ASM'

String_Blaster:
	db 		'BLASTER',0

Text_Title:
	db		'Sound Blaster Pro Mixer Chip Interface',13,10,0
Text_Copyright:
	db		'Copyright (c) 1993-2022 Jerome Shidel',13,10,0
Text_Version:
	db		'Version',0x20,0
Text_Volume:
	db		0x20,'Volume',0
Text_Left:
	db		'L',0
Text_Right:
	db		0x20, '/', 0x20, 'R', 0
Text_Unknown:
	db		'?', 0x20
Text_HexWord:
	db		'0', 'x',0
Text_Error:
	db		'Error',0

StatusTypes:
	db		'Base Port',0
	dw 		2
	db		0x01
	db		'Master',0
	dw		1
	db		0x10
	db		'Voice',0
	dw		1
	db		0x11
	db		'Line',0
	dw		1
	db		0x17
	db		'FM',0
	dw		1
	db		0x12
	db		'CD',0
	dw		0
	db		0x13
	db		'MIC',0
	dw		0
	db		0x14
	db		'FM Steering',0
	dw		StatusSteerFM
	db		0x15
	db		'FM Mode',0
	dw 		StatusModeFM
	db		0x16
	db		'ADC Channel',0
	dw		StatusADC
	db		0x18
	db		'ADC Filter',0
	dw		StatusFilter
	db		0x19
	db 		'ANFI Filter',0
	dw		StatusBool
	db		0x1A
	db 		'DNFI Filter',0
	dw		StatusBool
	db		0x1B
	db 		0

StatusSteerFM:
	db		'No Steering',0
	db		'Steer Left',0
	db		'Steer Right',0
	db		'Mute',0
	db 		0

StatusModeFM:
	db		'Mono',0
	db		'Stereo',0
	db		0

StatusADC:
	db 		'Microphone',0
	db 		'CD',0
    db		'(reserved)',0
    db 		'Line',0
	db		0

StatusFilter:
	db		'Low',0
	db		'High',0
	db		0

StatusBool:
	db		'off',0
	db		'On',0
	db		0

SettingTypes:
	db		'M',2,0x04		; Master Volume
	db 		'?',0,0x00		; Display Help
	db		'R',0,0x03		; Reset
	db		'B',1,0x02		; Base Port
	db		'V',2,0x05		; Voice Volume
	db		'F',2,0x06		; FM Volume
	db		'C',2,0x07		; CD Volume
	db		'L',2,0x0b		; Line Volume
	db		'I',3,0x08		; Mic Volume

	db		'S',1,0x09		; FM Channel Steering
	db		'O',1,0x0A		; FM Mono/Stereo Mode
	db		'A',1,0x0C		; ADC Source Channel
	db		'N',1,0x0D		; ADC Filter Low,High
	db		'E',1,0x0E		; ANFI Filter on/off
	db		'D',1,0x0F		; DNFI Filter on/off

	db		0

SettingMode:
	dw		0x0204 ; default Master Volume

Text_Help:
	db 	'usage: SBPMIXER [options]',13,10
	db	13,10
	db	9,'/?',9,'Display help',13,10
	db	9,'/R',9,'Reset mixer chip',13,10
	db	9,'/B n',9,'Override base port, like /B 0x0220',13,10
	db	13,10
	db	9,'/M v',9,'Master volume (0-15[,0-15])',13,10
	db	9,'/V v',9,'Voice volume',13,10
	db	9,'/F v',9,'FM volume',13,10
	db	9,'/C v',9,'CD volume',13,10
	db	9,'/L v',9,'Line volume',13,10
	db	9,'/I v',9,'Microphone volume',13,10
	db	13,10
	db	9,'/S n',9,'FM Steering (0-3)',13,10
	db	9,'/O n',9,'FM Mode (0/1)',13,10
	db	9,'/A n',9,'ADC Source (0,1,3)',13,10
	db	9,'/N n',9,'ADC Filter (0/1)',13,10
	db	9,'/E n',9,'ANFI Filter (0/1)',13,10
	db	9,'/D n',9,'DNFI Filter (0/1)',13,10
	db	13,10
	db 	0
