
;                     CAL.S    1.07    08/12/1998
;                     Copyright 1998, Charles Dye
;                     email: raster@highfiber.com
;
;     This is source for Eric Isaacson's shareware assembler, A86.
;     Re-assemble by typing  A86 CAL.S
;
;     This program is copyrighted, but freeware.  You may freely use
;     and distribute unmodified copies of this program, with or without
;     the source.


radix 16                               ; gentlemen prefer hex


doscall macro                          ; call to dos int_21 with a
mov ah,#1                              ; one-byte function in ah
int 21
#em

doscall2 macro                         ; call to dos int_21 with a
mov ax,#1                              ; two-byte function in ax
int 21
#em

dosprint macro                         ; call to dos string-print function
mov dx,offset #1
mov ah,09
int 21
#em

zero macro                             ; zero a register
xor #1,#1
#em


;     assembly options :

;  un-comment the next line to make monday the first day of the week :
;  monday    equ  1

;  un-comment the next line to remove the asterisk marking today's date :
;  no_splat  equ  1

;  un-comment the next line to prevent expanding years 00-99 to 2000-2099 :
;  no_2dig   equ  1

;  un-comment the next line to prevent pausing year calendar after june :
;  no_pause  equ  1


;     uninitialized variables :

julian_lo    equ  005e                 ; total number of days since
julian_hi    equ  0060                 ; december 31, 1752   (two words)

cal1         equ  0064                 ; temp storage for year-calendar
                                       ; print routine   (three bytes)

today        equ  0067                 ; today's date (byte)

month        equ  0068                 ; 1 = january, 12 = december (word)

year         equ  006a                 ; 1800 through 2199 (word)


;     start of code :

begin:
doscall 2a                             ; get date from dos
#if !no_splat
mov b [today],dl                       ; remember today's date
#endif
mov w [year],cx                        ; use current year as default
mov dl,dh
mov dh,00                              ; convert month to a word value
mov w [month],dx                       ; and use it as default
call parse                             ; read the command line
mov ax,w [year]
cmp ax,01753xd                         ; any year less than 1753
jb val_yx                              ; is an error
cmp ax,02399xd                         ; any year above 2399
ja val_yx                              ; is an error
mov ax,w [month]
cmp ax,0001                            ; any month below 1
jb val_mx                              ; is an error
cmp ax,000c                            ; any month above 12
ja val_mx                              ; is an error
call print_cal                         ; display calendar
int 20                                 ; and exit

val_yx:                                ; bad year --
mov dx,offset msg_year_bad             ; point to bad-year error message
jmp short val_2                        ; and skip ahead
val_mx:                                ; bad month --
mov dx,offset msg_month_bad            ; point to bad-month error message
val_2:
doscall 09                             ; print error message
int 20                                 ; and exit

parse:                                 ; read the user's command line:
mov si,0081                            ; start of command line
call skip_junk                         ; skip over any leading spaces
call test_digit                        ; is next character a digit?
je parse_cal                           ; if so, get user's value(s)
cmp bl,0d                              ; end of line?  if so, exit
jbe ret                                ; otherwise fall through to ....

syntax:                                ; syntax error:
dosprint msg_syntax                    ; print an error message
int 20                                 ; and exit

parse_cal:                             ; get calendar month and year values:
#if !no_splat
mov b [today],00                       ; forget today's date
#endif
call get_num                           ; get first user value
jc ret                                 ; any error, exit (use defaults)
mov w [month],ax                       ; save first value as month
call skip_junk                         ; and skip over any separator chars
call get_num                           ; get second value
jnc > l4                               ; save second value as year and exit
                                       ; only one value on command line :
dec b [flags]                          ; note full-year calendar
mov ax,w [month]                       ; change month to 1 (january]
mov w [month],0001                     ; and move first value into the year
l4:
#if !no_2dig
cmp ax,0100xd
jae > l5
add ax,02000xd
l5:
#endif
mov w [year],ax
ret                                    ; and exit

is_junk:                               ; junk that needs to be skipped ....
inc si                                 ; ignore it and fall through

skip_junk:                             ; skip past any separator characters:
mov al,b [si]                          ; examine next char on command line
cmp al,20                              ; space?
je is_junk                             ; skip over spaces
cmp al,'/'                             ; slash?
je is_junk                             ; skip over slashes
cmp al,'-'                             ; minus?
je is_junk                             ; skip over minuses
                                       ; anything else should not be ignored
                                       ; so fall through to exit
get_num_bad:
stc
ret

get_num:                               ; parse number from command line:
zero ax                                ; start with a value of zero
mov cx,000a                            ; ten, used for multiplications
call test_digit                        ; is the first character a digit?
jne get_num_bad                        ; if not, return error
l1:                                    ; number-parsing loop:
call test_digit                        ; is next character a digit?
jne get_num_okay                       ; if not, done parsing number; exit
inc si                                 ; if so, accept digit
sub bl,'0'                             ; convert ascii to value 0 - 9
mov bh,00                              ; 2-byte value
mul cx                                 ; multiply working value by ten
cmp dl,ch                              ; overflow during multiplication?
jne get_num_bad                        ; if overflow, return error
add ax,bx                              ; add in value of digit
jnc l1                                 ; if no overflow, loop back for next
ret

test_digit:                            ; is next character a digit?
mov bl,b [si]                          ; get next character
cmp bl,'0'
jb ret                                 ; no, exit with .z flag clear
cmp bl,'9'
ja ret                                 ; no, exit with .z flag clear
get_num_okay:
cmp bl,bl                              ; yes, exit with .z set
ret

compute_julian:                        ; convert date to julian number:
mov ax,w [year]                        ; get year in .ax
mov bx,ax                              ; and in .bx
cmp ax,02000xd                         ; year 2000?
je > l0                                ; if so, definitely a leap year
mov cl,0100xd
div cl
cmp ah,00                              ; is year divisible by 100?
je > l1                                ; if so, not a leap year
test bl,03                             ; is year divisible by 4?
jne > l1                               ; if not, not a leap year
l0:                                    ; leap year!
mov b [months_table+1],1d              ; 29 days in february
l1:
zero cx                                ; .cx holds a convenient zero
mov bp,cx                              ; start with january
#if monday
mov w [julian_lo],cx
#else
mov w [julian_lo],0001
#endif
mov w [julian_hi],cx                   ; and a julian date of four
l2:
mov al,b [months_table+bp]             ; get length of month
cbw                                    ; as a two-byte value
inc bp
cmp bp,w [month]                       ; hit the user's month yet?
je > l4                                ; yes, exit this loop
add w [julian_lo],ax                   ; no, add month length into julian
jmp SHORT l2                                 ; and loop back for next month
l4:                                    ; added in lengths of previous months:
sub bx,01753xd                         ; normalize year to zero
mov ax,bx
mov dx,0365xd
mul dx                                 ; multiply year number by 365
add w [julian_lo],ax
adc w [julian_hi],dx                   ; and add into the julian date
mov ax,bx
shr ax,1
shr ax,1                               ; divide year number by four
add w [julian_lo],ax                   ; to get number of leap-days
adc w [julian_hi],cx                   ; add leap days into julian date
mov ax,bx
add ax,052xd
mov dl,0100xd
div dl                                 ; and divide by 100
cbw                                    ; to get number of non-leap xx00 years
sub w [julian_lo],ax
sbb w [julian_hi],cx                   ; subtract from julian date
cmp bx,0247xd
jbe > l8                               ; user year greater than 2000?
add w [julian_lo],0001                 ; if so, add one  (year 2000 is the
adc w [julian_hi],cx                   ; only leap century in program range)
l8:
mov dx,w [julian_hi]
mov ax,w [julian_lo]
mov cl,07
div cx                                 ; divide julian date by seven
mov al,01                              ; to get day of the week.
sub al,dl
ret                                    ; and return offset in .al

print_cal:                             ; print a calendar:
call crlf                              ; blank line
inc b [flags]                          ; full-year calendar?
je print_year_cal                      ; if so, go do that
call header_out                        ; display month and year
call crlf                              ; end of line
dosprint msg_cal1                      ; print days-of-week line
call crlf                              ; end of line
mov si,0006                            ; print six rows of dates :
call compute_julian                    ; calculate offset for start of month
mov ch,al
l4:
call print_cal_line                    ; print a row of dates
call crlf                              ; and terminate print line
add ch,07                              ; add seven to date offset
dec si                                 ; done six rows yet?
jne l4                                 ; if not, loop back
ret                                    ; if so, exit

print_year_cal:                        ; print full-year calendar:
zero si                                ; start in the first column
l0:
call header_out                        ; display month and year
mov cx,0009
call spaces_out
call compute_julian                    ; compute values for first of month
mov b [cal1+si],al                     ; save in temp variable
inc w [month]                          ; move on to next month
inc si                                 ; and next column
cmp si,0003                            ; printed three month names yet?
jne l0                                 ; no, loop back for more
call crlf                              ; yes, end print line
l2:
dosprint msg_cal1                      ; print days-of-week line
dec si                                 ; three times
jne l2
call crlf                              ; then end print line
sub w [month],0003                     ; back to first-column month
mov si,0006                            ; print six rows of dates
l5:
zero di                                ; start in first column
l6:
mov ch,b [cal1+di]                     ; get offset for start of month
call print_cal_line                    ; print a row of dates
add b [cal1+di],07                     ; then add seven to date offset
inc w [month]                          ; move on to the next month
inc di                                 ; in the next column
cmp di,0003                            ; done three columns yet?
jb l6                                  ; no, loop back and do next column
call crlf                              ; terminate print line
sub w [month],0003                     ; back to first-column month
dec si                                 ; printed six rows yet
jne l5                                 ; no, loop back for more
call crlf                              ; print a blank line
add w [month],03                       ; move ahead to next row of months
#if !no_pause
cmp w [month],0007                     ; does july come next?
jne > l7                               ; if not, no need to pause
mov bx,0001                            ; handle for stdout --
doscall2 4400                          ; ioctl get device data
and dl,82                              ; examine device and stdout bits
cmp dl,82                              ; standard output to the console?
jne > l7                               ; if not, do not pause
dosprint msg_more                      ; time to pause:  print pause message
l65:
mov ah,01                              ; keyboard:  check key buffer status
int 16
pushf                                  ; save status
mov ah,00                              ; keyboard:  get key
int 16
popf                                   ; are we flushing the key buffer?
jne l65                                ; if so, loop back for more
l7:
#endif
cmp w [month],000c                     ; all done yet?
ja ret                                 ; yes, exit
jmp print_year_cal                     ; no, loop back for next three months

print_cal_line:                        ; print row of dates:
mov cl,00                              ; start in first day-of-week column
l2:
mov al,ch                              ; get date offset from .ch
add al,cl                              ; and add the column number
call out2dig                           ; print number if valid
inc cl                                 ; next day-of-week column
cmp cl,07                              ; done seven yet?
jne l2                                 ; nope, keep going
call space_out
int 21                                 ; yes, print two more trailing spaces
ret                                    ; and exit

out2dig:                               ; print date in .al, if it is valid:
cmp al,00                              ; zero?
je > l1                                ; if so, not valid; print spaces
mov bx,w [month]                       ; get offset into month-lengths table
cmp al,b [months_table-1+bx]           ; date value too large?
jbe > l2                               ; no, print it
l1:                                    ; invalid date value:
mov dx,offset msg_3sp                  ; print three spaces
l15:
doscall 09
ret                                    ; and exit
l2:                                    ; valid date value:
#if !no_splat
cmp al,b [today]                       ; is this today's date ?
jne > l3                               ; if not, continue
mov dx,offset msg_today                ; if so, print an asterisk and exit
jmp l15
#endif
l3:
cmp al,0a                              ; ten or greater?  i.e., two digits?
jae > l4                               ; yes, print two digits
push ax                                ; otherwise, save value
call space_out                         ; print a space
pop dx
add dl,'0'                             ; convert one-digit value to ascii
int 21                                 ; and print it
jmp short space_out                    ; print trailing space and exit
l4:                                    ; print two-digit value:
call bcdout                            ; then print a space and exit

space_out:                             ; print a space:
mov dl,20                              ; ascii value of a space
doscall 02                             ; print it
ret

header_out:                            ; display month and year :
call six_spaces                        ; print six spaces
mov ax,w [month]                       ; get month number
mov cl,03
mul cl                                 ; and multiply by three
mov bx,ax                              ; to get pointer to month name
mov ah,02                              ; dos print-a-character function
l0:                                    ; print three characters
mov dl,b [month_names-3+bx]            ; get byte from month name
int 21                                 ; and print it
inc bx                                 ; advance pointer
loop l0                                ; and continue until done
call space_out                         ; print one space
mov ax,w [year]                        ; get the current year
mov cl,0100xd
div cl                                 ; divide year by 100
mov bl,ah                              ; save the remainder
call bcdout                            ; print the century
mov al,bl                              ; get the remainder and fall through -
bcdout:                                ; print value in .al
aam                                    ; unpack decimal digits
add ax,'0' by '0'                      ; and convert to ascii digits
push ax                                ; save the remainder
mov dl,ah
doscall 02                             ; print the tens digit
pop dx                                 ; get the ones digit
int 21                                 ; print the ones digit
ret

crlf:                                  ; terminate print line:
dosprint msg_crlf                      ; print carriage return and line feed
ret

six_spaces:                            ; print six spaces :
mov cx,0006                            ; load .cx with six and fall through

spaces_out:                            ; print .cx number of spaces:
mov ah,02                              ; dos print-a-character function
mov dl,20                              ; ascii value of a space
l0:
int 21                                 ; print it
loop l0                                ; however many times
ret


flags:                                 ; nonzero means full-year calendar
db 00


months_table:                          ; number of days in each month
db 1f, 1c, 1f, 1e, 1f, 1e, 1f, 1f, 1e, 1f, 1e, 1f

month_names:                           ; three-letter month names
db 'JanFebMarAprMayJunJulAugSepOctNovDec'

msg_syntax:
db 0d,0a
db 'CAL  1.07  Freeware',0d,0a
db 'Copyright 1998, Charles Dye',0d,0a
db 0a
db 'CAL',0d,0a
db 'CAL mm/yyyy',0d,0a
db 'CAL yyyy'

msg_crlf:
db 0d,0a,'$'

msg_year_bad:
db 0d,0a,'Year is 1753-2399!',0d,0a,'$'

msg_month_bad:
db 0d,0a,'Month is 1-12!',0d,0a,'$'

msg_cal1:
#if monday
db 'Mo Tu We Th Fr Sa Su'
#else
db 'Su Mo Tu We Th Fr Sa'
#endif

msg_3sp:
db '   $'

#if !no_pause
msg_more:
db 'More',0d,'$'
#endif

#if !no_splat
msg_today:
db ' * $'
#endif


;  v1.00   01-05-1997
;          First release.  999 bytes.
;
;  v1.01   02-06-1997
;          Fixes a bug in calculation of Julian numbers.  999 bytes.
;
;  v1.02   02-22-1998
;          Adds features, reduces program size.  If CAL is started with no
;  parameters, it will display an asterisk in place of the current date.
;  Year may now be entered as two digits (corresponding to years 2000-2099.)
;  965 bytes.
;
;  v1.03   02-28-1998
;          Test for I/O redirection is now done correctly (using IOCTL
;  instead of peeking the JFT.)  FreeDOS uses the JFT differently than does
;  MS-DOS.  940 bytes.
;
;  v1.04   06-19-1998
;          Program exits via INT 20 instead of RET (fix for FreeDOS
;  compatibility problem.)  915 bytes.
;
;  v1.05   06-25-1998
;          Any character 0D *or less* is now treated as an end-of-line
;  (workaround for odd problem with Pat Villani's COMMAND.COM.)  915 bytes.
;
;  v1.06   07-08-1998
;          Extended year range to 1753 through 2399.  Adds an assembly-time
;  option to make Monday the first day of week (ISO standard.)  900 bytes.
;
;  v1.06   07-11-1998
;          No change to the executable.  Adds assembly-time options to the
;  source file to remove the asterisk marking today's date, the expansion of
;  two-digit years, and the automatic pause in the year calendar.  900 bytes.
;
;  v1.07   08-12-1998
;          Fixes an incompatibility with 8086 and 8088 CPUs (logical shifts
;  with immediate count values.)  900 bytes.

