#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <io.h>

// #define DEBUG

char str1[256];
char str2[256];
char complement = 0;
char squeeze    = 0;
char delmode    = 0;
char multimode  = 0;
char lastch     = 0;
char predef     = 0;
#ifdef DEBUG
char debug      = 0;
#endif

char iso8859[55] = { 0307,0374,0351,0342,0344,0340,0345,0347,
		     0352,0353,0350,0357,0356,0354,0304,0305,
		     0311,0346,0306,0364,0366,0362,0373,0371,
		     0375,0326,0334,0242,0243,0245,0244,0244,
		     0341,0355,0363,0372,0361,0321,0252,0272,
		     0277,0254,0254,0275,0274,0241,0253,0273,
		     0260,0261,0262,0337,0265,0367,0 };

char iso8859g[41]= { 0246,0053,0053,0053,0053,0053,0053,0246,
		     0053,0053,0053,0053,0053,0053,0053,0053,
		     0053,0055,0053,0053,0053,0053,0053,0053,
		     0053,0053,0055,0053,0053,0053,0053,0053,
		     0053,0053,0053,0053,0053,0053,0053,0053, 0 } ;

char cp437[55]   = { 0200,0201,0202,0203,0204,0205,0206,0207,
		     0210,0211,0212,0213,0214,0215,0216,0217,
		     0220,0221,0222,0223,0224,0225,0226,0227,
		     0230,0231,0232,0233,0234,0235,0236,0237,
		     0240,0241,0242,0243,0244,0245,0246,0247,
		     0250,0251,0252,0253,0254,0255,0256,0257,
		     0370,0361,0375,0341,0346,0366,0 };

char cp437g[41]  = { 0263,0264,0265,0266,0267,0270,0271,0272,
		     0273,0274,0275,0276,0277,0300,0301,0302,
		     0303,0304,0305,0306,0307,0310,0311,0312,
		     0313,0314,0315,0316,0317,0320,0321,0322,
		     0323,0324,0325,0326,0327,0330,0331,0332,0 };

char utf8[234]   = {  64,  67,  70,  73,      76,  79,  82,  85,
		      88,  91,  94,  97,     100, 103, 106, 109,
		     112, 115, 118, 121,     124, 127, 130, 133,
		     136, 139, 142, 145,     148, 151, 226, 157,
		     160, 163, 166, 169,     172, 175, 178, 181,
		     184, 230, 190, 193,     196, 199, 202, 205,
		     208, 211, 214, 217,     220, 223,   0,   0,
		       0,   0,   0,   0,       0,   0,   0,   0,
		     0xC3,0x87,0, 0xC3,0xBC,0, 0xC3,0xA9,0, 0xC3,0xA2,0,
		     0xC3,0xA4,0, 0xC3,0xA0,0, 0xC3,0xA5,0, 0xC3,0xA7,0,
		     0xC3,0xAA,0, 0xC3,0xAB,0, 0xC3,0xA8,0, 0xC3,0xAF,0,
		     0xC3,0xAE,0, 0xC3,0xAC,0, 0xC3,0x84,0, 0xC3,0x85,0,
		     0xC3,0x89,0, 0xC3,0xA6,0, 0xC3,0x86,0, 0xC3,0xB4,0,
		     0xC3,0xB6,0, 0xC3,0xB2,0, 0xC3,0xBB,0, 0xC3,0xB9,0,
		     0xC3,0xBF,0, 0xC3,0x96,0, 0xC3,0x9C,0, 0xC2,0xA2,0,
		     0xC2,0xA3,0, 0xC2,0xA5,0, 0,   0,   0, 0xC6,0x92,0,
		     0xC3,0xA2,0, 0xC3,0xAD,0, 0xC3,0xB3,0, 0xC3,0xBA,0,
		     0xC3,0xB1,0, 0xC3,0x91,0, 0xC2,0xAA,0, 0xC2,0xBA,0,
		     0xC2,0xBF,0, 0,   0,   0, 0xC2,0xAC,0, 0xC2,0xBD,0,
		     0xC2,0xBC,0, 0xC2,0xA1,0, 0xC2,0xAB,0, 0xC2,0xBB,0,
		     0xC2,0xB0,0, 0xC2,0xB1,0, 0xC2,0xB2,0, 0xC3,0x9F,0,
		     0xC2,0xB5,0, 0xC3,0xB7,0,
		     0xE2,0x82,0xA7,0,         0xE2,0x8C,0x90,0 };



char helptext[] = "\n\
 TR 1.1 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage: tr [ options ] [ <string1> [ <string2> [ <str3> <str4> ... ] ] ]\n\n\
 valid options are:\n\
     /C  (complement) all characters NOT in <string1>\n\
     /D  (delete)     remove all characters in <string1>\n\
     /S  (squeeze)    remove consecutive duplicate characters\n\
     /M  (multibyte)  replace all characters in <string1> by the\n\
		      corresponding <string2>, <str3>, <str4> ...\n\
     /Pn (predefined) use internally defined <string1> and <string2>\n\
		      n = 1: CP437     --> ISO8859-1 (characters only)\n\
		      n = 2: CP437     --> ISO8859-1 (subst. non-mapping)\n\
		      n = 3: CP437     --> ISO8859-1 (subst. graphics)\n\
		      n = 4: ISO8859-1 --> CP437     (characters only)\n\
		      n = 5: ISO8859-1 --> CP437     (subst. non-mapping)\n\
		      n = 6: CP437     --> UTF-8     (characters only)\n\n\
 examples: echo abcDEFghi   | tr A-Z a-z\n\
	   echo a..o..u. | tr /M \\0A\\0D ae oe ue \"<LF>\" \"<CR>\"\n\
	   tr /P1 < text.dos > text.win\n\n";

void set_sepchr(char *p, char *t, int l,char neg) {
  unsigned char tmp[256];
  unsigned char *q, c, tmp2[4];
  if(strchr(p,'\\')) {
    for(q=tmp; *p&&q<&tmp[l]; p++)
      if(*p!='\\') *q++ = *p;
      else {
	p++;
	if(!isxdigit(*p)||!isxdigit(p[1])) *q++ = *p;
	else {
	  tmp2[0] = *p++;
	  tmp2[1] = *p;
	  tmp2[2] = '\0';
	  *q++ = strtol(tmp2,NULL,16) & 0XFF;
	  }
	}
    *q++ = '\0';
    p = tmp;
    }
  q = t;
  *q++ = c = *p++;
  for( ; *p&&q<&t[l]; p++)
    if((*p!='-')||(c>=p[1])) *q++ = c = *p;
    else for(c++ ; c<p[1]; c++)  *q++ = c;
  *q = '\0';
  if(neg) {
    for(q=tmp,c=0; c<255&&q<&tmp[l]; c++) if(!strchr(t,c)) *q++ = c;
    *q = '\0';
    strcpy(t,tmp);
    }
  }

#ifdef DEBUG
void show_tables(int l) {
  int i,j,k;
  printf("DELMODE=%d   MULTIMODE=%d   COMPLEMENT=%d\n",delmode,multimode,complement);
  for(i=0,k=strlen(str1); i<k; i+=24) {
    printf("\n%3d:",i);
    for(j=0; j<24; j++) if(i+j<k) printf(" %02X",str1[i+j]&0XFF); else printf("   ");
    }
  printf("\n");
  for(i=0; i<l; i+=24) {
    printf("\n%3d:",i);
    for(j=0; j<24; j++) if(i+j<l) printf(" %02X",str2[i+j]&0XFF); else printf("   ");
    }
  printf("\n");
  }
#endif

void main (int argc, char* argv[]) {
  int   i,j,k;
  char  *p, *q;
  unsigned char ch;

  if(argc < 2) printf(helptext);
  else {
    for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
      switch (toupper(argv[i][1])) {
	case 'C': complement = 1;              break;
	case 'D': multimode  = 0; delmode = 1; break;
	case 'M': multimode  = 1; delmode = 0; break;
	case 'S': squeeze    = 1;              break;
	case 'P': if(isdigit(argv[i][2]))
		  predef = argv[i][2] & 0X07;  break;
#ifdef DEBUG
	case 'X': debug      = 1;              break;
#endif
	case 'H': printf(helptext);            exit(0);
	}
      }

    if(!predef) {
      set_sepchr(argv[i],str1,255,complement);
      strcpy(str2,str1);
      if(!delmode&&++i<argc) {
	if(!multimode) {
	  set_sepchr(argv[i],str2,255,0);
	  for(i=strlen(str1),j=strlen(str2),ch=str2[j-1]; j<i; j++) str2[j] = ch;
	  }
	else {
	  k = strlen(str2);
	  j = k + 1;
	  p = &str2[j];
	  q = str2;
	  while((i<argc)&&(j<250)) {
	    set_sepchr(argv[i],p,255-j,0);
	    if(q<&str2[k]) *q++ = j;
	    j += (strlen(p) + 1);
	    p = &str2[j];
	    i++;
	    }
	  q--;
	  for(ch=*q++; q<&str2[k]; q++) *q = ch;
	  }
	}
      }
    else switch(predef) {
      case 1:
      case 2:
      case 3: strcpy(str1,cp437);
	      strcpy(str2,iso8859);
	      if(predef==3) {
		strcat(str1,cp437g);
		strcat(str2,iso8859g);
		}
	      if(predef>1)
		for(i=128; i<256; i++)
		  if(!strchr(str1,i)) {
		    j = strlen(str1);
		    if(j<255) {
		      str1[j] = i;
		      str2[j] = 0327;
		      j++;
		      str1[j] = '\0';
		      str2[j] = '\0';
		      }
		    }
	      multimode = 0;
	      break;
      case 4:
      case 5: strcpy(str1,iso8859);
	      strcpy(str2,cp437);
	      if(predef==5)
		for(i=128; i<256; i++)
		  if(!strchr(str1,i)) {
		    j = strlen(str1);
		    if(j<255) {
		      str1[j] = i;
		      str2[j] = 0372;
		      j++;
		      str1[j] = '\0';
		      str2[j] = '\0';
		      }
		    }
	      multimode = 0;
	      break;
      case 6: strcpy(str1,cp437);
	      memcpy(str2,utf8,sizeof(utf8));
	      multimode = 1;
	      break;
      default: printf(helptext);
	      exit(1);
      }
#ifdef DEBUG
    if(debug) show_tables((multimode)?p-str2:strlen(str2));
    else
#endif
      {
      setmode(0,O_BINARY);
      while((i=getc(stdin))!=EOF) {
	j = ((p=strchr(str1,i))==NULL)?-1:p-str1;
	if(j<0) fputc(i,stdout);
	else if(!delmode) {
	  ch = str2[j];
	  if(!squeeze||(ch!=lastch)) {
	    if(!multimode) fputc(ch,stdout);
	    else fprintf(stdout,"%s",&str2[ch]);
	    lastch = ch;
	    }
	  }
	}
      setmode(0,O_TEXT);
      }
    }
  exit(0);
  }
