/*!\file netinet/in_pcb.h
 * Internal IP structures.
 */

/*
 * Copyright (c) 1982, 1986, 1990, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)in_pcb.h    8.1 (Berkeley) 6/10/93
 * $Id: in_pcb.h,v 1.14.2.2 1997/03/03 09:24:37 davidg Exp $
 */

#ifndef __NETINET_IN_PCB_H
#define __NETINET_IN_PCB_H

#ifndef __SYS_MBUF_H
#include <sys/mbuf.h>
#endif

#ifndef __SYS_QUEUE_H
#include <sys/queue.h>
#endif

/*
 * Common structure pcb for internet protocol implementation.
 * Here are stored pointers to local and foreign host table
 * entries, local and foreign socket numbers, and pointers
 * up (to a socket structure) and down (to a protocol-specific)
 * control block.
 */
LIST_HEAD(inpcbhead, inpcb);

struct inpcb {
        LIST_ENTRY(inpcb) inp_list;    /* list for all PCBs of this proto */
        LIST_ENTRY(inpcb) inp_hash;    /* hash list */
        struct  inpcbinfo *inp_pcbinfo;
        struct  in_addr inp_faddr;      /* foreign host table entry */
        u_short inp_fport;              /* foreign port */
        struct  in_addr inp_laddr;      /* local host table entry */
        u_short inp_lport;              /* local port */
        struct  socket *inp_socket;     /* back pointer to socket */
        caddr_t inp_ppcb;               /* pointer to per-protocol pcb */
        struct  route inp_route;        /* placeholder for routing entry */
        int     inp_flags;              /* generic IP/datagram flags */
        struct  ip inp_ip;              /* header prototype; should have more */
        struct  mbuf *inp_options;      /* IP options */
        struct  ip_moptions *inp_moptions; /* IP multicast options */
};

struct inpcbinfo {
        struct inpcbhead *listhead;
        struct inpcbhead *hashbase;
        unsigned long hashmask;
        unsigned short lastport;
        unsigned short lastlow;
        unsigned short lasthi;
};

#define INP_PCBHASH(faddr, lport, fport, mask) \
        (((faddr) ^ ((faddr) >> 16) ^ (lport) ^ (fport)) & (mask))

/* flags in inp_flags: */
#define INP_RECVOPTS            0x01    /* receive incoming IP options */
#define INP_RECVRETOPTS         0x02    /* receive IP options for reply */
#define INP_RECVDSTADDR         0x04    /* receive IP dst address */
#define INP_HDRINCL             0x08    /* user supplies entire IP header */
#define INP_HIGHPORT            0x10    /* user wants "high" port binding */
#define INP_LOWPORT             0x20    /* user wants "low" port binding */
#define INP_ANONPORT            0x40    /* port chosen for user */
#define INP_RECVIF              0x80    /* receive incoming interface */
#define INP_CONTROLOPTS         (INP_RECVOPTS|INP_RECVRETOPTS|INP_RECVDSTADDR|\
                                        INP_RECVIF)

#define INPLOOKUP_WILDCARD      1

#define sotoinpcb(so)   ((struct inpcb *)(so)->so_pcb)

#endif
