/*
 * Copyright (c) 2021 TK Chia
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name of the developer(s) nor the names of its
 *     contributors may be used to endorse or promote products derived from
 *     this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define _LIBI86_COMPILING_
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include "libi86/stdlib.h"
#include "libi86/internal/acconfig.h"
#include "libi86/internal/dos.h"
#include "libi86/internal/dos-dbcs.h"

#ifndef _LIBI86_INTERNAL_HAVE_ENAMETOOLONG
# define ENAMETOOLONG	E2BIG
#endif

char *
_fullpath (char *out_path, const char *path, size_t size)
{
  if (! path || ! path[0])
    path = ".";

  if (! out_path || size >= _MAX_PATH)
    return realpath (path, out_path);
  else
    {
      char buf[_MAX_PATH];
      char *res = realpath (path, buf);
      size_t len;

      if (! res)
	return NULL;

      len = strlen (res);
      if (len >= size)
	{
	  errno = ENAMETOOLONG;
	  return NULL;
	}

      memcpy (out_path, res, len + 1);
      return out_path;
    }
}
