/*
 *  ddeml.h     Dynamic Data Exchange Management Library (DDEML) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_DDEMLH
#define _INC_DDEMLH

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* DDEML callback calling convention */
#define EXPENTRY    CALLBACK

/* Handles for DDEML */
DECLARE_HANDLE( HCONV );
DECLARE_HANDLE( HCONVLIST );
DECLARE_HANDLE( HDDEDATA );
DECLARE_HANDLE( HSZ );

/* Conversion states */
#define XST_NULL            0
#define XST_INCOMPLETE      1
#define XST_CONNECTED       2
#define XST_INIT1           3
#define XST_INIT2           4
#define XST_REQSENT         5
#define XST_DATARCVD        6
#define XST_POKESENT        7
#define XST_POKEACKRCVD     8
#define XST_EXECSENT        9
#define XST_EXECACKRCVD     10
#define XST_ADVSENT         11
#define XST_UNADVSENT       12
#define XST_ADVACKRCVD      13
#define XST_UNADVACKRCVD    14
#define XST_ADVDATASENT     15
#define XST_ADVDATAACKRCVD  16

/* Special value used with XTYP_ADVREQ */
#define CADV_LATEACK    0xFFFF

/* Status flags */
#define ST_CONNECTED    0x0001
#define ST_ADVISE       0x0002
#define ST_ISLOCAL      0x0004
#define ST_BLOCKED      0x0008
#define ST_CLIENT       0x0010
#define ST_TERMINATED   0x0020
#define ST_INLIST       0x0040
#define ST_BLOCKNEXT    0x0080
#define ST_ISSELF       0x0100

/* DdeClientTransaction() result flags */
#define DDE_FACK            0x8000
#define DDE_FBUSY           0x4000
#define DDE_FDEFERUPD       0x4000
#define DDE_FACKREQ         0x8000
#define DDE_FRELEASE        0x2000
#define DDE_FREQUESTED      0x1000
#define DDE_FAPPSTATUS      0x00FF
#define DDE_FNOTPROCESSED   0x0000
#define DDE_FACKRESERVED    (~(DDE_FACK | DDE_FBUSY | DDE_FAPPSTATUS))
#define DDE_FADVRESERVED    (~(DDE_FACKREQ | DDE_FDEFERUPD))
#define DDE_FDATRESERVED    (~(DDE_FACKREQ | DDE_FRELEASE | DDE_FREQUESTED))
#define DDE_FPOKRESERVED    (~(DDE_FRELEASE))

/* Special message filter code used with DDE */
#define MSGF_DDEMGR 0x8001

/* Code page identifiers used with DDE */
#define CP_WINANSI          1004
#define CP_WINUNICODE       1200
#ifdef UNICODE
    #define CP_WINNEUTRAL   CP_WINUNICODE
#else
    #define CP_WINNEUTRAL   CP_WINANSI
#endif

/* Transaction type flags */
#define XTYPF_NOBLOCK   0x0002
#define XTYPF_NODATA    0x0004
#define XTYPF_ACKREQ    0x0008

/* Transaction classes */
#define XCLASS_MASK         0xFC00
#define XCLASS_BOOL         0x1000
#define XCLASS_DATA         0x2000
#define XCLASS_FLAGS        0x4000
#define XCLASS_NOTIFICATION 0x8000

/* Transaction types */
#define XTYP_ERROR              (0x0000 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
#define XTYP_ADVDATA            (0x0010 | XCLASS_FLAGS)
#define XTYP_ADVREQ             (0x0020 | XCLASS_DATA | XTYPF_NOBLOCK)
#define XTYP_ADVSTART           (0x0030 | XCLASS_BOOL)
#define XTYP_ADVSTOP            (0x0040 | XCLASS_NOTIFICATION)
#define XTYP_EXECUTE            (0x0050 | XCLASS_FLAGS)
#define XTYP_CONNECT            (0x0060 | XCLASS_BOOL | XTYPF_NOBLOCK)
#define XTYP_CONNECT_CONFIRM    (0x0070 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
#define XTYP_XACT_COMPLETE      (0x0080 | XCLASS_NOTIFICATION)
#define XTYP_POKE               (0x0090 | XCLASS_FLAGS)
#define XTYP_REGISTER           (0x00A0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
#define XTYP_REQUEST            (0x00B0 | XCLASS_DATA)
#define XTYP_DISCONNECT         (0x00C0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
#define XTYP_UNREGISTER         (0x00D0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
#define XTYP_WILDCONNECT        (0x00E0 | XCLASS_DATA | XTYPF_NOBLOCK)
#define XTYP_MONITOR            (0x00F0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
#define XTYP_MASK               0x00F0
#define XTYP_SHIFT              4

/* Special timeout value */
#define TIMEOUT_ASYNC   0xFFFFFFFFL

/* Special transaction identifier value */
#define QID_SYNC    0xFFFFFFFFL

/* Strings used by DDE */
#define SZDDESYS_TOPIC          TEXT( "System" )
#define SZDDESYS_ITEM_TOPICS    TEXT( "Topics" )
#define SZDDESYS_ITEM_SYSITEMS  TEXT( "SysItems" )
#define SZDDESYS_ITEM_RTNMSG    TEXT( "ReturnMessage" )
#define SZDDESYS_ITEM_STATUS    TEXT( "Status" )
#define SZDDESYS_ITEM_FORMATS   TEXT( "Formats" )
#define SZDDESYS_ITEM_HELP      TEXT( "Help" )
#define SZDDE_ITEM_ITEMLIST     TEXT( "TopicItemList" )

/* DDE data handle special value */
#define CBR_BLOCK   ((HDDEDATA)-1)

/* Callback filter flags */
#define CBF_FAIL_SELFCONNECTIONS    0x00001000L
#define CBF_FAIL_CONNECTIONS        0x00002000L
#define CBF_FAIL_ADVISES            0x00004000L
#define CBF_FAIL_EXECUTES           0x00008000L
#define CBF_FAIL_POKES              0x00010000L
#define CBF_FAIL_REQUESTS           0x00020000L
#define CBF_FAIL_ALLSRVXACTIONS     0x0003F000L
#define CBF_SKIP_CONNECT_CONFIRMS   0x00040000L
#define CBF_SKIP_REGISTRATIONS      0x00080000L
#define CBF_SKIP_UNREGISTRATIONS    0x00100000L
#define CBF_SKIP_DISCONNECTS        0x00200000L
#define CBF_SKIP_ALLNOTIFICATIONS   0x003C0000L

/* Application command flags */
#define APPCMD_CLIENTONLY   0x00000010L
#define APPCMD_FILTERINITS  0x00000020L
#define APPCMD_MASK         0x00000FF0L

/* Applications classification flags */
#define APPCLASS_STANDARD   0x00000000L
#define APPCLASS_MONITOR    0x00000001L
#define APPCLASS_MASK       0x0000000FL

/* DdeEnableCallback() commands */
#define EC_ENABLEALL    0
#define EC_ENABLEONE    ST_BLOCKNEXT
#define EC_DISABLE      ST_BLOCKED
#define EC_QUERYWAITING 2

/* DdeNameService() commands */
#define DNS_REGISTER    0x0001
#define DNS_UNREGISTER  0x0002
#define DNS_FILTERON    0x0004
#define DNS_FILTEROFF   0x0008

/* Special data handle value */
#define HDATA_APPOWNED  0x00000001L

/* DDEML error codes */
#define DMLERR_NO_ERROR             0x0000
#define DMLERR_FIRST                0x4000
#define DMLERR_ADVACKTIMEOUT        0x4000
#define DMLERR_BUSY                 0x4001
#define DMLERR_DATAACKTIMEOUT       0x4002
#define DMLERR_DLL_NOT_INITIALIZED  0x4003
#define DMLERR_DLL_USAGE            0x4004
#define DMLERR_EXECACKTIMEOUT       0x4005
#define DMLERR_INVALIDPARAMETER     0x4006
#define DMLERR_LOW_MEMORY           0x4007
#define DMLERR_MEMORY_ERROR         0x4008
#define DMLERR_NOTPROCESSED         0x4009
#define DMLERR_NO_CONV_ESTABLISHED  0x400A
#define DMLERR_POKEACKTIMEOUT       0x400B
#define DMLERR_POSTMSG_FAILED       0x400C
#define DMLERR_REENTRANCY           0x400D
#define DMLERR_SERVER_DIED          0x400E
#define DMLERR_SYS_ERROR            0x400F
#define DMLERR_UNADVACKTIMEOUT      0x4010
#define DMLERR_UNFOUND_QUEUE_ID     0x4011
#define DMLERR_LAST                 0x4011

/* String monitoring actions */
#define MH_CREATE   1
#define MH_KEEP     2
#define MH_DELETE   3
#define MH_CLEANUP  4

/* Maximum number of monitors */
#define MAX_MONITORS    4

/* Monitor callback filter flags */
#define MF_HSZ_INFO     0x01000000L
#define MF_SENDMSGS     0x02000000L
#define MF_POSTMSGS     0x04000000L
#define MF_CALLBACKS    0x08000000L
#define MF_ERRORS       0x10000000L
#define MF_LINKS        0x20000000L
#define MF_CONV         0x40000000L
#define MF_MASK         0xFF000000L

/* String pair */
typedef struct tagHSZPAIR {
    HSZ hszSvc;
    HSZ hszTopic;
} HSZPAIR;
typedef HSZPAIR *PHSZPAIR;

/* Conversion context */
typedef struct tagCONVCONTEXT {
    UINT                        cb;
    UINT                        wFlags;
    UINT                        wCountryID;
    int                         iCodePage;
    DWORD                       dwLangID;
    DWORD                       dwSecurity;
    SECURITY_QUALITY_OF_SERVICE qos;
} CONVCONTEXT;
typedef CONVCONTEXT *PCONVCONTEXT;

/* Conversion information */
typedef struct tagCONVINFO {
    DWORD       cb;
    DWORD_PTR   hUser;
    HCONV       hConvPartner;
    HSZ         hszSvcPartner;
    HSZ         hszServiceReq;
    HSZ         hszTopic;
    HSZ         hszItem;
    UINT        wFmt;
    UINT        wType;
    UINT        wStatus;
    UINT        wConvst;
    UINT        wLastError;
    HCONVLIST   hConvList;
    CONVCONTEXT ConvCtxt;
    HWND        hwnd;
    HWND        hwndPartner;
} CONVINFO;
typedef CONVINFO    *PCONVINFO;

/* DDEML callback function */
typedef HDDEDATA (CALLBACK FNCALLBACK)( UINT, UINT, HCONV, HSZ, HSZ, HDDEDATA, ULONG_PTR, ULONG_PTR );
typedef HDDEDATA (CALLBACK *PFNCALLBACK)( UINT, UINT, HCONV, HSZ, HSZ, HDDEDATA, ULONG_PTR, ULONG_PTR );

/* DDEML message hook data */
typedef struct tagDDEML_MSG_HOOK_DATA {
    UINT_PTR    uiLo;
    UINT_PTR    uiHi;
    DWORD       cbData;
    DWORD       Data[8];
} DDEML_MSG_HOOK_DATA;
typedef DDEML_MSG_HOOK_DATA *PDDEML_MSG_HOOK_DATA;

/* Monitor message structure */
typedef struct tagMONMSGSTRUCT {
    UINT                cb;
    HWND                hwndTo;
    DWORD               dwTime;
    HANDLE              hTask;
    UINT                wMsg;
    WPARAM              wParam;
    LPARAM              lParam;
    DDEML_MSG_HOOK_DATA dmhd;
} MONMSGSTRUCT;
typedef MONMSGSTRUCT    *PMONMSGSTRUCT;

/* Monitor callback structure */
typedef struct tagMONCBSTRUCT {
    UINT        cb;
    DWORD       dwTime;
    HANDLE      hTask;
    DWORD       dwRet;
    UINT        wType;
    UINT        wFmt;
    HCONV       hConv;
    HSZ         hsz1;
    HSZ         hsz2;
    HDDEDATA    hData;
    ULONG_PTR   dwData1;
    ULONG_PTR   dwData2;
    CONVCONTEXT cc;
    DWORD       cbData;
    DWORD       Data[8];
} MONCBSTRUCT;
typedef MONCBSTRUCT *PMONCBSTRUCT;

/* Monitor string structure */
typedef struct tagMONHSZSTRUCTA {
    UINT    cb;
    BOOL    fsAction;
    DWORD   dwTime;
    HSZ     hsz;
    HANDLE  hTask;
    CHAR    str[1];
} MONHSZSTRUCTA;
typedef MONHSZSTRUCTA   *PMONHSZSTRUCTA;
typedef struct tagMONHSZSTRUCTW {
    UINT    cb;
    BOOL    fsAction;
    DWORD   dwTime;
    HSZ     hsz;
    HANDLE  hTask;
    WCHAR   str[1];
} MONHSZSTRUCTW;
typedef MONHSZSTRUCTW   *PMONHSZSTRUCTW;
#ifdef UNICODE
typedef MONHSZSTRUCTW   MONHSZSTRUCT;
typedef PMONHSZSTRUCTW  PMONHSZSTRUCT;
#else
typedef MONHSZSTRUCTA   MONHSZSTRUCT;
typedef PMONHSZSTRUCTA  PMONHSZSTRUCT;
#endif

/* Monitor error structure */
typedef struct tagMONERRSTRUCT {
    UINT    cb;
    UINT    wLastError;
    DWORD   dwTime;
    HANDLE  hTask;
} MONERRSTRUCT;
typedef MONERRSTRUCT    *PMONERRSTRUCT;

/* Monitor link structure */
typedef struct tagMONLINKSTRUCT {
    UINT    cb;
    DWORD   dwTime;
    HANDLE  hTask;
    BOOL    fEstablished;
    BOOL    fNoData;
    HSZ     hszSvc;
    HSZ     hszTopic;
    HSZ     hszItem;
    UINT    wFmt;
    BOOL    fServer;
    HCONV   hConvServer;
    HCONV   hConvClient;
} MONLINKSTRUCT;
typedef MONLINKSTRUCT   *PMONLINKSTRUCT;

/* Monitor conversion structure */
typedef struct tagMONCONVSTRUCT {
    UINT    cb;
    BOOL    fConnect;
    DWORD   dwTime;
    HANDLE  hTask;
    HSZ     hszSvc;
    HSZ     hszTopic;
    HCONV   hConvClient;
    HCONV   hConvServer;
} MONCONVSTRUCT;
typedef MONCONVSTRUCT   *PMONCONVSTRUCT;

/* Functions in USER32.DLL */
WINUSERAPI BOOL WINAPI      DdeAbandonTransaction( DWORD, HCONV, DWORD );
WINUSERAPI LPBYTE WINAPI    DdeAccessData( HDDEDATA, LPDWORD );
WINUSERAPI HDDEDATA WINAPI  DdeAddData( HDDEDATA, LPBYTE, DWORD, DWORD );
WINUSERAPI HDDEDATA WINAPI  DdeClientTransaction( LPBYTE, DWORD, HCONV, HSZ, UINT, UINT, DWORD, LPDWORD );
WINUSERAPI int WINAPI       DdeCmpStringHandles( HSZ, HSZ );
WINUSERAPI HCONV WINAPI     DdeConnect( DWORD, HSZ, HSZ, PCONVCONTEXT );
WINUSERAPI HCONVLIST WINAPI DdeConnectList( DWORD, HSZ, HSZ, HCONVLIST, PCONVCONTEXT );
WINUSERAPI HDDEDATA WINAPI  DdeCreateDataHandle( DWORD, LPBYTE, DWORD, DWORD, HSZ, UINT, UINT );
WINUSERAPI HSZ WINAPI       DdeCreateStringHandleA( DWORD, LPCSTR, int );
WINUSERAPI HSZ WINAPI       DdeCreateStringHandleW( DWORD, LPCWSTR, int );
WINUSERAPI BOOL WINAPI      DdeDisconnect( HCONV );
WINUSERAPI HCONVLIST WINAPI DdeDisconnectList( HCONVLIST );
WINUSERAPI BOOL WINAPI      DdeEnableCallback( DWORD, HCONV, UINT );
WINUSERAPI BOOL WINAPI      DdeFreeDataHandle( HDDEDATA );
WINUSERAPI BOOL WINAPI      DdeFreeStringHandle( DWORD, HSZ );
WINUSERAPI DWORD WINAPI     DdeGetData( HDDEDATA, LPBYTE, DWORD, DWORD );
WINUSERAPI UINT WINAPI      DdeGetLastError( DWORD );
WINUSERAPI BOOL WINAPI      DdeImpersonateClient( HCONV );
WINUSERAPI UINT WINAPI      DdeInitializeA( LPDWORD, PFNCALLBACK, DWORD, DWORD );
WINUSERAPI UINT WINAPI      DdeInitializeW( LPDWORD, PFNCALLBACK, DWORD, DWORD );
WINUSERAPI BOOL WINAPI      DdeKeepStringHandle( DWORD, HSZ );
WINUSERAPI HDDEDATA WINAPI  DdeNameService( DWORD, HSZ, HSZ, UINT );
WINUSERAPI BOOL WINAPI      DdePostAdvise( DWORD, HSZ, HSZ );
WINUSERAPI UINT WINAPI      DdeQueryConvInfo( HCONV, DWORD, PCONVINFO );
WINUSERAPI HCONV WINAPI     DdeQueryNextServer( HCONVLIST, HCONV );
WINUSERAPI DWORD WINAPI     DdeQueryStringA( DWORD, HSZ, LPSTR, DWORD, int );
WINUSERAPI DWORD WINAPI     DdeQueryStringW( DWORD, HSZ, LPWSTR, DWORD, int );
WINUSERAPI HCONV WINAPI     DdeReconnect( HCONV );
WINUSERAPI BOOL WINAPI      DdeSetUserHandle( HCONV, DWORD, DWORD_PTR );
WINUSERAPI BOOL WINAPI      DdeUnaccessData( HDDEDATA );
WINUSERAPI BOOL WINAPI      DdeUninitialize( DWORD );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define DdeCreateStringHandle   DdeCreateStringHandleW
    #define DdeInitialize           DdeInitializeW
    #define DdeQueryString          DdeQueryStringW
#else
    #define DdeCreateStringHandle   DdeCreateStringHandleA
    #define DdeInitialize           DdeInitializeA
    #define DdeQueryString          DdeQueryStringA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_DDEMLH */
