/*
 *  srb.h       SCSI Request Block (SRB) definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTSRB_
#define _NTSRB_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify SCSI port functions */
#ifdef _NTDDK_
    #define SCSIPORT_API
#else
    #define SCSIPORT_API    DECLSPEC_IMPORT
#endif

/* Primitive data types */
typedef PHYSICAL_ADDRESS    SCSI_PHYSICAL_ADDRESS;
typedef PHYSICAL_ADDRESS    *PSCSI_PHYSICAL_ADDRESS;

/* SCSI minimum and maximum values */
#define SCSI_MAXIMUM_LOGICAL_UNITS      8
#define SCSI_MAXIMUM_TARGETS_PER_BUS    128
#define SCSI_MAXIMUM_LUNS_PER_TARGET    255
#define SCSI_MAXIMUM_BUSES              8
#define SCSI_MINIMUM_PHYSICAL_BREAKS    16
#define SCSI_MAXIMUM_PHYSICAL_BREAKS    255
#define SCSI_MAXIMUM_TARGETS            8
#define MAXIMUM_CDB_SIZE                12

/* SCSI bus target macros */
#define SCSI_COMBINE_BUS_TARGET( p1, p2 ) \
    (((((UCHAR)(p2)) & ~0x1F) << 8) | (((UCHAR)(p1)) << 5) | (((UCHAR)(p2)) & 0x1F))
#define SCSI_DECODE_BUS_TARGET( x, p1, p2 ) \
    (p1 = (UCHAR)((x) >> 5), p2 = (UCHAR)((((x) >> 8) & ~0x1F) | ((x) & 0x1F)))

/* SCSI 64-bit DMA use flags */
#define SCSI_DMA64_SYSTEM_SUPPORTED                 0x80
#define SCSI_DMA64_MINIPORT_SUPPORTED               0x01
#if (NTDDI_VERSION > 0x05020100)
    #define SCSI_DMA64_MINIPORT_FULL64BIT_SUPPORTED 0x02
#endif

/* Uninitialized value */
#define SP_UNINITIALIZED_VALUE  0xFFFFFFFFL
#define SP_UNTAGGED             0xFF

/* SRB events */
#define SRBEV_BUS_RESET                 0x0001
#define SRBEV_SCSI_ASYNC_NOTIFICATION   0x0002

/* SRB functions */
#define SRB_FUNCTION_EXECUTE_SCSI           0x00
#define SRB_FUNCTION_CLAIM_DEVICE           0x01
#define SRB_FUNCTION_IO_CONTROL             0x02
#define SRB_FUNCTION_RECEIVE_EVENT          0x03
#define SRB_FUNCTION_RELEASE_QUEUE          0x04
#define SRB_FUNCTION_ATTACH_DEVICE          0x05
#define SRB_FUNCTION_RELEASE_DEVICE         0x06
#define SRB_FUNCTION_SHUTDOWN               0x07
#define SRB_FUNCTION_FLUSH                  0x08
#define SRB_FUNCTION_ABORT_COMMAND          0x10
#define SRB_FUNCTION_RELEASE_RECOVERY       0x11
#define SRB_FUNCTION_RESET_BUS              0x12
#define SRB_FUNCTION_RESET_DEVICE           0x13
#define SRB_FUNCTION_TERMINATE_IO           0x14
#define SRB_FUNCTION_FLUSH_QUEUE            0x15
#define SRB_FUNCTION_REMOVE_DEVICE          0x16
#define SRB_FUNCTION_WMI                    0x17
#define SRB_FUNCTION_LOCK_QUEUE             0x18
#define SRB_FUNCTION_UNLOCK_QUEUE           0x19
#define SRB_FUNCTION_RESET_LOGICAL_UNIT     0x20
#define SRB_FUNCTION_SET_LINK_TIMEOUT       0x21
#define SRB_FUNCTION_LINK_TIMEOUT_OCCURRED  0x22
#define SRB_FUNCTION_LINK_TIMEOUT_COMPLETE  0x23
#define SRB_FUNCTION_POWER                  0x24
#define SRB_FUNCTION_PNP                    0x25
#define SRB_FUNCTION_DUMP_POINTERS          0x26

/* SRB status codes */
#define SRB_STATUS_PENDING                  0x00
#define SRB_STATUS_SUCCESS                  0x01
#define SRB_STATUS_ABORTED                  0x02
#define SRB_STATUS_ABORT_FAILED             0x03
#define SRB_STATUS_ERROR                    0x04
#define SRB_STATUS_BUSY                     0x05
#define SRB_STATUS_INVALID_REQUEST          0x06
#define SRB_STATUS_INVALID_PATH_ID          0x07
#define SRB_STATUS_NO_DEVICE                0x08
#define SRB_STATUS_TIMEOUT                  0x09
#define SRB_STATUS_SELECTION_TIMEOUT        0x0A
#define SRB_STATUS_COMMAND_TIMEOUT          0x0B
#define SRB_STATUS_MESSAGE_REJECTED         0x0D
#define SRB_STATUS_BUS_RESET                0x0E
#define SRB_STATUS_PARITY_ERROR             0x0F
#define SRB_STATUS_REQUEST_SENSE_FAILED     0x10
#define SRB_STATUS_NO_HBA                   0x11
#define SRB_STATUS_DATA_OVERRUN             0x12
#define SRB_STATUS_UNEXPECTED_BUS_FREE      0x13
#define SRB_STATUS_PHASE_SEQUENCE_FAILURE   0x14
#define SRB_STATUS_BAD_SRB_BLOCK_LENGTH     0x15
#define SRB_STATUS_REQUEST_FLUSHED          0x16
#define SRB_STATUS_INVALID_LUN              0x20
#define SRB_STATUS_INVALID_TARGET_ID        0x21
#define SRB_STATUS_BAD_FUNCTION             0x22
#define SRB_STATUS_ERROR_RECOVERY           0x23
#define SRB_STATUS_NOT_POWERED              0x24
#define SRB_STATUS_LINK_DOWN                0x25
#define SRB_STATUS_INTERNAL_ERROR           0x30
#define SRB_STATUS_QUEUE_FROZEN             0x40
#define SRB_STATUS_AUTOSENSE_VALID          0x80
#define SRB_STATUS( x ) \
    ((x) & ~(SRB_STATUS_AUTOSENSE_VALID | SRB_STATUS_QUEUE_FROZEN))

/* SRB flags */
#define SRB_FLAGS_QUEUE_ACTION_ENABLE       0x00000002L
#define SRB_FLAGS_DISABLE_DISCONNECT        0x00000004L
#define SRB_FLAGS_DISABLE_SYNCH_TRANSFER    0x00000008L
#define SRB_FLAGS_BYPASS_FROZEN_QUEUE       0x00000010L
#define SRB_FLAGS_DISABLE_AUTOSENSE         0x00000020L
#define SRB_FLAGS_DATA_IN                   0x00000040L
#define SRB_FLAGS_DATA_OUT                  0x00000080L
#define SRB_FLAGS_NO_DATA_TRANSFER          0x00000000L
#define SRB_FLAGS_UNSPECIFIED_DIRECTION     (SRB_FLAGS_DATA_IN | SRB_FLAGS_DATA_OUT)
#define SRB_FLAGS_NO_QUEUE_FREEZE           0x00000100L
#define SRB_FLAGS_ADAPTER_CACHE_ENABLE      0x00000200L
#define SRB_FLAGS_FREE_SENSE_BUFFER         0x00000400L
#define SRB_FLAGS_IS_ACTIVE                 0x00010000L
#define SRB_FLAGS_ALLOCATED_FROM_ZONE       0x00020000L
#define SRB_FLAGS_SGLIST_FROM_POOL          0x00040000L
#define SRB_FLAGS_BYPASS_LOCKED_QUEUE       0x00080000L
#define SRB_FLAGS_NO_KEEP_AWAKE             0x00100000L
#define SRB_FLAGS_PORT_DRIVER_ALLOCSENSE    0x00200000L
#define SRB_FLAGS_PORT_DRIVER_SENSEHASPORT  0x00400000L
#define SRB_FLAGS_DONT_START_NEXT_PACKET    0x00800000L

/* SRB queue actions */
#define SRB_SIMPLE_TAG_REQUEST          0x20
#define SRB_HEAD_OF_QUEUE_TAG_REQUEST   0x21
#define SRB_ORDERED_QUEUE_TAG_REQUEST   0x22
#define SRB_WMI_FLAGS_ADAPTER_REQUEST   0x01
#define SRB_POWER_FLAGS_ADAPTER_REQUEST 0x01
#define SRB_PNP_FLAGS_ADAPTER_REQUEST   0x01

/* Port driver error codes */
#define SP_BUS_PARITY_ERROR             0x0001
#define SP_UNEXPECTED_DISCONNECT        0x0002
#define SP_INVALID_RESELECTION          0x0003
#define SP_BUS_TIME_OUT                 0x0004
#define SP_PROTOCOL_ERROR               0x0005
#define SP_INTERNAL_ADAPTER_ERROR       0x0006
#define SP_REQUEST_TIMEOUT              0x0007
#define SP_IRQ_NOT_RESPONDING           0x0008
#define SP_BAD_FW_WARNING               0x0009
#define SP_BAD_FW_ERROR                 0x000A
#define SP_LOST_WMI_MINIPORT_REQUEST    0x000B

/* Port driver version flags */
#define SP_VER_TRACE_SUPPORT    0x0010

/* SCSI_HW_FIND_ADAPTER return codes */
#define SP_RETURN_NOT_FOUND     0
#define SP_RETURN_FOUND         1
#define SP_RETURN_ERROR         2
#define SP_RETURN_BAD_CONFIG    3

/* Access range */
typedef struct _ACCESS_RANGE {
#ifdef _NTSTORPORT_
    STOR_PHYSICAL_ADDRESS   RangeStart;
#else
    SCSI_PHYSICAL_ADDRESS   RangeStart;
#endif
    ULONG                   RangeLength;
    BOOLEAN                 RangeInMemory;
} ACCESS_RANGE;
typedef ACCESS_RANGE    *PACCESS_RANGE;

/* Port configuration information */
typedef struct _PORT_CONFIGURATION_INFORMATION {
    ULONG           Length;
    ULONG           SystemIoBusNumber;
    INTERFACE_TYPE  AdapterInterfaceType;
    ULONG           BusInterruptLevel;
    ULONG           BusInterruptVector;
    KINTERRUPT_MODE InterruptMode;
    ULONG           MaximumTransferLength;
    ULONG           NumberOfPhysicalBreaks;
    ULONG           DmaChannel;
    ULONG           DmaPort;
    DMA_WIDTH       DmaWidth;
    DMA_SPEED       DmaSpeed;
    ULONG           AlignmentMask;
    ULONG           NumberOfAccessRanges;
    ACCESS_RANGE    (*AccessRanges)[];
    PVOID           Reserved;
    UCHAR           NumberOfBuses;
    UCHAR           InitiatorBusId[8];
    BOOLEAN         ScatterGather;
    BOOLEAN         Master;
    BOOLEAN         CachesData;
    BOOLEAN         AdapterScansDown;
    BOOLEAN         AtdiskPrimaryClaimed;
    BOOLEAN         AtdiskSecondaryClaimed;
    BOOLEAN         Dma32BitAddresses;
    BOOLEAN         DemandMode;
    BOOLEAN         MapBuffers;
    BOOLEAN         NeedPhysicalAddresses;
    BOOLEAN         TaggedQueuing;
    BOOLEAN         AutoRequestSense;
    BOOLEAN         MultipleRequestPerLu;
    BOOLEAN         ReceiveEvent;
    BOOLEAN         RealModeInitialized;
    BOOLEAN         BufferAccessScsiPortControlled;
    UCHAR           MaximumNumberOfTargets;
    UCHAR           ReservedUchars[2];
    ULONG           SlotNumber;
    ULONG           BusInterruptLevel2;
    ULONG           BusInterruptVector2;
    KINTERRUPT_MODE InterruptMode2;
    ULONG           DmaChannel2;
    ULONG           DmaPort2;
    DMA_WIDTH       DmaWidth2;
    DMA_SPEED       DmaSpeed2;
    ULONG           DeviceExtensionSize;
    ULONG           SpecificLuExtensionSize;
    ULONG           SrbExtensionSize;
    UCHAR           Dma64BitAddresses;
    BOOLEAN         ResetTargetSupported;
    UCHAR           MaximumNumberOfLogicalUnits;
    BOOLEAN         WmiDataProvider;
#ifdef _NTSTORPORT_
    STOR_SYNCHRONIZATION_MODEL  SynchronizationModel;
    PHW_MESSAGE_SIGNALED_INTERRUPT_ROUTINE  HwMSInterruptRoutine;
    INTERRUPT_SYNCHRONIZATION_MODE  InterruptSynchronizationMode;
    MEMORY_REGION   DumpRegion;
    ULONG           RequestedDumpBufferSize;
    BOOLEAN         VirtualDevice;
    ULONG           ExtendedFlags1;
    ULONG           MaxNumberOfIO;
#endif
} PORT_CONFIGURATION_INFORMATION;
typedef PORT_CONFIGURATION_INFORMATION  *PPORT_CONFIGURATION_INFORMATION;

/* SCSI adapter control types */
typedef enum _SCSI_ADAPTER_CONTROL_TYPE {
    ScsiQuerySupportedControlTypes      = 0,
    ScsiStopAdapter                     = 1,
    ScsiRestartAdapter                  = 2,
    ScsiSetBootConfig                   = 3,
    ScsiSetRunningConfig                = 4,
    ScsiAdapterControlMax               = 5,
    MakeAdapterControlTypeSizeOfUlong   = 0xFFFFFFFF
} SCSI_ADAPTER_CONTROL_TYPE;
typedef SCSI_ADAPTER_CONTROL_TYPE   *PSCSI_ADAPTER_CONTROL_TYPE;

/* SCSI adapter control status */
typedef enum _SCSI_ADAPTER_CONTROL_STATUS {
    ScsiAdapterControlSuccess       = 0,
    ScsiAdapterControlUnsuccessful  = 1
} SCSI_ADAPTER_CONTROL_STATUS;
typedef SCSI_ADAPTER_CONTROL_STATUS *PSCSI_ADAPTER_CONTROL_STATUS;

/* SCSI supported control type list */
typedef struct _SCSI_SUPPORTED_CONTROL_TYPE_LIST {
    ULONG   MaxControlType;
    BOOLEAN SupportedTypeList[1];
} SCSI_SUPPORTED_CONTROL_TYPE_LIST;
typedef SCSI_SUPPORTED_CONTROL_TYPE_LIST    *PSCSI_SUPPORTED_CONTROL_TYPE_LIST;

/* SCSI request block */
typedef struct _SCSI_REQUEST_BLOCK {
    USHORT                      Length;
    UCHAR                       Function;
    UCHAR                       SrbStatus;
    UCHAR                       ScsiStatus;
    UCHAR                       PathId;
    UCHAR                       TargetId;
    UCHAR                       Lun;
    UCHAR                       QueueTag;
    UCHAR                       QueueAction;
    UCHAR                       CdbLength;
    UCHAR                       SenseInfoBufferLength;
    ULONG                       SrbFlags;
    ULONG                       DataTransferLength;
    ULONG                       TimeOutValue;
    PVOID                       DataBuffer;
    PVOID                       SenseInfoBuffer;
    struct _SCSI_REQUEST_BLOCK  *NextSrb;
    PVOID                       OriginalRequest;
    PVOID                       SrbExtension;
    union {
        ULONG   InternalStatus;
        ULONG   QueueSortKey;
        ULONG   LinkTimeoutValue;
    };
    UCHAR                       Cdb[16];
} SCSI_REQUEST_BLOCK;
typedef SCSI_REQUEST_BLOCK  *PSCSI_REQUEST_BLOCK;

/* SCSI request block size */
#define SCSI_REQUEST_BLOCK_SIZE sizeof( SCSI_REQUEST_BLOCK )

/* SCSI WMI request block */
typedef struct _SCSI_WMI_REQUEST_BLOCK {
    USHORT  Length;
    UCHAR   Function;
    UCHAR   SrbStatus;
    UCHAR   WMISubFunction;
    UCHAR   PathId;
    UCHAR   TargetId;
    UCHAR   Lun;
    UCHAR   Reserved1;
    UCHAR   WMIFlags;
    UCHAR   Reserved2[2];
    ULONG   SrbFlags;
    ULONG   DataTransferLength;
    ULONG   TimeOutValue;
    PVOID   DataBuffer;
    PVOID   DataPath;
    PVOID   Reserved3;
    PVOID   OriginalRequest;
    PVOID   SubExtension;
    ULONG   Reserved4;
    UCHAR   Reserved5[16];
} SCSI_WMI_REQUEST_BLOCK;
typedef SCSI_WMI_REQUEST_BLOCK  *PSCSI_WMI_REQUEST_BLOCK;

/* Storage device power states */
typedef enum _STOR_DEVICE_POWER_STATE {
    StorPowerDeviceUnspecified  = 0,
    StorPowerDeviceD0           = 1,
    StorPowerDeviceD1           = 2,
    StorPowerDeviceD2           = 3,
    StorPowerDeviceD3           = 4,
    StorPowerDeviceMaximum      = 5
} STOR_DEVICE_POWER_STATE;
typedef STOR_DEVICE_POWER_STATE *PSTOR_DEVICE_POWER_STATE;

/* Storage power actions */
typedef enum {
    StorPowerActionNone             = 0,
    StorPowerActionReserved         = 1,
    StorPowerActionSleep            = 2,
    StorPowerActionHibernate        = 3,
    StorPowerActionShutdown         = 4,
    StorPowerActionShutdownReset    = 5,
    StorPowerActionShutdownOff      = 6,
    StorPowerActionWarmEject        = 7
} STOR_POWER_ACTION;
typedef STOR_POWER_ACTION   *PSTOR_POWER_ACTION;

/* SCSI power request block */
typedef struct _SCSI_POWER_REQUEST_BLOCK {
    USHORT                      Length;
    UCHAR                       Function;
    UCHAR                       SrbStatus;
    UCHAR                       SrbPowerFlags;
    UCHAR                       PathId;
    UCHAR                       TargetId;
    UCHAR                       Lun;
    STOR_DEVICE_POWER_STATE     DevicePowerState;
    ULONG                       SrbFlags;
    ULONG                       DataTransferLength;
    ULONG                       TimeOutValue;
    PVOID                       DataBuffer;
    PVOID                       SenseInfoBuffer;
    struct _SCSI_REQUEST_BLOCK  *NextSrb;
    PVOID                       OriginalRequest;
    PVOID                       SrbExtension;
    STOR_POWER_ACTION           PowerAction;
    UCHAR                       Reserved5[16];
} SCSI_POWER_REQUEST_BLOCK;
typedef SCSI_POWER_REQUEST_BLOCK    *PSCSI_POWER_REQUEST_BLOCK;

/* Storage Plug and Play actions */
typedef enum {
    StorStartDevice                 = 0x00,
    StorRemoveDevice                = 0x02,
    StorStopDevice                  = 0x04,
    StorQueryCapabilities           = 0x09,
    StorQueryResourceRequirements   = 0x0B,
    StorFilterResourceRequirements  = 0x0D,
    StorSurpriseRemoval             = 0x17
} STOR_PNP_ACTION;
typedef STOR_PNP_ACTION *PSTOR_PNP_ACTION;

/* Storage device capabilities */
typedef struct _STOR_DEVICE_CAPABILITIES {
    USHORT  Version;
    ULONG   DeviceD1            : 1;
    ULONG   DeviceD2            : 2;
    ULONG   LockSupported       : 1;
    ULONG   EjectSupported      : 1;
    ULONG   Removable           : 1;
    ULONG   DockDevice          : 1;
    ULONG   UniqueID            : 1;
    ULONG   SilentInstall       : 1;
    ULONG   SurpriseRemovalOK   : 1;
    ULONG   NoDisplayInUI       : 1;
} STOR_DEVICE_CAPABILITIES;
typedef STOR_DEVICE_CAPABILITIES    *PSTOR_DEVICE_CAPABILITIES;

/* SCSI Plug and Play request block */
typedef struct _SCSI_PNP_REQUEST_BLOCK {
    USHORT                      Length;
    UCHAR                       Function;
    UCHAR                       SrbStatus;
    UCHAR                       PnPSubFunction;
    UCHAR                       PathId;
    UCHAR                       TargetId;
    UCHAR                       Lun;
    STOR_PNP_ACTION             PnPAction;
    ULONG                       SrbFlags;
    ULONG                       DataTransferLength;
    ULONG                       TimeOutValue;
    PVOID                       DataBuffer;
    PVOID                       SenseInfoBuffer;
    struct _SCSI_REQUEST_BLOCK  *NextSrb;
    PVOID                       OriginalRequest;
    PVOID                       SrbExtension;
    ULONG                       SrbPnPFlags;
    UCHAR                       Reserved4[16];
} SCSI_PNP_REQUEST_BLOCK;
typedef SCSI_PNP_REQUEST_BLOCK  *PSCSI_PNP_REQUEST_BLOCK;

/* Hardware callbacks */
typedef BOOLEAN (NTAPI *PHW_INITIALIZE)( PVOID );
typedef BOOLEAN (NTAPI *PHW_STARTIO)( PVOID, PSCSI_REQUEST_BLOCK );
typedef BOOLEAN (NTAPI *PHW_INTERRUPT)( PVOID );
typedef VOID (NTAPI *PHW_TIMER)( PVOID );
typedef VOID (NTAPI *PHW_DMA_STARTED)( PVOID );
typedef ULONG (NTAPI *PHW_FIND_ADAPTER)( PVOID, PVOID, PVOID, PCHAR, PPORT_CONFIGURATION_INFORMATION, PBOOLEAN );
typedef BOOLEAN (NTAPI *PHW_RESET_BUS)( PVOID, ULONG );
typedef BOOLEAN (NTAPI *PHW_ADAPTER_STATE)( PVOID, PVOID, BOOLEAN );
typedef SCSI_ADAPTER_CONTROL_STATUS (NTAPI *PHW_ADAPTER_CONTROL)( PVOID, SCSI_ADAPTER_CONTROL_TYPE, PVOID );

/* SCSI notification types */
typedef enum _SCSI_NOTIFICATION_TYPE {
    RequestComplete             = 0,
    NextRequest                 = 1,
    NextLuRequest               = 2,
    ResetDetected               = 3,
    CallDisableInterrupts       = 4,
    CallEnableInterrupts        = 5,
    RequestTimerCall            = 6,
    BusChangeDetected           = 7,
    WMIEvent                    = 8,
    WMIReregister               = 9,
    LinkUp                      = 10,
    LinkDown                    = 11,
    QueryTickCount              = 12,
    BufferOverrunDetected       = 13,
#ifdef _NTSTORPORT_
    TraceNotification           = 14,
    GetExtendedFunctionTable    = 15,
    EnablePassiveInitialization = 0x1000,
    InitializeDpc               = 0x1001,
    IssueDpc                    = 0x1002,
    AcquireSpinLock             = 0x1003,
    ReleaseSpinLock             = 0x1004
#else
    TraceNotification           = 14
#endif
} SCSI_NOTIFICATION_TYPE;
typedef SCSI_NOTIFICATION_TYPE  *PSCSI_NOTIFICATION_TYPE;

/* Hardware initialization data */
typedef struct _HW_INITIALIZATION_DATA {
    ULONG               HwInitializationDataSize;
    INTERFACE_TYPE      AdapterInterfaceType;
    PHW_INITIALIZE      HwInitialize;
    PHW_STARTIO         HwStartIo;
    PHW_INTERRUPT       HwInterrupt;
    PHW_FIND_ADAPTER    HwFindAdapter;
    PHW_RESET_BUS       HwResetBus;
    PHW_DMA_STARTED     HwDmaStarted;
    PHW_ADAPTER_STATE   HwAdapterState;
    ULONG               DeviceExtensionSize;
    ULONG               SpecificLuExtensionSize;
    ULONG               SrbExtensionSize;
    ULONG               NumberOfAccessRanges;
    PVOID               Reserved;
    BOOLEAN             MapBuffers;
    BOOLEAN             NeedPhysicalAddresses;
    BOOLEAN             TaggedQueuing;
    BOOLEAN             AutoRequestSense;
    BOOLEAN             MultipleRequestPerLu;
    BOOLEAN             ReceiveEvent;
    USHORT              VendorIdLength;
    PVOID               VendorId;
    union {
        USHORT  ReservedUshort;
        USHORT  PortVersionFlags;
    };
    USHORT              DeviceIdLength;
    PVOID               DeviceId;
    PHW_ADAPTER_CONTROL HwAdapterControl;
#ifdef _NTSTORPORT_
    PHW_BUILDIO         HwBuildIo;
#endif
} HW_INITIALIZATION_DATA;
typedef HW_INITIALIZATION_DATA  *PHW_INITIALIZATION_DATA;

/* Functions in SCSIPORT.SYS */
SCSIPORT_API VOID __cdecl   ScsiDebugPrint( ULONG, PCCHAR, ... );
SCSIPORT_API VOID NTAPI     ScsiPortCompleteRequest( PVOID, UCHAR, UCHAR, UCHAR, UCHAR );
SCSIPORT_API ULONG NTAPI    ScsiPortConvertPhysicalAddressToUlong( SCSI_PHYSICAL_ADDRESS );
SCSIPORT_API SCSI_PHYSICAL_ADDRESS NTAPI    ScsiPortConvertUlongToPhysicalAddress( ULONG_PTR );
SCSIPORT_API VOID NTAPI     ScsiPortFlushDma( PVOID );
SCSIPORT_API VOID NTAPI     ScsiPortFreeDeviceBase( PVOID, PVOID );
SCSIPORT_API ULONG NTAPI    ScsiPortGetBusData( PVOID, ULONG, ULONG, ULONG, PVOID, ULONG );
SCSIPORT_API PVOID NTAPI    ScsiPortGetDeviceBase( PVOID, INTERFACE_TYPE, ULONG, SCSI_PHYSICAL_ADDRESS, ULONG, BOOLEAN );
SCSIPORT_API PVOID NTAPI    ScsiPortGetLogicalUnit( PVOID, UCHAR, UCHAR, UCHAR );
SCSIPORT_API SCSI_PHYSICAL_ADDRESS NTAPI    ScsiPortGetPhysicalAddress( PVOID, PSCSI_REQUEST_BLOCK, PVOID, ULONG * );
SCSIPORT_API PSCSI_REQUEST_BLOCK NTAPI  ScsiPortGetSrb( PVOID, UCHAR, UCHAR, UCHAR, LONG );
SCSIPORT_API PVOID NTAPI    ScsiPortGetUncachedExtension( PVOID, PPORT_CONFIGURATION_INFORMATION, ULONG );
SCSIPORT_API PVOID NTAPI    ScsiPortGetVirtualAddress( PVOID, SCSI_PHYSICAL_ADDRESS );
SCSIPORT_API ULONG NTAPI    ScsiPortInitialize( PVOID, PVOID, struct _HW_INITIALIZATION_DATA *, PVOID );
SCSIPORT_API VOID NTAPI     ScsiPortIoMapTransfer( PVOID, PSCSI_REQUEST_BLOCK, PVOID, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortLogError( PVOID, PSCSI_REQUEST_BLOCK, UCHAR, UCHAR, UCHAR, ULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortMoveMemory( PVOID, PVOID, ULONG );
SCSIPORT_API VOID __cdecl   ScsiPortNotification( SCSI_NOTIFICATION_TYPE, PVOID, ... );
SCSIPORT_API VOID NTAPI     ScsiPortQuerySystemTime( PLARGE_INTEGER );
SCSIPORT_API VOID NTAPI     ScsiPortReadPortBufferUchar( PUCHAR, PUCHAR, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortReadPortBufferUlong( PULONG, PULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortReadPortBufferUshort( PUSHORT, PUSHORT, ULONG );
SCSIPORT_API UCHAR NTAPI    ScsiPortReadPortUchar( PUCHAR );
SCSIPORT_API ULONG NTAPI    ScsiPortReadPortUlong( PULONG );
SCSIPORT_API USHORT NTAPI   ScsiPortReadPortUshort( PUSHORT );
SCSIPORT_API VOID NTAPI     ScsiPortReadRegisterBufferUchar( PUCHAR, PUCHAR, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortReadRegisterBufferUlong( PULONG, PULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortReadRegisterBufferUshort( PUSHORT, PUSHORT, ULONG );
SCSIPORT_API UCHAR NTAPI    ScsiPortReadRegisterUchar( PUCHAR );
SCSIPORT_API ULONG NTAPI    ScsiPortReadRegisterUlong( PULONG );
SCSIPORT_API USHORT NTAPI   ScsiPortReadRegisterUshort( PUSHORT );
SCSIPORT_API ULONG NTAPI    ScsiPortSetBusDataByOffset( PVOID, ULONG, ULONG, ULONG, PVOID, ULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortStallExecution( ULONG );
SCSIPORT_API BOOLEAN NTAPI  ScsiPortValidateRange( PVOID, INTERFACE_TYPE, ULONG, SCSI_PHYSICAL_ADDRESS, ULONG, BOOLEAN );
SCSIPORT_API VOID NTAPI     ScsiPortWritePortBufferUchar( PUCHAR, PUCHAR, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWritePortBufferUlong( PULONG, PULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWritePortBufferUshort( PUSHORT, PUSHORT, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWritePortUchar( PUCHAR, UCHAR );
SCSIPORT_API VOID NTAPI     ScsiPortWritePortUlong( PULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWritePortUshort( PUSHORT, USHORT );
SCSIPORT_API VOID NTAPI     ScsiPortWriteRegisterBufferUchar( PUCHAR, PUCHAR, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWriteRegisterBufferUlong( PULONG, PULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWriteRegisterBufferUshort( PUSHORT, PUSHORT, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWriteRegisterUchar( PUCHAR, UCHAR );
SCSIPORT_API VOID NTAPI     ScsiPortWriteRegisterUlong( PULONG, ULONG );
SCSIPORT_API VOID NTAPI     ScsiPortWriteRegisterUshort( PUSHORT, USHORT );

/* Functions implemented as macros */
#define ScsiPortConvertPhysicalAddressToUlong( x )      ((x).LowPart)
#define ScsiPortConvertPhysicalAddressToULongPtr( x )   ((ULONG_PTR)((x).QuadPart))
#if DBG
    #define DebugPrint( x )                             ScsiDebugPrint x
#else
    #define DebugPrint( x )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTSRB_ */
