/*
 * This file is part of the ipcfg tool
 * http://picotcp4dos.sourceforge.net
 *
 * Copyright (C) 2015 Mateusz Viste
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef PICOCONF_H_SENTINEL
#define PICOCONF_H_SENTINEL

#include <stdio.h>  /* required for FILE */

FILE *picoconf_open(char *filename);
void picoconf_close(FILE *fd);
int picoconf_getint(FILE *fd, int *pktint);
int picoconf_getip(FILE *fd, unsigned char *addr, int *masklen);
int picoconf_getrt(FILE *fd, unsigned char *addr, int *prefixlen, unsigned char *gw);
int picoconf_getdns(FILE *fd, unsigned char *addr);

#endif
