; #####################################

; SHOW_ROTATE, SHOW_TX, SHOW_RX, MSG (and WART), SHOW_STATS, SHOW_PROTO:
; functions used to output different kinds of data to the screen
; (or possibly an offscreen buffer, config is in terminal-data.asm)

SHOW_ROTATE:	; rotates position of status-, proto- and help-line
	push ax
	push bx
	push cx
	push dx
	push si
	push di
	push bp
		push ds
	cld
	mov ax,es
	mov ds,ax	; to ease movsw...
	; example: A         B         C        D
	; before statline, protoline,helpline (buf)
	; after  protoline,helpline, statline (buf)
	; -> copy stat to buf, proto to where stat was,
	;    help to where proto was, and buf to where help was
	xor bx,bx
	mov bh,[cs:statline]
		BX2DI	; di: where stat is and proto will be
	sub [cs:statpos],di	; SUB stat
	add [cs:protopos],di		; ADD proto
	add [cs:tstart],di		; ADD ... echo1
	add [cs:tend],di		; ADD ... echo2
	add [cs:tpos],di		; ADD ... echo3
	mov si,di
	  push si	; store where stat is
	xor bx,bx
	mov bh,[cs:rotoline]
		BX2DI	; di: where buf is
	  mov bp,di	; store where buf is
	mov cx,[cs:cols]
	mov dx,cx	; cols
	rep movsw	; COPY stat to buf
	xor bx,bx
	mov bh,[cs:protoline]	
		BX2DI	; di: where proto is
	sub [cs:protopos],di	; SUB proto
	sub [cs:tstart],di	; SUB ... echo1
	sub [cs:tend],di	; SUB ... echo2
	sub [cs:tpos],di	; SUB ... echo3
	add [cs:msgstart],di		; ADD help1
	add [cs:msgend],di		; ADD help2
	mov si,di
	  mov ax,di	; store where proto is
	  pop di	; restore where stat was and proto will be
	mov cx,dx	; cols
	rep movsw	; COPY proto to new position
	  mov di,ax	; restore where proto was and help will be
	  mov si,di	; save
	xor bx,bx
	mov bh,[cs:helpline]
		BX2DI	; di: where help was and stat (from buf) will be
	sub [cs:msgstart],di	; SUB help1
	sub [cs:msgend],di	; SUB help2
	add [cs:statpos],di		; ADD stat
	  push di	; save for last copy
	  xchg si,di	; restore, put di into si
	mov cx,dx	; cols
	rep movsw	; COPY help to new position
	mov si,bp	; from buf...
	  pop di	; ...to where help was
	mov cx,dx	; cols
	rep movsw	; COPY stat to new position
		pop ds
		; ^- copying is done, restore DS (to CS)
		; now we rotate the lines (statline, protoline, helpline)
		; We have already set up the new linear positions: -old +new
	mov ax,[cs:statline]
	mov bx,[cs:protoline]
	mov cx,[cs:helpline]
	mov [protoline],ax	; proto is now where stat  was
	mov [helpline],bx	; help  is now where proto was
	mov [statline],cx	; stat  is now where help  was
	pop bp
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	ret

; #####################################

SHOW_TX:        ; show AL/AX in mini-circular-rawbuffer:
		; the local echo facility!
        PUSH ax
        PUSH bx
        PUSH di
        cmp ax,-1
        jz wasnt_sent
        mov bx,ax
        mov di,[cs:tpos]
_txok:  mov ax,[cs:attr]
        mov al,bl
        stosw
        mov [tpos],di
        cmp di,[cs:tend]
        jb _txok2
        mov di,[cs:tstart]
        mov [tpos],di
_txok2: mov ax,[cs:attr]
        stosw
wasnt_sent:
        POP di
        POP bx
        POP ax
        RET

; #####################################

SHOW_RX:        ; show char in AL/AX in main output window
	cmp byte [ans_expect],1	; flag: we are inside an ANSI sequence
	jz srx_ansi
	cmp al,27	; char 27 (ESC) would start a new sequence
	jz srx_new_ansi

srx_tty:	; we are outside ANSI mode	
                call TTY
	jmp short srx_done

srx_new_ansi:
	mov byte [ans_expect],1	; now we are inside a new sequence
	mov word [abufptr],abuffer	; *offset* flush recovery buffer
	mov word [aparptr],apars	; *offset* flush argument buffer
	xor ax,ax
	mov [apars],ax			; flush argument buffer
	mov [apars+2],ax
	mov [abuffer],ax		; really flush recovery buffer
	jmp short srx_done	; the ESC is implicit and not processed

srx_ansi:	; we are really inside a sequence
		call ANSI
		nop
		nop
		nop
	jnc srx_done	; sequence still in progress
	jz srx_recover	; sequence was aborted
srx_eof:	; carry: end of sequence or error in sequence
	mov byte [ans_expect],0		; flag: no longer inside sequence
	jmp short srx_done

srx_recover:	; sequence could not be parsed
	push bx
	mov bx,arecover	; *offset*
srx_recshow:		; show the buffered unparsed sequence
	mov al,[cs:bx]
	inc bx
	or al,al
	jz srx_recdone
		call TTY
	jmp short srx_recshow	; loop until 0 encountered
srx_recdone:	; done with recovering
	mov al,[cs:bx-2]	; last non NULL char
	cmp al,27
	jnz srx_notweird	; previous sequence aborted because of ESC?
	mov byte [ans_expect],0
	call SHOW_RX		; we are NESTING to store the fact!
	pop bx
	jmp short srx_done	; do not reset ans_expect: new seq has begun
srx_notweird:
	pop bx
	jmp short srx_eof	; sequence is aborted -and- at end

srx_done:
        RET

; #####################################

MSG:		; to show a help message or similar stuff:
        PUSH ax	; show string on DS:SI to special message area on screen,
        PUSH si	; special char 1 means "wait and scroll"
        PUSH di
        mov di,[cs:msgstart]
        mov ax,[cs:attr]
msglp:  lodsb
        dec al
        jz msglf
        inc al
        jz msgeof
mnorm:  stosw
        cmp di,[cs:msgend]
        jb msglp
        mov di,[cs:msgstart]
        jmp short msglp
msglf:  PUSH cx
        mov cx,60
                call WART
        mov di,[cs:msgstart]
        mov ax,[cs:attr]
        mov cx,[cs:cols]
        rep stosw
        POP cx
        mov di,[cs:msgstart]
        jmp short msglp
msgeof: POP di
        POP si
        POP ax
        RET

; helper function for MSG to wait for a while:

WART:   PUSH ax         ; CX V-Syncs (8, 1 waere H-Syncs)
        PUSH dx
        mov dx,[cs:crtport]
        add dx,6
wmono:  in al,dx
        IODLY     ; 6x86 delay
        test al,8
        jz wmono
wmono2: in al,dx
        IODLY     ; 6x86 delay
        test al,8
        jnz wmono2
        loop wmono
        POP dx
        POP ax
        RET

; #####################################

SHOW_STATS:	; converts the 16bit comstats value to a human-readable
	PUSH ax	; list of keywords
        PUSH bx
        PUSH cx
        PUSH dx
        PUSH si
        PUSH di
	mov ax,[cs:comstats]
        mov di,[cs:statpos]
        mov si,mybits	; *offset*
        mov cx,16       ; 16 Bits
        mov bx,ax
statlp: mov ax,[cs:attr]
        mov al,ah
        shl bx,1
        jc stat1
stat0:  and ah,077h     ; no brigth/blink
stat1:  mov dx,5        ; fixed len
statsh: lodsb
        stosw
        dec dx
        jnz statsh
        loop statlp
        POP di
        POP si
        POP dx
        POP cx
        POP bx
        POP ax
        RET

; #####################################

SHOW_PROTO:	; shows line speed, CR policies for send and receive,
        PUSH ax	; and [the low byte hshake as a bit field]
        PUSH bx	; new 10/2001: show ANSI [simulated LED bit field] as well
        PUSH cx
        PUSH si
        PUSH di
        mov di,[cs:protopos]
pr_sp:  mov si,[cs:linespeed]
        shl si,1
        shl si,1
        lea si,[bauds+si]	; select one of the speed descriptions
        mov ax,[cs:attr]
        mov cx,4
pr_lp1: lodsb
        stosw
        loop pr_lp1
        mov al,' '
        stosw
        mov si,[cs:crpolicy]
        shl si,1
        shl si,1
        lea si,[crsends+si]	; select one of the CR send descriptions
        mov cx,4
pr_lp2: lodsb
        stosw
        loop pr_lp2
        mov al,' '
        stosw
        mov bx,[cs:hshake]
        and bx,00ffh
        test word [crpolicy],8000h
        jz pr_na
        or bx,100h	; convert CR receive policy to a "9th hshake bit"
pr_na:  mov cl,7
        shl bx,cl
        mov cx,9
        mov si,crgets	; *offset*	; has to be right in front of hshakes!
pr_lp3: mov ax,[cs:attr]	; convert the hshake bit field to a string
        shl bx,1
        jc pr_on
pr_off: and ah,77h      ; no bright/blink
pr_on:  PUSH cx
        mov cx,5
pr_lp4: lodsb
        stosw
        loop pr_lp4
        POP cx
        loop pr_lp3
	mov al,' '
	stosw
	stosw
pr_led:	mov bl,[cs:rled]	; prepare display of LED simulation
	mov si,rleds	; *offset*
	mov cx,4
pr_lp5:	mov ax,[cs:attr]
	test bl,1
	jnz pr_le1
	and ah,11h	; off means darker... and blue-er :-)
pr_le1:	lodsb
	stosw
	shr bl,1	; next LED (low bit shown first...)
	loop pr_lp5
	mov al,' '
	stosw
	stosw
        POP di
        POP si
        POP cx
        POP bx
        POP ax
        RET

; #####################################
