/*  Start

    Copyright (c) Joe Cosentino 2000.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <conio.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define MAX_CHARS 81
#define NEWLINE   "\r\n"

#define TRUE  1
#define FALSE 0

// G L O B A L S ////////////////////////////////////////////////////////////

// Added by Brian E. Reifsnyder 9/24/00
char filename[256], path[256];

typedef struct Program_Information
{
    char program[256];
    char description[256];
}PI;

PI prog_info;

// P R O T O T Y P E S //////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[]);
int error(char *);
int read_ini(char heading[30]);

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
	{
	argptr = rawargs[index];
	if (*argptr == '/')
	    {
	    argptr++;
	    optargs[kndex++] = argptr;
	    } // end if.
	else
	    {
	    fileargs[jndex++] = argptr;
	    } // end else.

	} // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

int error(char *error)
{
    fprintf(stderr, "%s\n", error);
    return 1;

} // end error.

/////////////////////////////////////////////////////////////////////////////

int read_ini(char heading[30])
{
  // INI file parsing routine modified, from Free FDISK's INI file parsing
  // routine, by Brian E. Reifsnyder for this program.
  // Added 9/24/00
  char char_number[2];
  char command_buffer[20];
  char home_path[255];
  char line_buffer[256];
  char setting_buffer[20];

  char *line_buffer_pointer;

  int index=0;
  int command_ok=FALSE;
  int description_found=FALSE;
  int done_looking=FALSE;
  int end_of_file_marker_encountered=FALSE;
  int heading_found=FALSE;
  int number;
  int object_found=FALSE;
  int program_found=FALSE;
  int sub_buffer_index=0;

  long line_counter=1;
  long setting;

  FILE *file;

  strcpy(home_path,path);
  strcat(home_path,"START.DAT");

  /* Search the directory Start resides in before searching the PATH      */
  /* in the environment for the start.dat file.                           */
  file=fopen(home_path,"rt");

  if(!file) file=fopen(searchpath("START.DAT"),"rt");

  if(file)
    {
    while(fgets(line_buffer,255,file) !=NULL)
      {
      if( (0!=strncmp(line_buffer,";",1))
       && (0!=strncmp(line_buffer,"999",3))
       && (end_of_file_marker_encountered==FALSE)
       && (heading_found==TRUE) )
	{
	if(0==strncmp(line_buffer,"[",1))
	  {
	  if(program_found==TRUE) return TRUE;
	  return FALSE;
	  }

	/* Clear the command_buffer and setting_buffer */
	index=0;

	do
	  {
	  command_buffer[index]=0x00;
	  setting_buffer[index]=0x00;

	  index++;
	  }while(index<20);

	/* Extract the command and setting from the line_buffer */

	/* Find the command */
	index=0;
	sub_buffer_index=0;
	done_looking=FALSE;
	object_found=FALSE;
	do
	  {
	  if( (line_buffer[index]!='=') && ( (line_buffer[index]>=0x30) && (line_buffer[index]<=0x7a) ) )
	    {
	    object_found=TRUE;
	    command_buffer[sub_buffer_index]=line_buffer[index];
	    sub_buffer_index++;
	    }

	  if( (object_found==TRUE) && ( (line_buffer[index]=='=') || (line_buffer[index]==' ') ) )
	    {
	    //command_buffer[sub_buffer_index]=0x0a;
	    done_looking=TRUE;
	    }

	  if(line_buffer[index]==0x0a)
	    {
	    if(program_found==TRUE) return TRUE;
	    return FALSE;
	    }

	  if( (index==254) || (line_buffer[index]==0x0a) )
	    {
            printf("Error encountered on line %n of the \"START.DAT\" file...Program Terminated.\n",line_counter);
	    exit(3);
	    }

	  index++;
	  }while(done_looking==FALSE);

	/* Find the setting */
	sub_buffer_index=0;
	object_found=FALSE;
	done_looking=FALSE;

	do
	  {
	  if( (line_buffer[index]!='=') && ( ( (line_buffer[index]>=0x30) && (line_buffer[index]<=0x7a) ) || (line_buffer[index]=='-') ) )
	    {
	    object_found=TRUE;
	    setting_buffer[sub_buffer_index]=line_buffer[index];
	    sub_buffer_index++;
	    }

	  if( (object_found==TRUE) && (line_buffer[index]==0x0a) )
	    {
	    done_looking=TRUE;
	    //setting_buffer[sub_buffer_index]=0x0a;
	    }

	  if(index==254)
	    {
            printf("Error encountered on line %d of the \"START.DAT\" file...Program Terminated.\n",line_counter);
	    exit(3);
	    }

	  index++;
	  }while(done_looking==FALSE);

	/* Process the command found in the line buffer */

	command_ok=FALSE;

	/* Check for the PROGRAM statement */
	if(0==stricmp(command_buffer,"PROGRAM"))
	  {
	  strcpy(prog_info.program,setting_buffer);

	  command_ok=TRUE;
	  program_found=TRUE;
	  }

	/* Check for the DESCRIPTION statement */
	if(0==stricmp(command_buffer,"DESCRIPTION"))
	  {
	  strcpy(prog_info.description,setting_buffer);

	  description_found=TRUE;
	  command_ok=TRUE;
	  }

	if(command_ok==FALSE)
	  {
          printf("Error encountered on line %d of the \"START.DAT\" file...Program Terminated.\n",line_counter);
	  exit(3);
	  }

	}

      if(0==strncmp(line_buffer,"999",3)) end_of_file_marker_encountered=TRUE;

      if(0==strncmp(line_buffer,heading,strlen(heading))) heading_found=TRUE;

      if( (program_found==TRUE) && (description_found==TRUE) ) return TRUE;

      line_counter++;
      }

    fclose(file);
    }

  return FALSE;

} // end read_ini.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    char *fileargs[64], *optargs[64], searchfile[] = "START.DAT", pathbuffer[_MAX_PATH], datEntry[30], *ext, *offset, dest[MAX_CHARS], *tmp;
    int index, help_flag=0, w_flag=0, n_options, n_files, handle;
    unsigned count;
    struct ffblk file;
    struct find_t ffblk;

    // Added by Brian E. Reifsnyder
    char command_line[256], program_name[25];
    int location, dot_location;

    // Place the filename of this program into filename.
    index=strlen(argv[0]);
    location=0;
    do
        {
        if (argv[0] [index]=='\\')
            {
            location=index+1;
            index=-1;
            } // end if.

        index--;
        } // end do.
    while (index>=0);

    index=location;
    do
        {
        filename[index-location]=argv[0] [index];
        index++;
        } // end do.
    while (index<=(strlen(argv[0])));

    index=0;
    do
        {
        if (filename[index]=='.')
            filename[index]=0;

        index++;
        } // end do.
    while (index<12);

    if (location>0)                     // Place the path of this program into path.
        {
        index=0;
        do
            {
            path[index]=argv[0] [index];
            index++;
            } // end do.
        while (index<location);

        path[index]=0;
        } // end if.
    else
        path[0]=0;

    n_options = classify_args(argc, argv, fileargs, optargs);
    n_files = argc - n_options;
    for (index=0;index<n_options;index++)
	{
	if (optargs[index][0] == '?') help_flag=1;
        else if (optargs[index][0] == 'W' || optargs[index][0] == 'w') w_flag=1;
	else
	    {
	    printf("Invalid parameter - /%s\n", strupr(optargs[index]));
	    exit(1);
	    } // end else.

	} // end for.

    if (help_flag)
	{
	printf("Starts a FreeDOS program.\n\n"
               "Syntax: START [/W] program [args] [/?]\n"
               "  /W  Does not return until the other program exits\n"
               "  /?  Displays this help message\n");
	exit(1);
	} // end if.

    // See if the correct number of parameters is on the command line.
    if (n_files < 2)
	{
	printf("Required parameter missing\n");
	return 1;
	} // end if.

    // Look for START.DAT in START environment variable, then disk.
    _searchenv(searchfile, "START", pathbuffer);
    if (*pathbuffer != '\0')
	{
	} // end if.

    // Search for the file the user wants to start.
    if (_dos_findfirst(fileargs[1], _A_NORMAL, &ffblk) != 0)
	{
	fprintf(stderr, "The file you specified, '%s' does not exist.\n", fileargs[1]);
	return 1;
	} // end if.

    // Save the program name.
    strcpy(program_name,fileargs[1]);

    // Get program extension.
    ext=strrchr(fileargs[1], '.');
    if (ext==NULL)
	strcpy(datEntry,"[DEFAULT]");
    else
	{
	*ext++ = '\0';

	// Build the string.
	strcpy(datEntry, "[");
	strcat(datEntry, ext);
	strcat(datEntry, "]");
	strupr(datEntry);
	} // end else.

    if (FALSE==read_ini(datEntry))
	{
	printf("No application is associated with the specified file.\n");
	return -1;
	} // end if.

    // Create command line
    strcpy(command_line,prog_info.program);
    strcat(command_line," ");
    strcat(command_line,program_name);
    command_line[(strlen(command_line)+1)]=0;
    command_line[strlen(command_line)]=13;

    if (w_flag)
        {
        tmp = system(command_line);
        spawnl(P_WAIT, tmp, NULL);
        return 0;
        } // end if.

    system(command_line);
    return 0;

} // end main.
