''
''
'' accctrl -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_accctrl_bi__
#define __win_accctrl_bi__

#define AccFree LocalFree
#define ACTRL_RESERVED &h00000000
#define ACTRL_ACCESS_PROTECTED &h00000001
#define ACTRL_ACCESS_ALLOWED &h00000001
#define ACTRL_ACCESS_DENIED &h00000002
#define ACTRL_AUDIT_SUCCESS &h00000004
#define ACTRL_AUDIT_FAILURE &h00000008
#define ACTRL_SYSTEM_ACCESS &h04000000
#define ACTRL_DELETE &h08000000
#define ACTRL_READ_CONTROL &h10000000
#define ACTRL_CHANGE_ACCESS &h20000000
#define ACTRL_CHANGE_OWNER &h40000000
#define ACTRL_SYNCHRONIZE &h80000000
#define ACTRL_STD_RIGHTS_ALL &hf8000000
#define ACTRL_FILE_READ &h00000001
#define ACTRL_FILE_WRITE &h00000002
#define ACTRL_FILE_APPEND &h00000004
#define ACTRL_FILE_READ_PROP &h00000008
#define ACTRL_FILE_WRITE_PROP &h00000010
#define ACTRL_FILE_EXECUTE &h00000020
#define ACTRL_FILE_READ_ATTRIB &h00000080
#define ACTRL_FILE_WRITE_ATTRIB &h00000100
#define ACTRL_FILE_CREATE_PIPE &h00000200
#define ACTRL_DIR_LIST &h00000001
#define ACTRL_DIR_CREATE_OBJECT &h00000002
#define ACTRL_DIR_CREATE_CHILD &h00000004
#define ACTRL_DIR_DELETE_CHILD &h00000040
#define ACTRL_DIR_TRAVERSE &h00000020
#define ACTRL_KERNEL_TERMINATE &h00000001
#define ACTRL_KERNEL_THREAD &h00000002
#define ACTRL_KERNEL_VM &h00000004
#define ACTRL_KERNEL_VM_READ &h00000008
#define ACTRL_KERNEL_VM_WRITE &h00000010
#define ACTRL_KERNEL_DUP_HANDLE &h00000020
#define ACTRL_KERNEL_PROCESS &h00000040
#define ACTRL_KERNEL_SET_INFO &h00000080
#define ACTRL_KERNEL_GET_INFO &h00000100
#define ACTRL_KERNEL_CONTROL &h00000200
#define ACTRL_KERNEL_ALERT &h00000400
#define ACTRL_KERNEL_GET_CONTEXT &h00000800
#define ACTRL_KERNEL_SET_CONTEXT &h00001000
#define ACTRL_KERNEL_TOKEN &h00002000
#define ACTRL_KERNEL_IMPERSONATE &h00004000
#define ACTRL_KERNEL_DIMPERSONATE &h00008000
#define ACTRL_PRINT_SADMIN &h00000001
#define ACTRL_PRINT_SLIST &h00000002
#define ACTRL_PRINT_PADMIN &h00000004
#define ACTRL_PRINT_PUSE &h00000008
#define ACTRL_PRINT_JADMIN &h00000010
#define ACTRL_SVC_GET_INFO &h00000001
#define ACTRL_SVC_SET_INFO &h00000002
#define ACTRL_SVC_STATUS &h00000004
#define ACTRL_SVC_LIST &h00000008
#define ACTRL_SVC_START &h00000010
#define ACTRL_SVC_STOP &h00000020
#define ACTRL_SVC_PAUSE &h00000040
#define ACTRL_SVC_INTERROGATE &h00000080
#define ACTRL_SVC_UCONTROL &h00000100
#define ACTRL_REG_QUERY &h00000001
#define ACTRL_REG_SET &h00000002
#define ACTRL_REG_CREATE_CHILD &h00000004
#define ACTRL_REG_LIST &h00000008
#define ACTRL_REG_NOTIFY &h00000010
#define ACTRL_REG_LINK &h00000020
#define ACTRL_WIN_CLIPBRD &h00000001
#define ACTRL_WIN_GLOBAL_ATOMS &h00000002
#define ACTRL_WIN_CREATE &h00000004
#define ACTRL_WIN_LIST_DESK &h00000008
#define ACTRL_WIN_LIST &h00000010
#define ACTRL_WIN_READ_ATTRIBS &h00000020
#define ACTRL_WIN_WRITE_ATTRIBS &h00000040
#define ACTRL_WIN_SCREEN &h00000080
#define ACTRL_WIN_EXIT &h00000100
#define ACTRL_ACCESS_NO_OPTIONS &h00000000
#define ACTRL_ACCESS_SUPPORTS_OBJECT_ENTRIES &h00000001
#define ACCCTRL_DEFAULT_PROVIDER "Windows NT Access Provider"
#define TRUSTEE_ACCESS_ALLOWED &h00000001L
#define TRUSTEE_ACCESS_READ &h00000002L
#define TRUSTEE_ACCESS_WRITE &h00000004L
#define TRUSTEE_ACCESS_EXPLICIT &h00000001L
#define TRUSTEE_ACCESS_READ_WRITE (&h00000002L or &h00000004L)
#define TRUSTEE_ACCESS_ALL &hFFFFFFFFL
#define NO_INHERITANCE &h0
#define SUB_OBJECTS_ONLY_INHERIT &h1
#define SUB_CONTAINERS_ONLY_INHERIT &h2
#define SUB_CONTAINERS_AND_OBJECTS_INHERIT &h3
#define INHERIT_NO_PROPAGATE &h4
#define INHERIT_ONLY &h8
#define INHERITED_ACCESS_ENTRY &h10
#define INHERITED_PARENT &h10000000
#define INHERITED_GRANDPARENT &h20000000

type INHERIT_FLAGS as ULONG
type PINHERIT_FLAGS as ULONG ptr
type ACCESS_RIGHTS as ULONG
type PACCESS_RIGHTS as ULONG ptr

enum ACCESS_MODE
	NOT_USED_ACCESS = 0
	GRANT_ACCESS
	SET_ACCESS
	DENY_ACCESS
	REVOKE_ACCESS
	SET_AUDIT_SUCCESS
	SET_AUDIT_FAILURE
end enum

enum SE_OBJECT_TYPE
	SE_UNKNOWN_OBJECT_TYPE = 0
	SE_FILE_OBJECT
	SE_SERVICE
	SE_PRINTER
	SE_REGISTRY_KEY
	SE_LMSHARE
	SE_KERNEL_OBJECT
	SE_WINDOW_OBJECT
	SE_DS_OBJECT
	SE_DS_OBJECT_ALL
	SE_PROVIDER_DEFINED_OBJECT
	SE_WMIGUID_OBJECT
	SE_REGISTRY_WOW64_32KEY
end enum

enum TRUSTEE_TYPE
	TRUSTEE_IS_UNKNOWN
	TRUSTEE_IS_USER
	TRUSTEE_IS_GROUP
	TRUSTEE_IS_DOMAIN
	TRUSTEE_IS_ALIAS
	TRUSTEE_IS_WELL_KNOWN_GROUP
	TRUSTEE_IS_DELETED
	TRUSTEE_IS_INVALID
	TRUSTEE_IS_COMPUTER
end enum

enum TRUSTEE_FORM
	TRUSTEE_IS_SID
	TRUSTEE_IS_NAME
	TRUSTEE_BAD_FORM
	TRUSTEE_IS_OBJECTS_AND_SID
	TRUSTEE_IS_OBJECTS_AND_NAME
end enum

enum MULTIPLE_TRUSTEE_OPERATION
	NO_MULTIPLE_TRUSTEE
	TRUSTEE_IS_IMPERSONATE
end enum

#ifndef UNICODE
type TRUSTEE_A
	pMultipleTrustee as TRUSTEE_A ptr
	MultipleTrusteeOperation as MULTIPLE_TRUSTEE_OPERATION
	TrusteeForm as TRUSTEE_FORM
	TrusteeType as TRUSTEE_TYPE
	ptstrName as LPSTR
end type

type PTRUSTEE_A as TRUSTEE_A ptr
type TRUSTEEA as TRUSTEE_A
type PTRUSTEEA as TRUSTEE_A ptr

type ACTRL_ACCESS_ENTRYA
	Trustee as TRUSTEE_A
	fAccessFlags as ULONG
	Access as ACCESS_RIGHTS
	ProvSpecificAccess as ACCESS_RIGHTS
	Inheritance as INHERIT_FLAGS
	lpInheritProperty as LPCSTR
end type

type PACTRL_ACCESS_ENTRYA as ACTRL_ACCESS_ENTRYA ptr

type ACTRL_ACCESS_ENTRY_LISTA
	cEntries as ULONG
	pAccessList as ACTRL_ACCESS_ENTRYA ptr
end type

type PACTRL_ACCESS_ENTRY_LISTA as ACTRL_ACCESS_ENTRY_LISTA ptr

type ACTRL_PROPERTY_ENTRYA
	lpProperty as LPCSTR
	pAccessEntryList as PACTRL_ACCESS_ENTRY_LISTA
	fListFlags as ULONG
end type

type PACTRL_PROPERTY_ENTRYA as ACTRL_PROPERTY_ENTRYA ptr

type ACTRL_ALISTA
	cEntries as ULONG
	pPropertyAccessList as PACTRL_PROPERTY_ENTRYA
end type

type PACTRL_ACCESSA as ACTRL_ALISTA ptr
type ACTRL_AUDITA as ACTRL_ALISTA
type PACTRL_AUDITA as ACTRL_ALISTA ptr

type TRUSTEE_ACCESSA
	lpProperty as LPSTR
	Access as ACCESS_RIGHTS
	fAccessFlags as ULONG
	fReturnedAccess as ULONG
end type

type PTRUSTEE_ACCESSA as TRUSTEE_ACCESSA ptr

#else ''UNICODE
type TRUSTEE_W
	pMultipleTrustee as TRUSTEE_W ptr
	MultipleTrusteeOperation as MULTIPLE_TRUSTEE_OPERATION
	TrusteeForm as TRUSTEE_FORM
	TrusteeType as TRUSTEE_TYPE
	ptstrName as LPWSTR
end type

type PTRUSTEE_W as TRUSTEE_W ptr
type TRUSTEEW as TRUSTEE_W
type PTRUSTEEW as TRUSTEE_W ptr

type ACTRL_ACCESS_ENTRYW
	Trustee as TRUSTEE_W
	fAccessFlags as ULONG
	Access as ACCESS_RIGHTS
	ProvSpecificAccess as ACCESS_RIGHTS
	Inheritance as INHERIT_FLAGS
	lpInheritProperty as LPCWSTR
end type

type PACTRL_ACCESS_ENTRYW as ACTRL_ACCESS_ENTRYW ptr

type ACTRL_ACCESS_ENTRY_LISTW
	cEntries as ULONG
	pAccessList as ACTRL_ACCESS_ENTRYW ptr
end type

type PACTRL_ACCESS_ENTRY_LISTW as ACTRL_ACCESS_ENTRY_LISTW ptr

type ACTRL_PROPERTY_ENTRYW
	lpProperty as LPCWSTR
	pAccessEntryList as PACTRL_ACCESS_ENTRY_LISTW
	fListFlags as ULONG
end type

type PACTRL_PROPERTY_ENTRYW as ACTRL_PROPERTY_ENTRYW ptr

type ACTRL_ALISTW
	cEntries as ULONG
	pPropertyAccessList as PACTRL_PROPERTY_ENTRYW
end type

type PACTRL_ACCESSW as ACTRL_ALISTW ptr
type ACTRL_AUDITW as ACTRL_ALISTW
type PACTRL_AUDITW as ACTRL_ALISTW ptr

type TRUSTEE_ACCESSW
	lpProperty as LPWSTR
	Access as ACCESS_RIGHTS
	fAccessFlags as ULONG
	fReturnedAccess as ULONG
end type

type PTRUSTEE_ACCESSW as TRUSTEE_ACCESSW ptr

#endif ''UNICODE

type ACTRL_OVERLAPPED
	union
		Provider as PVOID
		Reserved1 as ULONG
	end union
	Reserved2 as ULONG
	hEvent as HANDLE
end type

type PACTRL_OVERLAPPED as ACTRL_OVERLAPPED ptr

type OBJECTS_AND_SID
	ObjectsPresent as DWORD
	ObjectTypeGuid as GUID
	InheritedObjectTypeGuid as GUID
	pSid as SID ptr
end type

type POBJECTS_AND_SID as OBJECTS_AND_SID ptr

#ifndef UNICODE
type ACTRL_ACCESS_INFOA
	fAccessPermission as ULONG
	lpAccessPermissionName as LPSTR
end type

type PACTRL_ACCESS_INFOA as ACTRL_ACCESS_INFOA ptr

type ACTRL_CONTROL_INFOA
	lpControlId as LPSTR
	lpControlName as LPSTR
end type

type PACTRL_CONTROL_INFOA as ACTRL_CONTROL_INFOA ptr

type EXPLICIT_ACCESS_A
	grfAccessPermissions as DWORD
	grfAccessMode as ACCESS_MODE
	grfInheritance as DWORD
	Trustee as TRUSTEE_A
end type

type PEXPLICIT_ACCESS_A as EXPLICIT_ACCESS_A ptr
type EXPLICIT_ACCESSA as EXPLICIT_ACCESS_A
type PEXPLICIT_ACCESSA as EXPLICIT_ACCESS_A ptr

type OBJECTS_AND_NAME_A
	ObjectsPresent as DWORD
	ObjectType as SE_OBJECT_TYPE
	ObjectTypeName as LPSTR
	InheritedObjectTypeName as LPSTR
	ptstrName as LPSTR
end type

type POBJECTS_AND_NAME_A as OBJECTS_AND_NAME_A ptr

type INHERITED_FROMA
	GenerationGap as LONG
	AncestorName as LPSTR
end type

type PINHERITED_FROMA as INHERITED_FROMA ptr

#else ''UNICODE
type ACTRL_ACCESS_INFOW
	fAccessPermission as ULONG
	lpAccessPermissionName as LPWSTR
end type

type PACTRL_ACCESS_INFOW as ACTRL_ACCESS_INFOW ptr

type ACTRL_CONTROL_INFOW
	lpControlId as LPWSTR
	lpControlName as LPWSTR
end type

type PACTRL_CONTROL_INFOW as ACTRL_CONTROL_INFOW ptr

type EXPLICIT_ACCESS_W
	grfAccessPermissions as DWORD
	grfAccessMode as ACCESS_MODE
	grfInheritance as DWORD
	Trustee as TRUSTEE_W
end type

type PEXPLICIT_ACCESS_W as EXPLICIT_ACCESS_W ptr
type EXPLICIT_ACCESSW as EXPLICIT_ACCESS_W
type PEXPLICIT_ACCESSW as EXPLICIT_ACCESS_W ptr

type OBJECTS_AND_NAME_W
	ObjectsPresent as DWORD
	ObjectType as SE_OBJECT_TYPE
	ObjectTypeName as LPWSTR
	InheritedObjectTypeName as LPWSTR
	ptstrName as LPWSTR
end type

type POBJECTS_AND_NAME_W as OBJECTS_AND_NAME_W ptr

type INHERITED_FROMW
	GenerationGap as LONG
	AncestorName as LPWSTR
end type

type PINHERITED_FROMW as INHERITED_FROMW ptr

#endif ''UNICODE

#ifdef UNICODE

type TRUSTEE_ as TRUSTEE_W
type PTRUSTEE_ as TRUSTEE_W ptr
type TRUSTEE as TRUSTEEW
type PTRUSTEE as TRUSTEEW ptr
type ACTRL_ACCESS as ACTRL_ACCESSW
type PACTRL_ACCESS as ACTRL_ACCESSW ptr
type ACTRL_ACCESS_ENTRY_LIST as ACTRL_ACCESS_ENTRY_LISTW
type PACTRL_ACCESS_ENTRY_LIST as ACTRL_ACCESS_ENTRY_LISTW ptr
type ACTRL_ACCESS_INFO as ACTRL_ACCESS_INFOW
type PACTRL_ACCESS_INFO as ACTRL_ACCESS_INFOW ptr
type ACTRL_ACCESS_ENTRY as ACTRL_ACCESS_ENTRYW
type PACTRL_ACCESS_ENTRY as ACTRL_ACCESS_ENTRYW ptr
type ACTRL_AUDIT as ACTRL_AUDITW
type PACTRL_AUDIT as ACTRL_AUDITW ptr
type ACTRL_CONTROL_INFO as ACTRL_CONTROL_INFOW
type PACTRL_CONTROL_INFO as ACTRL_CONTROL_INFOW ptr
type EXPLICIT_ACCESS_ as EXPLICIT_ACCESS_W
type PEXPLICIT_ACCESS_ as EXPLICIT_ACCESS_W ptr
type EXPLICIT_ACCESS as EXPLICIT_ACCESSW
type PEXPLICIT_ACCESS as EXPLICIT_ACCESSW ptr
type TRUSTEE_ACCESS as TRUSTEE_ACCESSW
type PTRUSTEE_ACCESS as TRUSTEE_ACCESSW ptr
type OBJECTS_AND_NAME_ as OBJECTS_AND_NAME_W
type POBJECTS_AND_NAME_ as OBJECTS_AND_NAME_W ptr
type INHERITED_FROM as INHERITED_FROMA
type PINHERITED_FROM as INHERITED_FROMA ptr

#else ''UNICODE

type TRUSTEE_ as TRUSTEE_A
type PTRUSTEE_ as TRUSTEE_A ptr
type TRUSTEE as TRUSTEEA
type PTRUSTEE as TRUSTEEA ptr
type ACTRL_ACCESS as ACTRL_ACCESSA
type PACTRL_ACCESS as ACTRL_ACCESSA ptr
type ACTRL_ACCESS_ENTRY_LIST as ACTRL_ACCESS_ENTRY_LISTA
type PACTRL_ACCESS_ENTRY_LIST as ACTRL_ACCESS_ENTRY_LISTA ptr
type ACTRL_ACCESS_INFO as ACTRL_ACCESS_INFOA
type PACTRL_ACCESS_INFO as ACTRL_ACCESS_INFOA ptr
type ACTRL_ACCESS_ENTRY as ACTRL_ACCESS_ENTRYA
type PACTRL_ACCESS_ENTRY as ACTRL_ACCESS_ENTRYA ptr
type ACTRL_AUDIT as ACTRL_AUDITA
type PACTRL_AUDIT as ACTRL_AUDITA ptr
type ACTRL_CONTROL_INFO as ACTRL_CONTROL_INFOA
type PACTRL_CONTROL_INFO as ACTRL_CONTROL_INFOA ptr
type EXPLICIT_ACCESS_ as EXPLICIT_ACCESS_A
type PEXPLICIT_ACCESS_ as EXPLICIT_ACCESS_A ptr
type EXPLICIT_ACCESS as EXPLICIT_ACCESSA
type PEXPLICIT_ACCESS as EXPLICIT_ACCESSA ptr
type TRUSTEE_ACCESS as TRUSTEE_ACCESSA
type PTRUSTEE_ACCESS as TRUSTEE_ACCESSA ptr
type OBJECTS_AND_NAME_ as OBJECTS_AND_NAME_A
type POBJECTS_AND_NAME_ as OBJECTS_AND_NAME_A ptr
type INHERITED_FROM as INHERITED_FROMW
type PINHERITED_FROM as INHERITED_FROMW ptr

#endif ''UNICODE

#endif
