REM
REM  Loads an external palette from a JASC palette file
REM  This file is part of the ANSiMat project.
REM  Copyright (C) Mateusz Viste 2010
REM
REM  gopher://gopher.viste-family.net/1/projects/ansimat/
REM

FUNCTION LoadCustomPalette(PalFile AS STRING) AS BYTE
  DIM AS BYTE Result = 0
  DIM AS INTEGER PalFileHandler, R, G, B, x
  DIM AS STRING LineBuff
  PalFileHandler = FREEFILE
  IF OPEN(PalFile, FOR INPUT AS #PalFileHandler) = 0 THEN
      LINE INPUT #PalFileHandler, LineBuff
      IF LineBuff = "JASC-PAL" THEN
          LINE INPUT #PalFileHandler, LineBuff  ' Palette version, I don't care
          LINE INPUT #PalFileHandler, LineBuff  ' Number of colors
          IF VAL(LineBuff) = 256 THEN
              FOR x = 0 TO 255
                INPUT #PalFileHandler, R, G, B
                AnsiPallette(x) = RGB(R, G, B)
              NEXT x
            ELSE
              Result = 3 ' Palette is not 256 colors
          END IF
        ELSE
          Result = 2 ' Not a valid palette file
      END IF
    ELSE
      Result = 1 ' File could not be open
  END IF
  CLOSE #PalFileHandler
  RETURN Result
END FUNCTION
