REM
REM Saves the content of BigScreenBuffer to OutFile as a PCX graphic file.
REM Returns 0 if everything went fine, non-zero if a problem occured.
REM


FUNCTION SavePcxFile(BYREF OutFile AS STRING, BYREF xlimit AS INTEGER, BYREF ylimit AS INTEGER) AS BYTE
  DIM AS BYTE Result = 0
  DIM AS INTEGER x, y, PcxFileHandler
  DIM AS UBYTE RleCounter = 0, OldPixel
  PcxFileHandler = FREEFILE
  OPEN OutFile FOR OUTPUT AS #PcxFileHandler
  REM Write PCX header
  PRINT #PcxFileHandler, CHR(10);                     ' ZSoft file ID
  PRINT #PcxFileHandler, CHR(5);                      ' PCX version
  PRINT #PcxFileHandler, CHR(1);                      ' encoding (1 = RLE)
  PRINT #PcxFileHandler, CHR(8);                      ' Bits depth
  PRINT #PcxFileHandler, CHR(0, 0);                   ' xmin
  PRINT #PcxFileHandler, CHR(0, 0);                   ' ymin
  PRINT #PcxFileHandler, IntToDoubleByte(xlimit - 1); ' xmax
  PRINT #PcxFileHandler, IntToDoubleByte(ylimit - 1); ' ymax
  PRINT #PcxFileHandler, CHR(44, 1);                  ' Horizontal DPI (2 bytes)
  PRINT #PcxFileHandler, CHR(44, 1);                  ' Vertical DPI (2 bytes)
  PRINT #PcxFileHandler, STRING(48, 0);               ' Palette for 16 colors (48 bytes)
  PRINT #PcxFileHandler, CHR(0);                      ' reserved
  PRINT #PcxFileHandler, CHR(1);                      ' number of color planes
  PRINT #PcxFileHandler, IntToDoubleByte(xlimit);     ' nb of bytes per line (in 8bit mode = image width)
  PRINT #PcxFileHandler, CHR(1, 0);                   ' PaletteType (1=color/bw  2=grayscale)
  PRINT #PcxFileHandler, CHR(0, 0);                   ' HScrSize (optional)
  PRINT #PcxFileHandler, CHR(0, 0);                   ' VScrSize (optional)
  PRINT #PcxFileHandler, STRING(54, 0);               ' Filler
  REM Write PCX image data
  FOR y = 0 TO ylimit - 1
    OldPixel = BigScreenBuffer(0, y)
    RleCounter = 1
    FOR x = 1 TO xlimit - 1
      IF BigScreenBuffer(x, y) = OldPixel AND RleCounter < 63 THEN
          RleCounter += 1
        ELSE
          IF RleCounter > 1 OR OldPixel > 191 THEN PRINT #PcxFileHandler, CHR(RleCounter OR 192);
          PRINT #PcxFileHandler, CHR(OldPixel);
          RleCounter = 1
          OldPixel = BigScreenBuffer(x, y)
      END IF
    NEXT x
    IF RleCounter > 1 OR OldPixel > 191 THEN PRINT #PcxFileHandler, CHR(RleCounter OR 192);
    PRINT #PcxFileHandler, CHR(OldPixel);
  NEXT y
  REM Write RGB palette (768 bytes)
  PRINT #PcxFileHandler, CHR(12);                                        ' Palette byte ID
  FOR x = 0 TO 255
    PRINT #PcxFileHandler, CHR((AnsiPallette(x) SHR 16) AND &b11111111); ' Write Red value
    PRINT #PcxFileHandler, CHR((AnsiPallette(x) SHR 8) AND &b11111111);  ' Write Green value
    PRINT #PcxFileHandler, CHR((AnsiPallette(x)) AND &b11111111);        ' Write Blue value
  NEXT x
  CLOSE #PcxFileHandler
  RETURN Result
END FUNCTION
