-- encrypt.e - Encryption/decryption wrappers - HIP 2.0
-- Copyright (C) 2000  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file provides routines for acessing the available encryption
-- algorithms, so that other files do not need to have separate code for
-- each algorithm. This makes them easier to program and understand, and
-- simplifies the process of adding other encryption algorithms.

constant include_name = "encrypt.e"

include sha1.e
include stream.e


global function expand_key (sequence key, atom len)
    -- Expands the key to the desired length using SHA-1
    sequence expanded_key
    expanded_key = {}

    while length(expanded_key) < len do
	expanded_key = expanded_key & sha_1 (key & expanded_key)
    end while

    return expanded_key [1..len]
end function


atom algorithm_used         -- This will store the current algorithm

constant default_keylen = 32    -- 256 bits
global procedure init_encryption (atom algorithm, sequence key, sequence iv)
    -- Initializes the encryption, according to the algorithm used.
    -- key: the passphrase (of arbitrary length)
    -- iv: a 64-bit (8-byte) Initialization Vector
    -- algorithm: the algorithm to be used to encrypt the data

    atom key_length

    algorithm_used = algorithm

    -- Set key length
    key_length = enc_algs [algorithm_used][ALG_KEYSIZE]
    if key_length = 0 then key_length = default_keylen end if

    key = expand_key (key, key_length)  -- Expand key

    -- Adjust IV length
    while length (iv) < enc_algs [algorithm_used][ALG_BLOCKSIZE] do
	iv = iv & iv
    end while
    iv = iv [1..enc_algs [algorithm_used][ALG_BLOCKSIZE]]


    init_stream (algorithm, key, iv)
end procedure



global function identify_encryption_algorithm (sequence key, sequence iv,
		sequence cypher, sequence plain)
    -- Tries to find an algorithm that will decrypt the cyphertext
    -- to the correct plaintext, using the specified key.

    for x = 1 to length (enc_algs) do
	-- Test each encryption algorithm

	-- Init decryption
	init_encryption (x, key, iv)

	-- Compare decrypted data
	if compare (decrypt_data (cypher), plain) = 0 then
	    -- It is the same, algorithm found
	    return x
	end if
    end for

    return 0    -- No match (wrong key, probably)
end function


