-- errors.e - Error constants and crash routines - HIP 2.0
-- Copyright (C) 2000  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file contains error codes for the program, and provides routines
-- for aborting the program when an error occurs.

include machine.e
include file.e

include constant.e

global constant INFO_LASTBLOCK = -100

-- integer write_log, log_file
-- write_log = 0


-- Default crash message
crash_message ("HIP has just crashed!\n\n" &
	    "An unknown error has occurred while HIP was running.\n\n" &
	    "Please report this error to davitf@eml.cc, describing in detail\n" &
	    "what was happening when the program crashed. If there is a file\n"&
	    "named ex.err in the directory HIP is located, please include it\n"&
	    "as well.\n")

-- Error handling procedure
global procedure abort_error (sequence file, sequence routine, sequence error_msg)
    -- Aborts the program with a crash message, writing an ex.err file.
    -- This routine is only called when there is a bug in the program.

    puts(2,

	    "HIP has just crashed!\n\n" &
	    "The following error has occurred while HIP was running:\n" &
	    sprintf("%s in %s : %s\n\n", {routine, file, error_msg}) &
	    "Please report this error to davitf@eml.cc, describing in detail\n" &
	    "what was happening when the program crashed. If there is a file\n"&
	    "named ex.err in the directory HIP is located, please include it\n"&
	    "as well.\n")

    crash_message ("")  -- Show no error message on abort

    ? 1/0   -- Create a stupid error so that an ex.err file is generated.
    -- ex.err will not be written if the program is run with the
    -- public-domain version.

    abort(1)    -- Just to be sure the program will stop
end procedure

global procedure end_program (sequence message)
    -- Aborts the program with an error message
    puts (1, message & '\n')
    abort (1)
end procedure

-- global constant LOG_NONE = 0, LOG_IMPORTANT = 1, LOG_DETAIL = 2, LOG_ALL = 3
--
-- global procedure start_log (integer log_level)
--
--     if log_level = 0 and write_log != 0 then
--         printf(log_file, "Logging stopped at %02d-%02d-%02d %02d:%02d:%02d\n\n",date())
--         close (log_file)
--
--     elsif log_level != 0 and write_log = 0 then
--         log_file = open ("hip.log", "a")
--         if log_file = -1 then
--             puts(1,"Unable to open log file\n")
--             puts(1,"Press any key to continue...\n")
--             while get_key()=-1 do
--             end while
--         end if
--
--         printf(log_file, "Logging with level %d at %02d-%02d-%02d %02d:%02d:%02d\n",log_level&date())
--         flush (log_file)
--     end if
--
--     write_log = log_level
-- end procedure
--
-- global procedure log_info (sequence message, atom level)
--     if level <= write_log then
--         puts(log_file, message&'\n')
--         flush (log_file)
--     end if
-- end procedure
--
-- global procedure log_info_s (sequence message, object vars, atom level)
--     if level <= write_log then
--         puts(log_file, sprintf(message&'\n', vars))
--         flush (log_file)
--     end if
--
-- end procedure

