function Setup() {
    Println("Setup!");

    mouse = { x: 0, y: 0, flags: 0 };

    // mod = new Module("examples/StefanII.mod");
    // Println(mod.songname);
    // Println(mod.modtype);
    // Println(mod.comment);
    // Println(mod.num_channels);
    // mod.Play();
    // ModuleStop();

    bmp = new Bitmap("examples/dojs.bmp");
    png = new Bitmap("examples/dojs.png");

    gp = new Bitmap("examples/gptest.png");
}

function Loop() {
    TextXY(10, 10, "rate=" + GetFramerate(), EGA.BLACK, EGA.LIGHT_BLUE);

    // Plot(30, 30, EGA.RED);
    // var c = GetPixel(30, 30);
    // Println("RED:" + typeof c);
    // Println("  r=" + c.GetRed());
    // Println("  g=" + c.GetGreen());
    // Println("  b=" + c.GetBlue());

    // Plot(30, 30, EGA.GREEN);
    // var c = GetPixel(30, 30);
    // Println("GREEN:");
    // Println("  r=" + c.GetRed());
    // Println("  g=" + c.GetGreen());
    // Println("  b=" + c.GetBlue());

    var c = gp.GetPixel(0, 0);
    Println("0x0:" + typeof c);
    Println("  r=" + c.GetRed());
    Println("  g=" + c.GetGreen());
    Println("  b=" + c.GetBlue());
    var c = gp.GetPixel(1, 0);
    Println("1x0:" + typeof c);
    Println("  r=" + c.GetRed());
    Println("  g=" + c.GetGreen());
    Println("  b=" + c.GetBlue());
    var c = gp.GetPixel(2, 0);
    Println("2x0:" + typeof c);
    Println("  r=" + c.GetRed());
    Println("  g=" + c.GetGreen());
    Println("  b=" + c.GetBlue());
    var c = gp.GetPixel(3, 0);
    Println("3x0:" + typeof c);
    Println("  r=" + c.GetRed());
    Println("  g=" + c.GetGreen());
    Println("  b=" + c.GetBlue());

    gp.Draw(20, 20);

    //DirTest();
    // IPXtest();
    //GlobalTest();
    //FileTest();
    //Gc(true);
    //Println("Memory=" + JSON.stringify(MemoryInfo()));
    // OldScreens();

    //   Stop();
}

function DirTest() {
    Println(JSON.stringify(Stat("jsboot")));
    Println(JSON.stringify(Stat("runit.bat")));

    var files = List(".");
    Println(JSON.stringify(files));
    files.forEach(function (e) {
        var i = Stat(e);
        Println(e + '\t' + i.size + '\t' + new Date(i.mtime));
    });
}

function Input(e) {
    mouse = e;
}

function IPXtest() {
    Println("IPX available = " + IPX_AVAILABLE);

    IpxSocketOpen(0x4711);
    Println("Socket open");

    Println(JSON.stringify(IpxGetLocalAddress()));

    IpxSend("Hello World!", IPX.BROADCAST);
    Println("Sent");

    while (!IpxCheckPacket()) {
        Sleep(100);
    }
    Println(JSON.stringify(IpxGetPacket()));

    IpxSend("Hello World!", IPX.BROADCAST);
    Println("Sent2");

    IpxSocketClose();
    Println("Socket closed");
}

function FileTest() {
    var outfile = new File("TEST.TXT", "w");
    outfile.WriteLine("line!");
    outfile.Close();

    var rd = Read("TEST.TXT");
    Println("read=" + rd);

    var infile = new File("TEST.TXT", "r");
    var l = infile.ReadLine();
    infile.Close();
    Println("line=" + l);
}

function GlobalTest() {
    Println("Hello World!");

    Println("num colors=" + NumColors());
    Println("num free colors=" + NumFreeColors());

    Println("size x=" + SizeX());
    Println("size y=" + SizeY());

    black = Color(0, 0, 0);
    red = Color(255, 1, 2);
    green = Color(1, 255, 2);
    blue = Color(66, 66, 255);

    Println("red = " + red.GetRed() + "/" + red.GetGreen() + "/" + red.GetBlue() + "=" + red.value);

    Println("mouse available = " + MOUSE_AVAILABLE);

    Println("arc style = " + ARC.OPEN);
    Println("arc style = " + ARC.CLOSE1);
    Println("arc style = " + ARC.CLOSE2);

    Println(JSON.stringify(red.value));
    Println(JSON.stringify(EGA));
    Println(JSON.stringify(FMMUSIC));
}

function OldScreens() {
    {
        ClearScreen(black);
        Box(8, 8, MaxX() - 8, MaxY() - 8, green);
        Ellipse(SizeX() / 2, SizeY() / 2, 10, 20, red);
        r = CircleArc(50, 50, 30, 0, 450, ARC_STYLE_CLOSE2, blue);
        Println("ArcRes = " + JSON.stringify(r));

        PolyLine([[110, 110], [110, 120], [130, 130], [110, 140]], green);

        Polygon([
            [110, 110],
            [120, 120],
            [130, 130],
            [140, 140]
        ], blue);

        FramedBox(200, 200, 240, 220, 3, [blue, red, red, green, green]);

        key = KeyRead();
    }

    {
        FloodFill(SizeX() / 2, SizeY() / 2, red, green);
        key = KeyRead();
    }

    {
        ClearScreen(black);
        FilledBox(8, 8, MaxX() - 8, MaxY() - 8, green);
        FilledEllipse(SizeX() / 2, SizeY() / 2, 10, 20, red);
        r = FilledCircleArc(50, 50, 30, 0, 450, ARC_STYLE_CLOSE2, blue);
        Println("ArcRes = " + JSON.stringify(r));
        key = KeyRead();
    }
}
