/*
 *  iads.h      Active Directory Service (ADS) interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>

#ifndef __iads_h__
#define __iads_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* String data types */
typedef LPWSTR  ADS_DN_STRING;
typedef LPWSTR  *PADS_DN_STRING;
typedef LPWSTR  ADS_CASE_EXACT_STRING;
typedef LPWSTR  *PADS_CASE_EXACT_STRING;
typedef LPWSTR  ADS_CASE_IGNORE_STRING;
typedef LPWSTR  *PADS_CASE_IGNORE_STRING;
typedef LPWSTR  ADS_PRINTABLE_STRING;
typedef LPWSTR  *PADS_PRINTABLE_STRING;
typedef LPWSTR  ADS_NUMERIC_STRING;
typedef LPWSTR  *PADS_NUMERIC_STRING;
typedef LPWSTR  ADS_OBJECT_CLASS;
typedef LPWSTR  *PADS_OBJECT_CLASS;

/* Primitive data types */
typedef DWORD           ADS_BOOLEAN;
typedef DWORD           *LPNDS_BOOLEAN;
typedef DWORD           ADS_INTEGER;
typedef DWORD           *PADS_INTEGER;
typedef SYSTEMTIME      ADS_UTC_TIME;
typedef SYSTEMTIME      *PADS_UTC_TIME;
typedef LARGE_INTEGER   ADS_LARGE_INTEGER;
typedef LARGE_INTEGER   *PADS_LARGE_INTEGER;
typedef HANDLE          ADS_SEARCH_HANDLE;
typedef HANDLE          *PADS_SEARCH_HANDLE;

/* ADS attribute control codes */
#define ADS_ATTR_CLEAR  1L
#define ADS_ATTR_UPDATE 2L
#define ADS_ATTR_APPEND 3L
#define ADS_ATTR_DELETE 4L

/* ADS GUID strings */
#define ADS_DIRSYNC_COOKIE  L"FC8CB04D-311D-406C-8CB9-1AE8B843B418"
#define ADS_VLV_RESPONSE    L"FC8CB04D-311D-406C-8CB9-1AE8B843B419"

/* ADS extended dispatch identifiers */
#define ADS_EXT_MINEXTDISPID        1
#define ADS_EXT_MAXEXTDISPID        16777215
#define ADS_EXT_INITCREDENTIALS     1
#define ADS_EXT_INITIALIZE_COMPLETE 2

/* ADS types */
typedef enum {
    ADSTYPE_INVALID                 = 0,
    ADSTYPE_DN_STRING               = 1,
    ADSTYPE_CASE_EXACT_STRING       = 2,
    ADSTYPE_CASE_IGNORE_STRING      = 3,
    ADSTYPE_PRINTABLE_STRING        = 4,
    ADSTYPE_NUMERIC_STRING          = 5,
    ADSTYPE_BOOLEAN                 = 6,
    ADSTYPE_INTEGER                 = 7,
    ADSTYPE_OCTET_STRING            = 8,
    ADSTYPE_UTC_TIME                = 9,
    ADSTYPE_LARGE_INTEGER           = 10,
    ADSTYPE_PROV_SPECIFIC           = 11,
    ADSTYPE_OBJECT_CLASS            = 12,
    ADSTYPE_CASEIGNORE_LIST         = 13,
    ADSTYPE_OCTET_LIST              = 14,
    ADSTYPE_PATH                    = 15,
    ADSTYPE_POSTALADDRESS           = 16,
    ADSTYPE_TIMESTAMP               = 17,
    ADSTYPE_BACKLINK                = 18,
    ADSTYPE_TYPEDNAME               = 19,
    ADSTYPE_HOLD                    = 20,
    ADSTYPE_NETADDRESS              = 21,
    ADSTYPE_REPLICAPOINTER          = 22,
    ADSTYPE_FAXNUMBER               = 23,
    ADSTYPE_EMAIL                   = 24,
    ADSTYPE_NT_SECURITY_DESCRIPTOR  = 25,
    ADSTYPE_UNKNOWN                 = 26,
    ADSTYPE_DN_WITH_BINARY          = 27,
    ADSTYPE_DN_WITH_STRING          = 28
} ADSTYPEENUM;
typedef ADSTYPEENUM ADSTYPE;

/* ADS octet string */
typedef struct {
    DWORD   dwLength;
    LPBYTE  lpValue;
} ADS_OCTET_STRING;
typedef ADS_OCTET_STRING    *PADS_OCTET_STRING;

/* ADS NT security descriptor */
typedef struct {
    DWORD   dwLength;
    LPBYTE  lpValue;
} ADS_NT_SECURITY_DESCRIPTOR;
typedef ADS_NT_SECURITY_DESCRIPTOR  *PADS_NT_SECURITY_DESCRIPTOR;

/* ADS provider-specific information */
typedef struct {
    DWORD   dwLength;
    LPBYTE  lpValue;
} ADS_PROV_SPECIFIC;
typedef ADS_PROV_SPECIFIC   *PADS_PROV_SPECIFIC;

/* ADS case ignore list */
typedef struct _ADS_CASEIGNORE_LIST{
    struct _ADS_CASEIGNORE_LIST *Next;
    LPWSTR                      String;
} ADS_CASEIGNORE_LIST;
typedef ADS_CASEIGNORE_LIST *PADS_CASEIGNORE_LIST;

/* ADS octet list */
typedef struct _ADS_OCTET_LIST {
    struct _ADS_OCTET_LIST  *Next;
    DWORD                   Length;
    BYTE                    *Data;
} ADS_OCTET_LIST;
typedef ADS_OCTET_LIST  *PADS_OCTET_LIST;

/* ADS path */
typedef struct {
    DWORD   Type;
    LPWSTR  VolumeName;
    LPWSTR  Path;
} ADS_PATH;
typedef ADS_PATH    *PADS_PATH;

/* ADS postal address */
typedef struct {
    LPWSTR  PostalAddress[6];
} ADS_POSTALADDRESS;
typedef ADS_POSTALADDRESS   *PADS_POSTALADDRESS;

/* ADS timestamp */
typedef struct {
    DWORD   WholeSeconds;
    DWORD   EventID;
} ADS_TIMESTAMP;
typedef ADS_TIMESTAMP   *PADS_TIMESTAMP;

/* ADS backlink */
typedef struct {
    DWORD   RemoteID;
    LPWSTR  ObjectName;
} ADS_BACKLINK;
typedef ADS_BACKLINK    *PADS_BACKLINK;

/* ADS typed name */
typedef struct {
    LPWSTR  ObjectName;
    DWORD   Level;
    DWORD   Interval;
} ADS_TYPEDNAME;
typedef ADS_TYPEDNAME   *PADS_TYPEDNAME;

/* ADS hold */
typedef struct {
    LPWSTR  ObjectName;
    DWORD   Amount;
} ADS_HOLD;
typedef ADS_HOLD    *PADS_HOLD;

/* ADS network address */
typedef struct {
    DWORD   AddressType;
    DWORD   AddressLength;
    BYTE    *Address;
} ADS_NETADDRESS;
typedef ADS_NETADDRESS  *PADS_NETADDRESS;

/* ADS replica pointer */
typedef struct {
    LPWSTR          ServerName;
    DWORD           ReplicaType;
    DWORD           ReplicaNumber;
    DWORD           Count;
    PADS_NETADDRESS ReplicaAddressHints;
} ADS_REPLICAPOINTER;
typedef ADS_REPLICAPOINTER  *PADS_REPLICAPOINTER;

/* ADS fax number */
typedef struct {
    LPWSTR  TelephoneNumber;
    DWORD   NumberOfBits;
    LPBYTE  Parameters;
} ADS_FAXNUMBER;
typedef ADS_FAXNUMBER   *PADS_FAXNUMBER;

/* ADS email */
typedef struct {
    LPWSTR  Address;
    DWORD   Type;
} ADS_EMAIL;
typedef ADS_EMAIL   *PADS_EMAIL;

/* ADS distinguished name with binary */
typedef struct {
    DWORD   dwLength;
    LPBYTE  lpBinaryValue;
    LPWSTR  pszDNString;
} ADS_DN_WITH_BINARY;
typedef ADS_DN_WITH_BINARY   *PADS_DN_WITH_BINARY;

/* ADS distinguished name with string */
typedef struct {
    LPWSTR  pszStringValue;
    LPWSTR  pszDNString;
} ADS_DN_WITH_STRING;
typedef ADS_DN_WITH_STRING  *PADS_DN_WITH_STRING;

/* ADS value */
typedef struct _adsvalue {
    ADSTYPE dwType;
    union {
        ADS_DN_STRING               DNString;
        ADS_CASE_EXACT_STRING       CaseExactString;
        ADS_CASE_IGNORE_STRING      CaseIgnoreString;
        ADS_PRINTABLE_STRING        PrintableString;
        ADS_NUMERIC_STRING          NumericString;
        ADS_BOOLEAN                 Boolean;
        ADS_INTEGER                 Integer;
        ADS_OCTET_STRING            OctetString;
        ADS_UTC_TIME                UTCTime;
        ADS_LARGE_INTEGER           LargeInteger;
        ADS_OBJECT_CLASS            ClassName;
        ADS_PROV_SPECIFIC           ProviderSpecific;
        PADS_CASEIGNORE_LIST        pCaseIgnoreList;
        PADS_OCTET_LIST             pOctetList;
        PADS_PATH                   pPath;
        PADS_POSTALADDRESS          pPostalAddress;
        ADS_TIMESTAMP               Timestamp;
        ADS_BACKLINK                BackLink;
        PADS_TYPEDNAME              pTypedName;
        ADS_HOLD                    Hold;
        PADS_NETADDRESS             pNetAddress;
        PADS_REPLICAPOINTER         pReplicaPointer;
        PADS_FAXNUMBER              pFaxNumber;
        ADS_EMAIL                   Email;
        ADS_NT_SECURITY_DESCRIPTOR  SecurityDescriptor;
        PADS_DN_WITH_BINARY         pDNWithBinary;
        PADS_DN_WITH_STRING         pDNWithString;
    };
} ADSVALUE;
typedef ADSVALUE    *PADSVALUE;
typedef ADSVALUE    *LPADSVALUE;

/* ADS attribute information */
typedef struct _ads_attr_info {
    LPWSTR      pszAttrName;
    DWORD       dwControlCode;
    ADSTYPE     dwADsType;
    PADSVALUE   pADsValues;
    DWORD       dwNumValues;
} ADS_ATTR_INFO;
typedef ADS_ATTR_INFO   *PADS_ATTR_INFO;

/* ADS authentication flags */
typedef enum {
    ADS_SECURE_AUTHENTICATION   = 0x00000001,
    ADS_USE_ENCRYPTION          = 0x00000002,
    ADS_USE_SSL                 = 0x00000002,
    ADS_READONLY_SERVER         = 0x00000004,
    ADS_PROMPT_CREDENTIALS      = 0x00000008,
    ADS_NO_AUTHENTICATION       = 0x00000010,
    ADS_FAST_BIND               = 0x00000020,
    ADS_USE_SIGNING             = 0x00000040,
    ADS_USE_SEALING             = 0x00000080,
    ADS_USE_DELEGATION          = 0x00000100,
    ADS_SERVER_BIND             = 0x00000200,
    ADS_NO_REFERRAL_CHASING     = 0x00000400
} ADS_AUTHENTICATION_ENUM;

/* ADS object information */
typedef struct _ads_object_info {
    LPWSTR  pszRDN;
    LPWSTR  pszObjectDN;
    LPWSTR  pszParentDN;
    LPWSTR  pszSchemaDN;
    LPWSTR  pszClassName;
} ADS_OBJECT_INFO;
typedef ADS_OBJECT_INFO *PADS_OBJECT_INFO;

/* ADS status codes */
typedef enum {
    ADS_STATUS_S_OK                     = 0,
    ADS_STATUS_INVALID_SEARCHPREF       = 1,
    ADS_STATUS_INVALID_SEARCHPREFVALUE  = 2
} ADS_STATUSENUM;
typedef ADS_STATUSENUM  ADS_STATUS;
typedef ADS_STATUSENUM  *PADS_STATUS;

/* ADS dereference options */
typedef enum {
    ADS_DEREF_NEVER     = 0,
    ADS_DEREF_SEARCHING = 1,
    ADS_DEREF_FINDING   = 2,
    ADS_DEREF_ALWAYS    = 3
} ADS_DEREFENUM;

/* ADS scopes */
typedef enum {
    ADS_SCOPE_BASE      = 0,
    ADS_SCOPE_ONELEVEL  = 1,
    ADS_SCOPE_SUBTREE   = 2
} ADS_SCOPEENUM;

/* ADS preferences */
typedef enum {
    ADSIPROP_ASYNCHRONOUS       = 0x00000000,
    ADSIPROP_DEREF_ALIASES      = 0x00000001,
    ADSIPROP_SIZE_LIMIT         = 0x00000002,
    ADSIPROP_TIME_LIMIT         = 0x00000003,
    ADSIPROP_ATTRIBTYPES_ONLY   = 0x00000004,
    ADSIPROP_SEARCH_SCOPE       = 0x00000005,
    ADSIPROP_TIMEOUT            = 0x00000006,
    ADSIPROP_PAGESIZE           = 0x00000007,
    ADSIPROP_PAGED_TIME_LIMIT   = 0x00000008,
    ADSIPROP_CHASE_REFERRALS    = 0x00000009,
    ADSIPROP_SORT_ON            = 0x0000000A,
    ADSIPROP_CACHE_RESULTS      = 0x0000000B,
    ADSIPROP_ADSIFLAG           = 0x0000000C
} ADS_PREFERENCES_ENUM;

/* ADS dialects */
typedef enum {
    ADSI_DIALECT_LDAP   = 0x00000000,
    ADSI_DIALECT_SQL    = 0x00000001
} ADSI_DIALECT_ENUM;

/* ADS chase referral flags */
typedef enum {
    ADS_CHASE_REFERRALS_NEVER       = 0x00000000,
    ADS_CHASE_REFERRALS_SUBORDINATE = 0x00000020,
    ADS_CHASE_REFERRALS_EXTERNAL    = 0x00000040,
    ADS_CHASE_REFERRALS_ALWAYS      = 0x00000060
} ADS_CHASE_REFERRALS_ENUM;

/* ADS search preferences */
typedef enum {
    ADS_SEARCHPREF_ASYNCHRONOUS     = 0,
    ADS_SEARCHPREF_DEREF_ALIASES    = 1,
    ADS_SEARCHPREF_SIZE_LIMIT       = 2,
    ADS_SEARCHPREF_TIME_LIMIT       = 3,
    ADS_SEARCHPREF_ATTRIBTYPES_ONLY = 4,
    ADS_SEARCHPREF_SEARCH_SCOPE     = 5,
    ADS_SEARCHPREF_TIMEOUT          = 6,
    ADS_SEARCHPREF_PAGESIZE         = 7,
    ADS_SEARCHPREF_PAGED_TIME_LIMIT = 8,
    ADS_SEARCHPREF_CHASE_REFERRALS  = 9,
    ADS_SEARCHPREF_SORT_ON          = 10,
    ADS_SEARCHPREF_CACHE_RESULTS    = 11,
    ADS_SEARCHPREF_DIRSYNC          = 12,
    ADS_SEARCHPREF_TOMBSTONE        = 13,
    ADS_SEARCHPREF_VLV              = 14,
    ADS_SEARCHPREF_ATTRIBUTE_QUERY  = 15,
    ADS_SEARCHPREF_SECURITY_MASK    = 16,
    ADS_SEARCHPREF_DIRSYNC_FLAG     = 17,
    ADS_SEARCHPREF_EXTENDED_DN      = 18
} ADS_SEARCHPREF_ENUM;
typedef ADS_SEARCHPREF_ENUM ADS_SEARCHPREF;

/* ADS password encodings */
typedef enum {
    ADS_PASSWORD_ENCODE_REQUIRE_SSL = 0,
    ADS_PASSWORD_ENCODE_CLEAR       = 1
} ADS_PASSWORD_ENCODING_ENUM;

/* ADS search preference information */
typedef struct ads_searchpref_info {
    ADS_SEARCHPREF  dwSearchPref;
    ADSVALUE        vValue;
    ADS_STATUS      dwStatus;
} ADS_SEARCHPREF_INFO;
typedef ADS_SEARCHPREF_INFO *PADS_SEARCHPREF_INFO;
typedef ADS_SEARCHPREF_INFO *LPADS_SEARCHPREF_INFO;

/* ADS search column */
typedef struct ads_search_column {
    LPWSTR      pszAttrName;
    ADSTYPE     dwADsType;
    PADSVALUE   pADsValues;
    DWORD       dwNumValues;
    HANDLE      hReserved;
} ADS_SEARCH_COLUMN;
typedef ADS_SEARCH_COLUMN   *PADS_SEARCH_COLUMN;

/* ADS attribute definition */
typedef struct _ads_attr_def {
    LPWSTR  pszAttrName;
    ADSTYPE dwADsType;
    DWORD   dwMinRange;
    DWORD   dwMaxRange;
    BOOL    fMultiValued;
} ADS_ATTR_DEF;
typedef ADS_ATTR_DEF    *PADS_ATTR_DEF;

/* ADS class definition */
typedef struct _ads_class_def {
    LPWSTR  pszClassName;
    DWORD   dwMandatoryAttrs;
    LPWSTR  *ppszMandatoryAttrs;
    DWORD   optionalAttrs;
    LPWSTR  **ppszOptionalAttrs;
    DWORD   dwNamingAttrs;
    LPWSTR  **ppszNamingAttrs;
    DWORD   dwSuperClasses;
    LPWSTR  **ppszSuperClasses;
    BOOL    fIsContainer;
} ADS_CLASS_DEF;
typedef ADS_CLASS_DEF   *PADS_CLASS_DEF;

/* ADS sort key */
typedef struct _ads_sortkey {
    LPWSTR  pszAttrType;
    LPWSTR  pszReserved;
    BOOLEAN fReverseorder;
} ADS_SORTKEY;
typedef ADS_SORTKEY *PADS_SORTKEY;

/* ADS virtual list view */
typedef struct _ads_vlv {
    DWORD   dwBeforeCount;
    DWORD   dwAfterCount;
    DWORD   dwOffset;
    DWORD   dwContentCount;
    LPWSTR  pszTarget;
    DWORD   dwContextIDLength;
    LPBYTE  lpContextID;
} ADS_VLV;
typedef ADS_VLV *PADS_VLV;

/* ADS property operations */
typedef enum {
    ADS_PROPERTY_CLEAR  = 1,
    ADS_PROPERTY_UPDATE = 2,
    ADS_PROPERTY_SEARCH = 3,
    ADS_PROPERTY_DELETE = 4
} ADS_PROPERTY_OPERATION_ENUM;

/* ADS system flags */
typedef enum {
    ADS_SYSTEMFLAG_DISALLOW_DELETE              = 0x80000000,
    ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME          = 0x40000000,
    ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE            = 0x20000000,
    ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE    = 0x10000000,
    ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME       = 0x08000000,
    ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE         = 0x04000000,
    ADS_SYSTEMFLAG_CR_NTDS_NC                   = 0x00000001,
    ADS_SYSTEMFLAG_CR_NTDS_DOMAIN               = 0x00000002,
    ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED          = 0x00000001,
    ADS_SYSTEMFLAG_ATTR_IS_CONSTRUCTED          = 0x00000004
} ADS_SYSTEMFLAG_ENUM;

/* ADS group types */
typedef enum {
    ADS_GROUP_TYPE_GLOBAL_GROUP         = 0x00000002,
    ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP   = 0x00000004,
    ADS_GROUP_TYPE_LOCAL_GROUP          = 0x00000004,
    ADS_GROUP_TYPE_UNIVERSAL_GROUP      = 0x00000008,
    ADS_GROUP_TYPE_SECURITY_ENABLED     = 0x80000000
} ADS_GROUP_TYPE_ENUM;

/* ADS user flags */
typedef enum ADS_USER_FLAG {
    ADS_UF_SCRIPT                           = 0x00000001,
    ADS_UF_ACCOUNTDISABLE                   = 0x00000002,
    ADS_UF_HOMEDIR_REQUIRED                 = 0x00000008,
    ADS_UF_LOCKOUT                          = 0x00000010,
    ADS_UF_PASSWD_NOTREQD                   = 0x00000020,
    ADS_UF_PASSWD_CANT_CHANGE               = 0x00000040,
    ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED  = 0x00000080,
    ADS_UF_TEMP_DUPLICATE_ACCOUNT           = 0x00000100,
    ADS_UF_NORMAL_ACCOUNT                   = 0x00000200,
    ADS_UF_INTERDOMAIN_TRUST_ACCOUNT        = 0x00000800,
    ADS_UF_WORKSTATION_TRUST_ACCOUNT        = 0x00001000,
    ADS_UF_SERVER_TRUST_ACCOUNT             = 0x00002000,
    ADS_UF_DONT_EXPIRE_PASSWD               = 0x00010000,
    ADS_UF_MNS_LOGON_ACCOUNT                = 0x00020000,
    ADS_UF_SMARTCARD_REQUIRED               = 0x00040000,
    ADS_UF_TRUSTED_FOR_DELEGATION           = 0x00080000,
    ADS_UF_NOT_DELEGATED                    = 0x00100000,
    ADS_UF_USE_DES_KEY_ONLY                 = 0x00200000,
    ADS_UF_DONT_REQUIRE_PREAUTH             = 0x00400000,
    ADS_UF_PASSWORD_EXPIRED                 = 0x00800000,
    ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION   = 0x01000000
} ADS_USER_FLAG_ENUM;

/* ADS rights */
typedef enum {
    ADS_RIGHT_DELETE                    = 0x00010000,
    ADS_RIGHT_READ_CONTROL              = 0x00020000,
    ADS_RIGHT_WRITE_DAC                 = 0x00040000,
    ADS_RIGHT_WRITE_OWNER               = 0x00080000,
    ADS_RIGHT_SYNCHRONIZE               = 0x00100000,
    ADS_RIGHT_ACCESS_SYSTEM_SECURITY    = 0x01000000,
    ADS_RIGHT_GENERIC_READ              = 0x80000000,
    ADS_RIGHT_GENERIC_WRITE             = 0x40000000,
    ADS_RIGHT_GENERIC_EXECUTE           = 0x20000000,
    ADS_RIGHT_GENERIC_ALL               = 0x10000000,
    ADS_RIGHT_DS_CREATE_CHILD           = 0x00000001,
    ADS_RIGHT_DS_DELETE_CHILD           = 0x00000002,
    ADS_RIGHT_ACTRL_DS_LIST             = 0x00000004,
    ADS_RIGHT_DS_SELF                   = 0x00000008,
    ADS_RIGHT_DS_READ_PROP              = 0x00000010,
    ADS_RIGHT_DS_WRITE_PROP             = 0x00000020,
    ADS_RIGHT_DS_DELETE_TREE            = 0x00000040,
    ADS_RIGHT_DS_LIST_OBJECT            = 0x00000080,
    ADS_RIGHT_DS_CONTROL_ACCESS         = 0x00000100
} ADS_RIGHTS_ENUM;

/* ADS ACE types */
typedef enum {
    ADS_ACETYPE_ACCESS_ALLOWED                  = 0x00000000,
    ADS_ACETYPE_ACCESS_DENIED                   = 0x00000001,
    ADS_ACETYPE_SYSTEM_AUDIT                    = 0x00000002,
    ADS_ACETYPE_ACCESS_ALLOWED_OBJECT           = 0x00000005,
    ADS_ACETYPE_ACCESS_DENIED_OBJECT            = 0x00000006,
    ADS_ACETYPE_SYSTEM_AUDIT_OBJECT             = 0x00000007,
    ADS_ACETYPE_SYSTEM_ALARM_OBJECT             = 0x00000008,
    ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK         = 0x00000009,
    ADS_ACETYPE_ACCESS_DENIED_CALLBACK          = 0x0000000A,
    ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK_OBJECT  = 0x0000000B,
    ADS_ACETYPE_ACCESS_DENIED_CALLBACK_OBJECT   = 0x0000000C,
    ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK           = 0x0000000D,
    ADS_ACETYPE_SYSTEM_ALARM_CALLBACK           = 0x0000000E,
    ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK_OBJECT    = 0x0000000F,
    ADS_ACETYPE_SYSTEM_ALARM_CALLBACK_OBJECT    = 0x00000010
} ADS_ACETYPE_ENUM;

/* ADS ACE flags */
typedef enum {
    ADS_ACEFLAG_INHERIT_ACE                 = 0x00000002,
    ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE    = 0x00000004,
    ADS_ACEFLAG_INHERIT_ONLY_ACE            = 0x00000008,
    ADS_ACEFLAG_INHERITED_ACE               = 0x00000010,
    ADS_ACEFLAG_VALID_INHERIT_FLAGS         = 0x0000001F,
    ADS_ACEFLAG_SUCCESSFUL_ACCESS           = 0x00000040,
    ADS_ACEFLAG_FAILED_ACCESS               = 0x00000080
} ADS_ACEFLAG_ENUM;

/* ADS flag types */
typedef enum {
    ADS_FLAG_OBJECT_TYPE_PRESENT            = 0x00000001,
    ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT  = 0x00000002
} ADS_FLAGTYPE_ENUM;

/* ADS security descriptor control flags */
typedef enum {
    ADS_SD_CONTROL_SE_OWNER_DEFAULTED       = 0x00000001,
    ADS_SD_CONTROL_SE_GROUP_DEFAULTED       = 0x00000002,
    ADS_SD_CONTROL_SE_DACL_PRESENT          = 0x00000004,
    ADS_SD_CONTROL_SE_DACL_DEFAULTED        = 0x00000008,
    ADS_SD_CONTROL_SE_SACL_PRESENT          = 0x00000010,
    ADS_SD_CONTROL_SE_SACL_DEFAULTED        = 0x00000020,
    ADS_SD_CONTROL_SE_DACL_AUTO_INHERIT_REQ = 0x00000100,
    ADS_SD_CONTROL_SE_SACL_AUTO_INHERIT_REQ = 0x00000200,
    ADS_SD_CONTROL_SE_DACL_AUTO_INHERITED   = 0x00000400,
    ADS_SD_CONTROL_SE_SACL_AUTO_INHERITED   = 0x00000800,
    ADS_SD_CONTROL_SE_DACL_PROTECTED        = 0x00001000,
    ADS_SD_CONTROL_SE_SACL_PROTECTED        = 0x00002000,
    ADS_SD_CONTROL_SE_SELF_RELATIVE         = 0x00008000
} ADS_SD_CONTROL_ENUM;

/* ADS security descriptor revision number */
typedef enum {
    ADS_SD_REVISION_DS  = 4
} ADS_SD_REVISION_ENUM;

/* ADS name types */
typedef enum {
    ADS_NAME_TYPE_1779                      = 1,
    ADS_NAME_TYPE_CANONICAL                 = 2,
    ADS_NAME_TYPE_NT4                       = 3,
    ADS_NAME_TYPE_DISPLAY                   = 4,
    ADS_NAME_TYPE_DOMAIN_SIMPLE             = 5,
    ADS_NAME_TYPE_ENTERPRISE_SIMPLE         = 6,
    ADS_NAME_TYPE_GUID                      = 7,
    ADS_NAME_TYPE_UNKNOWN                   = 8,
    ADS_NAME_TYPE_USER_PRINCIPAL_NAME       = 9,
    ADS_NAME_TYPE_CANONICAL_EX              = 10,
    ADS_NAME_TYPE_SERVICE_PRINCIPAL_NAME    = 11,
    ADS_NAME_TYPE_SID_OR_SID_HISTORY_NAME   = 12
} ADS_NAME_TYPE_ENUM;

/* ADS name initialization types */
typedef enum {
    ADS_NAME_INITTYPE_DOMAIN    = 1,
    ADS_NAME_INITTYPE_SERVER    = 2,
    ADS_NAME_INITTYPE_GC        = 3
} ADS_NAME_INITTYPE_ENUM;

/* ADS options */
typedef enum {
    ADS_OPTION_SERVERNAME                   = 0,
    ADS_OPTION_REFERRALS                    = 1,
    ADS_OPTION_PAGE_SIZE                    = 2,
    ADS_OPTION_SECURITY_MASK                = 3,
    ADS_OPTION_MUTUAL_AUTH_STATUS           = 4,
    ADS_OPTION_QUOTA                        = 5,
    ADS_OPTION_PASSWORD_PORTNUMBER          = 6,
    ADS_OPTION_PASSWORD_METHOD              = 7,
    ADS_OPTION_ACCUMULATIVE_MODIFICATION    = 8,
    ADS_OPTION_SKIP_SID_LOOKUP              = 9
} ADS_OPTION_ENUM;

/* ADS security information types */
typedef enum {
    ADS_SECURITY_INFO_OWNER = 0x00000001,
    ADS_SECURITY_INFO_GROUP = 0x00000002,
    ADS_SECURITY_INFO_DACL  = 0x00000004,
    ADS_SECURITY_INFO_SACL  = 0x00000008
} ADS_SECURITY_INFO_ENUM;

/* ADS set types */
typedef enum {
    ADS_SETTYPE_FULL        = 1,
    ADS_SETTYPE_PROVIDER    = 2,
    ADS_SETTYPE_SERVER      = 3,
    ADS_SETTYPE_DN          = 4
} ADS_SETTYPE_ENUM;

/* ADS formats */
typedef enum {
    ADS_FORMAT_WINDOWS              = 1,
    ADS_FORMAT_WINDOWS_NO_SERVER    = 2,
    ADS_FORMAT_WINDOWS_DN           = 3,
    ADS_FORMAT_WINDOWS_PARENT       = 4,
    ADS_FORMAT_X500                 = 5,
    ADS_FORMAT_X500_NO_SERVER       = 6,
    ADS_FORMAT_X500_DN              = 7,
    ADS_FORMAT_X500_PARENT          = 8,
    ADS_FORMAT_SERVER               = 9,
    ADS_FORMAT_PROVIDER             = 10,
    ADS_FORMAT_LEAF                 = 11
} ADS_FORMAT_ENUM;

/* ADS display types */
typedef enum {
    ADS_DISPLAY_FULL        = 1,
    ADS_DISPLAY_VALUE_ONLY  = 2
} ADS_DISPLAY_ENUM;

/* ADS escape modes */
typedef enum {
    ADS_ESCAPEDMODE_DEFAULT = 1,
    ADS_ESCAPEDMODE_ON      = 2,
    ADS_ESCAPEDMODE_OFF     = 3,
    ADS_ESCAPEDMODE_OFF_EX  = 4
} ADS_ESCAPE_MODE_ENUM;

/* ADS path types */
typedef enum {
    ADS_PATH_FILE       = 1,
    ADS_PATH_FILESHARE  = 2,
    ADS_PATH_REGISTRY   = 3
} ADS_PATHTYPE_ENUM;

/* ADS security descriptor formats */
typedef enum {
    ADS_SD_FORMAT_IID       = 1,
    ADS_SD_FORMAT_RAW       = 2,
    ADS_SD_FORMAT_HEXSTRING = 3
} ADS_SD_FORMAT_ENUM;

/* GUIDs */
EXTERN_C const IID      IID_IADs;
EXTERN_C const IID      IID_IADsContainer;
EXTERN_C const IID      IID_IADsCollection;
EXTERN_C const IID      IID_IADsMembers;
EXTERN_C const IID      IID_IADsPropertyList;
EXTERN_C const IID      IID_IADsPropertyEntry;
EXTERN_C const CLSID    CLSID_PropertyEntry;
EXTERN_C const IID      IID_IADsPropertyValue;
EXTERN_C const IID      IID_IADsPropertyValue2;
EXTERN_C const CLSID    CLSID_PropertyValue;
EXTERN_C const IID      IID_IPrivateDispatch;
EXTERN_C const IID      IID_IPrivateUnknown;
EXTERN_C const IID      IID_IADsExtension;
EXTERN_C const IID      IID_IADsDeleteOps;
EXTERN_C const IID      IID_IADsNamespaces;
EXTERN_C const IID      IID_IADsClass;
EXTERN_C const IID      IID_IADsProperty;
EXTERN_C const IID      IID_IADsSyntax;
EXTERN_C const IID      IID_IADsLocality;
EXTERN_C const IID      IID_IADsO;
EXTERN_C const IID      IID_IADsOU;
EXTERN_C const IID      IID_IADsDomain;
EXTERN_C const IID      IID_IADsComputer;
EXTERN_C const IID      IID_IADsComputerOperations;
EXTERN_C const IID      IID_IADsGroup;
EXTERN_C const IID      IID_IADsUser;
EXTERN_C const IID      IID_IADsPrintQueue;
EXTERN_C const IID      IID_IADsPrintQueueOperations;
EXTERN_C const IID      IID_IADsPrintJob;
EXTERN_C const IID      IID_IADsPrintJobOperations;
EXTERN_C const IID      IID_IADsService;
EXTERN_C const IID      IID_IADsServiceOperations;
EXTERN_C const IID      IID_IADsFileService;
EXTERN_C const IID      IID_IADsFileServiceOperations;
EXTERN_C const IID      IID_IADsFileShare;
EXTERN_C const IID      IID_IADsSession;
EXTERN_C const IID      IID_IADsResource;
EXTERN_C const IID      IID_IADsOpenDSObject;
EXTERN_C const IID      IID_IDirectoryObject;
EXTERN_C const IID      IID_IDirectorySearch;
EXTERN_C const IID      IID_IDirectorySchemaMgmt;
EXTERN_C const IID      IID_IADsAggregatee;
EXTERN_C const IID      IID_IADsAggregator;
EXTERN_C const IID      IID_IADsAccessControlEntry;
EXTERN_C const CLSID    CLSID_AccessControlEntry;
EXTERN_C const IID      IID_IADsAccessControlList;
EXTERN_C const CLSID    CLSID_AccessControlList;
EXTERN_C const IID      IID_IADsSecurityDescriptor;
EXTERN_C const CLSID    CLSID_SecurityDescriptor;
EXTERN_C const IID      IID_IADsLargeInteger;
EXTERN_C const CLSID    CLSID_LargeInteger;
EXTERN_C const IID      IID_IADsNameTranslate;
EXTERN_C const CLSID    CLSID_NameTranslate;
EXTERN_C const IID      IID_IADsCaseIgnoreList;
EXTERN_C const CLSID    CLSID_CaseIgnoreList;
EXTERN_C const IID      IID_IADsNetAddress;
EXTERN_C const CLSID    CLSID_NetAddress;
EXTERN_C const IID      IID_IADsOctetList;
EXTERN_C const CLSID    CLSID_OctetList;
EXTERN_C const IID      IID_IADsEmail;
EXTERN_C const CLSID    CLSID_Email;
EXTERN_C const IID      IID_IADsPath;
EXTERN_C const CLSID    CLSID_Path;
EXTERN_C const IID      IID_IADsReplicaPointer;
EXTERN_C const CLSID    CLSID_ReplicaPointer;
EXTERN_C const IID      IID_IADsAcl;
EXTERN_C const IID      IID_IADsTimestamp;
EXTERN_C const CLSID    CLSID_Timestamp;
EXTERN_C const IID      IID_IADsPostalAddress;
EXTERN_C const CLSID    CLSID_PostalAddress;
EXTERN_C const IID      IID_IADsBackLink;
EXTERN_C const CLSID    CLSID_BackLink;
EXTERN_C const IID      IID_IADsTypedName;
EXTERN_C const CLSID    CLSID_TypedName;
EXTERN_C const IID      IID_IADsHold;
EXTERN_C const CLSID    CLSID_Hold;
EXTERN_C const IID      IID_IADsObjectOptions;
EXTERN_C const IID      IID_IADsPathname;
EXTERN_C const CLSID    CLSID_Pathname;
EXTERN_C const IID      IID_IADsADSystemInfo;
EXTERN_C const CLSID    CLSID_ADSystemInfo;
EXTERN_C const IID      IID_IADsWinNTSystemInfo;
EXTERN_C const CLSID    CLSID_WinNTSystemInfo;
EXTERN_C const IID      IID_IADsDNWithBinary;
EXTERN_C const CLSID    CLSID_DNWithBinary;
EXTERN_C const IID      IID_IADsDNWithString;
EXTERN_C const CLSID    CLSID_DNWithString;
EXTERN_C const IID      IID_IADsSecurityUtility;
EXTERN_C const CLSID    CLSID_ADsSecurityUtility;

/* IADs interface */
#undef INTERFACE
#define INTERFACE   IADs
DECLARE_INTERFACE_( IADs, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;
};

/* IADsContainer interface */
#undef INTERFACE
#define INTERFACE   IADsContainer
DECLARE_INTERFACE_( IADsContainer, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsContainer methods */
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( get__NewEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( get_Filter )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Filter )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_Hints )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Hints )( THIS_ VARIANT ) PURE;
    STDMETHOD( GetObject )( THIS_ BSTR, BSTR, IDispatch ** ) PURE;
    STDMETHOD( Create )( THIS_ BSTR, BSTR, IDispatch ** ) PURE;
    STDMETHOD( Delete )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( CopyHere )( THIS_ BSTR, BSTR, IDispatch ** ) PURE;
    STDMETHOD( MoveHere )( THIS_ BSTR, BSTR, IDispatch ** ) PURE;
};

/* IADsCollection interface */
#undef INTERFACE
#define INTERFACE   IADsCollection
DECLARE_INTERFACE_( IADsCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsCollection methods */
    STDMETHOD( get__NewEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( Add )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( Remove )( THIS_ BSTR ) PURE;
    STDMETHOD( GetObject )( THIS_ BSTR, VARIANT * ) PURE;
};

/* IADsMembers interface */
#undef INTERFACE
#define INTERFACE   IADsMembers
DECLARE_INTERFACE_( IADsMembers, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsMembers methods */
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( get__NewEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( get_Filter )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Filter )( THIS_ VARIANT ) PURE;
};

/* IADsPropertyList interface */
#undef INTERFACE
#define INTERFACE   IADsPropertyList
DECLARE_INTERFACE_( IADsPropertyList, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPropertyList methods */
    STDMETHOD( get_PropertyCount )( THIS_ long * ) PURE;
    STDMETHOD( Next )( THIS_ VARIANT * ) PURE;
    STDMETHOD( Skip )( THIS_ long ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT, VARIANT * ) PURE;
    STDMETHOD( GetPropertyItem )( THIS_ BSTR, LONG, VARIANT * ) PURE;
    STDMETHOD( PutPropertyItem )( THIS_ VARIANT ) PURE;
    STDMETHOD( ResetPropertyItem )( THIS_ VARIANT ) PURE;
    STDMETHOD( PurgePropertyList )( THIS ) PURE;
};

/* IADsPropertyEntry interface */
#undef INTERFACE
#define INTERFACE   IADsPropertyEntry
DECLARE_INTERFACE_( IADsPropertyEntry, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPropertyEntry methods */
    STDMETHOD( Clear )( THIS ) PURE;
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ADsType )( THIS_ long * ) PURE;
    STDMETHOD( put_ADsType )( THIS_ long ) PURE;
    STDMETHOD( get_ControlCode )( THIS_ long * ) PURE;
    STDMETHOD( put_ControlCode )( THIS_ long ) PURE;
    STDMETHOD( get_Values )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Values )( THIS_ VARIANT ) PURE;
};

/* IADsPropertyValue interface */
#undef INTERFACE
#define INTERFACE   IADsPropertyValue
DECLARE_INTERFACE_( IADsPropertyValue, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPropertyValue methods */
    STDMETHOD( Clear )( THIS ) PURE;
    STDMETHOD( get_ADsType )( THIS_ long * ) PURE;
    STDMETHOD( put_ADsType )( THIS_ long ) PURE;
    STDMETHOD( get_DNString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_DNString )( THIS_ BSTR ) PURE;
    STDMETHOD( get_CaseExactString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_CaseExactString )( THIS_ BSTR ) PURE;
    STDMETHOD( get_CaseIgnoreString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_CaseIgnoreString )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PrintableString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PrintableString )( THIS_ BSTR ) PURE;
    STDMETHOD( get_NumericString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_NumericString )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Boolean )( THIS_ long * ) PURE;
    STDMETHOD( put_Boolean )( THIS_ long ) PURE;
    STDMETHOD( get_Integer )( THIS_ long * ) PURE;
    STDMETHOD( put_Integer )( THIS_ long ) PURE;
    STDMETHOD( get_OctetString )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_OctetString )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_SecurityDescriptor )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_SecurityDescriptor )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_LargeInteger )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_LargeInteger )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_UTCTime )( THIS_ DATE * ) PURE;
    STDMETHOD( put_UTCTime )( THIS_ DATE ) PURE;
};

/* IADsPropertyValue2 interface */
#undef INTERFACE
#define INTERFACE   IADsPropertyValue2
DECLARE_INTERFACE_( IADsPropertyValue2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPropertyValue2 methods */
    STDMETHOD( GetObjectProperty )( THIS_ long *, VARIANT * ) PURE;
    STDMETHOD( PutObjectProperty )( THIS_ long, VARIANT ) PURE;
};

/* IPrivateDispatch interface */
#undef INTERFACE
#define INTERFACE   IPrivateDispatch
DECLARE_INTERFACE_( IPrivateDispatch, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPrivateDispatch methods */
    STDMETHOD( ADSIInitializeDispatchManager )( THIS_ long ) PURE;
    STDMETHOD( ADSIGetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( ADSIGetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( ADSIGetIDsOfNames )( THIS_ REFIID, OLECHAR **, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( ADSIInvoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IPrivateUnknown interface */
#undef INTERFACE
#define INTERFACE   IPrivateUnknown
DECLARE_INTERFACE_( IPrivateUnknown, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPrivateUnknown methods */
    STDMETHOD( ADSIInitializeObject )( THIS_ BSTR, BSTR, long ) PURE;
    STDMETHOD( ADSIReleaseObject )( THIS ) PURE;
};

/* IADsExtension interface */
#undef INTERFACE
#define INTERFACE   IADsExtension
DECLARE_INTERFACE_( IADsExtension, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IADsExtension methods */
    STDMETHOD( Operate )( THIS_ DWORD, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( PrivateGetIDsOfNames )( THIS_ REFIID, OLECHAR **, unsigned int, LCID, DISPID * ) PURE;
    STDMETHOD( PrivateInvoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, unsigned int * ) PURE;
};

/* IADsDeleteOps interface */
#undef INTERFACE
#define INTERFACE   IADsDeleteOps
DECLARE_INTERFACE_( IADsDeleteOps, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsDeleteOps methods */
    STDMETHOD( DeleteObject )( THIS_ long ) PURE;
};

/* IADsNamespaces interface */
#undef INTERFACE
#define INTERFACE   IADsNamespaces
DECLARE_INTERFACE_( IADsNamespaces, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsNamespaces methods */
    STDMETHOD( get_DefaultContainer )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_DefaultContainer )( THIS_ BSTR ) PURE;
};

/* IADsClass interface */
#undef INTERFACE
#define INTERFACE   IADsClass
DECLARE_INTERFACE_( IADsClass, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsClass methods */
    STDMETHOD( get_PrimaryInterface )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_CLSID )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_CLSID )( THIS_ BSTR ) PURE;
    STDMETHOD( get_OID )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_OID )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Abstract )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_Abstract )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_Auxiliary )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_Auxiliary )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_MandatoryProperties )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_MandatoryProperties )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_OptionalProperties )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_OptionalProperties )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_NamingProperties )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_NamingProperties )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_DerivedFrom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_DerivedFrom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_AuxDerivedFrom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_AuxDerivedFrom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_PossibleSuperiors )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_PossibleSuperiors )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_Containment )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Containment )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_Container )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_Container )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_HelpFileName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_HelpFileName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_HelpFileContext )( THIS_ long * ) PURE;
    STDMETHOD( put_HelpFileContext )( THIS_ long ) PURE;
    STDMETHOD( Qualifiers )( THIS_ IADsCollection ** ) PURE;
};

/* IADsProperty interface */
#undef INTERFACE
#define INTERFACE   IADsProperty
DECLARE_INTERFACE_( IADsProperty, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsProperty methods */
    STDMETHOD( get_OID )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_OID )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Syntax )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Syntax )( THIS_ BSTR ) PURE;
    STDMETHOD( get_MaxRange )( THIS_ long * ) PURE;
    STDMETHOD( put_MaxRange )( THIS_ long ) PURE;
    STDMETHOD( get_MinRange )( THIS_ long * ) PURE;
    STDMETHOD( put_MinRange )( THIS_ long ) PURE;
    STDMETHOD( get_MultiValued )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_MultiValued )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( Qualifiers )( THIS_ IADsCollection ** ) PURE;
};

/* IADsSyntax interface */
#undef INTERFACE
#define INTERFACE   IADsSyntax
DECLARE_INTERFACE_( IADsSyntax, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsSyntax methods */
    STDMETHOD( get_OleAutoDataType )( THIS_ long * ) PURE;
    STDMETHOD( put_OleAutoDataType )( THIS_ long ) PURE;
};

/* IADsLocality interface */
#undef INTERFACE
#define INTERFACE   IADsLocality
DECLARE_INTERFACE_( IADsLocality, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsLocality methods */
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_LocalityName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LocalityName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PostalAddress )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PostalAddress )( THIS_ BSTR ) PURE;
    STDMETHOD( get_SeeAlso )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_SeeAlso )( THIS_ VARIANT ) PURE;
};

/* IADsO interface */
#undef INTERFACE
#define INTERFACE   IADsO
DECLARE_INTERFACE_( IADsO, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsO methods */
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_LocalityName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LocalityName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PostalAddress )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PostalAddress )( THIS_ BSTR ) PURE;
    STDMETHOD( get_TelephoneNumber )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_TelephoneNumber )( THIS_ BSTR ) PURE;
    STDMETHOD( get_FaxNumber )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_FaxNumber )( THIS_ BSTR ) PURE;
    STDMETHOD( get_SeeAlso )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_SeeAlso )( THIS_ BSTR ) PURE;
};

/* IADsOU interface */
#undef INTERFACE
#define INTERFACE   IADsOU
DECLARE_INTERFACE_( IADsOU, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsOU methods */
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_LocalityName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LocalityName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PostalAddress )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PostalAddress )( THIS_ BSTR ) PURE;
    STDMETHOD( get_TelephoneNumber )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_TelephoneNumber )( THIS_ BSTR ) PURE;
    STDMETHOD( get_FaxNumber )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_FaxNumber )( THIS_ BSTR ) PURE;
    STDMETHOD( get_SeeAlso )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_SeeAlso )( THIS_ BSTR ) PURE;
    STDMETHOD( get_BusinessCategory )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_BusinessCategory )( THIS_ BSTR ) PURE;
};

/* IADsDomain interface */
#undef INTERFACE
#define INTERFACE   IADsDomain
DECLARE_INTERFACE_( IADsDomain, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsDomain methods */
    STDMETHOD( get_IsWorkgroup )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_MinPasswordLength )( THIS_ long * ) PURE;
    STDMETHOD( put_MinPasswordLength )( THIS_ long ) PURE;
    STDMETHOD( get_MinPasswordAge )( THIS_ long * ) PURE;
    STDMETHOD( put_MinPasswordAge )( THIS_ long ) PURE;
    STDMETHOD( get_MaxPasswordAge )( THIS_ long * ) PURE;
    STDMETHOD( put_MaxPasswordAge )( THIS_ long ) PURE;
    STDMETHOD( get_MaxBadPasswordsAllowed )( THIS_ long * ) PURE;
    STDMETHOD( put_MaxBadPasswordsAllowed )( THIS_ long ) PURE;
    STDMETHOD( get_PasswordHistoryLength )( THIS_ long * ) PURE;
    STDMETHOD( put_PasswordHistoryLength )( THIS_ long ) PURE;
    STDMETHOD( get_PasswordAttributes )( THIS_ long * ) PURE;
    STDMETHOD( put_PasswordAttributes )( THIS_ long ) PURE;
    STDMETHOD( get_AutoUnlockInterval )( THIS_ long * ) PURE;
    STDMETHOD( put_AutoUnlockInterval )( THIS_ long ) PURE;
    STDMETHOD( get_LockoutObservationInterval )( THIS_ long * ) PURE;
    STDMETHOD( put_LockoutObservationInterval )( THIS_ long ) PURE;
};

/* IADsComputer interface */
#undef INTERFACE
#define INTERFACE   IADsComputer
DECLARE_INTERFACE_( IADsComputer, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsComputer methods */
    STDMETHOD( get_ComputerID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Site )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Location )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Location )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PrimaryUser )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PrimaryUser )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Owner )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Owner )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Division )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Division )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Department )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Department )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Role )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Role )( THIS_ BSTR ) PURE;
    STDMETHOD( get_OperatingSystem )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_OperatingSystem )( THIS_ BSTR ) PURE;
    STDMETHOD( get_OperatingSystemVersion )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_OperatingSystemVersion )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Model )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Model )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Processor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Processor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ProcessorCount )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ProcessorCount )( THIS_ BSTR ) PURE;
    STDMETHOD( get_MemorySize )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_MemorySize )( THIS_ BSTR ) PURE;
    STDMETHOD( get_StorageCapacity )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_StorageCapacity )( THIS_ BSTR ) PURE;
    STDMETHOD( get_NetAddresses )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_NetAddresses )( THIS_ VARIANT ) PURE;
};

/* IADsComputerOperations interface */
#undef INTERFACE
#define INTERFACE   IADsComputerOperations
DECLARE_INTERFACE_( IADsComputerOperations, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsComputerOperations methods */
    STDMETHOD( Status )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Shutdown )( THIS_ VARIANT_BOOL ) PURE;
};

/* IADsGroup interface */
#undef INTERFACE
#define INTERFACE   IADsGroup
DECLARE_INTERFACE_( IADsGroup, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsGroup methods */
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( Members )( THIS_ IADsMembers ** ) PURE;
    STDMETHOD( IsMember )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( Add )( THIS_ BSTR ) PURE;
    STDMETHOD( Remove )( THIS_ BSTR ) PURE;
};

/* IADsUser interface */
#undef INTERFACE
#define INTERFACE   IADsUser
DECLARE_INTERFACE_( IADsUser, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsUser methods */
    STDMETHOD( get_BadLoginAddress )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_BadLoginCount )( THIS_ long * ) PURE;
    STDMETHOD( get_LastLogin )( THIS_ DATE * ) PURE;
    STDMETHOD( get_LastLogoff )( THIS_ DATE * ) PURE;
    STDMETHOD( get_LastFailedLogin )( THIS_ DATE * ) PURE;
    STDMETHOD( get_PasswordLastChanged )( THIS_ DATE * ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Division )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Division )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Department )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Department )( THIS_ BSTR ) PURE;
    STDMETHOD( get_EmployeeID )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_EmployeeID )( THIS_ BSTR ) PURE;
    STDMETHOD( get_FullName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_FullName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_FirstName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_FirstName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_LastName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LastName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_OtherName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_OtherName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_NamePrefix )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_NamePrefix )( THIS_ BSTR ) PURE;
    STDMETHOD( get_NameSuffix )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_NameSuffix )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Title )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Title )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Manager )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Manager )( THIS_ BSTR ) PURE;
    STDMETHOD( get_TelephoneHome )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_TelephoneHome )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_TelephoneMobile )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_TelephoneMobile )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_TelephoneNumber )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_TelephoneNumber )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_TelephonePager )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_TelephonePager )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_FaxNumber )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_FaxNumber )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_OfficeLocations )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_OfficeLocations )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_PostalAddresses )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_PostalAddresses )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_PostalCodes )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_PostalCodes )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_SeeAlso )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_SeeAlso )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_AccountDisabled )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_AccountDisabled )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_AccountExpirationDate )( THIS_ DATE * ) PURE;
    STDMETHOD( put_AccountExpirationDate )( THIS_ DATE ) PURE;
    STDMETHOD( get_GraceLoginsAllowed )( THIS_ long * ) PURE;
    STDMETHOD( put_GraceLoginsAllowed )( THIS_ long ) PURE;
    STDMETHOD( get_GraceLoginsRemaining )( THIS_ long * ) PURE;
    STDMETHOD( put_GraceLoginsRemaining )( THIS_ long ) PURE;
    STDMETHOD( get_IsAccountLocked )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_IsAccountLocked )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_LoginHours )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_LoginHours )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_LoginWorkstations )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_LoginWorkstations )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_MaxLogins )( THIS_ long * ) PURE;
    STDMETHOD( put_MaxLogins )( THIS_ long ) PURE;
    STDMETHOD( get_MaxStorage )( THIS_ long * ) PURE;
    STDMETHOD( put_MaxStorage )( THIS_ long ) PURE;
    STDMETHOD( get_PasswordExpirationDate )( THIS_ DATE * ) PURE;
    STDMETHOD( put_PasswordExpirationDate )( THIS_ DATE ) PURE;
    STDMETHOD( get_PasswordMinimumLength )( THIS_ long * ) PURE;
    STDMETHOD( put_PasswordMinimumLength )( THIS_ long ) PURE;
    STDMETHOD( get_PasswordRequired )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_PasswordRequired )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_RequireUniquePassword )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_RequireUniquePassword )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_EmailAddress )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_EmailAddress )( THIS_ BSTR ) PURE;
    STDMETHOD( get_HomeDirectory )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_HomeDirectory )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Languages )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Languages )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_Profile )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Profile )( THIS_ BSTR ) PURE;
    STDMETHOD( get_LoginScript )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LoginScript )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Picture )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Picture )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_HomePage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_HomePage )( THIS_ BSTR ) PURE;
    STDMETHOD( Groups )( THIS_ IADsMembers ** ) PURE;
    STDMETHOD( SetPassword )( THIS_ BSTR ) PURE;
    STDMETHOD( ChangePassword )( THIS_ BSTR, BSTR ) PURE;
};

/* IADsPrintQueue interface */
#undef INTERFACE
#define INTERFACE   IADsPrintQueue
DECLARE_INTERFACE_( IADsPrintQueue, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsPrintQueue methods */
    STDMETHOD( get_PrinterPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PrinterPath )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Model )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Model )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Datatype )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Datatype )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PrintProcessor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_PrintProcessor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Location )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Location )( THIS_ BSTR ) PURE;
    STDMETHOD( get_StartTime )( THIS_ DATE * ) PURE;
    STDMETHOD( put_StartTime )( THIS_ DATE ) PURE;
    STDMETHOD( get_UntilTime )( THIS_ DATE * ) PURE;
    STDMETHOD( put_UntilTime )( THIS_ DATE ) PURE;
    STDMETHOD( get_DefaultJobPriority )( THIS_ long * ) PURE;
    STDMETHOD( put_DefaultJobPriority )( THIS_ long ) PURE;
    STDMETHOD( get_Priority )( THIS_ long * ) PURE;
    STDMETHOD( put_Priority )( THIS_ long ) PURE;
    STDMETHOD( get_BannerPage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_BannerPage )( THIS_ BSTR ) PURE;
    STDMETHOD( get_PrintDevices )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_PrintDevices )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_NetAddresses )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_NetAddresses )( THIS_ VARIANT ) PURE;
};

/* IADsPrintQueueOperations interface */
#undef INTERFACE
#define INTERFACE   IADsPrintQueueOperations
DECLARE_INTERFACE_( IADsPrintQueueOperations, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsPrintQueueOperations methods */
    STDMETHOD( get_Status )( THIS_ long * ) PURE;
    STDMETHOD( PrintJobs )( THIS_ IADsCollection ** ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;
    STDMETHOD( Purge )( THIS ) PURE;
};

/* IADsPrintJob interface */
#undef INTERFACE
#define INTERFACE   IADsPrintJob
DECLARE_INTERFACE_( IADsPrintJob, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsPrintJob methods */
    STDMETHOD( get_HostPrintQueue )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_User )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_UserPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_TimeSubmitted )( THIS_ DATE * ) PURE;
    STDMETHOD( get_TotalPages )( THIS_ long * ) PURE;
    STDMETHOD( get_Size )( THIS_ long * ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Priority )( THIS_ long * ) PURE;
    STDMETHOD( put_Priority )( THIS_ long ) PURE;
    STDMETHOD( get_StartTime )( THIS_ DATE * ) PURE;
    STDMETHOD( put_StartTime )( THIS_ DATE ) PURE;
    STDMETHOD( get_UntilTime )( THIS_ DATE * ) PURE;
    STDMETHOD( put_UntilTime )( THIS_ DATE ) PURE;
    STDMETHOD( get_Notify )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Notify )( THIS_ BSTR ) PURE;
    STDMETHOD( get_NotifyPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_NotifyPath )( THIS_ BSTR ) PURE;
};

/* IADsPrintJobOperations interface */
#undef INTERFACE
#define INTERFACE   IADsPrintJobOperations
DECLARE_INTERFACE_( IADsPrintJobOperations, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsPrintJobOperations methods */
    STDMETHOD( get_Status )( THIS_ long * ) PURE;
    STDMETHOD( get_TimeElapsed )( THIS_ long * ) PURE;
    STDMETHOD( get_PagesPrinted )( THIS_ long * ) PURE;
    STDMETHOD( get_Position )( THIS_ long * ) PURE;
    STDMETHOD( put_Position )( THIS_ long ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;
};

/* IADsService interface */
#undef INTERFACE
#define INTERFACE   IADsService
DECLARE_INTERFACE_( IADsService, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsService methods */
    STDMETHOD( get_HostComputer )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_HostComputer )( THIS_ BSTR ) PURE;
    STDMETHOD( get_DisplayName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_DisplayName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Version )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Version )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ServiceType )( THIS_ long * ) PURE;
    STDMETHOD( put_ServiceType )( THIS_ long ) PURE;
    STDMETHOD( get_StartType )( THIS_ long * ) PURE;
    STDMETHOD( put_StartType )( THIS_ long ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Path )( THIS_ BSTR ) PURE;
    STDMETHOD( get_StartupParameters )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_StartupParameters )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ErrorControl )( THIS_ long * ) PURE;
    STDMETHOD( put_ErrorControl )( THIS_ long ) PURE;
    STDMETHOD( get_LoadOrderGroup )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LoadOrderGroup )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ServiceAccountName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ServiceAccountName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ServiceAccountPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ServiceAccountPath )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Dependencies )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Dependencies )( THIS_ VARIANT ) PURE;
};

/* IADsServiceOperations interface */
#undef INTERFACE
#define INTERFACE   IADsServiceOperations
DECLARE_INTERFACE_( IADsServiceOperations, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsServiceOperations methods */
    STDMETHOD( get_Status )( THIS_ long * ) PURE;
    STDMETHOD( Start )( THIS ) PURE;
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Continue )( THIS ) PURE;
    STDMETHOD( SetPassword )( THIS_ BSTR ) PURE;
};

/* IADsFileService interface */
#undef INTERFACE
#define INTERFACE   IADsFileService
DECLARE_INTERFACE_( IADsFileService, IADsService ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsService methods */
    STDMETHOD( get_HostComputer )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_HostComputer )( THIS_ BSTR ) PURE;
    STDMETHOD( get_DisplayName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_DisplayName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Version )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Version )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ServiceType )( THIS_ long * ) PURE;
    STDMETHOD( put_ServiceType )( THIS_ long ) PURE;
    STDMETHOD( get_StartType )( THIS_ long * ) PURE;
    STDMETHOD( put_StartType )( THIS_ long ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Path )( THIS_ BSTR ) PURE;
    STDMETHOD( get_StartupParameters )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_StartupParameters )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ErrorControl )( THIS_ long * ) PURE;
    STDMETHOD( put_ErrorControl )( THIS_ long ) PURE;
    STDMETHOD( get_LoadOrderGroup )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_LoadOrderGroup )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ServiceAccountName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ServiceAccountName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ServiceAccountPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ServiceAccountPath )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Dependencies )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Dependencies )( THIS_ VARIANT ) PURE;

    /* IADsFileService methods */
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_MaxUserCount )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_MaxUserCount )( THIS_ BSTR ) PURE;
};

/* IADsFileServiceOperations interface */
#undef INTERFACE
#define INTERFACE   IADsFileServiceOperations
DECLARE_INTERFACE_( IADsFileServiceOperations, IADsServiceOperations ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsServiceOperations methods */
    STDMETHOD( get_Status )( THIS_ long * ) PURE;
    STDMETHOD( Start )( THIS ) PURE;
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Continue )( THIS ) PURE;
    STDMETHOD( SetPassword )( THIS_ BSTR ) PURE;

    /* IADsFileServiceOperations methods */
    STDMETHOD( Sessions )( THIS_ IADsCollection ** ) PURE;
    STDMETHOD( Resources )( THIS_ IADsCollection ** ) PURE;
};

/* IADsFileShare interface */
#undef INTERFACE
#define INTERFACE   IADsFileShare
DECLARE_INTERFACE_( IADsFileShare, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsFileShare methods */
    STDMETHOD( get_CurrentUserCount )( THIS_ long * ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_HostComputer )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_HostComputer )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Path )( THIS_ BSTR ) PURE;
    STDMETHOD( get_MaxUserCount )( THIS_ long * ) PURE;
    STDMETHOD( put_MaxUserCount )( THIS_ long ) PURE;
};

/* IADsSession interface */
#undef INTERFACE
#define INTERFACE   IADsSession
DECLARE_INTERFACE_( IADsSession, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsSession methods */
    STDMETHOD( get_User )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_UserPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Computer )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ComputerPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ConnectTime )( THIS_ long * ) PURE;
    STDMETHOD( get_IdleTime )( THIS_ long * ) PURE;
};

/* IADsResource interface */
#undef INTERFACE
#define INTERFACE   IADsResource
DECLARE_INTERFACE_( IADsResource, IADs ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADs methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Class )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GUID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ADsPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Parent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Schema )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetInfo )( THIS ) PURE;
    STDMETHOD( SetInfo )( THIS ) PURE;
    STDMETHOD( Get )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( Put )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( PutEx )( THIS_ long, BSTR, VARIANT ) PURE;
    STDMETHOD( GetInfoEx )( THIS_ VARIANT, long ) PURE;

    /* IADsResource methods */
    STDMETHOD( get_User )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_UserPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_LockCount )( THIS_ long * ) PURE;
};

/* IADsOpenDSObject interface */
#undef INTERFACE
#define INTERFACE   IADsOpenDSObject
DECLARE_INTERFACE_( IADsOpenDSObject, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsOpenDSObject methods */
    STDMETHOD( OpenDSObject )( THIS_ BSTR, BSTR, BSTR, long, IDispatch ** ) PURE;
};

/* IDirectoryObject interface */
#undef INTERFACE
#define INTERFACE   IDirectoryObject
DECLARE_INTERFACE_( IDirectoryObject, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectoryObject methods */
    STDMETHOD( GetObjectInformation )( THIS_ PADS_OBJECT_INFO * ) PURE;
    STDMETHOD( GetObjectAttributes )( THIS_ LPWSTR *, DWORD, PADS_ATTR_INFO *, DWORD * ) PURE;
    STDMETHOD( SetObjectAttributes )( THIS_ PADS_ATTR_INFO, DWORD, DWORD * ) PURE;
    STDMETHOD( CreateDSObject )( THIS_ LPWSTR, PADS_ATTR_INFO, DWORD, IDispatch ** ) PURE;
    STDMETHOD( DeleteDSObject )( THIS_ LPWSTR ) PURE;
};

/* IDirectorySearch interface */
#undef INTERFACE
#define INTERFACE   IDirectorySearch
DECLARE_INTERFACE_( IDirectorySearch, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectorySearch methods */
    STDMETHOD( SetSearchPreference )( THIS_ PADS_SEARCHPREF_INFO, DWORD ) PURE;
    STDMETHOD( ExecuteSearch )( THIS_ LPWSTR, LPWSTR *, DWORD, PADS_SEARCH_HANDLE ) PURE;
    STDMETHOD( AbandonSearch )( THIS_ ADS_SEARCH_HANDLE ) PURE;
    STDMETHOD( GetFirstRow )( THIS_ ADS_SEARCH_HANDLE ) PURE;
    STDMETHOD( GetNextRow )( THIS_ ADS_SEARCH_HANDLE ) PURE;
    STDMETHOD( GetPreviousRow )( THIS_ ADS_SEARCH_HANDLE ) PURE;
    STDMETHOD( GetNextColumnName )( THIS_ ADS_SEARCH_HANDLE, LPWSTR * ) PURE;
    STDMETHOD( GetColumn )( THIS_ ADS_SEARCH_HANDLE, LPWSTR, PADS_SEARCH_COLUMN ) PURE;
    STDMETHOD( FreeColumn )( THIS_ PADS_SEARCH_COLUMN ) PURE;
    STDMETHOD( CloseSearchHandle )( THIS_ ADS_SEARCH_HANDLE ) PURE;
};

/* IDirectorySchemaMgmt interface */
#undef INTERFACE
#define INTERFACE   IDirectorySchemaMgmt
DECLARE_INTERFACE_( IDirectorySchemaMgmt, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectorySchemaMgmt methods */
    STDMETHOD( EnumAttributes )( THIS_ LPWSTR *, DWORD, PADS_ATTR_DEF *, DWORD * ) PURE;
    STDMETHOD( CreateAttributeDefinition )( THIS_ LPWSTR, PADS_ATTR_DEF ) PURE;
    STDMETHOD( WriteAttributeDefinition )( THIS_ LPWSTR, PADS_ATTR_DEF ) PURE;
    STDMETHOD( DeleteAttributeDefinition )( THIS_ LPWSTR ) PURE;
    STDMETHOD( EnumClasses )( THIS_ LPWSTR *, DWORD, PADS_CLASS_DEF *, DWORD * ) PURE;
    STDMETHOD( WriteClassDefinition )( THIS_ LPWSTR, PADS_CLASS_DEF ) PURE;
    STDMETHOD( CreateClassDefinition )( THIS_ LPWSTR, PADS_CLASS_DEF ) PURE;
    STDMETHOD( DeleteClassDefinition )( THIS_ LPWSTR ) PURE;
};

/* IADsAggregatee interface */
#undef INTERFACE
#define INTERFACE   IADsAggregatee
DECLARE_INTERFACE_( IADsAggregatee, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IADsAggregatee methods */
    STDMETHOD( ConnectAsAggregatee )( THIS_ IUnknown * ) PURE;
    STDMETHOD( DisconnectAsAggregatee )( THIS ) PURE;
    STDMETHOD( RelinquishInterface )( THIS_ REFIID ) PURE;
    STDMETHOD( RestoreInterface )( THIS_ REFIID ) PURE;
};

/* IADsAggregator interface */
#undef INTERFACE
#define INTERFACE   IADsAggregator
DECLARE_INTERFACE_( IADsAggregator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IADsAggregator methods */
    STDMETHOD( ConnectAsAggregator )( THIS_ IUnknown * ) PURE;
    STDMETHOD( DisconnectAsAggregator )( THIS ) PURE;
};

/* IADsAccessControlEntry interface */
#undef INTERFACE
#define INTERFACE   IADsAccessControlEntry
DECLARE_INTERFACE_( IADsAccessControlEntry, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsAccessControlEntry methods */
    STDMETHOD( get_AccessMask )( THIS_ long * ) PURE;
    STDMETHOD( put_AccessMask )( THIS_ long ) PURE;
    STDMETHOD( get_AceType )( THIS_ long * ) PURE;
    STDMETHOD( put_AceType )( THIS_ long ) PURE;
    STDMETHOD( get_AceFlags )( THIS_ long * ) PURE;
    STDMETHOD( put_AceFlags )( THIS_ long ) PURE;
    STDMETHOD( get_Flags )( THIS_ long * ) PURE;
    STDMETHOD( put_Flags )( THIS_ long ) PURE;
    STDMETHOD( get_ObjectType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ObjectType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_InheritedObjectType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_InheritedObjectType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Trustee )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Trustee )( THIS_ BSTR ) PURE;
};

/* IADsAccessControlList interface */
#undef INTERFACE
#define INTERFACE   IADsAccessControlList
DECLARE_INTERFACE_( IADsAccessControlList, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsAccessControlList methods */
    STDMETHOD( get_AclRevision )( THIS_ long * ) PURE;
    STDMETHOD( put_AclRevision )( THIS_ long ) PURE;
    STDMETHOD( get_AceCount )( THIS_ long * ) PURE;
    STDMETHOD( put_AceCount )( THIS_ long ) PURE;
    STDMETHOD( AddAce )( THIS_ IDispatch * ) PURE;
    STDMETHOD( RemoveAce )( THIS_ IDispatch * ) PURE;
    STDMETHOD( CopyAccessList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get__NewEnum )( THIS_ IUnknown ** ) PURE;
};

/* IADsSecurityDescriptor interface */
#undef INTERFACE
#define INTERFACE   IADsSecurityDescriptor
DECLARE_INTERFACE_( IADsSecurityDescriptor, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsSecurityDescriptor methods */
    STDMETHOD( get_Revision )( THIS_ long * ) PURE;
    STDMETHOD( put_Revision )( THIS_ long ) PURE;
    STDMETHOD( get_Control )( THIS_ long * ) PURE;
    STDMETHOD( put_Control )( THIS_ long ) PURE;
    STDMETHOD( get_Owner )( THIS_ long * ) PURE;
    STDMETHOD( put_Owner )( THIS_ long ) PURE;
    STDMETHOD( get_OwnerDefaulted )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_OwnerDefaulted )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_Group )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Group )( THIS_ BSTR ) PURE;
    STDMETHOD( get_GroupDefaulted )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_GroupDefaulted )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_DiscretionaryAcl )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_DiscretionaryAcl )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_DaclDefaulted )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_DaclDefaulted )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_SystemAcl )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_SystemAcl )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_SaclDefaulted )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_SaclDefaulted )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( CopySecurityDescriptor )( THIS_ IDispatch ** ) PURE;
};

/* IADsLargeInteger interface */
#undef INTERFACE
#define INTERFACE   IADsLargeInteger
DECLARE_INTERFACE_( IADsLargeInteger, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsLargeInteger methods */
    STDMETHOD( get_HighPart )( THIS_ long * ) PURE;
    STDMETHOD( put_HighPart )( THIS_ long ) PURE;
    STDMETHOD( get_LowPart )( THIS_ long * ) PURE;
    STDMETHOD( put_LowPart )( THIS_ long ) PURE;
};

/* IADsNameTranslate interface */
#undef INTERFACE
#define INTERFACE   IADsNameTranslate
DECLARE_INTERFACE_( IADsNameTranslate, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsNameTranslate methods */
    STDMETHOD( put_ChaseReferral )( THIS_ long ) PURE;
    STDMETHOD( Init )( THIS_ long, BSTR ) PURE;
    STDMETHOD( InitEx )( THIS_ long, BSTR, BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( Set )( THIS_ long, BSTR ) PURE;
    STDMETHOD( Get )( THIS_ long, BSTR * ) PURE;
    STDMETHOD( SetEx )( THIS_ long, VARIANT ) PURE;
    STDMETHOD( GetEx )( THIS_ long, VARIANT * ) PURE;
};

/* IADsCaseIgnoreList interface */
#undef INTERFACE
#define INTERFACE   IADsCaseIgnoreList
DECLARE_INTERFACE_( IADsCaseIgnoreList, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsCaseIgnoreList methods */
    STDMETHOD( get_CaseIgnoreList )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_CaseIgnoreList )( THIS_ VARIANT ) PURE;
};

/* IADsFaxNumber interface */
#undef INTERFACE
#define INTERFACE   IADsFaxNumber
DECLARE_INTERFACE_( IADsFaxNumber, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsFaxNumber methods */
    STDMETHOD( get_TelephoneNumber )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_TelephoneNumber )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Parameters )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Parameters )( THIS_ VARIANT ) PURE;
};

/* IADsNetAddress interface */
#undef INTERFACE
#define INTERFACE   IADsNetAddress
DECLARE_INTERFACE_( IADsNetAddress, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsNetAddress methods */
    STDMETHOD( get_AddressType )( THIS_ long * ) PURE;
    STDMETHOD( put_AddressType )( THIS_ long ) PURE;
    STDMETHOD( get_Address )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_Address )( THIS_ VARIANT ) PURE;
};

/* IADsOctetList interface */
#undef INTERFACE
#define INTERFACE   IADsOctetList
DECLARE_INTERFACE_( IADsOctetList, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsOctetList methods */
    STDMETHOD( get_OctetList )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_OctetList )( THIS_ VARIANT ) PURE;
};

/* IADsEmail interface */
#undef INTERFACE
#define INTERFACE   IADsEmail
DECLARE_INTERFACE_( IADsEmail, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsEmail methods */
    STDMETHOD( get_Type )( THIS_ long * ) PURE;
    STDMETHOD( put_Type )( THIS_ long ) PURE;
    STDMETHOD( get_Address )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Address )( THIS_ BSTR ) PURE;
};

/* IADsPath interface */
#undef INTERFACE
#define INTERFACE   IADsPath
DECLARE_INTERFACE_( IADsPath, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPath methods */
    STDMETHOD( get_Type )( THIS_ long * ) PURE;
    STDMETHOD( put_Type )( THIS_ long ) PURE;
    STDMETHOD( get_VolumeName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_VolumeName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Path )( THIS_ BSTR ) PURE;
};

/* IADsReplicaPointer interface */
#undef INTERFACE
#define INTERFACE   IADsReplicaPointer
DECLARE_INTERFACE_( IADsReplicaPointer, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsReplicaPointer methods */
    STDMETHOD( get_ServerName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ServerName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ReplicaType )( THIS_ long * ) PURE;
    STDMETHOD( put_ReplicaType )( THIS_ long ) PURE;
    STDMETHOD( get_ReplicaNumber )( THIS_ long * ) PURE;
    STDMETHOD( put_ReplicaNumber )( THIS_ long ) PURE;
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( put_Count )( THIS_ long ) PURE;
    STDMETHOD( get_ReplicaAddressHints )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ReplicaAddressHints )( THIS_ VARIANT ) PURE;
};

/* IADsAcl interface */
#undef INTERFACE
#define INTERFACE   IADsAcl
DECLARE_INTERFACE_( IADsAcl, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsAcl methods */
    STDMETHOD( get_ProtectedAttrName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ProtectedAttrName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_SubjectName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_SubjectName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Privileges )( THIS_ long * ) PURE;
    STDMETHOD( put_Privileges )( THIS_ long ) PURE;
    STDMETHOD( CopyAcl )( THIS_ IDispatch ** ) PURE;
};

/* IADsTimestamp interface */
#undef INTERFACE
#define INTERFACE   IADsTimestamp
DECLARE_INTERFACE_( IADsTimestamp, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsTimestamp methods */
    STDMETHOD( get_WholeSeconds )( THIS_ long * ) PURE;
    STDMETHOD( put_WholeSeconds )( THIS_ long ) PURE;
    STDMETHOD( get_EventID )( THIS_ long * ) PURE;
    STDMETHOD( put_EventID )( THIS_ long ) PURE;
};

/* IADsPostalAddress interface */
#undef INTERFACE
#define INTERFACE   IADsPostalAddress
DECLARE_INTERFACE_( IADsPostalAddress, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPostalAddress methods */
    STDMETHOD( get_PostalAddress )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_PostalAddress )( THIS_ VARIANT ) PURE;
};

/* IADsBackLink interface */
#undef INTERFACE
#define INTERFACE   IADsBackLink
DECLARE_INTERFACE_( IADsBackLink, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsBackLink methods */
    STDMETHOD( get_RemoteID )( THIS_ long * ) PURE;
    STDMETHOD( put_RemoteID )( THIS_ long ) PURE;
    STDMETHOD( get_ObjectName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ObjectName )( THIS_ BSTR ) PURE;
};

/* IADsTypedName interface */
#undef INTERFACE
#define INTERFACE   IADsTypedName
DECLARE_INTERFACE_( IADsTypedName, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsTypedName methods */
    STDMETHOD( get_ObjectName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ObjectName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Level )( THIS_ long * ) PURE;
    STDMETHOD( put_Level )( THIS_ long ) PURE;
    STDMETHOD( get_Interval )( THIS_ long * ) PURE;
    STDMETHOD( put_Interval )( THIS_ long ) PURE;
};

/* IADsHold interface */
#undef INTERFACE
#define INTERFACE   IADsHold
DECLARE_INTERFACE_( IADsHold, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsHold methods */
    STDMETHOD( get_ObjectName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ObjectName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Amount )( THIS_ long * ) PURE;
    STDMETHOD( put_Amount )( THIS_ long ) PURE;
};

/* IADsObjectOptions interface */
#undef INTERFACE
#define INTERFACE   IADsObjectOptions
DECLARE_INTERFACE_( IADsObjectOptions, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsObjectOptions methods */
    STDMETHOD( GetOption )( THIS_ long, VARIANT * ) PURE;
    STDMETHOD( SetOption )( THIS_ long, VARIANT ) PURE;
};

/* IADsPathname interface */
#undef INTERFACE
#define INTERFACE   IADsPathname
DECLARE_INTERFACE_( IADsPathname, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsPathname methods */
    STDMETHOD( Set )( THIS_ BSTR, long ) PURE;
    STDMETHOD( SetDisplayType )( THIS_ long ) PURE;
    STDMETHOD( Retrieve )( THIS_ long, BSTR * ) PURE;
    STDMETHOD( GetNumElements )( THIS_ long * ) PURE;
    STDMETHOD( GetElement )( THIS_ long, BSTR * ) PURE;
    STDMETHOD( AddLeafElement )( THIS_ BSTR ) PURE;
    STDMETHOD( RemoveLeafElement )( THIS ) PURE;
    STDMETHOD( CopyPath )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( GetEscapedElement )( THIS_ long, BSTR, BSTR * ) PURE;
    STDMETHOD( get_EscapedMode )( THIS_ long * ) PURE;
    STDMETHOD( put_EscapedMode )( THIS_ long ) PURE;
};

/* IADsADSystemInfo interface */
#undef INTERFACE
#define INTERFACE   IADsADSystemInfo
DECLARE_INTERFACE_( IADsADSystemInfo, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsADSystemInfo methods */
    STDMETHOD( get_UserName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ComputerName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_SiteName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_DomainShortName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_DomainDNSName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ForestDNSName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_PDCRoleOwner )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_SchemaRoleOwner )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_IsNativeMode )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( GetAnyDCName )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetDCSiteName )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( RefreshSchemaCache )( THIS ) PURE;
    STDMETHOD( GetTrees )( THIS_ VARIANT * ) PURE;
};

/* IADsWinNTSystemInfo interface */
#undef INTERFACE
#define INTERFACE   IADsWinNTSystemInfo
DECLARE_INTERFACE_( IADsWinNTSystemInfo, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsWinNTSystemInfo methods */
    STDMETHOD( get_UserName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_ComputerName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_DomainName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_PDC )( THIS_ BSTR * ) PURE;
};

/* IADsDNWithBinary interface */
#undef INTERFACE
#define INTERFACE   IADsDNWithBinary
DECLARE_INTERFACE_( IADsDNWithBinary, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsDNWithBinary methods */
    STDMETHOD( get_BinaryValue )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_BinaryValue )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_DNString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_DNString )( THIS_ BSTR ) PURE;
};

/* IADsDNWithString interface */
#undef INTERFACE
#define INTERFACE   IADsDNWithString
DECLARE_INTERFACE_( IADsDNWithString, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsDNWithString methods */
    STDMETHOD( get_StringValue )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_StringValue )( THIS_ BSTR ) PURE;
    STDMETHOD( get_DNString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_DNString )( THIS_ BSTR ) PURE;
};

/* IADsSecurityUtility interface */
#undef INTERFACE
#define INTERFACE   IADsSecurityUtility
DECLARE_INTERFACE_( IADsSecurityUtility, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IADsSecurityUtility methods */
    STDMETHOD( GetSecurityDescriptor )( THIS_ VARIANT, long, long, VARIANT * ) PURE;
    STDMETHOD( SetSecurityDescriptor )( THIS_ VARIANT, long, VARIANT, long ) PURE;
    STDMETHOD( ConvertSecurityDescriptor )( THIS_ VARIANT, long, long, VARIANT * ) PURE;
    STDMETHOD( get_SecurityMask )( THIS_ long * ) PURE;
    STDMETHOD( put_SecurityMask )( THIS_ long ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IADs_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADs_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADs_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADs_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADs_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADs_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADs_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADs_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADs_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADs_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADs_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADs_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADs_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADs_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADs_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADs_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADs_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADs_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADs_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADs_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsContainer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsContainer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsContainer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsContainer_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsContainer_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsContainer_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsContainer_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsContainer_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define IADsContainer_get__NewEnum( x, p ) \
        (x)->lpVtbl->get__NewEnum( x, p )
    #define IADsContainer_get_Filter( x, p ) \
        (x)->lpVtbl->get_Filter( x, p )
    #define IADsContainer_put_Filter( x, p ) \
        (x)->lpVtbl->put_Filter( x, p )
    #define IADsContainer_get_Hints( x, p ) \
        (x)->lpVtbl->get_Hints( x, p )
    #define IADsContainer_put_Hints( x, p ) \
        (x)->lpVtbl->put_Hints( x, p )
    #define IADsContainer_GetObject( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetObject( x, p1, p2, p3 )
    #define IADsContainer_Create( x, p1, p2, p3 ) \
        (x)->lpVtbl->Create( x, p1, p2, p3 )
    #define IADsContainer_Delete( x, p1, p2 ) \
        (x)->lpVtbl->Delete( x, p1, p2 )
    #define IADsContainer_CopyHere( x, p1, p2, p3 ) \
        (x)->lpVtbl->CopyHere( x, p1, p2, p3 )
    #define IADsContainer_MoveHere( x, p1, p2, p3 ) \
        (x)->lpVtbl->MoveHere( x, p1, p2, p3 )
    #define IADsCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsCollection_get__NewEnum( x, p ) \
        (x)->lpVtbl->get__NewEnum( x, p )
    #define IADsCollection_Add( x, p1, p2 ) \
        (x)->lpVtbl->Add( x, p1, p2 )
    #define IADsCollection_Remove( x, p ) \
        (x)->lpVtbl->Remove( x, p )
    #define IADsCollection_GetObject( x, p1, p2 ) \
        (x)->lpVtbl->GetObject( x, p1, p2 )
    #define IADsMembers_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsMembers_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsMembers_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsMembers_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsMembers_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsMembers_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsMembers_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsMembers_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define IADsMembers_get__NewEnum( x, p ) \
        (x)->lpVtbl->get__NewEnum( x, p )
    #define IADsMembers_get_Filter( x, p ) \
        (x)->lpVtbl->get_Filter( x, p )
    #define IADsMembers_put_Filter( x, p ) \
        (x)->lpVtbl->put_Filter( x, p )
    #define IADsPropertyList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPropertyList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPropertyList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPropertyList_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPropertyList_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPropertyList_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPropertyList_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPropertyList_get_PropertyCount( x, p ) \
        (x)->lpVtbl->get_PropertyCount( x, p )
    #define IADsPropertyList_Next( x, p ) \
        (x)->lpVtbl->Next( x, p )
    #define IADsPropertyList_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IADsPropertyList_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IADsPropertyList_Item( x, p1, p2 ) \
        (x)->lpVtbl->Item( x, p1, p2 )
    #define IADsPropertyList_GetPropertyItem( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPropertyItem( x, p1, p2, p3 )
    #define IADsPropertyList_PutPropertyItem( x, p ) \
        (x)->lpVtbl->PutPropertyItem( x, p )
    #define IADsPropertyList_ResetPropertyItem( x, p ) \
        (x)->lpVtbl->ResetPropertyItem( x, p )
    #define IADsPropertyList_PurgePropertyList( x ) \
        (x)->lpVtbl->PurgePropertyList( x )
    #define IADsPropetryEntry_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPropertyEntry_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPropertyEntry_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPropertyEntry_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPropertyEntry_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPropertyEntry_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPropertyEntry_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPropertyEntry_Clear( x ) \
        (x)->lpVtbl->Clear( x )
    #define IADsPropertyEntry_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsPropertyEntry_put_Name( x, p ) \
        (x)->lpVtbl->put_Name( x, p )
    #define IADsPropertyEntry_get_ADsType( x, p ) \
        (x)->lpVtbl->get_ADsType( x, p )
    #define IADsPropertyEntry_put_ADsType( x, p ) \
        (x)->lpVtbl->put_ADsType( x, p )
    #define IADsPropertyEntry_get_ControlCode( x, p ) \
        (x)->lpVtbl->get_ControlCode( x, p )
    #define IADsPropertyEntry_put_ControlCode( x, p ) \
        (x)->lpVtbl->put_ControlCode( x, p )
    #define IADsPropertyEntry_get_Values( x, p ) \
        (x)->lpVtbl->get_Values( x, p )
    #define IADsPropertyEntry_put_Values( x, p ) \
        (x)->lpVtbl->put_Values( x, p )
    #define IADsPropertyValue_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPropertyValue_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPropertyValue_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPropertyValue_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPropertyValue_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPropertyValue_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPropertyValue_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPropertyValue_Clear( x ) \
        (x)->lpVtbl->Clear( x )
    #define IADsPropertyValue_get_ADsType( x, p ) \
        (x)->lpVtbl->get_ADsType( x, p )
    #define IADsPropertyValue_put_ADsType( x, p ) \
        (x)->lpVtbl->put_ADsType( x, p )
    #define IADsPropertyValue_get_DNString( x, p ) \
        (x)->lpVtbl->get_DNString( x, p )
    #define IADsPropertyValue_put_DNString( x, p ) \
        (x)->lpVtbl->put_DNString( x, p )
    #define IADsPropertyValue_get_CaseExactString( x, p ) \
        (x)->lpVtbl->get_CaseExactString( x, p )
    #define IADsPropertyValue_put_CaseExactString( x, p ) \
        (x)->lpVtbl->put_CaseExactString( x, p )
    #define IADsPropertyValue_get_PrintableString( x, p ) \
        (x)->lpVtbl->get_PrintableString( x, p )
    #define IADsPropertyValue_put_PrintableString( x, p ) \
        (x)->lpVtbl->put_PrintableString( x, p )
    #define IADsPropertyValue_get_NumericString( x, p ) \
        (x)->lpVtbl->get_NumericString( x, p )
    #define IADsPropertyValue_put_NumericString( x, p ) \
        (x)->lpVtbl->put_NumericString( x, p )
    #define IADsPropertyValue_get_Boolean( x, p ) \
        (x)->lpVtbl->get_Boolean( x, p )
    #define IADsPropertyValue_put_Boolean( x, p ) \
        (x)->lpVtbl->put_Boolean( x, p )
    #define IADsPropertyValue_get_Integer( x, p ) \
        (x)->lpVtbl->get_Integer( x, p )
    #define IADsPropertyValue_put_Integer( x, p ) \
        (x)->lpVtbl->put_Integer( x, p )
    #define IADsPropertyValue_get_OctetString( x, p ) \
        (x)->lpVtbl->get_OctetString( x, p )
    #define IADsPropertyValue_put_OctetString( x, p ) \
        (x)->lpVtbl->put_OctetString( x, p )
    #define IADsPropertyValue_get_SecurityDescriptor( x, p ) \
        (x)->lpVtbl->get_SecurityDescriptor( x, p )
    #define IADsPropertyValue_put_SecurityDescriptor( x, p ) \
        (x)->lpVtbl->put_SecurityDescriptor( x, p )
    #define IADsPropertyValue_get_LargeInteger( x, p ) \
        (x)->lpVtbl->get_LargeInteger( x, p )
    #define IADsPropertyValue_put_LargeInteger( x, p ) \
        (x)->lpVtbl->put_LargeInteger( x, p )
    #define IADsPropertyValue_get_UTCTime( x, p ) \
        (x)->lpVtbl->get_UTCTime( x, p )
    #define IADsPropertyValue_put_UTCTime( x, p ) \
        (x)->lpVtbl->put_UTCTime( x, p )
    #define IADsPropertyValue2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPropertyValue2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPropertyValue2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPropertyValue2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPropertyValue2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPropertyValue2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPropertyValue2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPropertyValue2_GetObjectProperty( x, p1, p2 ) \
        (x)->lpVtbl->GetObjectProperty( x, p1, p2 )
    #define IADsPropertyValue2_PutObjectProperty( x, p1, p2 ) \
        (x)->lpVtbl->PutObjectProperty( x, p1, p2 )
    #define IPrivateDispatch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPrivateDispatch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPrivateDispatch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPrivateDispatch_ADSIInitializeDispatchManager( x, p ) \
        (x)->lpVtbl->ADSIInitializeDispatchManager( x, p )
    #define IPrivateDispatch_ADSIGetTypeInfoCount( x, p ) \
        (x)->lpVtbl->ADSIGetTypeInfoCount( x, p )
    #define IPrivateDispatch_ADSIGetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->ADSIGetTypeInfo( x, p1, p2, p3 )
    #define IPrivateDispatch_ADSIGetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ADSIGetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IPrivateDispatch_ADSIInvoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->ADSIInvoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IPrivateUnknown_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPrivateUnknown_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPrivateUnknown_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPrivateUnknown_ADSIInitializeObject( x, p1, p2, p3 ) \
        (x)->lpVtbl->ADSIInitializeObject( x, p1, p2, p3 )
    #define IPrivateUnknown_ADSIReleaseObject( x ) \
        (x)->lpVtbl->ADSIReleaseObject( x )
    #define IADsExtension_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsExtension_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsExtension_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsExtension_Operate( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Operate( x, p1, p2, p3, p4 )
    #define IADsExtension_PrivateGetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->PrivateGetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsExtension_PrivateInvoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->PrivateInvoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsDeleteOps_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsDeleteOps_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsDeleteOps_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsDeleteOps_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsDeleteOps_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsDeleteOps_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsDeleteOps_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsDeleteOps_DeleteObject( x, p ) \
        (x)->lpVtbl->DeleteObject( x, p )
    #define IADsNamespaces_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsNamespaces_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsNamespaces_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsNamespaces_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsNamespaces_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsNamespaces_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsNamespaces_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsNamespaces_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsNamespaces_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsNamespaces_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsNamespaces_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsNamespaces_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsNamespaces_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsNamespaces_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsNamespaces_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsNamespaces_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsNamespaces_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsNamespaces_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsNamespaces_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsNamespaces_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsNamespaces_get_DefaultContainer( x, p ) \
        (x)->lpVtbl->get_DefaultContainer( x, p )
    #define IADsNamespaces_put_DefaultContainer( x, p ) \
        (x)->lpVtbl->put_DefaultContainer( x, p )
    #define IADsClass_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsClass_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsClass_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsClass_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsClass_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsClass_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsClass_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsClass_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsClass_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsClass_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsClass_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsClass_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsClass_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsClass_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsClass_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsClass_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsClass_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsClass_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsClass_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsClass_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsClass_get_PrimaryInterface( x, p ) \
        (x)->lpVtbl->get_PrimaryInterface( x, p )
    #define IADsClass_get_CLSID( x, p ) \
        (x)->lpVtbl->get_CLSID( x, p )
    #define IADsClass_put_CLSID( x, p ) \
        (x)->lpVtbl->put_CLSID( x, p )
    #define IADsClass_get_OID( x, p ) \
        (x)->lpVtbl->get_OID( x, p )
    #define IADsClass_put_OID( x, p ) \
        (x)->lpVtbl->put_OID( x, p )
    #define IADsClass_get_Abstract( x, p ) \
        (x)->lpVtbl->get_Abstract( x, p )
    #define IADsClass_put_Abstract( x, p ) \
        (x)->lpVtbl->put_Abstract( x, p )
    #define IADsClass_get_Auxiliary( x, p ) \
        (x)->lpVtbl->get_Auxiliary( x, p )
    #define IADsClass_put_Auxiliary( x, p ) \
        (x)->lpVtbl->put_Auxiliary( x, p )
    #define IADsClass_get_MandatoryProperties( x, p ) \
        (x)->lpVtbl->get_MandatoryProperties( x, p )
    #define IADsClass_put_MandatoryProperties( x, p ) \
        (x)->lpVtbl->put_MandatoryProperties( x, p )
    #define IADsClass_get_OptionalProperties( x, p ) \
        (x)->lpVtbl->get_OptionalProperties( x, p )
    #define IADsClass_put_OptionalProperties( x, p ) \
        (x)->lpVtbl->put_OptionalProperties( x, p )
    #define IADsClass_get_NamingProperties( x, p ) \
        (x)->lpVtbl->get_NamingProperties( x, p )
    #define IADsClass_put_NamingProperties( x, p ) \
        (x)->lpVtbl->put_NamingProperties( x, p )
    #define IADsClass_get_DerivedFrom( x, p ) \
        (x)->lpVtbl->get_DerivedFrom( x, p )
    #define IADsClass_put_DerivedFrom( x, p ) \
        (x)->lpVtbl->put_DerivedFrom( x, p )
    #define IADsClass_get_AuxDerivedFrom( x, p ) \
        (x)->lpVtbl->get_AuxDerivedFrom( x, p )
    #define IADsClass_put_AuxDerivedFrom( x, p ) \
        (x)->lpVtbl->put_AuxDerivedFrom( x, p )
    #define IADsClass_get_PossibleSuperiors( x, p ) \
        (x)->lpVtbl->get_PossibleSuperiors( x, p )
    #define IADsClass_put_PossibleSuperiors( x, p ) \
        (x)->lpVtbl->put_PossibleSuperiors( x, p )
    #define IADsClass_get_Containment( x, p ) \
        (x)->lpVtbl->get_Containment( x, p )
    #define IADsClass_put_Containment( x, p ) \
        (x)->lpVtbl->put_Containment( x, p )
    #define IADsClass_get_Container( x, p ) \
        (x)->lpVtbl->get_Container( x, p )
    #define IADsClass_put_Container( x, p ) \
        (x)->lpVtbl->put_Container( x, p )
    #define IADsClass_get_HelpFileName( x, p ) \
        (x)->lpVtbl->get_HelpFileName( x, p )
    #define IADsClass_put_HelpFileName( x, p ) \
        (x)->lpVtbl->put_HelpFileName( x, p )
    #define IADsClass_get_HelpFileContext( x, p ) \
        (x)->lpVtbl->get_HelpFileContext( x, p )
    #define IADsClass_put_HelpFileContext( x, p ) \
        (x)->lpVtbl->put_HelpFileContext( x, p )
    #define IADsClass_Qualifiers( x, p ) \
        (x)->lpVtbl->Qualifiers( x, p )
    #define IADsProperty_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsProperty_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsProperty_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsProperty_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsProperty_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsProperty_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsProperty_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsProperty_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsProperty_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsProperty_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsProperty_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsProperty_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsProperty_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsProperty_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsProperty_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsProperty_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsProperty_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsProperty_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsProperty_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsProperty_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsProperty_get_OID( x, p ) \
        (x)->lpVtbl->get_OID( x, p )
    #define IADsProperty_put_OID( x, p ) \
        (x)->lpVtbl->put_OID( x, p )
    #define IADsProperty_get_Syntax( x, p ) \
        (x)->lpVtbl->get_Syntax( x, p )
    #define IADsProperty_put_Syntax( x, p ) \
        (x)->lpVtbl->put_Syntax( x, p )
    #define IADsProperty_get_MaxRange( x, p ) \
        (x)->lpVtbl->get_MaxRange( x, p )
    #define IADsProperty_put_MaxRange( x, p ) \
        (x)->lpVtbl->put_MaxRange( x, p )
    #define IADsProperty_get_MinRange( x, p ) \
        (x)->lpVtbl->get_MinRange( x, p )
    #define IADsProperty_put_MinRange( x, p ) \
        (x)->lpVtbl->put_MinRange( x, p )
    #define IADsProperty_get_MultiValued( x, p ) \
        (x)->lpVtbl->get_MultiValued( x, p )
    #define IADsProperty_put_MultiValued( x, p ) \
        (x)->lpVtbl->put_MultiValued( x, p )
    #define IADsProperty_Qualifiers( x, p ) \
        (x)->lpVtbl->Qualifiers( x, p )
    #define IADsSyntax_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsSyntax_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsSyntax_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsSyntax_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsSyntax_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsSyntax_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsSyntax_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsSyntax_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsSyntax_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsSyntax_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsSyntax_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsSyntax_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsSyntax_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsSyntax_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsSyntax_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsSyntax_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsSyntax_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsSyntax_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsSyntax_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsSyntax_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsSyntax_get_OleAutoDataType( x, p ) \
        (x)->lpVtbl->get_OleAutoDataType( x, p )
    #define IADsSyntax_put_OleAutoDataType( x, p ) \
        (x)->lpVtbl->put_OleAutoDataType( x, p )
    #define IADsLocality_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsLocality_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsLocality_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsLocality_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsLocality_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsLocality_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsLocality_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsLocality_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsLocality_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsLocality_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsLocality_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsLocality_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsLocality_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsLocality_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsLocality_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsLocality_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsLocality_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsLocality_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsLocality_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsLocality_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsLocality_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsLocality_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsLocality_get_LocalityName( x, p ) \
        (x)->lpVtbl->get_LocalityName( x, p )
    #define IADsLocality_put_LocalityName( x, p ) \
        (x)->lpVtbl->put_LocalityName( x, p )
    #define IADsLocality_get_PostalAddress( x, p ) \
        (x)->lpVtbl->get_PostalAddress( x, p )
    #define IADsLocality_put_PostalAddress( x, p ) \
        (x)->lpVtbl->put_PostalAddress( x, p )
    #define IADsLocality_get_SeeAlso( x, p ) \
        (x)->lpVtbl->get_SeeAlso( x, p )
    #define IADsLocality_put_SeeAlso( x, p ) \
        (x)->lpVtbl->put_SeeAlso( x, p )
    #define IADsO_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsO_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsO_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsO_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsO_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsO_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsO_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsO_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsO_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsO_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsO_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsO_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsO_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsO_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsO_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsO_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsO_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsO_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsO_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsO_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsO_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsO_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsO_get_LocalityName( x, p ) \
        (x)->lpVtbl->get_LocalityName( x, p )
    #define IADsO_put_LocalityName( x, p ) \
        (x)->lpVtbl->put_LocalityName( x, p )
    #define IADsO_get_PostalAddress( x, p ) \
        (x)->lpVtbl->get_PostalAddress( x, p )
    #define IADsO_put_PostalAddress( x, p ) \
        (x)->lpVtbl->put_PostalAddress( x, p )
    #define IADsO_get_TelephoneNumber( x, p ) \
        (x)->lpVtbl->get_TelephoneNumber( x, p )
    #define IADsO_put_TelephoneNumber( x, p ) \
        (x)->lpVtbl->put_TelephoneNumber( x, p )
    #define IADsO_get_FaxNumber( x, p ) \
        (x)->lpVtbl->get_FaxNumber( x, p )
    #define IADsO_put_FaxNumber( x, p ) \
        (x)->lpVtbl->put_FaxNumber( x, p )
    #define IADsO_get_SeeAlso( x, p ) \
        (x)->lpVtbl->get_SeeAlso( x, p )
    #define IADsO_put_SeeAlso( x, p ) \
        (x)->lpVtbl->put_SeeAlso( x, p )
    #define IADsOU_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsOU_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsOU_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsOU_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsOU_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsOU_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsOU_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsOU_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsOU_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsOU_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsOU_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsOU_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsOU_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsOU_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsOU_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsOU_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsOU_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsOU_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsOU_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsOU_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsOU_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsOU_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsOU_get_LocalityName( x, p ) \
        (x)->lpVtbl->get_LocalityName( x, p )
    #define IADsOU_put_LocalityName( x, p ) \
        (x)->lpVtbl->put_LocalityName( x, p )
    #define IADsOU_get_PostalAddress( x, p ) \
        (x)->lpVtbl->get_PostalAddress( x, p )
    #define IADsOU_put_PostalAddress( x, p ) \
        (x)->lpVtbl->put_PostalAddress( x, p )
    #define IADsOU_get_TelephoneNumber( x, p ) \
        (x)->lpVtbl->get_TelephoneNumber( x, p )
    #define IADsOU_put_TelephoneNumber( x, p ) \
        (x)->lpVtbl->put_TelephoneNumber( x, p )
    #define IADsOU_get_FaxNumber( x, p ) \
        (x)->lpVtbl->get_FaxNumber( x, p )
    #define IADsOU_put_FaxNumber( x, p ) \
        (x)->lpVtbl->put_FaxNumber( x, p )
    #define IADsOU_get_SeeAlso( x, p ) \
        (x)->lpVtbl->get_SeeAlso( x, p )
    #define IADsOU_put_SeeAlso( x, p ) \
        (x)->lpVtbl->put_SeeAlso( x, p )
    #define IADsOU_get_BusinessCategory( x, p ) \
        (x)->lpVtbl->get_BusinessCategory( x, p )
    #define IADsOU_put_BusinessCategory( x, p ) \
        (x)->lpVtbl->put_BusinessCategory( x, p )
    #define IADsDomain_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsDomain_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsDomain_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsDomain_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsDomain_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsDomain_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsDomain_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsDomain_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsDomain_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsDomain_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsDomain_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsDomain_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsDomain_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsDomain_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsDomain_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsDomain_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsDomain_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsDomain_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsDomain_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsDomain_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsDomain_get_IsWorkgroup( x, p ) \
        (x)->lpVtbl->get_IsWorkgroup( x, p )
    #define IADsDomain_get_MinPasswordLength( x, p ) \
        (x)->lpVtbl->get_MinPasswordLength( x, p )
    #define IADsDomain_put_MinPasswordLength( x, p ) \
        (x)->lpVtbl->put_MinPasswordLength( x, p )
    #define IADsDomain_get_MinPasswordAge( x, p ) \
        (x)->lpVtbl->get_MinPasswordAge( x, p )
    #define IADsDomain_put_MinPasswordAge( x, p ) \
        (x)->lpVtbl->put_MinPasswordAge( x, p )
    #define IADsDomain_get_MaxPasswordAge( x, p ) \
        (x)->lpVtbl->get_MaxPasswordAge( x, p )
    #define IADsDomain_put_MaxPasswordAge( x, p ) \
        (x)->lpVtbl->put_MaxPasswordAge( x, p )
    #define IADsDomain_get_MaxBadPasswordsAllowed( x, p ) \
        (x)->lpVtbl->get_MaxBadPasswordsAllowed( x, p )
    #define IADsDomain_put_MaxBadPasswordsAllowed( x, p ) \
        (x)->lpVtbl->put_MaxBadPasswordsAllowed( x, p )
    #define IADsDomain_get_PasswordHistoryLength( x, p ) \
        (x)->lpVtbl->get_PasswordHistoryLength( x, p )
    #define IADsDomain_put_PasswordHistoryLength( x, p ) \
        (x)->lpVtbl->put_PasswordHistoryLength( x, p )
    #define IADsDomain_get_PasswordAttributes( x, p ) \
        (x)->lpVtbl->get_PasswordAttributes( x, p )
    #define IADsDomain_put_PasswordAttributes( x, p ) \
        (x)->lpVtbl->put_PasswordAttributes( x, p )
    #define IADsDomain_get_AutoUnlockInterval( x, p ) \
        (x)->lpVtbl->get_AutoUnlockInterval( x, p )
    #define IADsDomain_put_AutoUnlockInterval( x, p ) \
        (x)->lpVtbl->put_AutoUnlockInterval( x, p )
    #define IADsDomain_get_LockoutObservationInterval( x, p ) \
        (x)->lpVtbl->get_LockoutObservationInterval( x, p )
    #define IADsDomain_put_LockoutObservationInterval( x, p ) \
        (x)->lpVtbl->put_LockoutObservationInterval( x, p )
    #define IADsComputer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsComputer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsComputer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsComputer_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsComputer_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsComputer_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsComputer_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsComputer_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsComputer_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsComputer_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsComputer_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsComputer_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsComputer_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsComputer_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsComputer_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsComputer_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsComputer_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsComputer_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsComputer_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsComputer_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsComputer_get_ComputerID( x, p ) \
        (x)->lpVtbl->get_ComputerID( x, p )
    #define IADsComputer_get_Site( x, p ) \
        (x)->lpVtbl->get_Site( x, p )
    #define IADsComputer_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsComputer_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsComputer_get_Location( x, p ) \
        (x)->lpVtbl->get_Location( x, p )
    #define IADsComputer_put_Location( x, p ) \
        (x)->lpVtbl->put_Location( x, p )
    #define IADsComputer_get_PrimaryUser( x, p ) \
        (x)->lpVtbl->get_PrimaryUser( x, p )
    #define IADsComputer_put_PrimaryUser( x, p ) \
        (x)->lpVtbl->put_PrimaryUser( x, p )
    #define IADsComputer_get_Owner( x, p ) \
        (x)->lpVtbl->get_Owner( x, p )
    #define IADsComputer_put_Owner( x, p ) \
        (x)->lpVtbl->put_Owner( x, p )
    #define IADsComputer_get_Division( x, p ) \
        (x)->lpVtbl->get_Division( x, p )
    #define IADsComputer_put_Division( x, p ) \
        (x)->lpVtbl->put_Division( x, p )
    #define IADsComputer_get_Department( x, p ) \
        (x)->lpVtbl->get_Department( x, p )
    #define IADsComputer_put_Department( x, p ) \
        (x)->lpVtbl->put_Department( x, p )
    #define IADsComputer_get_Role( x, p ) \
        (x)->lpVtbl->get_Role( x, p )
    #define IADsComputer_put_Role( x, p ) \
        (x)->lpVtbl->put_Role( x, p )
    #define IADsComputer_get_OperatingSystem( x, p ) \
        (x)->lpVtbl->get_OperatingSystem( x, p )
    #define IADsComputer_put_OperatingSystem( x, p ) \
        (x)->lpVtbl->put_OperatingSystem( x, p )
    #define IADsComputer_get_OperatingSystemVersion( x, p ) \
        (x)->lpVtbl->get_OperatingSystemVersion( x, p )
    #define IADsComputer_put_OperatingSystemVersion( x, p ) \
        (x)->lpVtbl->put_OperatingSystemVersion( x, p )
    #define IADsComputer_get_Model( x, p ) \
        (x)->lpVtbl->get_Model( x, p )
    #define IADsComputer_put_Model( x, p ) \
        (x)->lpVtbl->put_Model( x, p )
    #define IADsComputer_get_Processor( x, p ) \
        (x)->lpVtbl->get_Processor( x, p )
    #define IADsComputer_put_Processor( x, p ) \
        (x)->lpVtbl->put_Processor( x, p )
    #define IADsComputer_get_ProcessorCount( x, p ) \
        (x)->lpVtbl->get_ProcessorCount( x, p )
    #define IADsComputer_put_ProcessorCount( x, p ) \
        (x)->lpVtbl->put_ProcessorCount( x, p )
    #define IADsComputer_get_MemorySize( x, p ) \
        (x)->lpVtbl->get_MemorySize( x, p )
    #define IADsComputer_put_MemorySize( x, p ) \
        (x)->lpVtbl->put_MemorySize( x, p )
    #define IADsComputer_get_StorageCapacity( x, p ) \
        (x)->lpVtbl->get_StorageCapacity( x, p )
    #define IADsComputer_put_StorageCapacity( x, p ) \
        (x)->lpVtbl->put_StorageCapacity( x, p )
    #define IADsComputer_get_NetAddresses( x, p ) \
        (x)->lpVtbl->get_NetAddresses( x, p )
    #define IADsComputer_put_NetAddresses( x, p ) \
        (x)->lpVtbl->put_NetAddresses( x, p )
    #define IADsComputerOperations_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsComputerOperations_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsComputerOperations_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsComputerOperations_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsComputerOperations_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsComputerOperations_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsComputerOperations_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsComputerOperations_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsComputerOperations_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsComputerOperations_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsComputerOperations_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsComputerOperations_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsComputerOperations_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsComputerOperations_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsComputerOperations_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsComputerOperations_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsComputerOperations_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsComputerOperations_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsComputerOperations_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsComputerOperations_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsComputerOperations_Status( x, p ) \
        (x)->lpVtbl->Status( x, p )
    #define IADsComputerOperations_Shutdown( x, p ) \
        (x)->lpVtbl->Shutdown( x, p )
    #define IADsGroup_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsGroup_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsGroup_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsGroup_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsGroup_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsGroup_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsGroup_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsGroup_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsGroup_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsGroup_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsGroup_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsGroup_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsGroup_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsGroup_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsGroup_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsGroup_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsGroup_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsGroup_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsGroup_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsGroup_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsGroup_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsGroup_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsGroup_Members( x, p ) \
        (x)->lpVtbl->Members( x, p )
    #define IADsGroup_IsMember( x, p1, p2 ) \
        (x)->lpVtbl->IsMember( x, p1, p2 )
    #define IADsGroup_Add( x, p ) \
        (x)->lpVtbl->Add( x, p )
    #define IADsGroup_Remove( x, p ) \
        (x)->lpVtbl->Remove( x, p )
    #define IADsUser_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsUser_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsUser_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsUser_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsUser_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsUser_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsUser_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsUser_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsUser_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsUser_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsUser_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsUser_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsUser_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsUser_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsUser_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsUser_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsUser_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsUser_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsUser_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsUser_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsUser_get_BadLoginAddress( x, p ) \
        (x)->lpVtbl->get_BadLoginAddress( x, p )
    #define IADsUser_get_BadLoginCount( x, p ) \
        (x)->lpVtbl->get_BadLoginCount( x, p )
    #define IADsUser_get_LastLogin( x, p ) \
        (x)->lpVtbl->get_LastLogin( x, p )
    #define IADsUser_get_LastLogoff( x, p ) \
        (x)->lpVtbl->get_LastLogoff( x, p )
    #define IADsUser_get_LastFailedLogin( x, p ) \
        (x)->lpVtbl->get_LastFailedLogin( x, p )
    #define IADsUser_get_PasswordLastChanged( x, p ) \
        (x)->lpVtbl->get_PasswordLastChanged( x, p )
    #define IADsUser_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsUser_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsUser_get_Division( x, p ) \
        (x)->lpVtbl->get_Division( x, p )
    #define IADsUser_put_Division( x, p ) \
        (x)->lpVtbl->put_Division( x, p )
    #define IADsUser_get_Department( x, p ) \
        (x)->lpVtbl->get_Department( x, p )
    #define IADsUser_put_Department( x, p ) \
        (x)->lpVtbl->put_Department( x, p )
    #define IADsUSer_get_EmployeeID( x, p ) \
        (x)->lpVtbl->get_EmployeeID( x, p )
    #define IADsUser_put_EmployeeID( x, p ) \
        (x)->lpVtbl->put_EmployeeID( x, p )
    #define IADsUser_get_FullName( x, p ) \
        (x)->lpVtbl->get_FullName( x, p )
    #define IADsUser_put_FullName( x, p ) \
        (x)->lpVtbl->put_FullName( x, p )
    #define IADsUser_get_FirstName( x, p ) \
        (x)->lpVtbl->get_FirstName( x, p )
    #define IADsUser_put_FirstName( x, p ) \
        (x)->lpVtbl->put_FirstName( x, p )
    #define IADsUser_get_LastName( x, p ) \
        (x)->lpVtbl->get_LastName( x, p )
    #define IADsUser_put_LastName( x, p ) \
        (x)->lpVtbl->put_LastName( x, p )
    #define IADsUser_get_OtherName( x, p ) \
        (x)->lpVtbl->get_OtherName( x, p )
    #define IADsUser_put_OtherName( x, p ) \
        (x)->lpVtbl->put_OtherName( x, p )
    #define IADsUser_get_NamePrefix( x, p ) \
        (x)->lpVtbl->get_NamePrefix( x, p )
    #define IADsUser_put_NamePrefix( x, p ) \
        (x)->lpVtbl->put_NamePrefix( x, p )
    #define IADsUser_get_NameSuffix( x, p ) \
        (x)->lpVtbl->get_NameSuffix( x, p )
    #define IADsUser_put_NameSuffix( x, p ) \
        (x)->lpVtbl->put_NameSuffix( x, p )
    #define IADsUser_get_Title( x, p ) \
        (x)->lpVtbl->get_Title( x, p )
    #define IADsUser_put_Title( x, p ) \
        (x)->lpVtbl->put_Title( x, p )
    #define IADsUser_get_Manager( x, p ) \
        (x)->lpVtbl->get_Manager( x, p )
    #define IADsUser_put_Manager( x, p ) \
        (x)->lpVtbl->put_Manager( x, p )
    #define IADsUser_get_TelephoneHome( x, p ) \
        (x)->lpVtbl->get_TelephoneHome( x, p )
    #define IADsUser_put_TelephoneHome( x, p ) \
        (x)->lpVtbl->put_TelephoneHome( x, p )
    #define IADsUser_get_TelephoneMobile( x, p ) \
        (x)->lpVtbl->get_TelephoneMobile( x, p )
    #define IADsUser_put_TelephoneMobile( x, p ) \
        (x)->lpVtbl->put_TelephoneMobile( x, p )
    #define IADsUser_get_TelephoneNumber( x, p ) \
        (x)->lpVtbl->get_TelephoneNumber( x, p )
    #define IADsUser_put_TelephoneNumber( x, p ) \
        (x)->lpVtbl->put_TelephoneNumber( x, p )
    #define IADsUser_get_TelephonePager( x, p ) \
        (x)->lpVtbl->get_TelephonePager( x, p )
    #define IADsUser_put_TelephonePager( x, p ) \
        (x)->lpVtbl->put_TelephonePager( x, p )
    #define IADsUser_get_FaxNumber( x, p ) \
        (x)->lpVtbl->get_FaxNumber( x, p )
    #define IADsUser_put_FaxNumber( x, p ) \
        (x)->lpVtbl->put_FaxNumber( x, p )
    #define IADsUser_get_OfficeLocations( x, p ) \
        (x)->lpVtbl->get_OfficeLocations( x, p )
    #define IADsUser_put_OfficeLocations( x, p ) \
        (x)->lpVtbl->put_OfficeLocations( x, p )
    #define IADsUser_get_PostalAddresses( x, p ) \
        (x)->lpVtbl->get_PostalAddresses( x, p )
    #define IADsUser_put_PostalAddresses( x, p ) \
        (x)->lpVtbl->put_PostalAddresses( x, p )
    #define IADsUser_get_PostalCodes( x, p ) \
        (x)->lpVtbl->get_PostalCodes( x, p )
    #define IADsUser_put_PostalCodes( x, p ) \
        (x)->lpVtbl->put_PostalCodes( x, p )
    #define IADsUser_get_SeeAlso( x, p ) \
        (x)->lpVtbl->get_SeeAlso( x, p )
    #define IADsUser_put_SeeAlso( x, p ) \
        (x)->lpVtbl->put_SeeAlso( x, p )
    #define IADsUser_get_AccountDisabled( x, p ) \
        (x)->lpVtbl->get_AccountDisabled( x, p )
    #define IADsUser_put_AccountDisabled( x, p ) \
        (x)->lpVtbl->put_AccountDisabled( x, p )
    #define IADsUser_get_AccountExpirationDate( x, p ) \
        (x)->lpVtbl->get_AccountExpirationDate( x, p )
    #define IADsUser_put_AccountExpirationDate( x, p ) \
        (x)->lpVtbl->put_AccountExpirationDate( x, p )
    #define IADsUser_get_GraceLoginsAllowed( x, p ) \
        (x)->lpVtbl->get_GraceLoginsAllowed( x, p )
    #define IADsUser_put_GraceLoginsAllowed( x, p ) \
        (x)->lpVtbl->put_GraceLoginsAllowed( x, p )
    #define IADsUser_get_GraceLoginsRemaining( x, p ) \
        (x)->lpVtbl->get_GraceLoginsRemaining( x, p )
    #define IADsUser_put_GraceLoginsRemaining( x, p ) \
        (x)->lpVtbl->put_GraceLoginsRemaining( x, p )
    #define IADsUser_get_IsAccountLocked( x, p ) \
        (x)->lpVtbl->get_IsAccountLocked( x, p )
    #define IADsUser_put_IsAccountLocked( x, p ) \
        (x)->lpVtbl->put_IsAccountLocked( x, p )
    #define IADsUser_get_LoginHours( x, p ) \
        (x)->lpVtbl->get_LoginHours( x, p )
    #define IADsUser_put_LoginHours( x, p ) \
        (x)->lpVtbl->put_LoginHours( x, p )
    #define IADsUser_get_LoginWorkstations( x, p ) \
        (x)->lpVtbl->get_LoginWorkstations( x, p )
    #define IADsUser_put_LoginWorkstations( x, p ) \
        (x)->lpVtbl->put_LoginWorkstations( x, p )
    #define IADsUser_get_MaxLogins( x, p ) \
        (x)->lpVtbl->get_MaxLogins( x, p )
    #define IADsUser_put_MaxLogins( x, p ) \
        (x)->lpVtbl->put_MaxLogins( x, p )
    #define IADsUser_get_MaxStorage( x, p ) \
        (x)->lpVtbl->get_MaxStorage( x, p )
    #define IADsUser_put_MaxStorage( x, p ) \
        (x)->lpVtbl->put_MaxStorage( x, p )
    #define IADsUser_get_PasswordExpirationDate( x, p ) \
        (x)->lpVtbl->get_PasswordExpirationDate( x, p )
    #define IADsUser_put_PasswordExpirationDate( x, p ) \
        (x)->lpVtbl->put_PasswordExpirationDate( x, p )
    #define IADsUser_get_PasswordMinimumLength( x, p ) \
        (x)->lpVtbl->get_PasswordMinimumLength( x, p )
    #define IADsUser_put_PasswordMinimumLength( x, p ) \
        (x)->lpVtbl->put_PasswordMinimumLength( x, p )
    #define IADsUser_get_PasswordRequired( x, p ) \
        (x)->lpVtbl->get_PasswordRequired( x, p )
    #define IADsUser_put_PasswordRequired( x, p ) \
        (x)->lpVtbl->put_PasswordRequired( x, p )
    #define IADsUser_get_RequireUniquePassword( x, p ) \
        (x)->lpVtbl->get_RequireUniquePassword( x, p )
    #define IADsUser_put_RequireUniquePassword( x, p ) \
        (x)->lpVtbl->put_RequireUniquePassword( x, p )
    #define IADsUser_get_EmailAddress( x, p ) \
        (x)->lpVtbl->get_EmailAddress( x, p )
    #define IADsUser_put_EmailAddress( x, p ) \
        (x)->lpVtbl->put_EmailAddress( x, p )
    #define IADsUser_get_HomeDirectory( x, p ) \
        (x)->lpVtbl->get_HomeDirectory( x, p )
    #define IADsUser_put_HomeDirectory( x, p ) \
        (x)->lpVtbl->put_HomeDirectory( x, p )
    #define IADsUser_get_Languages( x, p ) \
        (x)->lpVtbl->get_Languages( x, p )
    #define IADsUser_put_Languages( x, p ) \
        (x)->lpVtbl->put_Languages( x, p )
    #define IADsUser_get_Profile( x, p ) \
        (x)->lpVtbl->get_Profile( x, p )
    #define IADsUser_put_Profile( x, p ) \
        (x)->lpVtbl->put_Profile( x, p )
    #define IADsUser_get_LoginScript( x, p ) \
        (x)->lpVtbl->get_LoginScript( x, p )
    #define IADsUser_put_LoginScript( x, p ) \
        (x)->lpVtbl->put_LoginScript( x, p )
    #define IADsUser_get_Picture( x, p ) \
        (x)->lpVtbl->get_Picture( x, p )
    #define IADsUser_put_Picture( x, p ) \
        (x)->lpVtbl->put_Picture( x, p )
    #define IADsUser_get_HomePage( x, p ) \
        (x)->lpVtbl->get_HomePage( x, p )
    #define IADsUser_put_HomePage( x, p ) \
        (x)->lpVtbl->put_HomePage( x, p )
    #define IADsUser_Groups( x, p ) \
        (x)->lpVtbl->Groups( x, p )
    #define IADsUser_SetPassword( x, p ) \
        (x)->lpVtbl->SetPassword( x, p )
    #define IADsUser_ChangePassword( x, p1, p2 ) \
        (x)->lpVtbl->ChangePassword( x, p1, p2 )
    #define IADsPrintQueue_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPrintQueue_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPrintQueue_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPrintQueue_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPrintQueue_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPrintQueue_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPrintQueue_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPrintQueue_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsPrintQueue_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsPrintQueue_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsPrintQueue_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsPrintQueue_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsPrintQueue_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsPrintQueue_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsPrintQueue_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsPrintQueue_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsPrintQueue_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsPrintQueue_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsPrintQueue_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsPrintQueue_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsPrintQueue_get_PrinterPath( x, p ) \
        (x)->lpVtbl->get_PrinterPath( x, p )
    #define IADsPrintQueue_put_PrinterPath( x, p ) \
        (x)->lpVtbl->put_PrinterPath( x, p )
    #define IADsPrintQueue_get_Model( x, p ) \
        (x)->lpVtbl->get_Model( x, p )
    #define IADsPrintQueue_put_Model( x, p ) \
        (x)->lpVtbl->put_Model( x, p )
    #define IADsPrintQueue_get_Datatype( x, p ) \
        (x)->lpVtbl->get_Datatype( x, p )
    #define IADsPrintQueue_put_Datatype( x, p ) \
        (x)->lpVtbl->put_Datatype( x, p )
    #define IADsPrintQueue_get_PrintProcessor( x, p ) \
        (x)->lpVtbl->get_PrintProcessor( x, p )
    #define IADsPrintQueue_put_PrintProcessor( x, p ) \
        (x)->lpVtbl->put_PrintProcessor( x, p )
    #define IADsPrintQueue_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsPrintQueue_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsPrintQueue_get_Location( x, p ) \
        (x)->lpVtbl->get_Location( x, p )
    #define IADsPrintQueue_put_Location( x, p ) \
        (x)->lpVtbl->put_Location( x, p )
    #define IADsPrintQueue_get_StartTime( x, p ) \
        (x)->lpVtbl->get_StartTime( x, p )
    #define IADsPrintQueue_put_StartTime( x, p ) \
        (x)->lpVtbl->put_StartTime( x, p )
    #define IADsPrintQueue_get_UntilTime( x, p ) \
        (x)->lpVtbl->get_UntilTime( x, p )
    #define IADsPrintQueue_put_UntilTime( x, p ) \
        (x)->lpVtbl->put_UntilTime( x, p )
    #define IADsPrintQueue_get_DefaultJobPriority( x, p ) \
        (x)->lpVtbl->get_DefaultJobPriority( x, p )
    #define IADsPrintQueue_put_DefaultJobPriority( x, p ) \
        (x)->lpVtbl->put_DefaultJobPriority( x, p )
    #define IADsPrintQueue_get_Priority( x, p ) \
        (x)->lpVtbl->get_Priority( x, p )
    #define IADsPrintQueue_put_Priority( x, p ) \
        (x)->lpVtbl->put_Priority( x, p )
    #define IADsPrintQueue_get_BannerPage( x, p ) \
        (x)->lpVtbl->get_BannerPage( x, p )
    #define IADsPrintQueue_put_BannerPage( x, p ) \
        (x)->lpVtbl->put_BannerPage( x, p )
    #define IADsPrintQueue_get_PrintDevices( x, p ) \
        (x)->lpVtbl->get_PrintDevices( x, p )
    #define IADsPrintQueue_put_PrintDevices( x, p ) \
        (x)->lpVtbl->put_PrintDevices( x, p )
    #define IADsPrintQueue_get_NetAddresses( x, p ) \
        (x)->lpVtbl->get_NetAddresses( x, p )
    #define IADsPrintQueue_put_NetAddresses( x, p ) \
        (x)->lpVtbl->put_NetAddresses( x, p )
    #define IADsPrintQueueOperations_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPrintQueueOperations_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPrintQueueOperations_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPrintQueueOperations_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPrintQueueOperations_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPrintQueueOperations_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPrintQueueOperations_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPrintQueueOperations_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsPrintQueueOperations_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsPrintQueueOperations_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsPrintQueueOperations_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsPrintQueueOperations_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsPrintQueueOperations_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsPrintQueueOperations_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsPrintQueueOperations_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsPrintQueueOperations_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsPrintQueueOperations_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsPrintQueueOperations_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsPrintQueueOperations_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsPrintQueueOperations_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsPrintQueueOperations_get_Status( x, p ) \
        (x)->lpVtbl->get_Status( x, p )
    #define IADsPrintQueueOperations_PrintJobs( x, p ) \
        (x)->lpVtbl->PrintJobs( x, p )
    #define IADsPrintQueueOperations_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IADsPrintQueueOperations_Resume( x ) \
        (x)->lpVtbl->Resume( x )
    #define IADsPrintQueueOperations_Purge( x ) \
        (x)->lpVtbl->Purge( x )
    #define IADsPrintJob_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPrintJob_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPrintJob_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPrintJob_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPrintJob_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPrintJob_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPrintJob_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPrintJob_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsPrintJob_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsPrintJob_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsPrintJob_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsPrintJob_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsPrintJob_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsPrintJob_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsPrintJob_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsPrintJob_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsPrintJob_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsPrintJob_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsPrintJob_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsPrintJob_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsPrintJob_get_HostPrintQueue( x, p ) \
        (x)->lpVtbl->get_HostPrintQueue( x, p )
    #define IADsPrintJob_get_User( x, p ) \
        (x)->lpVtbl->get_User( x, p )
    #define IADsPrintJob_get_UserPath( x, p ) \
        (x)->lpVtbl->get_UserPath( x, p )
    #define IADsPrintJob_get_TimeSubmitted( x, p ) \
        (x)->lpVtbl->get_TimeSubmitted( x, p )
    #define IADsPrintJob_get_TotalPages( x, p ) \
        (x)->lpVtbl->get_TotalPages( x, p )
    #define IADsPrintJob_get_Size( x, p ) \
        (x)->lpVtbl->get_Size( x, p )
    #define IADsPrintJob_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsPrintJob_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsPrintJob_get_Priority( x, p ) \
        (x)->lpVtbl->get_Priority( x, p )
    #define IADsPrintJob_put_Priority( x, p ) \
        (x)->lpVtbl->put_Priority( x, p )
    #define IADsPrintJob_get_StartTime( x, p ) \
        (x)->lpVtbl->get_StartTime( x, p )
    #define IADsPrintJob_put_StartTime( x, p ) \
        (x)->lpVtbl->put_StartTime( x, p )
    #define IADsPrintJob_get_UntilTime( x, p ) \
        (x)->lpVtbl->get_UntilTime( x, p )
    #define IADsPrintJob_put_UntilTime( x, p ) \
        (x)->lpVtbl->put_UntilTime( x, p )
    #define IADsPrintJob_get_Notify( x, p ) \
        (x)->lpVtbl->get_Notify( x, p )
    #define IADsPrintJob_put_Notify( x, p ) \
        (x)->lpVtbl->put_Notify( x, p )
    #define IADsPrintJob_get_NotifyPath( x, p ) \
        (x)->lpVtbl->get_NotifyPath( x, p )
    #define IADsPrintJob_put_NotifyPath( x, p ) \
        (x)->lpVtbl->put_NotifyPath( x, p )
    #define IADsPrintJobOperations_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPrintJobOperations_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPrintJobOperations_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPrintJobOperations_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPrintJobOperations_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPrintJobOperations_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPrintJobOperations_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPrintJobOperations_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsPrintJobOperations_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsPrintJobOperations_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsPrintJobOperations_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsPrintJobOperations_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsPrintJobOperations_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsPrintJobOperations_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsPrintJobOperations_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsPrintJobOperations_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsPrintJobOperations_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsPrintJobOperations_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsPrintJobOperations_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsPrintJobOperations_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsPrintJobOperations_get_Status( x, p ) \
        (x)->lpVtbl->get_Status( x, p )
    #define IADsPrintJobOperations_get_TimeElapsed( x, p ) \
        (x)->lpVtbl->get_TimeElapsed( x, p )
    #define IADsPrintJobOperations_get_PagesPrinted( x, p ) \
        (x)->lpVtbl->get_PagesPrinted( x, p )
    #define IADsPrintJobOperations_get_Position( x, p ) \
        (x)->lpVtbl->get_Position( x, p )
    #define IADsPrintJobOperations_put_Position( x, p ) \
        (x)->lpVtbl->put_Position( x, p )
    #define IADsPrintJobOperations_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IADsPrintJobOperations_Resume( x ) \
        (x)->lpVtbl->Resume( x )
    #define IADsService_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsService_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsService_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsService_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsService_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsService_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsService_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsService_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsService_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsService_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsService_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsService_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsService_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsService_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsService_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsService_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsService_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsService_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsService_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsService_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsService_get_HostComputer( x, p ) \
        (x)->lpVtbl->get_HostComputer( x, p )
    #define IADsService_put_HostComputer( x, p ) \
        (x)->lpVtbl->put_HostComputer( x, p )
    #define IADsService_get_DisplayName( x, p ) \
        (x)->lpVtbl->get_DisplayName( x, p )
    #define IADsService_put_DisplayName( x, p ) \
        (x)->lpVtbl->put_DisplayName( x, p )
    #define IADsService_get_Version( x, p ) \
        (x)->lpVtbl->get_Version( x, p )
    #define IADsService_put_Version( x, p ) \
        (x)->lpVtbl->put_Version( x, p )
    #define IADsService_get_ServiceType( x, p ) \
        (x)->lpVtbl->get_ServiceType( x, p )
    #define IADsService_put_ServiceType( x, p ) \
        (x)->lpVtbl->put_ServiceType( x, p )
    #define IADsService_get_StartType( x, p ) \
        (x)->lpVtbl->get_StartType( x, p )
    #define IADsService_put_StartType( x, p ) \
        (x)->lpVtbl->put_StartType( x, p )
    #define IADsService_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IADsService_put_Path( x, p ) \
        (x)->lpVtbl->put_Path( x, p )
    #define IADsService_get_StartupParameters( x, p ) \
        (x)->lpVtbl->get_StartupParameters( x, p )
    #define IADsService_put_StartupParameters( x, p ) \
        (x)->lpVtbl->put_StartupParameters( x, p )
    #define IADsService_get_ErrorControl( x, p ) \
        (x)->lpVtbl->get_ErrorControl( x, p )
    #define IADsService_put_ErrorControl( x, p ) \
        (x)->lpVtbl->put_ErrorControl( x, p )
    #define IADsService_get_LoadOrderGroup( x, p ) \
        (x)->lpVtbl->get_LoadOrderGroup( x, p )
    #define IADsService_put_LoadOrderGroup( x, p ) \
        (x)->lpVtbl->put_LoadOrderGroup( x, p )
    #define IADsService_get_ServiceAccountName( x, p ) \
        (x)->lpVtbl->get_ServiceAccountName( x, p )
    #define IADsService_put_ServiceAccountName( x, p ) \
        (x)->lpVtbl->put_ServiceAccountName( x, p )
    #define IADsService_get_ServiceAccountPath( x, p ) \
        (x)->lpVtbl->get_ServiceAccountPath( x, p )
    #define IADsService_put_ServiceAccountPath( x, p ) \
        (x)->lpVtbl->put_ServiceAccountPath( x, p )
    #define IADsService_get_Dependencies( x, p ) \
        (x)->lpVtbl->get_Dependencies( x, p )
    #define IADsService_put_Dependencies( x, p ) \
        (x)->lpVtbl->put_Dependencies( x, p )
    #define IADsServiceOperations_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsServiceOperations_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsServiceOperations_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsServiceOperations_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsServiceOperations_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsServiceOperations_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsServiceOperations_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsServiceOperations_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsServiceOperations_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsServiceOperations_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsServiceOperations_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsServiceOperations_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsServiceOperations_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsServiceOperations_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsServiceOperations_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsServiceOperations_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsServiceOperations_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsServiceOperations_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsServiceOperations_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsServiceOperations_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsServiceOperations_get_Status( x, p ) \
        (x)->lpVtbl->get_Status( x, p )
    #define IADsServiceOperations_Start( x ) \
        (x)->lpVtbl->Start( x )
    #define IADsServiceOperations_Stop( x ) \
        (x)->lpVtbl->Stop( x )
    #define IADsServiceOperations_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IADsServiceOperations_Continue( x ) \
        (x)->lpVtbl->Continue( x )
    #define IADsServiceOperations_SetPassword( x, p ) \
        (x)->lpVtbl->SetPassword( x, p )
    #define IADsFileService_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsFileService_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsFileService_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsFileService_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsFileService_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsFileService_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsFileService_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsFileService_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsFileService_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsFileService_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsFileService_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsFileService_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsFileService_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsFileService_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsFileService_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsFileService_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsFileService_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsFileService_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsFileService_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsFileService_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsFileService_get_HostComputer( x, p ) \
        (x)->lpVtbl->get_HostComputer( x, p )
    #define IADsFileService_put_HostComputer( x, p ) \
        (x)->lpVtbl->put_HostComputer( x, p )
    #define IADsFileService_get_DisplayName( x, p ) \
        (x)->lpVtbl->get_DisplayName( x, p )
    #define IADsFileService_put_DisplayName( x, p ) \
        (x)->lpVtbl->put_DisplayName( x, p )
    #define IADsFileService_get_Version( x, p ) \
        (x)->lpVtbl->get_Version( x, p )
    #define IADsFileService_put_Version( x, p ) \
        (x)->lpVtbl->put_Version( x, p )
    #define IADsFileService_get_ServiceType( x, p ) \
        (x)->lpVtbl->get_ServiceType( x, p )
    #define IADsFileService_put_ServiceType( x, p ) \
        (x)->lpVtbl->put_ServiceType( x, p )
    #define IADsFileService_get_StartType( x, p ) \
        (x)->lpVtbl->get_StartType( x, p )
    #define IADsFileService_put_StartType( x, p ) \
        (x)->lpVtbl->put_StartType( x, p )
    #define IADsFileService_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IADsFileService_put_Path( x, p ) \
        (x)->lpVtbl->put_Path( x, p )
    #define IADsFileService_get_StartupParameters( x, p ) \
        (x)->lpVtbl->get_StartupParameters( x, p )
    #define IADsFileService_put_StartupParameters( x, p ) \
        (x)->lpVtbl->put_StartupParameters( x, p )
    #define IADsFileService_get_ErrorControl( x, p ) \
        (x)->lpVtbl->get_ErrorControl( x, p )
    #define IADsFileService_put_ErrorControl( x, p ) \
        (x)->lpVtbl->put_ErrorControl( x, p )
    #define IADsFileService_get_LoadOrderGroup( x, p ) \
        (x)->lpVtbl->get_LoadOrderGroup( x, p )
    #define IADsFileService_put_LoadOrderGroup( x, p ) \
        (x)->lpVtbl->put_LoadOrderGroup( x, p )
    #define IADsFileService_get_ServiceAccountName( x, p ) \
        (x)->lpVtbl->get_ServiceAccountName( x, p )
    #define IADsFileService_put_ServiceAccountName( x, p ) \
        (x)->lpVtbl->put_ServiceAccountName( x, p )
    #define IADsFileService_get_ServiceAccountPath( x, p ) \
        (x)->lpVtbl->get_ServiceAccountPath( x, p )
    #define IADsFileService_put_ServiceAccountPath( x, p ) \
        (x)->lpVtbl->put_ServiceAccountPath( x, p )
    #define IADsFileService_get_Dependencies( x, p ) \
        (x)->lpVtbl->get_Dependencies( x, p )
    #define IADsFileService_put_Dependencies( x, p ) \
        (x)->lpVtbl->put_Dependencies( x, p )
    #define IADsFileService_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsFileService_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsFileService_get_MaxUserCount( x, p ) \
        (x)->lpVtbl->get_MaxUserCount( x, p )
    #define IADsFileService_put_MaxUserCount( x, p ) \
        (x)->lpVtbl->put_MaxUserCount( x, p )
    #define IADsFileServiceOperations_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsFileServiceOperations_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsFileServiceOperations_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsFileServiceOperations_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsFileServiceOperations_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsFileServiceOperations_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsFileServiceOperations_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsFileServiceOperations_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsFileServiceOperations_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsFileServiceOperations_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsFileServiceOperations_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsFileServiceOperations_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsFileServiceOperations_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsFileServiceOperations_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsFileServiceOperations_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsFileServiceOperations_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsFileServiceOperations_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsFileServiceOperations_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsFileServiceOperations_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsFileServiceOperations_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsFileServiceOperations_get_Status( x, p ) \
        (x)->lpVtbl->get_Status( x, p )
    #define IADsFileServiceOperations_Start( x ) \
        (x)->lpVtbl->Start( x )
    #define IADsFileServiceOperations_Stop( x ) \
        (x)->lpVtbl->Stop( x )
    #define IADsFileServiceOperations_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IADsFileServiceOperations_Continue( x ) \
        (x)->lpVtbl->Continue( x )
    #define IADsFileServiceOperations_SetPassword( x, p ) \
        (x)->lpVtbl->SetPassword( x, p )
    #define IADsFileServiceOperations_Sessions( x, p ) \
        (x)->lpVtbl->Sessions( x, p )
    #define IADsFileServiceOperations_Resources( x, p ) \
        (x)->lpVtbl->Resources( x, p )
    #define IADsFileShare_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsFileShare_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsFileShare_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsFileShare_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsFileShare_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsFileShare_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsFileShare_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsFileShare_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsFileShare_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsFileShare_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsFileShare_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsFileShare_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsFileShare_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsFileShare_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsFileShare_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsFileShare_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsFileShare_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsFileShare_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsFileShare_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsFileShare_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsFileShare_get_CurrentUserCount( x, p ) \
        (x)->lpVtbl->get_CurrentUserCount( x, p )
    #define IADsFileShare_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IADsFileShare_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IADsFileShare_get_HostComputer( x, p ) \
        (x)->lpVtbl->get_HostComputer( x, p )
    #define IADsFileShare_put_HostComputer( x, p ) \
        (x)->lpVtbl->put_HostComputer( x, p )
    #define IADsFileShare_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IADsFileShare_put_Path( x, p ) \
        (x)->lpVtbl->put_Path( x, p )
    #define IADsFileShare_get_MaxUserCount( x, p ) \
        (x)->lpVtbl->get_MaxUserCount( x, p )
    #define IADsFileShare_put_MaxUserCount( x, p ) \
        (x)->lpVtbl->put_MaxUserCount( x, p )
    #define IADsSession_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsSession_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsSession_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsSession_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsSession_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsSession_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsSession_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsSession_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsSession_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsSession_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsSession_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsSession_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsSession_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsSession_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsSession_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsSession_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsSession_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsSession_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsSession_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsSession_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsSession_get_User( x, p ) \
        (x)->lpVtbl->get_User( x, p )
    #define IADsSession_get_UserPath( x, p ) \
        (x)->lpVtbl->get_UserPath( x, p )
    #define IADsSession_get_Computer( x, p ) \
        (x)->lpVtbl->get_Computer( x, p )
    #define IADsSession_get_ComputerPath( x, p ) \
        (x)->lpVtbl->get_ComputerPath( x, p )
    #define IADsSession_get_ConnectTime( x, p ) \
        (x)->lpVtbl->get_ConnectTime( x, p )
    #define IADsSession_get_IdleTime( x, p ) \
        (x)->lpVtbl->get_IdleTime( x, p )
    #define IADsResource_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsResource_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsResource_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsResource_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsResource_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsResource_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsResource_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsResource_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IADsResource_get_Class( x, p ) \
        (x)->lpVtbl->get_Class( x, p )
    #define IADsResource_get_GUID( x, p ) \
        (x)->lpVtbl->get_GUID( x, p )
    #define IADsResource_get_ADsPath( x, p ) \
        (x)->lpVtbl->get_ADsPath( x, p )
    #define IADsResource_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IADsResource_get_Schema( x, p ) \
        (x)->lpVtbl->get_Schema( x, p )
    #define IADsResource_GetInfo( x ) \
        (x)->lpVtbl->GetInfo( x )
    #define IADsResource_SetInfo( x ) \
        (x)->lpVtbl->SetInfo( x )
    #define IADsResource_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsResource_Put( x, p1, p2 ) \
        (x)->lpVtbl->Put( x, p1, p2 )
    #define IADsResource_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsResource_PutEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->PutEx( x, p1, p2, p3 )
    #define IADsResource_GetInfoEx( x, p1, p2 ) \
        (x)->lpVtbl->GetInfoEx( x, p1, p2 )
    #define IADsResource_get_User( x, p ) \
        (x)->lpVtbl->get_User( x, p )
    #define IADsResource_get_UserPath( x, p ) \
        (x)->lpVtbl->get_UserPath( x, p )
    #define IADsResource_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IADsResource_get_LockCount( x, p ) \
        (x)->lpVtbl->get_LockCount( x, p )
    #define IADsOpenDSObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsOpenDSObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsOpenDSObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsOpenDSObject_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsOpenDSObject_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsOpenDSObject_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsOpenDSObject_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsOpenDSObject_OpenDSObject( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->OpenDSObject( x, p1, p2, p3, p4, p5 )
    #define IDirectoryObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectoryObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectoryObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectoryObject_GetObjectInformation( x, p ) \
        (x)->lpVtbl->GetObjectInformation( x, p )
    #define IDirectoryObject_GetObjectAttributes( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetObjectAttributes( x, p1, p2, p3, p4 )
    #define IDirectoryObject_SetObjectAttributes( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetObjectAttributes( x, p1, p2, p3 )
    #define IDirectoryObject_CreateDSObject( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateDSObject( x, p1, p2, p3, p4 )
    #define IDirectoryObject_DeleteDSObject( x, p ) \
        (x)->lpVtbl->DeleteDSObject( x, p )
    #define IDirectorySearch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectorySearch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectorySearch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectorySearch_SetSearchPreference( x, p1, p2 ) \
        (x)->lpVtbl->SetSearchPreference( x, p1, p2 )
    #define IDirectorySearch_ExecuteSearch( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ExecuteSearch( x, p1, p2, p3, p4 )
    #define IDirectorySearch_AbandonSearch( x, p ) \
        (x)->lpVtbl->AbandonSearch( x, p )
    #define IDirectorySearch_GetFirstRow( x, p ) \
        (x)->lpVtbl->GetFirstRow( x, p )
    #define IDirectorySearch_GetNextRow( x, p ) \
        (x)->lpVtbl->GetNextRow( x, p )
    #define IDirectorySearch_GetPreviousRow( x, p ) \
        (x)->lpVtbl->GetPreviousRow( x, p )
    #define IDirectorySearch_GetNextColumnName( x, p1, p2 ) \
        (x)->lpVtbl->GetNextColumnName( x, p1, p2 )
    #define IDirectorySearch_GetColumn( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetColumn( x, p1, p2, p3 )
    #define IDirectorySearch_FreeColumn( x, p ) \
        (x)->lpVtbl->FreeColumn( x, p )
    #define IDirectorySearch_CloseSearchHandle( x, p ) \
        (x)->lpVtbl->CloseSearchHandle( x, p )
    #define IDirectorySchemaMgmt_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectorySchemaMgmt_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectorySchemaMgmt_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectorySchemaMgmt_EnumAttributes( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->EnumAttributes( x, p1, p2, p3, p4 )
    #define IDirectorySchemaMgmt_CreateAttributeDefinition( x, p1, p2 ) \
        (x)->lpVtbl->CreateAttributeDefinition( x, p1, p2 )
    #define IDirectorySchemaMgmt_WriteAttributeDefinition( x, p1, p2 ) \
        (x)->lpVtbl->WriteAttributeDefinition( x, p1, p2 )
    #define IDirectorySchemaMgmt_DeleteAttributeDefinition( x, p ) \
        (x)->lpVtbl->DeleteAttributeDefinition( x, p )
    #define IDirectorySchemaMgmt_EnumClasses( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->EnumClasses( x, p1, p2, p3, p4 )
    #define IDirectorySchemaMgmt_WriteClassDefinition( x, p1, p2 ) \
        (x)->lpVtbl->WriteClassDefinition( x, p1, p2 )
    #define IDirectorySchemaMgmt_CreateClassDefinition( x, p1, p2 ) \
        (x)->lpVtbl->CreateClassDefinition( x, p1, p2 )
    #define IDirectorySchemaMgmt_DeleteClassDefinition( x, p ) \
        (x)->lpVtbl->DeleteClassDefinition( x, p )
    #define IADsAggregatee_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsAggregatee_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsAggregatee_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsAggregatee_ConnectAsAggregatee( x, p ) \
        (x)->lpVtbl->ConnectAsAggregatee( x, p )
    #define IADsAggregatee_DisconnectAsAggregatee( x ) \
        (x)->lpVtbl->DisconnectAsAggregatee( x )
    #define IADsAggregatee_RelinquishInterface( x, p ) \
        (x)->lpVtbl->RelinquishInterface( x, p )
    #define IADsAggregatee_RestoreInterface( x, p ) \
        (x)->lpVtbl->RestoreInterface( x, p )
    #define IADsAggregator_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsAggregator_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsAggregator_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsAggregator_ConnectAsAggregator( x, p ) \
        (x)->lpVtbl->ConnectAsAggregator( x, p )
    #define IADsAggregator_DisconnectAsAggregator( x ) \
        (x)->lpVtbl->DisconnectAsAggregator( x )
    #define IADsAccessControlEntry_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsAccessControlEntry_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsAccessControlEntry_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsAccessControlEntry_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsAccessControlEntry_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsAccessControlEntry_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsAccessControlEntry_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsAccessControlEntry_get_AccessMask( x, p ) \
        (x)->lpVtbl->get_AccessMask( x, p )
    #define IADsAccessControlEntry_put_AccessMask( x, p ) \
        (x)->lpVtbl->put_AccessMask( x, p )
    #define IADsAccessControlEntry_get_AceType( x, p ) \
        (x)->lpVtbl->get_AceType( x, p )
    #define IADsAccessControlEntry_put_AceType( x, p ) \
        (x)->lpVtbl->put_AceType( x, p )
    #define IADsAccessControlEntry_get_AceFlags( x, p ) \
        (x)->lpVtbl->get_AceFlags( x, p )
    #define IADsAccessControlEntry_put_AceFlags( x, p ) \
        (x)->lpVtbl->put_AceFlags( x, p )
    #define IADsAccessControlEntry_get_Flags( x, p ) \
        (x)->lpVtbl->get_Flags( x, p )
    #define IADsAccessControlEntry_put_Flags( x, p ) \
        (x)->lpVtbl->put_Flags( x, p )
    #define IADsAccessControlEntry_get_ObjectType( x, p ) \
        (x)->lpVtbl->get_ObjectType( x, p )
    #define IADsAccessControlEntry_put_ObjectType( x, p ) \
        (x)->lpVtbl->put_ObjectType( x, p )
    #define IADsAccessControlEntry_get_InheritedObjectType( x, p ) \
        (x)->lpVtbl->get_InheritedObjectType( x, p )
    #define IADsAccessControlEntry_put_InheritedObjectType( x, p ) \
        (x)->lpVtbl->put_InheritedObjectType( x, p )
    #define IADsAccessControlEntry_get_Trustee( x, p ) \
        (x)->lpVtbl->get_Trustee( x, p )
    #define IADsAccessControlEntry_put_Trustee( x, p ) \
        (x)->lpVtbl->put_Trustee( x, p )
    #define IADsAccessControlList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsAccessControlList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsAccessControlList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsAccessControlList_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsAccessControlList_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsAccessControlList_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsAccessControlList_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsAccessControlList_get_AclRevision( x, p ) \
        (x)->lpVtbl->get_AclRevision( x, p )
    #define IADsAccessControlList_put_AclRevision( x, p ) \
        (x)->lpVtbl->put_AclRevision( x, p )
    #define IADsAccessControlList_get_AceCount( x, p ) \
        (x)->lpVtbl->get_AceCount( x, p )
    #define IADsAccessControlList_put_AceCount( x, p ) \
        (x)->lpVtbl->put_AceCount( x, p )
    #define IADsAccessControlList_AddAce( x, p ) \
        (x)->lpVtbl->AddAce( x, p )
    #define IADsAccessControlList_RemoveAce( x, p ) \
        (x)->lpVtbl->RemoveAce( x, p )
    #define IADsAccessControlList_CopyAccessList( x, p ) \
        (x)->lpVtbl->CopyAccessList( x, p )
    #define IADsAccessControlList_get__NewEnum( x, p ) \
        (x)->lpVtbl->get__NewEnum( x, p )
    #define IADsSecurityDescriptor_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsSecurityDescriptor_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsSecurityDescriptor_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsSecurityDescriptor_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsSecurityDescriptor_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsSecurityDescriptor_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsSecurityDescriptor_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsSecurityDescriptor_get_Revision( x, p ) \
        (x)->lpVtbl->get_Revision( x, p )
    #define IADsSecurityDescriptor_put_Revision( x, p ) \
        (x)->lpVtbl->put_Revision( x, p )
    #define IADsSecurityDescriptor_get_Control( x, p ) \
        (x)->lpVtbl->get_Control( x, p )
    #define IADsSecurityDescriptor_put_Control( x, p ) \
        (x)->lpVtbl->put_Control( x, p )
    #define IADsSecurityDescriptor_get_Owner( x, p ) \
        (x)->lpVtbl->get_Owner( x, p )
    #define IADsSecurityDescriptor_put_Owner( x, p ) \
        (x)->lpVtbl->put_Owner( x, p )
    #define IADsSecurityDescriptor_get_OwnerDefaulted( x, p ) \
        (x)->lpVtbl->get_OwnerDefaulted( x, p )
    #define IADsSecurityDescriptor_put_OwnerDefaulted( x, p ) \
        (x)->lpVtbl->put_OwnerDefaulted( x, p )
    #define IADsSecurityDescriptor_get_Group( x, p ) \
        (x)->lpVtbl->get_Group( x, p )
    #define IADsSecurityDescriptor_put_Group( x, p ) \
        (x)->lpVtbl->put_Group( x, p )
    #define IADsSecurityDescriptor_get_GroupDefaulted( x, p ) \
        (x)->lpVtbl->get_GroupDefaulted( x, p )
    #define IADsSecurityDescriptor_put_GroupDefaulted( x, p ) \
        (x)->lpVtbl->put_GroupDefaulted( x, p )
    #define IADsSecurityDescriptor_get_DiscretionaryAcl( x, p ) \
        (x)->lpVtbl->get_DiscretionaryAcl( x, p )
    #define IADsSecurityDescriptor_put_DiscretionaryAcl( x, p ) \
        (x)->lpVtbl->put_DiscretionaryAcl( x, p )
    #define IADsSecurityDescriptor_get_DaclDefaulted( x, p ) \
        (x)->lpVtbl->get_DaclDefaulted( x, p )
    #define IADsSecurityDescriptor_put_DaclDefaulted( x, p ) \
        (x)->lpVtbl->put_DaclDefaulted( x, p )
    #define IADsSecurityDescriptor_get_SystemAcl( x, p ) \
        (x)->lpVtbl->get_SystemAcl( x, p )
    #define IADsSecurityDescriptor_put_SystemAcl( x, p ) \
        (x)->lpVtbl->put_SystemAcl( x, p )
    #define IADsSecurityDescriptor_get_SaclDefaulted( x, p ) \
        (x)->lpVtbl->get_SaclDefaulted( x, p )
    #define IADsSecurityDescriptor_put_SaclDefaulted( x, p ) \
        (x)->lpVtbl->put_SaclDefaulted( x, p )
    #define IADsSecurityDescriptor_CopySecurityDescriptor( x, p ) \
        (x)->lpVtbl->CopySecurityDescriptor( x, p )
    #define IADsLargeInteger_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsLargeInteger_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsLargeInteger_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsLargeInteger_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsLargeInteger_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsLargeInteger_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsLargeInteger_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsLargeInteger_get_HighPart( x, p ) \
        (x)->lpVtbl->get_HighPart( x, p )
    #define IADsLargeInteger_put_HighPart( x, p ) \
        (x)->lpVtbl->put_HighPart( x, p )
    #define IADsLargeInteger_get_LowPart( x, p ) \
        (x)->lpVtbl->get_LowPart( x, p )
    #define IADsLargeInteger_put_LowPart( x, p ) \
        (x)->lpVtbl->put_LowPart( x, p )
    #define IADsNameTranslate_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsNameTranslate_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsNameTranslate_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsNameTranslate_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsNameTranslate_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsNameTranslate_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsNameTranslate_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsNameTranslate_put_ChaseReferral( x, p ) \
        (x)->lpVtbl->put_ChaseReferral( x, p )
    #define IADsNameTranslate_Init( x, p1, p2 ) \
        (x)->lpVtbl->Init( x, p1, p2 )
    #define IADsNameTranslate_InitEx( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->InitEx( x, p1, p2, p3, p4, p5 )
    #define IADsNameTranslate_Set( x, p1, p2 ) \
        (x)->lpVtbl->Set( x, p1, p2 )
    #define IADsNameTranslate_Get( x, p1, p2 ) \
        (x)->lpVtbl->Get( x, p1, p2 )
    #define IADsNameTranslate_SetEx( x, p1, p2 ) \
        (x)->lpVtbl->SetEx( x, p1, p2 )
    #define IADsNameTranslate_GetEx( x, p1, p2 ) \
        (x)->lpVtbl->GetEx( x, p1, p2 )
    #define IADsCaseIgnoreList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsCaseIgnoreList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsCaseIgnoreList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsCaseIgnoreList_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsCaseIgnoreList_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsCaseIgnoreList_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsCaseIgnoreList_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsFaxNumber_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsFaxNumber_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsFaxNumber_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsFaxNumber_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsFaxNumber_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsFaxNumber_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsFaxNumber_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsFaxNumber_get_TelephoneNumber( x, p ) \
        (x)->lpVtbl->get_TelephoneNumber( x, p )
    #define IADsFaxNumber_put_TelephoneNumber( x, p ) \
        (x)->lpVtbl->put_TelephoneNumber( x, p )
    #define IADsFaxNumber_get_Parameters( x, p ) \
        (x)->lpVtbl->get_Parameters( x, p )
    #define IADsFaxNumber_put_Parameters( x, p ) \
        (x)->lpVtbl->put_Parameters( x, p )
    #define IADsNetAddress_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsNetAddress_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsNetAddress_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsNetAddress_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsNetAddress_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsNetAddress_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsNetAddress_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsNetAddress_get_AddressType( x, p ) \
        (x)->lpVtbl->get_AddressType( x, p )
    #define IADsNetAddress_put_AddressType( x, p ) \
        (x)->lpVtbl->put_AddressType( x, p )
    #define IADsNetAddress_get_Address( x, p ) \
        (x)->lpVtbl->get_Address( x, p )
    #define IADsNetAddress_put_Address( x, p ) \
        (x)->lpVtbl->put_Address( x, p )
    #define IADsOctetList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsOctetList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsOctetList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsOctetList_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsOctetList_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsOctetList_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsOctetList_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsOctetList_get_OctetList( x, p ) \
        (x)->lpVtbl->get_OctetList( x, p )
    #define IADsOctetList_put_OctetList( x, p ) \
        (x)->lpVtbl->put_OctetList( x, p )
    #define IADsEmail_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsEmail_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsEmail_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsEmail_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsEmail_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsEmail_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsEmail_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsEmail_get_Type( x, p ) \
        (x)->lpVtbl->get_Type( x, p )
    #define IADsEmail_put_Type( x, p ) \
        (x)->lpVtbl->put_Type( x, p )
    #define IADsEmail_get_Address( x, p ) \
        (x)->lpVtbl->get_Address( x, p )
    #define IADsEmail_put_Address( x, p ) \
        (x)->lpVtbl->put_Address( x, p )
    #define IADsPath_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPath_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPath_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPath_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPath_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPath_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPath_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPath_get_Type( x, p ) \
        (x)->lpVtbl->get_Type( x, p )
    #define IADsPath_put_Type( x, p ) \
        (x)->lpVtbl->put_Type( x, p )
    #define IADsPath_get_VolumeName( x, p ) \
        (x)->lpVtbl->get_VolumeName( x, p )
    #define IADsPath_put_VolumeName( x, p ) \
        (x)->lpVtbl->put_VolumeName( x, p )
    #define IADsPath_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IADsPath_put_Path( x, p ) \
        (x)->lpVtbl->put_Path( x, p )
    #define IADsReplicaPointer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsReplicaPointer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsReplicaPointer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsReplicaPointer_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsReplicaPointer_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsReplicaPointer_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsReplicaPointer_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsReplicaPointer_get_ServerName( x, p ) \
        (x)->lpVtbl->get_ServerName( x, p )
    #define IADsReplicaPointer_put_ServerName( x, p ) \
        (x)->lpVtbl->put_ServerName( x, p )
    #define IADsReplicaPointer_get_ReplicaType( x, p ) \
        (x)->lpVtbl->get_ReplicaType( x, p )
    #define IADsReplicaPointer_put_ReplicaType( x, p ) \
        (x)->lpVtbl->put_ReplicaType( x, p )
    #define IADsReplicaPointer_get_ReplicaNumber( x, p ) \
        (x)->lpVtbl->get_ReplicaNumber( x, p )
    #define IADsReplicaPointer_put_ReplicaNumber( x, p ) \
        (x)->lpVtbl->put_ReplicaNumber( x, p )
    #define IADsReplicaPointer_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define IADsReplicaPointer_put_Count( x, p ) \
        (x)->lpVtbl->put_Count( x, p )
    #define IADsReplicaPointer_get_ReplicaAddressHints( x, p ) \
        (x)->lpVtbl->get_ReplicaAddressHints( x, p )
    #define IADsReplicaPointer_put_ReplicaAddressHints( x, p ) \
        (x)->lpVtbl->put_ReplicaAddressHints( x, p )
    #define IADsAcl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsAcl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsAcl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsAcl_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsAcl_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsAcl_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsAcl_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsAcl_get_ProtectedAttrName( x, p ) \
        (x)->lpVtbl->get_ProtectedAttrName( x, p )
    #define IADsAcl_put_ProtectedAttrName( x, p ) \
        (x)->lpVtbl->put_ProtectedAttrName( x, p )
    #define IADsAcl_get_SubjectName( x, p ) \
        (x)->lpVtbl->get_SubjectName( x, p )
    #define IADsAcl_put_SubjectName( x, p ) \
        (x)->lpVtbl->put_SubjectName( x, p )
    #define IADsAcl_get_Privileges( x, p ) \
        (x)->lpVtbl->get_Privileges( x, p )
    #define IADsAcl_put_Privileges( x, p ) \
        (x)->lpVtbl->put_Privileges( x, p )
    #define IADsAcl_CopyAcl( x, p ) \
        (x)->lpVtbl->CopyAcl( x, p )
    #define IADsTimestamp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsTimestamp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsTimestamp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsTimestamp_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsTimestamp_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsTimestamp_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsTimestamp_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsTimestamp_get_WholeSeconds( x, p ) \
        (x)->lpVtbl->get_WholeSeconds( x, p )
    #define IADsTimestamp_put_WholeSeconds( x, p ) \
        (x)->lpVtbl->put_WholeSeconds( x, p )
    #define IADsTimestamp_get_EventID( x, p ) \
        (x)->lpVtbl->get_EventID( x, p )
    #define IADsTimestamp_put_EventID( x, p ) \
        (x)->lpVtbl->put_EventID( x, p )
    #define IADsPostalAddress_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPostalAddress_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPostalAddress_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPostalAddress_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPostalAddress_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPostalAddress_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPostalAddress_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPostalAddress_get_PostalAddress( x, p ) \
        (x)->lpVtbl->get_PostalAddress( x, p )
    #define IADsPostalAddress_put_PostalAddress( x, p ) \
        (x)->lpVtbl->put_PostalAddress( x, p )
    #define IADsBackLink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsBackLink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsBackLink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsBackLink_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsBackLink_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsBackLink_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsBackLink_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsBackLink_get_RemoteID( x, p ) \
        (x)->lpVtbl->get_RemoteID( x, p )
    #define IADsBackLink_put_RemoteID( x, p ) \
        (x)->lpVtbl->put_RemoteID( x, p )
    #define IADsBackLink_get_ObjectName( x, p ) \
        (x)->lpVtbl->get_ObjectName( x, p )
    #define IADsBackLink_put_ObjectName( x, p ) \
        (x)->lpVtbl->put_ObjectName( x, p )
    #define IADsTypedName_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsTypedName_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsTypedName_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsTypedName_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsTypedName_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsTypedName_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsTypedName_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsTypedName_get_ObjectName( x, p ) \
        (x)->lpVtbl->get_ObjectName( x, p )
    #define IADsTypedName_put_ObjectName( x, p ) \
        (x)->lpVtbl->put_ObjectName( x, p )
    #define IADsTypedName_get_Level( x, p ) \
        (x)->lpVtbl->get_Level( x, p )
    #define IADsTypedName_put_Level( x, p ) \
        (x)->lpVtbl->put_Level( x, p )
    #define IADsTypedName_get_Interval( x, p ) \
        (x)->lpVtbl->get_Interval( x, p )
    #define IADsTypedName_put_Interval( x, p ) \
        (x)->lpVtbl->put_Interval( x, p )
    #define IADsHold_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsHold_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsHold_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsHold_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsHold_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsHold_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsHold_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsHold_get_ObjectName( x, p ) \
        (x)->lpVtbl->get_ObjectName( x, p )
    #define IADsHold_put_ObjectName( x, p ) \
        (x)->lpVtbl->put_ObjectName( x, p )
    #define IADsHold_get_Amount( x, p ) \
        (x)->lpVtbl->get_Amount( x, p )
    #define IADsHold_put_Amount( x, p ) \
        (x)->lpVtbl->put_Amount( x, p )
    #define IADsObjectOptions_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsObjectOptions_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsObjectOptions_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsObjectOptions_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsObjectOptions_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsObjectOptions_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsObjectOptions_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsObjectOptions_GetOption( x, p1, p2 ) \
        (x)->lpVtbl->GetOption( x, p1, p2 )
    #define IADsObjectOptions_SetOption( x, p1, p2 ) \
        (x)->lpVtbl->SetOption( x, p1, p2 )
    #define IADsPathname_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsPathname_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsPathname_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsPathname_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsPathname_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsPathname_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsPathname_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsPathname_Set( x, p1, p2 ) \
        (x)->lpVtbl->Set( x, p1, p2 )
    #define IADsPathname_SetDisplayType( x, p ) \
        (x)->lpVtbl->SetDisplayType( x, p )
    #define IADsPathname_Retrieve( x, p1, p2 ) \
        (x)->lpVtbl->Retrieve( x, p1, p2 )
    #define IADsPathname_GetNumElements( x, p ) \
        (x)->lpVtbl->GetNumElements( x, p )
    #define IADsPathname_GetElement( x, p1, p2 ) \
        (x)->lpVtbl->GetElement( x, p1, p2 )
    #define IADsPathname_AddLeafElement( x, p ) \
        (x)->lpVtbl->AddLeafElement( x, p )
    #define IADsPathname_RemoveLeafElement( x ) \
        (x)->lpVtbl->RemoveLeafElement( x )
    #define IADsPathname_CopyPath( x, p ) \
        (x)->lpVtbl->CopyPath( x, p )
    #define IADsPathname_GetEscapedElement( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetEscapedElement( x, p1, p2, p3 )
    #define IADsPathname_get_EscapedMode( x, p ) \
        (x)->lpVtbl->get_EscapedMode( x, p )
    #define IADsPathname_put_EscapedMode( x, p ) \
        (x)->lpVtbl->put_EscapedMode( x, p )
    #define IADsADSystemInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsADSystemInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsADSystemInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsADSystemInfo_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsADSystemInfo_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsADSystemInfo_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsADSystemInfo_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsADSystemInfo_get_UserName( x, p ) \
        (x)->lpVtbl->get_UserName( x, p )
    #define IADsADSystemInfo_get_ComputerName( x, p ) \
        (x)->lpVtbl->get_ComputerName( x, p )
    #define IADsADSystemInfo_get_SiteName( x, p ) \
        (x)->lpVtbl->get_SiteName( x, p )
    #define IADsADSystemInfo_get_DomainShortName( x, p ) \
        (x)->lpVtbl->get_DomainShortName( x, p )
    #define IADsADSystemInfo_get_DomainDNSName( x, p ) \
        (x)->lpVtbl->get_DomainDNSName( x, p )
    #define IADsADSystemInfo_get_ForestDNSName( x, p ) \
        (x)->lpVtbl->get_ForestDNSName( x, p )
    #define IADsADSystemInfo_get_PDCRoleOwner( x, p ) \
        (x)->lpVtbl->get_PDCRoleOwner( x, p )
    #define IADsADSystemInfo_get_SchemaRoleOwner( x, p ) \
        (x)->lpVtbl->get_SchemaRoleOwner( x, p )
    #define IADsADSystemInfo_get_IsNativeMode( x, p ) \
        (x)->lpVtbl->get_IsNativeMode( x, p )
    #define IADsADSystemInfo_GetAnyDCName( x, p ) \
        (x)->lpVtbl->GetAnyDCName( x, p )
    #define IADsADSystemInfo_GetDCSiteName( x, p1, p2 ) \
        (x)->lpVtbl->GetDCSiteName( x, p1, p2 )
    #define IADsADSystemInfo_RefreshSchemaCache( x ) \
        (x)->lpVtbl->RefreshSchemaCache( x )
    #define IADsADSystemInfo_GetTrees( x, p ) \
        (x)->lpVtbl->GetTrees( x, p )
    #define IADsWinNTSystemInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsWinNTSystemInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsWinNTSystemInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsWinNTSystemInfo_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsWinNTSystemInfo_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsWinNTSystemInfo_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsWinNTSystemInfo_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsWinNTSystemInfo_get_UserName( x, p ) \
        (x)->lpVtbl->get_UserName( x, p )
    #define IADsWinNTSystemInfo_get_ComputerName( x, p ) \
        (x)->lpVtbl->get_ComputerName( x, p )
    #define IADsWinNTSystemInfo_get_DomainName( x, p ) \
        (x)->lpVtbl->get_DomainName( x, p )
    #define IADsWinNTSystemInfo_get_PDC( x, p ) \
        (x)->lpVtbl->get_PDC( x, p )
    #define IADsDNWithBinary_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsDNWithBinary_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsDNWithBinary_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsDNWithBinary_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsDNWithBinary_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsDNWithBinary_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsDNWithBinary_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsDNWithBinary_get_BinaryValue( x, p ) \
        (x)->lpVtbl->get_BinaryValue( x, p )
    #define IADsDNWithBinary_put_BinaryValue( x, p ) \
        (x)->lpVtbl->put_BinaryValue( x, p )
    #define IADsDNWithBinary_get_DNString( x, p ) \
        (x)->lpVtbl->get_DNString( x, p )
    #define IADsDNWithBinary_put_DNString( x, p ) \
        (x)->lpVtbl->put_DNString( x, p )
    #define IADsDNWithString_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsDNWithString_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsDNWithString_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsDNWithString_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsDNWithString_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsDNWithString_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsDNWithString_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsDNWithString_get_StringValue( x, p ) \
        (x)->lpVtbl->get_StringValue( x, p )
    #define IADsDNWithString_put_StringValue( x, p ) \
        (x)->lpVtbl->put_StringValue( x, p )
    #define IADsDNWithString_get_DNString( x, p ) \
        (x)->lpVtbl->get_DNString( x, p )
    #define IADsDNWithString_put_DNString( x, p ) \
        (x)->lpVtbl->put_DNString( x, p )
    #define IADsSecurityUtility_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IADsSecurityUtility_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IADsSecurityUtility_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IADsSecurityUtility_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IADsSecurityUtility_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IADsSecurityUtility_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IADsSecurityUtility_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IADsSecurityUtility_GetSecurityDescriptor( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetSecurityDescriptor( x, p1, p2, p3, p4 )
    #define IADsSecurityUtility_SetSecurityDescriptor( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetSecurityDescriptor( x, p1, p2, p3, p4 )
    #define IADsSecurityUtility_ConvertSecurityDescriptor( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ConvertSecurityDescriptor( x, p1, p2, p3, p4 )
    #define IADsSecurityUtility_get_SecurityMask( x, p ) \
        (x)->lpVtbl->get_SecurityMask( x, p )
    #define IADsSecurityUtility_put_SecurityMask( x, p ) \
        (x)->lpVtbl->put_SecurityMask( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __iads_h__ */
