/*
 *  wingdi.h    Win32 Graphical Device Interface (GDI) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINGDI_
#define _WINGDI_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify GDI and spooler functions */
#define WINGDIAPI   DECLSPEC_IMPORT
#define WINSPOOLAPI DECLSPEC_IMPORT

/* Primitive data types used with color spaces */
#if (WINVER >= 0x0400)
typedef LONG    LCSCSTYPE;
typedef LONG    LCSGAMUTMATCH;
typedef long    FXPT16DOT16;
typedef long    *LPFXPT16DOT16;
typedef long    FXPT2DOT30;
typedef long    *LPFXPT2DOT30;
#endif

/* Neutral unsigned character */
#ifdef UNICODE
typedef WCHAR   BCHAR;
#else
typedef BYTE    BCHAR;
#endif

/* Color data type used with functions in MSIMG32.DLL */
#if (WINVER >= 0x0400)
typedef USHORT  COLOR16;
#endif

/* Macro to make quaternary raster operations */
#define MAKEROP4( p1, p2 )  (DWORD)((((p2) << 8) & 0xFF000000L) | (p1))

/* Macro to make an instance of the POINTS structure for a numeric value */
#define MAKEPOINTS( x ) (*((POINTS *)&(x)))

/* Macros to manipulate CMYK color values */
#if (WINVER >= 0x0400)
    #define GetKValue( x )          ((BYTE)((x)))
    #define GetYValue( x )          ((BYTE)((x) >> 8))
    #define GetMValue( x )          ((BYTE)((x) >> 16))
    #define GetCValue( x )          ((BYTE)((x) >> 24))
    #define CMYK( p1, p2, p3, p4 ) \
        ((COLORREF)((((BYTE)(p4) | ((WORD)((BYTE)(p3)) << 8)) | \
        (((DWORD)(BYTE)(p2)) << 16)) | (((DWORD)(BYTE)(p1)) << 24)))
#endif

/* Macros to manipulate RGB color values */
#define GetRValue( x )              LOBYTE( x )
#define GetGValue( x )              LOBYTE( ((WORD)(x)) >> 8 )
#define GetBValue( x )              LOBYTE( (x) >> 16 )
#define RGB( p1, p2, p3 ) \
    ((COLORREF)(((BYTE)(p1) | ((WORD)((BYTE)(p2)) << 8)) | \
    (((DWORD)(BYTE)(p3)) << 16)))
#define PALETTERGB( p1, p2, p3 )    (0x02000000L | RGB( p1, p2, p3 ))
#define PALETTEINDEX( x )           ((COLORREF)(0x01000000L | (DWORD)(WORD)(x)))

/* Binary raster operations */
#define R2_BLACK        1
#define R2_NOTMERGEPEN  2
#define R2_MASKNOTPEN   3
#define R2_NOTCOPYPEN   4
#define R2_MASKPENNOT   5
#define R2_NOT          6
#define R2_XORPEN       7
#define R2_NOTMASKPEN   8
#define R2_MASKPEN      9
#define R2_NOTXORPEN    10
#define R2_NOP          11
#define R2_MERGENOTPEN  12
#define R2_COPYPEN      13
#define R2_MERGEPENNOT  14
#define R2_MERGEPEN     15
#define R2_WHITE        16
#define R2_LAST         16

/* Ternary raster operations */
#define SRCCOPY         0x00CC0020L
#define SRCPAINT        0x00EE0086L
#define SRCAND          0x008800C6L
#define SRCINVERT       0x00660046L
#define SRCERASE        0x00440328L
#define NOTSRCCOPY      0x00330008L
#define NOTSRCERASE     0x001100A6L
#define MERGECOPY       0x00C000CAL
#define MERGEPAINT      0x00BB0226L
#define PATCOPY         0x00F00021L
#define PATPAINT        0x00FB0A09L
#define PATINVERT       0x005A0049L
#define DSTINVERT       0x00550009L
#define BLACKNESS       0x00000042L
#define WHITENESS       0x00FF0062L
#define NOMIRRORBITMAP  0x80000000L
#define CAPTUREBLT      0x40000000L

/* GDI error return values */
#define GDI_ERROR   0xFFFFFFFFL
#define HGDI_ERROR  ((HANDLE)0xFFFFFFFFL)

/* Return values for region functions */
#define ERROR           0
#define NULLREGION      1
#define SIMPLEREGION    2
#define COMPLEXREGION   3
#define RGN_ERROR       ERROR

/* CombineRgn() operations */
#define RGN_AND     1
#define RGN_OR      2
#define RGN_XOR     3
#define RGN_DIFF    4
#define RGN_COPY    5
#define RGN_MIN     RGN_AND
#define RGN_MAX     RGN_COPY

/* StretchBlt() modes */
#define BLACKONWHITE        1
#define WHITEONBLACK        2
#define COLORONCOLOR        3
#define HALFTONE            4
#define MAXSTRETCHBLTMODE   4

/* New names for StretchBlt() modes */
#if (WINVER >= 0x0400)
    #define STRETCH_ANDSCANS    BLACKONWHITE
    #define STRETCH_ORSCANS     WHITEONBLACK
    #define STRETCH_DELETESCANS COLORONCOLOR
    #define STRETCH_HALFTONE    HALFTONE
#endif

/* Polygon fill modes */
#define ALTERNATE       1
#define WINDING         2
#define POLYFILL_LAST   2

/* Layout flags */
#if (WINVER >= 0x0500)
    #define LAYOUT_RTL                          0x00000001L
    #define LAYOUT_BTT                          0x00000002L
    #define LAYOUT_VBH                          0x00000004L
    #define LAYOUT_ORIENTATIONMASK              (LAYOUT_RTL | LAYOUT_BTT | LAYOUT_VBH)
    #define LAYOUT_BITMAPORIENTATIONPRESERVED   0x00000008L
#endif

/* Text alignment flags */
#define TA_NOUPDATECP   0
#define TA_UPDATECP     1
#define TA_LEFT         0
#define TA_RIGHT        2
#define TA_CENTER       6
#define TA_TOP          0
#define TA_BOTTOM       8
#define TA_BASELINE     24
#if (WINVER >= 0x0400)
    #define TA_RTLREADING   256
    #define TA_MASK         (TA_BASELINE + TA_CENTER + TA_UPDATECP + TA_RTLREADING)
#else
    #define TA_MASK         (TA_BASELINE + TA_CENTER + TA_UPDATECP)
#endif

/* Vertical text alignment flags */
#define VTA_BASELINE    TA_BASELINE
#define VTA_LEFT        TA_BOTTOM
#define VTA_RIGHT       TA_TOP
#define VTA_CENTER      TA_CENTER
#define VTA_BOTTOM      TA_RIGHT
#define VTA_TOP         TA_LEFT

/* ExtTextOut() flags */
#define ETO_OPAQUE                  0x00000002
#define ETO_CLIPPED                 0x00000004
#if (WINVER >= 0x0400)
    #define ETO_GLYPH_INDEX         0x00000010
    #define ETO_RTLREADING          0x00000080
    #define ETO_NUMERICSLOCAL       0x00000400
    #define ETO_NUMERICSLATIN       0x00000800
    #define ETO_IGNORELANGUAGE      0x00001000
#endif
#if (_WIN32_WINNT >= 0x0500)
    #define ETO_PDY                 0x00002000
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define ETO_REVERSE_INDEX_MAP   0x00010000
#endif

/* GetBoundsRect()/SetBoundsRect() flags */
#define DCB_RESET       0x0001
#define DCB_ACCUMULATE  0x0002
#define DCB_DIRTY       DCB_ACCUMULATE
#define DCB_SET         (DCB_RESET | DCB_ACCUMULATE)
#define DCB_ENABLE      0x0004
#define DCB_DISABLE     0x0008

/* Metafile commands */
#define META_SETBKCOLOR             0x0201
#define META_SETBKMODE              0x0102
#define META_SETMAPMODE             0x0103
#define META_SETROP2                0x0104
#define META_SETRELABS              0x0105
#define META_SETPOLYFILLMODE        0x0106
#define META_SETSTRETCHBLTMODE      0x0107
#define META_SETTEXTCHAREXTRA       0x0108
#define META_SETTEXTCOLOR           0x0209
#define META_SETTEXTJUSTIFICATION   0x020A
#define META_SETWINDOWORG           0x020B
#define META_SETWINDOWEXT           0x020C
#define META_SETVIEWPORTORG         0x020D
#define META_SETVIEWPORTEXT         0x020E
#define META_OFFSETWINDOWORG        0x020F
#define META_SCALEWINDOWEXT         0x0410
#define META_OFFSETVIEWPORTORG      0x0211
#define META_SCALEVIEWPORTEXT       0x0412
#define META_LINETO                 0x0213
#define META_MOVETO                 0x0214
#define META_EXCLUDECLIPRECT        0x0415
#define META_INTERSECTCLIPRECT      0x0416
#define META_ARC                    0x0817
#define META_ELLIPSE                0x0418
#define META_FLOODFILL              0x0419
#define META_PIE                    0x081A
#define META_RECTANGLE              0x041B
#define META_ROUNDRECT              0x061C
#define META_PATBLT                 0x061D
#define META_SAVEDC                 0x001E
#define META_SETPIXEL               0x041F
#define META_OFFSETCLIPRGN          0x0220
#define META_TEXTOUT                0x0521
#define META_BITBLT                 0x0922
#define META_STRETCHBLT             0x0B23
#define META_POLYGON                0x0324
#define META_POLYLINE               0x0325
#define META_ESCAPE                 0x0626
#define META_RESTOREDC              0x0127
#define META_FILLREGION             0x0228
#define META_FRAMEREGION            0x0429
#define META_INVERTREGION           0x012A
#define META_PAINTREGION            0x012B
#define META_SELECTCLIPREGION       0x012C
#define META_SELECTOBJECT           0x012D
#define META_SETTEXTALIGN           0x012E
#define META_CHORD                  0x0830
#define META_SETMAPPERFLAGS         0x0231
#define META_EXTTEXTOUT             0x0A32
#define META_SETDIBTODEV            0x0D33
#define META_SELECTPALETTE          0x0234
#define META_REALIZEPALETTE         0x0035
#define META_ANIMATEPALETTE         0x0436
#define META_SETPALENTRIES          0x0037
#define META_POLYPOLYGON            0x0538
#define META_RESIZEPALETTE          0x0139
#define META_DIBBITBLT              0x0940
#define META_DIBSTRETCHBLT          0x0B41
#define META_DIBCREATEPATTERNBRUSH  0x0142
#define META_STRETCHDIB             0x0F43
#define META_EXTFLOODFILL           0x0548
#if (WINVER >= 0x0500)
    #define META_SETLAYOUT          0x0149
#endif
#define META_DELETEOBJECT           0x01F0
#define META_CREATEPALETTE          0x00F7
#define META_CREATEPATTERNBRUSH     0x01F9
#define META_CREATEPENINDIRECT      0x02FA
#define META_CREATEFONTINDIRECT     0x02FB
#define META_CREATEBRUSHINDIRECT    0x02FC
#define META_CREATEREGION           0x06FF

/* GDI escape codes */
#define NEWFRAME                1
#define ABORTDOC                2
#define NEXTBAND                3
#define SETCOLORTABLE           4
#define GETCOLORTABLE           5
#define FLUSHOUTPUT             6
#define DRAFTMODE               7
#define QUERYESCSUPPORT         8
#define SETABORTPROC            9
#define STARTDOC                10
#define ENDDOC                  11
#define GETPHYSPAGESIZE         12
#define GETPRINTINGOFFSET       13
#define GETSCALINGFACTOR        14
#define MFCOMMENT               15
#define GETPENWIDTH             16
#define SETCOPYCOUNT            17
#define SELECTPAPERSOURCE       18
#define DEVICEDATA              19
#define PASSTHROUGH             19
#define GETTECHNOLGY            20
#define GETTECHNOLOGY           20
#define SETLINECAP              21
#define SETLINEJOIN             22
#define SETMITERLIMIT           23
#define BANDINFO                24
#define DRAWPATTERNRECT         25
#define GETVECTORPENSIZE        26
#define GETVECTORBRUSHSIZE      27
#define ENABLEDUPLEX            28
#define GETSETPAPERBINS         29
#define GETSETPRINTORIENT       30
#define ENUMPAPERBINS           31
#define SETDIBSCALING           32
#define EPSPRINTING             33
#define ENUMPAPERMETRICS        34
#define GETSETPAPERMETRICS      35
#define POSTSCRIPT_DATA         37
#define POSTSCRIPT_IGNORE       38
#define MOUSETRAILS             39
#define GETDEVICEUNITS          42
#define GETEXTENDEDTEXTMETRICS  256
#define GETEXTENTTABLE          257
#define GETPAIRKERNTABLE        258
#define GETTRACKKERNTABLE       259
#define EXTTEXTOUT              512
#define GETFACENAME             513
#define DOWNLOADFACE            514
#define ENABLERELATIVEWIDTHS    768
#define ENABLEPAIRKERNING       769
#define SETKERNTRACK            770
#define SETALLJUSTVALUES        771
#define SETCHARSET              772
#define STRETCHBLT              2048
#define METAFILE_DRIVER         2049
#define GETSETSCREENPARAMS      3072
#define QUERYDIBSUPPORT         3073
#define BEGIN_PATH              4096
#define CLIP_TO_PATH            4097
#define END_PATH                4098
#define EXT_DEVICE_CAPS         4099
#define RESTORE_CTM             4100
#define SAVE_CTM                4101
#define SET_ARC_DIRECTION       4102
#define SET_BACKGROUND_COLOR    4103
#define SET_POLY_MODE           4104
#define SET_SCREEN_ANGLE        4105
#define SET_SPREAD              4106
#define TRANSFORM_CTM           4107
#define SET_CLIP_BOX            4108
#define SET_BOUNDS              4109
#define SET_MIRROR_MODE         4110
#define OPENCHANNEL             4110
#define DOWNLOADHEADER          4111
#define CLOSECHANNEL            4112
#define POSTSCRIPT_PASSTHROUGH  4115
#define ENCAPSULATED_POSTSCRIPT 4116
#define POSTSCRIPT_IDENTIFY     4117
#define POSTSCRIPT_INJECTION    4118
#define CHECKJPEGFORMAT         4119
#define CHECKPNGFORMAT          4120
#define GET_PS_FEATURESETTING   4121
#define GDIPLUS_TS_QUERYVER     4122
#define GDIPLUS_TS_RECORD       4123
#define SPCLPASSTHROUGH2        4568

/* Values used with the POSTSCRIPT_IDENTIFY escape */
#define PSIDENT_GDICENTRIC  0
#define PSIDENT_PSCENTRIC   1

/* Injection points */
#define PSINJECT_BEGINSTREAM                1
#define PSINJECT_PSADOBE                    2
#define PSINJECT_PAGESATEND                 3
#define PSINJECT_PAGES                      4
#define PSINJECT_DOCNEEDEDRES               5
#define PSINJECT_DOCSUPPLIEDRES             6
#define PSINJECT_PAGEORDER                  7
#define PSINJECT_ORIENTATION                8
#define PSINJECT_BOUNDINGBOX                9
#define PSINJECT_DOCUMENTPROCESSCOLORS      10
#define PSINJECT_COMMENTS                   11
#define PSINJECT_BEGINDEFAULTS              12
#define PSINJECT_ENDDEFAULTS                13
#define PSINJECT_BEGINPROLOG                14
#define PSINJECT_ENDPROLOG                  15
#define PSINJECT_BEGINSETUP                 16
#define PSINJECT_ENDSETUP                   17
#define PSINJECT_TRAILER                    18
#define PSINJECT_EOF                        19
#define PSINJECT_ENDSTREAM                  20
#define PSINJECT_DOCUMENTPROCESSCOLORSATEND 21
#define PSINJECT_PAGENUMBER                 100
#define PSINJECT_BEGINPAGESETUP             101
#define PSINJECT_ENDPAGESETUP               102
#define PSINJECT_PAGETRAILER                103
#define PSINJECT_PLATECOLOR                 104
#define PSINJECT_SHOWPAGE                   105
#define PSINJECT_PAGEBBOX                   106
#define PSINJECT_ENDPAGECOMMENTS            107
#define PSINJECT_VMSAVE                     200
#define PSINJECT_VMRESTORE                  201

/* Values used with the GET_PS_FEATURESETTING escape */
#define FEATURESETTING_NUP                  0
#define FEATURESETTING_OUTPUT               1
#define FEATURESETTING_PSLEVEL              2
#define FEATURESETTING_CUSTPAPER            3
#define FEATURESETTING_MIRROR               4
#define FEATURESETTING_NEGATIVE             5
#define FEATURESETTING_PROTOCOL             6
#if (_WIN32_WINNT >= 0x0500)
    #define FEATURESETTING_PRIVATE_BEGIN    0x1000
    #define FEATURESETTING_PRIVATE_END      0x1FFF
#endif

/* Return values of the FEATURESETTING_PROTOCOL escape */
#define PSPROTOCOL_ASCII    0
#define PSPROTOCOL_BCP      1
#define PSPROTOCOL_TBCP     2
#define PSPROTOCOL_BINARY   3

/* Flags returned by the QUERYDIBSUPPORT escape */
#define QDI_SETDIBITS   1
#define QDI_GETDIBITS   2
#define QDI_DIBTOSCREEN 4
#define QDI_STRETCHDIB  8

/* GDIPLUS_TS_QUERYVER return values */
#if (_WIN32_WINNT >= 0x0600)
    #define MILCORE_TS_QUERYVER_RESULT_FALSE    0x00000000
    #define MILCORE_TS_QUERYVER_RESULT_TRUE     0x7FFFFFFF
#endif

/* Spooler error codes */
#define SP_NOTREPORTED  0x4000
#define SP_ERROR        (-1)
#define SP_APPABORT     (-2)
#define SP_USERABORT    (-3)
#define SP_OUTOFDISK    (-4)
#define SP_OUTOFMEMORY  (-5)

/* Value used with the WM_SPOOLERSTATUS message */
#define PR_JOBSTATUS    0x0000

/* GDI object types */
#define OBJ_PEN         1
#define OBJ_BRUSH       2
#define OBJ_DC          3
#define OBJ_METADC      4
#define OBJ_PAL         5
#define OBJ_FONT        6
#define OBJ_BITMAP      7
#define OBJ_REGION      8
#define OBJ_METAFILE    9
#define OBJ_MEMDC       10
#define OBJ_EXTPEN      11
#define OBJ_ENHMETADC   12
#define OBJ_ENHMETAFILE 13
#define OBJ_COLORSPACE  14
#define GDI_OBJ_LAST    OBJ_COLORSPACE

/* ModifyWorldTransform() options */
#define MWT_IDENTITY        1
#define MWT_LEFTMULTIPLY    2
#define MWT_RIGHTMULTIPLY   3
#define MWT_MIN             MWT_IDENTITY
#define MWT_MAX             MWT_RIGHTMULTIPLY

/* ColorMatchToTarget() actions */
#if (WINVER >= 0x0400)
    #define CS_ENABLE           0x00000001L
    #define CS_DISABLE          0x00000002L
    #define CS_DELETE_TRANSFORM 0x00000003L
#endif

/* Logical color space signature */
#if (WINVER >= 0x0400)
    #define LCS_SIGNATURE   'PSOC'
#endif

/* Color space types */
#if (WINVER >= 0x0400)
    #define LCS_sRGB                'sRGB'
    #define LCS_WINDOWS_COLOR_SPACE 'Win '
#endif

/* Color space type flags */
#if (WINVER >= 0x0400)
    #define LCS_CALIBRATED_RGB  0x00000000L
#endif

/* Color space gamut matching flags */
#if (WINVER >= 0x0400)
    #define LCS_GM_BUSINESS         0x00000001L
    #define LCS_GM_GRAPHICS         0x00000002L
    #define LCS_GM_IMAGES           0x00000004L
    #define LCS_GM_ABS_COLORIMETRIC 0x00000008L
#endif

/* CheckColorsInGamut() results */
#if (WINVER >= 0x0400)
    #define CM_OUT_OF_GAMUT 255
    #define CM_IN_GAMUT     0
#endif

/* UpdateICMRegKey() operations */
#if (WINVER >= 0x0400)
    #define ICM_ADDPROFILE          1
    #define ICM_DELETEPROFILE       2
    #define ICM_QUERYPROFILE        3
    #define ICM_SETDEFAULTPROFILE   4
    #define ICM_REGISTERICMATCHER   5
    #define ICM_UNREGISTERICMATCHER 6
    #define ICM_QUERYMATCH          7
#endif

/* Bitmap color space types */
#if (WINVER >= 0x0400)
    #define PROFILE_LINKED      'LINK'
    #define PROFILE_EMBEDDED    'MBED'
#endif

/* Bitmap compression types */
#define BI_RGB          0L
#define BI_RLE8         1L
#define BI_RLE4         2L
#define BI_BITFIELDS    3L
#define BI_JPEG         4L
#define BI_PNG          5L

/* TranslateCharsetInfo() flags */
#if (WINVER >= 0x0400)
    #define TCI_SRCCHARSET      0x0001L
    #define TCI_SRCCODEPAGE     0x0002L
    #define TCI_SRCFONTSIG      0x0003L
    #if (_WIN32_WINNT >= 0x0500)
        #define TCI_SRCLOCALE   0x1000L
    #endif
#endif

/* Pitch and family flags */
#define TMPF_FIXED_PITCH    0x01
#define TMPF_VECTOR         0x02
#define TMPF_TRUETYPE       0x04
#define TMPF_DEVICE         0x08

/* New text metric flags */
#define NTM_ITALIC          0x00000001L
#define NTM_BOLD            0x00000020L
#define NTM_REGULAR         0x00000040L
#define NTM_NONNEGATIVE_AC  0x00010000L
#define NTM_PS_OPENTYPE     0x00020000L
#define NTM_TT_OPENTYPE     0x00040000L
#define NTM_MULTIPLEMASTER  0x00080000L
#define NTM_TYPE1           0x00100000L
#define NTM_DSIG            0x00200000L

/* Maximum length of a font name */
#define LF_FACESIZE     32
#define LF_FULLFACESIZE 64

/* Output precision values */
#define OUT_DEFAULT_PRECIS          0
#define OUT_STRING_PRECIS           1
#define OUT_CHARACTER_PRECIS        2
#define OUT_STROKE_PRECIS           3
#define OUT_TT_PRECIS               4
#define OUT_DEVICE_PRECIS           5
#define OUT_RASTER_PRECIS           6
#define OUT_TT_ONLY_PRECIS          7
#define OUT_OUTLINE_PRECIS          8
#define OUT_SCREEN_OUTLINE_PRECIS   9
#define OUT_PS_ONLY_PRECIS          10

/* Clip precision values */
#define CLIP_DEFAULT_PRECIS     0x00
#define CLIP_CHARACTER_PRECIS   0x01
#define CLIP_STROKE_PRECIS      0x02
#define CLIP_MASK               0x0F
#define CLIP_LH_ANGLES          0x10
#define CLIP_TT_ALWAYS          0x20
#if (_WIN32_WINNT >= 0x0600)
    #define CLIP_DFA_DISABLE    0x40
#endif
#define CLIP_EMBEDDED           0x80

/* Quality values */
#define DEFAULT_QUALITY             0
#define DRAFT_QUALITY               1
#define PROOF_QUALITY               2
#if (WINVER >= 0x0400)
    #define NONANTIALIASED_QUALITY      3
    #define ANTIALIASED_QUALITY         4
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define CLEARTYPE_QUALITY           5
    #define CLEARTYPE_NATURAL_QUALITY   6
#endif

/* Pitch values */
#define DEFAULT_PITCH   0x00
#define FIXED_PITCH     0x01
#define VARIABLE_PITCH  0x02
#if (WINVER >= 0x0400)
    #define MONO_FONT   0x08
#endif

/* Character sets */
#define ANSI_CHARSET            0
#define DEFAULT_CHARSET         1
#define SYMBOL_CHARSET          2
#define SHIFTJIS_CHARSET        128
#define HANGEUL_CHARSET         129
#define HANGUL_CHARSET          129
#define GB2312_CHARSET          134
#define CHINESEBIG5_CHARSET     136
#define OEM_CHARSET             255
#if (WINVER >= 0x0400)
    #define JOHAB_CHARSET       130
    #define HEBREW_CHARSET      177
    #define ARABIC_CHARSET      178
    #define GREEK_CHARSET       161
    #define TURKISH_CHARSET     162
    #define VIETNAMESE_CHARSET  163
    #define THAI_CHARSET        222
    #define EASTEUROPE_CHARSET  238
    #define RUSSIAN_CHARSET     204
    #define MAC_CHARSET         77
    #define BALTIC_CHARSET      186
#endif

/* Font families */
#define FF_DONTCARE     0x00
#define FF_ROMAN        0x10
#define FF_SWISS        0x20
#define FF_MODERN       0x30
#define FF_SCRIPT       0x40
#define FF_DECORATIVE   0x50

/* Font weights */
#define FW_DONTCARE     0
#define FW_THIN         100
#define FW_EXTRALIGHT   200
#define FW_LIGHT        300
#define FW_NORMAL       400
#define FW_MEDIUM       500
#define FW_SEMIBOLD     600
#define FW_BOLD         700
#define FW_EXTRABOLD    800
#define FW_HEAVY        900
#define FW_ULTRALIGHT   FW_EXTRALIGHT
#define FW_REGULAR      FW_NORMAL
#define FW_DEMIBOLD     FW_SEMIBOLD
#define FW_ULTRABOLD    FW_EXTRABOLD
#define FW_BLACK        FW_HEAVY

/* Values for any field in the PANOSE structure */
#define PAN_ANY     0
#define PAN_NO_FIT  1

/* PANOSE family types */
#define PAN_FAMILY_TEXT_DISPLAY 2
#define PAN_FAMILY_SCRIPT       3
#define PAN_FAMILY_DECORATIVE   4
#define PAN_FAMILY_PICTORIAL    5

/* PANOSE serif styles */
#define PAN_SERIF_COVE                  2
#define PAN_SERIF_OBTUSE_COVE           3
#define PAN_SERIF_SQUARE_COVE           4
#define PAN_SERIF_OBTUSE_SQUARE_COVE    5
#define PAN_SERIF_SQUARE                6
#define PAN_SERIF_THIN                  7
#define PAN_SERIF_BONE                  8
#define PAN_SERIF_EXAGGERATED           9
#define PAN_SERIF_TRIANGLE              10
#define PAN_SERIF_NORMAL_SANS           11
#define PAN_SERIF_OBTUSE_SANS           12
#define PAN_SERIF_PERP_SANS             13
#define PAN_SERIF_FLARED                14
#define PAN_SERIF_ROUNDED               15

/* PANOSE weights */
#define PAN_WEIGHT_VERY_LIGHT   2
#define PAN_WEIGHT_LIGHT        3
#define PAN_WEIGHT_THIN         4
#define PAN_WEIGHT_BOOK         5
#define PAN_WEIGHT_MEDIUM       6
#define PAN_WEIGHT_DEMI         7
#define PAN_WEIGHT_BOLD         8
#define PAN_WEIGHT_HEAVY        9
#define PAN_WEIGHT_BLACK        10
#define PAN_WEIGHT_NORD         11

/* PANOSE proportions */
#define PAN_PROP_OLD_STYLE      2
#define PAN_PROP_MODERN         3
#define PAN_PROP_EVEN_WIDTH     4
#define PAN_PROP_EXPANDED       5
#define PAN_PROP_CONDENSED      6
#define PAN_PROP_VERY_EXPANDED  7
#define PAN_PROP_VERY_CONDENSED 8
#define PAN_PROP_MONOSPACED     9

/* PANOSE contrasts */
#define PAN_CONTRAST_NONE           2
#define PAN_CONTRAST_VERY_LOW       3
#define PAN_CONTRAST_LOW            4
#define PAN_CONTRAST_MEDIUM_LOW     5
#define PAN_CONTRAST_MEDIUM         6
#define PAN_CONTRAST_MEDIUM_HIGH    7
#define PAN_CONTRAST_HIGH           8
#define PAN_CONTRAST_VERY_HIGH      9

/* PANOSE stroke variations */
#define PAN_STROKE_GRADUAL_DIAG 2
#define PAN_STROKE_GRADUAL_TRAN 3
#define PAN_STROKE_GRADUAL_VERT 4
#define PAN_STROKE_GRADUAL_HORZ 5
#define PAN_STROKE_RAPID_VERT   6
#define PAN_STROKE_RAPID_HORZ   7
#define PAN_STROKE_INSTANT_VERT 8

/* PANOSE arm styles */
#define PAN_STRAIGHT_ARMS_HORZ          2
#define PAN_STRAIGHT_ARMS_WEDGE         3
#define PAN_STRAIGHT_ARMS_VERT          4
#define PAN_STRAIGHT_ARMS_SINGLE_SERIF  5
#define PAN_STRAIGHT_ARMS_DOUBLE_SERIF  6
#define PAN_BENT_ARMS_HORZ              7
#define PAN_BENT_ARMS_WEDGE             8
#define PAN_BENT_ARMS_VERT              9
#define PAN_BENT_ARMS_SINGLE_SERIF      10
#define PAN_BENT_ARMS_DOUBLE_SERIF      11

/* PANOSE letterforms */
#define PAN_LETT_NORMAL_CONTACT     2
#define PAN_LETT_NORMAL_WEIGHTED    3
#define PAN_LETT_NORMAL_BOXED       4
#define PAN_LETT_NORMAL_FLATTENED   5
#define PAN_LETT_NORMAL_ROUNDED     6
#define PAN_LETT_NORMAL_OFF_CENTER  7
#define PAN_LETT_NORMAL_SQUARE      8
#define PAN_LETT_OBLIQUE_CONTACT    9
#define PAN_LETT_OBLIQUE_WEIGHTED   10
#define PAN_LETT_OBLIQUE_BOXED      11
#define PAN_LETT_OBLIQUE_FLATTENED  12
#define PAN_LETT_OBLIQUE_ROUNDED    13
#define PAN_LETT_OBLIQUE_OFF_CENTER 14
#define PAN_LETT_OBLIQUE_SQUARE     15

/* PANOSE midline styles */
#define PAN_MIDLINE_STANDARD_TRIMMED    2
#define PAN_MIDLINE_STANDARD_POINTED    3
#define PAN_MIDLINE_STANDARD_SERIFED    4
#define PAN_MIDLINE_HIGH_TRIMMED        5
#define PAN_MIDLINE_HIGH_POINTED        6
#define PAN_MIDLINE_HIGH_SERIFED        7
#define PAN_MIDLINE_CONSTANT_TRIMMED    8
#define PAN_MIDLINE_CONSTANT_POINTED    9
#define PAN_MIDLINE_CONSTANT_SERIFED    10
#define PAN_MIDLINE_LOW_TRIMMED         11
#define PAN_MIDLINE_LOW_POINTED         12
#define PAN_MIDLINE_LOW_SERIFED         13

/* PANOSE x-height values */
#define PAN_XHEIGHT_CONSTANT_SMALL  2
#define PAN_XHEIGHT_CONSTANT_STD    3
#define PAN_XHEIGHT_CONSTANT_LARGE  4
#define PAN_XHEIGHT_DUCKING_SMALL   5
#define PAN_XHEIGHT_DUCKING_STD     6
#define PAN_XHEIGHT_DUCKING_LARGE   7

/* Length of a font vendor in EXTLOGFONT */
#define ELF_VENDOR_SIZE 4

/* EXTLOGFONT version value */
#define ELF_VERSION 0

/* EXTLOGFONT culture value */
#define ELF_CULTURE_LATIN   0

/* Font types */
#define RASTER_FONTTYPE     0x0001
#define DEVICE_FONTTYPE     0x0002
#define TRUETYPE_FONTTYPE   0x0004

/* Palette entry flags */
#define PC_RESERVED     0x01
#define PC_EXPLICIT     0x02
#define PC_NOCOLLAPSE   0x04

/* Background modes */
#define TRANSPARENT 1
#define OPAQUE      2
#define BKMODE_LAST 2

/* Graphics modes */
#define GM_COMPATIBLE   1
#define GM_ADVANCED     2
#define GM_LAST         2

/* GetPath() and PolyDraw() point types */
#define PT_CLOSEFIGURE  0x01
#define PT_LINETO       0x02
#define PT_BEZIERTO     0x04
#define PT_MOVETO       0x06

/* Mapping modes */
#define MM_TEXT             1
#define MM_LOMETRIC         2
#define MM_HIMETRIC         3
#define MM_LOENGLISH        4
#define MM_HIENGLISH        5
#define MM_TWIPS            6
#define MM_ISOTROPIC        7
#define MM_ANISOTROPIC      8
#define MM_MIN              MM_TEXT
#define MM_MAX              MM_ANISOTROPIC
#define MM_MAX_FIXEDSCALE   MM_TWIPS

/* Stock object indices */
#define WHITE_BRUSH             0
#define LTGRAY_BRUSH            1
#define GRAY_BRUSH              2
#define DKGRAY_BRUSH            3
#define BLACK_BRUSH             4
#define NULL_BRUSH              5
#define HOLLOW_BRUSH            NULL_BRUSH
#define WHITE_PEN               6
#define BLACK_PEN               7
#define NULL_PEN                8
#define OEM_FIXED_FONT          10
#define ANSI_FIXED_FONT         11
#define ANSI_VAR_FONT           12
#define SYSTEM_FONT             13
#define DEVICE_DEFAULT_FONT     14
#define DEFAULT_PALETTE         15
#define SYSTEM_FIXED_FONT       16
#if (WINVER >= 0x0400)
    #define DEFAULT_GUI_FONT    17
#endif
#if (_WIN32_WINNT >= 0x0500)
    #define DC_BRUSH            18
    #define DC_PEN              19
    #define STOCK_LAST          19
#elif (WINVER >= 0x0400)
    #define STOCK_LAST          17
#else
    #define STOCK_LAST          16
#endif

/* Invalid color value */
#define CLR_INVALID 0xFFFFFFFFL

/* Brush styles */
#define BS_SOLID            0L
#define BS_NULL             1L
#define BS_HOLLOW           BS_NULL
#define BS_HATCHED          2L
#define BS_PATTERN          3L
#define BS_INDEXED          4L
#define BS_DIBPATTERN       5L
#define BS_DIBPATTERNPT     6L
#define BS_PATTERN8X8       7L
#define BS_DIBPATTERN8X8    8L
#define BS_MONOPATTERN      9L

/* Hatch styles */
#define HS_HORIZONTAL   0L
#define HS_VERTICAL     1L
#define HS_FDIAGONAL    2L
#define HS_BDIAGONAL    3L
#define HS_CROSS        4L
#define HS_DIAGCROSS    5L
#define HS_API_MAX      12L

/* Pen styles */
#define PS_SOLID            0x00000000L
#define PS_DASH             0x00000001L
#define PS_DOT              0x00000002L
#define PS_DASHDOT          0x00000003L
#define PS_DASHDOTDOT       0x00000004L
#define PS_NULL             0x00000005L
#define PS_INSIDEFRAME      0x00000006L
#define PS_USERSTYLE        0x00000007L
#define PS_ALTERNATE        0x00000008L
#define PS_STYLE_MASK       0x0000000FL
#define PS_ENDCAP_ROUND     0x00000000L
#define PS_ENDCAP_SQUARE    0x00000100L
#define PS_ENDCAP_FLAT      0x00000200L
#define PS_ENDCAP_MASK      0x00000F00L
#define PS_JOIN_ROUND       0x00000000L
#define PS_JOIN_BEVEL       0x00001000L
#define PS_JOIN_MITER       0x00002000L
#define PS_JOIN_MASK        0x0000F000L
#define PS_COSMETIC         0x00000000L
#define PS_GEOMETRIC        0x00010000L
#define PS_TYPE_MASK        0x000F0000L

/* Arc directions */
#define AD_COUNTERCLOCKWISE 1
#define AD_CLOCKWISE        2

/* GetDeviceCaps() indices */
#define DRIVERVERSION       0
#define TECHNOLOGY          2
#define HORZSIZE            4
#define VERTSIZE            6
#define HORZRES             8
#define VERTRES             10
#define BITSPIXEL           12
#define PLANES              14
#define NUMBRUSHES          16
#define NUMPENS             18
#define NUMMARKERS          20
#define NUMFONTS            22
#define NUMCOLORS           24
#define PDEVICESIZE         26
#define CURVECAPS           28
#define LINECAPS            30
#define POLYGONALCAPS       32
#define TEXTCAPS            34
#define CLIPCAPS            36
#define RASTERCAPS          38
#define ASPECTX             40
#define ASPECTY             42
#define ASPECTXY            44
#define LOGPIXELSX          88
#define LOGPIXELSY          90
#define SIZEPALETTE         104
#define NUMRESERVED         106
#define COLORRES            108
#define PHYSICALWIDTH       110
#define PHYSICALHEIGHT      111
#define PHYSICALOFFSETX     112
#define PHYSICALOFFSETY     113
#define SCALINGFACTORX      114
#define SCALINGFACTORY      115
#define VREFRESH            116
#define DESKTOPVERTRES      117
#define DESKTOPHORZRES      118
#define BLTALIGNMENT        119
#if (WINVER >= 0x0500)
    #define SHADEBLENDCAPS  120
    #define COLORMGMTCAPS   121
#endif

/* Device technologies */
#define DT_PLOTTER      0
#define DT_RASDISPLAY   1
#define DT_RASPRINTER   2
#define DT_RASCAMERA    3
#define DT_CHARSTREAM   4
#define DT_METAFILE     5
#define DT_DISPFILE     6

/* Curve capabilities */
#define CC_NONE         0
#define CC_CIRCLES      1
#define CC_PIE          2
#define CC_CHORD        4
#define CC_ELLIPSES     8
#define CC_WIDE         16
#define CC_STYLED       32
#define CC_WIDESTYLED   64
#define CC_INTERIORS    128
#define CC_ROUNDRECT    256

/* Line capabilities */
#define LC_NONE         0
#define LC_POLYLINE     2
#define LC_MARKER       4
#define LC_POLYMARKER   8
#define LC_WIDE         16
#define LC_STYLED       32
#define LC_WIDESTYLED   64
#define LC_INTERIORS    128

/* Polygon capabilities */
#define PC_NONE         0
#define PC_POLYGON      1
#define PC_RECTANGLE    2
#define PC_WINDPOLYGON  4
#define PC_TRAPEZOID    4
#define PC_SCANLINE     8
#define PC_WIDE         16
#define PC_STYLED       32
#define PC_WIDESTYLED   64
#define PC_INTERIORS    128
#define PC_POLYPOLYGON  256
#define PC_PATHS        512

/* Clipping capabilities */
#define CP_NONE         0
#define CP_RECTANGLE    1
#define CP_REGION       2

/* Text capabilities */
#define TC_OP_CHARACTER 0x00000001
#define TC_OP_STROKE    0x00000002
#define TC_CP_STROKE    0x00000004
#define TC_CR_90        0x00000008
#define TC_CR_ANY       0x00000010
#define TC_SF_X_YINDEP  0x00000020
#define TC_SA_DOUBLE    0x00000040
#define TC_SA_INTEGER   0x00000080
#define TC_SA_CONTIN    0x00000100
#define TC_EA_DOUBLE    0x00000200
#define TC_IA_ABLE      0x00000400
#define TC_UA_ABLE      0x00000800
#define TC_SO_ABLE      0x00001000
#define TC_RA_ABLE      0x00002000
#define TC_VA_ABLE      0x00004000
#define TC_RESERVED     0x00008000
#define TC_SCROLLBLT    0x00010000

/* Raster capabilities */
#define RC_BITBLT       0x0001
#define RC_BANDING      0x0002
#define RC_SCALING      0x0004
#define RC_BITMAP64     0x0008
#define RC_GDI20_OUTPUT 0x0010
#define RC_GDI20_STATE  0x0020
#define RC_SAVEBITMAP   0x0040
#define RC_DI_BITMAP    0x0080
#define RC_PALETTE      0x0100
#define RC_DIBTODEV     0x0200
#define RC_BIGFONT      0x0400
#define RC_STRETCHBLT   0x0800
#define RC_FLOODFILL    0x1000
#define RC_STRETCHDIB   0x2000
#define RC_OP_DX_OUTPUT 0x4000
#define RC_DEVBITS      0x8000

/* Shading and blending capabilities */
#if (WINVER >= 0x0500)
    #define SB_NONE             0x00000000
    #define SB_CONST_ALPHA      0x00000001
    #define SB_PIXEL_ALPHA      0x00000002
    #define SB_PREMULT_ALPHA    0x00000004
    #define SB_GRAD_RECT        0x00000010
    #define SB_GRAD_TRI         0x00000020
#endif

/* Color management capabilities */
#if (WINVER >= 0x0500)
    #define CM_NONE         0x00000000
    #define CM_DEVICE_ICM   0x00000001
    #define CM_GAMMA_RAMP   0x00000002
    #define CM_CMYK_COLOR   0x00000004
#endif

/* DIB color table types */
#define DIB_RGB_COLORS  0
#define DIB_PAL_COLORS  1

/* System palette uses */
#define SYSPAL_ERROR        0
#define SYSPAL_STATIC       1
#define SYSPAL_NOSTATIC     2
#define SYSPAL_NOSTATIC256  3

/* CreateDIBitmap() flags */
#define CBM_INIT    0x00000004L

/* ExtFloodFill() flags */
#define FLOODFILLBORDER     0
#define FLOODFILLSURFACE    1

/* Maximum length of a device name */
#define CCHDEVICENAME   32

/* Maximum length of a form name */
#define CCHFORMNAME 32

/* Current device mode specification version */
#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
    #define DM_SPECVERSION  0x0401
#elif (WINVER >= 0x0400)
    #define DM_SPECVERSION  0x0400
#else
    #define DM_SPECVERSION  0x0320
#endif

/* Device mode field flags */
#define DM_ORIENTATION              0x00000001L
#define DM_PAPERSIZE                0x00000002L
#define DM_PAPERLENGTH              0x00000004L
#define DM_PAPERWIDTH               0x00000008L
#define DM_SCALE                    0x00000010L
#if (WINVER >= 0x0500)
    #define DM_POSITION             0x00000020L
    #define DM_NUP                  0x00000040L
#endif
#if (WINVER >= 0x0501)
    #define DM_DISPLAYORIENTATION   0x00000080L
#endif
#define DM_COPIES                   0x00000100L
#define DM_DEFAULTSOURCE            0x00000200L
#define DM_PRINTQUALITY             0x00000400L
#define DM_COLOR                    0x00000800L
#define DM_DUPLEX                   0x00001000L
#define DM_YRESOLUTION              0x00002000L
#define DM_TTOPTION                 0x00004000L
#define DM_COLLATE                  0x00008000L
#define DM_FORMNAME                 0x00010000L
#define DM_LOGPIXELS                0x00020000L
#define DM_BITSPERPEL               0x00040000L
#define DM_PELSWIDTH                0x00080000L
#define DM_PELSHEIGHT               0x00100000L
#define DM_DISPLAYFLAGS             0x00200000L
#define DM_DISPLAYFREQUENCY         0x00400000L
#if (WINVER >= 0x0400)
    #define DM_ICMMETHOD            0x00800000L
    #define DM_ICMINTENT            0x01000000L
    #define DM_MEDIATYPE            0x02000000L
    #define DM_DITHERTYPE           0x04000000L
    #define DM_PANNINGWIDTH         0x08000000L
    #define DM_PANNINGHEIGHT        0x10000000L
#endif
#if (WINVER >= 0x0501)
    #define DM_DISPLAYFIXEDOUTPUT   0x20000000L
#endif

/* Device mode orientations */
#define DMORIENT_PORTRAIT   1
#define DMORIENT_LANDSCAPE  2

/* Device mode paper types */
#define DMPAPER_LETTER                              1
#define DMPAPER_LETTERSMALL                         2
#define DMPAPER_TABLOID                             3
#define DMPAPER_LEDGER                              4
#define DMPAPER_LEGAL                               5
#define DMPAPER_STATEMENT                           6
#define DMPAPER_EXECUTIVE                           7
#define DMPAPER_A3                                  8
#define DMPAPER_A4                                  9
#define DMPAPER_A4SMALL                             10
#define DMPAPER_A5                                  11
#define DMPAPER_B4                                  12
#define DMPAPER_B5                                  13
#define DMPAPER_FOLIO                               14
#define DMPAPER_QUARTO                              15
#define DMPAPER_10X14                               16
#define DMPAPER_11X17                               17
#define DMPAPER_NOTE                                18
#define DMPAPER_ENV_9                               19
#define DMPAPER_ENV_10                              20
#define DMPAPER_ENV_11                              21
#define DMPAPER_ENV_12                              22
#define DMPAPER_ENV_14                              23
#define DMPAPER_CSHEET                              24
#define DMPAPER_DSHEET                              25
#define DMPAPER_ESHEET                              26
#define DMPAPER_ENV_DL                              27
#define DMPAPER_ENV_C5                              28
#define DMPAPER_ENV_C3                              29
#define DMPAPER_ENV_C4                              30
#define DMPAPER_ENV_C6                              31
#define DMPAPER_ENV_C65                             32
#define DMPAPER_ENV_B4                              33
#define DMPAPER_ENV_B5                              34
#define DMPAPER_ENV_B6                              35
#define DMPAPER_ENV_ITALY                           36
#define DMPAPER_ENV_MONARCH                         37
#define DMPAPER_ENV_PERSONAL                        38
#define DMPAPER_FANFOLD_US                          39
#define DMPAPER_FANFOLD_STD_GERMAN                  40
#define DMPAPER_FANFOLD_LGL_GERMAN                  41
#if (WINVER >= 0x0400)
    #define DMPAPER_ISO_B4                          42
    #define DMPAPER_JAPANESE_POSTCARD               43
    #define DMPAPER_9X11                            44
    #define DMPAPER_10X11                           45
    #define DMPAPER_15X11                           46
    #define DMPAPER_ENV_INVITE                      47
    #define DMPAPER_LETTER_EXTRA                    50
    #define DMPAPER_LEGAL_EXTRA                     51
    #define DMPAPER_TABLOID_EXTRA                   52
    #define DMPAPER_A4_EXTRA                        53
    #define DMPAPER_LETTER_TRANSVERSE               54
    #define DMPAPER_A4_TRANSVERSE                   55
    #define DMPAPER_LETTER_EXTRA_TRANSVERSE         56
    #define DMPAPER_A_PLUS                          57
    #define DMPAPER_B_PLUS                          58
    #define DMPAPER_LETTER_PLUS                     59
    #define DMPAPER_A4_PLUS                         60
    #define DMPAPER_A5_TRANSVERSE                   61
    #define DMPAPER_B5_TRANSVERSE                   62
    #define DMPAPER_A3_EXTRA                        63
    #define DMPAPER_A5_EXTRA                        64
    #define DMPAPER_B5_EXTRA                        65
    #define DMPAPER_A2                              66
    #define DMPAPER_A3_TRANSVERSE                   67
    #define DMPAPER_A3_EXTRA_TRANSVERSE             68
#endif
#if (WINVER >= 0x0500)
    #define DMPAPER_DBL_JAPANESE_POSTCARD           69
    #define DMPAPER_A6                              70
    #define DMPAPER_JENV_KAKU2                      71
    #define DMPAPER_JENV_KAKU3                      72
    #define DMPAPER_JENV_CHOU3                      73
    #define DMPAPER_JENV_CHOU4                      74
    #define DMPAPER_LETTER_ROTATED                  75
    #define DMPAPER_A3_ROTATED                      76
    #define DMPAPER_A4_ROTATED                      77
    #define DMPAPER_A5_ROTATED                      78
    #define DMPAPER_B4_JIS_ROTATED                  79
    #define DMPAPER_B5_JIS_ROTATED                  80
    #define DMPAPER_JAPANESE_POSTCARD_ROTATED       81
    #define DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED   82
    #define DMPAPER_A6_ROTATED                      83
    #define DMPAPER_JENV_KAKU2_ROTATED              84
    #define DMPAPER_JENV_KAKU3_ROTATED              85
    #define DMPAPER_JENV_CHOU3_ROTATED              86
    #define DMPAPER_JENV_CHOU4_ROTATED              87
    #define DMPAPER_B6_JIS                          88
    #define DMPAPER_B6_JIS_ROTATED                  89
    #define DMPAPER_12X11                           90
    #define DMPAPER_JENV_YOU4                       91
    #define DMPAPER_JENV_YOU4_ROTATED               92
    #define DMPAPER_P16K                            93
    #define DMPAPER_P32K                            94
    #define DMPAPER_P32KBIG                         95
    #define DMPAPER_PENV_1                          96
    #define DMPAPER_PENV_2                          97
    #define DMPAPER_PENV_3                          98
    #define DMPAPER_PENV_4                          99
    #define DMPAPER_PENV_5                          100
    #define DMPAPER_PENV_6                          101
    #define DMPAPER_PENV_7                          102
    #define DMPAPER_PENV_8                          103
    #define DMPAPER_PENV_9                          104
    #define DMPAPER_PENV_10                         105
    #define DMPAPER_P16K_ROTATED                    106
    #define DMPAPER_P32K_ROTATED                    107
    #define DMPAPER_P32KBIG_ROTATED                 108
    #define DMPAPER_PENV_1_ROTATED                  109
    #define DMPAPER_PENV_2_ROTATED                  110
    #define DMPAPER_PENV_3_ROTATED                  111
    #define DMPAPER_PENV_4_ROTATED                  112
    #define DMPAPER_PENV_5_ROTATED                  113
    #define DMPAPER_PENV_6_ROTATED                  114
    #define DMPAPER_PENV_7_ROTATED                  115
    #define DMPAPER_PENV_8_ROTATED                  116
    #define DMPAPER_PENV_9_ROTATED                  117
    #define DMPAPER_PENV_10_ROTATED                 118
#endif
#define DMPAPER_USER                                256
#define DMPAPER_FIRST                               DMPAPER_LETTER
#if (WINVER >= 0x0500)
    #define DMPAPER_LAST                            DMPAPER_PENV_10_ROTATED
#elif (WINVER >= 0x0400)
    #define DMPAPER_LAST                            DMPAPER_A3_EXTRA_TRANSVERSE
#else
    #define DMPAPER_LAST                            DMPAPER_FANFOLD_LGL_GERMAN
#endif

/* Device mode bins */
#define DMBIN_UPPER         1
#define DMBIN_ONLYONE       1
#define DMBIN_LOWER         2
#define DMBIN_MIDDLE        3
#define DMBIN_MANUAL        4
#define DMBIN_ENVELOPE      5
#define DMBIN_ENVMANUAL     6
#define DMBIN_AUTO          7
#define DMBIN_TRACTOR       8
#define DMBIN_SMALLFMT      9
#define DMBIN_LARGEFMT      10
#define DMBIN_LARGECAPACITY 11
#define DMBIN_CASSETTE      14
#define DMBIN_FORMSOURCE    15
#define DMBIN_USER          256
#define DMBIN_FIRST         DMBIN_UPPER
#define DMBIN_LAST          DMBIN_FORMSOURCE

/* Device mode resolutions */
#define DMRES_DRAFT     (-1)
#define DMRES_LOW       (-2)
#define DMRES_MEDIUM    (-3)
#define DMRES_HIGH      (-4)

/* Device mode color settings */
#define DMCOLOR_MONOCHROME  1
#define DMCOLOR_COLOR       2

/* Device mode duplex settings */
#define DMDUP_SIMPLEX       1
#define DMDUP_VERTICAL      2
#define DMDUP_HORIZONTAL    3

/* Device mode TrueType settings */
#define DMTT_BITMAP                 1
#define DMTT_DOWNLOAD               2
#define DMTT_SUBDEV                 3
#if (WINVER >= 0x0400)
    #define DMTT_DOWNLOAD_OUTLINE   4
#endif

/* Device mode collation settings */
#define DMCOLLATE_FALSE 0
#define DMCOLLATE_TRUE  1

/* Device mode display orientations */
#if (WINVER >= 0x0501)
    #define DMDO_DEFAULT    0
    #define DMDO_90         1
    #define DMDO_180        2
    #define DMDO_270        3
#endif

/* Device mode display fixed output settings */
#if (WINVER >= 0x0501)
    #define DMDFO_DEFAULT   0
    #define DMDFO_STRETCH   1
    #define DMDFO_CENTER    2
#endif

/* Device mode display flags */
#define DM_INTERLACED           0x00000002L
#define DMDISPLAYFLAGS_TEXTMODE 0x00000004L

/* Device mode physical/logical page settings */
#define DMNUP_SYSTEM    1
#define DMNUP_ONEUP     2

/* Device mode ICM methods */
#if (WINVER >= 0x0400)
    #define DMICMMETHOD_NONE    1
    #define DMICMMETHOD_SYSTEM  2
    #define DMICMMETHOD_DRIVER  3
    #define DMICMMETHOD_DEVICE  4
    #define DMICMMETHOD_USER    256
#endif

/* Device mode ICM intents */
#if (WINVER >= 0x0400)
    #define DMICM_SATURATE          1
    #define DMICM_CONTRAST          2
    #define DMICM_COLORIMETRIC      3
    #define DMICM_ABS_COLORIMETRIC  4
    #define DMICM_USER              256
#endif

/* Device mode media types */
#if (WINVER >= 0x0400)
    #define DMMEDIA_STANDARD        1
    #define DMMEDIA_TRANSPARENCY    2
    #define DMMEDIA_GLOSSY          3
    #define DMMEDIA_USER            256
#endif

/* Device mode dithering types */
#if (WINVER >= 0x0400)
    #define DMDITHER_NONE           1
    #define DMDITHER_COARSE         2
    #define DMDITHER_FINE           3
    #define DMDITHER_LINEART        4
    #define DMDITHER_ERRORDIFFUSION 5
    #define DMDITHER_GRAYSCALE      10
    #define DMDITHER_USER           256
#endif

/* Display device flags */
#define DISPLAY_DEVICE_ATTACHED_TO_DESKTOP  0x00000001L
#define DISPLAY_DEVICE_MULTI_DRIVER         0x00000002L
#define DISPLAY_DEVICE_PRIMARY_DEVICE       0x00000004L
#define DISPLAY_DEVICE_MIRRORING_DRIVER     0x00000008L
#define DISPLAY_DEVICE_VGA_COMPATIBLE       0x00000010L
#if (_WIN32_WINNT >= 0x0500)
    #define DISPLAY_DEVICE_REMOVABLE        0x00000020L
#endif
#define DISPLAY_DEVICE_DISCONNECT           0x02000000L
#if (_WIN32_WINNT >= 0x0500)
    #define DISPLAY_DEVICE_REMOTE           0x04000000L
    #define DISPLAY_DEVICE_MODESPRUNED      0x08000000L
#endif
#define DISPLAY_DEVICE_TS_COMPATIBLE        0x00200000L
#if (_WIN32_WINNT >= 0x0600)
    #define DISPLAY_DEVICE_UNSAFE_MODES_ON  0x00080000L
#endif

/* Child display device states */
#if (_WIN32_WINNT >= 0x0500)
    #define DISPLAY_DEVICE_ACTIVE   0x00000001L
    #define DISPLAY_DEVICE_ATTACHED 0x00000002L
#endif

/* Display configuration maximum path length */
#if (WINVER >= 0x0601)
    #define DISPLAYCONFIG_MAXPATH   1024
#endif

/* Display configuration path mode index special value */
#if (WINVER >= 0x0601)
    #define DISPLAYCONFIG_PATH_MODE_IDX_INVALID 0xFFFFFFFF
#endif

/* Display configuration path source status flags */
#if (WINVER >= 0x0601)
    #define DISPLAYCONFIG_SOURCE_IN_USE 0x00000001
#endif

/* Display configuration path target status flags */
#if (WINVER >= 0x0601)
    #define DISPLAYCONFIG_TARGET_IN_USE                     0x00000001
    #define DISPLAYCONFIG_TARGET_FORCIBLE                   0x00000002
    #define DISPLAYCONFIG_TARGET_FORCED_AVAILABILITY_BOOT   0x00000004
    #define DISPLAYCONFIG_TARGET_FORCED_AVAILABILITY_PATH   0x00000008
    #define DISPLAYCONFIG_TARGET_FORCED_AVAILABILITY_SYSTEM 0x00000010
#endif

/* Display configuration path flags */
#if (WINVER >= 0x0601)
    #define DISPLAYCONFIG_PATH_ACTIVE   0x00000001
#endif

/* QueryDisplayConfig() flags */
#if (WINVER >= 0x0601)
    #define QDC_ALL_PATHS               0x00000001
    #define QDC_ONLY_ACTIVE_PATHS       0x00000002
    #define QDC_DATABASE_CURRENT        0x00000004
#endif

/* SetDisplayConfig() flags */
#if (WINVER >= 0x0601)
    #define SDC_TOPOLOGY_INTERNAL           0x00000001
    #define SDC_TOPOLOGY_CLONE              0x00000002
    #define SDC_TOPOLOGY_EXTEND             0x00000004
    #define SDC_TOPOLOGY_EXTERNAL           0x00000008
    #define SDC_TOPOLOGY_SUPPLIED           0x00000010
    #define SDC_USE_DATABASE_CURRENT \
        (SDC_TOPOLOGY_INTERNAL | SDC_TOPOLOGY_CLONE | SDC_TOPOLOGY_EXTEND | \
        SDC_TOPOLOGY_EXTERNAL)
    #define SDC_USE_SUPPLIED_DISPLAY_CONFIG 0x00000020L
    #define SDC_VALIDATE                    0x00000040L
    #define SDC_APPLY                       0x00000080L
    #define SDC_NO_OPTIMIZATION             0x00000100L
    #define SDC_SAVE_TO_DATABASE            0x00000200L
    #define SDC_ALLOW_CHANGES               0x00000400L
    #define SDC_PATH_PERSIST_IF_REQUIRED    0x00000800L
    #define SDC_FORCE_MODE_ENUMERATION      0x00001000L
    #define SDC_ALLOW_PATH_ORDER_CHANGES    0x00002000L
#endif

/* Region data header type values */
#define RDH_RECTANGLES  1

/* Value used with GetRandomRgn() */
#define SYSRGN  4

/* Values used with GetGlyphOutline() */
#define GGO_METRICS             0
#define GGO_BITMAP              1
#define GGO_NATIVE              2
#define GGO_BEZIER              3
#if (WINVER >= 0x0400)
    #define GGO_GRAY2_BITMAP    4
    #define GGO_GRAY4_BITMAP    5
    #define GGO_GRAY8_BITMAP    6
    #define GGO_GLYPH_INDEX     0x0080
#endif
#if (_WIN32_WINNT >= 0x0500)
    #define GGO_UNHINTED        0x0100
#endif

/* TrueType character outline types */
#define TT_POLYGON_TYPE 24

/* TrueType curve types */
#define TT_PRIM_LINE    1
#define TT_PRIM_QSPLINE 2
#define TT_PRIM_CSPLINE 3

/* GetCharacterPlacement() and GetFontLanguageInfo() flags */
#if (WINVER >= 0x0400)
    #define GCP_DBCS            0x00000001L
    #define GCP_REORDER         0x00000002L
    #define GCP_USEKERNING      0x00000008L
    #define GCP_GLYPHSHAPE      0x00000010L
    #define GCP_LIGATE          0x00000020L
    #define GCP_DIACRITIC       0x00000100L
    #define GCP_KASHIDA         0x00000400L
    #define GCP_ERROR           0x00008000L
    #define FLI_MASK            0x0000103BL
    #define GCP_JUSTIFY         0x00010000L
    #define FLI_GLYPHS          0x00040000L
    #define GCP_CLASSIN         0x00080000L
    #define GCP_MAXEXTENT       0x00100000L
    #define GCP_JUSTIFYIN       0x00200000L
    #define GCP_DISPLAYZWG      0x00400000L
    #define GCP_SYMSWAPOFF      0x00800000L
    #define GCP_NUMERICOVERRIDE 0x01000000L
    #define GCP_NEUTRALOVERRIDE 0x02000000L
    #define GCP_NUMERICSLATIN   0x04000000L
    #define GCP_NUMERICSLOCAL   0x08000000L
#endif

/* GetCharacterPlacement() character classes */
#if (WINVER >= 0x0400)
    #define GCPCLASS_LATIN                  1
    #define GCPCLASS_HEBREW                 2
    #define GCPCLASS_ARABIC                 2
    #define GCPCLASS_NEUTRAL                3
    #define GCPCLASS_LOCALNUMBER            4
    #define GCPCLASS_LATINNUMBER            5
    #define GCPCLASS_LATINNUMERICTERMINATOR 6
    #define GCPCLASS_LATINNUMERICSEPARATOR  7
    #define GCPCLASS_NUMERICSEPARATOR       8
    #define GCPCLASS_PREBOUNDLTR            0x80
    #define GCPCLASS_PREBOUNDRTL            0x40
    #define GCPCLASS_POSTBOUNDLTR           0x20
    #define GCPCLASS_POSTBOUNDRTL           0x10
#endif

/* GetCharacterPlacement() glyph flags */
#if (WINVER >= 0x0400)
    #define GCPGLYPH_LINKBEFORE 0x8000
    #define GCPGLYPH_LINKAFTER  0x4000
#endif

/* Rasterizer status flags */
#define TT_AVAILABLE    0x0001
#define TT_ENABLED      0x0002

/* Pixel format types */
#define PFD_TYPE_RGBA       0
#define PFD_TYPE_COLORINDEX 1

/* Pixel format layer types */
#define PFD_MAIN_PLANE      0
#define PFD_OVERLAY_PLANE   1
#define PFD_UNDERLAY_PLANE  (-1)

/* Pixel format descriptor flags */
#define PFD_DOUBLEBUFFER            0x00000001L
#define PFD_STEREO                  0x00000002L
#define PFD_DRAW_TO_WINDOW          0x00000004L
#define PFD_DRAW_TO_BITMAP          0x00000008L
#define PFD_SUPPORT_GDI             0x00000010L
#define PFD_SUPPORT_OPENGL          0x00000020L
#define PFD_GENERIC_FORMAT          0x00000040L
#define PFD_NEED_PALETTE            0x00000080L
#define PFD_NEED_SYSTEM_PALETTE     0x00000100L
#define PFD_SWAP_EXCHANGE           0x00000200L
#define PFD_SWAP_COPY               0x00000400L
#define PFD_SWAP_LAYER_BUFFERS      0x00000800L
#define PFD_GENERIC_ACCELERATED     0x00001000L
#define PFD_SUPPORT_DIRECTDRAW      0x00002000L
#define PFD_DIRECT3D_ACCELERATED    0x00004000L
#define PFD_SUPPORT_COMPOSITION     0x00008000L
#define PFD_DEPTH_DONTCARE          0x20000000L
#define PFD_DOUBLEBUFFER_DONTCARE   0x40000000L
#define PFD_STEREO_DONTCARE         0x80000000L

/* Constants used with DocumentProperties() */
#define DM_UPDATE       1
#define DM_COPY         2
#define DM_PROMPT       4
#define DM_MODIFY       8
#define DM_IN_BUFFER    DM_MODIFY
#define DM_IN_PROMPT    DM_PROMPT
#define DM_OUT_BUFFER   DM_COPY
#define DM_OUT_DEFAULT  DM_UPDATE

/* Device capabilities indices */
#define DC_FIELDS                   1
#define DC_PAPERS                   2
#define DC_PAPERSIZE                3
#define DC_MINEXTENT                4
#define DC_MAXEXTENT                5
#define DC_BINS                     6
#define DC_DUPLEX                   7
#define DC_SIZE                     8
#define DC_EXTRA                    9
#define DC_VERSION                  10
#define DC_DRIVER                   11
#define DC_BINNAMES                 12
#define DC_ENUMRESOLUTIONS          13
#define DC_FILEDEPENDENCIES         14
#define DC_TRUETYPE                 15
#define DC_PAPERNAMES               16
#define DC_ORIENTATION              17
#define DC_COPIES                   18
#if (WINVER >= 0x0400)
    #define DC_BINADJUST            19
    #define DC_EMF_COMPLIANT        20
    #define DC_DATATYPE_PRODUCED    21
    #define DC_COLLATE              22
    #define DC_MANUFACTURER         23
    #define DC_MODEL                24
#endif
#if (WINVER >= 0x0500)
    #define DC_PERSONALITY          25
    #define DC_PRINTRATE            26
    #define DC_PRINTRATEUNIT        27
    #define DC_PRINTERMEM           28
    #define DC_MEDIAREADY           29
    #define DC_STAPLE               30
    #define DC_PRINTRATEPPM         31
    #define DC_COLORDEVICE          32
    #define DC_NUP                  33
    #if (_WIN32_WINNT >= 0x0500)
        #define DC_MEDIATYPENAMES   34
        #define DC_MEDIATYPES       35
    #endif
#endif

/* TrueType capabilities */
#define DCTT_BITMAP                 0x00000001L
#define DCTT_DOWNLOAD               0x00000002L
#define DCTT_SUBDEV                 0x00000004L
#if (WINVER >= 0x0400)
    #define DCTT_DOWNLOAD_OUTLINE   0x00000008L
#endif

/* Bin adjustment capabilities */
#if (WINVER >= 0x0400)
    #define DCBA_FACEUPNONE     0x0000
    #define DCBA_FACEUPCENTER   0x0001
    #define DCBA_FACEUPLEFT     0x0002
    #define DCBA_FACEUPRIGHT    0x0003
    #define DCBA_FACEDOWNNONE   0x0100
    #define DCBA_FACEDOWNCENTER 0x0101
    #define DCBA_FACEDOWNLEFT   0x0102
    #define DCBA_FACEDOWNRIGHT  0x0103
#endif

/* Print rate units */
#if (WINVER >= 0x0500)
    #define PRINTRATEUNIT_PPM   1
    #define PRINTRATEUNIT_CPS   2
    #define PRINTRATEUNIT_LPM   3
    #define PRINTRATEUNIT_IPM   4
#endif

/* Glyph set accelerator flags */
#if (_WIN32_WINNT >= 0x0500)
    #define GS_8BIT_INDICES 0x00000001L
#endif

/* GetGlyphIndices() flags */
#if (_WIN32_WINNT >= 0x0500)
    #define GGI_MARK_NONEXISTING_GLYPHS 0x00000001L
#endif

/* Design vector and axes list stamps */
#if (_WIN32_WINNT >= 0x0500)
    #define STAMP_DESIGNVECTOR  (0x08000000L + 'd' + ('v' << 8))
    #define STAMP_AXESLIST      (0x08000000L + 'a' + ('l' << 8))
#endif

/* Maximum number of axes */
#if (_WIN32_WINNT >= 0x0500)
    #define MM_MAX_NUMAXES  16
#endif

/* Font resource flags */
#if (_WIN32_WINNT >= 0x0500)
    #define FR_PRIVATE  0x00000010L
    #define FR_NOT_ENUM 0x00000020L
#endif

/* GDI DirectDraw packet version */
#if (_WIN32_WINNT >= 0x0600)
    #define GDIREGISTERDDRAWPACKETVERSION   0x00000001L
#endif

/* Maximum length of axes names */
#if (_WIN32_WINNT >= 0x0500)
    #define MM_MAX_AXES_NAMELEN 16
#endif

/* Blend operations */
#if (WINVER >= 0x0400)
    #define AC_SRC_OVER 0x00
#endif

/* Alpha format flags */
#if (WINVER >= 0x0400)
    #define AC_SRC_ALPHA    0x01
#endif

/* GradientFill() modes */
#if (WINVER >= 0x0400)
    #define GRADIENT_FILL_RECT_H    0x00000000L
    #define GRADIENT_FILL_RECT_V    0x00000001L
    #define GRADIENT_FILL_TRIANGLE  0x00000002L
    #define GRADIENT_FILL_OP_FLAG   0x000000FFL
#endif

/* Color adjustment flags */
#define CA_NEGATIVE     0x0001
#define CA_LOG_FILTER   0x0002

/* Illuminant indices */
#define ILLUMINANT_DEVICE_DEFAULT   0
#define ILLUMINANT_A                1
#define ILLUMINANT_B                2
#define ILLUMINANT_C                3
#define ILLUMINANT_D50              4
#define ILLUMINANT_D55              5
#define ILLUMINANT_D65              6
#define ILLUMINANT_D75              7
#define ILLUMINANT_F2               8
#define ILLUMINANT_MAX_INDEX        ILLUMINANT_F2
#define ILLUMINANT_TUNGSTEN         ILLUMINANT_A
#define ILLUMINANT_DAYLIGHT         ILLUMINANT_C
#define ILLUMINANT_FLUORESCENT      ILLUMINANT_F2
#define ILLUMINANT_NTSC             ILLUMINANT_C

/* Gamma bounds */
#define RGB_GAMMA_MIN   02500
#define RGB_GAMMA_MAX   65000

/* Reference black and white bounds */
#define REFERENCE_WHITE_MIN 6000
#define REFERENCE_WHITE_MAX 10000
#define REFERENCE_BLACK_MIN 0
#define REFERENCE_BLACK_MAX 4000

/* Color adjustment bounds */
#define COLOR_ADJ_MIN   (-100)
#define COLOR_ADJ_MAX   100

/* Document information flags */
#if (WINVER >= 0x0400)
    #define DI_APPBANDING               0x00000001L
    #define DI_ROPS_READ_DESTINATION    0x00000002L
#endif

/* Font mapper maximum */
#define FONTMAPPER_MAX  10

/* ICM modes */
#if (WINVER >= 0x0400)
    #define ICM_OFF             1
    #define ICM_ON              2
    #define ICM_QUERY           3
    #define ICM_DONE_OUTSIDEDC  4
#endif

/* Enhanced metafile signature */
#define ENHMETA_SIGNATURE   0x464D4520L

/* Special value used to reference stock objects in enhanced metafiles */
#define ENHMETA_STOCK_OBJECT    0x80000000L

/* Enhanced metafile record types */
#define EMR_HEADER                  1L
#define EMR_POLYBEZIER              2L
#define EMR_POLYGON                 3L
#define EMR_POLYLINE                4L
#define EMR_POLYBEZIERTO            5L
#define EMR_POLYLINETO              6L
#define EMR_POLYPOLYLINE            7L
#define EMR_POLYPOLYGON             8L
#define EMR_SETWINDOWEXTEX          9L
#define EMR_SETWINDOWORGEX          10L
#define EMR_SETVIEWPORTEXTEX        11L
#define EMR_SETVIEWPORTORGEX        12L
#define EMR_SETBRUSHORGEX           13L
#define EMR_EOF                     14L
#define EMR_SETPIXELV               15L
#define EMR_SETMAPPERFLAGS          16L
#define EMR_SETMAPMODE              17L
#define EMR_SETBKMODE               18L
#define EMR_SETPOLYFILLMODE         19L
#define EMR_SETROP2                 20L
#define EMR_SETSTRETCHBLTMODE       21L
#define EMR_SETTEXTALIGN            22L
#define EMR_SETCOLORADJUSTMENT      23L
#define EMR_SETTEXTCOLOR            24L
#define EMR_SETBKCOLOR              25L
#define EMR_OFFSETCLIPRGN           26L
#define EMR_MOVETOEX                27L
#define EMR_SETMETARGN              28L
#define EMR_EXCLUDECLIPRECT         29L
#define EMR_INTERSECTCLIPRECT       30L
#define EMR_SCALEVIEWPORTEXTEX      31L
#define EMR_SCALEWINDOWEXTEX        32L
#define EMR_SAVEDC                  33L
#define EMR_RESTOREDC               34L
#define EMR_SETWORLDTRANSFORM       35L
#define EMR_MODIFYWORLDTRANSFORM    36L
#define EMR_SELECTOBJECT            37L
#define EMR_CREATEPEN               38L
#define EMR_CREATEBRUSHINDIRECT     39L
#define EMR_DELETEOBJECT            40L
#define EMR_ANGLEARC                41L
#define EMR_ELLIPSE                 42L
#define EMR_RECTANGLE               43L
#define EMR_ROUNDRECT               44L
#define EMR_ARC                     45L
#define EMR_CHORD                   46L
#define EMR_PIE                     47L
#define EMR_SELECTPALETTE           48L
#define EMR_CREATEPALETTE           49L
#define EMR_SETPALETTEENTRIES       50L
#define EMR_RESIZEPALETTE           51L
#define EMR_REALIZEPALETTE          52L
#define EMR_EXTFLOODFILL            53L
#define EMR_LINETO                  54L
#define EMR_ARCTO                   55L
#define EMR_POLYDRAW                56L
#define EMR_SETARCDIRECTION         57L
#define EMR_SETMITERLIMIT           58L
#define EMR_BEGINPATH               59L
#define EMR_ENDPATH                 60L
#define EMR_CLOSEFIGURE             61L
#define EMR_FILLPATH                62L
#define EMR_STROKEANDFILLPATH       63L
#define EMR_STROKEPATH              64L
#define EMR_FLATTENPATH             65L
#define EMR_WIDENPATH               66L
#define EMR_SELECTCLIPPATH          67L
#define EMR_ABORTPATH               68L
#define EMR_GDICOMMENT              70L
#define EMR_FILLRGN                 71L
#define EMR_FRAMERGN                72L
#define EMR_INVERTRGN               73L
#define EMR_PAINTRGN                74L
#define EMR_EXTSELECTCLIPRGN        75L
#define EMR_BITBLT                  76L
#define EMR_STRETCHBLT              77L
#define EMR_MASKBLT                 78L
#define EMR_PLGBLT                  79L
#define EMR_SETDIBITSTODEVICE       80L
#define EMR_STRETCHDIBITS           81L
#define EMR_EXTCREATEFONTINDIRECTW  82L
#define EMR_EXTTEXTOUTA             83L
#define EMR_EXTTEXTOUTW             84L
#define EMR_POLYBEZIER16            85L
#define EMR_POLYGON16               86L
#define EMR_POLYLINE16              87L
#define EMR_POLYBEZIERTO16          88L
#define EMR_POLYLINETO16            89L
#define EMR_POLYPOLYLINE16          90L
#define EMR_POLYPOLYGON16           91L
#define EMR_POLYDRAW16              92L
#define EMR_CREATEMONOBRUSH         93L
#define EMR_CREATEDIBPATTERNBRUSHPT 94L
#define EMR_EXTCREATEPEN            95L
#define EMR_POLYTEXTOUTA            96L
#define EMR_POLYTEXTOUTW            97L
#if (WINVER >= 0x0400)
    #define EMR_SETICMMODE          98L
    #define EMR_CREATECOLORSPACE    99L
    #define EMR_SETCOLORSPACE       100L
    #define EMR_DELETECOLORSPACE    101L
    #define EMR_GLSRECORD           102L
    #define EMR_GLSBOUNDEDRECORD    103L
    #define EMR_PIXELFORMAT         104L
#endif
#if (WINVER >= 0x0500)
    #define EMR_COLORCORRECTPALETTE 111L
    #define EMR_SETICMPROFILEA      112L
    #define EMR_SETICMPROFILEW      113L
    #define EMR_ALPHABLEND          114L
    #define EMR_SETLAYOUT           115L
    #define EMR_TRANSPARENTBLT      116L
    #define EMR_GRADIENTFILL        118L
    #define EMR_COLORMATCHTOTARGETW 121L
    #define EMR_CREATECOLORSPACEW   122L
#endif
#define EMR_MIN                     1L
#if (WINVER >= 0x0500)
    #define EMR_MAX                 122L
#elif (WINVER >= 0x0400)
    #define EMR_MAX                 104L
#else
    #define EMR_MAX                 97L
#endif

/* Values used with the ICM functions in enhanced metafiles */
#if (WINVER >= 0x0500)
    #define SETICMPROFILE_EMBEDDED      0x00000001L
    #define CREATECOLORSPACE_EMBEDDED   0x00000001L
    #define COLORMATCHTOTARGET_EMBEDDED 0x00000001L
#endif

/* Special enhanced metafile comments */
#define GDICOMMENT_IDENTIFIER       0x43494447L
#define GDICOMMENT_WINDOWS_METAFILE 0x80000001L
#define GDICOMMENT_BEGINGROUP       0x00000002L
#define GDICOMMENT_ENDGROUP         0x00000003L
#define GDICOMMENT_MULTIFORMATS     0x40000004L
#define EPS_SIGNATURE               0x46535045L
#define GDICOMMENT_UNICODE_STRING   0x00000040L
#define GDICOMMENT_UNICODE_END      0x00000080L

/* OpenGL font types */
#define WGL_FONT_LINES      0
#define WGL_FONT_POLYGONS   1

/* Layer plane descriptor flags */
#define LPD_DOUBLEBUFFER    0x00000001L
#define LPD_STEREO          0x00000002L
#define LPD_SUPPORT_GDI     0x00000010L
#define LPD_SUPPORT_OPENGL  0x00000020L
#define LPD_SHARE_DEPTH     0x00000040L
#define LPD_SHARE_STENCIL   0x00000080L
#define LPD_SHARE_ACCUM     0x00000100L
#define LPD_SWAP_EXCHANGE   0x00000200L
#define LPD_SWAP_COPY       0x00000400L
#define LPD_TRANSPARENT     0x00001000L

/* Layer plane color types */
#define LPD_TYPE_RGB        0
#define LPD_TYPE_COLORINDEX 1

/* wglSwapLayerBuffers() flags */
#define WGL_SWAP_MAIN_PLANE 0x00000001L
#define WGL_SWAP_OVERLAY1   0x00000002L
#define WGL_SWAP_OVERLAY2   0x00000004L
#define WGL_SWAP_OVERLAY3   0x00000008L
#define WGL_SWAP_OVERLAY4   0x00000010L
#define WGL_SWAP_OVERLAY5   0x00000020L
#define WGL_SWAP_OVERLAY6   0x00000040L
#define WGL_SWAP_OVERLAY7   0x00000080L
#define WGL_SWAP_OVERLAY8   0x00000100L
#define WGL_SWAP_OVERLAY9   0x00000200L
#define WGL_SWAP_OVERLAY10  0x00000400L
#define WGL_SWAP_OVERLAY11  0x00000800L
#define WGL_SWAP_OVERLAY12  0x00001000L
#define WGL_SWAP_OVERLAY13  0x00002000L
#define WGL_SWAP_OVERLAY14  0x00004000L
#define WGL_SWAP_OVERLAY15  0x00008000L
#define WGL_SWAP_UNDERLAY1  0x00010000L
#define WGL_SWAP_UNDERLAY2  0x00020000L
#define WGL_SWAP_UNDERLAY3  0x00040000L
#define WGL_SWAP_UNDERLAY4  0x00080000L
#define WGL_SWAP_UNDERLAY5  0x00100000L
#define WGL_SWAP_UNDERLAY6  0x00200000L
#define WGL_SWAP_UNDERLAY7  0x00400000L
#define WGL_SWAP_UNDERLAY8  0x00800000L
#define WGL_SWAP_UNDERLAY9  0x01000000L
#define WGL_SWAP_UNDERLAY10 0x02000000L
#define WGL_SWAP_UNDERLAY11 0x04000000L
#define WGL_SWAP_UNDERLAY12 0x08000000L
#define WGL_SWAP_UNDERLAY13 0x10000000L
#define WGL_SWAP_UNDERLAY14 0x20000000L
#define WGL_SWAP_UNDERLAY15 0x40000000L

/* Maximum number of buffers that can be swapped at once */
#define WGL_SWAPMULTIPLE_MAX    16

/* Structure used with the DRAWPATTERNRECT escape */
#if (WINVER >= 0x0400)
typedef struct _DRAWPATRECT {
    POINT   ptPosition;
    POINT   ptSize;
    WORD    wStyle;
    WORD    wPattern;
} DRAWPATRECT;
typedef DRAWPATRECT *PDRAWPATRECT;
#endif

/* Structure used with the POSTSCRIPT_INJECTION escape */
typedef struct _PSINJECTDATA {
    DWORD   DataBytes;
    WORD    InjectionPoint;
    WORD    PageNumber;
} PSINJECTDATA;
typedef PSINJECTDATA    *PPSINJECTDATA;

/* PostScript output settings */
typedef struct _PSFEATURE_OUTPUT {
    BOOL    bPageIndependent;
    BOOL    bSetPageDevice;
} PSFEATURE_OUTPUT;
typedef PSFEATURE_OUTPUT    *PPSFEATURE_OUTPUT;

/* PostScript custom page size settings */
typedef struct _PSFEATURE_CUSTPAPER {
    LONG    lOrientation;
    LONG    lWidth;
    LONG    lHeight;
    LONG    lWidthOffset;
    LONG    lHeightOffset;
} PSFEATURE_CUSTPAPER;
typedef PSFEATURE_CUSTPAPER *PPSFEATURE_CUSTPAPER;

/* Transformation */
typedef struct tagXFORM {
    FLOAT   eM11;
    FLOAT   eM12;
    FLOAT   eM21;
    FLOAT   eM22;
    FLOAT   eDx;
    FLOAT   eDy;
} XFORM;
typedef XFORM   *PXFORM;
typedef XFORM   *LPXFORM;

/* Bitmap information */
typedef struct tagBITMAP {
    LONG    bmType;
    LONG    bmWidth;
    LONG    bmHeight;
    LONG    bmWidthBytes;
    WORD    bmPlanes;
    WORD    bmBitsPixel;
    LPVOID  bmBits;
} BITMAP;
typedef BITMAP  *PBITMAP;
typedef BITMAP  *NPBITMAP;
typedef BITMAP  *LPBITMAP;

/* RGB triple */
#include <pshpack1.h>
typedef struct tagRGBTRIPLE {
    BYTE    rgbtBlue;
    BYTE    rgbtGreen;
    BYTE    rgbtRed;
} RGBTRIPLE;
typedef RGBTRIPLE   *PRGBTRIPLE;
typedef RGBTRIPLE   *NPRGBTRIPLE;
typedef RGBTRIPLE   *LPRGBTRIPLE;
#include <poppack.h>

/* RGB quadruple */
typedef struct tagRGBQUAD {
    BYTE    rgbBlue;
    BYTE    rgbGreen;
    BYTE    rgbRed;
    BYTE    rgbReserved;
} RGBQUAD;
typedef RGBQUAD *LPRGBQUAD;

/* CIEXYZ */
#if (WINVER >= 0x0400)
typedef struct tagCIEXYZ {
    FXPT2DOT30  ciexyzX;
    FXPT2DOT30  ciexyzY;
    FXPT2DOT30  ciexyzZ;
} CIEXYZ;
typedef CIEXYZ  *LPCIEXYZ;
#endif

/* CIEXYZ triple */
#if (WINVER >= 0x0400)
typedef struct tagCIEXYZTRIPLE {
    CIEXYZ  ciexyzRed;
    CIEXYZ  ciexyzGreen;
    CIEXYZ  ciexyzBlue;
} CIEXYZTRIPLE;
typedef CIEXYZTRIPLE    *LPCIEXYZTRIPLE;
#endif

/* Logical color space */
#if (WINVER >= 0x0400)
typedef struct tagLOGCOLORSPACEA {
    DWORD           lcsSignature;
    DWORD           lcsVersion;
    DWORD           lcsSize;
    LCSCSTYPE       lcsCSType;
    LCSGAMUTMATCH   lcsIntent;
    CIEXYZTRIPLE    lcsEndpoints;
    DWORD           lcsGammaRed;
    DWORD           lcsGammaGreen;
    DWORD           lcsGammaBlue;
    CHAR            lcsFilename[MAX_PATH];
} LOGCOLORSPACEA;
typedef LOGCOLORSPACEA      *LPLOGCOLORSPACEA;
typedef struct tagLOGCOLORSPACEW {
    DWORD           lcsSignature;
    DWORD           lcsVersion;
    DWORD           lcsSize;
    LCSCSTYPE       lcsCSType;
    LCSGAMUTMATCH   lcsIntent;
    CIEXYZTRIPLE    lcsEndpoints;
    DWORD           lcsGammaRed;
    DWORD           lcsGammaGreen;
    DWORD           lcsGammaBlue;
    WCHAR           lcsFilename[MAX_PATH];
} LOGCOLORSPACEW;
typedef LOGCOLORSPACEW      *LPLOGCOLORSPACEW;
#ifdef UNICODE
typedef LOGCOLORSPACEW      LOGCOLORSPACE;
typedef LPLOGCOLORSPACEW    LPLOGCOLORSPACE;
#else
typedef LOGCOLORSPACEA      LOGCOLORSPACE;
typedef LPLOGCOLORSPACEA    LPLOGCOLORSPACE;
#endif
#endif

/* Bitmap core header */
typedef struct tagBITMAPCOREHEADER {
    DWORD   bcSize;
    WORD    bcWidth;
    WORD    bcHeight;
    WORD    bcPlanes;
    WORD    bcBitCount;
} BITMAPCOREHEADER;
typedef BITMAPCOREHEADER    *PBITMAPCOREHEADER;
typedef BITMAPCOREHEADER    *LPBITMAPCOREHEADER;

/* Bitmap information header */
typedef struct tagBITMAPINFOHEADER {
    DWORD   biSize;
    LONG    biWidth;
    LONG    biHeight;
    WORD    biPlanes;
    WORD    biBitCount;
    DWORD   biCompression;
    DWORD   biSizeImage;
    LONG    biXPelsPerMeter;
    LONG    biYPelsPerMeter;
    DWORD   biClrUsed;
    DWORD   biClrImportant;
} BITMAPINFOHEADER;
typedef BITMAPINFOHEADER    *PBITMAPINFOHEADER;
typedef BITMAPINFOHEADER    *LPBITMAPINFOHEADER;

/* Bitmap information header for Windows 95 and later */
#if (WINVER >= 0x0400)
typedef struct {
    DWORD           bV4Size;
    LONG            bV4Width;
    LONG            bV4Height;
    WORD            bV4Planes;
    WORD            bV4BitCount;
    DWORD           bV4V4Compression;
    DWORD           bV4SizeImage;
    LONG            bV4XPelsPerMeter;
    LONG            bV4YPelsPerMeter;
    DWORD           bV4ClrUsed;
    DWORD           bV4ClrImportant;
    DWORD           bV4RedMask;
    DWORD           bV4GreenMask;
    DWORD           bV4BlueMask;
    DWORD           bV4AlphaMask;
    DWORD           bV4CSType;
    CIEXYZTRIPLE    bV4Endpoints;
    DWORD           bV4GammaRed;
    DWORD           bV4GammaGreen;
    DWORD           bV4GammaBlue;
} BITMAPV4HEADER;
typedef BITMAPV4HEADER  *PBITMAPV4HEADER;
typedef BITMAPV4HEADER  *LPBITMAPV4HEADER;
#endif

/* Bitmap information header for Windows 98 and later */
#if (WINVER >= 0x0500)
typedef struct {
    DWORD           bV5Size;
    LONG            bV5Width;
    LONG            bV5Height;
    WORD            bV5Planes;
    WORD            bV5BitCount;
    DWORD           bV5Compression;
    DWORD           bV5SizeImage;
    LONG            bV5XPelsPerMeter;
    LONG            bV5YPelsPerMeter;
    DWORD           bV5ClrUsed;
    DWORD           bV5ClrImportant;
    DWORD           bV5RedMask;
    DWORD           bV5GreenMask;
    DWORD           bV5BlueMask;
    DWORD           bV5AlphaMask;
    DWORD           bV5CSType;
    CIEXYZTRIPLE    bV5Endpoints;
    DWORD           bV5GammaRed;
    DWORD           bV5GammaGreen;
    DWORD           bV5GammaBlue;
    DWORD           bV5Intent;
    DWORD           bV5ProfileData;
    DWORD           bV5ProfileSize;
    DWORD           bV5Reserved;
} BITMAPV5HEADER;
typedef BITMAPV5HEADER  *PBITMAPV5HEADER;
typedef BITMAPV5HEADER  *LPBITMAPV5HEADER;
#endif

/* Bitmap information */
typedef struct tagBITMAPINFO {
    BITMAPINFOHEADER    bmiHeader;
    RGBQUAD             bmiColors[1];
} BITMAPINFO;
typedef BITMAPINFO  *PBITMAPINFO;
typedef BITMAPINFO  *LPBITMAPINFO;

/* Bitmap core information */
typedef struct tagBITMAPCOREINFO {
    BITMAPCOREHEADER    bmciHeader;
    RGBTRIPLE           bmciColors[1];
} BITMAPCOREINFO;
typedef BITMAPCOREINFO  *PBITMAPCOREINFO;
typedef BITMAPCOREINFO  *LPBITMAPCOREINFO;

/* Bitmap file header */
#include <pshpack2.h>
typedef struct tagBITMAPFILEHEADER {
    WORD    bfType;
    DWORD   bfSize;
    WORD    bfReserved1;
    WORD    bfReserved2;
    DWORD   bfOffBits;
} BITMAPFILEHEADER;
typedef BITMAPFILEHEADER    *PBITMAPFILEHEADER;
typedef BITMAPFILEHEADER    *LPBITMAPFILEHEADER;
#include <poppack.h>

/* Font signature */
#if (WINVER >= 0x0400)
typedef struct tagFONTSIGNATURE {
    DWORD   fsUsb[4];
    DWORD   fsCsb[4];
} FONTSIGNATURE;
typedef FONTSIGNATURE   *PFONTSIGNATURE;
typedef FONTSIGNATURE   *LPFONTSIGNATURE;
#endif

/* Character set information */
#if (WINVER >= 0x0400)
typedef struct tagCHARSETINFO {
    UINT            ciCharset;
    UINT            ciACP;
    FONTSIGNATURE   fs;
} CHARSETINFO;
typedef CHARSETINFO *PCHARSETINFO;
typedef CHARSETINFO *NPCHARSETINFO;
typedef CHARSETINFO *LPCHARSETINFO;
#endif

/* Locale signature */
#if (WINVER >= 0x0400)
typedef struct tagLOCALESIGNATURE {
    DWORD   lsUsb[4];
    DWORD   lsCsbDefault[2];
    DWORD   lsCsbSupported[2];
} LOCALESIGNATURE;
typedef LOCALESIGNATURE *PLOCALESIGNATURE;
typedef LOCALESIGNATURE *LPLOCALESIGNATURE;
#endif

/* Handle table for clipboard metafiles */
typedef struct tagHANDLETABLE {
    HGDIOBJ objectHandle[1];
} HANDLETABLE;
typedef HANDLETABLE *PHANDLETABLE;
typedef HANDLETABLE *LPHANDLETABLE;

/* Metafile record */
typedef struct tagMETARECORD {
    DWORD   rdSize;
    WORD    rdFunction;
    WORD    rdParm[1];
} METARECORD;
typedef METARECORD UNALIGNED    *PMETARECORD;
typedef METARECORD UNALIGNED    *LPMETARECORD;

/* Clipboard metafile */
typedef struct tagMETAFILEPICT {
    LONG        mm;
    LONG        xExt;
    LONG        yExt;
    HMETAFILE   hMF;
} METAFILEPICT;
typedef METAFILEPICT    *LPMETAFILEPICT;

/* Metafile header */
#include <pshpack2.h>
typedef struct tagMETAHEADER {
    WORD    mtType;
    WORD    mtHeaderSize;
    WORD    mtVersion;
    DWORD   mtSize;
    WORD    mtNoObjects;
    DWORD   mtMaxRecord;
    WORD    mtNoParameters;
} METAHEADER;
typedef METAHEADER UNALIGNED    *PMETAHEADER;
typedef METAHEADER UNALIGNED    *LPMETAHEADER;
#include <poppack.h>

/* Enhanced metafile record */
typedef struct tagENHMETARECORD {
    DWORD   iType;
    DWORD   nSize;
    DWORD   dParm[1];
} ENHMETARECORD;
typedef ENHMETARECORD   *PENHMETARECORD;
typedef ENHMETARECORD   *LPENHMETARECORD;

/* Enhanced metafile header */
typedef struct tagENHMETAHEADER {
    DWORD   iType;
    DWORD   nSize;
    RECTL   rclBounds;
    RECTL   rclFrame;
    DWORD   dSignature;
    DWORD   nVersion;
    DWORD   nBytes;
    DWORD   nRecords;
    WORD    nHandles;
    WORD    sReserved;
    DWORD   nDescription;
    DWORD   offDescription;
    DWORD   nPalEntries;
    SIZEL   szlDevice;
    SIZEL   szlMillimeters;
#if (WINVER >= 0x0400)
    DWORD   cbPixelFormat;
    DWORD   offPixelFormat;
    DWORD   bOpenGL;
#endif
#if (WINVER >= 0x0500)
    SIZEL   szlMicrometers;
#endif
} ENHMETAHEADER;
typedef ENHMETAHEADER   *PENHMETAHEADER;
typedef ENHMETAHEADER   *LPENHMETAHEADER;

/* Text metric */
#include <pshpack4.h>
typedef struct tagTEXTMETRICA {
    LONG    tmHeight;
    LONG    tmAscent;
    LONG    tmDescent;
    LONG    tmInternalLeading;
    LONG    tmExternalLeading;
    LONG    tmAveCharWidth;
    LONG    tmMaxCharWidth;
    LONG    tmWeight;
    LONG    tmOverhang;
    LONG    tmDigitizedAspectX;
    LONG    tmDigitizedAspectY;
    BYTE    tmFirstChar;
    BYTE    tmLastChar;
    BYTE    tmDefaultChar;
    BYTE    tmBreakChar;
    BYTE    tmItalic;
    BYTE    tmUnderlined;
    BYTE    tmStruckOut;
    BYTE    tmPitchAndFamily;
    BYTE    tmCharSet;
} TEXTMETRICA;
typedef TEXTMETRICA     *PTEXTMETRICA;
typedef TEXTMETRICA     *NPTEXTMETRICA;
typedef TEXTMETRICA     *LPTEXTMETRICA;
typedef struct tagTEXTMETRICW {
    LONG    tmHeight;
    LONG    tmAscent;
    LONG    tmDescent;
    LONG    tmInternalLeading;
    LONG    tmExternalLeading;
    LONG    tmAveCharWidth;
    LONG    tmMaxCharWidth;
    LONG    tmWeight;
    LONG    tmOverhang;
    LONG    tmDigitizedAspectX;
    LONG    tmDigitizedAspectY;
    WCHAR   tmFirstChar;
    WCHAR   tmLastChar;
    WCHAR   tmDefaultChar;
    WCHAR   tmBreakChar;
    BYTE    tmItalic;
    BYTE    tmUnderlined;
    BYTE    tmStruckOut;
    BYTE    tmPitchAndFamily;
    BYTE    tmCharSet;
} TEXTMETRICW;
typedef TEXTMETRICW     *PTEXTMETRICW;
typedef TEXTMETRICW     *NPTEXTMETRICW;
typedef TEXTMETRICW     *LPTEXTMETRICW;
#ifdef UNICODE
typedef TEXTMETRICW     TEXTMETRIC;
typedef PTEXTMETRICW    PTEXTMETRIC;
typedef NPTEXTMETRICW   NPTEXTMETRIC;
typedef LPTEXTMETRICW   LPTEXTMETRIC;
#else
typedef TEXTMETRICA     TEXTMETRIC;
typedef PTEXTMETRICA    PTEXTMETRIC;
typedef NPTEXTMETRICA   NPTEXTMETRIC;
typedef LPTEXTMETRICA   LPTEXTMETRIC;
#endif
#include <poppack.h>

/* New text metric */
#include <pshpack4.h>
typedef struct tagNEWTEXTMETRICA {
    LONG    tmHeight;
    LONG    tmAscent;
    LONG    tmDescent;
    LONG    tmInternalLeading;
    LONG    tmExternalLeading;
    LONG    tmAveCharWidth;
    LONG    tmMaxCharWidth;
    LONG    tmWeight;
    LONG    tmOverhang;
    LONG    tmDigitizedAspectX;
    LONG    tmDigitizedAspectY;
    BYTE    tmFirstChar;
    BYTE    tmLastChar;
    BYTE    tmDefaultChar;
    BYTE    tmBreakChar;
    BYTE    tmItalic;
    BYTE    tmUnderlined;
    BYTE    tmStruckOut;
    BYTE    tmPitchAndFamily;
    BYTE    tmCharSet;
    DWORD   ntmFlags;
    UINT    ntmSizeEM;
    UINT    ntmCellHeight;
    UINT    ntmAvgWidth;
} NEWTEXTMETRICA;
typedef NEWTEXTMETRICA      *PNEWTEXTMETRICA;
typedef NEWTEXTMETRICA      *NPNEWTEXTMETRICA;
typedef NEWTEXTMETRICA      *LPNEWTEXTMETRICA;
typedef struct tagNEWTEXTMETRICW {
    LONG    tmHeight;
    LONG    tmAscent;
    LONG    tmDescent;
    LONG    tmInternalLeading;
    LONG    tmExternalLeading;
    LONG    tmAveCharWidth;
    LONG    tmMaxCharWidth;
    LONG    tmWeight;
    LONG    tmOverhang;
    LONG    tmDigitizedAspectX;
    LONG    tmDigitizedAspectY;
    WCHAR   tmFirstChar;
    WCHAR   tmLastChar;
    WCHAR   tmDefaultChar;
    WCHAR   tmBreakChar;
    BYTE    tmItalic;
    BYTE    tmUnderlined;
    BYTE    tmStruckOut;
    BYTE    tmPitchAndFamily;
    BYTE    tmCharSet;
    DWORD   ntmFlags;
    UINT    ntmSizeEM;
    UINT    ntmCellHeight;
    UINT    ntmAvgWidth;
} NEWTEXTMETRICW;
typedef NEWTEXTMETRICW      *PNEWTEXTMETRICW;
typedef NEWTEXTMETRICW      *NPNEWTEXTMETRICW;
typedef NEWTEXTMETRICW      *LPNEWTEXTMETRICW;
#ifdef UNICODE
typedef NEWTEXTMETRICW      NEWTEXTMETRIC;
typedef PNEWTEXTMETRICW     PNEWTEXTMETRIC;
typedef NPNEWTEXTMETRICW    NPNEWTEXTMETRIC;
typedef LPNEWTEXTMETRICW    LPNEWTEXTMETRIC;
#else
typedef NEWTEXTMETRICA      NEWTEXTMETRIC;
typedef PNEWTEXTMETRICA     PNEWTEXTMETRIC;
typedef NPNEWTEXTMETRICA    NPNEWTEXTMETRIC;
typedef LPNEWTEXTMETRICA    LPNEWTEXTMETRIC;
#endif
#include <poppack.h>

/* New text metric (extended version) */
#if (WINVER >= 0x0400)
typedef struct tagNEWTEXTMETRICEXA {
    NEWTEXTMETRICA  ntmTm;
    FONTSIGNATURE   ntmFontSig;
} NEWTEXTMETRICEXA;
typedef struct tagNEWTEXTMETRICEXW {
    NEWTEXTMETRICW  ntmTm;
    FONTSIGNATURE   ntmFontSig;
} NEWTEXTMETRICEXW;
#ifdef UNICODE
typedef NEWTEXTMETRICEXW    NEWTEXTMETRICEX;
#else
typedef NEWTEXTMETRICEXA    NEWTEXTMETRICEX;
#endif
#endif

/* Pixel array */
typedef struct tagPELARRAY {
    LONG    paXCount;
    LONG    paYCount;
    LONG    paXExt;
    LONG    paYExt;
    BYTE    paRGBs;
} PELARRAY;
typedef PELARRAY    *PPELARRAY;
typedef PELARRAY    *NPPELARRAY;
typedef PELARRAY    *LPPELARRAY;

/* Logical brush */
typedef struct tagLOGBRUSH {
    UINT        lbStyle;
    COLORREF    lbColor;
    ULONG_PTR   lbHatch;
} LOGBRUSH;
typedef LOGBRUSH    *PLOGBRUSH;
typedef LOGBRUSH    *NPLOGBRUSH;
typedef LOGBRUSH    *LPLOGBRUSH;
typedef LOGBRUSH    PATTERN;
typedef PATTERN     *PPATTERN;
typedef PATTERN     *NPPATTERN;
typedef PATTERN     *LPPATTERN;

/* Logical brush (32-bit version) */
typedef struct tagLOGBRUSH32 {
    UINT        lbStyle;
    COLORREF    lbColor;
    ULONG       lbHatch;
} LOGBRUSH32;
typedef LOGBRUSH32  *PLOGBRUSH32;
typedef LOGBRUSH32  *NPLOGBRUSH32;
typedef LOGBRUSH32  *LPLOGBRUSH32;

/* Logical pen */
typedef struct tagLOGPEN {
    UINT        lopnStyle;
    POINT       lopnWidth;
    COLORREF    lopnColor;
} LOGPEN;
typedef LOGPEN  *PLOGPEN;
typedef LOGPEN  *NPLOGPEN;
typedef LOGPEN  *LPLOGPEN;

/* Extended logical pen */
typedef struct tagEXTLOGPEN {
    DWORD       elpPenStyle;
    DWORD       elpWidth;
    UINT        elpBrushStyle;
    COLORREF    elpColor;
    ULONG_PTR   elpHatch;
    DWORD       elpNumEntries;
    DWORD       elpStyleEntry[1];
} EXTLOGPEN;
typedef EXTLOGPEN   *PEXTLOGPEN;
typedef EXTLOGPEN   *NPEXTLOGPEN;
typedef EXTLOGPEN   *LPEXTLOGPEN;

/* Extended logical pen (32-bit version) */
typedef struct tagEXTLOGPEN32 {
    DWORD       elpPenStyle;
    DWORD       elpWidth;
    UINT        elpBrushStyle;
    COLORREF    elpColor;
    ULONG       elpHatch;
    DWORD       elpNumEntries;
    DWORD       elpStyleEntry[1];
} EXTLOGPEN32;
typedef EXTLOGPEN32 *PEXTLOGPEN32;
typedef EXTLOGPEN32 *NPEXTLOGPEN32;
typedef EXTLOGPEN32 *LPEXTLOGPEN32;

/* Palette entry */
typedef struct tagPALETTEENTRY {
    BYTE    peRed;
    BYTE    peGreen;
    BYTE    peBlue;
    BYTE    peFlags;
} PALETTEENTRY;
typedef PALETTEENTRY    *PPALETTEENTRY;
typedef PALETTEENTRY    *LPPALETTEENTRY;

/* Logical palette */
typedef struct tagLOGPALETTE {
    WORD            palVersion;
    WORD            palNumEntries;
    PALETTEENTRY    palPalEntry[1];
} LOGPALETTE;
typedef LOGPALETTE  *PLOGPALETTE;
typedef LOGPALETTE  *NPLOGPALETTE;
typedef LOGPALETTE  *LPLOGPALETTE;

/* Logical font */
typedef struct tagLOGFONTA {
    LONG    lfHeight;
    LONG    lfWidth;
    LONG    lfEscapement;
    LONG    lfOrientation;
    LONG    lfWeight;
    BYTE    lfItalic;
    BYTE    lfUnderline;
    BYTE    lfStrikeOut;
    BYTE    lfCharSet;
    BYTE    lfOutPrecision;
    BYTE    lfClipPrecision;
    BYTE    lfQuality;
    BYTE    lfPitchAndFamily;
    CHAR    lfFaceName[LF_FACESIZE];
} LOGFONTA;
typedef LOGFONTA    *PLOGFONTA;
typedef LOGFONTA    *NPLOGFONTA;
typedef LOGFONTA    *LPLOGFONTA;
typedef struct tagLOGFONTW {
    LONG    lfHeight;
    LONG    lfWidth;
    LONG    lfEscapement;
    LONG    lfOrientation;
    LONG    lfWeight;
    BYTE    lfItalic;
    BYTE    lfUnderline;
    BYTE    lfStrikeOut;
    BYTE    lfCharSet;
    BYTE    lfOutPrecision;
    BYTE    lfClipPrecision;
    BYTE    lfQuality;
    BYTE    lfPitchAndFamily;
    WCHAR   lfFaceName[LF_FACESIZE];
} LOGFONTW;
typedef LOGFONTW    *PLOGFONTW;
typedef LOGFONTW    *NPLOGFONTW;
typedef LOGFONTW    *LPLOGFONTW;
#ifdef UNICODE
typedef LOGFONTW    LOGFONT;
typedef PLOGFONTW   PLOGFONT;
typedef NPLOGFONTW  NPLOGFONT;
typedef LPLOGFONTW  LPLOGFONT;
#else
typedef LOGFONTA    LOGFONT;
typedef PLOGFONTA   PLOGFONT;
typedef NPLOGFONTA  NPLOGFONT;
typedef LPLOGFONTA  LPLOGFONT;
#endif

/* Logical font enumeration data */
typedef struct tagENUMLOGFONTA {
    LOGFONTA    elfLogFont;
    BYTE        elfFullName[LF_FULLFACESIZE];
    BYTE        elfStyle[LF_FACESIZE];
} ENUMLOGFONTA;
typedef ENUMLOGFONTA    *LPENUMLOGFONTA;
typedef struct tagENUMLOGFONTW {
    LOGFONTW    elfLogFont;
    WCHAR       elfFullName[LF_FULLFACESIZE];
    WCHAR       elfStyle[LF_FACESIZE];
} ENUMLOGFONTW;
typedef ENUMLOGFONTW    *LPENUMLOGFONTW;
#ifdef UNICODE
typedef ENUMLOGFONTW    ENUMLOGFONT;
typedef LPENUMLOGFONTW  LPENUMLOGFONT;
#else
typedef ENUMLOGFONTA    ENUMLOGFONT;
typedef LPENUMLOGFONTA  LPENUMLOGFONT;
#endif

/* Logical font enumeration data (extended version) */
#if (WINVER >= 0x0400)
typedef struct tagENUMLOGFONTEXA {
    LOGFONTA    elfLogFont;
    BYTE        elfFullName[LF_FULLFACESIZE];
    BYTE        elfStyle[LF_FACESIZE];
    BYTE        elfScript[LF_FACESIZE];
} ENUMLOGFONTEXA;
typedef ENUMLOGFONTEXA      *LPENUMLOGFONTEXA;
typedef struct tagENUMLOGFONTEXW {
    LOGFONTW    elfLogFont;
    WCHAR       elfFullName[LF_FULLFACESIZE];
    WCHAR       elfStyle[LF_FACESIZE];
    WCHAR       elfScript[LF_FACESIZE];
} ENUMLOGFONTEXW;
typedef ENUMLOGFONTEXW      *LPENUMLOGFONTEXW;
#ifdef UNICODE
typedef ENUMLOGFONTEXW      ENUMLOGFONTEX;
typedef LPENUMLOGFONTEXW    LPENUMLOGFONTEX;
#else
typedef ENUMLOGFONTEXA      ENUMLOGFONTEX;
typedef LPENUMLOGFONTEXA    LPENUMLOGFONTEX;
#endif
#endif

/* PANOSE */
typedef struct tagPANOSE {
    BYTE    bFamilyType;
    BYTE    bSerifStyle;
    BYTE    bWeight;
    BYTE    bProportion;
    BYTE    bContrast;
    BYTE    bStrokeVariation;
    BYTE    bArmStyle;
    BYTE    bLetterform;
    BYTE    bMidline;
    BYTE    bXHeight;
} PANOSE;
typedef PANOSE  *LPPANOSE;

/* Extended logical font */
typedef struct tagEXTLOGFONTA {
    LOGFONTA    elfLogFont;
    BYTE        elfFullName[LF_FULLFACESIZE];
    BYTE        elfStyle[LF_FACESIZE];
    DWORD       elfVersion;
    DWORD       elfStyleSize;
    DWORD       elfMatch;
    DWORD       elfReserved;
    BYTE        elfVendorId[ELF_VENDOR_SIZE];
    DWORD       elfCulture;
    PANOSE      elfPanose;
} EXTLOGFONTA;
typedef EXTLOGFONTA     *PEXTLOGFONTA;
typedef EXTLOGFONTA     *NPEXTLOGFONTA;
typedef EXTLOGFONTA     *LPEXTLOGFONTA;
typedef struct tagEXTLOGFONTW {
    LOGFONTW    elfLogFont;
    WCHAR       elfFullName[LF_FULLFACESIZE];
    WCHAR       elfStyle[LF_FACESIZE];
    DWORD       elfVersion;
    DWORD       elfStyleSize;
    DWORD       elfMatch;
    DWORD       elfReserved;
    BYTE        elfVendorId[ELF_VENDOR_SIZE];
    DWORD       elfCulture;
    PANOSE      elfPanose;
} EXTLOGFONTW;
typedef EXTLOGFONTW     *PEXTLOGFONTW;
typedef EXTLOGFONTW     *NPEXTLOGFONTW;
typedef EXTLOGFONTW     *LPEXTLOGFONTW;
#ifdef UNICODE
typedef EXTLOGFONTW     EXTLOGFONT;
typedef PEXTLOGFONTW    PEXTLOGFONT;
typedef NPEXTLOGFONTW   NPEXTLOGFONT;
typedef LPEXTLOGFONTW   LPEXTLOGFONT;
#else
typedef EXTLOGFONTA     EXTLOGFONT;
typedef PEXTLOGFONTA    PEXTLOGFONT;
typedef NPEXTLOGFONTA   NPEXTLOGFONT;
typedef LPEXTLOGFONTA   LPEXTLOGFONT;
#endif

/* Device mode */
typedef struct _devicemodeA {
    BYTE    dmDeviceName[CCHDEVICENAME];
    WORD    dmSpecVersion;
    WORD    dmDriverVersion;
    WORD    dmSize;
    WORD    dmDriverExtra;
    DWORD   dmFields;
    union {
        struct {
            short   dmOrientation;
            short   dmPaperSize;
            short   dmPaperLength;
            short   dmPaperWidth;
            short   dmScale;
            short   dmCopies;
            short   dmDefaultSource;
            short   dmPrintQuality;
        };
        struct {
            POINTL  dmPosition;
            DWORD   dmDisplayOrientation;
            DWORD   dmDisplayFixedOutput;
        };
    };
    short   dmColor;
    short   dmDuplex;
    short   dmYResolution;
    short   dmTTOption;
    short   dmCollate;
    BYTE    dmFormName[CCHFORMNAME];
    WORD    dmLogPixels;
    DWORD   dmBitsPerPel;
    DWORD   dmPelsWidth;
    DWORD   dmPelsHeight;
    union {
        DWORD   dmDisplayFlags;
        DWORD   dmNup;
    };
    DWORD   dmDisplayFrequency;
#if (WINVER >= 0x0400)
    DWORD   dmICMMethod;
    DWORD   dmICMIntent;
    DWORD   dmMediaType;
    DWORD   dmDitherType;
    DWORD   dmReserved1;
    DWORD   dmReserved2;
#endif
#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
    DWORD   dmPanningWidth;
    DWORD   dmPanningHeight;
#endif
} DEVMODEA;
typedef DEVMODEA    *PDEVMODEA;
typedef DEVMODEA    *NPDEVMODEA;
typedef DEVMODEA    *LPDEVMODEA;
typedef struct _devicemodeW {
    WCHAR   dmDeviceName[CCHDEVICENAME];
    WORD    dmSpecVersion;
    WORD    dmDriverVersion;
    WORD    dmSize;
    WORD    dmDriverExtra;
    DWORD   dmFields;
    union {
        struct {
            short   dmOrientation;
            short   dmPaperSize;
            short   dmPaperLength;
            short   dmPaperWidth;
            short   dmScale;
            short   dmCopies;
            short   dmDefaultSource;
            short   dmPrintQuality;
        };
        struct {
            POINTL  dmPosition;
            DWORD   dmDisplayOrientation;
            DWORD   dmDisplayFixedOutput;
        };
    };
    short   dmColor;
    short   dmDuplex;
    short   dmYResolution;
    short   dmTTOption;
    short   dmCollate;
    WCHAR   dmFormName[CCHFORMNAME];
    WORD    dmLogPixels;
    DWORD   dmBitsPerPel;
    DWORD   dmPelsWidth;
    DWORD   dmPelsHeight;
    union {
        DWORD   dmDisplayFlags;
        DWORD   dmNup;
    };
    DWORD   dmDisplayFrequency;
#if (WINVER >= 0x0400)
    DWORD   dmICMMethod;
    DWORD   dmICMIntent;
    DWORD   dmMediaType;
    DWORD   dmDitherType;
    DWORD   dmReserved1;
    DWORD   dmReserved2;
#endif
#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
    DWORD   dmPanningWidth;
    DWORD   dmPanningHeight;
#endif
} DEVMODEW;
typedef DEVMODEW    *PDEVMODEW;
typedef DEVMODEW    *NPDEVMODEW;
typedef DEVMODEW    *LPDEVMODEW;
#ifdef UNICODE
typedef DEVMODEW    DEVMODE;
typedef PDEVMODEW   PDEVMODE;
typedef NPDEVMODEW  NPDEVMODE;
typedef LPDEVMODEW  LPDEVMODE;
#else
typedef DEVMODEA    DEVMODE;
typedef PDEVMODEA   PDEVMODE;
typedef NPDEVMODEA  NPDEVMODE;
typedef LPDEVMODEA  LPDEVMODE;
#endif

/* Display device information */
typedef struct _DISPLAY_DEVICEA {
    DWORD   cb;
    CHAR    DeviceName[32];
    CHAR    DeviceString[128];
    DWORD   StateFlags;
    CHAR    DeviceID[128];
    CHAR    DeviceKey[128];
} DISPLAY_DEVICEA;
typedef DISPLAY_DEVICEA     *PDISPLAY_DEVICEA;
typedef DISPLAY_DEVICEA     *LPDISPLAY_DEVICEA;
typedef struct _DISPLAY_DEVICEW {
    DWORD   cb;
    WCHAR   DeviceName[32];
    WCHAR   DeviceString[128];
    DWORD   StateFlags;
    WCHAR   DeviceID[128];
    WCHAR   DeviceKey[128];
} DISPLAY_DEVICEW;
typedef DISPLAY_DEVICEW     *PDISPLAY_DEVICEW;
typedef DISPLAY_DEVICEW     *LPDISPLAY_DEVICEW;
#ifdef UNICODE
typedef DISPLAY_DEVICEW     DISPLAY_DEVICE;
typedef PDISPLAY_DEVICEW    PDISPLAY_DEVICE;
typedef LPDISPLAY_DEVICEW   LPDISPLAY_DEVICE;
#else
typedef DISPLAY_DEVICEA     DISPLAY_DEVICE;
typedef PDISPLAY_DEVICEA    PDISPLAY_DEVICE;
typedef LPDISPLAY_DEVICEA   LPDISPLAY_DEVICE;
#endif

/* Display configuration rational number */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_RATIONAL {
    UINT32  Numerator;
    UINT32  Denominator;
} DISPLAYCONFIG_RATIONAL;
#endif

/* Display configuration video output technologies */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_OTHER                   = -1,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HD15                    = 0,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SVIDEO                  = 1,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPOSITE_VIDEO         = 2,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPONENT_VIDEO         = 3,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DVI                     = 4,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HDMI                    = 5,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_LVDS                    = 6,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_D_JPN                   = 8,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDI                     = 9,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EXTERNAL    = 10,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EMBEDDED    = 11,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EXTERNAL            = 12,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EMBEDDED            = 13,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDTVDONGLE              = 14,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INTERNAL                = 0x80000000,
    DISPLAYCONFIG_OUTPUT_TECHNOLOGY_FORCE_UINT32            = 0xFFFFFFFF
} DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY;
#endif

/* Display configuration scanline orderings */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_SCANLINE_ORDERING_UNSPECIFIED                 = 0,
    DISPLAYCONFIG_SCANLINE_ORDERING_PROGRESSIVE                 = 1,
    DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED                  = 2,
    DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_UPPERFIELDFIRST
        = DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED,
    DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_LOWERFIELDFIRST  = 3,
    DISPLAYCONFIG_SCANLINE_ORDERING_FORCE_UINT32                = 0xFFFFFFFF
} DISPLAYCONFIG_SCANLINE_ORDERING;
#endif

/* Display configuration 2D region */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_2DREGION {
    UINT32  cx;
    UINT32  cy;
} DISPLAYCONFIG_2DREGION;
#endif

/* Display configuration video configuration information */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_VIDEO_SIGNAL_INFO {
    UINT64                          pixelRate;
    DISPLAYCONFIG_RATIONAL          hSyncFreq;
    DISPLAYCONFIG_RATIONAL          vSyncFreq;
    DISPLAYCONFIG_2DREGION          activeSize;
    DISPLAYCONFIG_2DREGION          totalSize;
    UINT32                          videoStandard;
    DISPLAYCONFIG_SCANLINE_ORDERING scanLineOrdering;
} DISPLAYCONFIG_VIDEO_SIGNAL_INFO;
#endif

/* Display configuration scaling values */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_SCALING_IDENTITY                  = 1,
    DISPLAYCONFIG_SCALING_CENTERED                  = 2,
    DISPLAYCONFIG_SCALING_STRETCHED                 = 3,
    DISPLAYCONFIG_SCALING_ASPECTRATIO_CENTEREDMAX   = 4,
    DISPLAYCONFIG_SCALING_CUSTOM                    = 5,
    DISPLAYCONFIG_SCALING_PREFERRED                 = 128,
    DISPLAYCONFIG_SCALING_FORCE_UINT32              = 0xFFFFFFFF
} DISPLAYCONFIG_SCALING;
#endif

/* Display configuration rotation values */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_ROTATION_IDENTITY     = 1,
    DISPLAYCONFIG_ROTATION_ROTATE90     = 2,
    DISPLAYCONFIG_ROTATION_ROTATE180    = 3,
    DISPLAYCONFIG_ROTATION_ROTATE270    = 4,
    DISPLAYCONFIG_ROTATION_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_ROTATION;
#endif

/* Display configuration mode information types */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_MODE_INFO_TYPE_SOURCE         = 1,
    DISPLAYCONFIG_MODE_INFO_TYPE_TARGET         = 2,
    DISPLAYCONFIG_MODE_INFO_TYPE_FORCE_UINT32   = 0xFFFFFFFF
} DISPLAYCONFIG_MODE_INFO_TYPE;
#endif

/* Display configuration pixel formats */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_PIXELFORMAT_8BPP          = 1,
    DISPLAYCONFIG_PIXELFORMAT_16BPP         = 2,
    DISPLAYCONFIG_PIXELFORMAT_24BPP         = 3,
    DISPLAYCONFIG_PIXELFORMAT_32BPP         = 4,
    DISPLAYCONFIG_PIXELFORMAT_NONGDI        = 5,
    DISPLAYCONFIG_PIXELFORMAT_FORCE_UINT32  = 0xFFFFFFFF
} DISPLAYCONFIG_PIXELFORMAT;
#endif

/* Display configuration source mode */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_SOURCE_MODE {
    UINT32                      width;
    UINT32                      height;
    DISPLAYCONFIG_PIXELFORMAT   pixelFormat;
    POINTL                      position;
} DISPLAYCONFIG_SOURCE_MODE;
#endif

/* Display configuration target mode */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_TARGET_MODE {
    DISPLAYCONFIG_VIDEO_SIGNAL_INFO targetVideoSignalInfo;
} DISPLAYCONFIG_TARGET_MODE;
#endif

/* Display configuration mode information */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_MODE_INFO {
    DISPLAYCONFIG_MODE_INFO_TYPE    infoType;
    UINT32                          id;
    LUID                            adapterId;
    union {
        DISPLAYCONFIG_TARGET_MODE   targetMode;
        DISPLAYCONFIG_SOURCE_MODE   sourceMode;
    };
} DISPLAYCONFIG_MODE_INFO;
#endif

/* Display configuration path source information */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_PATH_SOURCE_INFO {
    LUID    adapterId;
    UINT32  id;
    UINT32  modeInfoIdx;
    UINT32  statusFlags;
} DISPLAYCONFIG_PATH_SOURCE_INFO;
#endif

/* Display configuration path target information */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_PATH_TARGET_INFO {
    LUID                                    adapterId;
    UINT32                                  id;
    UINT32                                  modeInfoIdx;
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY   outputTechnology;
    DISPLAYCONFIG_ROTATION                  rotation;
    DISPLAYCONFIG_SCALING                   scaling;
    DISPLAYCONFIG_RATIONAL                  refreshRate;
    DISPLAYCONFIG_SCANLINE_ORDERING         scanlineOrdering;
    BOOL                                    targetAvailable;
    UINT32                                  statusFlags;
} DISPLAYCONFIG_PATH_TARGET_INFO;
#endif

/* Display configuration path information */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_PATH_INFO {
    DISPLAYCONFIG_PATH_SOURCE_INFO  sourceInfo;
    DISPLAYCONFIG_PATH_TARGET_INFO  targetInfo;
    UINT32                          flags;
} DISPLAYCONFIG_PATH_INFO;
#endif

/* Display configuration topology identifiers */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_TOPOLOGY_INTERNAL     = 0x00000001,
    DISPLAYCONFIG_TOPOLOGY_CLONE        = 0x00000002,
    DISPLAYCONFIG_TOPOLOGY_EXTEND       = 0x00000004,
    DISPLAYCONFIG_TOPOLOGY_EXTERNAL     = 0x00000008,
    DISPLAYCONFIG_TOPOLOGY_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_TOPOLOGY_ID;
#endif

/* Display configuration device information types */
#if (WINVER >= 0x0601)
typedef enum {
    DISPLAYCONFIG_DEVICE_INFO_GET_SOURCE_NAME           = 1,
    DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_NAME           = 2,
    DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_PREFERRED_MODE = 3,
    DISPLAYCONFIG_DEVICE_INFO_GET_ADAPTER_NAME          = 4,
    DISPLAYCONFIG_DEVICE_INFO_SET_TARGET_PERSISTENCE    = 5,
    DISPLAYCONFIG_DEVICE_INFO_FORCE_UINT32              = 0xFFFFFFFF
} DISPLAYCONFIG_DEVICE_INFO_TYPE;
#endif

/* Display configuration device information header */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_DEVICE_INFO_HEADER {
    DISPLAYCONFIG_DEVICE_INFO_TYPE  type;
    UINT32                          size;
    LUID                            adapterId;
    UINT32                          id;
} DISPLAYCONFIG_DEVICE_INFO_HEADER;
#endif

/* Display configuration source device name */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_SOURCE_DEVICE_NAME {
    DISPLAYCONFIG_DEVICE_INFO_HEADER    header;
    WCHAR                               viewGdiDeviceName[CCHDEVICENAME];
} DISPLAYCONFIG_SOURCE_DEVICE_NAME;
#endif

/* Display configuration target device name flags */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS {
    union {
        struct {
            UINT32  friendlyNameFromEdid    : 1;
            UINT32  friendlyNameForced      : 1;
            UINT32  edidIdsValid            : 1;
            UINT32  reserved                : 29;
        };
        UINT32  value;
    };
} DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS;
#endif

/* Display configuration target device name */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_TARGET_DEVICE_NAME {
    DISPLAYCONFIG_DEVICE_INFO_HEADER        header;
    DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS  flags;
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY   outputTechnology;
    UINT16                                  edidManufacturerId;
    UINT16                                  edidProductCodeId;
    UINT32                                  connectorInstance;
    WCHAR                                   monitorFriendlyDeviceName[64];
    WCHAR                                   monitorDevicePath[128];
} DISPLAYCONFIG_TARGET_DEVICE_NAME;
#endif

/* Display configuration target preferred mode */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_TARGET_PREFERRED_MODE {
    DISPLAYCONFIG_DEVICE_INFO_HEADER    header;
    UINT32                              width;
    UINT32                              height;
    DISPLAYCONFIG_TARGET_MODE           targetMode;
} DISPLAYCONFIG_TARGET_PREFERRED_MODE;
#endif

/* Display configuration adapter name */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_ADAPTER_NAME {
    DISPLAYCONFIG_DEVICE_INFO_HEADER    header;
    WCHAR                               adapterDevicePath[128];
} DISPLAYCONFIG_ADAPTER_NAME;
#endif

/* Display configuration set target persistence */
#if (WINVER >= 0x0601)
typedef struct DISPLAYCONFIG_SET_TARGET_PERSISTENCE {
    DISPLAYCONFIG_DEVICE_INFO_HEADER    header;
    union {
        struct {
            UINT32  bootPersistenceOn   : 1;
            UINT32  reserved            : 31;
        };
        UINT32  value;
    };
} DISPLAYCONFIG_SET_TARGET_PERSISTENCE;
#endif

/* Region data header */
typedef struct _RGNDATAHEADER {
    DWORD   dwSize;
    DWORD   iType;
    DWORD   nCount;
    DWORD   nRgnSize;
    RECT    rcBound;
} RGNDATAHEADER;
typedef RGNDATAHEADER   *PRGNDATAHEADER;

/* Region data */
typedef struct _RGNDATA {
    RGNDATAHEADER   rdh;
    char            Buffer[1];
} RGNDATA;
typedef RGNDATA *PRGNDATA;
typedef RGNDATA *NPRGNDATA;
typedef RGNDATA *LPRGNDATA;

/* Font ABC widths */
typedef struct _ABC {
    int     abcA;
    UINT    abcB;
    int     abcC;
} ABC;
typedef ABC *PABC;
typedef ABC *NPABC;
typedef ABC *LPABC;

/* Font ABC widths (floating-point version) */
typedef struct _ABCFLOAT {
    FLOAT   abcfA;
    FLOAT   abcfB;
    FLOAT   abcfC;
} ABCFLOAT;
typedef ABCFLOAT    *PABCFLOAT;
typedef ABCFLOAT    *NPABCFLOAT;
typedef ABCFLOAT    *LPABCFLOAT;

/* Outline text metric */
typedef struct _OUTLINETEXTMETRICA {
    UINT        otmSize;
    TEXTMETRICA otmTextMetrics;
    BYTE        otmFiller;
    PANOSE      otmPanoseNumber;
    UINT        otmfsSelection;
    UINT        otmfsType;
    int         otmsCharSlopeRise;
    int         otmsCharSlopeRun;
    int         otmItalicAngle;
    UINT        otmEMSquare;
    int         otmAscent;
    int         otmDescent;
    UINT        otmLineGap;
    UINT        otmsCapEmHeight;
    UINT        otmsXHeight;
    RECT        otmrcFontBox;
    int         otmMacAscent;
    int         otmMacDescent;
    UINT        otmMacLineGap;
    UINT        otmusMinimumPPEM;
    POINT       otmptSubscriptSize;
    POINT       otmptSubscriptOffset;
    POINT       otmptSuperscriptSize;
    POINT       otmptSuperscriptOffset;
    UINT        otmsStrikeoutSize;
    int         otmsStrikeoutPosition;
    int         otmsUnderscoreSize;
    int         otmsUnderscorePosition;
    PSTR        otmpFamilyName;
    PSTR        otmpFaceName;
    PSTR        otmpStyleName;
    PSTR        otmpFullName;
} OUTLINETEXTMETRICA;
typedef OUTLINETEXTMETRICA      *POUTLINETEXTMETRICA;
typedef OUTLINETEXTMETRICA      *NPOUTLINETEXTMETRICA;
typedef OUTLINETEXTMETRICA      *LPOUTLINETEXTMETRICA;
typedef struct _OUTLINETEXTMETRICW {
    UINT        otmSize;
    TEXTMETRICW otmTextMetrics;
    BYTE        otmFiller;
    PANOSE      otmPanoseNumber;
    UINT        otmfsSelection;
    UINT        otmfsType;
    int         otmsCharSlopeRise;
    int         otmsCharSlopeRun;
    int         otmItalicAngle;
    UINT        otmEMSquare;
    int         otmAscent;
    int         otmDescent;
    UINT        otmLineGap;
    UINT        otmsCapEmHeight;
    UINT        otmsXHeight;
    RECT        otmrcFontBox;
    int         otmMacAscent;
    int         otmMacDescent;
    UINT        otmMacLineGap;
    UINT        otmusMinimumPPEM;
    POINT       otmptSubscriptSize;
    POINT       otmptSubscriptOffset;
    POINT       otmptSuperscriptSize;
    POINT       otmptSuperscriptOffset;
    UINT        otmsStrikeoutSize;
    int         otmsStrikeoutPosition;
    int         otmsUnderscoreSize;
    int         otmsUnderscorePosition;
    PSTR        otmpFamilyName;
    PSTR        otmpFaceName;
    PSTR        otmpStyleName;
    PSTR        otmpFullName;
} OUTLINETEXTMETRICW;
typedef OUTLINETEXTMETRICW      *POUTLINETEXTMETRICW;
typedef OUTLINETEXTMETRICW      *NPOUTLINETEXTMETRICW;
typedef OUTLINETEXTMETRICW      *LPOUTLINETEXTMETRICW;
#ifdef UNICODE
typedef OUTLINETEXTMETRICW      OUTLINETEXTMETRIC;
typedef POUTLINETEXTMETRICW     POUTLINETEXTMETRIC;
typedef NPOUTLINETEXTMETRICW    NPOUTLINETEXTMETRIC;
typedef LPOUTLINETEXTMETRICW    LPOUTLINETEXTMETRIC;
#else
typedef OUTLINETEXTMETRICA      OUTLINETEXTMETRIC;
typedef POUTLINETEXTMETRICA     POUTLINETEXTMETRIC;
typedef NPOUTLINETEXTMETRICA    NPOUTLINETEXTMETRIC;
typedef LPOUTLINETEXTMETRICA    LPOUTLINETEXTMETRIC;
#endif

/* Structure passed of PolyTextOut() */
typedef struct tagPOLYTEXTA {
    int     x;
    int     y;
    UINT    n;
    LPCSTR  lpstr;
    UINT    uiFlags;
    RECT    rcl;
    int     *pdx;
} POLYTEXTA;
typedef POLYTEXTA   *PPOLYTEXTA;
typedef POLYTEXTA   *NPPOLYTEXTA;
typedef POLYTEXTA   *LPPOLYTEXTA;
typedef struct tagPOLYTEXTW {
    int     x;
    int     y;
    UINT    n;
    LPCWSTR lpstr;
    UINT    uiFlags;
    RECT    rcl;
    int     *pdx;
} POLYTEXTW;
typedef POLYTEXTW   *PPOLYTEXTW;
typedef POLYTEXTW   *NPPOLYTEXTW;
typedef POLYTEXTW   *LPPOLYTEXTW;
#ifdef UNICODE
typedef POLYTEXTW   POLYTEXT;
typedef PPOLYTEXTW  PPOLYTEXT;
typedef NPPOLYTEXTW NPPOLYTEXT;
typedef LPPOLYTEXTW LPPOLYTEXT;
#else
typedef POLYTEXTA   POLYTEXT;
typedef PPOLYTEXTA  PPOLYTEXT;
typedef NPPOLYTEXTA NPPOLYTEXT;
typedef LPPOLYTEXTA LPPOLYTEXT;
#endif

/* Fixed-point number */
typedef struct _FIXED {
    WORD    fract;
    short   value;
} FIXED;

/* Transformation matrix */
typedef struct _MAT2 {
    FIXED   eM11;
    FIXED   eM12;
    FIXED   eM21;
    FIXED   eM22;
} MAT2;
typedef MAT2    *LPMAT2;

/* Glyph metrics */
typedef struct _GLYPHMETRICS {
    UINT    gmBlackBoxX;
    UINT    gmBlackBoxY;
    POINT   gmptGlyphOrigin;
    short   gmCellIncX;
    short   gmCellIncY;
} GLYPHMETRICS;
typedef GLYPHMETRICS    *LPGLYPHMETRICS;

/* Point (fixed-point version) */
typedef struct tagPOINTFX {
    FIXED   x;
    FIXED   y;
} POINTFX;
typedef POINTFX *LPPOINTFX;

/* TrueType curves */
typedef struct tagTTPOLYCURVE {
    WORD    wType;
    WORD    cpfx;
    POINTFX apfx[1];
} TTPOLYCURVE;
typedef TTPOLYCURVE *LPTTPOLYCURVE;

/* TrueType polygon header */
typedef struct tagTTPOLYGONHEADER {
    DWORD   cb;
    DWORD   dwType;
    POINTFX pfxStart;
} TTPOLYGONHEADER;
typedef TTPOLYGONHEADER *LPTTPOLYGONHEADER;

/* GetCharacterPlacement() results */
#if (WINVER >= 0x0400)
typedef struct tagGCP_RESULTSA {
    DWORD   lStructSize;
    LPSTR   lpOutString;
    UINT    *lpOrder;
    int     *lpDx;
    int     *lpCaretPos;
    LPSTR   lpClass;
    LPWSTR  lpGlyphs;
    UINT    nGlyphs;
    int     nMaxFit;
} GCP_RESULTSA;
typedef GCP_RESULTSA    *LPGCP_RESULTSA;
typedef struct tagGCP_RESULTSW {
    DWORD   lStructSize;
    LPWSTR  lpOutString;
    UINT    *lpOrder;
    int     *lpDx;
    int     *lpCaretPos;
    LPSTR   lpClass;
    LPWSTR  lpGlyphs;
    UINT    nGlyphs;
    int     nMaxFit;
} GCP_RESULTSW;
typedef GCP_RESULTSW    *LPGCP_RESULTSW;
#ifdef UNICODE
typedef GCP_RESULTSW    GCP_RESULTS;
typedef LPGCP_RESULTSW  LPGCP_RESULTS;
#else
typedef GCP_RESULTSA    GCP_RESULTS;
typedef LPGCP_RESULTSA  LPGCP_RESULTS;
#endif
#endif

/* Rasterizer status */
typedef struct _RASTERIZER_STATUS {
    short   nSize;
    short   wFlags;
    short   nLanguageID;
} RASTERIZER_STATUS;
typedef RASTERIZER_STATUS   *LPRASTERIZER_STATUS;

/* Pixel format descriptor */
typedef struct tagPIXELFORMATDESCRIPTOR {
    WORD    nSize;
    WORD    nVersion;
    DWORD   dwFlags;
    BYTE    iPixelType;
    BYTE    cColorBits;
    BYTE    cRedBits;
    BYTE    cRedShift;
    BYTE    cGreenBits;
    BYTE    cGreenShift;
    BYTE    cBlueBits;
    BYTE    cBlueShift;
    BYTE    cAlphaBits;
    BYTE    cAlphaShift;
    BYTE    cAccumBits;
    BYTE    cAccumRedBits;
    BYTE    cAccumGreenBits;
    BYTE    cAccumBlueBits;
    BYTE    cAccumAlphaBits;
    BYTE    cDepthBits;
    BYTE    cStencilBits;
    BYTE    cAuxBuffers;
    BYTE    iLayerType;
    BYTE    bReserved;
    DWORD   dwLayerMask;
    DWORD   dwVisibleMask;
    DWORD   dwDamageMask;
} PIXELFORMATDESCRIPTOR;
typedef PIXELFORMATDESCRIPTOR   *PPIXELFORMATDESCRIPTOR;
typedef PIXELFORMATDESCRIPTOR   *LPPIXELFORMATDESCRIPTOR;

/* GDI callbacks */
typedef int (CALLBACK *OLDFONTENUMPROCA)( CONST LOGFONTA *, CONST TEXTMETRICA *, DWORD, LPARAM );
typedef int (CALLBACK *OLDFONTENUMPROCW)( CONST LOGFONTW *, CONST TEXTMETRICW *, DWORD, LPARAM );
typedef int (CALLBACK *GOBJENUMPROC)( LPVOID, LPARAM );
typedef VOID (CALLBACK *LINEDDAPROC)( int, int, LPARAM );
typedef OLDFONTENUMPROCA    FONTENUMPROCA;
typedef OLDFONTENUMPROCW    FONTENUMPROCW;
#ifdef UNICODE
    #define FONTENUMPROC    FONTENUMPROCW
    #define OLDFONTENUMPROC OLDFONTENUMPROCW
#else
    #define FONTENUMPROC    FONTENUMPROCA
    #define OLDFONTENUMPROC OLDFONTENUMPROCA
#endif

/* Function pointers for Win16 compatibility */
typedef UINT (CALLBACK *LPFNDEVMODE)( HWND, HMODULE, LPDEVMODE, LPSTR, LPSTR, LPDEVMODE, LPSTR, UINT );
typedef DWORD (CALLBACK *LPFNDEVCAPS)( LPSTR, LPSTR, UINT, LPSTR, LPDEVMODE );

/* Unicode character range */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagWCRANGE {
    WCHAR   wcLow;
    USHORT  cGlyphs;
} WCRANGE;
typedef WCRANGE *PWCRANGE;
typedef WCRANGE *LPWCRANGE;
#endif

/* Glyph set */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagGLYPHSET {
    DWORD   cbThis;
    DWORD   flAccel;
    DWORD   cGlyphsSupported;
    DWORD   cRanges;
    WCRANGE ranges[1];
} GLYPHSET;
typedef GLYPHSET    *PGLYPHSET;
typedef GLYPHSET    *LPGLYPHSET;
#endif

/* Design vector */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagDESIGNVECTOR {
    DWORD   dvReserved;
    DWORD   dvNumAxes;
    LONG    dvValues[MM_MAX_NUMAXES];
} DESIGNVECTOR;
typedef DESIGNVECTOR    *PDESIGNVECTOR;
typedef DESIGNVECTOR    *LPDESIGNVECTOR;
#endif

/* Axis information */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagAXISINFOA {
    LONG    axMinValue;
    LONG    axMaxValue;
    BYTE    axAxisName[MM_MAX_AXES_NAMELEN];
} AXISINFOA;
typedef AXISINFOA   *PAXISINFOA;
typedef AXISINFOA   *LPAXISINFOA;
typedef struct tagAXISINFOW {
    LONG    axMinValue;
    LONG    axMaxValue;
    BYTE    axAxisName[MM_MAX_AXES_NAMELEN];
} AXISINFOW;
typedef AXISINFOW   *PAXISINFOW;
typedef AXISINFOW   *LPAXISINFOW;
#ifdef UNICODE
typedef AXISINFOW   AXISINFO;
typedef PAXISINFOW  PAXISINFO;
typedef LPAXISINFOW LPAXISINFO;
#else
typedef AXISINFOA   AXISINFO;
typedef PAXISINFOA  PAXISINFO;
typedef LPAXISINFOA LPAXISINFO;
#endif
#endif

/* Axes list */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagAXESLISTA {
    DWORD       axlReserved;
    DWORD       axlNumAxes;
    AXISINFOA   axlAxisInfo[MM_MAX_NUMAXES];
} AXESLISTA;
typedef AXESLISTA   *PAXESLISTA;
typedef AXESLISTA   *LPAXESLISTA;
typedef struct tagAXESLISTW {
    DWORD       axlReserved;
    DWORD       axlNumAxes;
    AXISINFOW   axlAxisInfo[MM_MAX_NUMAXES];
} AXESLISTW;
typedef AXESLISTW   *PAXESLISTW;
typedef AXESLISTW   *LPAXESLISTW;
#ifdef UNICODE
typedef AXESLISTW   AXESLIST;
typedef PAXESLISTW  PAXESLIST;
typedef LPAXESLISTW LPAXESLIST;
#else
typedef AXESLISTA   AXESLIST;
typedef PAXESLISTA  PAXESLIST;
typedef LPAXESLISTA LPAXESLIST;
#endif
#endif

/* Logical font enumeration data (extended version with design vector) */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagENUMLOGFONTEXDVA {
    ENUMLOGFONTEXA  elfEnumLogfontEx;
    DESIGNVECTOR    elfDesignVector;
} ENUMLOGFONTEXDVA;
typedef ENUMLOGFONTEXDVA    *PENUMLOGFONTEXDVA;
typedef ENUMLOGFONTEXDVA    *LPENUMLOGFONTEXDVA;
typedef struct tagENUMLOGFONTEXDVW {
    ENUMLOGFONTEXW  elfEnumLogfontEx;
    DESIGNVECTOR    elfDesignVector;
} ENUMLOGFONTEXDVW;
typedef ENUMLOGFONTEXDVW    *PENUMLOGFONTEXDVW;
typedef ENUMLOGFONTEXDVW    *LPENUMLOGFONTEXDVW;
#ifdef UNICODE
typedef ENUMLOGFONTEXDVW    ENUMLOGFONTEXDV;
typedef PENUMLOGFONTEXDVW   PENUMLOGFONTEXDV;
typedef LPENUMLOGFONTEXDVW  LPENUMLOGFONTEXDV;
#else
typedef ENUMLOGFONTEXDVA    ENUMLOGFONTEXDV;
typedef PENUMLOGFONTEXDVA   PENUMLOGFONTEXDV;
typedef LPENUMLOGFONTEXDVA  LPENUMLOGFONTEXDV;
#endif
#endif

/* Text metric enumeration data */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagENUMTEXTMETRICA {
    NEWTEXTMETRICEXA    etmNewTextMetricEx;
    AXESLISTA           etmAxesList;
} ENUMTEXTMETRICA;
typedef ENUMTEXTMETRICA     *PENUMTEXTMETRICA;
typedef ENUMTEXTMETRICA     *LPENUMTEXTMETRICA;
typedef struct tagENUMTEXTMETRICW {
    NEWTEXTMETRICEXW    etmNewTextMetricEx;
    AXESLISTW           etmAxesList;
} ENUMTEXTMETRICW;
typedef ENUMTEXTMETRICW     *PENUMTEXTMETRICW;
typedef ENUMTEXTMETRICW     *LPENUMTEXTMETRICW;
#ifdef UNICODE
typedef ENUMTEXTMETRICW     ENUMTEXTMETRIC;
typedef PENUMTEXTMETRICW    PENUMTEXTMETRIC;
typedef LPENUMTEXTMETRICW   LPENUMTEXTMETRIC;
#else
typedef ENUMTEXTMETRICA     ENUMTEXTMETRIC;
typedef PENUMTEXTMETRICA    PENUMTEXTMETRIC;
typedef LPENUMTEXTMETRICA   LPENUMTEXTMETRIC;
#endif
#endif

/* GDI DirectDraw callbacks */
#if (_WIN32_WINNT >= 0x0600)
typedef PVOID (WINAPI *GDIMARSHALLOC)( DWORD, LPVOID );
typedef HRESULT (WINAPI *DDRAWMARSHCALLBACKMARSHAL)( HGDIOBJ, LPVOID, LPVOID * );
typedef HRESULT (WINAPI *DDRAWMARSHCALLBACKUNMARSHAL)( LPVOID, HDC *, LPVOID * );
typedef HRESULT (WINAPI *DDRAWMARSHCALLBACKRELEASE)( LPVOID );
#endif

/* GDI DirectDraw pakcet */
#if (_WIN32_WINNT >= 0x0600)
typedef struct {
    DWORD                       dwSize;
    DWORD                       dwVersion;
    DDRAWMARSHCALLBACKMARSHAL   pfnDdMarshal;
    DDRAWMARSHCALLBACKUNMARSHAL pfnDdUnmarshal;
    DDRAWMARSHCALLBACKRELEASE   pfnDdRelease;
} GDIREGISTERDDRAWPACKET;
typedef GDIREGISTERDDRAWPACKET  *PGDIREGISTERDDRAWPACKET;
#endif

/* Triangle vertex */
#if (WINVER >= 0x0400)
typedef struct _TRIVERTEX {
    LONG    x;
    LONG    y;
    COLOR16 Red;
    COLOR16 Green;
    COLOR16 Blue;
    COLOR16 Alpha;
} TRIVERTEX;
typedef TRIVERTEX   *PTRIVERTEX;
typedef TRIVERTEX   *LPTRIVERTEX;
#endif

/* Gradient triangle */
#if (WINVER >= 0x0400)
typedef struct _GRADIENT_TRIANGLE {
    ULONG   Vertex1;
    ULONG   Vertex2;
    ULONG   Vertex3;
} GRADIENT_TRIANGLE;
typedef GRADIENT_TRIANGLE   *PGRADIENT_TRIANGLE;
typedef GRADIENT_TRIANGLE   *LPGRADIENT_TRIANGLE;
#endif

/* Gradient rectangle */
#if (WINVER >= 0x0400)
typedef struct _GRADIENT_RECT {
    ULONG   UpperLeft;
    ULONG   LowerRight;
} GRADIENT_RECT;
typedef GRADIENT_RECT   *PGRADIENT_RECT;
typedef GRADIENT_RECT   *LPGRADIENT_RECT;
#endif

/* Blend function */
#if (WINVER >= 0x0400)
typedef struct _BLENDFUNCTION {
    BYTE    BlendOp;
    BYTE    BlendFlags;
    BYTE    SourceConstantAlpha;
    BYTE    AlphaFormat;
} BLENDFUNCTION;
typedef BLENDFUNCTION   *PBLENDFUNCTION;
#endif

/* Metafile enumeration callbacks */
typedef int (CALLBACK *MFENUMPROC)( HDC, HANDLETABLE *, METARECORD *, int, LPARAM );
typedef int (CALLBACK *ENHMFENUMPROC)( HDC, HANDLETABLE *, ENHMETARECORD *, int, LPARAM );

/* DIB section */
typedef struct tagDIBSECTION {
    BITMAP              dsBm;
    BITMAPINFOHEADER    dsBmih;
    DWORD               dsBitfields[3];
    HANDLE              dshSection;
    DWORD               dsOffset;
} DIBSECTION;
typedef DIBSECTION  *PDIBSECTION;
typedef DIBSECTION  *LPDIBSECTION;

/* Color adjustment information */
typedef struct tagCOLORADJUSTMENT {
    WORD    caSize;
    WORD    caFlags;
    WORD    caIlluminantIndex;
    WORD    caRedGamma;
    WORD    caGreenGamma;
    WORD    caBlueGamma;
    WORD    caReferenceBlack;
    WORD    caReferenceWhite;
    SHORT   caContrast;
    SHORT   caBrightness;
    SHORT   caColorfulness;
    SHORT   caRedGreenTint;
} COLORADJUSTMENT;
typedef COLORADJUSTMENT *PCOLORADJUSTMENT;
typedef COLORADJUSTMENT *LPCOLORADJUSTMENT;

/* Abort procedure callback for printing */
typedef BOOL (CALLBACK *ABORTPROC)( HDC, int );

/* Document information */
typedef struct _DOCINFOA {
    int     cbSize;
    LPCSTR  lpszDocName;
    LPCSTR  lpszOutput;
#if (WINVER >= 0x0400)
    LPCSTR  lpszDatatype;
    DWORD   fwType;
#endif
} DOCINFOA;
typedef DOCINFOA    *LPDOCINFOA;
typedef struct _DOCINFOW {
    int     cbSize;
    LPCWSTR lpszDocName;
    LPCWSTR lpszOutput;
#if (WINVER >= 0x0400)
    LPCWSTR lpszDatatype;
    DWORD   fwType;
#endif
} DOCINFOW;
typedef DOCINFOW    *LPDOCINFOW;
#ifdef UNICODE
typedef DOCINFOW    DOCINFO;
typedef LPDOCINFOW  LPDOCINFO;
#else
typedef DOCINFOA    DOCINFO;
typedef LPDOCINFOA  LPDOCINFO;
#endif

/* Kerning pair */
typedef struct tagKERNINGPAIR {
    WORD    wFirst;
    WORD    wSecond;
    int     iKernAmount;
} KERNINGPAIR;
typedef KERNINGPAIR *LPKERNINGPAIR;

/* ICM enumeration procedure */
#if (WINVER >= 0x0400)
typedef int (CALLBACK *ICMENUMPROCA)( LPSTR, LPARAM );
typedef int (CALLBACK *ICMENUMPROCW)( LPWSTR, LPARAM );
#ifdef UNICODE
    #define ICMENUMPROC ICMENUMPROCW
#else
    #define ICMENUMPROC ICMENUMPROCA
#endif
#endif

/* Enhanced metafile record header */
typedef struct tagEMR {
    DWORD   iType;
    DWORD   nSize;
} EMR;
typedef EMR *PEMR;

/* Data for enhanced metafile records involving text */
typedef struct tagEMRTEXT {
    POINTL  ptlReference;
    DWORD   nChars;
    DWORD   offString;
    DWORD   fOptions;
    RECTL   rcl;
    DWORD   offDx;
} EMRTEXT;
typedef EMRTEXT *PEMRTEXT;

/* Enhanced metafile record for AbortPath(), etc. */
typedef struct tagEMRABORTPATH {
    EMR emr;
} EMRABORTPATH;
typedef EMRABORTPATH    *PEMRABORTPATH;
typedef EMRABORTPATH    EMRBEGINPATH;
typedef EMRABORTPATH    *PEMRBEGINPATH;
typedef EMRABORTPATH    EMRENDPATH;
typedef EMRABORTPATH    *PEMRENDPATH;
typedef EMRABORTPATH    EMRCLOSEFIGURE;
typedef EMRABORTPATH    *PEMRCLOSEFIGURE;
typedef EMRABORTPATH    EMRFLATTENPATH;
typedef EMRABORTPATH    *PEMRFLATTENPATH;
typedef EMRABORTPATH    EMRWIDENPATH;
typedef EMRABORTPATH    *PEMRWIDENPATH;
typedef EMRABORTPATH    EMRSETMETARGN;
typedef EMRABORTPATH    *PEMRSETMETARGN;
typedef EMRABORTPATH    EMRSAVEDC;
typedef EMRABORTPATH    *PEMRSAVEDC;
typedef EMRABORTPATH    EMRREALIZEPALETTE;
typedef EMRABORTPATH    *PEMRREALIZEPALETTE;

/* Enhanced metafile record for SelectClipPath(), etc. */
typedef struct tagEMRSELECTCLIPPATH {
    EMR     emr;
    DWORD   iMode;
} EMRSELECTCLIPPATH;
typedef EMRSELECTCLIPPATH   *PEMRSELECTCLIPPATH;
typedef EMRSELECTCLIPPATH   EMRSETBKMODE;
typedef EMRSELECTCLIPPATH   *PEMRSETBKMODE;
typedef EMRSELECTCLIPPATH   EMRSETMAPMODE;
typedef EMRSELECTCLIPPATH   *PEMRSETMAPMODE;
#if (WINVER >= 0x0500)
typedef EMRSELECTCLIPPATH   EMRSETLAYOUT;
typedef EMRSELECTCLIPPATH   *PEMRSETLAYOUT;
#endif
typedef EMRSELECTCLIPPATH   EMRSETPOLYFILLMODE;
typedef EMRSELECTCLIPPATH   *PEMRSETPOLYFILLMODE;
typedef EMRSELECTCLIPPATH   EMRSETROP2;
typedef EMRSELECTCLIPPATH   *PEMRSETROP2;
typedef EMRSELECTCLIPPATH   EMRSETSTRETCHBLTMODE;
typedef EMRSELECTCLIPPATH   *PEMRSETSTRETCHBLTMODE;
typedef EMRSELECTCLIPPATH   EMRSETICMMODE;
typedef EMRSELECTCLIPPATH   *PEMRSETICMMODE;
typedef EMRSELECTCLIPPATH   EMRSETTEXTALIGN;
typedef EMRSELECTCLIPPATH   *PEMRSETTEXTALIGN;

/* Enhanced metafile record for SetMiterLimit() */
typedef struct tagEMRSETMITERLIMIT {
    EMR     emr;
    FLOAT   eMiterLimit;
} EMRSETMITERLIMIT;
typedef EMRSETMITERLIMIT    *PEMRSETMITERLIMIT;

/* Enhanced metafile record for RestoreDC() */
typedef struct tagEMRRESTOREDC {
    EMR     emr;
    LONG    iRelative;
} EMRRESTOREDC;
typedef EMRRESTOREDC    *PEMRRESTOREDC;

/* Enhanced metafile record for SetArcDirection() */
typedef struct tagEMRSETARCDIRECTION {
    EMR     emr;
    DWORD   iArcDirection;
} EMRSETARCDIRECTION;
typedef EMRSETARCDIRECTION  *PEMRSETARCDIRECTION;

/* Enhanced metafile record for SetMapperFlags() */
typedef struct tagEMRSETMAPPERFLAGS {
    EMR     emr;
    DWORD   dwFlags;
} EMRSETMAPPERFLAGS;
typedef EMRSETMAPPERFLAGS   *PEMRSETMAPPERFLAGS;

/* Enhanced metafile record for SetTextColor() and SetBkColor() */
typedef struct tagEMRSETTEXTCOLOR {
    EMR         emr;
    COLORREF    crColor;
} EMRSETTEXTCOLOR;
typedef EMRSETTEXTCOLOR *PEMRSETTEXTCOLOR;
typedef EMRSETTEXTCOLOR EMRSETBKCOLOR;
typedef EMRSETTEXTCOLOR *PEMRSETBKCOLOR;

/* Enhanced metafile record for SelectObject() and DeleteObject() */
typedef struct tagEMRSELECTOBJECT {
    EMR     emr;
    DWORD   ihObject;
} EMRSELECTOBJECT;
typedef EMRSELECTOBJECT *PEMRSELECTOBJECT;
typedef EMRSELECTOBJECT EMRDELETEOBJECT;
typedef EMRSELECTOBJECT *PEMRDELETEOBJECT;

/* Enhanced metafile record for SelectPalette() */
typedef struct tagEMRSELECTPALETTE {
    EMR     emr;
    DWORD   ihPal;
} EMRSELECTPALETTE;
typedef EMRSELECTPALETTE    *PEMRSELECTPALETTE;

/* Enhanced metafile record for ResizePalette() */
typedef struct tagEMRRESIZEPALETTE {
    EMR     emr;
    DWORD   ihPal;
    DWORD   cEntries;
} EMRRESIZEPALETTE;
typedef EMRRESIZEPALETTE    *PEMRRESIZEPALETTE;

/* Enhanced metafile record for SetPaletteEntries() */
typedef struct tagEMRSETPALETTEENTRIES {
    EMR             emr;
    DWORD           ihPal;
    DWORD           iStart;
    DWORD           cEntries;
    PALETTEENTRY    aPalEntries[1];
} EMRSETPALETTEENTRIES;
typedef EMRSETPALETTEENTRIES    *PEMRSETPALETTEENTRIES;

/* Enhanced metafile record for SetColorAdjustment() */
typedef struct tagEMRSETCOLORADJUSTMENT {
    EMR             emr;
    COLORADJUSTMENT ColorAdjustment;
} EMRSETCOLORADJUSTMENT;
typedef EMRSETCOLORADJUSTMENT   *PEMRSETCOLORADJUSTMENT;

/* Enhanced metafile record for GdiComment() */
typedef struct tagEMRGDICOMMENT {
    EMR     emr;
    DWORD   cbData;
    BYTE    Data[1];
} EMRGDICOMMENT;
typedef EMRGDICOMMENT   *PEMRGDICOMMENT;

/* Enhanced metafile record for end-of-file */
typedef struct tagEMREOF {
    EMR     emr;
    DWORD   nPalEntries;
    DWORD   offPalEntries;
    DWORD   nSizeLast;
} EMREOF;
typedef EMREOF  *PEMREOF;

/* Enhanced metafile record for LineTo() and MoveToEx() */
typedef struct tagEMRLINETO {
    EMR     emr;
    POINTL  ptl;
} EMRLINETO;
typedef EMRLINETO   *PEMRLINETO;
typedef EMRLINETO   EMRMOVETOEX;
typedef EMRLINETO   *PEMRMOVETOEX;

/* Enhanced metafile record for OffsetClipRgn() */
typedef struct tagEMROFFSETCLIPRGN {
    EMR     emr;
    POINTL  ptlOffset;
} EMROFFSETCLIPRGN;
typedef EMROFFSETCLIPRGN    *PEMROFFSETCLIPRGN;

/* Enhanced metafile record for FillPath(), etc. */
typedef struct tagEMRFILLPATH {
    EMR     emr;
    RECTL   rclBounds;
} EMRFILLPATH;
typedef EMRFILLPATH *PEMRFILLPATH;
typedef EMRFILLPATH EMRSTROKEANDFILLPATH;
typedef EMRFILLPATH *PEMRSTROKEANDFILLPATH;
typedef EMRFILLPATH EMRSTROKEPATH;
typedef EMRFILLPATH *PEMRSTROKEPATH;

/* Enhanced metafile record for ExcludeClipRect() and IntersectClipRect() */
typedef struct tagEMREXCLUDECLIPRECT {
    EMR     emr;
    RECTL   rclClip;
} EMREXCLUDECLIPRECT;
typedef EMREXCLUDECLIPRECT  *PEMREXCLUDECLIPRECT;
typedef EMREXCLUDECLIPRECT  EMRINTERSECTCLIPRECT;
typedef EMREXCLUDECLIPRECT  *PEMRINTERSECTCLIPRECT;

/* Enhanced metafile record for SetViewportOrgEx(), etc. */
typedef struct tagEMRSETVIEWPORTORGEX {
    EMR     emr;
    POINTL  ptlOrigin;
} EMRSETVIEWPORTORGEX;
typedef EMRSETVIEWPORTORGEX *PEMRSETVIEWPORTORGEX;
typedef EMRSETVIEWPORTORGEX EMRSETWINDOWORGEX;
typedef EMRSETVIEWPORTORGEX *PEMRSETWINDOWORGEX;
typedef EMRSETVIEWPORTORGEX EMRSETBRUSHORGEX;
typedef EMRSETVIEWPORTORGEX *PEMRSETBRUSHORGEX;

/* Enhanced metafile record for SetViewportExtEx() and SetWindowExtEx() */
typedef struct tagEMRSETVIEWPORTEXTEX {
    EMR     emr;
    SIZEL   szlExtent;
} EMRSETVIEWPORTEXTEX;
typedef EMRSETVIEWPORTEXTEX *PEMRSETVIEWPORTEXTEX;
typedef EMRSETVIEWPORTEXTEX EMRSETWINDOWEXTEX;
typedef EMRSETVIEWPORTEXTEX *PEMRSETWINDOWEXTEX;

/* Enhanced metafile record for ScaleViewportExtEx() and ScaleWindowExtEx() */
typedef struct tagEMRSCALEVIEWPORTEXTEX {
    EMR     emr;
    LONG    xNum;
    LONG    xDenom;
    LONG    yNum;
    LONG    yDenom;
} EMRSCALEVIEWPORTEXTEX;
typedef EMRSCALEVIEWPORTEXTEX   *PEMRSCALEVIEWPORTEXTEX;
typedef EMRSCALEVIEWPORTEXTEX   EMRSCALEWINDOWEXTEX;
typedef EMRSCALEVIEWPORTEXTEX   *PEMRSCALEWINDOWEXTEX;

/* Enhanced metafile record for SetWorldTransform() */
typedef struct tagEMRSETWORLDTRANSFORM {
    EMR     emr;
    XFORM   xform;
} EMRSETWORLDTRANSFORM;
typedef EMRSETWORLDTRANSFORM    *PEMRSETWORLDTRANSFORM;

/* Enhanced metafile record for ModifyWorldTransform() */
typedef struct tagEMRMODIFYWORLDTRANSFORM {
    EMR     emr;
    XFORM   xform;
    DWORD   iMode;
} EMRMODIFYWORLDTRANSFORM;
typedef EMRMODIFYWORLDTRANSFORM *PEMRMODIFYWORLDTRANSFORM;

/* Enhanced metafile record for SetPixelV() */
typedef struct tagEMRSETPIXELV {
    EMR         emr;
    POINTL      ptlPixel;
    COLORREF    crColor;
} EMRSETPIXELV;
typedef EMRSETPIXELV    *PEMRSETPIXELV;

/* Enhanced metafile record for ExtFloodFill() */
typedef struct tagEMREXTFLOODFILL {
    EMR         emr;
    POINTL      ptlStart;
    COLORREF    crColor;
    DWORD       iMode;
} EMREXTFLOODFILL;
typedef EMREXTFLOODFILL *PEMREXTFLOODFILL;

/* Enhanced metafile record for Ellipse() and Rectangle() */
typedef struct tagEMRELLIPSE {
    EMR     emr;
    RECTL   rclBox;
} EMRELLIPSE;
typedef EMRELLIPSE  *PEMRELLIPSE;
typedef EMRELLIPSE  EMRRECTANGLE;
typedef EMRELLIPSE  *PEMRRECTANGLE;

/* Enhanced metafile record for RoundRect() */
typedef struct tagEMRROUNDRECT {
    EMR     emr;
    RECTL   rclBox;
    SIZEL   szlCorner;
} EMRROUNDRECT;
typedef EMRROUNDRECT    *PEMRROUNDRECT;

/* Enhanced metafile record for Arc() */
typedef struct tagEMRARC {
    EMR     emr;
    RECTL   rclBox;
    POINTL  ptlStart;
    POINTL  ptlEnd;
} EMRARC;
typedef EMRARC  *PEMRARC;
typedef EMRARC  EMRARCTO;
typedef EMRARC  *PEMRARCTO;
typedef EMRARC  EMRCHORD;
typedef EMRARC  *PEMRCHORD;
typedef EMRARC  EMRPIE;
typedef EMRARC  *PEMRPIE;

/* Enhanced metafile record for AngleArc() */
typedef struct tagEMRANGLEARC {
    EMR     emr;
    POINTL  ptlCenter;
    DWORD   nRadius;
    FLOAT   eStartAngle;
    FLOAT   eSweepAngle;
} EMRANGLEARC;
typedef EMRANGLEARC *PEMRANGLEARC;

/* Enhanced metafile record for Polyline(), etc. */
typedef struct tagEMRPOLYLINE {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cptl;
    POINTL  aptl[1];
} EMRPOLYLINE;
typedef EMRPOLYLINE *PEMRPOLYLINE;
typedef EMRPOLYLINE EMRPOLYBEZIER;
typedef EMRPOLYLINE *PEMRPOLYBEZIER;
typedef EMRPOLYLINE EMRPOLYGON;
typedef EMRPOLYLINE *PEMRPOLYGON;
typedef EMRPOLYLINE EMRPOLYBEZIERTO;
typedef EMRPOLYLINE *PEMRPOLYBEZIERTO;
typedef EMRPOLYLINE EMRPOLYLINETO;
typedef EMRPOLYLINE *PEMRPOLYLINETO;

/* Enhanced metafile record for Polyline(), etc. (16-bit version) */
typedef struct tagEMRPOLYLINE16 {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cpts;
    POINTS  apts[1];
} EMRPOLYLINE16;
typedef EMRPOLYLINE16   *PEMRPOLYLINE16;
typedef EMRPOLYLINE16   EMRPOLYBEZIER16;
typedef EMRPOLYLINE16   *PEMRPOLYBEZIER16;
typedef EMRPOLYLINE16   EMRPOLYGON16;
typedef EMRPOLYLINE16   *PEMRPOLYGON16;
typedef EMRPOLYLINE16   EMRPOLYBEZIERTO16;
typedef EMRPOLYLINE16   *PEMRPOLYBEZIERTO16;
typedef EMRPOLYLINE16   EMRPOLYLINETO16;
typedef EMRPOLYLINE16   *PEMRPOLYLINETO16;

/* Enhanced metafile record for PolyDraw() */
typedef struct tagEMRPOLYDRAW {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cptl;
    POINTL  aptl[1];
    BYTE    abTypes[1];
} EMRPOLYDRAW;
typedef EMRPOLYDRAW *PEMRPOLYDRAW;

/* Enhanced metafile record for PolyDraw() (16-bit version) */
typedef struct tagEMRPOLYDRAW16 {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cpts;
    POINTS  apts[1];
    BYTE    abTypes[1];
} EMRPOLYDRAW16;
typedef EMRPOLYDRAW16   *PEMRPOLYDRAW16;

/* Enhanced metafile record for PolyPolyline() and PolyPolygon() */
typedef struct tagEMRPOLYPOLYLINE {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   nPolys;
    DWORD   cptl;
    DWORD   aPolyCounts[1];
    POINTL  aptl[1];
} EMRPOLYPOLYLINE;
typedef EMRPOLYPOLYLINE *PEMRPOLYPOLYLINE;
typedef EMRPOLYPOLYLINE EMRPOLYPOLYGON;
typedef EMRPOLYPOLYLINE *PEMRPOLYPOLYGON;

/* Enhanced metafile record for PolyPolyline() and PolyPolygon() (16-bit version) */
typedef struct tagEMRPOLYPOLYLINE16 {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   nPolys;
    DWORD   cpts;
    DWORD   aPolyCounts[1];
    POINTS  apts[1];
} EMRPOLYPOLYLINE16;
typedef EMRPOLYPOLYLINE16   *PEMRPOLYPOLYLINE16;
typedef EMRPOLYPOLYLINE16   EMRPOLYPOLYGON16;
typedef EMRPOLYPOLYLINE16   *PEMRPOLYPOLYGON16;

/* Enhanced metafile record for InvertRgn() and PaintRgn() */
typedef struct tagEMRINVERTRGN {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cbRgnData;
    BYTE    RgnData[1];
} EMRINVERTRGN;
typedef EMRINVERTRGN    *PEMRINVERTRGN;
typedef EMRINVERTRGN    EMRPAINTRGN;
typedef EMRINVERTRGN    *PEMRPAINTRGN;

/* Enhanced metafile record for FillRgn() */
typedef struct tagEMRFILLRGN {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cbRgnData;
    DWORD   ihBrush;
    BYTE    RgnData[1];
} EMRFILLRGN;
typedef EMRFILLRGN  *PEMRFILLRGN;

/* Enhanced metafile record for FrameRgn() */
typedef struct tagEMRFRAMERGN {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cbRgnData;
    DWORD   ihBrush;
    SIZEL   szlStroke;
    BYTE    RgnData[1];
} EMRFRAMERGN;
typedef EMRFRAMERGN *PEMRFRAMERGN;

/* Enhanced metafile record for ExtSelectClipRgn() */
typedef struct tagEMREXTSELECTCLIPRGN {
    EMR     emr;
    DWORD   cbRgnData;
    DWORD   iMode;
    BYTE    RgnData[1];
} EMREXTSELECTCLIPRGN;
typedef EMREXTSELECTCLIPRGN *PEMREXTSELECTCLIPRGN;

/* Enhanced metafile record for ExtTextOut() */
typedef struct tagEMREXTTEXTOUTA {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   iGraphicsMode;
    FLOAT   exScale;
    FLOAT   eyScale;
    EMRTEXT emrtext;
} EMREXTTEXTOUTA;
typedef EMREXTTEXTOUTA  *PEMREXTTEXTOUTA;
typedef EMREXTTEXTOUTA  EMREXTTEXTOUTW;
typedef EMREXTTEXTOUTA  *PEMREXTTEXTOUTW;

/* Enhanced metafile record for PolyTextOut() */
typedef struct tagEMRPOLYTEXTOUTA {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   iGraphicsMode;
    FLOAT   exScale;
    FLOAT   eyScale;
    LONG    cStrings;
    EMRTEXT aemrtext[1];
} EMRPOLYTEXTOUTA;
typedef EMRPOLYTEXTOUTA *PEMRPOLYTEXTOUTA;
typedef EMRPOLYTEXTOUTA EMRPOLYTEXTOUTW;
typedef EMRPOLYTEXTOUTA *PEMRPOLYTEXTOUTW;

/* Enhanced metafile record for BitBlt() */
typedef struct tagEMRBITBLT {
    EMR         emr;
    RECTL       rclBounds;
    LONG        xDest;
    LONG        yDest;
    LONG        cxDest;
    LONG        cyDest;
    DWORD       dwRop;
    LONG        xSrc;
    LONG        ySrc;
    XFORM       xformSrc;
    COLORREF    crBkColorSrc;
    DWORD       iUsageSrc;
    DWORD       offBmiSrc;
    DWORD       cbBmiSrc;
    DWORD       offBitsSrc;
    DWORD       cbBitsSrc;
} EMRBITBLT;
typedef EMRBITBLT   *PEMRBITBLT;

/* Enhanced metafile record for StretchBlt() */
typedef struct tagEMRSTRETCHBLT {
    EMR         emr;
    RECTL       rclBounds;
    LONG        xDest;
    LONG        yDest;
    LONG        cxDest;
    LONG        cyDest;
    DWORD       dwRop;
    LONG        xSrc;
    LONG        ySrc;
    XFORM       xformSrc;
    COLORREF    crBkColorSrc;
    DWORD       iUsageSrc;
    DWORD       offBmiSrc;
    DWORD       cbBmiSrc;
    DWORD       offBitsSrc;
    DWORD       cbBitsSrc;
    LONG        cxSrc;
    LONG        cySrc;
} EMRSTRETCHBLT;
typedef EMRSTRETCHBLT   *PEMRSTRETCHBLT;

/* Enhanced metafile record for MaskBlt() */
typedef struct tagEMRMASKBLT {
    EMR         emr;
    RECTL       rclBounds;
    LONG        xDest;
    LONG        yDest;
    LONG        cxDest;
    LONG        cyDest;
    DWORD       dwRop;
    LONG        xSrc;
    LONG        ySrc;
    XFORM       xformSrc;
    COLORREF    crBkColorSrc;
    DWORD       iUsageSrc;
    DWORD       offBmiSrc;
    DWORD       cbBmiSrc;
    DWORD       offBitsSrc;
    DWORD       cbBitsSrc;
    LONG        xMask;
    LONG        yMask;
    DWORD       iUsageMask;
    DWORD       offBmiMask;
    DWORD       cbBmiMask;
    DWORD       offBitsMask;
    DWORD       cbBitsMask;
} EMRMASKBLT;
typedef EMRMASKBLT  *PEMRMASKBLT;

/* Enhanced metafile record for PlgBlt() */
typedef struct tagEMRPLGBLT {
    EMR         emr;
    RECTL       rclBounds;
    POINTL      aptlDest[3];
    LONG        xSrc;
    LONG        ySrc;
    LONG        cxSrc;
    LONG        cySrc;
    XFORM       xformSrc;
    COLORREF    crBkColorSrc;
    DWORD       iUsageSrc;
    DWORD       offBmiSrc;
    DWORD       cbBmiSrc;
    DWORD       offBitsSrc;
    DWORD       cbBitsSrc;
    LONG        xMask;
    LONG        yMask;
    DWORD       iUsageMask;
    DWORD       offBmiMask;
    DWORD       cbBmiMask;
    DWORD       offBitsMask;
    DWORD       cbBitsMask;
} EMRPLGBLT;
typedef EMRPLGBLT   *PEMRPLGBLT;

/* Enhanced metafile record for SetDIBitsToDevice() */
typedef struct tagEMRSETDIBITSTODEVICE {
    EMR     emr;
    RECTL   rclBounds;
    LONG    xDest;
    LONG    yDest;
    LONG    xSrc;
    LONG    ySrc;
    LONG    cxSrc;
    LONG    cySrc;
    DWORD   offBmiSrc;
    DWORD   cbBmiSrc;
    DWORD   offBitsSrc;
    DWORD   cbBitsSrc;
    DWORD   iUsageSrc;
    DWORD   iStartScan;
    DWORD   cScans;
} EMRSETDIBITSTODEVICE;
typedef EMRSETDIBITSTODEVICE    *PEMRSETDIBITSTODEVICE;

/* Enhanced metafile record for StretchDIBits() */
typedef struct tagEMRSTRETCHDIBITS {
    EMR     emr;
    RECTL   rclBounds;
    LONG    xDest;
    LONG    yDest;
    LONG    xSrc;
    LONG    ySrc;
    LONG    cxSrc;
    LONG    cySrc;
    DWORD   offBmiSrc;
    DWORD   cbBmiSrc;
    DWORD   offBitsSrc;
    DWORD   cbBitsSrc;
    DWORD   iUsageSrc;
    DWORD   dwRop;
    LONG    cxDest;
    LONG    cyDest;
} EMRSTRETCHDIBITS;
typedef EMRSTRETCHDIBITS    *PEMRSTRETCHDIBITS;

/* Enhanced metafile record for CreateFontIndirectEx() */
typedef struct tagEMREXTCREATEFONTINDIRECTW {
    EMR         emr;
    DWORD       ihFont;
    EXTLOGFONTW elfw;
} EMREXTCREATEFONTINDIRECTW;
typedef EMREXTCREATEFONTINDIRECTW   *PEMREXTCREATEFONTINDIRECTW;

/* Enhanced metafile record for CreatePalette() */
typedef struct tagEMRCREATEPALETTE {
    EMR         emr;
    DWORD       ihPal;
    LOGPALETTE  lgpl;
} EMRCREATEPALETTE;
typedef EMRCREATEPALETTE    *PEMRCREATEPALETTE;

/* Enhanced metafile record for CreatePen() */
typedef struct tagEMRCREATEPEN {
    EMR     emr;
    DWORD   ihPen;
    LOGPEN  lopn;
} EMRCREATEPEN;
typedef EMRCREATEPEN    *PEMRCREATEPEN;

/* Enhanced metafile record for ExtCreatePen() */
typedef struct tagEMREXTCREATEPEN {
    EMR         emr;
    DWORD       ihPen;
    DWORD       offBmi;
    DWORD       cbBmi;
    DWORD       offBits;
    DWORD       cbBits;
    EXTLOGPEN32 elp;
} EMREXTCREATEPEN;
typedef EMREXTCREATEPEN *PEMREXTCREATEPEN;

/* Enhanced metafile record for CreateBrushIndirect() */
typedef struct tagEMRCREATEBRUSHINDIRECT {
    EMR         emr;
    DWORD       ihBrush;
    LOGBRUSH32  lb;
} EMRCREATEBRUSHINDIRECT;
typedef EMRCREATEBRUSHINDIRECT  *PEMRCREATEBRUSHINDIRECT;

/* Enhanced metafile record for creation of a monochrome brush */
typedef struct tagEMRCREATEMONOBRUSH {
    EMR     emr;
    DWORD   ihBrush;
    DWORD   iUsage;
    DWORD   offBmi;
    DWORD   cbBmi;
    DWORD   offBits;
    DWORD   cbBits;
} EMRCREATEMONOBRUSH;
typedef EMRCREATEMONOBRUSH  *PEMRCREATEMONOBRUSH;

/* Enhanced metafile record for CreateDIBPatternBrushPt() */
typedef struct tagEMRCREATEDIBPATTERNBRUSHPT {
    EMR     emr;
    DWORD   ihBrush;
    DWORD   iUsage;
    DWORD   offBmi;
    DWORD   cbBmi;
    DWORD   offBits;
    DWORD   cbBits;
} EMRCREATEDIBPATTERNBRUSHPT;
typedef EMRCREATEDIBPATTERNBRUSHPT  *PEMRCREATEDIBPATTERNBRUSHPT;

/* Enhanced metafile header */
typedef struct tagEMRFORMAT {
    DWORD   dSignature;
    DWORD   nVersion;
    DWORD   cbData;
    DWORD   offData;
} EMRFORMAT;
typedef EMRFORMAT   *PEMRFORMAT;

/* Enhanced metafile record for OpenGL commands */
#if (WINVER >= 0x0400)
typedef struct tagEMRGLSRECORD {
    EMR     emr;
    DWORD   cbData;
    BYTE    Data[1];
} EMRGLSRECORD;
typedef EMRGLSRECORD    *PEMRGLSRECORD;
#endif

/* Enhanced metafile record for bounded OpenGL commands */
#if (WINVER >= 0x0400)
typedef struct tagEMRGLSBOUNDEDRECORD {
    EMR     emr;
    RECTL   rclBounds;
    DWORD   cbData;
    BYTE    Data[1];
} EMRGLSBOUNDEDRECORD;
typedef EMRGLSBOUNDEDRECORD *PEMRGLSBOUNDEDRECORD;
#endif

/* Enhanced metafile record for pixel format commands */
#if (WINVER >= 0x0400)
typedef struct tagEMRPIXELFORMAT {
    EMR                     emr;
    PIXELFORMATDESCRIPTOR   pfd;
} EMRPIXELFORMAT;
typedef EMRPIXELFORMAT  *PEMRPIXELFORMAT;
#endif

/* Enhanced metafile record for CreateColorSpace() */
#if (WINVER >= 0x0400)
typedef struct tagEMRCREATECOLORSPACE {
    EMR             emr;
    DWORD           ihCS;
    LOGCOLORSPACEA  lcs;
} EMRCREATECOLORSPACE;
typedef EMRCREATECOLORSPACE *PEMRCREATECOLORSPACE;
#endif

/* Enhanced metafile record for SetColorSpace(), etc. */
#if (WINVER >= 0x0400)
typedef struct tagEMRSETCOLORSPACE {
    EMR     emr;
    DWORD   ihCS;
} EMRSETCOLORSPACE;
typedef EMRSETCOLORSPACE    *PEMRSETCOLORSPACE;
typedef EMRSETCOLORSPACE    EMRSELECTCOLORSPACE;
typedef EMRSETCOLORSPACE    *PEMRSELECTCOLORSPACE;
typedef EMRSETCOLORSPACE    EMRDELETECOLORSPACE;
typedef EMRSETCOLORSPACE    *PEMRDELETECOLORSPACE;
#endif

/* Enhanced metafile record for ExtEscape() and DrawEscape() */
#if (WINVER >= 0x0500)
typedef struct tagEMREXTESCAPE {
    EMR     emr;
    INT     iEscape;
    INT     cbEscData;
    BYTE    EscData[1];
} EMREXTESCAPE;
typedef EMREXTESCAPE    *PEMREXTESCAPE;
typedef EMREXTESCAPE    EMRDRAWESCAPE;
typedef EMREXTESCAPE    *PEMRDRAWESCAPE;
#endif

/* Enhanced metafile record for named escapes */
#if (WINVER >= 0x0500)
typedef struct tagEMRNAMEDESCAPE {
    EMR     emr;
    INT     iEscape;
    INT     cbDriver;
    INT     cbEscData;
    BYTE    EscData[1];
} EMRNAMEDESCAPE;
typedef EMRNAMEDESCAPE  *PEMRNAMEDESCAPE;
#endif

/* Enhanced metafile record for SetICMProfile() */
#if (WINVER >= 0x0500)
typedef struct tagEMRSETICMPROFILE {
    EMR     emr;
    DWORD   dwFlags;
    DWORD   cbName;
    DWORD   cbData;
    BYTE    Data[1];
} EMRSETICMPROFILE;
typedef EMRSETICMPROFILE    *PEMRSETICMPROFILE;
typedef EMRSETICMPROFILE    EMRSETICMPROFILEA;
typedef EMRSETICMPROFILE    *PEMRSETICMPROFILEA;
typedef EMRSETICMPROFILE    EMRSETICMPROFILEW;
typedef EMRSETICMPROFILE    *PEMRSETICMPROFILEW;
#endif

/* Enhanced metafile record for CreateColorSpaceW() */
#if (WINVER >= 0x0500)
typedef struct tagEMRCREATECOLORSPACEW {
    EMR             emr;
    DWORD           ihCS;
    LOGCOLORSPACEW  lcs;
    DWORD           dwFlags;
    DWORD           cbData;
    BYTE            Data[1];
} EMRCREATECOLORSPACEW;
typedef EMRCREATECOLORSPACEW    *PEMRCREATECOLORSPACEW;
#endif

/* Enhanced metafile record for ColorMatchToTarget() */
#if (WINVER >= 0x0500)
typedef struct tagEMRCOLORMATCHTOTARGET {
    EMR     emr;
    DWORD   dwAction;
    DWORD   dwFlags;
    DWORD   cbName;
    DWORD   cbData;
    BYTE    Data[1];
} EMRCOLORMATCHTOTARGET;
typedef EMRCOLORMATCHTOTARGET   *PEMRCOLORMATCHTOTARGET;
#endif

/* Enhanced metafile record for ColorCorrectPalette() */
#if (WINVER >= 0x0500)
typedef struct tagEMRCOLORCORRECTPALETTE {
    EMR     emr;
    DWORD   ihPalette;
    DWORD   nFirstEntry;
    DWORD   nPalEntries;
    DWORD   nReserved;
} EMRCOLORCORRECTPALETTE;
typedef EMRCOLORCORRECTPALETTE  *PEMRCOLORCORRECTPALETTE;
#endif

/* Enhanced metafile record for AlphaBlend() */
#if (WINVER >= 0x0500)
typedef struct tagEMRALPHABLEND {
    EMR         emr;
    RECTL       rclBounds;
    LONG        xDest;
    LONG        yDest;
    LONG        cxDest;
    LONG        cyDest;
    DWORD       dwRop;
    LONG        xSrc;
    LONG        ySrc;
    XFORM       xformSrc;
    COLORREF    crBkColorSrc;
    DWORD       iUsageSrc;
    DWORD       offBmiSrc;
    DWORD       cbBmiSrc;
    DWORD       offBitsSrc;
    DWORD       cbBitsSrc;
    LONG        cxSrc;
    LONG        cySrc;
} EMRALPHABLEND;
typedef EMRALPHABLEND   *PEMRALPHABLEND;
#endif

/* Enhanced metafile record for GradientFill() */
#if (WINVER >= 0x0500)
typedef struct tagEMRGRADIENTFILL {
    EMR         emr;
    RECTL       rclBounds;
    DWORD       nVer;
    DWORD       nTri;
    ULONG       ulMode;
    TRIVERTEX   Ver[1];
} EMRGRADIENTFILL;
typedef EMRGRADIENTFILL *PEMRGRADIENTFILL;
#endif

/* Enhanced metafile record for TransparentBlt() */
#if (WINVER >= 0x0500)
typedef struct tagEMRTRANSPARENTBLT {
    EMR         emr;
    RECTL       rclBounds;
    LONG        xDest;
    LONG        yDest;
    LONG        cxDest;
    LONG        cyDest;
    DWORD       dwRop;
    LONG        xSrc;
    LONG        ySrc;
    XFORM       xformSrc;
    COLORREF    crBkColorSrc;
    DWORD       iUsageSrc;
    DWORD       offBmiSrc;
    DWORD       cbBmiSrc;
    DWORD       offBitsSrc;
    DWORD       cbBitsSrc;
    LONG        cxSrc;
    LONG        cySrc;
} EMRTRANSPARENTBLT;
typedef EMRTRANSPARENTBLT   *PEMRTRANSPARENTBLT;
#endif

/* Point (floating-point version) */
typedef struct _POINTFLOAT {
    FLOAT   x;
    FLOAT   y;
} POINTFLOAT;
typedef POINTFLOAT  *PPOINTFLOAT;

/* Glyph metrics (floating-point version) */
typedef struct _GLYPHMETRICSFLOAT {
    FLOAT       gmfBlackBoxX;
    FLOAT       gmfBlackBoxY;
    POINTFLOAT  gmfptGlyphOrigin;
    FLOAT       gmfCellIncX;
    FLOAT       gmfCellIncY;
} GLYPHMETRICSFLOAT;
typedef GLYPHMETRICSFLOAT   *PGLYPHMETRICSFLOAT;
typedef GLYPHMETRICSFLOAT   *LPGLYPHMETRICSFLOAT;

/* Layer plane descriptor */
typedef struct tagLAYERPLANEDESCRIPTOR {
    WORD        nSize;
    WORD        nVersion;
    DWORD       dwFlags;
    BYTE        iPixelType;
    BYTE        cColorBits;
    BYTE        cRedBits;
    BYTE        cRedShift;
    BYTE        cGreenBits;
    BYTE        cGreenShift;
    BYTE        cBlueBits;
    BYTE        cBlueShift;
    BYTE        cAlphaBits;
    BYTE        cAlphaShift;
    BYTE        cAccumBits;
    BYTE        cAccumRedBits;
    BYTE        cAccumGreenBits;
    BYTE        cAccumBlueBits;
    BYTE        cAccumAlphaBits;
    BYTE        cDepthBits;
    BYTE        cStencilBits;
    BYTE        cAuxBuffers;
    BYTE        iLayerPlane;
    BYTE        bReserved;
    COLORREF    crTransparent;
} LAYERPLANEDESCRIPTOR;
typedef LAYERPLANEDESCRIPTOR    *PLAYERPLANEDESCRIPTOR;
typedef LAYERPLANEDESCRIPTOR    *LPLAYERPLANEDESCRIPTOR;

/* wglSwapMultipleBuffers() information */
#if (WINVER >= 0x0500)
typedef struct _WGLSWAP {
    HDC     hdc;
    UINT    uiFlags;
} WGLSWAP;
typedef WGLSWAP *PWGLSWAP;
typedef WGLSWAP *LPWGLSWAP;
#endif

/* Functions in GDI32.DLL */
WINGDIAPI int WINAPI            AbortDoc( HDC );
WINGDIAPI BOOL WINAPI           AbortPath( HDC );
WINGDIAPI int WINAPI            AddFontResourceA( LPCSTR );
WINGDIAPI int WINAPI            AddFontResourceW( LPCWSTR );
WINGDIAPI BOOL WINAPI           AngleArc( HDC, int, int, DWORD, FLOAT, FLOAT );
WINGDIAPI BOOL WINAPI           AnimatePalette( HPALETTE, UINT, UINT, CONST PALETTEENTRY * );
WINGDIAPI BOOL WINAPI           Arc( HDC, int, int, int, int, int, int, int, int );
WINGDIAPI BOOL WINAPI           ArcTo( HDC, int, int, int, int, int, int, int, int );
WINGDIAPI BOOL WINAPI           BeginPath( HDC );
WINGDIAPI BOOL WINAPI           BitBlt( HDC, int, int, int, int, HDC, int, int, DWORD );
WINGDIAPI BOOL WINAPI           CancelDC( HDC );
WINGDIAPI BOOL WINAPI           Chord( HDC, int, int, int, int, int, int, int, int );
WINGDIAPI int WINAPI            ChoosePixelFormat( HDC, CONST PIXELFORMATDESCRIPTOR * );
WINGDIAPI HENHMETAFILE WINAPI   CloseEnhMetaFile( HDC );
WINGDIAPI BOOL WINAPI           CloseFigure( HDC );
WINGDIAPI HMETAFILE WINAPI      CloseMetaFile( HDC );
WINGDIAPI int WINAPI            CombineRgn( HRGN, HRGN, HRGN, int );
WINGDIAPI BOOL WINAPI           CombineTransform( LPXFORM, CONST XFORM *, CONST XFORM * );
WINGDIAPI HENHMETAFILE WINAPI   CopyEnhMetaFileA( HENHMETAFILE, LPCSTR );
WINGDIAPI HENHMETAFILE WINAPI   CopyEnhMetaFileW( HENHMETAFILE, LPCWSTR );
WINGDIAPI HMETAFILE WINAPI      CopyMetaFileA( HMETAFILE, LPCSTR );
WINGDIAPI HMETAFILE WINAPI      CopyMetaFileW( HMETAFILE, LPCWSTR );
WINGDIAPI HBITMAP WINAPI        CreateBitmap( int, int, UINT, UINT, CONST VOID * );
WINGDIAPI HBITMAP WINAPI        CreateBitmapIndirect( CONST BITMAP * );
WINGDIAPI HBRUSH WINAPI         CreateBrushIndirect( CONST LOGBRUSH * );
WINGDIAPI HBITMAP WINAPI        CreateCompatibleBitmap( HDC, int, int );
WINGDIAPI HDC WINAPI            CreateCompatibleDC( HDC );
WINGDIAPI HDC WINAPI            CreateDCA( LPCSTR, LPCSTR, LPCSTR, CONST DEVMODEA * );
WINGDIAPI HDC WINAPI            CreateDCW( LPCWSTR, LPCWSTR, LPCWSTR, CONST DEVMODEW * );
WINGDIAPI HBRUSH WINAPI         CreateDIBPatternBrush( HGLOBAL, UINT );
WINGDIAPI HBRUSH WINAPI         CreateDIBPatternBrushPt( CONST VOID *, UINT );
WINGDIAPI HBITMAP WINAPI        CreateDIBSection( HDC, CONST BITMAPINFO *, UINT, VOID **, HANDLE, DWORD );
WINGDIAPI HBITMAP WINAPI        CreateDIBitmap( HDC, CONST BITMAPINFOHEADER *, DWORD, CONST VOID *, CONST BITMAPINFO *, UINT );
WINGDIAPI HBITMAP WINAPI        CreateDiscardableBitmap( HDC, int, int );
WINGDIAPI HRGN WINAPI           CreateEllipticRgn( int, int, int, int );
WINGDIAPI HRGN WINAPI           CreateEllipticRgnIndirect( CONST RECT * );
WINGDIAPI HDC WINAPI            CreateEnhMetaFileA( HDC, LPCSTR, CONST RECT *, LPCSTR );
WINGDIAPI HDC WINAPI            CreateEnhMetaFileW( HDC, LPCWSTR, CONST RECT *, LPCWSTR );
WINGDIAPI HFONT WINAPI          CreateFontA( int, int, int, int, int, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, LPCSTR );
WINGDIAPI HFONT WINAPI          CreateFontIndirectA( CONST LOGFONTA * );
WINGDIAPI HFONT WINAPI          CreateFontIndirectW( CONST LOGFONTW * );
WINGDIAPI HFONT WINAPI          CreateFontW( int, int, int, int, int, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, LPCWSTR );
WINGDIAPI HPALETTE WINAPI       CreateHalftonePalette( HDC );
WINGDIAPI HBRUSH WINAPI         CreateHatchBrush( int, COLORREF );
WINGDIAPI HDC WINAPI            CreateICA( LPCSTR, LPCSTR, LPCSTR, CONST DEVMODEA * );
WINGDIAPI HDC WINAPI            CreateICW( LPCWSTR, LPCWSTR, LPCWSTR, CONST DEVMODEW * );
WINGDIAPI HDC WINAPI            CreateMetaFileA( LPCSTR );
WINGDIAPI HDC WINAPI            CreateMetaFileW( LPCWSTR );
WINGDIAPI HPALETTE WINAPI       CreatePalette( CONST LOGPALETTE * );
WINGDIAPI HBRUSH WINAPI         CreatePatternBrush( HBITMAP );
WINGDIAPI HPEN WINAPI           CreatePen( int, int, COLORREF );
WINGDIAPI HPEN WINAPI           CreatePenIndirect( CONST LOGPEN * );
WINGDIAPI HRGN WINAPI           CreatePolyPolygonRgn( CONST POINT *, CONST INT *, int, int );
WINGDIAPI HRGN WINAPI           CreatePolygonRgn( CONST POINT *, int, int );
WINGDIAPI HRGN WINAPI           CreateRectRgn( int, int, int, int );
WINGDIAPI HRGN WINAPI           CreateRectRgnIndirect( CONST RECT * );
WINGDIAPI HRGN WINAPI           CreateRoundRectRgn( int, int, int, int, int, int );
WINGDIAPI BOOL WINAPI           CreateScalableFontResourceA( DWORD, LPCSTR, LPCSTR, LPCSTR );
WINGDIAPI BOOL WINAPI           CreateScalableFontResourceW( DWORD, LPCWSTR, LPCWSTR, LPCWSTR );
WINGDIAPI HBRUSH WINAPI         CreateSolidBrush( COLORREF );
WINGDIAPI BOOL WINAPI           DPtoLP( HDC, LPPOINT, int );
WINGDIAPI BOOL WINAPI           DeleteDC( HDC );
WINGDIAPI BOOL WINAPI           DeleteEnhMetaFile( HENHMETAFILE );
WINGDIAPI BOOL WINAPI           DeleteMetaFile( HMETAFILE );
WINGDIAPI BOOL WINAPI           DeleteObject( HGDIOBJ );
WINGDIAPI int WINAPI            DescribePixelFormat( HDC, int, UINT, LPPIXELFORMATDESCRIPTOR );
WINGDIAPI int WINAPI            DrawEscape( HDC, int, int, LPCSTR );
WINGDIAPI BOOL WINAPI           Ellipse( HDC, int, int, int, int );
WINGDIAPI int WINAPI            EndDoc( HDC );
WINGDIAPI int WINAPI            EndPage( HDC );
WINGDIAPI BOOL WINAPI           EndPath( HDC );
WINGDIAPI BOOL WINAPI           EnumEnhMetaFile( HDC, HENHMETAFILE, ENHMFENUMPROC, LPVOID, CONST RECT * );
WINGDIAPI int WINAPI            EnumFontFamiliesA( HDC, LPCSTR, FONTENUMPROCA, LPARAM );
WINGDIAPI int WINAPI            EnumFontFamiliesW( HDC, LPCWSTR, FONTENUMPROCW, LPARAM );
WINGDIAPI int WINAPI            EnumFontsA( HDC, LPCSTR, FONTENUMPROCA, LPARAM );
WINGDIAPI int WINAPI            EnumFontsW( HDC, LPCWSTR, FONTENUMPROCW, LPARAM );
WINGDIAPI BOOL WINAPI           EnumMetaFile( HDC, HMETAFILE, MFENUMPROC, LPARAM );
WINGDIAPI int WINAPI            EnumObjects( HDC, int, GOBJENUMPROC, LPARAM );
WINGDIAPI BOOL WINAPI           EqualRgn( HRGN, HRGN );
WINGDIAPI int WINAPI            Escape( HDC, int, int, LPCSTR, LPVOID );
WINGDIAPI int WINAPI            ExcludeClipRect( HDC, int, int, int, int );
WINGDIAPI HPEN WINAPI           ExtCreatePen( DWORD, DWORD, CONST LOGBRUSH *, DWORD, CONST DWORD * );
WINGDIAPI HRGN WINAPI           ExtCreateRegion( CONST XFORM *, DWORD, CONST RGNDATA * );
WINGDIAPI int WINAPI            ExtEscape( HDC, int, int, LPCSTR, int, LPSTR );
WINGDIAPI BOOL WINAPI           ExtFloodFill( HDC, int, int, COLORREF, UINT );
WINGDIAPI int WINAPI            ExtSelectClipRgn( HDC, HRGN, int );
WINGDIAPI BOOL WINAPI           ExtTextOutA( HDC, int, int, UINT, CONST RECT *, LPCSTR, UINT, CONST INT * );
WINGDIAPI BOOL WINAPI           ExtTextOutW( HDC, int, int, UINT, CONST RECT *, LPCWSTR, UINT, CONST INT * );
WINGDIAPI BOOL WINAPI           FillPath( HDC );
WINGDIAPI BOOL WINAPI           FillRgn( HDC, HRGN, HBRUSH );
WINGDIAPI BOOL WINAPI           FixBrushOrgEx( HDC, int, int, LPPOINT );
WINGDIAPI BOOL WINAPI           FlattenPath( HDC );
WINGDIAPI BOOL WINAPI           FloodFill( HDC, int, int, COLORREF );
WINGDIAPI BOOL WINAPI           FrameRgn( HDC, HRGN, HBRUSH, int, int );
WINGDIAPI BOOL WINAPI           GdiComment( HDC, UINT, CONST BYTE * );
WINGDIAPI BOOL WINAPI           GdiFlush();
WINGDIAPI DWORD WINAPI          GdiGetBatchLimit();
WINGDIAPI DWORD WINAPI          GdiSetBatchLimit( DWORD );
WINGDIAPI int WINAPI            GetArcDirection( HDC );
WINGDIAPI BOOL WINAPI           GetAspectRatioFilterEx( HDC, LPSIZE );
WINGDIAPI LONG WINAPI           GetBitmapBits( HBITMAP, LONG, LPVOID );
WINGDIAPI BOOL WINAPI           GetBitmapDimensionEx( HBITMAP, LPSIZE );
WINGDIAPI COLORREF WINAPI       GetBkColor( HDC );
WINGDIAPI int WINAPI            GetBkMode( HDC );
WINGDIAPI UINT WINAPI           GetBoundsRect( HDC, LPRECT, UINT );
WINGDIAPI BOOL WINAPI           GetBrushOrgEx( HDC, LPPOINT );
WINGDIAPI BOOL WINAPI           GetCharABCWidthsA( HDC, UINT, UINT, LPABC );
WINGDIAPI BOOL WINAPI           GetCharABCWidthsFloatA( HDC, UINT, UINT, LPABCFLOAT );
WINGDIAPI BOOL WINAPI           GetCharABCWidthsFloatW( HDC, UINT, UINT, LPABCFLOAT );
WINGDIAPI BOOL WINAPI           GetCharABCWidthsW( HDC, UINT, UINT, LPABC );
WINGDIAPI BOOL WINAPI           GetCharWidth32A( HDC, UINT, UINT, LPINT );
WINGDIAPI BOOL WINAPI           GetCharWidth32W( HDC, UINT, UINT, LPINT );
WINGDIAPI BOOL WINAPI           GetCharWidthA( HDC, UINT, UINT, LPINT );
WINGDIAPI BOOL WINAPI           GetCharWidthFloatA( HDC, UINT, UINT, PFLOAT );
WINGDIAPI BOOL WINAPI           GetCharWidthFloatW( HDC, UINT, UINT, PFLOAT );
WINGDIAPI BOOL WINAPI           GetCharWidthW( HDC, UINT, UINT, LPINT );
WINGDIAPI int WINAPI            GetClipBox( HDC, LPRECT );
WINGDIAPI int WINAPI            GetClipRgn( HDC, HRGN );
WINGDIAPI BOOL WINAPI           GetColorAdjustment( HDC, LPCOLORADJUSTMENT );
WINGDIAPI HGDIOBJ WINAPI        GetCurrentObject( HDC, UINT );
WINGDIAPI BOOL WINAPI           GetCurrentPositionEx( HDC, LPPOINT );
WINGDIAPI BOOL WINAPI           GetDCOrgEx( HDC, LPPOINT );
WINGDIAPI UINT WINAPI           GetDIBColorTable( HDC, UINT, UINT, RGBQUAD * );
WINGDIAPI int WINAPI            GetDIBits( HDC, HBITMAP, UINT, UINT, LPVOID, LPBITMAPINFO, UINT );
WINGDIAPI int WINAPI            GetDeviceCaps( HDC, int );
WINGDIAPI HENHMETAFILE WINAPI   GetEnhMetaFileA( LPCSTR );
WINGDIAPI UINT WINAPI           GetEnhMetaFileBits( HENHMETAFILE, UINT, LPBYTE );
WINGDIAPI UINT WINAPI           GetEnhMetaFileDescriptionA( HENHMETAFILE, UINT, LPSTR );
WINGDIAPI UINT WINAPI           GetEnhMetaFileDescriptionW( HENHMETAFILE, UINT, LPWSTR );
WINGDIAPI UINT WINAPI           GetEnhMetaFileHeader( HENHMETAFILE, UINT, LPENHMETAHEADER );
WINGDIAPI UINT WINAPI           GetEnhMetaFilePaletteEntries( HENHMETAFILE, UINT, LPPALETTEENTRY );
WINGDIAPI UINT WINAPI           GetEnhMetaFilePixelFormat( HENHMETAFILE, UINT, PIXELFORMATDESCRIPTOR * );
WINGDIAPI HENHMETAFILE WINAPI   GetEnhMetaFileW( LPCWSTR );
WINGDIAPI DWORD WINAPI          GetFontData( HDC, DWORD, DWORD, PVOID, DWORD );
WINGDIAPI DWORD WINAPI          GetGlyphOutlineA( HDC, UINT, UINT, LPGLYPHMETRICS, DWORD, LPVOID, CONST MAT2 * );
WINGDIAPI DWORD WINAPI          GetGlyphOutlineW( HDC, UINT, UINT, LPGLYPHMETRICS, DWORD, LPVOID, CONST MAT2 * );
WINGDIAPI int WINAPI            GetGraphicsMode( HDC );
WINGDIAPI DWORD WINAPI          GetKerningPairsA( HDC, DWORD, LPKERNINGPAIR );
WINGDIAPI DWORD WINAPI          GetKerningPairsW( HDC, DWORD, LPKERNINGPAIR );
WINGDIAPI int WINAPI            GetMapMode( HDC );
WINGDIAPI HMETAFILE WINAPI      GetMetaFileA( LPCSTR );
WINGDIAPI UINT WINAPI           GetMetaFileBitsEx( HMETAFILE, UINT, LPVOID );
WINGDIAPI HMETAFILE WINAPI      GetMetaFileW( LPCWSTR );
WINGDIAPI int WINAPI            GetMetaRgn( HDC, HRGN );
WINGDIAPI BOOL WINAPI           GetMiterLimit( HDC, PFLOAT );
WINGDIAPI COLORREF WINAPI       GetNearestColor( HDC, COLORREF );
WINGDIAPI UINT WINAPI           GetNearestPaletteIndex( HPALETTE, COLORREF );
WINGDIAPI int WINAPI            GetObjectA( HANDLE, int, LPVOID );
WINGDIAPI DWORD WINAPI          GetObjectType( HGDIOBJ );
WINGDIAPI int WINAPI            GetObjectW( HANDLE, int, LPVOID );
WINGDIAPI UINT WINAPI           GetOutlineTextMetricsA( HDC, UINT, LPOUTLINETEXTMETRICA );
WINGDIAPI UINT WINAPI           GetOutlineTextMetricsW( HDC, UINT, LPOUTLINETEXTMETRICW );
WINGDIAPI UINT WINAPI           GetPaletteEntries( HPALETTE, UINT, UINT, LPPALETTEENTRY );
WINGDIAPI int WINAPI            GetPath( HDC, LPPOINT, LPBYTE, int );
WINGDIAPI COLORREF WINAPI       GetPixel( HDC, int, int );
WINGDIAPI int WINAPI            GetPixelFormat( HDC );
WINGDIAPI int WINAPI            GetPolyFillMode( HDC );
WINGDIAPI int WINAPI            GetROP2( HDC );
WINGDIAPI int WINAPI            GetRandomRgn( HDC, HRGN, INT );
WINGDIAPI BOOL WINAPI           GetRasterizerCaps( LPRASTERIZER_STATUS, UINT );
WINGDIAPI DWORD WINAPI          GetRegionData( HRGN, DWORD, LPRGNDATA );
WINGDIAPI int WINAPI            GetRgnBox( HRGN, LPRECT );
WINGDIAPI HGDIOBJ WINAPI        GetStockObject( int );
WINGDIAPI int WINAPI            GetStretchBltMode( HDC );
WINGDIAPI UINT WINAPI           GetSystemPaletteEntries( HDC, UINT, UINT, LPPALETTEENTRY );
WINGDIAPI UINT WINAPI           GetSystemPaletteUse( HDC );
WINGDIAPI UINT WINAPI           GetTextAlign( HDC );
WINGDIAPI int WINAPI            GetTextCharacterExtra( HDC );
WINGDIAPI COLORREF WINAPI       GetTextColor( HDC );
WINGDIAPI BOOL WINAPI           GetTextExtentExPointA( HDC, LPCSTR, int, int, LPINT, LPINT, LPSIZE );
WINGDIAPI BOOL WINAPI           GetTextExtentExPointW( HDC, LPCWSTR, int, int, LPINT, LPINT, LPSIZE );
WINGDIAPI BOOL WINAPI           GetTextExtentPoint32A( HDC, LPCSTR, int, LPSIZE );
WINGDIAPI BOOL WINAPI           GetTextExtentPoint32W( HDC, LPCWSTR, int, LPSIZE );
WINGDIAPI BOOL WINAPI           GetTextExtentPointA( HDC, LPCSTR, int, LPSIZE );
WINGDIAPI BOOL WINAPI           GetTextExtentPointW( HDC, LPCWSTR, int, LPSIZE );
WINGDIAPI int WINAPI            GetTextFaceA( HDC, int, LPSTR );
WINGDIAPI int WINAPI            GetTextFaceW( HDC, int, LPWSTR );
WINGDIAPI BOOL WINAPI           GetTextMetricsA( HDC, LPTEXTMETRICA );
WINGDIAPI BOOL WINAPI           GetTextMetricsW( HDC, LPTEXTMETRICW );
WINGDIAPI BOOL WINAPI           GetViewportExtEx( HDC, LPSIZE );
WINGDIAPI BOOL WINAPI           GetViewportOrgEx( HDC, LPPOINT );
WINGDIAPI UINT WINAPI           GetWinMetaFileBits( HENHMETAFILE, UINT, LPBYTE, INT, HDC );
WINGDIAPI BOOL WINAPI           GetWindowExtEx( HDC, LPSIZE );
WINGDIAPI BOOL WINAPI           GetWindowOrgEx( HDC, LPPOINT );
WINGDIAPI BOOL WINAPI           GetWorldTransform( HDC, LPXFORM );
WINGDIAPI int WINAPI            IntersectClipRect( HDC, int, int, int, int );
WINGDIAPI BOOL WINAPI           InvertRgn( HDC, HRGN );
WINGDIAPI BOOL WINAPI           LPtoDP( HDC, LPPOINT, int );
WINGDIAPI BOOL WINAPI           LineDDA( int, int, int, int, LINEDDAPROC, LPARAM );
WINGDIAPI BOOL WINAPI           LineTo( HDC, int, int );
WINGDIAPI BOOL WINAPI           MaskBlt( HDC, int, int, int, int, HDC, int, int, HBITMAP, int, int, DWORD );
WINGDIAPI BOOL WINAPI           ModifyWorldTransform( HDC, CONST XFORM *, DWORD );
WINGDIAPI BOOL WINAPI           MoveToEx( HDC, int, int, LPPOINT );
WINGDIAPI int WINAPI            OffsetClipRgn( HDC, int, int );
WINGDIAPI int WINAPI            OffsetRgn( HRGN, int, int );
WINGDIAPI BOOL WINAPI           OffsetViewportOrgEx( HDC, int, int, LPPOINT );
WINGDIAPI BOOL WINAPI           OffsetWindowOrgEx( HDC, int, int, LPPOINT );
WINGDIAPI BOOL WINAPI           PaintRgn( HDC, HRGN );
WINGDIAPI BOOL WINAPI           PatBlt( HDC, int, int, int, int, DWORD );
WINGDIAPI HRGN WINAPI           PathToRegion( HDC );
WINGDIAPI BOOL WINAPI           Pie( HDC, int, int, int, int, int, int, int, int );
WINGDIAPI BOOL WINAPI           PlayEnhMetaFile( HDC, HENHMETAFILE, CONST RECT * );
WINGDIAPI BOOL WINAPI           PlayEnhMetaFileRecord( HDC, LPHANDLETABLE, CONST ENHMETARECORD *, UINT );
WINGDIAPI BOOL WINAPI           PlayMetaFile( HDC, HMETAFILE );
WINGDIAPI BOOL WINAPI           PlayMetaFileRecord( HDC, LPHANDLETABLE, LPMETARECORD, UINT );
WINGDIAPI BOOL WINAPI           PlgBlt( HDC, CONST POINT *, HDC, int, int, int, int, HBITMAP, int, int );
WINGDIAPI BOOL WINAPI           PolyBezier( HDC, CONST POINT *, DWORD );
WINGDIAPI BOOL WINAPI           PolyBezierTo( HDC, CONST POINT *, DWORD );
WINGDIAPI BOOL WINAPI           PolyDraw( HDC, CONST POINT *, CONST BYTE *, int );
WINGDIAPI BOOL WINAPI           PolyPolygon( HDC, CONST POINT *, CONST INT *, int );
WINGDIAPI BOOL WINAPI           PolyPolyline( HDC, CONST POINT *, CONST DWORD *, DWORD );
WINGDIAPI BOOL WINAPI           PolyTextOutA( HDC, CONST POLYTEXTA *, int );
WINGDIAPI BOOL WINAPI           PolyTextOutW( HDC, CONST POLYTEXTW *, int );
WINGDIAPI BOOL WINAPI           Polygon( HDC, CONST POINT *, int );
WINGDIAPI BOOL WINAPI           Polyline( HDC, CONST POINT *, int );
WINGDIAPI BOOL WINAPI           PolylineTo( HDC, CONST POINT *, DWORD );
WINGDIAPI BOOL WINAPI           PtInRegion( HRGN, int, int );
WINGDIAPI BOOL WINAPI           PtVisible( HDC, int, int );
WINGDIAPI UINT WINAPI           RealizePalette( HDC );
WINGDIAPI BOOL WINAPI           RectInRegion( HRGN, CONST RECT * );
WINGDIAPI BOOL WINAPI           RectVisible( HDC, CONST RECT * );
WINGDIAPI BOOL WINAPI           Rectangle( HDC, int, int, int, int );
WINGDIAPI BOOL WINAPI           RemoveFontResourceA( LPCSTR );
WINGDIAPI BOOL WINAPI           RemoveFontResourceW( LPCWSTR );
WINGDIAPI HDC WINAPI            ResetDCA( HDC, CONST DEVMODEA * );
WINGDIAPI HDC WINAPI            ResetDCW( HDC, CONST DEVMODEW * );
WINGDIAPI BOOL WINAPI           ResizePalette( HPALETTE, UINT );
WINGDIAPI BOOL WINAPI           RestoreDC( HDC, int );
WINGDIAPI BOOL WINAPI           RoundRect( HDC, int, int, int, int, int, int );
WINGDIAPI int WINAPI            SaveDC( HDC );
WINGDIAPI BOOL WINAPI           ScaleViewportExtEx( HDC, int, int, int, int, LPSIZE );
WINGDIAPI BOOL WINAPI           ScaleWindowExtEx( HDC, int, int, int, int, LPSIZE );
WINGDIAPI BOOL WINAPI           SelectClipPath( HDC, int );
WINGDIAPI int WINAPI            SelectClipRgn( HDC, HRGN );
WINGDIAPI HGDIOBJ WINAPI        SelectObject( HDC, HGDIOBJ );
WINGDIAPI HPALETTE WINAPI       SelectPalette( HDC, HPALETTE, BOOL );
WINGDIAPI int WINAPI            SetAbortProc( HDC, ABORTPROC );
WINGDIAPI int WINAPI            SetArcDirection( HDC, int );
WINGDIAPI LONG WINAPI           SetBitmapBits( HBITMAP, DWORD, CONST VOID * );
WINGDIAPI BOOL WINAPI           SetBitmapDimensionEx( HBITMAP, int, int, LPSIZE );
WINGDIAPI COLORREF WINAPI       SetBkColor( HDC, COLORREF );
WINGDIAPI int WINAPI            SetBkMode( HDC, int );
WINGDIAPI UINT WINAPI           SetBoundsRect( HDC, CONST RECT *, UINT );
WINGDIAPI BOOL WINAPI           SetBrushOrgEx( HDC, int, int, LPPOINT );
WINGDIAPI BOOL WINAPI           SetColorAdjustment( HDC, CONST COLORADJUSTMENT * );
WINGDIAPI UINT WINAPI           SetDIBColorTable( HDC, UINT, UINT, CONST RGBQUAD * );
WINGDIAPI int WINAPI            SetDIBits( HDC, HBITMAP, UINT, UINT, CONST VOID *, CONST BITMAPINFO *, UINT );
WINGDIAPI int WINAPI            SetDIBitsToDevice( HDC, int, int, DWORD, DWORD, int, int, UINT, UINT, CONST VOID *, CONST BITMAPINFO *, UINT);
WINGDIAPI HENHMETAFILE WINAPI   SetEnhMetaFileBits( UINT, CONST BYTE * );
WINGDIAPI int WINAPI            SetGraphicsMode( HDC, int );
WINGDIAPI int WINAPI            SetMapMode( HDC, int );
WINGDIAPI DWORD WINAPI          SetMapperFlags( HDC, DWORD );
WINGDIAPI HMETAFILE WINAPI      SetMetaFileBitsEx( UINT, CONST BYTE * );
WINGDIAPI int WINAPI            SetMetaRgn( HDC );
WINGDIAPI BOOL WINAPI           SetMiterLimit( HDC, FLOAT, PFLOAT );
WINGDIAPI UINT WINAPI           SetPaletteEntries( HPALETTE, UINT, UINT, CONST PALETTEENTRY * );
WINGDIAPI COLORREF WINAPI       SetPixel( HDC, int, int, COLORREF );
WINGDIAPI BOOL WINAPI           SetPixelFormat( HDC, int, CONST PIXELFORMATDESCRIPTOR * );
WINGDIAPI BOOL WINAPI           SetPixelV( HDC, int, int, COLORREF );
WINGDIAPI int WINAPI            SetPolyFillMode( HDC, int );
WINGDIAPI int WINAPI            SetROP2( HDC, int );
WINGDIAPI BOOL WINAPI           SetRectRgn( HRGN, int, int, int, int );
WINGDIAPI int WINAPI            SetStretchBltMode( HDC, int );
WINGDIAPI UINT WINAPI           SetSystemPaletteUse( HDC, UINT );
WINGDIAPI UINT WINAPI           SetTextAlign( HDC, UINT );
WINGDIAPI int WINAPI            SetTextCharacterExtra( HDC, int );
WINGDIAPI COLORREF WINAPI       SetTextColor( HDC, COLORREF );
WINGDIAPI BOOL WINAPI           SetTextJustification( HDC, int, int );
WINGDIAPI BOOL WINAPI           SetViewportExtEx( HDC, int, int, LPSIZE );
WINGDIAPI BOOL WINAPI           SetViewportOrgEx( HDC, int, int, LPPOINT );
WINGDIAPI HENHMETAFILE WINAPI   SetWinMetaFileBits( UINT, CONST BYTE *, HDC, CONST METAFILEPICT * );
WINGDIAPI BOOL WINAPI           SetWindowExtEx( HDC, int, int, LPSIZE );
WINGDIAPI BOOL WINAPI           SetWindowOrgEx( HDC, int, int, LPPOINT );
WINGDIAPI BOOL WINAPI           SetWorldTransform( HDC, CONST XFORM * );
WINGDIAPI int WINAPI            StartDocA( HDC, CONST DOCINFOA * );
WINGDIAPI int WINAPI            StartDocW( HDC, CONST DOCINFOW * );
WINGDIAPI int WINAPI            StartPage( HDC );
WINGDIAPI BOOL WINAPI           StretchBlt( HDC, int, int, int, int, HDC, int, int, int, int, DWORD );
WINGDIAPI int WINAPI            StretchDIBits( HDC, int, int, int, int, int, int, int, int, CONST VOID *, CONST BITMAPINFO *, UINT, DWORD );
WINGDIAPI BOOL WINAPI           StrokeAndFillPath( HDC );
WINGDIAPI BOOL WINAPI           StrokePath( HDC );
WINGDIAPI BOOL WINAPI           SwapBuffers( HDC );
WINGDIAPI BOOL WINAPI           TextOutA( HDC, int, int, LPCSTR, int );
WINGDIAPI BOOL WINAPI           TextOutW( HDC, int, int, LPCWSTR, int );
WINGDIAPI BOOL WINAPI           UnrealizeObject( HGDIOBJ );
WINGDIAPI BOOL WINAPI           UpdateColors( HDC );
WINGDIAPI BOOL WINAPI           WidenPath( HDC );
#if (WINVER >= 0x0400)
WINGDIAPI BOOL WINAPI           CheckColorsInGamut( HDC, LPVOID, LPVOID, DWORD );
WINGDIAPI BOOL WINAPI           ColorMatchToTarget( HDC, HDC, DWORD );
WINGDIAPI HCOLORSPACE WINAPI    CreateColorSpaceA( LPLOGCOLORSPACEA );
WINGDIAPI HCOLORSPACE WINAPI    CreateColorSpaceW( LPLOGCOLORSPACEW );
WINGDIAPI BOOL WINAPI           DeleteColorSpace( HCOLORSPACE );
WINGDIAPI int WINAPI            EnumFontFamiliesExA( HDC, LPLOGFONTA, FONTENUMPROCA, LPARAM, DWORD );
WINGDIAPI int WINAPI            EnumFontFamiliesExW( HDC, LPLOGFONTW, FONTENUMPROCW, LPARAM, DWORD );
WINGDIAPI int WINAPI            EnumICMProfilesA( HDC, ICMENUMPROCA, LPARAM );
WINGDIAPI int WINAPI            EnumICMProfilesW( HDC, ICMENUMPROCW, LPARAM );
WINGDIAPI DWORD WINAPI          GetCharacterPlacementA( HDC, LPCSTR, int, int, LPGCP_RESULTSA, DWORD );
WINGDIAPI DWORD WINAPI          GetCharacterPlacementW( HDC, LPCWSTR, int, int, LPGCP_RESULTSW, DWORD );
WINGDIAPI HCOLORSPACE WINAPI    GetColorSpace( HDC );
WINGDIAPI BOOL WINAPI           GetDeviceGammaRamp( HDC, LPVOID );
WINGDIAPI DWORD WINAPI          GetFontLanguageInfo( HDC );
WINGDIAPI BOOL WINAPI           GetICMProfileA( HDC, LPDWORD, LPSTR );
WINGDIAPI BOOL WINAPI           GetICMProfileW( HDC, LPDWORD, LPWSTR );
WINGDIAPI BOOL WINAPI           GetLogColorSpaceA( HCOLORSPACE, LPLOGCOLORSPACEA );
WINGDIAPI BOOL WINAPI           GetLogColorSpaceW( HCOLORSPACE, LPLOGCOLORSPACEW );
WINGDIAPI int WINAPI            GetTextCharset( HDC );
WINGDIAPI int WINAPI            GetTextCharsetInfo( HDC, LPFONTSIGNATURE, DWORD );
WINGDIAPI HCOLORSPACE WINAPI    SetColorSpace( HDC, HCOLORSPACE );
WINGDIAPI BOOL WINAPI           SetDeviceGammaRamp( HDC, LPVOID );
WINGDIAPI int WINAPI            SetICMMode( HDC, int );
WINGDIAPI BOOL WINAPI           SetICMProfileA( HDC, LPSTR );
WINGDIAPI BOOL WINAPI           SetICMProfileW( HDC, LPWSTR );
WINGDIAPI BOOL WINAPI           TranslateCharsetInfo( DWORD *, LPCHARSETINFO, DWORD );
WINGDIAPI BOOL WINAPI           UpdateICMRegKeyA( DWORD, LPSTR, LPSTR, UINT );
WINGDIAPI BOOL WINAPI           UpdateICMRegKeyW( DWORD, LPWSTR, LPWSTR, UINT );
#endif
#if (WINVER >= 0x0500)
WINGDIAPI BOOL WINAPI           ColorCorrectPalette( HDC, HPALETTE, DWORD, DWORD );
WINGDIAPI DWORD WINAPI          GetLayout( HDC );
WINGDIAPI DWORD WINAPI          SetLayout( HDC, DWORD );
#endif
#if (_WIN32_WINNT >= 0x0500)
WINGDIAPI HANDLE WINAPI         AddFontMemResourceEx( PVOID, DWORD, PVOID, DWORD * );
WINGDIAPI int WINAPI            AddFontResourceExA( LPCSTR, DWORD, PVOID );
WINGDIAPI int WINAPI            AddFontResourceExW( LPCWSTR, DWORD, PVOID );
WINGDIAPI HFONT WINAPI          CreateFontIndirectExA( CONST ENUMLOGFONTEXDVA * );
WINGDIAPI HFONT WINAPI          CreateFontIndirectExW( CONST ENUMLOGFONTEXDVW * );
WINGDIAPI BOOL WINAPI           GdiAlphaBlend( HDC, int, int, int, int, HDC, int, int, int, int, BLENDFUNCTION );
WINGDIAPI BOOL WINAPI           GdiGradientFill( HDC, PTRIVERTEX, ULONG, PVOID, ULONG, ULONG );
WINGDIAPI BOOL WINAPI           GdiTransparentBlt( HDC, int, int, int, int, HDC, int, int, int, int, UINT );
WINGDIAPI BOOL WINAPI           GetCharABCWidthsI( HDC, UINT, UINT, LPWORD, LPABC );
WINGDIAPI BOOL WINAPI           GetCharWidthI( HDC, UINT, UINT, LPWORD, LPINT );
WINGDIAPI COLORREF WINAPI       GetDCBrushColor( HDC );
WINGDIAPI COLORREF WINAPI       GetDCPenColor( HDC );
WINGDIAPI DWORD WINAPI          GetFontUnicodeRanges( HDC, LPGLYPHSET );
WINGDIAPI DWORD WINAPI          GetGlyphIndicesA( HDC, LPCSTR, int, LPWORD, DWORD );
WINGDIAPI DWORD WINAPI          GetGlyphIndicesW( HDC, LPCWSTR, int, LPWORD, DWORD );
WINGDIAPI BOOL WINAPI           GetTextExtentExPointI( HDC, LPWORD, int, int, LPINT, LPINT, LPSIZE );
WINGDIAPI BOOL WINAPI           GetTextExtentPointI( HDC, LPWORD, int, LPSIZE );
WINGDIAPI BOOL WINAPI           RemoveFontMemResourceEx( HANDLE );
WINGDIAPI BOOL WINAPI           RemoveFontResourceExA( LPCSTR, DWORD, PVOID );
WINGDIAPI BOOL WINAPI           RemoveFontResourceExW( LPCWSTR, DWORD, PVOID );
WINGDIAPI COLORREF WINAPI       SetDCBrushColor( HDC, COLORREF );
WINGDIAPI COLORREF WINAPI       SetDCPenColor( HDC, COLORREF );
#endif

/* Functions in MSIMG32.DLL */
#if (WINVER >= 0x0400)
WINGDIAPI BOOL WINAPI   AlphaBlend( HDC, int, int, int, int, HDC, int, int, int, int, BLENDFUNCTION );
WINGDIAPI BOOL WINAPI   GradientFill( HDC, PTRIVERTEX, ULONG, PVOID, ULONG, ULONG );
WINGDIAPI BOOL WINAPI   TransparentBlt( HDC, int, int, int, int, HDC, int, int, int, int, UINT );
#endif

/* Functions in OPENGL32.DLL */
WINGDIAPI BOOL WINAPI   wglCopyContext( HGLRC, HGLRC, UINT );
WINGDIAPI HGLRC WINAPI  wglCreateContext( HDC );
WINGDIAPI HGLRC WINAPI  wglCreateLayerContext( HDC, int );
WINGDIAPI BOOL WINAPI   wglDeleteContext( HGLRC );
WINGDIAPI BOOL WINAPI   wglDescribeLayerPlane( HDC, int, int, UINT, LPLAYERPLANEDESCRIPTOR );
WINGDIAPI HGLRC WINAPI  wglGetCurrentContext( VOID );
WINGDIAPI HDC WINAPI    wglGetCurrentDC( VOID );
WINGDIAPI int WINAPI    wglGetLayerPaletteEntries( HDC, int, int, int, COLORREF * );
WINGDIAPI PROC WINAPI   wglGetProcAddress( LPCSTR );
WINGDIAPI BOOL WINAPI   wglMakeCurrent( HDC, HGLRC );
WINGDIAPI BOOL WINAPI   wglRealizeLayerPalette( HDC, int, BOOL );
WINGDIAPI int WINAPI    wglSetLayerPaletteEntries( HDC, int, int, int, CONST COLORREF * );
WINGDIAPI BOOL WINAPI   wglShareLists( HGLRC, HGLRC );
WINGDIAPI BOOL WINAPI   wglSwapLayerBuffers( HDC, UINT );
WINGDIAPI BOOL WINAPI   wglUseFontBitmapsA( HDC, DWORD, DWORD, DWORD );
WINGDIAPI BOOL WINAPI   wglUseFontBitmapsW( HDC, DWORD, DWORD, DWORD );
WINGDIAPI BOOL WINAPI   wglUseFontOutlinesA( HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT );
WINGDIAPI BOOL WINAPI   wglUseFontOutlinesW( HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT );
#if (WINVER >= 0x0500)
WINGDIAPI DWORD WINAPI  wglSwapMultipleBuffers( UINT, CONST WGLSWAP * );
#endif

/* Functions in WINSPOOL.DRV */
WINSPOOLAPI int WINAPI  DeviceCapabilitiesA( LPCSTR, LPCSTR, WORD, LPSTR, CONST DEVMODEA * );
WINSPOOLAPI int WINAPI  DeviceCapabilitiesW( LPCWSTR, LPCWSTR, WORD, LPWSTR, CONST DEVMODEW * );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define AddFontResource             AddFontResourceW
    #define CopyEnhMetaFile             CopyEnhMetaFileW
    #define CopyMetaFile                CopyMetaFileW
    #define CreateDC                    CreateDCW
    #define CreateEnhMetaFile           CreateEnhMetaFileW
    #define CreateFont                  CreateFontW
    #define CreateFontIndirect          CreateFontIndirectW
    #define CreateIC                    CreateICW
    #define CreateMetaFile              CreateMetaFileW
    #define CreateScalableFontResource  CreateScalableFontResourceW
    #define DeviceCapabilities          DeviceCapabilitiesW
    #define EnumFontFamilies            EnumFontFamiliesW
    #define EnumFonts                   EnumFontsW
    #define ExtTextOut                  ExtTextOutW
    #define GetCharABCWidths            GetCharABCWidthsW
    #define GetCharABCWidthsFloat       GetCharABCWidthsFloatW
    #define GetCharWidth                GetCharWidthW
    #define GetCharWidth32              GetCharWidth32W
    #define GetCharWidthFloat           GetCharWidthFloatW
    #define GetEnhMetaFile              GetEnhMetaFileW
    #define GetEnhMetaFileDescription   GetEnhMetaFileDescriptionW
    #define GetGlyphOutline             GetGlyphOutlineW
    #define GetKerningPairs             GetKerningPairsW
    #define GetMetaFile                 GetMetaFileW
    #define GetObject                   GetObjectW
    #define GetOutlineTextMetrics       GetOutlineTextMetricsW
    #define GetTextExtentExPoint        GetTextExtentExPointW
    #define GetTextExtentPoint          GetTextExtentPointW
    #define GetTextExtentPoint32        GetTextExtentPoint32W
    #define GetTextFace                 GetTextFaceW
    #define GetTextMetrics              GetTextMetricsW
    #define PolyTextOut                 PolyTextOutW
    #define RemoveFontResource          RemoveFontResourceW
    #define ResetDC                     ResetDCW
    #define StartDoc                    StartDocW
    #define TextOut                     TextOutW
    #define wglUseFontBitmaps           wglUseFontBitmapsW
    #define wglUseFontOutlines          wglUseFontOutlinesW
    #if (WINVER >= 0x0400)
        #define CreateColorSpace        CreateColorSpaceW
        #define EnumFontFamiliesEx      EnumFontFamiliesExW
        #define EnumICMProfiles         EnumICMProfilesW
        #define GetCharacterPlacement   GetCharacterPlacementW
        #define GetICMProfile           GetICMProfileW
        #define GetLogColorSpace        GetLogColorSpaceW
        #define SetICMProfile           SetICMProfileW
        #define UpdateICMRegKey         UpdateICMRegKeyW
    #endif
    #if (_WIN32_WINNT >= 0x0500)
        #define AddFontResourceEx       AddFontResourceExW
        #define CreateFontIndirectEx    CreateFontIndirectExW
        #define GetGlyphIndices         GetGlyphIndicesW
        #define RemoveFontResourceEx    RemoveFontResourceExW
    #endif
#else
    #define AddFontResource             AddFontResourceA
    #define CopyEnhMetaFile             CopyEnhMetaFileA
    #define CopyMetaFile                CopyMetaFileA
    #define CreateDC                    CreateDCA
    #define CreateEnhMetaFile           CreateEnhMetaFileA
    #define CreateFont                  CreateFontA
    #define CreateFontIndirect          CreateFontIndirectA
    #define CreateIC                    CreateICA
    #define CreateMetaFile              CreateMetaFileA
    #define CreateScalableFontResource  CreateScalableFontResourceA
    #define DeviceCapabilities          DeviceCapabilitiesA
    #define EnumFontFamilies            EnumFontFamiliesA
    #define EnumFonts                   EnumFontsA
    #define ExtTextOut                  ExtTextOutA
    #define GetCharABCWidths            GetCharABCWidthsA
    #define GetCharABCWidthsFloat       GetCharABCWidthsFloatA
    #define GetCharWidth                GetCharWidthA
    #define GetCharWidth32              GetCharWidth32A
    #define GetCharWidthFloat           GetCharWidthFloatA
    #define GetEnhMetaFile              GetEnhMetaFileA
    #define GetEnhMetaFileDescription   GetEnhMetaFileDescriptionA
    #define GetGlyphOutline             GetGlyphOutlineA
    #define GetKerningPairs             GetKerningPairsW
    #define GetMetaFile                 GetMetaFileA
    #define GetObject                   GetObjectA
    #define GetOutlineTextMetrics       GetOutlineTextMetricsA
    #define GetTextExtentExPoint        GetTextExtentExPointA
    #define GetTextExtentPoint          GetTextExtentPointA
    #define GetTextExtentPoint32        GetTextExtentPoint32A
    #define GetTextFace                 GetTextFaceA
    #define GetTextMetrics              GetTextMetricsA
    #define PolyTextOut                 PolyTextOutA
    #define RemoveFontResource          RemoveFontResourceA
    #define ResetDC                     ResetDCA
    #define StartDoc                    StartDocA
    #define TextOut                     TextOutA
    #define wglUseFontBitmaps           wglUseFontBitmapsA
    #define wglUseFontOutlines          wglUseFontOutlinesA
    #if (WINVER >= 0x0400)
        #define CreateColorSpace        CreateColorSpaceA
        #define EnumFontFamiliesEx      EnumFontFamiliesExA
        #define EnumICMProfiles         EnumICMProfilesA
        #define GetCharacterPlacement   GetCharacterPlacementA
        #define GetICMProfile           GetICMProfileA
        #define GetLogColorSpace        GetLogColorSpaceA
        #define SetICMProfile           SetICMProfileA
        #define UpdateICMRegKey         UpdateICMRegKeyA
    #endif
    #if (_WIN32_WINNT >= 0x0500)
        #define AddFontResourceEx       AddFontResourceExA
        #define CreateFontIndirectEx    CreateFontIndirectExA
        #define GetGlyphIndices         GetGlyphIndicesA
        #define RemoveFontResourceEx    RemoveFontResourceExA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINGDI_ */
