comment |
=======================================
Driver management: existing upper DOS
Memory merged as UMBs.
=======================================
Compiled as EXE Binary using
 TASM /t /q /m5 /z %1
 TLINK /x /e %1
 DEL %1.OBJ
=======================================
(C) 1992-2002 by JVP (info@jvp.de)
=======================================
Source released under following License
=======================================

Modified BSD license

Redistribution and use of source and binary forms, with or without
modification, are permitted provided the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
|
;==================
; Types + Constants
;==================
ReqHdr          struc
                db      2 dup (?)
Cmd             db      ?
Status          dw      ?
                dd      2 dup (?)
                db      ?
BrkOfs          dw      ?
BrkSeg          dw      ?
CmdLnPtr        dd      ?
                dw      ?
ReqHdr          ends
; for Port I/O
Delay           macro
local           @@Lbl1, @@Lbl2
                nop
                jmp     short @@Lbl1
@@Lbl1:         nop
                jmp     short @@Lbl2
@@Lbl2:         nop
endm
; auf nchste Segmentgrenze legen
Align16         macro
local           Pos
Pos             equ     $
                org     Pos + (16-((Pos-DevHdr) and 15) and 15)
endm
cVersion        equ     '1.9'                   ; max. 3-stellig
cValidROM       =       0AA55h                  ; ROM-BIOS-Kennung
cRAM            =       ''                     ; Tabelleneintrag RAM
cROM            =       ''                     ;       -"-       ROM
cVideo          =       ''                     ;       -"-       VideoRAM
cEMS            =       ''                     ;       -"-       EMS Page Frame
cEmpty          =       ''                     ;       -"-       unbenutzt
cExclude        =       'X'                     ;       -"-       excluded
cDRDOS          =       7
cMSDOS          =       8
                locals
                .model  tiny
                .code
                org     0
;=====================
; Device Driver Header
;=====================
DevHdr          dd      -1                      ; Nur ein Driver
                dw      1000000000000000b       ; Character-Device
Stra            dw      StrategyProc            ; Strategy-Routine
Entr            dw      EntryProc               ; Einsprungadresse
PrgTitle$       db      'HiRAM', cVersion
;===============================================
; Int 2Fh Handler for DR-DOS 5.0/6.0
;===============================================
; Aufruf:  AX = 12FFh
;          BX = 6
; Liefert: AX = 0 => OK
;          BX = 0 (for DRDOS reserved Video RAM)
;          CX = 0 (from DRDOS used Video RAM)
;          DX = erstes Segment des oberen RAMs
;===============================================
DRDOSInt2Fh     proc    far
                db      "JVP'93"                ; nur zum Auffllen
                cmp     AX, 12FFh               ; DRDOS Handler ?
                jne     @@JmpOldInt             ;   nein ->
                cmp     BX, 6                   ; UMB-Funktionen ?
                jne     @@JmpOldInt             ;   nein ->
                or      CX, CX                  ; Get UMB Link ?
                jnz     @@NotFunc0              ;   nein ->
                xor     BX, BX                  ; for DRDOS reserved VideoRAM
; ist schon 0   xor     CX, CX                  ; from DRDOS used VideoRAM
                mov     DX, 0000h               ; 1st UMB-Segment wird
DRUpperSeg2:    jmp     short @@Ret             ;   for "0000h" eingetragen!
@@NotFunc0:     mov     AX, 1
                cmp     CX, 2                   ; Get/Set Video Link ?
                jae     @@ErrRet                ;   nein ->
                mov     AL, 82h                 ; Fehler, AH ist schon 0
                xchg    AX, CX
@@Ret:          xor     AX, AX
@@ErrRet:       retf    2
@@JmpOldInt:    db      0EAh
DROldInt2Fh     dd      0F0F0F0F0h
DRDOSInt2Fh     endp
DRDOSInt2FhEnd  label   byte
DRInt2FhLen     equ     DRDOSInt2FhEnd-DRDOSInt2Fh
DRInt2FhParas   equ     (DRInt2FhLen+15)/16
DRUpperSeg      equ     word ptr [(offset DRUpperSeg2)-2]
;==============================================
; Int 2Fh Handler for MSDOS 5.0
;==============================================
; Aufruf:  1) AX = 4300h
;          2) AX = 4310h
; Liefert: 1) AL = 80h (= installiert)
;          2) ES:BX -> XMS-Einsprungpunkt
;==============================================
MSDOSInt2Fh     proc    far
                db      "JVP'93"                ; nur zum Auffllen
                cmp     AH, 43h                 ; XMS-Funktionen ?
                jne     @@JmpOldInt             ;   nein ->
                or      AL, AL                  ; Fkt. 0 Installationstest ?
                jz      @@Func0                 ;   ja ->
                cmp     AL, 10h                 ; Fkt. 10 Get Address ?
                je      @@Func10                ;   ja ->
@@JmpOldInt:    db      0EAh
MSOldInt2Fh     dd      0F0F0F0F0h
@@Func0:        mov     AL, 10000000b           ; OK, installiert
                iret
@@Func10:       push    CS                      ; ES:BX -> Einsprungpunkt
                pop     ES
                mov     BX, (@@XMSEntry-MSDOSInt2Fh)
                iret
;=======================================================
; Temporary XMS-Handler (only Get Version / Request UMB)
;=======================================================
@@XMSEntry:     pushf
                or      AH, AH                  ; Fkt. 0 Get XMS Version ?
                je      @@XMSFunc0              ;   ja ->

                cmp     AH, 10h                 ; Fkt. 10 Request UMB ?
                je      @@XMSFunc10             ;   ja ->
                xor     AX, AX                  ; kein Erfolg
                mov     BL, 10000000b           ; nicht implementiert
                popf
                retf

;================
; Get XMS Version
;================
@@XMSFunc0:     mov     AX, 0200h               ; Versionsnummer
                mov     BX, AX                  ; Revisionsnummer
                xor     DX, DX                  ; keine HMA verfgbar
                popf
                retf
;============
; Request UMB
;============
@@XMSFunc10:    push    DS
                push    CX
                xor     BX, BX
                xor     CX, CX                  ; Default-Gre: 0
                mov     AX, 0000h               ; erstes UMB-Segment wird
MSUpperSeg2:    mov     DS, AX                  ;   fr "0000h" eingetragen!
                inc     AX                      ; 1 Segment weiter fr (*)
                cmp     [BX+1], BX              ; Block frei ?
                jne     @@NextSeg               ;   nein ->
                cmp     CX, [BX+3]              ; Block-Gre gltig ?
                jae     @@NextSeg               ;   nein ->
                mov     CX, [BX+3]              ; Block-Gre
                cmp     CX, DX                  ;   zu klein ?
                jb      @@NextSeg               ;     ja ->
                inc     BX                      ; BX := 1
                mov     [BX], AX                ; Owner-Segment eintragen
                xchg    AX, BX                  ; AX := 1 (OK), BX := Segment
@@XMSRet:       mov     DX, CX                  ; Segment-Gre
                pop     CX
                pop     DS
                popf
                retf
@@NextSeg:      add     AX, [BX+3]              ; Lnge addieren (*)
                cmp     byte ptr [BX], 'Z'      ; letzter MCB ?
                jne     short MSUpperSeg2       ;   nein, weitersuchen ->
@@LastUMB:      cmp     CX, BX                  ; grter UMB > 0 ?
                ja      @@SmallerUMB            ;   ja ->
                lds     DX, CS:[(MSOldInt2Fh-MSDOSInt2Fh)]
                mov     AX, 252Fh               ; Int2Fh-Handler wird jetzt
                int     21h                     ;   nicht mehr bentigt
                inc     BX                      ; keine UMBs verfgbar (0B1h)
@@SmallerUMB:   xor     AX, AX                  ; Aufruf ohne Erfolg
                or      BL, 0B0h                ; kleinerer UMB verfgbar
                jmp     short @@XMSRet
MSDOSInt2Fh     endp
MSDOSInt2FhEnd  label   byte
MSInt2FhLen     equ     MSDOSInt2FhEnd-MSDOSInt2Fh
MSInt2FhParas   equ     (MSInt2FhLen+15)/16
MSUpperSeg      equ     word ptr [(offset MSUpperSeg2)-2]
;================================
; Initialization of Device Driver
;================================
EntryProc       proc    far
                push    AX
                push    BX
                push    DS
                push    ES
                push    CS
                pop     DS
                les     BX, Req
                mov     AL, ES:BX[Cmd]
                or      AL, AL                  ; Funktion 0 ?
                jnz     @@Error                 ;   nein, Fehler ->
                mov     word ptr ES:BX[BrkOfs], 0
                mov     ES:BX[BrkSeg], CS
                call    Init                    ; Initialisieren
                mov     AX, 0100h               ; OK-Flag
                jnc     @@Ret                   ;   OK ->
@@Error:        mov     AX, 8103h
@@Ret:          mov     word ptr ES:BX[Status], AX
                pop     ES
                pop     DS
                pop     BX
                pop     AX
                ret
EntryProc       endp
;==================================
; Strategy Routine of Device Driver
;==================================
StrategyProc    proc    far                     ; Strategy-Routine
                mov     word ptr CS:[Req],BX    ; BX speichern
                mov     word ptr CS:[Req+2],ES  ; ES speichern
                ret                             ; ...Fertig
StrategyProc    endp
Title$          db      13, 10, 'HiRAM V', cVersion, 'a  Copyright (C) 1992-2002 by JVP (info@jvp.de).', 0
Help$           db      'Bindet vorhandene RAM-Bereiche (Zusatzspeicherkarten, Shadow-RAM etc.)', 13, 10
                db      'zwischen den Segmenten A000h und F000h in die DOS-Speicherverwaltung ein.', 13, 10, 10
                db      'Aufruf in CONFIG.SYS mit', 13, 10
                db      '   DEVICE=HiRAM.EXE [/option [/option [...]]]', 13, 10, 10
                db      'option steht fr:', 13, 10
                db      '   Debug       verhindert die Installation und zeigt nur Speicherinfos.', 13, 10
                db      '   Exclude=start-ende[,start-ende] schliet Bereich(e) vom RAM-Test aus.', 13, 10
;                db      '   Include=start-ende[,start-ende] fgt Bereich(e) dem RAM-Test hinzu.', 13, 10
                db      '   FixMSDOS    initialisiert den Zusatzspeicher nach Art von MS-DOS 5.0.', 13, 10
                db      '   FixDRDOS    initialisiert den Zusatzspeicher nach Art von DR-DOS 5.0/6.0.', 13, 10
                db      '   Chain       verbindet konventionellen und Zusatzspeicher.', 13, 10
                db      '   NoChain     hlt konventionellen und Zusatzspeicher getrennt.', 13, 10
                db      '   Int2F       installiert den jeweiligen Int 2Fh Handler fr MS- bzw. DR-DOS.', 13, 10
                db      '   NoInt2F     verhindert die Installation eines Int 2Fh Handlers.', 13, 10
                db      'Voreingestellt sind fr', 13, 10
                db      '   MS-DOS 3.x - 4.0x:  /FixMSDOS /Chain /NoInt2F,', 13, 10
                db      '   MS-DOS 5.x:         /FixMSDOS /NoChain /Int2F,', 13, 10
                db      '   DR-DOS 3.41:        /FixMSDOS /Chain /NoInt2F,', 13, 10
                db      '   DR-DOS 5.0 - 6.0:   /FixDRDOS /Chain /Int2F,', 13, 10
                db      'diese Optionen brauchen also nicht jeweils explizit angegeben werden.', 13, 10, 10
                db      'Speichertest mit [Taste], Ende mit [ESC] ... ', 0
;Already$        db      'FEHLER: Es ist bereits ein Upper Memory Treiber installiert.', 13, 10
;                db      '        Programm nicht installiert.', 0
NotInst$        db      'FEHLER: Kein oberer Speicher gefunden.', 13, 10
NotInst2$       db      '        Programm nicht installiert.', 0
DOSErr$         db      'FEHLER: MS-DOS ab Version 3.0 oder DR-DOS ab Version 3.41 erforderlich!', 13, 10
                db      '        Programm nicht installiert.', 0
;EMM386Warn$     db      'WARNUNG: Mit CPUs 386/486 sollte EMM386.'
;EMMEXE$         db      'EXE eingesetzt werden.', 0
DOSWarn$        db      'WARNUNG: Das aktuelle Betriebssystem untersttzt nicht das Hochladen.', 0
Exclude$        db      'WARNUNG: Falscher /EXCLUDE-Parameter wird ignoriert.', 0
;Include$        db      'WARNUNG: Falscher /INCLUDE-Parameter wird ignoriert.', 0
MemManager$     db      'WARNUNG: Es ist bereits ein Speichermanager installiert!', 13, 10
                db      '         Treiber trotzdem installieren (J/N) ? ', 0
Inst$           db      'Programm installiert.', 0
YesNo$          db      'j', 0
Req             dd      0                       ; Device Driver Request
XMSCtrl         dd      0                       ; FAR-Call-Adresse XMS-Handler
HMAAvail        dw      -1                      ; -1=HMA existiert nicht
                                                ;  0=HMA ex., aber nicht genutzt
                                                ;  1=HMA ex. und genutzt
UpperSeg        dw      0
FirstMCB        dw      0                       ; Segment des 1. MCB
WhichDOS        dw      cMSDOS                  ; DRDOS/MSDOS
DOSVersion      dw      031Fh                   ; 3.31
ChainFlag       db      0                       ; -1 = Upper Memory einbinden
DR2FhFlag       db      0                       ; -1 = DRDOS Int2Fh Handler
MS2FhFlag       db      0                       ; -1 = MSDOS Int2Fh Handler
DebugFlag       db      0                       ; -1 = nur Sp.Test, keine Inst.
ExcludeWarn     db      0                       ; <> 0 = falscher Exclude-Parm.
;IncludeWarn     db      0                       ; <> 0 = falscher Include-Parm.
HexB$           db      '0123456789ABCDEF'
UMBName         dw      offset MSDOSName$
MSDOSName$      db      0, 0, 0, 'SM', 0, 'HiRAM'       ; MCB-Name MS-DOS
DRDOSName$      db      0, 0, 0, 'HiRAM', cVersion      ; MCB-Name DR-DOS
UMBName$        db      0, 0, 0, 'UMB', 0, 0, 0, 0, 0   ; UMB-Name
NoChainCmd$     db      'no'
ChainCmd$       db      'chain', 0
NoInt2FhCmd$    db      'no'
Int2FhCmd$      db      'int2f', 0
MSDOSCmd$       db      'fixmsdos', 0
DRDOSCmd$       db      'fixdrdos', 0
DebugCmd$       db      'debug', 0
ExcludeCmd1$    db      'exclude=', 0
ExcludeCmd2$    db      'x=', 0
ExcludeCmd3$    db      'e=', 0
;IncludeCmd1$    db      'include=', 0
;IncludeCmd2$    db      'i=', 0
EMM$            db      'EMMXXXX0'
RAMFound        db      0                       ; <> 0 = gefunden
ROMFound        db      0                       ; <> 0 = gefunden
EMSSearch$      db      'Suche EMS: ', 0
RAMSearch$      db      'Suche RAM: ', 0
ROMSearch$      db      'Suche ROM: ', 0
NoROMFound$     db      'nicht gefunden'        ; \
ROMFound$       db      '     '                 ;  >
                db      13, 10, 0               ; /
CRLF            db      13, 10, 10, 0
Empty$          db      'h-', 0
KB$             db      'h ', 0
Hex$            db      '        ', 0
Back$           db      'h', 8, 8, 8, 8, 8, 0
MemTbl          db      (100h-0A0h) dup ('')
MemPic          db      ' Belegung des oberen Speichers ͻ', 13, 10
                db      '  A000h   A800h   B000h   B800h   C000h         ', 13, 10
                db      '        ', 13, 10
MemPicTbl1      db      '        ', 13, 10
MemPicTbl2      db      '       ', 13, 10
                db      '    Ĵ   ', 13, 10
                db      '  C800h   D000h   D800h   E000h   E800h   F000h ', 13, 10
                db      '                                                ', 13, 10
                db      ' =RAM =ROM =VideoRAM =EMS =frei X=excluded ', 13, 10
                db      '͹', 13, 10
                db      '  Betriebssystem: '
DosMsg$         db      'MS-DOS Version '
DosVersion$     db      '3.31           ', 13, 10
                db      'ͼ', 0
;=========================
; Initialization of Driver
;=========================
; Ausgabe:  CY = 0 => OK
;=========================
Init            proc    near
                push    AX
                push    BX
                push    CX
                push    DX
                push    ES
                push    CS
                pop     ES
                cld
                mov     SI, offset Title$
                call    PrintStr
                call    GetDosVersion           ; DOS Version
                mov     SI, offset DosErr$
                jnc     @@DOSOK                 ;   gltig ->
@@NotOK:        call    PrintStr
                stc
                jmp     @@Ret
@@DOSOK:        mov     AH, 52h                 ; Get List of Lists
                push    ES
                int     21h
                mov     AX, ES:[BX-2]
                pop     ES
                mov     FirstMCB, AX            ; 1. MCB merken
                mov     AX, 4300h               ; XMS Installation Test
                int     2Fh
                cmp     AL, 80h
                jne     @@NoXMS
                mov     AX, 4310h               ; Get XMS Address
                int     2Fh
                mov     word ptr [XMSCtrl], BX
                mov     word ptr [XMSCtrl+2], ES
@@NoXMS:        push    CS
                pop     ES
                call    CheckInst               ; schon installiert ?
                mov     SI, offset NotInst2$
                jnz     @@NotOK                 ;   ja ->
@@NotInst:      call    InitFlags               ; Defaultwerte einstellen
                call    GetCmdLine              ; Kommandozeile auswerten
                call    SearchMem               ; Speicher suchen
                call    ShowMem                 ; alles anzeigen,
                mov     SI, offset Exclude$
                cmp     ExcludeWarn, 0          ; falscher Exclude-Parameter ?
                jz      @@ExcludeOK             ;   nein ->
                call    PrintStr
@@ExcludeOK: ;   mov     SI, offset Include$
             ;   cmp     IncludeWarn, 0          ; falscher Include-Parameter ?
             ;   jz      @@IncludeOK             ;   nein ->
             ;   call    PrintStr
@@IncludeOK:    cmp     DebugFlag, 0            ; nur Testen ?
                je      @@NoDebug               ;   nein ->
                mov     SI, offset NotInst2$
                jmp     short @@NotOK
@@NoDebug:      call    InitHiRAM               ;   initialisieren
                call    ChainHiRAM              ;   und anhngen
                mov     SI, offset NotInst$
                cmp     word ptr [UpperSeg], 0  ; oberes RAM gefunden ?
                jz      @@NotOK                 ;   nein ->
comment |
=========================================================
                call    DetectCPU
                cmp     AX, 1                   ; 8086 ?
                je      @@8086                  ;   ja ->
                mov     SI, offset EMM386Warn$
                cmp     AX, 3                   ; 386 ?
                jne     @@8086                  ;   ja ->
                call    PrintStr
=========================================================
|
@@8086:         call    InitInt2Fh
                cmp     DOSVersion, 0500h       ; DOS < 5.0 ?
                jae     @@DOS5                  ;   nein ->
                mov     SI, offset DOSWarn$     ; kein Hochladen untersttzt
                call    PrintStr
@@DOS5:         mov     SI, offset Inst$
                call    PrintStr
                clc
@@Ret:          pop     ES
                pop     DX
                pop     CX
                pop     BX
                pop     AX
                ret
Init            endp
;==============================================
; Je nach DOS Version Defaults einstellen
;==============================================
InitFlags       proc    near
                cmp     DOSVersion, 0500h       ; DOS 5.x, 6.x ?
                jb      @@NoDOS5                ;   nein ->
                cmp     WhichDOS, cDRDOS        ; DRDOS ?
                je      @@DRDOS5                ;   ja ->
@@MSDOS5:       mov     MS2FhFlag, -1           ; MS Int2Fh Handler installieren
                jmp     short @@Ret
@@DRDOS5:       mov     DR2FhFlag, -1           ; DR Int2Fh Handler installieren
@@NoDOS5:       mov     ChainFlag, -1           ; Upper Memory einbinden
@@Ret:          ret
InitFlags       endp
;======================================
; Strings vergleichen
;======================================
;  Aufruf:  DS:SI -> 1.String
;           ES:DI -> 2.String
;  Liefert: ZF = 1 bei bereinstimmung
;======================================
CmpStr          proc    near
                mov     BX, SI
@@Loop:         cmp     byte ptr ES:[DI], 0     ; Stringende ?
                jz      @@Ret                   ;   ja ->
                lodsb
                or      AL, 00100000b           ; LoCase
                scasb
                je      @@Loop
                mov     SI, BX
@@Ret:          ret
CmpStr          endp
;=====================================
; Kommandozeile lesen und Flags setzen
;=====================================
GetCmdLine      proc    near
                push    DS
                lds     SI, DS:Req
                lds     SI, dword ptr DS:SI[CmdLnPtr]
@@Loop:         lodsb
                or      AL, AL                  ; #0 ?
                je      @@Ret                   ;   ja, fertig ->
                cmp     AL, ' '
                je      @@Loop
                cmp     AL, 9
                je      @@Loop
                cmp     AL, 0Dh                 ; CR ?
                je      @@Ret                   ;   ja, fertig ->
                cmp     AL, 0Ah                 ; LF ?
                je      @@Ret                   ;   ja, fertig ->
                cmp     AL, '/'                 ; Optionstrennzeichen
                je      @@TestCmds
                cmp     AL, '-'                 ; Optionstrennzeichen
                jne     @@Loop
@@TestCmds:
@@TestDebug:    mov     DI, offset DebugCmd$    ; "/DEBUG"
                call    CmpStr
                jne     @@TestExclude
                mov     DebugFlag, -1
                jmp     short @@Ret
@@TestExclude:  mov     DI, offset ExcludeCmd1$ ; "/EXCLUDE="
                call    CmpStr
                je      @@GetExclude
                mov     DI, offset ExcludeCmd2$ ; "/X=" (MSDOS)
                call    CmpStr
                je      @@GetExclude
                mov     DI, offset ExcludeCmd3$ ; "/E=" (DRDOS)
                call    CmpStr
                jne     @@TestMSDOS     ; @@TestInclude
@@GetExclude:   mov     AH, cExclude
                call    GetHexStr
                or      CS:ExcludeWarn, AL
                jmp     short @@Loop
comment |
=============================================================
@@TestInclude:  mov     DI, offset IncludeCmd1$ ; "/INCLUDE="
                call    CmpStr
                je      @@GetInclude
                mov     DI, offset IncludeCmd2$ ; "/I="
                call    CmpStr
                jne     @@TestMSDOS
@@GetInclude:   mov     AH, cEmpty
                call    GetHexStr
                or      CS:IncludeWarn, AL
                jmp     short @@Loop
=============================================================
|
@@Ret:          pop     DS
                ret
@@TestMSDOS:    mov     DI, offset MSDOSCmd$    ; "/FIXMSDOS"
                call    CmpStr
                jne     @@TestDRDOS
                mov     word ptr CS:[WhichDOS], cMSDOS
                mov     word ptr CS:[UMBName], offset MSDOSName$
                jmp     short @@Loop
@@TestDRDOS:    mov     DI, offset DRDOSCmd$    ; "/FIXDRDOS"
                call    CmpStr
                jne     @@TestNoChain
                mov     word ptr CS:[WhichDOS], cDRDOS
                mov     word ptr CS:[UMBName], offset DRDOSName$
                jmp     @@Loop
@@TestNoChain:  mov     DI, offset NoChainCmd$  ; "/NOCHAIN"
                call    CmpStr
                jne     @@TestChain
                mov     CS:[ChainFlag], 0       ; No Chain
                jmp     @@Loop
@@TestChain:    mov     DI, offset ChainCmd$    ; "/CHAIN"
                call    CmpStr
                jne     @@TestNoInt2Fh
                mov     CS:[ChainFlag], -1      ; No Chain
                jmp     @@Loop
@@TestNoInt2Fh: mov     DI, offset NoInt2FhCmd$ ; "/NOINT2F"
                call    CmpStr
                jne     @@TestInt2Fh
                mov     CS:[MS2FhFlag], 0       ; No MSDOS Int 2Fh Handler
                mov     CS:[DR2FhFlag], 0       ; No DRDOS Int 2Fh Handler
                jmp     @@Loop
@@TestInt2Fh:   mov     DI, offset Int2FhCmd$   ; "/INT2F"
                call    CmpStr
                jne     @@Ret
                cmp     word ptr CS:[WhichDOS], cDRDOS
                je      @@DRDOS
                mov     CS:[MS2FhFlag], 0       ; MSDOS Int 2Fh Handler
                jmp     @@Loop
@@DRDOS:        mov     CS:[DR2FhFlag], 0       ; DRDOS Int 2Fh Handler
                jmp     @@Loop
GetCmdLine      endp
;=========================================
; Liest HexStrings von der Kommandozeile
; und trgt die Bereiche in die MemTbl ein
; Format: "-YYYY", "XXXX-", XXXX-YYYY"
;=========================================
; Aufruf:   DS:SI -> Hexstrings
;           AH = Kennung fr MemTbl
; Liefert:  AL = 0 OK
;           AL <> 0 falscher Parameter
;           Eintrge in MemTbl
;=========================================
GetHexStr       proc    near
@@NextSeg:      call    ASC2BCD
                mov     CX, BX                  ; StartSeg merken
                cmp     AL, '-'                 ; StartSeg - EndSeg ?
                jne     @@FillTbl               ;   nein ->
                call    ASC2BCD
                or      BX, BX                  ; EndSeg = 0 ?
                jnz     @@FillTbl               ;   nein ->
                mov     BX, 0F000h              ; EndSeg auf F000h setzen
                jcxz    @@Ret                   ; StartSeg und EndSeg = 0
@@FillTbl:      mov     CL, BH
                mov     BH, 0
                mov     BL, CH
                mov     CH, 0
                inc     CX
                cmp     BL, 0A0h                ; StartSeg >= 0A000h ?
                jae     @@StartSegOK            ;   ja ->
                mov     BL, 0A0h
@@StartSegOK:   cmp     CL, 0F1h                ; EndSeg <= 0F000h ?
                jbe     @@EndSegOK              ;   ja ->
                mov     CL, 0F1h
@@EndSegOK:     cmp     BL, CL                  ; StartSeg >= EndSeg ?
                jae     @@Ret                   ;   ja, Fehler ->
                sub     CL, BL                  ; CL = Anzahl Segmente
                xchg    AL, AH                  ; AL = MemTbl-Eintrag, AH merken
                push    DS
                push    CS
                pop     DS
                call    FillMemTbl
                pop     DS
                xchg    AL, AH                  ; AL = letztes Zeichen
                cmp     AL, ','                 ; weitere Bereiche angegeben ?
                je      @@NextSeg               ; ja ->
                mov     AH, 0                   ; OK
@@Ret:          mov     AL, AH
                ret
GetHexStr       endp
;============================
; Int2Fh-Handler installieren
;============================
InitInt2Fh      proc    near
                push    ES
                cmp     DR2FhFlag, 0            ; DRDOS Int2Fh Handler ?
                jz      @@NoDRDOS               ;   nein ->
@@DRDOS:        mov     AX, 352Fh
                int     21h
                mov     word ptr DROldInt2Fh, BX
                mov     word ptr DROldInt2Fh+2, ES
                call    GetLastUpperMCB
                sub     word ptr ES:[BX+3], DRInt2FhParas
                sub     AX, DRInt2FhParas
                mov     ES, AX
                mov     SI, offset DRDOSInt2Fh  ; Int2Fh-Handler hinter
                xor     DI, DI                  ;   den letzten belegten
                mov     CX, DRInt2FhLen         ;   Speicher kopieren
                rep     movsb
                call    SetInt2Fh
@@NoDRDOS:      cmp     MS2FhFlag, 0            ; MSDOS Int2Fh Handler ?
                jz      @@Ret                   ;   nein ->
@@MSDOS:        mov     AX, 352Fh
                int     21h
                mov     word ptr MSOldInt2Fh, BX
                mov     word ptr MSOldInt2Fh+2, ES
                mov     AX, word ptr [UpperSeg]
                inc     AX
                inc     AX
                mov     ES, AX
                mov     SI, offset MSDOSInt2Fh  ; Int2Fh-Handler in den
                xor     DI, DI                  ;   ersten oberen
                mov     CX, MSInt2FhLen         ;   Speicherblock
                rep     movsb                   ;   kopieren
                call    SetInt2Fh
@@Ret:          pop     ES
                ret
InitInt2Fh      endp
SetInt2Fh       proc    near
                push    DS
                mov     DS, AX                  ; neues Segment
                mov     AX, 252Fh
                mov     DX, 6                   ; Offset Interrupt-Einsprung
                int     21h
                pop     DS
                ret
SetInt2Fh       endp
;=======================================
; Liefert in DosVersion$ die DOS Version
;=======================================
GetDOSVersion   proc    near
                mov     AX, 3306h               ; Get Real DOS Version
                xor     BX, BX
                int     21h
                cmp     AL, 6                   ; Funktion untersttzt ?
                mov     AX, BX
                jne     @@NotDOS5               ;   nein ->
                cmp     AL, 10                  ; DOS < 10.0 (OS/2) ?
                jb      @@OK                    ;   ja ->
@@NotDOS5:      mov     AH, 30h                 ; Get DOS Version
                int     21h
                cmp     AL, 3                   ; DOS < 3.00 ?
                jb      @@Error                 ;   ja ->
                cmp     AL, 10                  ; OS/2 ?
                jae     @@Error                 ;   ja ->
                cmp     AX, 1F03h               ; DOS 3.31 ?
                jne     @@OK                    ;   nein ->
                push    AX
                mov     AX, 4452h               ; Get DRDOS Version
                stc
                int     21h
                mov     BX, AX                  ; merken
                pop     AX
                jc      @@Ok                    ; kein DRDOS ->
                mov     word ptr DOSMsg$, 'RD'  ; MS-DOS => DR-DOS
;                mov     word ptr EMMEXE$, 'YS'  ; EMM386.EXE => EMM386.SYS
;                mov     byte ptr EMMEXE$+2, 'S'
                mov     UMBName, offset DRDOSName$
                mov     AX, 41*256+3
                cmp     BX, 1063h               ; V3.41 ?
                je      @@OK                    ;   ja ->
                inc     AH
                cmp     BX, 1064h               ; V3.42 ?
                je      @@OK                    ;   ja ->
                mov     WhichDOS, cDRDOS        ; fr UMB-Link ab DRDOS 5.0
                mov     AX, 0005h
                cmp     BX, 1065h               ; V5.00 ?
                je      @@OK                    ;   ja ->
                mov     AL, 06h
                cmp     BX, 1067h               ; V6.00 ?
                jb      @@Error                 ;   nein ->
@@OK:           push    AX
                xor     AH, AH
                mov     BX, '0'*256 + 10
                mov     CX, 1
                mov     SI, offset DOSVersion$
                call    BCD2ASC
                pop     AX
                xchg    AL, AH
                mov     DosVersion, AX
                xor     AH, AH
                mov     CX, 2
                mov     SI, offset DOSVersion$+2
                call    BCD2ASC
                clc
                ret
@@Error:        stc
                ret
GetDOSVersion   endp
comment |
;==================================
; Ermittelt die CPU (aus HIMEM.ASM)
;==================================
; Liefert:  AX=1 => 8086
;              2 => 80286
;              3 => 80386
;==================================
DetectCPU       proc   near
                xor     AX, AX              ; Move 0 into the Flags register
                push    AX
                popf
                pushf                       ; Try and get it back out
                pop     AX
                and     AH, 0F0h            ; If the top four bits are set...
                cmp     AH, 0F0h
                je      short MC_8086       ; ...it's an 8086 machine
                mov     AX, 0F000h          ; Move F000h into the Flags register
                push    AX
                popf
                pushf                       ; Try and get it back out
                pop     AX
                and     AH, 0F0h            ; If the top four bits aren't set...
                jz      short MC_80286      ; ...it's an 80286 machine
                ; We're on an 80386 machine
                mov     AX, 3
                ret
MC_80286:       ; We're on an 80286 machine
                mov     AX, 2
                ret
MC_8086:        ; We're on an 8086 machine
                mov     AX, 1
                ret
DetectCPU       endp
|
;============================================
; Die Belegung des oberen Speichers ermitteln
;==============================================
SearchMem       proc    near
                call    SearchVideo             ; Video-Speicher suchen
                call    SearchROM               ; ROM-Erweiterungen suchen
                call    SearchEMS               ; EMS-Page-Frame suchen
                call    SearchRAM               ; oberen RAM-Speicher suchen
                ret
SearchMem       endp
;===========================================
; Die Belegung des oberen Speichers anzeigen
;===========================================
ShowMem         proc    near
                push    ES
                push    CS
                pop     ES
                cld
                mov     SI, offset MemTbl       ; Speicherbelegungstabelle
                mov     DI, offset MemPicTbl1+5 ;   ins Bild kopieren
                mov     CX, (0C8h - 0A0h)
                rep     movsb
                mov     DI, offset MemPicTbl2+5 ;   ins Bild kopieren
                mov     CX, (0F0h - 0C8h)
                rep     movsb                   ; nur jedes
                mov     SI, offset MemPic
                call    PrintStr                ; anzeigen
                pop     ES
                ret
ShowMem         endp
;==========================================
; Sucht den Bereich des Video-Speichers und
; markiert diesen in der MemTbl
;==========================================
; Liefert:   -
;==========================================
SearchVideo     proc    near
                mov     AX, 1200h               ; EGA/VGA ?
                mov     BX, 10h
                int     10h
                cmp     BX, 10h                 ; BX unverndert ?
                mov     BX, 0A0h
                mov     CX, (0C0h - 0A0h)
                jne     @@Found                 ;   nein ->
                int     11h
                mov     BX, 0B0h
                mov     CX, (0C0h-0B0h)
                and     AL, 00110000b
                cmp     AL, 00110000b           ; Hercules ?
                je      @@Found                 ;   ja ->
                mov     BX, 0B8h                ; CGA
                mov     CX, (0C0h-0B8h)
@@Found:        mov     AL, cVideo
                call    FillMemTbl
                ret
SearchVideo     endp
;=======================================
; Im MCB die reservierten Felder lschen
;=======================================
; Aufruf:  ES = seg(MCB)
;          SI = offset Name
;=======================================
FillMCB         proc    near
                push    CX
                mov     DI, 5
                mov     CX, 3+8                 ; res. Felder + Name
                rep     movsb                   ;   bertragen
                pop     CX
                ret
FillMCB         endp
IncES           proc    near
                mov     AX, ES
                add     AH, 10h
                mov     ES, AX
                ret
IncES           endp
;======================================
; Fllt den aktuellen Speicherblock mit
; "JVP "
;======================================
; Aufruf:    ES = seg(MCB)
;======================================
InitMCB         proc    near
                push    CX
                push    ES
                mov     CX, ES:[BX+3]           ; Paragrafen-Zahl in
                shl     CX, 1                   ;   DoubleWords umrechnen
                shl     CX, 1
                mov     DI, 10h                 ; ES+1:0 = ES:10h
@@Loop:         mov     AX, 'VJ'
                stosw                           ; "JVP "
                or      DI, DI                  ; Segmentgrenze ?
                jnz     @@1                     ;   nein ->
                call    IncES                   ; ES erhhen
@@1:            mov     AX, ' P'
                stosw
                or      DI, DI                  ; Segmentgrenze ?
                jnz     @@2                     ;   nein ->
                call    IncES                   ; ES erhhen
@@2:            loop    @@Loop
                pop     ES
                pop     CX
                ret
InitMCB         endp
;======================================
; Liefert den letzten MCB der MCB-Kette
;======================================
; Liefert:  ES = seg(MCB)
;           AX = seg(MCB) + 1 + MCB.Len
;           BX = 0
;======================================
GetLastMCB      proc    near
                mov     AX, [FirstMCB]
                jmp     short GetMCBs
GetLastMCB      endp
;======================================
; Liefert den letzten oberen MCB
;======================================
; Liefert:  ES = seg(MCB)
;           AX = seg(MCB) + 1 + MCB.Len
;           BX = 0
;======================================
GetLastUpperMCB proc    near
                mov     AX, [UpperSeg]
GetMCBs:        xor     BX, BX
@@Loop:         mov     ES, AX
                inc     AX
                add     AX, ES:[BX+3]
                cmp     byte ptr ES:[BX], 'Z'   ; letzter MCB ?
                jne     @@Loop                  ;   nein ->
                ret
GetLastUpperMCB endp
;=======================================
; Hngt zwei Speicherblcke zusammen.
;=======================================
; Aufruf:  ES = seg(1.MCB)
;          AX = seg(2.MCB)
;          BX = 0
;          DX = seg(letzter eingeb. MCB)
; Liefert:   -
;=======================================
LinkMCBs        proc    near
                mov     byte ptr ES:[BX], 'M'   ; letzten MCB patchen
                dec     word ptr ES:[BX+3]      ; Gre-1
                dec     AX
                mov     ES, AX
                sub     AX, DX
                not     AX
                mov     byte ptr ES:[BX], 'M'   ; neuen MCB am Ende des vorigen
                mov     word ptr ES:[BX+3], AX  ;   anlegen und initialisieren
                mov     AX, WhichDOS            ; 7 bzw. 8
                mov     word ptr ES:[BX+1], AX  ; UMB-Link
                mov     SI, [UMBName]
                call    FillMCB
                ret
LinkMCBs        endp
;============================================
;  Hngt die oberen Speicherblcke mit denen
;  des konventionellen Speichers zusammen.
;============================================
;  Liefert:   -
;============================================
ChainHiRAM      proc    near
                push    ES
                cmp     ChainFlag, 0            ; zusammenhngen ?
                jz      @@Ret                   ;   nein ->
                mov     DX, [UpperSeg]
                or      DX, DX                  ; kein oberes RAM ?
                jz      @@Ret                   ;   ja ->
                call    GetLastMCB
                call    LinkMCBs                ; MCBs verbinden
@@Ret:          pop     ES
                ret
ChainHiRAM      endp
;==========================================
; Hngt die oberen Speicherblcke zusammen.
;==========================================
; Liefert:   -
;==========================================
InitHiRAM       proc    near
                push    ES
                mov     DX, 0A000h
@@SearchLoop:   call    TestMemTblRAM           ; RAM-Segment ?
                jne     @@NoRAMFound            ;   nein ->
                xor     BX, BX
                mov     [UpperSeg], DX          ;   ja, merken
                jmp     short @@InitNewMCB
@@NoRAMFound:   inc     DH
                cmp     DH, 0F0h
                jb      @@SearchLoop
                jmp     short @@Ret
@@Loop:         call    TestMemTblRAM           ; RAM-Segment ?
                jne     @@NextSeg               ;   nein ->
                call    GetLastUpperMCB
                cmp     AX, DX                  ; folgen Segmente aufeinander ?
                jne     @@Gap                   ;   nein ->
                inc     byte ptr ES:[BX+4]      ; = add word ptr ES:[BX+3], 100h
                call    InitMCB
                jmp     short @@NextSeg
@@Gap:          call    LinkMCBs                ; MCBs verbinden
@@InitNewMCB:   mov     ES, DX                  ; UpperSeg
                mov     byte ptr ES:[BX], 'Z'   ; letzter MCB
                mov     word ptr ES:[BX+1], 0   ; frei
                mov     word ptr ES:[BX+3], 0FFh; Gre in Paragrafen
                mov     SI, offset UMBName$
                call    FillMCB                 ; Name := 'UMB'
@@NextSeg:      inc     DH
                cmp     DH, 0F0h                ; noch nicht im ROM ?
                jb      @@Loop
comment |
                mov     AX, 4452h
                int     21h
                jc      @@Ret
                mov     AX, 4458h               ; DRDOS-Funktion
                int     21h
                cmp     word ptr ES:[BX+16h], 9
                jae     @@Ret
                mov     word ptr ES:[BX+16h], 9
|
@@Ret:          mov     AX, [UpperSeg]
                mov     DRUpperSeg, AX
                mov     MSUpperSeg, AX
                pop     ES
                ret
InitHiRAM       endp
;===========================================
; Sucht den Page-Frame des EMS-Speichers und
; markiert diesen in der MemTbl
;===========================================
; Liefert:   -
;===========================================
SearchEMS       proc    near
                mov     SI, offset EMSSearch$
                call    PrintIt
                push    ES
                mov     AX, 3567h
                int     21h
                mov     DI, 0Ah
                mov     SI, offset EMM$         ; Int67h Handler mit
                mov     CX, 4                   ;   "EMMXXXX0"-Kennung ?
                repe    cmpsw
                jne     @@Ret                   ;     nein ->
                mov     AH, 41h                 ; Get Frame Segment
                int     67h
                or      AH, AH                  ; Fehler ?
                jnz     @@Ret                   ;   ja ->
                mov     AX, BX                  ; Page Frame Segment
                push    AX
                call    Print1stHexSeg          ;   ausgeben
                pop     AX
                push    AX
                add     AX, 0FFFh               ; Ende des Page Frame Segments
                call    Print2ndHexSeg          ;   ausgeben
                pop     BX
                cmp     BH, 0A0h                ; Page Frame Segment < A000h ?
                jb      @@Ret                   ;   ja ->
                cmp     BH, 0F0h                ; >= F000h
                jae     @@Ret                   ;   ja ->
                mov     CX, 10h                 ; 64K
                mov     AL, cEMS                ; Page-Frame-Kennzeichen
                xor     BL, BL
                xchg    BH, BL
                call    FillMemTbl              ; in Tabelle eintragen
                mov     SI, offset ROMFound$
                jmp     short @@PrintIt
@@Ret:          mov     SI, offset NoROMFound$
@@PrintIt:      call    PrintIt
                pop     ES
                ret
SearchEMS       endp
;========================================
; Sucht obere Speicherblcke und markiert
; diese in der MemTbl
;========================================
; Liefert:   -
;========================================
SearchRAM       proc    near
                mov     SI, offset RAMSearch$
                call    PrintIt
                push    ES
                mov     DX, 0A000h
@@Loop:         call    PrintSeg
                call    TestMemTbl              ; Segment unbelegt ?
                jnz     @@NextSeg               ;   nein ->
                mov     ES, DX
                mov     CX, 1000h               ; 4K testen
                xor     DI, DI
@@MemLoop:      mov     AL, ES:[DI]             ; alten Wert merken
                Delay                           ;   und etwas warten
                mov     byte ptr ES:[DI], 055h  ; Testmuster ausgeben
                Delay                           ;   und etwas warten
                not     byte ptr ES:[DI]        ; Testmuster invertieren
                Delay                           ;   und wieder warten
                xchg    ES:[DI], AL             ; alten Wert restaurieren
                cmp     AL, not 055h            ; Testmuster invertiert ?
                jne     @@NextSeg               ;   nein, kein RAM ->
                inc     DI
                loop    @@MemLoop
                mov     MemTbl[BX], cRAM        ; RAM-Kennzeichen
                mov     byte ptr RAMFound, -1   ; RAM gefunden
@@NextSeg:      inc     DH                      ; nchstes Segment
                cmp     DH, 0F0h
                jb      @@Loop
                pop     ES
                mov     SI, offset NoROMFound$
                cmp     RAMFound, 0             ; berhaupt RAM gefunden ?
                jz      @@Ret                   ;   nein ->
                mov     DX, 0A000h
@@TestRAM:      call    TestMemTblRAM           ; RAM ?
                jne     @@TestNextSeg           ;   nein ->
                mov     AX, DX                  ; sonst
                call    Print1stHexSeg          ;   ausgeben
@@NextSegLoop:  inc     DH
                call    TestMemTblRAM           ; bis RAM-Ende
                je      @@NextSegLoop           ;   suchen
                mov     AX, DX
                dec     AX                      ; letztes Segment des RAMs
                call    Print2ndHexSeg          ;   ausgeben
@@TestNextSeg:  inc     DH
                cmp     DH, 0F0h
                jb      @@TestRAM
                mov     SI, offset ROMFound$
@@Ret:          call    PrintIt
                ret
SearchRAM       endp
;=========================================
; Testet, ob ein Speichersegment in MemTbl
; als frei markiert ist.
;=========================================
; Aufruf:   DX = Segment
; Liefert:  ZF = 1 wenn Block frei
;           BX = Index in MemTbl
;=========================================
TestMemTbl      proc    near
                xor     BX, BX
                mov     BL, DH
                sub     BL, 0A0h
                cmp     MemTbl[BX], cEmpty      ; unbelegt ?
                ret
TestMemTbl      endp
;=========================================
; Testet, ob ein Speichersegment in MemTbl
; als RAM markiert ist.
;=========================================
; Aufruf:   DX = Segment
; Liefert:  ZF = 1 wenn Block RAM
;           BX = Index in MemTbl
;=========================================
TestMemTblRAM   proc    near
                xor     BX, BX
                mov     BL, DH
                sub     BL, 0A0h
                cmp     MemTbl[BX], cRAM        ; RAM ?
                ret
TestMemTblRAM   endp
;=====================================
; Sucht ROM-Erweiterungen und markiert
; diese in der MemTbl
;=====================================
; Liefert:   -
;=====================================
SearchROM       proc    near
                mov     SI, offset ROMSearch$
                call    PrintIt
                push    ES
                xor     SI, SI
                mov     DX, 0A000h
@@Loop:         mov     ES, DX
                call    PrintSeg
                call    TestMemTbl
                cmp     word ptr ES:[SI], cValidROM
                je      @@ROMFound
                cmp     word ptr ES:[SI], not cValidROM
                je      @@ROMFound
                add     DX, 080h
@@SearchCont:   cmp     DH, 0F0h                ; Segment 0F000h ?
                jb      @@Loop                  ;   noch nicht ->
                pop     ES
                mov     SI, offset NoROMFound$
                cmp     ROMFound, 0             ; berhaupt ROM gefunden ?
                je      @@Ret                   ;   nein ->
                mov     SI, offset ROMFound$
@@Ret:          call    PrintIt
                ret
@@ROMFound:     mov     byte ptr ROMFound, -1   ; ROM gefunden
                push    SI
                mov     AX, DX
                call    Print1stHexSeg          ; Segment ausgeben
                pop     SI
                xor     AX, AX
                mov     AH, ES:[SI+2]           ; ROM-Gre in 512-Byte-Einheiten
                shr     AX, 1
                shr     AX, 1
                shr     AX, 1
                xor     BX, BX
                xor     CX, CX
                mov     BL, DH
                mov     CL, AH                  ; Anzahl Segmente
                add     DX, AX                  ; erstes Segment nach ROM
                mov     AL, cROM                ; ROM-Kennzeichen
                call    FillMemTbl              ; in Tabelle eintragen
                push    SI
                mov     AX, DX
                dec     AX                      ; Endsegment des ROMs
                call    Print2ndHexSeg          ;   ausgeben
                pop     SI

                jmp     short @@SearchCont
SearchROM       endp
;=========================================
; Markiert in MemTbl einen Bereich als be-
; legt mit RAM/ROM/EMS.
;=========================================
; Aufruf:   AL = Speicher-Kennzeichen
;           BX = Segment shr 8
;           CX = Anzahl der Segmente
;=========================================
FillMemTbl      proc    near
                jcxz    @@Ret                   ; 0 (64K) verhindern
                sub     BL, 0A0h
@@Loop:         mov     byte ptr MemTbl[BX], AL ; als RAM/ROM/EMS kennzeichnen
                inc     BX
                loop    @@Loop
@@Ret:          ret
FillMemTbl      endp
;======================================
; 1 Word als Hex-Zahl mit nachfolgendem
; "h - " ausgeben
;======================================
Print1stHexSeg  proc    near
                push    DX
                mov     CX, 16
                xor     DX, DX
                mov     SI, offset Hex$
                call    ConvertNum
                mov     SI, offset Empty$
                call    PrintIt
                pop     DX
                ret
Print1stHexSeg  endp
;======================================
; 1 Word als Hex-Zahl mit nachfolgendem
; "h" ausgeben
;======================================
Print2ndHexSeg  proc    near
                push    DX
                mov     CX, 16
                xor     DX, DX
                mov     SI, offset Hex$
                call    ConvertNum
                mov     SI, offset KB$
                call    PrintIt
                pop     DX
                ret
Print2ndHexSeg  endp
;======================================
; 1 Word als Hex-Zahl mit nachfolgendem
; Cursorrcksetzen ausgeben
;======================================
PrintSeg        proc    near
                push    AX
                push    CX
                push    DX
                push    SI
                mov     AX, DX
                xor     DX, DX
                mov     CX, 16
                mov     SI, offset Hex$
                call    ConvertNum
                mov     SI, offset Back$
                call    PrintIt
                pop     SI
                pop     DX
                pop     CX
                pop     AX
                ret
PrintSeg        endp
;=====================================
; Installationstest
;=====================================
; Liefert: ZF=0 bereits installiert
;          ZF=1 noch nicht installiert
;=====================================
CheckInst       proc    near
                push    ES
                mov     AX, 12FFh               ; DRDOS Get UMB Link
                mov     BX, 6
                xor     CX, CX
                xor     DX, DX
                int     2Fh
                or      CX, DX                  ; UMB oder Video aktiviert ?
                jnz     @@IsInst                ;   ja ->
                push    SP                      ; 8086/88 ?
                pop     AX
                cmp     AX, SP
                jne     @@NoXMS                 ;   ja ->
                .286p
                  smsw    AX                    ; Statusword lesen
                .8086
                and     AL, 00000001b           ; Prot. Mode Bit gesetzt ?
                jnz     @@IsInst                ;   ja ->
@@RealMode:     mov     AX, word ptr [XMSCtrl]  ; Ist berhaupt ein
                or      AX, word ptr [XMSCtrl+2];   XMS-Handler installiert ?
                jz      @@NoXMS                 ;     nein ->
                mov     AH, 10h                 ; Request UMB
                mov     DX, -1                  ; Grten ermitteln
                call    [XMSCtrl]
                cmp     BL, 0B0h                ; kleinerer UMB verfgbar ?
                je      @@IsInst                ;   ja ->
@@NoXMS:        call    GetLastMCB
                cmp     AX, 0A000h              ; Speicher > A000h eingebunden ?
                jbe     @@NotInst               ;   nein ->
@@IsInst:       mov     SI, offset MemManager$  ; "Es ist bereits ein Manager
                call    PrintIt                 ;  installiert..."
@@GetKey:       xor     AX, AX                  ; Auf Taste warten
                int     16h
                cmp     AL, 27                  ; ESC ?
                jne     @@NoESC                 ;   nein ->
                mov     AL, 'n'
@@NoESC:        or      AL, 00100000b           ; LoCase()
                cmp     AL, 'j'                 ; "j"a ?
                je      @@IsYesNo               ;   ja ->
                cmp     AL, 'n'                 ; "n"ein ?
                jne     @@GetKey                ;   nein ->
@@IsYesNo:      mov     YesNo$, AL
                mov     SI, offset YesNo$
                call    PrintStr
                mov     AL, YesNo$
                cmp     AL, 'j'
                jmp     short @@Ret
@@NotInst:      xor     AX, AX
@@Ret:          pop     ES
                ret
CheckInst       endp
;===================================
; String als "String" CR LF ausgeben
;===================================
PrintStr        proc    near
                call    PrintIt
                mov     SI, offset CRLF
PrintIt:        lodsb
                or      AL, AL
                jz      @@Ret
                mov     AH, 0Eh
                push    SI
                int     10h
                pop     SI
                jmp     short PrintIt
@@Ret:          ret
PrintStr        endp
;=========================================
; Liest HexString von der Kommandozeile
;=========================================
; Aufruf:    DS:SI -> HexString
; Liefert:   BX = HexWord
;            AL = Zeichen hinter HexString
;=========================================
ASC2BCD         proc    near
                xor     BX, BX
@@1stLoop:      lodsb
                cmp     AL, ' '                 ; Leerzeichen
                je      @@1stLoop               ;   berlesen
                cmp     AL, 9                   ; Tabs
                jne     @@NoSpace               ;   berlesen
                jmp     short @@1stLoop
@@Loop:         lodsb
@@NoSpace:      cmp     AL, '0'                 ; gltige Ziffer ?
                jb      @@Ret                   ;   nein ->
                cmp     AL, '9'
                jbe     @@NumOK                 ;   ja ->
                and     AL, 11011111b           ; UpCase
                cmp     AL, 'A'                 ; gltige Hexziffer ?
                jb      @@Ret                   ;   nein ->
                cmp     AL, 'F'
                ja      @@Ret                   ;   nein ->
                sub     AL, 7
@@NumOK:        sub     AL, '0'
                shl     BX, 1
                shl     BX, 1
                shl     BX, 1
                shl     BX, 1
                or      BL, AL
                jmp     short @@Loop
@@Ret:          ret
ASC2BCD         endp
;==============================================
; Convert a 32 bit number to a string.
;
; In: DX.AX= number to convert; CX= number base
; (1 to 16); SI= place to put string.
;==============================================
ConvertNum      proc    near
                push    AX
                push    BX
                push    CX
                push    DX
                push    SI
                push    DI
                push    ES
                push    DS
                pop     ES
                push    bp
                sub     sp, 4
                mov     bp, sp
                cld
                mov     DI, SI
                push    DI
; loop for each digit
                sub     bh, bh
                mov     word ptr [bp], ax       ;save low word
                mov     word ptr [bp+2], dx     ;save high word
                sub     si, si                  ;count digits
@@1:            inc     si
                mov     ax, word ptr [bp+2]     ;high word of value
                sub     dx, dx                  ;clear for divide
                div     cx                      ;divide, DX gets remainder
                mov     word ptr [bp+2], ax     ;save quotient (new high word)
                mov     ax, word ptr [bp]       ;low word of value
                div     cx                      ;divide, DX gets remainder
                                                ;  (the digit)
                mov     word ptr [bp], ax       ;save quotient (new low word)

                mov     bl, dl
                mov     al, byte ptr [HexB$+bx] ;get the digit
                stosb                           ;store
                cmp     word ptr [bp], 0        ;check if low word zero
                jne     @@1                     ;jump if not
                cmp     word ptr [bp+2], 0      ;check if high word zero
                jne     @@1                     ;jump if not
                sub     al, al
                stosb                           ;store the terminator
; reverse digits
                pop     cx                      ;restore start of string
                xchg    cx, si
                shr     cx, 1                   ;number of reverses
                jz      @@3                     ;jump if none
                xchg    di, si
                sub     si, 2                   ;point to last digit
@@2:            mov     al, byte ptr [di]       ;load front character
                xchg    al, byte ptr [si]       ;swap with end character
                stosb                           ;store new front character
                dec     si                      ;back up
                loop    @@2                     ;loop back for each digit
; finished
@@3:            add     sp, 4
                pop     bp
                pop     ES
                pop     DI
                pop     SI
                pop     DX
                pop     CX
                pop     BX
                pop     AX
                call    PrintIt
                ret
ConvertNum      endp
;==================================================
; BCD2ASC
; konvertiert den Eingabewert zur Basis BL in ASCII
; und schreibt die Zahl nach DS:DI
;==================================================
; Eingabe:   AX = Zahl
;            BL = Basis
;            CX = Zhler
;            DS:SI = Ziel
; Ausgabe:   String in DS:SI
;==================================================
                align   2
BCD2ASC         proc    near
                push    AX
                mov     AL, BH
@@Loop1:        mov     [SI], AL
                inc     SI
                loop    @@Loop1
                pop     AX
@@Loop:         dec     SI
                div     BL
                cmp     BL, 10
                je      @@1
                cmp     AH, 9
                jbe     @@1
                add     AH, 7
@@1:            add     AH, '0'
                mov     DS:[SI], AH
                xor     AH, AH
                or      AL, AL
                jnz     @@Loop
                ret
BCD2ASC         endp
;===================================
; Einsprung bei Aufruf als EXE-Datei
;===================================
EXEStart        proc    far
                mov     AX, CS
                mov     DS, AX
                mov     ES, AX
                mov     SI, offset Title$
                call    PrintStr
                mov     SI, offset Help$
                call    PrintIt
                xor     AX, AX
                int     16h
                cmp     AX, 011Bh
                je      @@Ret
                mov     SI, offset CRLF
                call    PrintStr
                mov     SI, offset Title$
                call    PrintStr
                call    GetDosVersion
                mov     SI, offset DosErr$
                jc      @@Exit
                call    SearchMem               ; Speicher suchen
                call    ShowMem                 ;   und anzeigen
                cmp     DOSVersion, 0500h
                jae     @@Ret
                mov     SI, offset DOSWarn$
@@Exit:         call    PrintStr
@@Ret:          mov     AX, 4C00h
                int     21h
EXEStart        endp
                .stack  100h
end             EXEStart