/*
 * EW Snake - Versione 0.5
 * Copyright (C) 2001 di Federico Marverti (yfede)
 *
 * Questo programma e` distribuito secondo i termini della Licenza
 * Pubblica Generica GNU (GNU GPL: GNU General Public License).
 * Per maggiori informazioni e riguardo leggere il file README.TXT
 * allegato alla distribuzione del presente codice sorgente.
 */

/* --- Inizio di gui.c --- */

#include "defs.h"
#include <allegro.h>

void main_menu( struct st_config *cfg );    /* Visualizza il menu principale */
void level_menu( struct st_config *cfg );   /* Visualizza il menu del livello */
void settings_menu( struct st_config *cfg );    /* Menu impostazioni */
void resolution_menu( struct st_config *cfg );  /* Menu per la risoluzione */
int change_red( struct st_config *dp3, int d2 );    /* Cambia la componente rossa del colore nuovo */
int change_green( struct st_config *dp3, int d2 );  /* Cambia la componente verde del colore nuovo */
int change_blue( struct st_config *dp3, int d2 );   /* Cambia la componente blu del colore nuovo */
void color_dialog( struct st_config *cfg, RGB *c_old ); /* Cambia le componenti del colore c_old */

extern int set_gfx( struct st_config *cfg );    /* Imposta il video e disegna le bitmap */
extern void unset_gfx( struct st_config *cfg ); /* Distrugge le bitmap */
extern void reset_screen( void );   /* Cancella lo schermo */
extern void reset_colors( struct st_config *cfg );  /* Reimposta i colori */
extern int play( struct st_config *cfg );   /* Gioca usando la configurazione specificata */
extern void load_config( struct st_config *cfg );   /* Legge la configurazione da file o default */

void main_menu( struct st_config *cfg )
{
    #define M_MAINH 5           /* Altezza e larghezza del menu principale in caratteri (senza contare i bordi) */
    #define M_MAINW 11
    #define M_MAINT "Menu Principale"   /* Titolo del menu principale */

    int choice;                 /* Voce del menu selezionata */
    int score = 0;              /* Ultimo punteggio ottenuto */
    int menu_x = ((cfg->resx)-(M_MAINW+3)*DE_FONTW)/2;  /* Coordinate dell'angolo in alto a sinistra del menu */
    int menu_y = ((cfg->resy)-(M_MAINH+2)*DE_FONTH)/2;

    MENU m_main[] = {
    /*  | text          | proc       | child | flag | dp   | */ 
        { "Gioca"       , NULL       , NULL  , 0    , NULL },
        { "Livello"     , NULL       , NULL  , 0    , NULL },
        { "Impostazioni", NULL       , NULL  , 0    , NULL },
        { ""            , NULL       , NULL  , 0    , NULL },   /* Separatore */
        { "Esci"        , NULL       , NULL  , 0    , NULL },
        { NULL          , NULL       , NULL  , 0    , NULL }
    };

    for( ;; )
    {
        reset_screen();         /* Cancella lo schermo */
        text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo */
        textprintf_centre( screen, font, (cfg->resx)/2, (menu_y-DE_FONTH*2)/2-DE_FONTH, CL_TEXT,
                           "%s - %s %s - %s ", P_WRITER, P_NAME, P_VERSION, P_DATE );   /* Titolo del programma */
        textprintf_centre( screen, font, (cfg->resx)/2, (menu_y-DE_FONTH*2)/2+DE_FONTH, CL_TEXT,
                           "Accettare le condizioni poste nel file" );   /* Leggere README.TXT */
        textprintf_centre( screen, font, (cfg->resx)/2, (menu_y-DE_FONTH*2)/2+DE_FONTH*2, CL_TEXT,
                           "README.TXT prima di usare il programma" );  /* Leggere README.TXT */
        textout_centre( screen, font, M_MAINT, (cfg->resx)/2, menu_y-DE_FONTH*2, CL_TEXT ); /* Titolo del menu */
        textprintf_centre( screen, font, (cfg->resx)/2, (cfg->resy)-(cfg->cellsize)/2-DE_FONTH/2, CL_TEXT,
                           " Livello: %d, Punteggio: %d/%d ", cfg->level, score, cfg->record ); /* Punteggio */

        show_mouse( screen );   /* Visualizza il cursore del mouse */
        do {
            choice = do_menu( m_main, menu_x, menu_y ); /* Visualizza il menu */
        } while( choice < 0 );  /* Attende un responso valido */
        show_mouse( NULL );     /* Cancella il cursore del mouse */

        switch( choice )
        {
            case 0:             /* Gioca */
                score = play( cfg );    /* Gioca con la configurazione specificata e memorizza il punteggio */
                if( score > (cfg->record) ) (cfg->record) = score;  /* Se necessario aggiorna il record */
            break;

            case 1:             /* Livello */
                level_menu( cfg );  /* Visualizza il menu per la scelta del livello */
            break;

            case 2:             /* Impostazioni */
                settings_menu( cfg );   /* Visualizza il menu delle impostazioni */
                menu_x = ((cfg->resx)-(M_MAINW+3)*DE_FONTW)/2;  /* Coordinate dell'angolo in alto a sinistra del menu */
                menu_y = ((cfg->resy)-(M_MAINH+2)*DE_FONTH)/2;
            break;

            case M_MAINH - 1:   /* Esci */
                return;
            break;
        }
    }
}

void level_menu( struct st_config *cfg )
{
    #define M_LEVELH 12         /* Altezza e larghezza del menu del livello in caratteri (senza contare i bordi) */
    #define M_LEVELW 9
    #define M_LEVELT "Seleziona il livello" /* Titolo del menu di livello */

    int choice;                 /* Voce del menu selezionata */
    int menu_x = ((cfg->resx)-(M_LEVELW+3)*DE_FONTW)/2; /* Coordinate dell'angolo in alto a sinistra del menu */
    int menu_y = ((cfg->resy)-(M_LEVELH+2)*DE_FONTH)/2;

    MENU m_level[] = {
    /*  | text       | proc       | child | flag | dp   | */ 
        { "Livello 0", NULL       , NULL  , 0    , NULL },
        { "Livello 1", NULL       , NULL  , 0    , NULL },
        { "Livello 2", NULL       , NULL  , 0    , NULL },
        { "Livello 3", NULL       , NULL  , 0    , NULL },
        { "Livello 4", NULL       , NULL  , 0    , NULL },
        { "Livello 5", NULL       , NULL  , 0    , NULL },
        { "Livello 6", NULL       , NULL  , 0    , NULL },
        { "Livello 7", NULL       , NULL  , 0    , NULL },
        { "Livello 8", NULL       , NULL  , 0    , NULL },
        { "Livello 9", NULL       , NULL  , 0    , NULL },
        { ""         , NULL       , NULL  , 0    , NULL },  /* Separatore */
        { "Annulla"  , NULL       , NULL  , 0    , NULL },
        { NULL       , NULL       , NULL  , 0    , NULL }
    };

    reset_screen();             /* Cancella lo schermo */
    text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo */
    textout_centre( screen, font, M_LEVELT, (cfg->resx)/2, menu_y-DE_FONTH*2, CL_TEXT );    /* Titolo del menu */
    textprintf_centre( screen, font, (cfg->resx)/2, (cfg->resy)-(cfg->cellsize)/2-DE_FONTH/2, CL_TEXT,
                       " Livello corrente: %d ", cfg->level );  /* Livello */

    show_mouse( screen );       /* Visualizza il cursore del mouse */
    do {
        choice = do_menu( m_level, menu_x, menu_y );    /* Visualizza il menu */
    } while( choice < 0 );      /* Attende un responso valido */

    show_mouse( NULL );         /* Cancella il cursore del mouse */

    if( choice == M_LEVELH - 1 ) return;    /* Se selezionato Annulla esce senza cambiare niente */

    if( choice >= 0 && choice <= 9 )    /* Se e` stato selezionato un livello valido */
        cfg->level = choice;    /* Lo assegna alla configurazione */
}

void settings_menu( struct st_config *cfg )
{
    #define M_SETTINGSH 10      /* Altezza e larghezza del menu impostazioni in caratteri (senza contare i bordi) */
    #define M_SETTINGSW 21
    #define M_SETTINGST "Impostazioni"  /* Titolo del menu impostazioni */

    int choice;                 /* Voce del menu selezionata */
    int menu_x = ((cfg->resx)-(M_SETTINGSW+3)*DE_FONTW)/2;  /* Coordinate dell'angolo in alto a sinistra del menu */
    int menu_y = ((cfg->resy)-(M_SETTINGSH+2)*DE_FONTH)/2;

    MENU m_settings[] = {
    /*  | text                   | proc       | child | flag | dp   | */ 
        { "Risoluzione"          , NULL       , NULL  , 0    , NULL },
        { "Colore di sfondo"     , NULL       , NULL  , 0    , NULL },
        { "Colore del serpente"  , NULL       , NULL  , 0    , NULL },
        { "Colore dell'obiettivo", NULL       , NULL  , 0    , NULL },
        { "Colore del muro"      , NULL       , NULL  , 0    , NULL },
        { "Colore dei menu"      , NULL       , NULL  , 0    , NULL },
        { "Colore del testo"     , NULL       , NULL  , 0    , NULL },
        { "Colore del cursore"   , NULL       , NULL  , 0    , NULL },
        { ""                     , NULL       , NULL  , 0    , NULL },  /* Separatore */
        { "Indietro"             , NULL       , NULL  , 0    , NULL },
        { NULL                   , NULL       , NULL  , 0    , NULL }
    };

    for( ;; )
    {
        reset_screen();         /* Cancella lo schermo */
        text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo */
        textout_centre( screen, font, M_SETTINGST, (cfg->resx)/2, menu_y-DE_FONTH*2, CL_TEXT ); /* Titolo del menu */
        textprintf_centre( screen, font, (cfg->resx)/2, (cfg->resy)-(cfg->cellsize)/2-DE_FONTH/2, CL_TEXT,
                           " Risoluzione corrente: %d x %d ", cfg->resx, cfg->resy );   /* Risoluzione */

        show_mouse( screen );   /* Visualizza il cursore del mouse */
        do {
            choice = do_menu( m_settings, menu_x, menu_y ); /* Visualizza il menu */
        } while( choice < 0 );  /* Attende un responso valido */
        show_mouse( NULL );     /* Cancella il cursore del mouse */

        switch( choice )        /* In base alla scelta avvia uno dei sottomenu */
        {
            case 0:
                resolution_menu( cfg );
                menu_x = ((cfg->resx)-(M_SETTINGSW+3)*DE_FONTW)/2;  /* Ricalcola la posizione del menu */
                menu_y = ((cfg->resy)-(M_SETTINGSH+2)*DE_FONTH)/2;
            break;

            case 1:
                color_dialog( cfg, &(cfg->c_background) );  /* Scelta del colore di sfondo */
            break;

            case 2:
                color_dialog( cfg, &(cfg->c_snake) );   /* Scelta del colore del serpente */
            break;

            case 3:
                color_dialog( cfg, &(cfg->c_goal) );    /* Scelta del colore dell'obiettivo */
            break;

            case 4:
                color_dialog( cfg, &(cfg->c_wall) );    /* Scelta del colore del muro */
            break;

            case 5:
                color_dialog( cfg, &(cfg->c_gui) ); /* Scelta del colore delle GUI */
            break;

            case 6:
                color_dialog( cfg, &(cfg->c_text) );    /* Scelta del colore del testo */
            break;

            case 7:
                color_dialog( cfg, &(cfg->c_mouse) );   /* Scelta del colore del cursore del mouse */
            break;

            case M_SETTINGSH - 1:   /* Se selezionato indietro */
                return;         /* Esce dalla funzione */
            break;
        }
    }
}

void resolution_menu( struct st_config *cfg )
{
    #define M_RESOLUTIONH 7     /* Altezza e larghezza del menu risoluzione in caratteri (senza contare i bordi) */
    #define M_RESOLUTIONW 12
    #define M_RESOLUTIONT "Seleziona la risoluzione"    /* Titolo del menu della risoluzione */

    int choice;                 /* Voce del menu selezionata */
    int menu_x = ((cfg->resx)-(M_RESOLUTIONW+3)*DE_FONTW)/2;    /* Coordinate dell'angolo in alto a sinistra del menu */
    int menu_y = ((cfg->resy)-(M_RESOLUTIONH+2)*DE_FONTH)/2;

    MENU m_resolution[] = {
    /*  | text       | proc       | child | flag | dp   | */ 
        { "320x240  ", NULL       , NULL  , 0    , NULL },
        { "640x480  ", NULL       , NULL  , 0    , NULL },
        { "800x600  ", NULL       , NULL  , 0    , NULL },
        { "1024x768 ", NULL       , NULL  , 0    , NULL },
        { "1600x1200", NULL       , NULL  , 0    , NULL },
        { ""         , NULL       , NULL  , 0    , NULL },  /* Separatore */
        { "Annulla"  , NULL       , NULL  , 0    , NULL },
        { NULL       , NULL       , NULL  , 0    , NULL }
    };

    reset_screen();             /* Cancella lo schermo */
    text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo */
    textout_centre( screen, font, M_RESOLUTIONT, (cfg->resx)/2, menu_y-DE_FONTH*2, CL_TEXT );   /* Titolo del menu */
    textprintf_centre( screen, font, (cfg->resx)/2, (cfg->resy)-(cfg->cellsize)/2-DE_FONTH/2, CL_TEXT,
                       " Risoluzione corrente: %d x %d ", cfg->resx, cfg->resy );   /* Risoluzione */

    show_mouse( screen );       /* Visualizza il cursore del mouse */
    do {
        choice = do_menu( m_resolution, menu_x, menu_y );   /* Visualizza il menu */
    } while( choice < 0 );      /* Attende un responso valido */
    show_mouse( NULL );         /* Cancella il cursore del mouse */

    switch( choice )            /* In base alla scelta cambia risoluzione */
    {
        case 0:
            cfg->resx = 320;
            cfg->resy = 240;
        break;

        case 1:
            cfg->resx = 640;
            cfg->resy = 480;
        break;

        case 2:
            cfg->resx = 800;
            cfg->resy = 600;
        break;

        case 3:
            cfg->resx = 1024;
            cfg->resy = 768;
        break;

        case 4:
            cfg->resx = 1600;
            cfg->resy = 1200;
        break;

        case M_RESOLUTIONH - 1: /* Se scelto annulla */
            return;             /* Esce */
        break;
    }
    unset_gfx( cfg );
    if( set_gfx( cfg ) != R_OK )    /* Se non riesce a impostare la risoluzione */
    {
        load_config( cfg );     /* Carica la vecchia configurazione */
        set_gfx( cfg );         /* E imposta i vecchi valori */
    }
    reset_colors( cfg );        /* Imposta i colori */
}

int change_red( struct st_config *dp3, int d2 )
{
    (dp3->c_new).r = d2;        /* Aggiorna la componente rossa */
    reset_colors( dp3 );        /* Aggiorna i colori */
    text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo del testo */
    /* Aggiorna il valore visualizzato */
    textprintf( screen, font, (dp3->cellsize)*10-DE_FONTW*3, (dp3->cellsize)*9, CL_TEXT, "%02d", d2 );
    return D_O_K;
}

int change_green( struct st_config *dp3, int d2 )
{
    (dp3->c_new).g = d2;        /* Aggiorna la componente verde */
    reset_colors( dp3 );        /* Aggiorna i colori */
    text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo del testo */
    /* Aggiorna il valore visualizzato */
    textprintf( screen, font, (dp3->cellsize)*10-DE_FONTW*3, (dp3->cellsize)*11, CL_TEXT, "%02d", d2 );
    return D_O_K;
}

int change_blue( struct st_config *dp3, int d2 )
{
    (dp3->c_new).b = d2;        /* Aggiorna la componente blu */
    reset_colors( dp3 );        /* Aggiorna i colori */
    text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo del testo */
    /* Aggiorna il valore visualizzato */
    textprintf( screen, font, (dp3->cellsize)*10-DE_FONTW*3, (dp3->cellsize)*13, CL_TEXT, "%02d", d2 );
    return D_O_K;
}

void color_dialog( struct st_config *cfg, RGB *c_old )
{
    #define CS (cfg->cellsize)  /* Abbreviazione, si potrebbe usare in tutto questo file ma la uso solo qui */
    #define D_COLORT "Componi il colore desiderato" /* Titolo della dialog */
    #define D_COLORS 5  /* Numero di elementi che compongono la dialog */

    DIALOG d_color[] = {
/* proc        | x    | y    | w    | h   | fg    |  bg          | key      |flags|d1 |d2| dp  | dp2         | dp3 */
{ d_slider_proc, CS*10, CS*9 , CS*12, CS  , CL_GUI, CL_BACKGROUND, KEY_R    , 0   , 63, 0, NULL, change_red  , cfg },
{ d_slider_proc, CS*10, CS*11, CS*12, CS  , CL_GUI, CL_BACKGROUND, KEY_V    , 0   , 63, 0, NULL, change_green, cfg },
{ d_slider_proc, CS*10, CS*13, CS*12, CS  , CL_GUI, CL_BACKGROUND, KEY_B    , 0   , 63, 0, NULL, change_blue , cfg },
/* proc        | x    | y    | w    | h   | fg    |  bg          | key      |flags  |d1  |d2  | dp        | dp2 | dp3 */
{ d_button_proc, CS*23, CS*9 , CS*6 , CS*2, CL_GUI, CL_BACKGROUND, KEY_ENTER, D_EXIT, 63 , 0  , "OK"      , NULL, NULL},
{ d_button_proc, CS*23, CS*12, CS*6 , CS*2, CL_GUI, CL_BACKGROUND, KEY_ESC  , D_EXIT, 63 , 0  , "Annulla" , NULL, NULL},
{ NULL         , 0    , 0    , 0    , 0   , 0     , 0            , 0        , 0     , 0  , 0  , NULL      , NULL, NULL}
};
    (cfg->c_new) = (*c_old);    /* Il colore nuovo corrisponde al vecchio */

    set_color( CL_OLD, c_old ); /* Imposta i colori */
    set_color( CL_NEW, &(cfg->c_new) );

    d_color[0].d2 = c_old->r;   /* Imposta le posizioni degli slider */
    d_color[1].d2 = c_old->g;
    d_color[2].d2 = c_old->b;

    reset_screen();             /* Cancella lo schermo */
    text_mode( CL_BACKGROUND ); /* Imposta il colore di sfondo del testo */
    textout_centre( screen, font, D_COLORT, (cfg->resx)/2, CS*8-DE_FONTH, CL_TEXT );    /* Mostra il titolo */
    textprintf( screen, font, CS*10-DE_FONTW*6, CS*9, CL_TEXT, "R: %02d", c_old->r );   /* Mostra i valori RGB */
    textprintf( screen, font, CS*10-DE_FONTW*6, CS*11, CL_TEXT, "V: %02d", c_old->g );
    textprintf( screen, font, CS*10-DE_FONTW*6, CS*13, CL_TEXT, "B: %02d", c_old->b );
    rectfill( screen, CS*11, CS*15, CS*16, CS*20, CL_OLD ); /* Disegna i rettangoli di riscontro */
    rectfill( screen, CS*16, CS*15, CS*21, CS*20, CL_NEW );

    if( do_dialog( d_color, NO_FOCUS ) == D_COLORS - 2 )    /* Se si esce con OK */
        (*c_old) = (cfg->c_new);    /* Viene cambiato il colore */

    reset_colors( cfg );        /* Aggiorna i colori */
}
/* --- Fine di gui.c --- */