# GNUmakefile
.NOTPARALLEL:
.RECIPEPREFIX := _

#=== fix2.sed begins ===
# 1i\
# OFFSET equ\
# Offset equ\
# Ptr equ\
# LEA equ MOV
# /^;/b
# /CODE_SEG/d
# /END /d
# / ENDP/d
# s/[ ][ ]*PROC .*/:/
# s/ES:\[/[ES:/
# s/ DD / DW 0,/
# s/\[0\]$//
# s/40://
# s/,,,*/,/
# s/,\[\([0-9]\)\],\(\[.*\)\]/,\2+\1]/
# s/\],\[/+/
# /INC /s/\[\([0-9]\)\]/+\1/
# /[+]BX/!s/\([ID].C\)[ ][ ]*\([^ ][^ ][^ ][^ ]*\)/\1 [\2]/
#=== fix2.sed ends ===

#=== fix3.sed begins ===
# /RemoveNewInt9:/,/ RET/s/OldInt9Addr/cs:&/
# /NewInt9Handler:/,/NotIntercept:/s/\[/[cs:/
# /NotIntercept:/,/CLC/s/StoreAX/cs:&/
#=== fix3.sed ends ===

#=== vars0.sed begins ===
# /^;/b
# / D[BWD] /b
# /,OFFSET/b
# /LEA /b
# s/ *;.*$//
# s/Word Ptr //
# s/\[[0-9]\],/,&/
# s/\(,.*\)\(\[[0-9]\]\)/,\2\1/
#=== vars0.sed ends ===

.PHONY: all check clean cleanall

#http://exactcode.com/opensource/minised/
#http://dl.exactcode.de/oss/minised/minised-1.15.tar.gz
SED=minised

PROG=inv-fasm
GAMEZIP=invadr11.zip
OLDASM=INVADERS.ASM
FASM=fasm
MD5SUM=md5sum
WGET=wget
WGETOPT=-q
UNZIPPER=unzip
UNZIPFLAGS=-qjan

#GAMEURL=ftp.lanet.lv/ftp/mirror/x2ftp/msdos/programming/gamesrc/
GAMEURL=www.ibiblio.org/pub/micro/pc-stuff/freedos/files/games/invaders/

all: $(PROG).com check

$(PROG).com: $(PROG).asm
_$(FASM) $< $@

fix2.sed fix3.sed vars0.sed: $(lastword $(MAKEFILE_LIST))
_@$(SED) -n -e '/$@ begins ===/,/$@ ends ===/s/^#[ ][ ]*//w $@' $<

vars1.sed: $(OLDASM)
_@$(SED) -n -e '/ D[BWD] /s|^\([^ ][^ ]*\).*|s/,\\(\1\\)$$/,[\\1]/|p' $< >$@

vars2.sed: vars1.sed
_@$(SED) -e 's|^s/,|s/ |' -e 's|\$$/,\[\\1\]/|,/[\\1],/|' $< >$@

$(PROG).asm: vars0.sed vars1.sed vars2.sed fix2.sed fix3.sed $(OLDASM)
_$(SED) -f $(word 1,$^) -f $(word 2,$^) $(lastword $^)\
 | $(SED) -f $(word 1,$^) -f $(word 3,$^)\
 | $(SED) -f $(word 4,$^) -f $(word 5,$^) >$@

$(GAMEZIP):
_@$(WGET) $(WGETOPT) $(GAMEURL)$(GAMEZIP)

$(OLDASM): $(GAMEZIP)
_@$(UNZIPPER) $(UNZIPFLAGS) $< INVADERS/$@ >/dev/null

check: $(PROG).com
_@$(MD5SUM) $<
_@echo 5d6fa26af01606feb90f17e014390139 \ $<

clean:
_@$(RM) $(PROG).asm vars?.sed fix?.sed

cleanall: clean
_@$(RM) $(PROG).com $(OLDASM)

# EOF
